# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class DashboardControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_dashboard_customers_using_post(self, body, dashboard_id, **kwargs):  # noqa: E501
        """addDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard_customers_using_post(body, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: strCustomerIds (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_dashboard_customers_using_post_with_http_info(body, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_dashboard_customers_using_post_with_http_info(body, dashboard_id, **kwargs)  # noqa: E501
            return data

    def add_dashboard_customers_using_post_with_http_info(self, body, dashboard_id, **kwargs):  # noqa: E501
        """addDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard_customers_using_post_with_http_info(body, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: strCustomerIds (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_dashboard_customers_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_dashboard_customers_using_post`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `add_dashboard_customers_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/{dashboardId}/customers/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_dashboard_to_customer_using_post(self, customer_id, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_customer_using_post(customer_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_dashboard_to_customer_using_post_with_http_info(customer_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_dashboard_to_customer_using_post_with_http_info(customer_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def assign_dashboard_to_customer_using_post_with_http_info(self, customer_id, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_customer_using_post_with_http_info(customer_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_dashboard_to_customer_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `assign_dashboard_to_customer_using_post`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `assign_dashboard_to_customer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/customer/{customerId}/dashboard/{dashboardId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_dashboard_to_edge_using_post(self, edge_id, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_edge_using_post(edge_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_dashboard_to_edge_using_post_with_http_info(edge_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_dashboard_to_edge_using_post_with_http_info(edge_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def assign_dashboard_to_edge_using_post_with_http_info(self, edge_id, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_edge_using_post_with_http_info(edge_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_dashboard_to_edge_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `assign_dashboard_to_edge_using_post`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `assign_dashboard_to_edge_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/dashboard/{dashboardId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_dashboard_to_public_customer_using_post(self, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToPublicCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_public_customer_using_post(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_dashboard_to_public_customer_using_post_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_dashboard_to_public_customer_using_post_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def assign_dashboard_to_public_customer_using_post_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """assignDashboardToPublicCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_dashboard_to_public_customer_using_post_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_dashboard_to_public_customer_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `assign_dashboard_to_public_customer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/customer/public/dashboard/{dashboardId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dashboard_using_delete(self, dashboard_id, **kwargs):  # noqa: E501
        """deleteDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_using_delete(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboard_using_delete_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboard_using_delete_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboard_using_delete_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """deleteDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_using_delete_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboard_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboard_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/{dashboardId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_dashboards_using_get(self, customer_id, page_size, page, **kwargs):  # noqa: E501
        """getCustomerDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_dashboards_using_get(customer_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param bool mobile: mobile
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_dashboards_using_get_with_http_info(customer_id, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_dashboards_using_get_with_http_info(customer_id, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_customer_dashboards_using_get_with_http_info(self, customer_id, page_size, page, **kwargs):  # noqa: E501
        """getCustomerDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_dashboards_using_get_with_http_info(customer_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param bool mobile: mobile
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'page_size', 'page', 'mobile', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_dashboards_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_dashboards_using_get`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_customer_dashboards_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_customer_dashboards_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'mobile' in params:
            query_params.append(('mobile', params['mobile']))  # noqa: E501
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/customer/{customerId}/dashboards{?mobile,textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_by_id_using_get(self, dashboard_id, **kwargs):  # noqa: E501
        """getDashboardById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_by_id_using_get(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_by_id_using_get_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_by_id_using_get_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboard_by_id_using_get_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """getDashboardById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_by_id_using_get_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboard_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/{dashboardId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_info_by_id_using_get(self, dashboard_id, **kwargs):  # noqa: E501
        """getDashboardInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_info_by_id_using_get(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: DashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_info_by_id_using_get_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_info_by_id_using_get_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboard_info_by_id_using_get_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """getDashboardInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_info_by_id_using_get_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: DashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_info_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboard_info_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/info/{dashboardId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_dashboards_using_get(self, edge_id, page_size, page, **kwargs):  # noqa: E501
        """getEdgeDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_dashboards_using_get(edge_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :param int start_time: startTime
        :param int end_time: endTime
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_dashboards_using_get_with_http_info(edge_id, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_dashboards_using_get_with_http_info(edge_id, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_edge_dashboards_using_get_with_http_info(self, edge_id, page_size, page, **kwargs):  # noqa: E501
        """getEdgeDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_dashboards_using_get_with_http_info(edge_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :param int start_time: startTime
        :param int end_time: endTime
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'page_size', 'page', 'text_search', 'sort_property', 'sort_order', 'start_time', 'end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_dashboards_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_edge_dashboards_using_get`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_edge_dashboards_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_edge_dashboards_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/dashboards{?textSearch,sortProperty,sortOrder,startTime,endTime,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_home_dashboard_info_using_get(self, **kwargs):  # noqa: E501
        """getHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_home_dashboard_info_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_home_dashboard_info_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_home_dashboard_info_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_home_dashboard_info_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_home_dashboard_info_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_home_dashboard_info_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/home/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HomeDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_home_dashboard_using_get(self, **kwargs):  # noqa: E501
        """getHomeDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_home_dashboard_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_home_dashboard_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_home_dashboard_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_home_dashboard_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getHomeDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_home_dashboard_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_home_dashboard_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/home', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HomeDashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_max_datapoints_limit_using_get(self, **kwargs):  # noqa: E501
        """getMaxDatapointsLimit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_max_datapoints_limit_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_max_datapoints_limit_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_max_datapoints_limit_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_max_datapoints_limit_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getMaxDatapointsLimit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_max_datapoints_limit_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_max_datapoints_limit_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/maxDatapointsLimit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_server_time_using_get(self, **kwargs):  # noqa: E501
        """getServerTime  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_time_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_server_time_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_server_time_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_server_time_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getServerTime  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_time_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_time_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/serverTime', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_dashboards_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_dashboards_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param bool mobile: mobile
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_dashboards_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_dashboards_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_tenant_dashboards_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getTenantDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_dashboards_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param bool mobile: mobile
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'mobile', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_dashboards_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_tenant_dashboards_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_tenant_dashboards_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'mobile' in params:
            query_params.append(('mobile', params['mobile']))  # noqa: E501
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenant/dashboards{?mobile,textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_dashboards_using_get1(self, tenant_id, page_size, page, **kwargs):  # noqa: E501
        """getTenantDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_dashboards_using_get1(tenant_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_id: tenantId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_dashboards_using_get1_with_http_info(tenant_id, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_dashboards_using_get1_with_http_info(tenant_id, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_tenant_dashboards_using_get1_with_http_info(self, tenant_id, page_size, page, **kwargs):  # noqa: E501
        """getTenantDashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_dashboards_using_get1_with_http_info(tenant_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_id: tenantId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_id', 'page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_dashboards_using_get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if ('tenant_id' not in params or
                params['tenant_id'] is None):
            raise ValueError("Missing the required parameter `tenant_id` when calling `get_tenant_dashboards_using_get1`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_tenant_dashboards_using_get1`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_tenant_dashboards_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in params:
            path_params['tenantId'] = params['tenant_id']  # noqa: E501

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenant/{tenantId}/dashboards{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tenant_home_dashboard_info_using_get(self, **kwargs):  # noqa: E501
        """getTenantHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_home_dashboard_info_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tenant_home_dashboard_info_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tenant_home_dashboard_info_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tenant_home_dashboard_info_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getTenantHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tenant_home_dashboard_info_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HomeDashboardInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tenant_home_dashboard_info_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenant/dashboard/home/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HomeDashboardInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_dashboard_customers_using_post(self, body, dashboard_id, **kwargs):  # noqa: E501
        """removeDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_dashboard_customers_using_post(body, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: strCustomerIds (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_dashboard_customers_using_post_with_http_info(body, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_dashboard_customers_using_post_with_http_info(body, dashboard_id, **kwargs)  # noqa: E501
            return data

    def remove_dashboard_customers_using_post_with_http_info(self, body, dashboard_id, **kwargs):  # noqa: E501
        """removeDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_dashboard_customers_using_post_with_http_info(body, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: strCustomerIds (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_dashboard_customers_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_dashboard_customers_using_post`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `remove_dashboard_customers_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/{dashboardId}/customers/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_dashboard_using_post(self, body, **kwargs):  # noqa: E501
        """saveDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_dashboard_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dashboard body: dashboard (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_dashboard_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_dashboard_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_dashboard_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveDashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_dashboard_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dashboard body: dashboard (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_dashboard_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_dashboard_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_tenant_home_dashboard_info_using_post(self, body, **kwargs):  # noqa: E501
        """setTenantHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_tenant_home_dashboard_info_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HomeDashboardInfo body: homeDashboardInfo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_tenant_home_dashboard_info_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_tenant_home_dashboard_info_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def set_tenant_home_dashboard_info_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """setTenantHomeDashboardInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_tenant_home_dashboard_info_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HomeDashboardInfo body: homeDashboardInfo (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_tenant_home_dashboard_info_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_tenant_home_dashboard_info_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/tenant/dashboard/home/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unassign_dashboard_from_customer_using_delete(self, customer_id, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_customer_using_delete(customer_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unassign_dashboard_from_customer_using_delete_with_http_info(customer_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unassign_dashboard_from_customer_using_delete_with_http_info(customer_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def unassign_dashboard_from_customer_using_delete_with_http_info(self, customer_id, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_customer_using_delete_with_http_info(customer_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unassign_dashboard_from_customer_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `unassign_dashboard_from_customer_using_delete`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `unassign_dashboard_from_customer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/customer/{customerId}/dashboard/{dashboardId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unassign_dashboard_from_edge_using_delete(self, edge_id, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_edge_using_delete(edge_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unassign_dashboard_from_edge_using_delete_with_http_info(edge_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unassign_dashboard_from_edge_using_delete_with_http_info(edge_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def unassign_dashboard_from_edge_using_delete_with_http_info(self, edge_id, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_edge_using_delete_with_http_info(edge_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unassign_dashboard_from_edge_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `unassign_dashboard_from_edge_using_delete`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `unassign_dashboard_from_edge_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/dashboard/{dashboardId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unassign_dashboard_from_public_customer_using_delete(self, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromPublicCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_public_customer_using_delete(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unassign_dashboard_from_public_customer_using_delete_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unassign_dashboard_from_public_customer_using_delete_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def unassign_dashboard_from_public_customer_using_delete_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """unassignDashboardFromPublicCustomer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_dashboard_from_public_customer_using_delete_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unassign_dashboard_from_public_customer_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `unassign_dashboard_from_public_customer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/customer/public/dashboard/{dashboardId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dashboard_customers_using_post(self, dashboard_id, **kwargs):  # noqa: E501
        """updateDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard_customers_using_post(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :param list[str] body: strCustomerIds
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dashboard_customers_using_post_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dashboard_customers_using_post_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def update_dashboard_customers_using_post_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501
        """updateDashboardCustomers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dashboard_customers_using_post_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: dashboardId (required)
        :param list[str] body: strCustomerIds
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dashboard_customers_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params or
                params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `update_dashboard_customers_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboardId'] = params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/dashboard/{dashboardId}/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dashboard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
