mecab_tags_en = {
    "NNG": "General Noun",
    "NNP": "Proper Noun",
    "NNB": "General Dependent Noun",
    "NNBC": "Unit Word",
    "NR": "Number Word",
    "NP": "Pronoun",
    "VV": "Verb",
    "VA": "Adjetive",
    "VAX": "Derived Adjetive",
    "VX": "Auxiliary Predicate",
    "VCP": "Positive Copula",
    "VCN": "Negative Copula",
    "MM": "Determiner",
    "MAG": "Adverb",
    "MAJ": "Conjunctive Adverb",
    "IC": "Exclamaation",
    "JKS": "Case Postposition (Nominative)",
    "JKC": "Case Postposition (Complementive)",
    "JKG": "Case Postposition (Determinative)",
    "JKO": "Case Postposition (Objective)",
    "JKB": "Adverbial Postposition",
    "JKV": "Case Postposition (Vocative)",
    "JKQ": "Case Postposition (Quotation)",
    "JC": "Conjunctive Postposition",
    "JX": "Auxiliary Postposition",
    "EP": "Prefinal Ending",
    "EF": "Final Ending",
    "EC": "Conjunctive Ending",
    "ETN": "Nominal Ending",
    "ETM": "Adnominal Ending",
    "XPN": "Noun Prefix",
    "XSN": "Noun Suffix",
    "XSV": "Verbalization Suffix",
    "XSA": "Adjectivization Suffix",
    "XR": "Root Word",
    "SF": "Sentence Ending Marker",
    "SE": "Ellipsis Symbol",
    "SSO": "Left Quotation Mark",
    "SSC": "Right Quotation Mark",
    "SC": "Separator Symbol",
    "SY": "Symbol",
    "SH": "Chinese Charachter",
    "SL": "Foreign Word",
    "SN": "Number",
}
mecab_tags = {
    "NNG": "일반 명사",
    "NNP": "고유 명사",
    "NNB": "의존 명사",
    "NNBC": "단위를 나타내는 명사",
    "NR": "수사",
    "NP": "대명사",
    "VV": "동사",
    "VA": "형용사",
    "VAX": "파생형용사",
    "VX": "보조 용언",
    "VCP": "긍정 지정사",
    "VCN": "부정 지정사",
    "MM": "관형사",
    "MAG": "일반 부사",
    "MAJ": "접속 부사",
    "IC": "감탄사",
    "JKS": "주격 조사",
    "JKC": "보격 조사",
    "JKG": "관형격 조사",
    "JKO": "목적격 조사",
    "JKB": "부사격 조사",
    "JKV": "호격 조사",
    "JKQ": "인용격 조사",
    "JC": "접속 조사",
    "JX": "보조사",
    "EP": "선어말어미",
    "EF": "종결 어미",
    "EC": "연결 어미",
    "ETN": "명사형 전성 어미",
    "ETM": "관형형 전성 어미",
    "XPN": "체언 접두사",
    "XSN": "명사파생 접미사",
    "XSV": "동사 파생 접미사",
    "XSA": "형용사 파생 접미사",
    "XR": "어근",
    "SF": "마침표, 물음표, 느낌표",
    "SE": "줄임표 …",
    "SSO": "여는 괄호 (, [",
    "SSC": "닫는 괄호 ), ]",
    "SC": "구분자 , · / :",
    "SY": "기타 기호",
    "SH": "한자",
    "SL": "외국어",
    "SN": "숫자",
}
# 'NNX': '파생 명사',
# SL: (?<=\n)[A-Za-z\s-\d]+\n
nouns_tags = {"NNG", "NNP", "UNKNOWN"}
topic_tags = {"NNG"}
stop_tags = {"SY", "SF", "SN", "SH", "SSO", "SSC", "SC", "SE"}
sent_tags = {"MAG", "NNG", "XR", "VV", "VA", "VVX", "VAX", "VX", "VCN", "XSV", "VCP"}
skip_tags = {"SC", "SN", "SY", "SSO", "SSC"}
lemma_tags = {"VV", "VX", "XSV", "VCN", "VA", "MAG", "VAX"}
aux_tags = {"VX", "VCP", "VCN"}

pass_tags = {("EC", "NNG")}

xsav_tags = {
    # ('NNG', 'VCP'): 'VVX',
    # ('NNG', 'XSV'): 'VVX',
    ("XR", "XSV"): "VVX",
    # ('NNG', 'XSA'): 'VAX',
    ("XR", "XSA"): "VAX",
}

xsn_sfx_tag = ("NNG", "XSN")

suffix_tags = {
    # 'VAX': {'적'},
    # 'NNG': ('감', '권', '계', '력', '률', '별', '분', '성', '용', '율', '자', '치', '화', '형'),
    "NNG": {"권", "화", "형"},
    "NNBC": {"당"},
}
# 'NNX': ('상'),

skip_chk_tags = {
    ("MM", "SC", "NNG", "SC", "NR"): "NNG",
    ("NNG", "SC", "NNG"): "NNG",
    ("NNG", "SN", "NNG"): "NNG",
    ("NNG", "SN", "NNG"): "NNG",
    ("NNG", "SN", "NNBC"): "NNG",
    ("NNG", "SN", "NNBC", "NNG"): "NNG",
    ("NNG", "SY", "NNBC", "JX"): "NNG",
    ("NNG", "SY", "NNG"): "NNG",
    ("NNG", "SY", "NNG", "XSN"): "NNG",
    ("SL", "SC", "NNG"): "NNG",
    ("SL", "SY", "NNG"): "NNG",
    ("SL", "SC", "SL"): "NNG",
    ("SL", "SY", "SL"): "NNG",
    ("SN", "NNBC", "NNG"): "NNG",
    ("SN", "NNBC", "VV"): "NNG",
    ("SSO", "NNG", "SSC"): "NNG",
    ("SSO", "SL", "SSC"): "NNG",
}

chk_tags = {
    ("EC", "NNG", "NNG"): "NNG",
    ("EC", "NNG", "XSN"): "NNG",
    ("EC", "XPN", "NNG"): "NNG",
    ("EP", "VV", "ETN"): "NNG",
    ("EP", "VV", "ETN", "NNG"): "NNG",
    ("IC", "IC"): "NNG",
    ("IC", "NNG"): "NNG",
    ("IC", "NNG", "SL"): "NNG",
    ("IC", "NNG", "NNG"): "NNG",
    ("IC", "NNG", "NNG", "NNG"): "NNG",
    ("IC", "NNG", "NNG", "XSN"): "NNG",
    ("IC", "NNG", "NNG", "NNG", "NNG"): "NNG",
    ("IC", "NR", "NNBC"): "NNG",
    ("IC", "VV", "EC", "NNG"): "NNG",
    ("JC", "NR"): "NNG",
    ("JKG", "NNG"): "NNG",
    ("JKS", "NNG"): "NNG",
    ("JKS", "NNG", "NNG"): "NNG",
    ("JKS", "NNG", "VCP"): "NNG",
    ("JKS", "VV"): "NNG",
    ("JKS", "XPN"): "NNG",
    ("JX", "ETN"): "NNG",
    ("JX", "NNG"): "NNG",
    ("JX", "NNG", "XSN"): "NNG",
    ("MAG", "NR"): "NNG",
    ("MAG", "MAG"): "NNG",
    ("MAG", "MAG", "VV"): "NNG",
    ("MAG", "NNG"): "NNG",
    ("MAJ", "MAG", "IC"): "NNG",
    ("MAJ", "MAG", "NNG"): "NNG",
    ("MM", "IC", "NNG"): "NNG",
    ("MM", "IC", "MAG", "NNG"): "NNG",
    ("MM", "IC", "NNG", "NNG"): "NNG",
    ("MM", "IC", "NNG", "XSN"): "NNG",
    ("MM", "IC", "NNG", "NNG", "NNG"): "NNG",
    ("MM", "IC", "XPN", "XR", "XSN"): "NNG",
    ("MM", "MM", "NNG"): "NNG",
    ("MM", "NNBC", "NNG"): "NNG",
    ("MM", "NNG"): "NNG",
    ("MM", "NNG", "JC", "NNG"): "NNG",
    ("MM", "NNG", "NNG"): "NNG",
    ("MM", "NNG", "NNG", "JKB"): "NNG",
    ("MM", "NNG", "NNG", "XSN"): "NNG",
    ("MM", "NNG", "NNG", "NNG"): "NNG",
    ("MM", "NNG", "NNG", "NNG", "NNG"): "NNG",
    ("MM", "NNG", "XSN"): "NNG",
    ("MM", "NNG", "XSN", "SN", "NNG"): "NNG",
    ("NNB", "MAG", "VV"): "NNG",
    ("NNB", "NNG"): "NNG",
    ("NNB", "NNG", "XSN"): "NNG",
    ("NNB", "NNG", "JKS", "NNG"): "NNG",
    ("NNB", "VCP"): "NNG",
    ("NNB", "VCP", "NNG"): "NNG",
    ("NNB", "VV"): "NNG",
    ("NNBC", "MAG", "VV"): "NNG",
    ("NNBC", "MM", "NNG"): "NNG",
    ("NNBC", "NNG"): "NNG",
    ("NNBC", "NR", "NNG"): "NNG",
    ("NNBC", "NR", "NNG", "NNG"): "NNG",
    ("NNBC", "VA", "NNG"): "NNG",
    ("NNBC", "VV", "NNG"): "NNG",
    ("NNG", "IC"): "NNG",
    ("NNG", "IC", "MAG"): "NNG",
    ("NNG", "IC", "MAG", "NNG"): "NNG",
    ("NNG", "IC", "MM", "NNG"): "NNG",
    ("NNG", "IC", "NNG"): "NNG",
    ("NNG", "IC", "NNG", "NNG"): "NNG",
    ("NNG", "JC"): "NNG",
    ("NNG", "JC", "IC"): "NNG",
    ("NNG", "JC", "NNG"): "NNG",
    ("NNG", "JKB"): "NNG",
    ("NNG", "JKB", "MM", "NNG"): "NNG",
    ("NNG", "JKB", "NNG"): "NNG",
    ("NNG", "JKB", "NNG", "NNG"): "NNG",
    ("NNG", "JKB", "NNG", "XSN", "NNG"): "NNG",
    ("NNG", "JKB", "NP"): "NNG",
    ("NNG", "JKB", "NR", "NNG"): "NNG",
    ("NNG", "JKB", "NR", "NNG", "NNG"): "NNG",
    ("NNG", "JKB", "VA", "NNG"): "NNG",
    ("NNG", "JKB", "VV"): "NNG",
    ("NNG", "JKB", "VV", "EC"): "NNG",
    ("NNG", "JKB", "VV", "XSN", "XSN"): "NNG",
    ("NNG", "JKC"): "NNG",
    ("NNG", "JKC", "VV"): "NNG",
    ("NNG", "JKG"): "NNG",
    ("NNG", "JKG", "NNG"): "NNG",
    ("NNG", "JKS", "NNG", "NNG"): "NNG",
    ("NNG", "JKO"): "NNG",
    ("NNG", "JKS"): "NNG",
    ("NNG", "JKS", "NNG"): "NNG",
    ("NNG", "JKS", "VV"): "NNG",
    ("NNG", "JKS", "VV", "EC", "NNG"): "NNG",
    ("NNG", "JKS", "VV", "EC", "NNG", "XSN"): "NNG",
    ("NNG", "JKS", "VV", "EC", "XPN"): "NNG",
    ("NNG", "JKS", "VV", "EC", "XPN", "NNG"): "NNG",
    ("NNG", "JKS", "XPN"): "NNG",
    ("NNG", "JX"): "NNG",
    ("NNG", "JX", "NNG"): "NNG",
    ("NNG", "JX", "NNG", "NNG"): "NNG",
    ("NNG", "JX", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "MAG"): "NNG",
    ("NNG", "MAG", "IC"): "NNG",
    ("NNG", "MAG", "MAG"): "NNG",
    ("NNG", "MAG", "MM", "NNG"): "NNG",
    ("NNG", "MAG", "NNG"): "NNG",
    ("NNG", "MAG", "NNG", "IC"): "NNG",
    ("NNG", "MAG", "NNG", "NNG"): "NNG",
    ("NNG", "MAG", "VA", "NNG"): "NNG",
    ("NNG", "MAG", "VV"): "NNG",
    ("NNG", "MAG", "VV", "IC"): "NNG",
    ("NNG", "MAG", "VV", "NNG"): "NNG",
    ("NNG", "MAG", "VV", "VV"): "NNG",
    ("NNG", "MAG", "NNG", "VV"): "NNG",
    ("NNG", "MM"): "NNG",
    ("NNG", "MM", "NNG"): "NNG",
    ("NNG", "MM", "NNG", "NNG"): "NNG",
    ("NNG", "NNB"): "NNG",
    ("NNG", "NNB", "JKC", "VV", "EC"): "NNG",
    ("NNG", "NNB", "JKC", "VV", "EC", "NNG"): "NNG",
    ("NNG", "NNB", "NNG"): "NNG",
    ("NNG", "NNB", "NNG", "XSN"): "NNG",
    ("NNG", "NNB", "VCP", "NNG", "NNG"): "NNG",
    ("NNG", "NNB", "XPN", "NNG"): "NNG",
    ("NNG", "NNBC"): "NNG",
    ("NNG", "NNBC", "IC"): "NNG",
    ("NNG", "NNBC", "NNG"): "NNG",
    ("NNG", "NNBC", "NR", "NNG"): "NNG",
    ("NNG", "NNBC", "VV"): "NNG",
    ("NNG", "NNG"): "NNG",
    ("NNG", "NNG", "EC"): "NNG",
    ("NNG", "NNG", "IC"): "NNG",
    ("NNG", "NNG", "IC", "NNG", "NNG"): "NNG",
    ("NNG", "NNG", "JC"): "NNG",
    ("NNG", "NNG", "JKB"): "NNG",
    ("NNG", "NNG", "JKB", "NNG"): "NNG",
    ("NNG", "NNG", "JKB", "NNG", "NNG"): "NNG",
    ("NNG", "NNG", "JKG"): "NNG",
    ("NNG", "NNG", "JKG", "NNG"): "NNG",
    ("NNG", "NNG", "JKO"): "NNG",
    ("NNG", "NNG", "JKS", "NNG"): "NNG",
    ("NNG", "NNG", "JX"): "NNG",
    ("NNG", "NNG", "JX", "MM"): "NNG",
    ("NNG", "NNG", "JX", "NNG"): "NNG",
    ("NNG", "NNG", "MAG"): "NNG",
    ("NNG", "NNG", "MAG", "NNG"): "NNG",
    ("NNG", "NNG", "MM", "NNG"): "NNG",
    ("NNG", "NNG", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "JKS", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "MM", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "NNB"): "NNG",
    ("NNG", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "NP"): "NNG",
    ("NNG", "NNG", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "XSN"): "NNG",
    ("NNG", "NNG", "NNG", "XSN", "NNG"): "NNG",
    ("NNG", "NNG", "NNG", "XSN", "VV"): "NNG",
    ("NNG", "NNG", "NR"): "NNG",
    ("NNG", "NNG", "VA", "IC"): "NNG",
    ("NNG", "NNG", "VA", "NNG"): "NNG",
    ("NNG", "NNG", "VCP", "EC"): "NNG",
    ("NNG", "NNG", "VCP", "NNG"): "NNG",
    ("NNG", "NNG", "VCP", "VA", "NNG"): "NNG",
    ("NNG", "NNG", "VV"): "NNG",
    ("NNG", "NNG", "VV", "NNG"): "NNG",
    ("NNG", "NNG", "XSN"): "NNG",
    ("NNG", "NNG", "XSN", "IC"): "NNG",
    ("NNG", "NNG", "XSN", "NNG"): "NNG",
    ("NNG", "NNG", "XSN", "VV"): "NNG",
    ("NNG", "NNG", "XSN", "XSN"): "NNG",
    ("NNG", "NNG", "XSV"): "NNG",
    ("NNG", "NP"): "NNG",
    ("NNG", "NP", "XSN", "NNG"): "NNG",
    ("NNG", "NR"): "NNG",
    ("NNG", "NR", "NNBC"): "NNG",
    ("NNG", "NR", "NNG"): "NNG",
    ("NNG", "NR", "NR", "NNBC"): "NNG",
    ("NNG", "NR", "VV"): "NNG",
    ("NNG", "SL"): "NNG",
    ("NNG", "SL", "NNG"): "NNG",
    ("NNG", "SL", "SN"): "NNG",
    ("NNG", "SN", "NNG"): "NNG",
    ("NNG", "SY", "SN"): "NNG",
    ("NNG", "VCP"): "NNG",
    ("NNG", "VCP", "EC"): "NNG",
    ("NNG", "VCP", "EC", "NNG"): "NNG",
    ("NNG", "VCP", "NNG"): "NNG",
    ("NNG", "VCP", "NNG", "NNG"): "NNG",
    ("NNG", "VCP", "VX", "NNG", "NNG"): "NNG",
    ("NNG", "VCP", "VX", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "VV"): "NNG",
    ("NNG", "VV", "EC"): "NNG",
    ("NNG", "VV", "EC", "NNG"): "NNG",
    ("NNG", "VV", "EC", "VX"): "NNG",
    ("NNG", "VV", "EC", "VX", "NNG"): "NNG",
    ("NNG", "VV", "EC", "VX", "NNG", "NNG"): "NNG",
    ("NNG", "VV", "EF"): "NNG",
    ("NNG", "VV", "EF", "NNG"): "NNG",
    ("NNG", "VV", "EP", "NNG"): "NNG",
    ("NNG", "VV", "JX", "NNG"): "NNG",
    ("NNG", "VV", "NNB"): "NNG",
    ("NNG", "VV", "NNG"): "NNG",
    ("NNG", "VV", "NNG", "NNG"): "NNG",
    ("NNG", "VV", "XPN", "NR"): "NNG",
    ("NNG", "VX", "EC", "NNG"): "NNG",
    ("NNG", "XPN"): "NNG",
    ("NNG", "XPN", "NNG"): "NNG",
    ("NNG", "XPN", "NNG", "NNG"): "NNG",
    ("NNG", "XSA"): "NNG",
    ("NNG", "XSN"): "NNG",
    ("NNG", "XSN", "XPN"): "NNG",
    ("NNG", "XSN", "JC"): "NNG",
    ("NNG", "XSN", "MM"): "NNG",
    ("NNG", "XSN", "JC", "NNG"): "NNG",
    ("NNG", "XSN", "JKB", "MM", "NNG"): "NNG",
    ("NNG", "XSN", "JKB", "NNG"): "NNG",
    ("NNG", "XSN", "MAG", "NNG"): "NNG",
    ("NNG", "XSN", "MM", "NNG"): "NNG",
    ("NNG", "XSN", "MM", "NNG", "NNG"): "NNG",
    ("NNG", "XSN", "NNBC", "VA", "NNG"): "NNG",
    ("NNG", "XSN", "NNG"): "NNG",
    ("NNG", "XSN", "NNG", "JKG"): "NNG",
    ("NNG", "XSN", "NNG", "NNG"): "NNG",
    ("NNG", "XSN", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "XSN", "NNG", "XSN"): "NNG",
    ("NNG", "XSN", "XSN"): "NNG",
    ("NNG", "XSV"): "NNG",
    ("NNG", "XSV", "EC"): "NNG",
    ("NNG", "XSV", "IC"): "NNG",
    ("NNG", "XSV", "MM", "NNG"): "NNG",
    ("NNG", "XSV", "MM", "NNG", "NNG"): "NNG",
    ("NNG", "XSV", "NNG"): "NNG",
    ("NNG", "XSV", "NNG", "NNG"): "NNG",
    ("NNG", "XSV", "NNG", "NNG", "NNG"): "NNG",
    ("NNG", "XSV", "NNG", "NNG", "XSN"): "NNG",
    ("NNG", "XSV", "VCP"): "NNG",
    ("NNG", "XSV", "VCP", "NNG"): "NNG",
    ("NP", "EC"): "NNG",
    ("NP", "EC", "NNG"): "NNG",
    ("NP", "IC", "NNG"): "NNG",
    ("NP", "JKB", "NNG"): "NNG",
    ("NP", "JKB", "NNG", "NNG"): "NNG",
    ("NP", "JKB", "NNG", "NNG", "NNG"): "NNG",
    ("NP", "JKB", "NNG", "NNG", "NNG", "NP"): "NNG",
    ("NP", "NNG"): "NNG",
    ("NP", "NNG", "NNG"): "NNG",
    ("NP", "XSN"): "NNG",
    ("NP", "VCP", "MM", "NNG"): "NNG",
    ("NP", "VV", "NNG"): "NNG",
    ("NR", "NNBC"): "NNG",
    ("NR", "NNBC", "NNB", "NNG"): "NNG",
    ("NR", "NNBC", "NNG"): "NNG",
    ("NR", "NNG"): "NNG",
    ("NR", "NNG", "NNG"): "NNG",
    ("NR", "NNG", "NNG", "NNG"): "NNG",
    ("NR", "NNG", "VCP"): "NNG",
    ("NR", "VCP"): "NNG",
    ("SL", "NNG"): "NNG",
    ("SL", "NNG", "NNG"): "NNG",
    ("SL", "NNG", "NNG", "NNG"): "NNG",
    ("SL", "NNG", "SL"): "NNG",
    ("SL", "SC", "SL"): "NNG",
    ("SL", "SL"): "SL",
    ("SL", "SN"): "SL",
    ("SL", "SN", "NNG"): "NNG",
    ("SL", "SY", "NNG"): "NNG",
    ("SL", "SY", "SL"): "NNG",
    ("SL", "XSN", "VCP", "NNG", "NNG"): "NNG",
    ("SN", "NNBC", "NNG"): "NNG",
    ("SN", "NNG"): "NNG",
    ("SN", "SY", "NNG"): "NNG",
    ("SSO", "NNG", "SSC"): "NNG",
    ("NNG", "SSO", "NNG", "SSC"): "NNG",
    ("NNG", "SSO", "SL", "SSC"): "NNG",
    ("NNG", "SSO", "SL", "SSC", "SL"): "NNG",
    ("NNG", "SSO", "NNG", "SSC", "NNG"): "NNG",
    ("SSO", "NNG", "SSC", "NNG"): "NNG",
    ("SSO", "SL", "SSC", "NNG"): "NNG",
    ("VA", "NNG"): "NNG",
    ("VA", "NNG", "VV", "EC"): "NNG",
    ("VCP", "EC"): "NNG",
    ("VCP", "EC", "NNG"): "NNG",
    ("VCP", "EC", "NNG", "NNG"): "NNG",
    ("VCP", "NNG"): "NNG",
    ("VCP", "NNG", "XSN"): "NNG",
    ("VV", "EC"): "NNG",
    ("VV", "EC", "NNG"): "NNG",
    ("VV", "EC", "NNG", "XSN"): "NNG",
    ("VV", "EC", "VX", "NNG"): "NNG",
    ("VV", "EP"): "NNG",
    ("VV", "ETN", "VA"): "VA",
    ("VV", "IC"): "NNG",
    ("VV", "IC", "NNG"): "NNG",
    ("VV", "MAG"): "NNG",
    ("VV", "NNB"): "NNG",
    ("VV", "NNG"): "NNG",
    ("VV", "NNG", "NNG"): "NNG",
    ("VV", "NNG", "NNG", "XSN"): "NNG",
    ("VV", "NNG", "VCP"): "NNG",
    ("VV", "NP", "NNG", "NNG", "NNG"): "NNG",
    ("VV", "VV"): "NNG",
    ("VV", "XPN", "NR"): "NNG",
    ("VX", "EC", "NNG"): "NNG",
    ("VX", "NNG"): "NNG",
    ("VX", "NNG", "XSN"): "NNG",
    ("XPN", "MAG"): "NNG",
    ("XPN", "NNG"): "NNG",
    ("XPN", "NNG", "MAG"): "NNG",
    ("XPN", "NNG", "NNG"): "NNG",
    ("XPN", "NNG", "NNG", "XSA", "NNG"): "NNG",
    ("XPN", "NNG", "XSN"): "NNG",
    ("XPN", "XR"): "NNG",
    ("XPN", "XR", "XSN"): "NNG",
    ("XR", "NNG"): "NNG",
    ("XSA", "ETM"): "NNG",
    ("XSN", "JC"): "NNG",
    ("XSN", "MAG"): "NNG",
    ("XSN", "MM"): "NNG",
    ("XSN", "NNG"): "NNG",
    ("XSN", "VCP", "NNG", "NNG"): "NNG",
    ("XSN", "VCP", "EC"): "NNG",
    ("XSV", "IC"): "NNG",
    ("XSV", "IC", "NNG"): "NNG",
    ("XSV", "NNG", "NNG"): "NNG",
}
