/*
 [The "BSD licence"]
 Copyright (c) 2013 Tom Everett
 All rights reserved.
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.
 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

parser grammar HTMLParser;

options { tokenVocab=HTMLLexer; }

// Template bits

templateTag
    : openTag=TEMPLATE_TAG_OPEN templateContent+ closeTag=TEMPLATE_TAG_CLOSE
    ;

templateComment
    : TEMPLATE_COMMENT_OPEN htmlContent TEMPLATE_COMMENT_CLOSE
    ;

templateVariable
    : TEMPLATE_VARIABLE_OPEN templateContent+ TEMPLATE_TAG_CLOSE
    ;

templateContent
    : TEMPLATE_CONTENT
    ;


// HTML

htmlDocument
    : (scriptlet | templateTag | templateComment | templateVariable | SEA_WS)* xml? (scriptlet | templateTag | templateComment | templateVariable | SEA_WS)* dtd? (scriptlet | templateTag | templateComment | templateVariable | SEA_WS)* htmlElements*
    ;

htmlElements
    : htmlMisc* htmlElement htmlMisc*
    ;

htmlElement
    : TAG_OPEN htmlTagName htmlAttribute* TAG_CLOSE htmlContent TAG_OPEN TAG_SLASH htmlTagName TAG_CLOSE  # Tag
    | TAG_OPEN htmlTagName htmlAttribute* TAG_SLASH_CLOSE # SelfClosingTag
    | TAG_OPEN htmlTagName htmlAttribute* TAG_CLOSE # SelfClosingTag
    | scriptlet # RawTag
    | script # dummy
    | style # RawTag
    | templateTag # dummy
    | templateComment # dummy
    | templateVariable # dummy
    ;

htmlContent
    : htmlChardata? ((htmlElement | xhtmlCDATA | htmlComment) htmlChardata?)*
    ;

htmlAttribute
    : htmlAttributeName TAG_EQUALS htmlAttributeValue
    | htmlAttributeName
    ;

htmlAttributeName
    : TAG_NAME
    ;

htmlAttributeValue
    : ATTVALUE_VALUE
    ;

htmlTagName
    : TAG_NAME
    ;

htmlChardata
    : HTML_TEXT
    | SEA_WS
    ;

htmlMisc
    : htmlComment
    | SEA_WS
    ;

htmlComment
    : HTML_COMMENT
    | HTML_CONDITIONAL_COMMENT
    ;

xhtmlCDATA
    : CDATA
    ;

dtd
    : DTD
    ;

xml
    : XML_DECLARATION
    ;

scriptlet
    : SCRIPTLET
    ;

script
    : SCRIPT_OPEN htmlAttribute* TAG_CLOSE scriptBody
    ;

scriptBody
    : SCRIPT_BODY
    | SCRIPT_SHORT_BODY
    ;

style
    : STYLE_OPEN htmlAttribute* TAG_CLOSE styleBody
    ;

styleBody
    : STYLE_BODY
    | STYLE_SHORT_BODY
    ;
