#!/usr/bin/env python
# coding: utf-8

# WARNING: this file is automatically generated, changes will be overwritten
import os
import sys
import logging
logger = logging.getLogger()
if "ipykernel_launcher" not in sys.argv[0]:
  logger.warning("get_ipython() CALLS WILL RETURN '' (empty)")
  class get_ipython():
    @classmethod
    def system(one,two=None,three=None,four=None):
      return os.system(two)
    @classmethod
    def run_cell_magic(one,two=None,three=None,four=None):
      return ''
    @classmethod
    def getoutput(one,two):
      return ''
    @classmethod
    def run_line_magic(one,two,three):
      return ''
# rel: https://docs.python.org/3/library/argparse.html
# rel: https://docs.python.org/3/library/inspect.html
def argparse_from_signature(function_name, parser):
  '''uses a function signature to create argparse arguments'''
  for param,val in inspect.signature(function_name).parameters.items():
    argpd = {}
    choices = list(typing.get_args(val.annotation))
    # auto-convert float and int from cmdline
    if val.annotation==int: argpd['type']=int
    elif val.annotation==float: argpd['type']=float
    elif len(choices)>0:
      argpd['choices']=choices
    # set any defaults we know of from the signature
    if val.default!=val.empty: 
      argpd['default']=val.default
      argpd['help']='(default: %(default)s)'

    if 'variadic' in val.kind.description: argpd['nargs']='*' #variadic keyword|positional
    # if positional *and* no default then do "required" logic
    if 'positional' in val.kind.description and val.default==val.empty: parser.add_argument(val.name,**argpd)
    else: parser.add_argument('-'+val.name[0].lower(), '--'+val.name.lower(), **argpd)
  return parser

def setup_cmdline_args():
  '''automatic command line arg system using `config_dict()` 
  kwargs must be named "kwargs" to parse'''
  global c

  parser = argparse.ArgumentParser(
    description=__doc__+'\n(abbreviations e.g., --abbr: ON)',
    # width for Jupyter, avoid one word per line
    formatter_class=lambda prog: argparse.RawTextHelpFormatter(prog, width=79)
  )
  parser = argparse_from_signature(config_dict, parser)
  # caps to avoid collisions
  rdefault = 0 if '-R' in str(sys.argv) else 2
  vdefault = 0 if '-V' in str(sys.argv) else 5
  parser.add_argument('-R', '--runlevel', action='count', default=rdefault, help='repeatable, -RRR is runlevel=3 default:%(default)s')
  parser.add_argument('-V', '--verbose', action='count', default=vdefault, help='repeatable, -VVVVV is verbosity=5 default:%(default)s (1:critical,2:error,3:warning,4:info,5:debug)')
  parser.add_argument("-v", "--version", action="version",version = f"{parser.prog} version 1.0.0")
  
  args = vars(parser.parse_args())
  # keyword arg fun! split : and = delimited list items into a dict, works with JSON input
  if 'kwargs' in args and args['kwargs'] != None:
    eq2 = [i.replace(':','=') for i in args['kwargs']]
    args=dict(**args, **dict(i.split('=') for i in eq2))
    # del args['kwargs']
  c = config_dict(**args) # run args through usual config_dict: win.
  return c
def get_json_for_python_export():
  activenb = _message.blocking_request('get_ipynb', request='', timeout_sec=5)['ipynb']
  activenb['cells'] = activenb['cells']
  out_cells = []
  collecting = True
  for cell in activenb['cells']:
    if cell['cell_type']=='markdown' and cell['source'][0][0]=='#' and cell['source'][0][1]!='#' and cell['source'][0].replace('#','').strip() not in skip_headers:
      print('Collecting cells under header:',cell['source'][0])
      collecting = True
    if cell['cell_type']=='markdown' and cell['source'][0][0]=='#' and cell['source'][0][1]!='#' and cell['source'][0].replace('#','').strip() in skip_headers:
      print('Skipping cells under header:',cell['source'][0])
      collecting = False
    if collecting == True:
      out_cells.append(cell)
  activenb['cells']=out_cells
  return activenb
# get_active_notebook_json()


# # Feature
# Data2Data: Convert data to a different type or structure.
# 
# 

# ## Motivation
# Python and various libs like Pandas excel at working with data but remembering/looking up all the paramaters and writing repetitive snippets is not efficient.

# # Imports

# In[1]:


# %%from_template first_cell
if 'c' not in globals():
  get_ipython().system('pip install nbf')
  from nbf import epc
  c = epc.do_setup({'resources':{'nbf':{}}, 'keyring':'bit.ly/3QPP1bs'})
  get_ipython().run_line_magic('run', "{c.get('nb_dir')}notebooks_as_features.ipynb")
  logger = epc.get_logger(c.get('nb_name'))
else: 
  get_ipython().system("cd {c['project_path']} && git pull")


# In[2]:


import os
import sys
import json
from google.colab import _message


# In[3]:


# c


# # Structure

# In[4]:


no_upper = 'a|an|and|as|at|but|by|en|for|if|in|of|on|or|the|to|v|via|vs|so'
skip_headers = ['Examples','EOF','Usage','Tests']


# # Functions

# In[5]:


def text2title(text:str)->str:
  '''comprehensive title capitalization, will preserve ACK-ronyms if in caps and
   not in the list of always-lowercase words'''
  text = text.replace('_',' ').replace('-',' ')
  title = ' '.join([x[0].upper()+x[1:] if x.lower() not in no_upper.split('|') else x.lower() for x in text.split()])
  return title

def nb_name2module_name(nb_name):
  mod_remove = no_upper+'|notebook|with|is'
  nb_name = nb_name.replace('_',' ').replace('-',' ').lower()
  return ' '.join([word for word in nb_name.split(' ') if word not in mod_remove.split('|')]).replace(' ','')

def get_json_for_python_export():
  activenb = _message.blocking_request('get_ipynb', request='', timeout_sec=5)['ipynb']
  activenb['cells'] = activenb['cells']
  out_cells = []
  collecting = True
  for cell in activenb['cells']:
    if cell['cell_type']=='markdown' and cell['source'][0][0]=='#' and cell['source'][0][1]!='#' and cell['source'][0].replace('#','').strip() not in skip_headers:
      print('Collecting cells under header:',cell['source'][0])
      collecting = True
    if cell['cell_type']=='markdown' and cell['source'][0][0]=='#' and cell['source'][0][1]!='#' and cell['source'][0].replace('#','').strip() in skip_headers:
      print('Skipping cells under header:',cell['source'][0])
      collecting = False
    if collecting == True:
      out_cells.append(cell)
  activenb['cells']=out_cells
  return activenb

def nb2ipynb(nb_json=None):
  '''active notebook to `c[nb_dir]{c[running_nb]}.ipynb`'''
  out_name = c['nb_dir']+c['running_nb']+'.ipynb'
  print(out_name)
  if nb_json==None:
    nb_json = _message.blocking_request('get_ipynb', request='', timeout_sec=5)['ipynb']
  with open(out_name, 'w') as nb_file:
    nb_file.write(json.dumps(nb_json,indent=2))
  get_ipython().system('ls -la {out_name}')

def nb2py_prepend(module_path):
  with open(c['nb_dir']+'/templates/nb2py_prepend','r') as fnullipy:
    prepend = fnullipy.read()
  with open(module_path, 'r') as original: data = original.read()
  paragraphs = data.split('\n')
  paragraphs.insert(2, '\n'+prepend)
  data = '\n'.join(paragraphs)
  # print(data)
  with open(module_path,'w') as prepended:
    prepended.write(data)

def nb2py(nb_name:str=None):
  if nb_name==None:
    nb_name = c['running_nb']
    nb2ipynb(get_json_for_python_export())
  module_name = nb_name2module_name(nb_name)+'.py'
  get_ipython().system("mkdir -p {c['project_path']}{c['active_project']}")
  module_path = f"{c['project_path']}{c['active_project']}/{module_name}"
  command = f"jupyter nbconvert --to python --output-dir {c['project_path']}{c['active_project']} --output {module_name} {c['nb_dir']}{nb_name}.ipynb"
  get_ipython().system('{command}')
  print(command)
  nb2py_prepend(module_path)
  

