from sator_core.models.vulnerability import VulnerabilityLocator

from sator_core.use_cases.resolution.metadata.vulnerability import VulnerabilityMetadataResolution
from sator_core.use_cases.resolution.references.vulnerability import VulnerabilityReferencesResolution
from sator_core.use_cases.annotation.attributes.vulnerability import VulnerabilityAttributesAnnotation
from sator_core.use_cases.extraction.attributes.vulnerability import VulnerabilityAttributesExtraction
from sator_core.use_cases.analysis.attributes.vulnerability import VulnerabilityAttributesAnalysis


class VulnerabilityProcessingService:
    def __init__(
            self, vulnerability_annotation: VulnerabilityAttributesAnnotation,
            vulnerability_extraction: VulnerabilityAttributesExtraction,
            vulnerability_analysis: VulnerabilityAttributesAnalysis,
            vulnerability_metadata: VulnerabilityMetadataResolution,
            vulnerability_references: VulnerabilityReferencesResolution
    ):
        self.vulnerability_metadata = vulnerability_metadata
        self.vulnerability_references = vulnerability_references
        self.vulnerability_annotation = vulnerability_annotation
        self.vulnerability_extraction = vulnerability_extraction
        self.vulnerability_analysis = vulnerability_analysis

    # TODO: should return something that assembles all the information
    def process_vulnerability(self, vulnerability_id: str) -> VulnerabilityLocator | None:
        metadata = self.vulnerability_metadata.resolve_vulnerability_metadata(vulnerability_id)

        if metadata:
            print(metadata)
            description = self.vulnerability_metadata.resolve_vulnerability_description(vulnerability_id)
            print(description)
            references = self.vulnerability_references.search_vulnerability_references(vulnerability_id)
            print(references)
            attributes = self.vulnerability_extraction.extract_vulnerability_attributes(vulnerability_id)

            if attributes:
                print(attributes)
                annotation = self.vulnerability_annotation.annotate_vulnerability_attributes(vulnerability_id)
                print(annotation)
                locator = self.vulnerability_analysis.analyze_vulnerability_attributes(vulnerability_id)
                print(locator)
                return locator

        return None
