"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Template = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const match_1 = require("./match");
const matcher_1 = require("./matcher");
const mappings_1 = require("./private/mappings");
const outputs_1 = require("./private/outputs");
const resources_1 = require("./private/resources");
const assert = require("./vendored/assert");
/**
 * (experimental) Suite of assertions that can be run on a CDK stack.
 *
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 *
 * @experimental
 */
class Template {
    constructor(template) {
        this.template = template;
        this.inspector = new assert.StackInspector(template);
    }
    /**
     * (experimental) Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @experimental
     */
    static fromStack(stack) {
        return new Template(toTemplate(stack));
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as an in-memory JSON object.
     *
     * @param template the CloudFormation template formatted as a nested set of records.
     * @experimental
     */
    static fromJSON(template) {
        return new Template(template);
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a JSON string.
     *
     * @param template the CloudFormation template in.
     * @experimental
     */
    static fromString(template) {
        return new Template(JSON.parse(template));
    }
    /**
     * (experimental) The CloudFormation template deserialized into an object.
     *
     * @experimental
     */
    toJSON() {
        return this.template;
    }
    /**
     * (experimental) Assert that the given number of resources of the given type exist in the template.
     *
     * @param type the resource type;
     * @param count number of expected instances.
     * @experimental
     */
    resourceCountIs(type, count) {
        const assertion = assert.countResources(type, count);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that a resource of the given type and properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the `Properties` key of the resource, via the
     * `Match.objectLike()`. To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the 'Properties' section of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceProperties(type, props) {
        this.hasResource(type, match_1.Match.objectLike({
            Properties: matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props),
        }));
    }
    /**
     * (experimental) Assert that a resource of the given type and given definition exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the entire defintion of the resource as should be expected in the template.
     * @experimental
     */
    hasResource(type, props) {
        const matchError = resources_1.hasResource(this.inspector, type, props);
        if (matchError) {
            throw new Error(matchError);
        }
    }
    /**
     * (experimental) Get the set of matching resources of a given type and properties in the CloudFormation template.
     *
     * @param type the type to match in the CloudFormation template.
     * @param props by default, matches all resources with the given type.
     * @experimental
     */
    findResources(type, props = {}) {
        return resources_1.findResources(this.inspector, type, props);
    }
    /**
     * (experimental) Assert that an Output with the given properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param props the output as should be expected in the template.
     * @experimental
     */
    hasOutput(props) {
        const matchError = outputs_1.hasOutput(this.inspector, props);
        if (matchError) {
            throw new Error(matchError);
        }
    }
    /**
     * (experimental) Get the set of matching Outputs that match the given properties in the CloudFormation template.
     *
     * @param props by default, matches all Outputs in the template.
     * @experimental
     */
    findOutputs(props = {}) {
        return outputs_1.findOutputs(this.inspector, props);
    }
    /**
     * (experimental) Assert that a Mapping with the given properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param props the output as should be expected in the template.
     * @experimental
     */
    hasMapping(props) {
        const matchError = mappings_1.hasMapping(this.inspector, props);
        if (matchError) {
            throw new Error(matchError);
        }
    }
    /**
     * (experimental) Get the set of matching Mappings that match the given properties in the CloudFormation template.
     *
     * @param props by default, matches all Mappings in the template.
     * @experimental
     */
    findMappings(props = {}) {
        return mappings_1.findMappings(this.inspector, props);
    }
    /**
     * (experimental) Assert that the CloudFormation template matches the given value.
     *
     * @param expected the expected CloudFormation template as key-value pairs.
     * @experimental
     */
    templateMatches(expected) {
        const assertion = assert.matchTemplate(expected);
        assertion.assertOrThrow(this.inspector);
    }
}
exports.Template = Template;
_a = JSII_RTTI_SYMBOL_1;
Template[_a] = { fqn: "@aws-cdk/assertions.Template", version: "1.120.0" };
function toTemplate(stack) {
    const root = stack.node.root;
    if (!core_1.Stage.isStage(root)) {
        throw new Error('unexpected: all stacks must be part of a Stage or an App');
    }
    const assembly = root.synth();
    return assembly.getStackArtifact(stack.artifactId).template;
}
//# sourceMappingURL=data:application/json;base64,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