"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasResource = exports.findResources = void 0;
const section_1 = require("./section");
function findResources(inspector, type, props = {}) {
    const section = inspector.value.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (!result.match) {
        return [];
    }
    return result.matches;
}
exports.findResources = findResources;
function hasResource(inspector, type, props) {
    const section = inspector.value.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    return [
        `Template has ${result.analyzedCount} resources with type ${type}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasResource = hasResource;
function filterType(section, type) {
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([_, v]) => v.Type === type)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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