#!/usr/bin/env python
# -*- coding: ascii -*-
# This Python Source Code Generated by XYmath

import numpy as np

def cd_nasa_1973( RupThroat ):
    '''
    Curve Fit Results from XYmath 10/09/2020
    Can be called with RupThroat=float or RupThroat=numpy array

    y = 1 - 1/(A + B*RupThroat + C*RupThroat**2)
        A = 13.530364611338884
        B = 37.78243120843655
        C = 45.34290951287185
        RupThroat = xData
        y = yData
        Correlation Coefficient = 0.9997030386550787
        Standard Deviation = 0.00018312181218106436
        Percent Standard Deviation = 0.018462994708524635%
    y = 1 - 1/(13.530364611338884 + 37.78243120843655*RupThroat + 45.34290951287185*RupThroat**2)

     (RupThroat,y) Data Pairs from 10/09/2020 Used in Curve Fit 
     (RupThroat,y) = (0.399126,0.972184),(0.536856,0.978487),(0.698,0.98381),
        (0.87154,0.987593),(1.05748,0.990674),(1.20071,0.992075),
        (1.34946,0.993476),(1.52878,0.994316),(1.69543,0.995157),
        (1.85107,0.995577),(2.00395,0.995997)

    '''
    try:
        if RupThroat<0.399126 or RupThroat>2.00395:
            print( 'WARNING... RupThroat is outside range in cd_nasa_1973' )
            print( '  RupThroat =',RupThroat,' RupThroat range = (0.399126 to 2.00395)' )
    except:
        if np.min(RupThroat)<0.399126 or np.max(RupThroat)>2.00395:
            print( 'WARNING... RupThroat is outside range in cd_nasa_1973' )
            print( '  RupThroat =',RupThroat,' RupThroat range = (0.399126 to 2.00395)' )
    
    return 1 - 1/(13.530364611338884 + 37.78243120843655*RupThroat + 45.34290951287185*RupThroat**2)

if __name__=='__main__':
    print( '='*44 )
    y_test = cd_nasa_1973( 2.00395 )
    print( 'y_test  =',y_test,'for Rup_test =',2.00395 )
    print( 'y_xymath=',0.9963144949260845 )
    print( )
    print( 'y_test should equal y_xymath above.' )

