"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UisNode = exports.UisNodeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const uis_generated_1 = require("./uis.generated");
Object.defineProperty(exports, "UisNodeProperty", { enumerable: true, get: function () { return uis_generated_1.RosUisNode; } });
/**
 * A ROS resource type:  `ALIYUN::UIS::UisNode`
 */
class UisNode extends ros.Resource {
    /**
     * Create a new `ALIYUN::UIS::UisNode`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUisNode = new uis_generated_1.RosUisNode(this, id, {
            description: props.description,
            uisId: props.uisId,
            ipAddrsNum: props.ipAddrsNum ? props.ipAddrsNum : 2,
            uisNodeBandwidth: props.uisNodeBandwidth ? props.uisNodeBandwidth : 20,
            uisNodeAreaId: props.uisNodeAreaId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUisNode;
        this.attrUisNodeActiveIps = rosUisNode.attrUisNodeActiveIps;
        this.attrUisNodeId = rosUisNode.attrUisNodeId;
        this.attrUisNodeIps = rosUisNode.attrUisNodeIps;
    }
}
exports.UisNode = UisNode;
//# sourceMappingURL=data:application/json;base64,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