"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UisConnection = exports.UisConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const uis_generated_1 = require("./uis.generated");
Object.defineProperty(exports, "UisConnectionProperty", { enumerable: true, get: function () { return uis_generated_1.RosUisConnection; } });
/**
 * A ROS resource type:  `ALIYUN::UIS::UisConnection`
 */
class UisConnection extends ros.Resource {
    /**
     * Create a new `ALIYUN::UIS::UisConnection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUisConnection = new uis_generated_1.RosUisConnection(this, id, {
            sslConfig: props.sslConfig,
            description: props.description,
            greConfig: props.greConfig,
            uisProtocol: props.uisProtocol ? props.uisProtocol : 'SSLVPN',
            uisNodeId: props.uisNodeId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUisConnection;
        this.attrUisConnectionId = rosUisConnection.attrUisConnectionId;
    }
}
exports.UisConnection = UisConnection;
//# sourceMappingURL=data:application/json;base64,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