import io
from PIL import Image
from pathlib import Path
from typing import Any, List, NamedTuple, Tuple

Frame = Tuple[int, int, int, str, int]
Frames = List[Frame]
Color = Tuple[int, int, int, int]

class XCursor:
    config_file: Path
    prefix: Path
    out_dir: Path
    out: Path
    def __init__(self, config_file: Path, out_dir: Path) -> None: ...
    def gen_argv_ctypes(self, argv: List[str]) -> Any: ...
    def generate(self) -> None: ...
    @classmethod
    def create(cls: Any, alias_file: Path, out_dir: Path) -> Path: ...

class AnicursorgenArgs(NamedTuple):
    add_shadows: bool = ...
    blur: float = ...
    color: Color = ...
    down_shift: float = ...
    right_shift: float = ...

class WindowsCursor:
    args: AnicursorgenArgs
    config_file: Path
    prefix: Path
    out_dir: Path
    out: Path
    def __init__(self, config_dir: Path, out_dir: Path, args: AnicursorgenArgs) -> None: ...
    def get_frames(self) -> Frames: ...
    @staticmethod
    def frames_have_animation(frames: Frames) -> bool: ...
    @staticmethod
    def make_framesets(frames: Frames) -> Frames: ...
    @staticmethod
    def copy_to(out: io.BufferedWriter, buf: io.BytesIO) -> None: ...
    def make_ani(self, frames: Frames, out_buffer: io.BufferedWriter) -> None: ...
    @staticmethod
    def shadowize(shadow: Image, orig: Image, color: Color) -> None: ...
    def create_shadow(self, orig: Image) -> Tuple[int, Any]: ...
    @staticmethod
    def write_png(out: io.BufferedWriter, frame_png: Image) -> None: ...
    @staticmethod
    def write_cur(out: io.BufferedWriter, frame: Frame, frame_png: Image) -> None: ...
    def make_cur(self, frames: Frames, animated: bool=...) -> io.BytesIO: ...
    def generate(self) -> None: ...
    @classmethod
    def create(cls: Any, alias_file: Path, out_dir: Path, args: Any=...) -> Path: ...
