import { ClusterProps, FargateTaskDefinitionProps } from 'aws-cdk-lib/aws-ecs';
import { Construct } from 'constructs';
export interface KongEcsDataPlaneProps {
    /**
     * @summary Define ClusterProps for ECS cluster
     */
    readonly clusterProps: ClusterProps;
    /**
     * @summary PrivateCA Arn to use to generate certificates
     */
    readonly privateCaArn: string;
    /**
     * @summary ECS Task properties
     */
    readonly kongTaskProps: FargateTaskDefinitionProps;
    /**
     * @summary Cluster DNS to connect to control plane
     */
    readonly clusterDns: string;
    /**
     * @summary Telemetry DNS
     */
    readonly telemetryDns: string;
    /**
     * @summary If Data plane is internet facing
     */
    readonly internetFacing?: boolean;
    /**
     * @summary Kong image with tag
     */
    readonly image?: string;
    /**
     * @summary Name of the Secret in AWS Secrets Manager
     */
    readonly licenseSecret?: string;
    readonly desiredCount: number;
}
export declare class KongEcs extends Construct {
    constructor(scope: Construct, id: string, props: KongEcsDataPlaneProps);
}
