// Copyright (c) Mito
import React from 'react';
import '../../../css/elements/DropdownItem.css';
import { classNames } from '../../utils/classNames';
import { DROPDOWN_IGNORE_CLICK_CLASS } from './Dropdown';
/**
 * The DropdownItem component is used to populate the Dropdown component.
 */
const DropdownItem = (props) => {
    const disabled = props.disabled === true;
    const hideSubtext = props.hideSubtext === true;
    const displaySubtextOnHover = props.displaySubtextOnHover === true;
    return (React.createElement("div", { className: classNames('mito-dropdown-item', { [DROPDOWN_IGNORE_CLICK_CLASS]: disabled }, props.className), onClick: !disabled ? props.onClick : undefined, title: props.tooltip },
        React.createElement("div", { className: classNames('mito-dropdown-item-icon-and-title-container') },
            React.createElement("div", { className: classNames('mito-dropdown-item-icon-container') }, props.icon),
            React.createElement("span", { title: props.tooltip || props.title },
                React.createElement("p", { className: classNames('text-body-2', 'text-overflow-hide', 'cursor-default', { 'mito-dropdown-item-title-disabled': disabled }) }, props.title))),
        props.subtext &&
            /*
                If hideSubtext is true, then we only want to display the subtext if displaySubtextOnHover is true and the
                DropdownItem is hovered over
            */
            React.createElement("div", { className: classNames('mito-dropdown-item-subtext-container', 'text-subtext-1', { 'mito-dropdown-item-subtext-disabled': disabled }, { 'mito-dropdown-item-display-subtext-on-hover': hideSubtext && displaySubtextOnHover }) }, props.subtext)));
};
export default DropdownItem;
//# sourceMappingURL=DropdownItem.js.map