# LangGraph Log Parser
[![wakatime](https://wakatime.com/badge/user/c88d1b82-ebdd-4842-ad45-93f471842103/project/b6d31f0d-340f-42d5-aa2d-bf3e2e6a0370.svg)](https://wakatime.com/badge/user/c88d1b82-ebdd-4842-ad45-93f471842103/project/b6d31f0d-340f-42d5-aa2d-bf3e2e6a0370)

### Download package
```dotenv
pip install langgraph_log_parser
```

### Documentation
Documentation is available at: https://serafinski.github.io/LangGraph-Log-Parser/

# Purpose
This Python package facilitates the parsing of run logs generated by [LangGraph](https://langchain-ai.github.io/langgraph/). During execution, logs are stored in an SQLite database in an encoded format _(using msgpack)_. These logs are then decoded and exported to a `json` format. Subsequently, the `json` files are transformed into `csv` files for further analysis.

Once in `csv` format, the data can be analyzed using methods from the [py4pm](https://processintelligence.solutions/static/api/2.7.11/index.html) library. These methods calculate specific statistics related to the multi-agent infrastructure's performance and enable visualizations of the process behavior and execution flow.

This pipeline provides a streamlined approach for extracting, transforming, and analyzing logs, offering valuable insights into multi-agent systems.