"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpJwtAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpJwtAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b;
        if (!this.authorizer) {
            const id = this.props.authorizerName && !core_1.Token.isUnresolved(this.props.authorizerName) ?
                this.props.authorizerName : 'JwtAuthorizer';
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName,
                jwtAudience: this.props.jwtAudience,
                jwtIssuer: this.props.jwtIssuer,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpJwtAuthorizer = HttpJwtAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpJwtAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpJwtAuthorizer", version: "1.129.0" };
//# sourceMappingURL=data:application/json;base64,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