#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.obj',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20201227',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Convenience facilities for objects.',
  long_description =
    ('Convenience facilities for objects.\n'    
 '\n'    
 '*Latest release 20201227*:\n'    
 'SingletonMixin: correctly invoke __new__, a surprisingly fiddly task to get '    
 'right.\n'    
 '\n'    
 '## Function `as_dict(o, selector=None)`\n'    
 '\n'    
 'Return a dictionary with keys mapping to the values of the attributes of '    
 '`o`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `o`: the object to map\n'    
 '* `selector`: the optional selection criterion\n'    
 '\n'    
 'If `selector` is omitted or `None`, select "public" attributes,\n'    
 'those not commencing with an underscore.\n'    
 '\n'    
 'If `selector` is a `str`, select attributes starting with `selector`.\n'    
 '\n'    
 'Otherwise presume `selector` is callable\n'    
 'and select attributes `attr` where `selector(attr)` is true.\n'    
 '\n'    
 '## Function `copy(obj, *a, **kw)`\n'    
 '\n'    
 'Convenient function to shallow copy an object with simple modifications.\n'    
 '\n'    
 'Performs a shallow copy of `self` using copy.copy.\n'    
 '\n'    
 'Treat all positional parameters as attribute names, and\n'    
 'replace those attributes with shallow copies of the original\n'    
 'attribute.\n'    
 '\n'    
 'Treat all keyword arguments as (attribute,value) tuples and\n'    
 'replace those attributes with the supplied values.\n'    
 '\n'    
 '## Function `flavour(obj)`\n'    
 '\n'    
 "Return constants indicating the ``flavour'' of an object:\n"    
 '* `T_MAP`: DictType, DictionaryType, objects with an __keys__ or keys '    
 'attribute.\n'    
 '* `T_SEQ`: TupleType, ListType, objects with an __iter__ attribute.\n'    
 '* `T_SCALAR`: Anything else.\n'    
 '\n'    
 '## Class `O(types.SimpleNamespace)`\n'    
 '\n'    
 'The `O` class is now obsolete, please subclass `types.SimpleNamespace`.\n'    
 '\n'    
 '## Function `O_attritems(o)`\n'    
 '\n'    
 'Generator yielding `(attr,value)` for relevant attributes of `o`.\n'    
 '\n'    
 '## Function `O_attrs(o)`\n'    
 '\n'    
 'Yield attribute names from `o` which are pertinent to `O_str`.\n'    
 '\n'    
 'Note: this calls `getattr(o,attr)` to inspect it in order to\n'    
 'prune callables.\n'    
 '\n'    
 '## Function `O_merge(o, _conflict=None, _overwrite=False, **kw)`\n'    
 '\n'    
 'Merge key:value pairs from a mapping into an object.\n'    
 '\n'    
 'Ignore keys that do not start with a letter.\n'    
 'New attributes or attributes whose values compare equal are\n'    
 'merged in. Unequal values are passed to:\n'    
 '\n'    
 '    _conflict(o, attr, old_value, new_value)\n'    
 '\n'    
 'to resolve the conflict. If _conflict is omitted or None\n'    
 'then the new value overwrites the old if _overwrite is true.\n'    
 '\n'    
 '## Function `O_str(o, no_recurse=False, seen=None)`\n'    
 '\n'    
 'Return a `str` representation of the object `o`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `o`: the object to describe.\n'    
 "* `no_recurse`: if true, do not recurse into the object's structure.\n"    
 '  Default: `False`.\n'    
 '* `seen`: a set of previously sighted objects\n'    
 '  to prevent recursion loops.\n'    
 '\n'    
 '## Function `obj_as_dict(*args, **kwargs)`\n'    
 '\n'    
 'OBSOLETE convesion of an object to a `dict`. Please us `cs.obj.as_dict`.\n'    
 '\n'    
 '## Class `Proxy`\n'    
 '\n'    
 'An extremely simple proxy object\n'    
 'that passes all unmatched attribute accesses to the proxied object.\n'    
 '\n'    
 'Note that setattr and delattr work directly on the proxy, not the proxied '    
 'object.\n'    
 '\n'    
 '## Function `singleton(registry, key, factory, fargs, fkwargs)`\n'    
 '\n'    
 'Obtain an object for `key` via `registry` (a mapping of `key`=>object).\n'    
 'Return `(is_new,object)`.\n'    
 '\n'    
 'If the `key` exists in the registry, return the associated object.\n'    
 'Otherwise create a new object by calling `factory(*fargs,**fkwargs)`\n'    
 'and store it as `key` in the `registry`.\n'    
 '\n'    
 'The `registry` may be any mapping of `key`s to objects\n'    
 'but will usually be a `weakref.WeakValueDictionary`\n'    
 'in order that object references expire as normal,\n'    
 'allowing garbage collection.\n'    
 '\n'    
 '*Note*: this function *is not* thread safe.\n'    
 'Multithreaded users should hold a mutex.\n'    
 '\n'    
 'See the `SingletonMixin` class for a simple mixin to create\n'    
 'singleton classes,\n'    
 'which does provide thread safe operations.\n'    
 '\n'    
 '## Class `SingletonMixin`\n'    
 '\n'    
 'A mixin turning a subclass into a singleton factory.\n'    
 '\n'    
 '*Note*: this mixin overrides `object.__new__`\n'    
 'and may not play well with other classes which oeverride `__new__`.\n'    
 '\n'    
 '*Warning*: because of the mechanics of `__new__`,\n'    
 "the instance's `__init__` method will always be called\n"    
 'after `__new__`,\n'    
 'even when a preexisting object is returned.\n'    
 'Therefore that method should be sensible\n'    
 'even for an already initialised\n'    
 'and probably subsequently modified object.\n'    
 '\n'    
 'One approach might be to access some attribute,\n'    
 'and preemptively return if it already exists.\n'    
 'Example:\n'    
 '\n'    
 '    def __init__(self, x, y):\n'    
 "        if hasattr(self, 'x'):\n"    
 '            return\n'    
 '        self.x = x\n'    
 '        self.y = y\n'    
 '\n'    
 '*Note*: each class registry has a lock,\n'    
 'which ensures that reuse of an object\n'    
 'in multiple threads will call the `__init__` method\n'    
 'in a thread safe serialised fashion.\n'    
 '\n'    
 'Implementation requirements:\n'    
 'a subclass should:\n'    
 '* provide a method `_singleton_key(*args,**kwargs)`\n'    
 '  returning a key for use in the single registry,\n'    
 '  computed from the positional and keyword arguments\n'    
 '  supplied on instance creation\n'    
 '  i.e. those which `__init__` would normally receive.\n'    
 '  This should have the same signature as `__init__`\n'    
 '  but using `cls` instead of `self`.\n'    
 '* provide a normal `__init__` method\n'    
 '  which can be safely called again\n'    
 '  after some earlier initialisation.\n'    
 '\n'    
 'This class is thread safe for the registry operations.\n'    
 '\n'    
 'Example:\n'    
 '\n'    
 '    class Pool(SingletonMixin):\n'    
 '\n'    
 '        @staticmethod\n'    
 '        def _singleton_key(foo, bah=3):\n'    
 '            return foo, bah\n'    
 '\n'    
 '        def __init__(self, foo, bah=3):\n'    
 "            if hasattr(self, 'foo'):\n"    
 '                return\n'    
 '           ... normal __init__ stuff here ...\n'    
 '           self.foo = foo\n'    
 '           ...\n'    
 '\n'    
 '## Class `TrackedClassMixin`\n'    
 '\n'    
 'A mixin to track all instances of a particular class.\n'    
 '\n'    
 'This is aimed at checking the global state of objects of a\n'    
 'particular type, particularly states like counters. The\n'    
 'tracking is attached to the class itself.\n'    
 '\n'    
 'The class to be tracked includes this mixin as a superclass and calls:\n'    
 '\n'    
 '    TrackedClassMixin.__init__(class_to_track)\n'    
 '\n'    
 'from its __init__ method. Note that `class_to_track` is\n'    
 'typically the class name itself, not `type(self)` which would\n'    
 'track the specific subclass. At some relevant point one can call:\n'    
 '\n'    
 '    self.tcm_dump(class_to_track[, file])\n'    
 '\n'    
 '`class_to_track` needs a `tcm_get_state` method to return the\n'    
 'salient information, such as this from cs.resources.MultiOpenMixin:\n'    
 '\n'    
 '    def tcm_get_state(self):\n'    
 "        return {'opened': self.opened, 'opens': self._opens}\n"    
 '\n'    
 'See cs.resources.MultiOpenMixin for example use.\n'    
 '\n'    
 '### Method `TrackedClassMixin.tcm_all_state(klass)`\n'    
 '\n'    
 'Generator yielding tracking information\n'    
 'for objects of type `klass`\n'    
 'in the form `(o,state)`\n'    
 'where `o` if a tracked object\n'    
 "and `state` is the object's `get_tcm_state` method result.\n"    
 '\n'    
 '### Method `TrackedClassMixin.tcm_dump(klass, f=None)`\n'    
 '\n'    
 'Dump the tracking information for `klass` to the file `f`\n'    
 '(default `sys.stderr`).\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20201227*:\n'    
 'SingletonMixin: correctly invoke __new__, a surprisingly fiddly task to get '    
 'right.\n'    
 '\n'    
 '*Release 20201021*:\n'    
 '* @OBSOLETE(obj_as_dict), recommend "as_dict()".\n'    
 '* [BREAKING] change as_dict() to accept a single optional selector instead '    
 'of various mutually exclusive keywords.\n'    
 '\n'    
 '*Release 20200716*:\n'    
 'SingletonMixin: no longer require special _singleton_init method, reuse '    
 'default __init__ implicitly through __new__ mechanics.\n'    
 '\n'    
 '*Release 20200517*:\n'    
 'Documentation improvements.\n'    
 '\n'    
 '*Release 20200318*:\n'    
 '* Replace obsolete O class with a new subclass of SimpleNamespace which '    
 'issues a warning.\n'    
 '* New singleton() generic factory function and SingletonMixin mixin class '    
 'for making singleton classes.\n'    
 '\n'    
 '*Release 20190103*:\n'    
 '* New mixin class TrackedClassMixin to track all instances of a particular '    
 'class.\n'    
 '* Documentation updates.\n'    
 '\n'    
 '*Release 20170904*:\n'    
 'Minor cleanups.\n'    
 '\n'    
 '*Release 20160828*:\n'    
 '* Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '* Minor tweaks.\n'    
 '\n'    
 '*Release 20150118*:\n'    
 'move long_description into cs/README-obj.rst\n'    
 '\n'    
 '*Release 20150110*:\n'    
 'cleaned out some old junk, readied metadata for PyPI'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.deco', 'cs.py3'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.obj'],
)
