[![CI](https://github.com/fhswf/MLPro/actions/workflows/ci.yml/badge.svg)](https://github.com/fhswf/MLPro/actions/workflows/ci.yml)
[![Documentation Status](https://readthedocs.org/projects/mlpro/badge/?version=latest)](https://mlpro.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/mlpro.svg)](https://badge.fury.io/py/mlpro)
[![PyPI Total Downloads](https://static.pepy.tech/personalized-badge/mlpro?period=total&units=international_system&left_color=blue&right_color=orange&left_text=PyPI%20Total%20Downloads)](https://pepy.tech/project/mlpro)
[![PyPI Last Month Downloads](https://static.pepy.tech/personalized-badge/mlpro?period=month&units=international_system&left_color=blue&right_color=orange&left_text=PyPI%20Last%20Month%20Downloads)](https://pepy.tech/project/mlpro)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6653484.svg)](https://doi.org/10.5281/zenodo.6653484)

<img src="https://github.com/fhswf/MLPro/blob/main/doc/logo/original/logo.png?raw=True" align="right" width="40%"/>

# MLPro - The integrative middleware framework for standardized machine learning in Python
MLPro is a modular, open-source middleware framework for standardized machine learning tasks in Python. It seamlessly integrates reinforcement learning, game theory, and online learning into flexible, recombinable workflows. With its rigorous design, scientific validity, and ready-to-use process models, MLPro accelerates research, development, and education. Whether for hybrid ML applications or real-time adaptive systems, MLPro is the right choice due to its transparency, reusability, and professional quality.

## Key Features

#### a) Open, modular, and extensible architecture
- Overarching software infrastructure (mathematics, data management and plotting, UI framework, logging, ...)
- Fundamental ML classes for adaptive models and their training and hyperparameter tuning

#### b) Growing number of dedicated sub-frameworks
- **MLPro-BF:** Powerful substructure with numerous cross-sectional functions
- **MLPro-RL:** Reinforcement learning
- **MLPro-GT:** Game theory
- **MLPro-OA:** Online machine learning
- **MLPro-SL:** Supervised learning

#### c) Online documentation ([learn more](https://mlpro.readthedocs.io/))

#### d) Example pool ([learn more](https://mlpro.readthedocs.io/en/latest/content/99_appendices/appendix1/main.html))

#### e) Extension hub ([learn more](https://mlpro.readthedocs.io/en/latest/content/04_extensions/main.html))


## Development
- Consequent object-oriented design and programming (OOD/OOP)
- Quality assurance by test-driven development
- Agile CI/CD approach with automated test and deployment
- Clean code paradigm


## Project and Team
Project MLPro was started in 2021 by the [Group for Automation Technology and Learning Systems at the South Westphalia University of Applied Sciences, Germany](https://www.fh-swf.de/de/forschung___transfer_4/labore_3/labs/labor_fuer_automatisierungstechnik__soest_1/standardseite_57.php).

[Contributors](https://github.com/fhswf/MLPro/graphs/contributors). 


## How to contribute
If you want to contribute, please read [CONTRIBUTING.md](https://github.com/fhswf/MLPro/blob/master/CONTRIBUTING.md)
