# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_entry_details import SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_entry_matching import SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_entry_response import SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse

class SecondaryMarketDayAheadOrIntraDayNoticeboardEntry(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayNoticeboardEntry
    """
    notice_details: SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails = Field(..., alias="noticeDetails")
    responses: conlist(SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse) = Field(...)
    matching_entries: conlist(SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching) = Field(..., alias="matchingEntries")
    __properties = ["noticeDetails", "responses", "matchingEntries"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntry:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of notice_details
        if self.notice_details:
            _dict['noticeDetails'] = self.notice_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in responses (list)
        _items = []
        if self.responses:
            for _item in self.responses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['responses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in matching_entries (list)
        _items = []
        if self.matching_entries:
            for _item in self.matching_entries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['matchingEntries'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntry:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketDayAheadOrIntraDayNoticeboardEntry.parse_obj(obj)

        _obj = SecondaryMarketDayAheadOrIntraDayNoticeboardEntry.parse_obj({
            "notice_details": SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails.from_dict(obj.get("noticeDetails")) if obj.get("noticeDetails") is not None else None,
            "responses": [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse.from_dict(_item) for _item in obj.get("responses")] if obj.get("responses") is not None else None,
            "matching_entries": [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching.from_dict(_item) for _item in obj.get("matchingEntries")] if obj.get("matchingEntries") is not None else None
        })
        return _obj

