# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.permission import Permission
from empire_platform_api_public_client.models.platform_appearance import PlatformAppearance
from empire_platform_api_public_client.models.profile_user import ProfileUser

class Profile(BaseModel):
    """
    Profile
    """
    user: ProfileUser = Field(...)
    permissions: conlist(Permission) = Field(...)
    appearance: PlatformAppearance = Field(...)
    impersonated_by: Optional[ProfileUser] = Field(None, alias="impersonatedBy")
    __properties = ["user", "permissions", "appearance", "impersonatedBy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Profile:
        """Create an instance of Profile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of impersonated_by
        if self.impersonated_by:
            _dict['impersonatedBy'] = self.impersonated_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Profile:
        """Create an instance of Profile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Profile.parse_obj(obj)

        _obj = Profile.parse_obj({
            "user": ProfileUser.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "permissions": obj.get("permissions"),
            "appearance": obj.get("appearance"),
            "impersonated_by": ProfileUser.from_dict(obj.get("impersonatedBy")) if obj.get("impersonatedBy") is not None else None
        })
        return _obj

