# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.participant_dashboard_transmission_rights_and_nominations_data_mtus_inner_values_inner_nomination_restriction import ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInnerNominationRestriction

class ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner(BaseModel):
    """
    ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner
    """
    direction: BorderDirection = Field(...)
    allocated_trs: StrictInt = Field(..., alias="allocatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    nominated_capacity: StrictInt = Field(..., alias="nominatedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    nomination_restriction: Optional[ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInnerNominationRestriction] = Field(None, alias="nominationRestriction")
    __properties = ["direction", "allocatedTrs", "nominatedCapacity", "nominationRestriction"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner:
        """Create an instance of ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of nomination_restriction
        if self.nomination_restriction:
            _dict['nominationRestriction'] = self.nomination_restriction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner:
        """Create an instance of ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner.parse_obj(obj)

        _obj = ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner.parse_obj({
            "direction": obj.get("direction"),
            "allocated_trs": obj.get("allocatedTrs"),
            "nominated_capacity": obj.get("nominatedCapacity"),
            "nomination_restriction": ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInnerNominationRestriction.from_dict(obj.get("nominationRestriction")) if obj.get("nominationRestriction") is not None else None
        })
        return _obj

