# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictBool, confloat, conint

class FinanceInformationLockableAmount(BaseModel):
    """
    FinanceInformationLockableAmount
    """
    amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    locked: StrictBool = Field(...)
    __properties = ["amount", "locked"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FinanceInformationLockableAmount:
        """Create an instance of FinanceInformationLockableAmount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FinanceInformationLockableAmount:
        """Create an instance of FinanceInformationLockableAmount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FinanceInformationLockableAmount.parse_obj(obj)

        _obj = FinanceInformationLockableAmount.parse_obj({
            "amount": obj.get("amount"),
            "locked": obj.get("locked")
        })
        return _obj

