# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date

from pydantic import BaseModel, Field, StrictInt, StrictStr
from empire_platform_api_public_client.models.border_direction import BorderDirection

class CreateSecondaryMarketLongTermTransferRequest(BaseModel):
    """
    CreateSecondaryMarketLongTermTransferRequest
    """
    first_day: date = Field(..., alias="firstDay", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    last_day: date = Field(..., alias="lastDay", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    direction: BorderDirection = Field(...)
    participant_id: StrictStr = Field(..., alias="participantId", description="Unique identifier for the record in UUID4 format")
    transfer_capacity: StrictInt = Field(..., alias="transferCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["firstDay", "lastDay", "direction", "participantId", "transferCapacity"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateSecondaryMarketLongTermTransferRequest:
        """Create an instance of CreateSecondaryMarketLongTermTransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateSecondaryMarketLongTermTransferRequest:
        """Create an instance of CreateSecondaryMarketLongTermTransferRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateSecondaryMarketLongTermTransferRequest.parse_obj(obj)

        _obj = CreateSecondaryMarketLongTermTransferRequest.parse_obj({
            "first_day": obj.get("firstDay"),
            "last_day": obj.get("lastDay"),
            "direction": obj.get("direction"),
            "participant_id": obj.get("participantId"),
            "transfer_capacity": obj.get("transferCapacity")
        })
        return _obj

