# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.default_nomination_mtu import DefaultNominationMtu

class CreateDefaultNominationRequest(BaseModel):
    """
    CreateDefaultNominationRequest
    """
    timescale: AuctionTimescale = Field(...)
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    delivery_period_start: date = Field(..., alias="deliveryPeriodStart", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    delivery_period_end: Optional[date] = Field(None, alias="deliveryPeriodEnd", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    mtus: conlist(DefaultNominationMtu) = Field(...)
    __properties = ["timescale", "borderDirection", "deliveryPeriodStart", "deliveryPeriodEnd", "mtus"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateDefaultNominationRequest:
        """Create an instance of CreateDefaultNominationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in mtus (list)
        _items = []
        if self.mtus:
            for _item in self.mtus:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtus'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateDefaultNominationRequest:
        """Create an instance of CreateDefaultNominationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateDefaultNominationRequest.parse_obj(obj)

        _obj = CreateDefaultNominationRequest.parse_obj({
            "timescale": obj.get("timescale"),
            "border_direction": obj.get("borderDirection"),
            "delivery_period_start": obj.get("deliveryPeriodStart"),
            "delivery_period_end": obj.get("deliveryPeriodEnd"),
            "mtus": [DefaultNominationMtu.from_dict(_item) for _item in obj.get("mtus")] if obj.get("mtus") is not None else None
        })
        return _obj

