# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.175.1
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import List, Optional

from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_reduction_period import AuctionReductionPeriod
from empire_platform_api_public_client.models.auction_sort_by import AuctionSortBy
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.public_auction_batch import PublicAuctionBatch
from empire_platform_api_public_client.models.public_auction_status import PublicAuctionStatus
from empire_platform_api_public_client.models.public_day_ahead_auction import PublicDayAheadAuction
from empire_platform_api_public_client.models.public_day_ahead_or_intra_day_auction_mtu_results import PublicDayAheadOrIntraDayAuctionMtuResults
from empire_platform_api_public_client.models.public_day_ahead_or_intra_day_auction_results import PublicDayAheadOrIntraDayAuctionResults
from empire_platform_api_public_client.models.public_intra_day_auction import PublicIntraDayAuction
from empire_platform_api_public_client.models.public_long_term_auction import PublicLongTermAuction
from empire_platform_api_public_client.models.public_long_term_auction_results import PublicLongTermAuctionResults

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PublicAuctionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_public_auction_reduction_periods(self, id : StrictStr, **kwargs) -> List[AuctionReductionPeriod]:  # noqa: E501
        """get_public_auction_reduction_periods  # noqa: E501

        Fetch reduction periods that possibly affects the Auction  See more at `getAuctionReductionPeriods`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_auction_reduction_periods(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[AuctionReductionPeriod]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_auction_reduction_periods_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_auction_reduction_periods_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_auction_reduction_periods_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_auction_reduction_periods  # noqa: E501

        Fetch reduction periods that possibly affects the Auction  See more at `getAuctionReductionPeriods`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_auction_reduction_periods_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[AuctionReductionPeriod], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_auction_reduction_periods" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "List[AuctionReductionPeriod]",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/{id}/reduction-periods', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_auctions(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[AuctionSortBy, Field(..., description="Sort list by given attribute and direction")], border_direction : Annotated[Optional[BorderDirection], Field(description="Filter for given border direction")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Filter for given timescale")] = None, product_type : Annotated[Optional[AuctionProductType], Field(description="Filter for given product type")] = None, status : Annotated[Optional[PublicAuctionStatus], Field(description="Filter for given (published) status")] = None, bidding_period_start : Annotated[Optional[datetime], Field(description="Filter for start of bidding period")] = None, bidding_period_end : Annotated[Optional[datetime], Field(description="Filter for end of bidding period")] = None, delivery_period_start : Annotated[Optional[datetime], Field(description="Filter for start of delivery period (aligned to MTUs)")] = None, delivery_period_end : Annotated[Optional[datetime], Field(description="Filter for end of delivery period (aligned to MTUs)")] = None, query : Annotated[Optional[StrictStr], Field(description="Free text search in name")] = None, **kwargs) -> PublicAuctionBatch:  # noqa: E501
        """get_public_auctions  # noqa: E501

        Fetch a paginated, sortable, filterable list of Auctions  See more at `getAuctions`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_auctions(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: AuctionSortBy
        :param border_direction: Filter for given border direction
        :type border_direction: BorderDirection
        :param timescale: Filter for given timescale
        :type timescale: AuctionTimescale
        :param product_type: Filter for given product type
        :type product_type: AuctionProductType
        :param status: Filter for given (published) status
        :type status: PublicAuctionStatus
        :param bidding_period_start: Filter for start of bidding period
        :type bidding_period_start: datetime
        :param bidding_period_end: Filter for end of bidding period
        :type bidding_period_end: datetime
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs)
        :type delivery_period_end: datetime
        :param query: Free text search in name
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicAuctionBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_auctions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_auctions_with_http_info(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_auctions_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : Annotated[AuctionSortBy, Field(..., description="Sort list by given attribute and direction")], border_direction : Annotated[Optional[BorderDirection], Field(description="Filter for given border direction")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Filter for given timescale")] = None, product_type : Annotated[Optional[AuctionProductType], Field(description="Filter for given product type")] = None, status : Annotated[Optional[PublicAuctionStatus], Field(description="Filter for given (published) status")] = None, bidding_period_start : Annotated[Optional[datetime], Field(description="Filter for start of bidding period")] = None, bidding_period_end : Annotated[Optional[datetime], Field(description="Filter for end of bidding period")] = None, delivery_period_start : Annotated[Optional[datetime], Field(description="Filter for start of delivery period (aligned to MTUs)")] = None, delivery_period_end : Annotated[Optional[datetime], Field(description="Filter for end of delivery period (aligned to MTUs)")] = None, query : Annotated[Optional[StrictStr], Field(description="Free text search in name")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_auctions  # noqa: E501

        Fetch a paginated, sortable, filterable list of Auctions  See more at `getAuctions`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_auctions_with_http_info(limit, offset, sort_by, border_direction, timescale, product_type, status, bidding_period_start, bidding_period_end, delivery_period_start, delivery_period_end, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: Sort list by given attribute and direction (required)
        :type sort_by: AuctionSortBy
        :param border_direction: Filter for given border direction
        :type border_direction: BorderDirection
        :param timescale: Filter for given timescale
        :type timescale: AuctionTimescale
        :param product_type: Filter for given product type
        :type product_type: AuctionProductType
        :param status: Filter for given (published) status
        :type status: PublicAuctionStatus
        :param bidding_period_start: Filter for start of bidding period
        :type bidding_period_start: datetime
        :param bidding_period_end: Filter for end of bidding period
        :type bidding_period_end: datetime
        :param delivery_period_start: Filter for start of delivery period (aligned to MTUs)
        :type delivery_period_start: datetime
        :param delivery_period_end: Filter for end of delivery period (aligned to MTUs)
        :type delivery_period_end: datetime
        :param query: Free text search in name
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicAuctionBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'border_direction',
            'timescale',
            'product_type',
            'status',
            'bidding_period_start',
            'bidding_period_end',
            'delivery_period_start',
            'delivery_period_end',
            'query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_auctions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        if _params.get('product_type') is not None:  # noqa: E501
            _query_params.append(('productType', _params['product_type'].value))

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        if _params.get('bidding_period_start') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_start'], datetime):
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('biddingPeriodStart', _params['bidding_period_start']))

        if _params.get('bidding_period_end') is not None:  # noqa: E501
            if isinstance(_params['bidding_period_end'], datetime):
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('biddingPeriodEnd', _params['bidding_period_end']))

        if _params.get('delivery_period_start') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_start'], datetime):
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodStart', _params['delivery_period_start']))

        if _params.get('delivery_period_end') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_end'], datetime):
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('deliveryPeriodEnd', _params['delivery_period_end']))

        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicAuctionBatch",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_day_ahead_auction(self, id : StrictStr, **kwargs) -> PublicDayAheadAuction:  # noqa: E501
        """get_public_day_ahead_auction  # noqa: E501

        Fetch a Day Ahead Auction by its identifier  See more at `getDayAheadAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicDayAheadAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_day_ahead_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_day_ahead_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_day_ahead_auction_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_day_ahead_auction  # noqa: E501

        Fetch a Day Ahead Auction by its identifier  See more at `getDayAheadAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicDayAheadAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_day_ahead_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicDayAheadAuction",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/day-ahead/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_day_ahead_or_intra_day_auction_mtu_results(self, id : StrictStr, mtu : datetime, **kwargs) -> PublicDayAheadOrIntraDayAuctionMtuResults:  # noqa: E501
        """get_public_day_ahead_or_intra_day_auction_mtu_results  # noqa: E501

        Fetch results for a given MTU in a Day Ahead or an Intra-Day Auction by its identifier  See more at `getDayAheadOrIntraDayAuctionMtuResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_or_intra_day_auction_mtu_results(id, mtu, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param mtu: (required)
        :type mtu: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicDayAheadOrIntraDayAuctionMtuResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_day_ahead_or_intra_day_auction_mtu_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_day_ahead_or_intra_day_auction_mtu_results_with_http_info(id, mtu, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_day_ahead_or_intra_day_auction_mtu_results_with_http_info(self, id : StrictStr, mtu : datetime, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_day_ahead_or_intra_day_auction_mtu_results  # noqa: E501

        Fetch results for a given MTU in a Day Ahead or an Intra-Day Auction by its identifier  See more at `getDayAheadOrIntraDayAuctionMtuResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_or_intra_day_auction_mtu_results_with_http_info(id, mtu, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param mtu: (required)
        :type mtu: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicDayAheadOrIntraDayAuctionMtuResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'mtu'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_day_ahead_or_intra_day_auction_mtu_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('mtu') is not None:  # noqa: E501
            if isinstance(_params['mtu'], datetime):
                _query_params.append(('mtu', _params['mtu'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('mtu', _params['mtu']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicDayAheadOrIntraDayAuctionMtuResults",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/day-ahead-or-intra-day/{id}/results/mtus', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_day_ahead_or_intra_day_auction_results(self, id : StrictStr, **kwargs) -> PublicDayAheadOrIntraDayAuctionResults:  # noqa: E501
        """get_public_day_ahead_or_intra_day_auction_results  # noqa: E501

        Fetch results for a Day Ahead or an Intra Day Auction by its identifier  See more at `getDayAheadOrIntraDayAuctionResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_or_intra_day_auction_results(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicDayAheadOrIntraDayAuctionResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_day_ahead_or_intra_day_auction_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_day_ahead_or_intra_day_auction_results_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_day_ahead_or_intra_day_auction_results_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_day_ahead_or_intra_day_auction_results  # noqa: E501

        Fetch results for a Day Ahead or an Intra Day Auction by its identifier  See more at `getDayAheadOrIntraDayAuctionResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_day_ahead_or_intra_day_auction_results_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicDayAheadOrIntraDayAuctionResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_day_ahead_or_intra_day_auction_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicDayAheadOrIntraDayAuctionResults",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/day-ahead-or-intra-day/{id}/results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_intra_day_auction(self, id : StrictStr, **kwargs) -> PublicIntraDayAuction:  # noqa: E501
        """get_public_intra_day_auction  # noqa: E501

        Fetch an Intra Day Auction by its identifier  See more at `getIntraDayAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_intra_day_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicIntraDayAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_intra_day_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_intra_day_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_intra_day_auction_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_intra_day_auction  # noqa: E501

        Fetch an Intra Day Auction by its identifier  See more at `getIntraDayAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_intra_day_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicIntraDayAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_intra_day_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicIntraDayAuction",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/intra-day/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_long_term_auction(self, id : StrictStr, **kwargs) -> PublicLongTermAuction:  # noqa: E501
        """get_public_long_term_auction  # noqa: E501

        Fetch a Long Term Auction by its identifier  See more at `getLongTermAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicLongTermAuction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_long_term_auction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_long_term_auction_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_long_term_auction_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_long_term_auction  # noqa: E501

        Fetch a Long Term Auction by its identifier  See more at `getLongTermAuction`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicLongTermAuction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_long_term_auction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicLongTermAuction",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/long-term/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_long_term_auction_calendar(self, **kwargs) -> str:  # noqa: E501
        """get_public_long_term_auction_calendar  # noqa: E501

        Fetch Long Term Auction \"bidding windows\" in iCal format, suitable for calendar subscriptions   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction_calendar(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_long_term_auction_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_long_term_auction_calendar_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_public_long_term_auction_calendar_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_long_term_auction_calendar  # noqa: E501

        Fetch Long Term Auction \"bidding windows\" in iCal format, suitable for calendar subscriptions   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction_calendar_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_long_term_auction_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/calendar'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/long-term/calendar', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_public_long_term_auction_results(self, id : StrictStr, **kwargs) -> PublicLongTermAuctionResults:  # noqa: E501
        """get_public_long_term_auction_results  # noqa: E501

        Fetch results for a Long Term Auction by its identifier  See more at `getLongTermAuctionResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction_results(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PublicLongTermAuctionResults
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_public_long_term_auction_results_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_public_long_term_auction_results_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_public_long_term_auction_results_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_public_long_term_auction_results  # noqa: E501

        Fetch results for a Long Term Auction by its identifier  See more at `getLongTermAuctionResults`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_long_term_auction_results_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PublicLongTermAuctionResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_long_term_auction_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PublicLongTermAuctionResults",
            '400': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/public/auctions/long-term/{id}/results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
