# empire-platform-api-public-client
OpenAPI specification for the Platform REST API of Empire

**System Time:** Europe/Amsterdam

**General data formats:**
  * _capacity values_ => kW (integers)
  * _dates and local times_ => System Time
  * _currencies_ => EUR


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.175.1
- Package version: 0.175.1
- Build package: org.openapitools.codegen.languages.PythonNextgenClientCodegen
For more information, please visit [https://www.britned.com](https://www.britned.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import empire_platform_api_public_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import empire_platform_api_public_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import empire_platform_api_public_client
from empire_platform_api_public_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.dev.empire.scapps.io
# See configuration.py for a list of all supported configuration parameters.
configuration = empire_platform_api_public_client.Configuration(
    host = "https://api.dev.empire.scapps.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKey
configuration.api_key['ApiKey'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKey'] = 'Bearer'

# Configure Bearer authorization (JWT): AuthToken
configuration = empire_platform_api_public_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with empire_platform_api_public_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = empire_platform_api_public_client.AttachmentApi(api_client)
    file_name = 'file_name_example' # str | 
    file = None # bytearray | 

    try:
        api_response = api_instance.upload_attachment(file_name, file)
        print("The response of AttachmentApi->upload_attachment:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AttachmentApi->upload_attachment: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.dev.empire.scapps.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AttachmentApi* | [**upload_attachment**](docs/AttachmentApi.md#upload_attachment) | **POST** /v1/attachments | 
*AuctionApi* | [**get_auction_bidding_configuration**](docs/AuctionApi.md#get_auction_bidding_configuration) | **GET** /v1/auctions/{id}/bidding-configuration | 
*AuctionApi* | [**get_auction_participants**](docs/AuctionApi.md#get_auction_participants) | **GET** /v1/auctions/{id}/participants | 
*AuctionApi* | [**get_auction_reduction_periods**](docs/AuctionApi.md#get_auction_reduction_periods) | **GET** /v1/auctions/{id}/reduction-periods | 
*AuctionApi* | [**get_auctions**](docs/AuctionApi.md#get_auctions) | **GET** /v1/auctions | 
*AuctionApi* | [**get_day_ahead_auction**](docs/AuctionApi.md#get_day_ahead_auction) | **GET** /v1/auctions/day-ahead/{id} | 
*AuctionApi* | [**get_day_ahead_or_intra_day_auction_bids**](docs/AuctionApi.md#get_day_ahead_or_intra_day_auction_bids) | **GET** /v1/auctions/day-ahead-or-intra-day/{id}/bids | 
*AuctionApi* | [**get_day_ahead_or_intra_day_auction_mtu_results**](docs/AuctionApi.md#get_day_ahead_or_intra_day_auction_mtu_results) | **GET** /v1/auctions/day-ahead-or-intra-day/{id}/results/mtus | 
*AuctionApi* | [**get_day_ahead_or_intra_day_auction_participant_results**](docs/AuctionApi.md#get_day_ahead_or_intra_day_auction_participant_results) | **GET** /v1/auctions/day-ahead-or-intra-day/{id}/results/participants/{participantId} | 
*AuctionApi* | [**get_day_ahead_or_intra_day_auction_results**](docs/AuctionApi.md#get_day_ahead_or_intra_day_auction_results) | **GET** /v1/auctions/day-ahead-or-intra-day/{id}/results | 
*AuctionApi* | [**get_intra_day_auction**](docs/AuctionApi.md#get_intra_day_auction) | **GET** /v1/auctions/intra-day/{id} | 
*AuctionApi* | [**get_long_term_auction**](docs/AuctionApi.md#get_long_term_auction) | **GET** /v1/auctions/long-term/{id} | 
*AuctionApi* | [**get_long_term_auction_bids**](docs/AuctionApi.md#get_long_term_auction_bids) | **GET** /v1/auctions/long-term/{id}/bids | 
*AuctionApi* | [**get_long_term_auction_results**](docs/AuctionApi.md#get_long_term_auction_results) | **GET** /v1/auctions/long-term/{id}/results | 
*AuctionApi* | [**submit_day_ahead_or_intra_day_bids**](docs/AuctionApi.md#submit_day_ahead_or_intra_day_bids) | **PUT** /v1/auctions/day-ahead-or-intra-day/{id}/bids | 
*AuctionApi* | [**submit_long_term_bids**](docs/AuctionApi.md#submit_long_term_bids) | **PUT** /v1/auctions/long-term/{id}/bids | 
*AuditLogApi* | [**get_audit_log_payload**](docs/AuditLogApi.md#get_audit_log_payload) | **GET** /v1/audit-logs/{id}/payload | 
*AuditLogApi* | [**get_audit_logs**](docs/AuditLogApi.md#get_audit_logs) | **GET** /v1/audit-logs | 
*BiddingConfigurationApi* | [**get_bidding_configuration**](docs/BiddingConfigurationApi.md#get_bidding_configuration) | **GET** /v1/bidding-configuration | 
*BiddingConfigurationApi* | [**update_bidding_configuration**](docs/BiddingConfigurationApi.md#update_bidding_configuration) | **PUT** /v1/bidding-configuration | 
*BuyNowOffersApi* | [**get_buy_now_offers**](docs/BuyNowOffersApi.md#get_buy_now_offers) | **GET** /v1/buy-now-offers | 
*BuyNowOffersApi* | [**purchase_buy_now_offer**](docs/BuyNowOffersApi.md#purchase_buy_now_offer) | **PUT** /v1/buy-now-offers/{id}/purchase | 
*DefaultBidApi* | [**create_day_ahead_or_intra_day_default_bid**](docs/DefaultBidApi.md#create_day_ahead_or_intra_day_default_bid) | **POST** /v1/default-bids/day-ahead-or-intra-day | 
*DefaultBidApi* | [**create_long_term_default_bid**](docs/DefaultBidApi.md#create_long_term_default_bid) | **POST** /v1/default-bids/long-term | 
*DefaultBidApi* | [**delete_default_bid**](docs/DefaultBidApi.md#delete_default_bid) | **DELETE** /v1/default-bids/{id} | 
*DefaultBidApi* | [**get_day_ahead_or_intra_day_default_bid**](docs/DefaultBidApi.md#get_day_ahead_or_intra_day_default_bid) | **GET** /v1/default-bids/day-ahead-or-intra-day/{id} | 
*DefaultBidApi* | [**get_default_bid_options**](docs/DefaultBidApi.md#get_default_bid_options) | **GET** /v1/default-bids/options | 
*DefaultBidApi* | [**get_default_bids**](docs/DefaultBidApi.md#get_default_bids) | **GET** /v1/default-bids | 
*DefaultBidApi* | [**get_long_term_default_bid**](docs/DefaultBidApi.md#get_long_term_default_bid) | **GET** /v1/default-bids/long-term/{id} | 
*DefaultBidApi* | [**update_day_ahead_or_intra_day_default_bid**](docs/DefaultBidApi.md#update_day_ahead_or_intra_day_default_bid) | **PUT** /v1/default-bids/day-ahead-or-intra-day/{id} | 
*DefaultBidApi* | [**update_long_term_default_bid**](docs/DefaultBidApi.md#update_long_term_default_bid) | **PUT** /v1/default-bids/long-term/{id} | 
*DefaultNominationApi* | [**create_default_nomination**](docs/DefaultNominationApi.md#create_default_nomination) | **POST** /v1/default-nominations | 
*DefaultNominationApi* | [**delete_default_nomination**](docs/DefaultNominationApi.md#delete_default_nomination) | **DELETE** /v1/default-nominations/{id} | 
*DefaultNominationApi* | [**get_default_nomination**](docs/DefaultNominationApi.md#get_default_nomination) | **GET** /v1/default-nominations/{id} | 
*DefaultNominationApi* | [**get_default_nomination_options**](docs/DefaultNominationApi.md#get_default_nomination_options) | **GET** /v1/default-nominations/options | 
*DefaultNominationApi* | [**get_default_nominations**](docs/DefaultNominationApi.md#get_default_nominations) | **GET** /v1/default-nominations | 
*DefaultNominationApi* | [**update_default_nomination**](docs/DefaultNominationApi.md#update_default_nomination) | **PUT** /v1/default-nominations/{id} | 
*FinanceApi* | [**get_finance_invoice**](docs/FinanceApi.md#get_finance_invoice) | **GET** /v1/finance/invoices/{id} | 
*FinanceApi* | [**get_finance_invoices**](docs/FinanceApi.md#get_finance_invoices) | **GET** /v1/finance/invoices | 
*FinanceApi* | [**get_finance_settlement_per_day**](docs/FinanceApi.md#get_finance_settlement_per_day) | **GET** /v1/finance/settlement/day | 
*FinanceApi* | [**get_finance_settlement_per_source**](docs/FinanceApi.md#get_finance_settlement_per_source) | **GET** /v1/finance/settlement/source | 
*FinanceApi* | [**get_finance_uiosi_overview**](docs/FinanceApi.md#get_finance_uiosi_overview) | **GET** /v1/finance/uiosi-overview | 
*FinanceInformationApi* | [**get_finance_information**](docs/FinanceInformationApi.md#get_finance_information) | **GET** /v1/finance-information | 
*ManualFileUploadApi* | [**upload_day_ahead_or_intra_day_bids**](docs/ManualFileUploadApi.md#upload_day_ahead_or_intra_day_bids) | **POST** /v1/manual-file-upload/bids/day-ahead-or-intra-day | 
*ManualFileUploadApi* | [**upload_long_term_bids**](docs/ManualFileUploadApi.md#upload_long_term_bids) | **POST** /v1/manual-file-upload/bids/long-term | 
*ManualFileUploadApi* | [**upload_timescale_nominations**](docs/ManualFileUploadApi.md#upload_timescale_nominations) | **POST** /v1/manual-file-upload/nominations/timescale | 
*MessagesApi* | [**get_participant_messages**](docs/MessagesApi.md#get_participant_messages) | **GET** /v1/messages/participant | 
*MessagesApi* | [**get_participant_unread_messages**](docs/MessagesApi.md#get_participant_unread_messages) | **GET** /v1/messages/participant/unread | 
*MessagesApi* | [**get_system_messages**](docs/MessagesApi.md#get_system_messages) | **GET** /v1/messages/system | 
*MetadataApi* | [**get_version**](docs/MetadataApi.md#get_version) | **GET** /v1/public/version | 
*NominationApi* | [**get_aggregated_nomination_options**](docs/NominationApi.md#get_aggregated_nomination_options) | **GET** /v1/nominations/aggregated/options | 
*NominationApi* | [**get_aggregated_nominations**](docs/NominationApi.md#get_aggregated_nominations) | **GET** /v1/nominations/aggregated | 
*NominationApi* | [**get_timescale_nomination_options**](docs/NominationApi.md#get_timescale_nomination_options) | **GET** /v1/nominations/timescale/options | 
*NominationApi* | [**get_timescale_nominations**](docs/NominationApi.md#get_timescale_nominations) | **GET** /v1/nominations/timescale | 
*NominationApi* | [**submit_timescale_nominations**](docs/NominationApi.md#submit_timescale_nominations) | **PUT** /v1/nominations/timescale | 
*OrganisationApi* | [**get_organisation**](docs/OrganisationApi.md#get_organisation) | **GET** /v1/organisations/{id} | 
*OrganisationApi* | [**get_participant_names**](docs/OrganisationApi.md#get_participant_names) | **GET** /v1/organisations/participant-names | 
*OrganisationApi* | [**get_participant_organisation**](docs/OrganisationApi.md#get_participant_organisation) | **GET** /v1/organisations/participant/{id} | 
*OrganisationDocumentApi* | [**create_organisation_document**](docs/OrganisationDocumentApi.md#create_organisation_document) | **POST** /v1/organisation-documents | 
*OrganisationDocumentApi* | [**delete_organisation_document**](docs/OrganisationDocumentApi.md#delete_organisation_document) | **DELETE** /v1/organisation-documents/{id} | 
*OrganisationDocumentApi* | [**get_organisation_document_options**](docs/OrganisationDocumentApi.md#get_organisation_document_options) | **GET** /v1/organisation-documents/options | 
*OrganisationDocumentApi* | [**get_organisation_documents**](docs/OrganisationDocumentApi.md#get_organisation_documents) | **GET** /v1/organisation-documents | 
*ParticipantDashboardApi* | [**get_participant_dashboard_default_bids_and_nominations**](docs/ParticipantDashboardApi.md#get_participant_dashboard_default_bids_and_nominations) | **GET** /v1/participant-dashboard/default-bids-and-nominations | 
*ParticipantDashboardApi* | [**get_participant_dashboard_finance_overview**](docs/ParticipantDashboardApi.md#get_participant_dashboard_finance_overview) | **GET** /v1/participant-dashboard/finance-overview | 
*ParticipantDashboardApi* | [**get_participant_dashboard_interconnector_capacity**](docs/ParticipantDashboardApi.md#get_participant_dashboard_interconnector_capacity) | **GET** /v1/participant-dashboard/interconnector-capacity | 
*ParticipantDashboardApi* | [**get_participant_dashboard_interconnector_capacity_graph**](docs/ParticipantDashboardApi.md#get_participant_dashboard_interconnector_capacity_graph) | **GET** /v1/participant-dashboard/interconnector-capacity-graph | 
*ParticipantDashboardApi* | [**get_participant_dashboard_messages**](docs/ParticipantDashboardApi.md#get_participant_dashboard_messages) | **GET** /v1/participant-dashboard/messages | 
*ParticipantDashboardApi* | [**get_participant_dashboard_netted_nominations**](docs/ParticipantDashboardApi.md#get_participant_dashboard_netted_nominations) | **GET** /v1/participant-dashboard/netted-nominations | 
*ParticipantDashboardApi* | [**get_participant_dashboard_next_auctions_and_nomination_gates**](docs/ParticipantDashboardApi.md#get_participant_dashboard_next_auctions_and_nomination_gates) | **GET** /v1/participant-dashboard/next-auctions-and-nomination-gates | 
*ParticipantDashboardApi* | [**get_participant_dashboard_transmission_rights_and_nominations**](docs/ParticipantDashboardApi.md#get_participant_dashboard_transmission_rights_and_nominations) | **GET** /v1/participant-dashboard/transmission-rights-and-nominations | 
*ParticipantDashboardApi* | [**get_participant_dashboard_transmission_rights_and_nominations_graph**](docs/ParticipantDashboardApi.md#get_participant_dashboard_transmission_rights_and_nominations_graph) | **GET** /v1/participant-dashboard/transmission-rights-and-nominations-graph | 
*ParticipantDashboardApi* | [**get_participant_dashboard_upcoming_long_term_auctions**](docs/ParticipantDashboardApi.md#get_participant_dashboard_upcoming_long_term_auctions) | **GET** /v1/participant-dashboard/upcoming-long-term-auctions | 
*ParticipantOverviewApi* | [**get_participant_overview**](docs/ParticipantOverviewApi.md#get_participant_overview) | **GET** /v1/participant-overview | 
*ProfileApi* | [**create_api_key**](docs/ProfileApi.md#create_api_key) | **POST** /v1/profile/api-keys | 
*ProfileApi* | [**delete_api_key**](docs/ProfileApi.md#delete_api_key) | **DELETE** /v1/profile/api-keys/{id} | 
*ProfileApi* | [**get_api_keys**](docs/ProfileApi.md#get_api_keys) | **GET** /v1/profile/api-keys | 
*ProfileApi* | [**get_preferences**](docs/ProfileApi.md#get_preferences) | **GET** /v1/profile/preferences | 
*ProfileApi* | [**get_profile**](docs/ProfileApi.md#get_profile) | **GET** /v1/profile | 
*ProfileApi* | [**get_profile_details**](docs/ProfileApi.md#get_profile_details) | **GET** /v1/profile/details | 
*ProfileApi* | [**get_zendesk_chat_token**](docs/ProfileApi.md#get_zendesk_chat_token) | **GET** /v1/profile/zendesk-chat-token | 
*ProfileApi* | [**update_preferences**](docs/ProfileApi.md#update_preferences) | **PUT** /v1/profile/preferences | 
*ProfileApi* | [**update_profile_details**](docs/ProfileApi.md#update_profile_details) | **PUT** /v1/profile/details | 
*PublicAllocatedAuctionApi* | [**get_public_aggregated_allocated_auctions**](docs/PublicAllocatedAuctionApi.md#get_public_aggregated_allocated_auctions) | **GET** /v1/public/allocated-auctions/aggregated | 
*PublicAllocatedAuctionApi* | [**get_public_allocated_auctions**](docs/PublicAllocatedAuctionApi.md#get_public_allocated_auctions) | **GET** /v1/public/allocated-auctions | 
*PublicAuctionApi* | [**get_public_auction_reduction_periods**](docs/PublicAuctionApi.md#get_public_auction_reduction_periods) | **GET** /v1/public/auctions/{id}/reduction-periods | 
*PublicAuctionApi* | [**get_public_auctions**](docs/PublicAuctionApi.md#get_public_auctions) | **GET** /v1/public/auctions | 
*PublicAuctionApi* | [**get_public_day_ahead_auction**](docs/PublicAuctionApi.md#get_public_day_ahead_auction) | **GET** /v1/public/auctions/day-ahead/{id} | 
*PublicAuctionApi* | [**get_public_day_ahead_or_intra_day_auction_mtu_results**](docs/PublicAuctionApi.md#get_public_day_ahead_or_intra_day_auction_mtu_results) | **GET** /v1/public/auctions/day-ahead-or-intra-day/{id}/results/mtus | 
*PublicAuctionApi* | [**get_public_day_ahead_or_intra_day_auction_results**](docs/PublicAuctionApi.md#get_public_day_ahead_or_intra_day_auction_results) | **GET** /v1/public/auctions/day-ahead-or-intra-day/{id}/results | 
*PublicAuctionApi* | [**get_public_intra_day_auction**](docs/PublicAuctionApi.md#get_public_intra_day_auction) | **GET** /v1/public/auctions/intra-day/{id} | 
*PublicAuctionApi* | [**get_public_long_term_auction**](docs/PublicAuctionApi.md#get_public_long_term_auction) | **GET** /v1/public/auctions/long-term/{id} | 
*PublicAuctionApi* | [**get_public_long_term_auction_calendar**](docs/PublicAuctionApi.md#get_public_long_term_auction_calendar) | **GET** /v1/public/auctions/long-term/calendar | 
*PublicAuctionApi* | [**get_public_long_term_auction_results**](docs/PublicAuctionApi.md#get_public_long_term_auction_results) | **GET** /v1/public/auctions/long-term/{id}/results | 
*PublicNominationsApi* | [**get_public_aggregated_nominations_overview**](docs/PublicNominationsApi.md#get_public_aggregated_nominations_overview) | **GET** /v1/public/nominations/aggregated-overview | 
*ReportingApi* | [**get_auctions_schedule_report**](docs/ReportingApi.md#get_auctions_schedule_report) | **GET** /v1/reporting/auctions/schedule | 
*ReportingApi* | [**get_organisations_audit_logs_report**](docs/ReportingApi.md#get_organisations_audit_logs_report) | **GET** /v1/reporting/organisations/audit-logs | 
*ReportingApi* | [**get_organisations_users_report**](docs/ReportingApi.md#get_organisations_users_report) | **GET** /v1/reporting/organisations/users | 
*ReportingApi* | [**get_outages_curtailment_report**](docs/ReportingApi.md#get_outages_curtailment_report) | **GET** /v1/reporting/outages/curtailment | 
*ReportingApi* | [**get_trs_and_nominations_buy_now_report**](docs/ReportingApi.md#get_trs_and_nominations_buy_now_report) | **GET** /v1/reporting/trs-and-nominations/buy-now | 
*ReportingApi* | [**get_trs_and_nominations_overview_report**](docs/ReportingApi.md#get_trs_and_nominations_overview_report) | **GET** /v1/reporting/trs-and-nominations/overview | 
*ReportingApi* | [**get_trs_and_nominations_proof_report**](docs/ReportingApi.md#get_trs_and_nominations_proof_report) | **GET** /v1/reporting/trs-and-nominations/proof | 
*SecondaryMarketApi* | [**accept_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#accept_secondary_market_transfer_request) | **PUT** /v1/secondary-market/transfer-requests/{id}/accept | 
*SecondaryMarketApi* | [**create_day_ahead_or_intra_day_secondary_market_noticeboard_entry**](docs/SecondaryMarketApi.md#create_day_ahead_or_intra_day_secondary_market_noticeboard_entry) | **POST** /v1/secondary-market/noticeboard/day-ahead-or-intra-day | 
*SecondaryMarketApi* | [**create_day_ahead_or_intra_day_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#create_day_ahead_or_intra_day_secondary_market_transfer_request) | **POST** /v1/secondary-market/transfer-requests/day-ahead-or-intra-day | 
*SecondaryMarketApi* | [**create_day_ahead_or_intraday_secondary_noticeboard_response**](docs/SecondaryMarketApi.md#create_day_ahead_or_intraday_secondary_noticeboard_response) | **POST** /v1/secondary-market/noticeboard/day-ahead-or-intra-day/response | 
*SecondaryMarketApi* | [**create_long_term_secondary_market_noticeboard_entry**](docs/SecondaryMarketApi.md#create_long_term_secondary_market_noticeboard_entry) | **POST** /v1/secondary-market/noticeboard/long-term | 
*SecondaryMarketApi* | [**create_long_term_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#create_long_term_secondary_market_transfer_request) | **POST** /v1/secondary-market/transfer-requests/long-term | 
*SecondaryMarketApi* | [**create_long_term_secondary_noticeboard_response**](docs/SecondaryMarketApi.md#create_long_term_secondary_noticeboard_response) | **POST** /v1/secondary-market/noticeboard/long-term/response | 
*SecondaryMarketApi* | [**create_secondary_market_return_request**](docs/SecondaryMarketApi.md#create_secondary_market_return_request) | **POST** /v1/secondary-market/return-requests | 
*SecondaryMarketApi* | [**delete_noticeboard_entry**](docs/SecondaryMarketApi.md#delete_noticeboard_entry) | **DELETE** /v1/secondary-market/noticeboard/{id} | 
*SecondaryMarketApi* | [**get_day_ahead_or_intra_day_secondary_market_noticeboard_entry**](docs/SecondaryMarketApi.md#get_day_ahead_or_intra_day_secondary_market_noticeboard_entry) | **GET** /v1/secondary-market/noticeboard/day-ahead-or-intra-day/{id} | 
*SecondaryMarketApi* | [**get_day_ahead_or_intra_day_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#get_day_ahead_or_intra_day_secondary_market_transfer_request) | **GET** /v1/secondary-market/transfer-requests/{id}/day-ahead-or-intra-day | 
*SecondaryMarketApi* | [**get_day_ahead_or_intra_day_secondary_market_transfer_request_options**](docs/SecondaryMarketApi.md#get_day_ahead_or_intra_day_secondary_market_transfer_request_options) | **GET** /v1/secondary-market/transfer-requests/day-ahead-or-intra-day/options | 
*SecondaryMarketApi* | [**get_day_ahead_or_intraday_secondary_market_noticeboard_options**](docs/SecondaryMarketApi.md#get_day_ahead_or_intraday_secondary_market_noticeboard_options) | **GET** /v1/secondary-market/noticeboard/day-ahead-or-intra-day/options | 
*SecondaryMarketApi* | [**get_day_ahead_or_intraday_secondary_market_noticeboard_response_options**](docs/SecondaryMarketApi.md#get_day_ahead_or_intraday_secondary_market_noticeboard_response_options) | **GET** /v1/secondary-market/noticeboard/day-ahead-or-intra-day/response/options | 
*SecondaryMarketApi* | [**get_long_term_secondary_market_noticeboard_entry**](docs/SecondaryMarketApi.md#get_long_term_secondary_market_noticeboard_entry) | **GET** /v1/secondary-market/noticeboard/long-term/{id} | 
*SecondaryMarketApi* | [**get_long_term_secondary_market_noticeboard_options**](docs/SecondaryMarketApi.md#get_long_term_secondary_market_noticeboard_options) | **GET** /v1/secondary-market/noticeboard/long-term/options | 
*SecondaryMarketApi* | [**get_long_term_secondary_market_noticeboard_response_options**](docs/SecondaryMarketApi.md#get_long_term_secondary_market_noticeboard_response_options) | **GET** /v1/secondary-market/noticeboard/long-term/response/options | 
*SecondaryMarketApi* | [**get_long_term_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#get_long_term_secondary_market_transfer_request) | **GET** /v1/secondary-market/transfer-requests/{id}/long-term | 
*SecondaryMarketApi* | [**get_long_term_secondary_market_transfer_request_options**](docs/SecondaryMarketApi.md#get_long_term_secondary_market_transfer_request_options) | **GET** /v1/secondary-market/transfer-requests/long-term/options | 
*SecondaryMarketApi* | [**get_secondary_market_noticeboard**](docs/SecondaryMarketApi.md#get_secondary_market_noticeboard) | **GET** /v1/secondary-market/noticeboard | 
*SecondaryMarketApi* | [**get_secondary_market_return_request_options**](docs/SecondaryMarketApi.md#get_secondary_market_return_request_options) | **GET** /v1/secondary-market/return-requests/options | 
*SecondaryMarketApi* | [**get_secondary_market_return_requests**](docs/SecondaryMarketApi.md#get_secondary_market_return_requests) | **GET** /v1/secondary-market/return-requests | 
*SecondaryMarketApi* | [**get_secondary_market_transfer_requests**](docs/SecondaryMarketApi.md#get_secondary_market_transfer_requests) | **GET** /v1/secondary-market/transfer-requests | 
*SecondaryMarketApi* | [**reject_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#reject_secondary_market_transfer_request) | **PUT** /v1/secondary-market/transfer-requests/{id}/reject | 
*SecondaryMarketApi* | [**withdraw_secondary_market_return_request**](docs/SecondaryMarketApi.md#withdraw_secondary_market_return_request) | **PUT** /v1/secondary-market/return-requests/{id}/withdraw | 
*SecondaryMarketApi* | [**withdraw_secondary_market_transfer_request**](docs/SecondaryMarketApi.md#withdraw_secondary_market_transfer_request) | **PUT** /v1/secondary-market/transfer-requests/{id}/withdraw | 
*TransmissionRightApi* | [**get_transmission_rights_overview**](docs/TransmissionRightApi.md#get_transmission_rights_overview) | **GET** /v1/transmission-rights/overview | 
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /v1/users/{id} | 
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /v1/users | 
*UserApi* | [**suspend_user**](docs/UserApi.md#suspend_user) | **PUT** /v1/users/{id}/suspend | 
*UserApi* | [**unsuspend_user**](docs/UserApi.md#unsuspend_user) | **PUT** /v1/users/{id}/unsuspend | 
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /v1/users/{id} | 


## Documentation For Models

 - [Address](docs/Address.md)
 - [AggregatedAllocatedAuction](docs/AggregatedAllocatedAuction.md)
 - [AggregatedNominationOptions](docs/AggregatedNominationOptions.md)
 - [AggregatedNominationOptionsNomineeParticipantsInner](docs/AggregatedNominationOptionsNomineeParticipantsInner.md)
 - [AggregatedNominationType](docs/AggregatedNominationType.md)
 - [AggregatedNominations](docs/AggregatedNominations.md)
 - [AggregatedNominationsMnsOrGb](docs/AggregatedNominationsMnsOrGb.md)
 - [AggregatedNominationsMnsOrGbMtusInner](docs/AggregatedNominationsMnsOrGbMtusInner.md)
 - [AggregatedNominationsMtuNettedNominations](docs/AggregatedNominationsMtuNettedNominations.md)
 - [AggregatedNominationsMtuValue](docs/AggregatedNominationsMtuValue.md)
 - [AggregatedNominationsNl](docs/AggregatedNominationsNl.md)
 - [AggregatedNominationsNlMtusInner](docs/AggregatedNominationsNlMtusInner.md)
 - [AggregatedNominationsNlMtusInnerEprogramValues](docs/AggregatedNominationsNlMtusInnerEprogramValues.md)
 - [AllocatedAuction](docs/AllocatedAuction.md)
 - [AllocatedAuctionBatch](docs/AllocatedAuctionBatch.md)
 - [AllocatedAuctionSortBy](docs/AllocatedAuctionSortBy.md)
 - [ApiKey](docs/ApiKey.md)
 - [Attachment](docs/Attachment.md)
 - [Auction](docs/Auction.md)
 - [AuctionAllocationResolution](docs/AuctionAllocationResolution.md)
 - [AuctionBatch](docs/AuctionBatch.md)
 - [AuctionBidParticipant](docs/AuctionBidParticipant.md)
 - [AuctionBidStatus](docs/AuctionBidStatus.md)
 - [AuctionBiddingConfiguration](docs/AuctionBiddingConfiguration.md)
 - [AuctionBiddingMode](docs/AuctionBiddingMode.md)
 - [AuctionIntraDayProductType](docs/AuctionIntraDayProductType.md)
 - [AuctionProcessStepsAbsolute](docs/AuctionProcessStepsAbsolute.md)
 - [AuctionProductType](docs/AuctionProductType.md)
 - [AuctionReductionPeriod](docs/AuctionReductionPeriod.md)
 - [AuctionResultCongestionRent](docs/AuctionResultCongestionRent.md)
 - [AuctionResultParticipant](docs/AuctionResultParticipant.md)
 - [AuctionSortBy](docs/AuctionSortBy.md)
 - [AuctionStatus](docs/AuctionStatus.md)
 - [AuctionTimescale](docs/AuctionTimescale.md)
 - [AuditLog](docs/AuditLog.md)
 - [AuditLogApiKey](docs/AuditLogApiKey.md)
 - [AuditLogBatch](docs/AuditLogBatch.md)
 - [AuditLogDomain](docs/AuditLogDomain.md)
 - [AuditLogPayload](docs/AuditLogPayload.md)
 - [AuditLogSortBy](docs/AuditLogSortBy.md)
 - [AuditLogStatus](docs/AuditLogStatus.md)
 - [AuditLogType](docs/AuditLogType.md)
 - [AuditLogUser](docs/AuditLogUser.md)
 - [AuditLogUserOrganisation](docs/AuditLogUserOrganisation.md)
 - [BidValue](docs/BidValue.md)
 - [BiddingConfiguration](docs/BiddingConfiguration.md)
 - [BiddingConfigurationPerDirection](docs/BiddingConfigurationPerDirection.md)
 - [BiddingConfigurationSecondaryMarketNotices](docs/BiddingConfigurationSecondaryMarketNotices.md)
 - [BiddingConfigurationValuesInner](docs/BiddingConfigurationValuesInner.md)
 - [BorderDirection](docs/BorderDirection.md)
 - [BorderDirectionWithBoth](docs/BorderDirectionWithBoth.md)
 - [BorderDirectionWithBothAndNone](docs/BorderDirectionWithBothAndNone.md)
 - [BuyNowDayAheadOfferSortBy](docs/BuyNowDayAheadOfferSortBy.md)
 - [BuyNowOffer](docs/BuyNowOffer.md)
 - [BuyNowOfferMtusInner](docs/BuyNowOfferMtusInner.md)
 - [BuyNowOfferStatus](docs/BuyNowOfferStatus.md)
 - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [CreateDayAheadOrIntraDayDefaultBidRequest](docs/CreateDayAheadOrIntraDayDefaultBidRequest.md)
 - [CreateDayAheadOrIntraDayDefaultBidRequestBidsInner](docs/CreateDayAheadOrIntraDayDefaultBidRequestBidsInner.md)
 - [CreateDayAheadOrIntraDayDefaultBidRequestBidsInnerMtusInner](docs/CreateDayAheadOrIntraDayDefaultBidRequestBidsInnerMtusInner.md)
 - [CreateDefaultNominationRequest](docs/CreateDefaultNominationRequest.md)
 - [CreateLongTermDefaultBidRequest](docs/CreateLongTermDefaultBidRequest.md)
 - [CreateOrganisationDocumentRequest](docs/CreateOrganisationDocumentRequest.md)
 - [CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry](docs/CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry.md)
 - [CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse](docs/CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse.md)
 - [CreateSecondaryMarketDayAheadOrIntraDayTransferRequest](docs/CreateSecondaryMarketDayAheadOrIntraDayTransferRequest.md)
 - [CreateSecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner](docs/CreateSecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner.md)
 - [CreateSecondaryMarketLongTermNoticeboardEntry](docs/CreateSecondaryMarketLongTermNoticeboardEntry.md)
 - [CreateSecondaryMarketLongTermNoticeboardResponse](docs/CreateSecondaryMarketLongTermNoticeboardResponse.md)
 - [CreateSecondaryMarketLongTermTransferRequest](docs/CreateSecondaryMarketLongTermTransferRequest.md)
 - [CreateSecondaryMarketReturnRequest](docs/CreateSecondaryMarketReturnRequest.md)
 - [CreatedApiKey](docs/CreatedApiKey.md)
 - [CreatedDefaultBid](docs/CreatedDefaultBid.md)
 - [CreatedDefaultNomination](docs/CreatedDefaultNomination.md)
 - [CreatedOrganisationDocument](docs/CreatedOrganisationDocument.md)
 - [CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry](docs/CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry.md)
 - [CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse](docs/CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse.md)
 - [CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest](docs/CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest.md)
 - [CreatedSecondaryMarketLongTermNoticeboardEntry](docs/CreatedSecondaryMarketLongTermNoticeboardEntry.md)
 - [CreatedSecondaryMarketLongTermNoticeboardResponse](docs/CreatedSecondaryMarketLongTermNoticeboardResponse.md)
 - [CreatedSecondaryMarketLongTermTransferRequest](docs/CreatedSecondaryMarketLongTermTransferRequest.md)
 - [CreatedSecondaryMarketReturnRequestIdentifier](docs/CreatedSecondaryMarketReturnRequestIdentifier.md)
 - [DashboardNextNominationGate](docs/DashboardNextNominationGate.md)
 - [DashboardNextNominationGateWindow](docs/DashboardNextNominationGateWindow.md)
 - [DashboardNextNominationWindowStatus](docs/DashboardNextNominationWindowStatus.md)
 - [DatePeriod](docs/DatePeriod.md)
 - [DateTimePeriod](docs/DateTimePeriod.md)
 - [DayAheadAuction](docs/DayAheadAuction.md)
 - [DayAheadOrIntraDayAuctionBidGroup](docs/DayAheadOrIntraDayAuctionBidGroup.md)
 - [DayAheadOrIntraDayAuctionBidGroupBatch](docs/DayAheadOrIntraDayAuctionBidGroupBatch.md)
 - [DayAheadOrIntraDayAuctionBidGroupBidsInner](docs/DayAheadOrIntraDayAuctionBidGroupBidsInner.md)
 - [DayAheadOrIntraDayAuctionBidGroupBidsInnerValue](docs/DayAheadOrIntraDayAuctionBidGroupBidsInnerValue.md)
 - [DayAheadOrIntraDayAuctionMtu](docs/DayAheadOrIntraDayAuctionMtu.md)
 - [DayAheadOrIntraDayAuctionMtuResults](docs/DayAheadOrIntraDayAuctionMtuResults.md)
 - [DayAheadOrIntraDayAuctionMtuResultsBidsInner](docs/DayAheadOrIntraDayAuctionMtuResultsBidsInner.md)
 - [DayAheadOrIntraDayAuctionParticipantResults](docs/DayAheadOrIntraDayAuctionParticipantResults.md)
 - [DayAheadOrIntraDayAuctionParticipantResultsMtusInner](docs/DayAheadOrIntraDayAuctionParticipantResultsMtusInner.md)
 - [DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue](docs/DayAheadOrIntraDayAuctionParticipantResultsMtusInnerValue.md)
 - [DayAheadOrIntraDayAuctionResults](docs/DayAheadOrIntraDayAuctionResults.md)
 - [DayAheadOrIntraDayAuctionResultsMtu](docs/DayAheadOrIntraDayAuctionResultsMtu.md)
 - [DayAheadOrIntraDayDefaultBid](docs/DayAheadOrIntraDayDefaultBid.md)
 - [DefaultBid](docs/DefaultBid.md)
 - [DefaultBidBatch](docs/DefaultBidBatch.md)
 - [DefaultBidOptions](docs/DefaultBidOptions.md)
 - [DefaultBidSortBy](docs/DefaultBidSortBy.md)
 - [DefaultBidStatus](docs/DefaultBidStatus.md)
 - [DefaultNomination](docs/DefaultNomination.md)
 - [DefaultNominationBatch](docs/DefaultNominationBatch.md)
 - [DefaultNominationDeclarationType](docs/DefaultNominationDeclarationType.md)
 - [DefaultNominationDetails](docs/DefaultNominationDetails.md)
 - [DefaultNominationMtu](docs/DefaultNominationMtu.md)
 - [DefaultNominationOptions](docs/DefaultNominationOptions.md)
 - [DefaultNominationSortBy](docs/DefaultNominationSortBy.md)
 - [DefaultNominationStatus](docs/DefaultNominationStatus.md)
 - [ErrorCode](docs/ErrorCode.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FinanceInformation](docs/FinanceInformation.md)
 - [FinanceInformationBankDepositsInner](docs/FinanceInformationBankDepositsInner.md)
 - [FinanceInformationLetterOfCreditsInner](docs/FinanceInformationLetterOfCreditsInner.md)
 - [FinanceInformationLockableAmount](docs/FinanceInformationLockableAmount.md)
 - [FinanceInformationLockableDate](docs/FinanceInformationLockableDate.md)
 - [FinanceInformationLockablePeriod](docs/FinanceInformationLockablePeriod.md)
 - [FinanceInformationMarketVatDetails](docs/FinanceInformationMarketVatDetails.md)
 - [FinanceInformationSageSettings](docs/FinanceInformationSageSettings.md)
 - [IntraDayAuction](docs/IntraDayAuction.md)
 - [Invoice](docs/Invoice.md)
 - [InvoiceActionType](docs/InvoiceActionType.md)
 - [InvoiceBatch](docs/InvoiceBatch.md)
 - [InvoiceDetails](docs/InvoiceDetails.md)
 - [InvoiceHistory](docs/InvoiceHistory.md)
 - [InvoiceLineItem](docs/InvoiceLineItem.md)
 - [InvoiceParticipantDetails](docs/InvoiceParticipantDetails.md)
 - [InvoiceStatus](docs/InvoiceStatus.md)
 - [InvoiceSummary](docs/InvoiceSummary.md)
 - [InvoiceVatRate](docs/InvoiceVatRate.md)
 - [LongTermAuction](docs/LongTermAuction.md)
 - [LongTermAuctionBid](docs/LongTermAuctionBid.md)
 - [LongTermAuctionBidBatch](docs/LongTermAuctionBidBatch.md)
 - [LongTermAuctionBidSortBy](docs/LongTermAuctionBidSortBy.md)
 - [LongTermAuctionResults](docs/LongTermAuctionResults.md)
 - [LongTermAuctionResultsAllocatedCapacityInner](docs/LongTermAuctionResultsAllocatedCapacityInner.md)
 - [LongTermBiddingResults](docs/LongTermBiddingResults.md)
 - [LongTermDefaultBid](docs/LongTermDefaultBid.md)
 - [LongTermOfferedCapacity](docs/LongTermOfferedCapacity.md)
 - [LongTermReservePrice](docs/LongTermReservePrice.md)
 - [LongTermReservePriceStepsInner](docs/LongTermReservePriceStepsInner.md)
 - [ManualFileUploadRequest](docs/ManualFileUploadRequest.md)
 - [Market](docs/Market.md)
 - [Message](docs/Message.md)
 - [MessageBatch](docs/MessageBatch.md)
 - [MessageCategory](docs/MessageCategory.md)
 - [MessageSender](docs/MessageSender.md)
 - [MessageSeverity](docs/MessageSeverity.md)
 - [MessageSortBy](docs/MessageSortBy.md)
 - [MessageType](docs/MessageType.md)
 - [MtuPeriod](docs/MtuPeriod.md)
 - [MtuSize](docs/MtuSize.md)
 - [MtuSizePerAuctionProductType](docs/MtuSizePerAuctionProductType.md)
 - [MtuSizePerTimescale](docs/MtuSizePerTimescale.md)
 - [NestedError](docs/NestedError.md)
 - [NominationCapacityResolution](docs/NominationCapacityResolution.md)
 - [NominationRestrictionType](docs/NominationRestrictionType.md)
 - [NoticeboardEntryType](docs/NoticeboardEntryType.md)
 - [NoticeboardEntryTypeWithBoth](docs/NoticeboardEntryTypeWithBoth.md)
 - [NotificationPreference](docs/NotificationPreference.md)
 - [NotificationPreferenceWithSms](docs/NotificationPreferenceWithSms.md)
 - [NtcOverviewMtuData](docs/NtcOverviewMtuData.md)
 - [OfferedCapacitySetup](docs/OfferedCapacitySetup.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationAuthMethod](docs/OrganisationAuthMethod.md)
 - [OrganisationContact](docs/OrganisationContact.md)
 - [OrganisationContactInformation](docs/OrganisationContactInformation.md)
 - [OrganisationDocument](docs/OrganisationDocument.md)
 - [OrganisationDocumentBatch](docs/OrganisationDocumentBatch.md)
 - [OrganisationDocumentFileType](docs/OrganisationDocumentFileType.md)
 - [OrganisationDocumentOptions](docs/OrganisationDocumentOptions.md)
 - [OrganisationDocumentOrganisation](docs/OrganisationDocumentOrganisation.md)
 - [OrganisationDocumentSortBy](docs/OrganisationDocumentSortBy.md)
 - [OrganisationDocumentStatus](docs/OrganisationDocumentStatus.md)
 - [OrganisationDocumentUploadedByUser](docs/OrganisationDocumentUploadedByUser.md)
 - [OrganisationDocumentUser](docs/OrganisationDocumentUser.md)
 - [OrganisationFileSettings](docs/OrganisationFileSettings.md)
 - [OrganisationMarketSettings](docs/OrganisationMarketSettings.md)
 - [OrganisationMarketSettingsGbNominationSettings](docs/OrganisationMarketSettingsGbNominationSettings.md)
 - [OrganisationMarketSettingsNlNominationSettings](docs/OrganisationMarketSettingsNlNominationSettings.md)
 - [OrganisationStatus](docs/OrganisationStatus.md)
 - [OrganisationType](docs/OrganisationType.md)
 - [OrganisationUser](docs/OrganisationUser.md)
 - [OrganisationUserBatch](docs/OrganisationUserBatch.md)
 - [OrganisationUserSortBy](docs/OrganisationUserSortBy.md)
 - [OtherParty](docs/OtherParty.md)
 - [Participant](docs/Participant.md)
 - [ParticipantDashboardDefaultBidsAndNominationsData](docs/ParticipantDashboardDefaultBidsAndNominationsData.md)
 - [ParticipantDashboardFinanceOverviewData](docs/ParticipantDashboardFinanceOverviewData.md)
 - [ParticipantDashboardFinanceOverviewInvoice](docs/ParticipantDashboardFinanceOverviewInvoice.md)
 - [ParticipantDashboardInterconnectorCapacityData](docs/ParticipantDashboardInterconnectorCapacityData.md)
 - [ParticipantDashboardInterconnectorCapacityDataMtusInner](docs/ParticipantDashboardInterconnectorCapacityDataMtusInner.md)
 - [ParticipantDashboardInterconnectorCapacityDataMtusInnerValuesInner](docs/ParticipantDashboardInterconnectorCapacityDataMtusInnerValuesInner.md)
 - [ParticipantDashboardInterconnectorCapacityGraphData](docs/ParticipantDashboardInterconnectorCapacityGraphData.md)
 - [ParticipantDashboardInterconnectorCapacityGraphDataMtusInner](docs/ParticipantDashboardInterconnectorCapacityGraphDataMtusInner.md)
 - [ParticipantDashboardInterconnectorCapacityGraphDataMtusInnerNettedNominations](docs/ParticipantDashboardInterconnectorCapacityGraphDataMtusInnerNettedNominations.md)
 - [ParticipantDashboardInterconnectorCapacityGraphDataMtusInnerValuesInner](docs/ParticipantDashboardInterconnectorCapacityGraphDataMtusInnerValuesInner.md)
 - [ParticipantDashboardMessages](docs/ParticipantDashboardMessages.md)
 - [ParticipantDashboardNettedNominationsData](docs/ParticipantDashboardNettedNominationsData.md)
 - [ParticipantDashboardNettedNominationsDataMtusInner](docs/ParticipantDashboardNettedNominationsDataMtusInner.md)
 - [ParticipantDashboardNettedNominationsDataMtusInnerAggregatedNominationsInner](docs/ParticipantDashboardNettedNominationsDataMtusInnerAggregatedNominationsInner.md)
 - [ParticipantDashboardNettedNominationsDataMtusInnerNettedNominations](docs/ParticipantDashboardNettedNominationsDataMtusInnerNettedNominations.md)
 - [ParticipantDashboardNextAuction](docs/ParticipantDashboardNextAuction.md)
 - [ParticipantDashboardNextAuctionsAndNominationGates](docs/ParticipantDashboardNextAuctionsAndNominationGates.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsData](docs/ParticipantDashboardTransmissionRightsAndNominationsData.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsDataMtusInner](docs/ParticipantDashboardTransmissionRightsAndNominationsDataMtusInner.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner](docs/ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInner.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInnerNominationRestriction](docs/ParticipantDashboardTransmissionRightsAndNominationsDataMtusInnerValuesInnerNominationRestriction.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsGraphData](docs/ParticipantDashboardTransmissionRightsAndNominationsGraphData.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsGraphDataMtusInner](docs/ParticipantDashboardTransmissionRightsAndNominationsGraphDataMtusInner.md)
 - [ParticipantDashboardTransmissionRightsAndNominationsGraphDataMtusInnerValuesInner](docs/ParticipantDashboardTransmissionRightsAndNominationsGraphDataMtusInnerValuesInner.md)
 - [ParticipantOrganisationDetails](docs/ParticipantOrganisationDetails.md)
 - [ParticipantOverviewData](docs/ParticipantOverviewData.md)
 - [ParticipantOverviewDataContactInformation](docs/ParticipantOverviewDataContactInformation.md)
 - [ParticipantOverviewDataFinanceOverview](docs/ParticipantOverviewDataFinanceOverview.md)
 - [ParticipantOverviewDataOrganisationMembers](docs/ParticipantOverviewDataOrganisationMembers.md)
 - [Permission](docs/Permission.md)
 - [PlatformAppearance](docs/PlatformAppearance.md)
 - [Profile](docs/Profile.md)
 - [ProfileDetails](docs/ProfileDetails.md)
 - [ProfileUser](docs/ProfileUser.md)
 - [ProfileUserOrganisation](docs/ProfileUserOrganisation.md)
 - [PublicAggregatedNominationsOverviewResponse](docs/PublicAggregatedNominationsOverviewResponse.md)
 - [PublicAggregatedNominationsOverviewResponseMtusInner](docs/PublicAggregatedNominationsOverviewResponseMtusInner.md)
 - [PublicAggregatedNominationsOverviewResponseMtusInnerValuesInner](docs/PublicAggregatedNominationsOverviewResponseMtusInnerValuesInner.md)
 - [PublicAuction](docs/PublicAuction.md)
 - [PublicAuctionBatch](docs/PublicAuctionBatch.md)
 - [PublicAuctionBidStatus](docs/PublicAuctionBidStatus.md)
 - [PublicAuctionStatus](docs/PublicAuctionStatus.md)
 - [PublicDayAheadAuction](docs/PublicDayAheadAuction.md)
 - [PublicDayAheadOrIntraDayAuctionMtuResults](docs/PublicDayAheadOrIntraDayAuctionMtuResults.md)
 - [PublicDayAheadOrIntraDayAuctionMtuResultsBidsInner](docs/PublicDayAheadOrIntraDayAuctionMtuResultsBidsInner.md)
 - [PublicDayAheadOrIntraDayAuctionResults](docs/PublicDayAheadOrIntraDayAuctionResults.md)
 - [PublicIntraDayAuction](docs/PublicIntraDayAuction.md)
 - [PublicLongTermAuction](docs/PublicLongTermAuction.md)
 - [PublicLongTermAuctionResults](docs/PublicLongTermAuctionResults.md)
 - [PurchasedByOrganisation](docs/PurchasedByOrganisation.md)
 - [ReservePricePublishType](docs/ReservePricePublishType.md)
 - [ReturnAuction](docs/ReturnAuction.md)
 - [SageCode](docs/SageCode.md)
 - [SecondaryMarketCapacityPriceMtu](docs/SecondaryMarketCapacityPriceMtu.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardEntry](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardEntry.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardEntryDetails.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponse.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponseMtusInner](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardEntryResponseMtusInner.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardOptions](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardOptions.md)
 - [SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions](docs/SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions.md)
 - [SecondaryMarketDayAheadOrIntraDayTransferRequest](docs/SecondaryMarketDayAheadOrIntraDayTransferRequest.md)
 - [SecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner](docs/SecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner.md)
 - [SecondaryMarketDayAheadOrIntraDayTransferRequestOptions](docs/SecondaryMarketDayAheadOrIntraDayTransferRequestOptions.md)
 - [SecondaryMarketDayAheadOrIntraDayTransferRequestOptionsMtusInner](docs/SecondaryMarketDayAheadOrIntraDayTransferRequestOptionsMtusInner.md)
 - [SecondaryMarketLongTermNoticeboardEntry](docs/SecondaryMarketLongTermNoticeboardEntry.md)
 - [SecondaryMarketLongTermNoticeboardEntryDetails](docs/SecondaryMarketLongTermNoticeboardEntryDetails.md)
 - [SecondaryMarketLongTermNoticeboardEntryResponse](docs/SecondaryMarketLongTermNoticeboardEntryResponse.md)
 - [SecondaryMarketLongTermNoticeboardOptions](docs/SecondaryMarketLongTermNoticeboardOptions.md)
 - [SecondaryMarketLongTermNoticeboardResponseOptions](docs/SecondaryMarketLongTermNoticeboardResponseOptions.md)
 - [SecondaryMarketLongTermTransferRequestOptions](docs/SecondaryMarketLongTermTransferRequestOptions.md)
 - [SecondaryMarketNoticeboardEntry](docs/SecondaryMarketNoticeboardEntry.md)
 - [SecondaryMarketNoticeboardEntryBatch](docs/SecondaryMarketNoticeboardEntryBatch.md)
 - [SecondaryMarketNoticeboardEntryStatus](docs/SecondaryMarketNoticeboardEntryStatus.md)
 - [SecondaryMarketReturnRequest](docs/SecondaryMarketReturnRequest.md)
 - [SecondaryMarketReturnRequestBatch](docs/SecondaryMarketReturnRequestBatch.md)
 - [SecondaryMarketReturnRequestStatus](docs/SecondaryMarketReturnRequestStatus.md)
 - [SecondaryMarketTransferRequest](docs/SecondaryMarketTransferRequest.md)
 - [SecondaryMarketTransferRequestBatch](docs/SecondaryMarketTransferRequestBatch.md)
 - [SecondaryMarketTransferRequestStatus](docs/SecondaryMarketTransferRequestStatus.md)
 - [SecondaryMarketTransferRequestType](docs/SecondaryMarketTransferRequestType.md)
 - [SecondaryMarketTransferTransmissionRightsMtu](docs/SecondaryMarketTransferTransmissionRightsMtu.md)
 - [Settlement](docs/Settlement.md)
 - [SettlementItem](docs/SettlementItem.md)
 - [SettlementPerSource](docs/SettlementPerSource.md)
 - [SettlementSourceType](docs/SettlementSourceType.md)
 - [SettlementSubSourceType](docs/SettlementSubSourceType.md)
 - [SourceAuction](docs/SourceAuction.md)
 - [SourceAuctionDisplayData](docs/SourceAuctionDisplayData.md)
 - [SourceAuctionResult](docs/SourceAuctionResult.md)
 - [SubmitDayAheadOrIntraDayBidsRequest](docs/SubmitDayAheadOrIntraDayBidsRequest.md)
 - [SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner](docs/SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner.md)
 - [SubmitDayAheadOrIntraDayBidsRequestBidGroupsInnerBidsInner](docs/SubmitDayAheadOrIntraDayBidsRequestBidGroupsInnerBidsInner.md)
 - [SubmitLongTermBidsRequest](docs/SubmitLongTermBidsRequest.md)
 - [SubmitLongTermBidsRequestBidsInner](docs/SubmitLongTermBidsRequestBidsInner.md)
 - [SubmitNominationsMtu](docs/SubmitNominationsMtu.md)
 - [SubmitTimescaleNominationsRequest](docs/SubmitTimescaleNominationsRequest.md)
 - [SystemMessageCategory](docs/SystemMessageCategory.md)
 - [TimescaleNominationMtuStatus](docs/TimescaleNominationMtuStatus.md)
 - [TimescaleNominationOptions](docs/TimescaleNominationOptions.md)
 - [TimescaleNominationOptionsWindowTiming](docs/TimescaleNominationOptionsWindowTiming.md)
 - [TimescaleNominationStatus](docs/TimescaleNominationStatus.md)
 - [TimescaleNominationType](docs/TimescaleNominationType.md)
 - [TimescaleNominationWindowStatus](docs/TimescaleNominationWindowStatus.md)
 - [TimescaleNominations](docs/TimescaleNominations.md)
 - [TimescaleNominationsMtusInner](docs/TimescaleNominationsMtusInner.md)
 - [TimescaleNominationsMtusInnerCurrentNomination](docs/TimescaleNominationsMtusInnerCurrentNomination.md)
 - [TransmissionRightsOverview](docs/TransmissionRightsOverview.md)
 - [TransmissionRightsOverviewMtusInner](docs/TransmissionRightsOverviewMtusInner.md)
 - [TransmissionRightsOverviewMtusInnerValuesInner](docs/TransmissionRightsOverviewMtusInnerValuesInner.md)
 - [TransmissionRightsOverviewMtusInnerValuesInnerTimescalesInner](docs/TransmissionRightsOverviewMtusInnerValuesInnerTimescalesInner.md)
 - [UiosiNotResold](docs/UiosiNotResold.md)
 - [UiosiOverview](docs/UiosiOverview.md)
 - [UiosiOverviewPerMtu](docs/UiosiOverviewPerMtu.md)
 - [UiosiResold](docs/UiosiResold.md)
 - [UnreadMessagesResponse](docs/UnreadMessagesResponse.md)
 - [UpdateDayAheadOrIntraDayDefaultBidRequest](docs/UpdateDayAheadOrIntraDayDefaultBidRequest.md)
 - [UpdateDefaultNominationRequest](docs/UpdateDefaultNominationRequest.md)
 - [UpdateLongTermDefaultBidRequest](docs/UpdateLongTermDefaultBidRequest.md)
 - [UpdateProfileDetailsRequest](docs/UpdateProfileDetailsRequest.md)
 - [UpdateUserRequest](docs/UpdateUserRequest.md)
 - [User](docs/User.md)
 - [UserOrganisation](docs/UserOrganisation.md)
 - [UserPreferences](docs/UserPreferences.md)
 - [UserPreferencesGeneralNotifications](docs/UserPreferencesGeneralNotifications.md)
 - [UserPreferencesSubscriptionNotifications](docs/UserPreferencesSubscriptionNotifications.md)
 - [UserRole](docs/UserRole.md)
 - [UserStatus](docs/UserStatus.md)
 - [VatRateType](docs/VatRateType.md)
 - [Version](docs/Version.md)
 - [ZendeskChatTokenResponse](docs/ZendeskChatTokenResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKey"></a>
### ApiKey

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header

<a id="AuthToken"></a>
### AuthToken

- **Type**: Bearer authentication (JWT)


## Author

britned.info@britned.com


