"""
---
title: Reinforcement Learning Algorithms
summary: >
  This is a collection of PyTorch implementations/tutorials of reinforcement learning algorithms.
  It currently includes Proximal Policy Optimization, Generalized Advantage Estimation, and
  Deep Q Networks.
---

# Reinforcement Learning Algorithms

* [Proximal Policy Optimization](ppo)
    * [This is an experiment](ppo/experiment.html) that runs a PPO agent on Atari Breakout.
    * [Generalized advantage estimation](ppo/gae.html)
* [Deep Q Networks](dqn)
    * [This is an experiment](dqn/experiment.html) that runs a DQN agent on Atari Breakout.
    * [Model](dqn/model.html) with dueling network
    * [Prioritized Experience Replay Buffer](dqn/replay_buffer.html)

[This is the implementation for OpenAI game wrapper](game.html) using `multiprocessing`.
"""