# noinspection PyPackageRequirements
import pytest

from bumpsemver.functions import NumericFunction


def test_numeric_init_wo_first_value():
    func = NumericFunction()
    assert func.first_value == '0'


def test_numeric_init_w_first_value():
    func = NumericFunction(first_value='5')
    assert func.first_value == '5'


def test_numeric_init_non_numeric_first_value():
    with pytest.raises(ValueError):
        NumericFunction(first_value='a')


def test_numeric_bump_simple_number():
    func = NumericFunction()
    assert func.bump('0') == '1'


def test_numeric_bump_prefix_and_suffix():
    func = NumericFunction()
    assert func.bump('v0b') == 'v1b'
