"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelfDestruct = void 0;
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
class SelfDestruct extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const selfDestructPolicy = new aws_iam_1.PolicyDocument();
        /** define inline policies */
        const selfDestructPolicyStatements = [
            //temporarily allow ALL
            new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                actions: ["*"],
                resources: ["*"],
            }),
        ];
        selfDestructPolicyStatements.forEach((statement) => selfDestructPolicy.addStatements(statement));
        const selfDestructRole = new iam.Role(this, "SelfDestructLambdaRole", {
            assumedBy: new iam.ServicePrincipal("lambda.amazonaws.com"),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole"),
            ],
            inlinePolicies: {
                policy: selfDestructPolicy,
            },
        });
        const selfDestructLambda = new lambda.SingletonFunction(this, "self-destruct-stack-app", {
            uuid: "6024fd94-c050-11ea-b3de-0242ac130004",
            runtime: lambda.Runtime.PYTHON_3_6,
            role: selfDestructRole,
            handler: "index.handler",
            code: lambda.Code.fromInline(`
import boto3
client = boto3.client('cloudformation')

def handler(event, context):
  print("event['StackName']: "+event['StackName'])
  return client.delete_stack(
    StackName=event['StackName']
  )
            `),
        });
        const rule = new aws_events_1.Rule(this, "SelfDestructRule", {
            schedule: aws_events_1.Schedule.rate(props.timeToLive),
        });
        selfDestructLambda.addPermission("allowEventsPermission", {
            action: "lambda:InvokeFunction",
            principal: new iam.ServicePrincipal("events.amazonaws.com"),
            sourceArn: rule.ruleArn,
        });
        var params = {
            StackName: cdk.Aws.STACK_NAME,
        };
        rule.addTarget(new aws_events_targets_1.LambdaFunction(selfDestructLambda, {
            event: aws_events_1.RuleTargetInput.fromObject(params),
        }));
    }
}
exports.SelfDestruct = SelfDestruct;
//# sourceMappingURL=data:application/json;base64,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