"""Capture some basic information about the computing environment.

Taken from https://gist.github.com/tahajahangir/5275848#file-pyinfo-py
"""

import platform
import sys


def section_packages():
    data = []
    try:
        import pkg_resources
    except ImportError:
        return None
    for pkg in pkg_resources.working_set:
        assert isinstance(pkg, pkg_resources.Distribution)
        data.append((pkg.project_name, pkg.version if pkg.has_version() else "[uknown]"))
    return dict(sorted(data, key=lambda a: a[0].lower()))


def section_system():
    data = []
    if hasattr(sys, "subversion"):
        data.append(("Python Subversion", ", ".join(x for x in sys.subversion if x)))

        data.append(
            (
                "OS Version",
                "%s %s (%s %s)"
                % (
                    platform.system(),
                    platform.release(),
                    platform.dist()[0].capitalize(),
                    platform.dist()[1],
                ),
            )
        )
    else:
        data.append(("OS Version", "%s %s" % (platform.system(), platform.release())))
    if hasattr(sys, "executable"):
        data.append(("Executable", sys.executable))
    data.append(("Build Date", platform.python_build()[1]))
    data.append(("Compiler", platform.python_compiler()))
    if hasattr(sys, "api_version"):
        data.append(("Python API", sys.api_version))
    return dict(data)


def get_watermark():
    return {
        "packages": section_packages(),
        "system": section_system(),
    }
