from zodipy._component_labels import ComponentLabel

K98 = {
    ComponentLabel.CLOUD: dict(
        x_0=0.0119,
        y_0=0.00548,
        z_0=-0.00215,
        i=2.03,
        Ω=77.7,
        n_0=1.13e-7,
        α=1.34,
        β=4.14,
        γ=0.942,
        μ=0.189,
    ),
    ComponentLabel.BAND1: dict(
        x_0=0.0,
        y_0=0.0,
        z_0=0.0,
        i=0.56,
        Ω=80.0,
        n_0=5.59e-10,
        δ_ζ=8.78,
        v=0.1,
        p=4.0,
        δ_r=1.5,
    ),
    ComponentLabel.BAND2: dict(
        x_0=0.0,
        y_0=0.0,
        z_0=0.0,
        i=1.2,
        Ω=30.3,
        n_0=1.99e-9,
        δ_ζ=1.99,
        v=0.9,
        p=4.0,
        δ_r=1.2,
    ),
    ComponentLabel.BAND3: dict(
        x_0=0.0,
        y_0=0.0,
        z_0=0.0,
        i=0.8,
        Ω=80.0,
        n_0=1.44e-10,
        δ_ζ=15,
        v=0.05,
        p=4.0,
        δ_r=1.5,
    ),
    ComponentLabel.RING: dict(
        x_0=0.0,
        y_0=0.0,
        z_0=0.0,
        i=0.49,
        Ω=22.3,
        n_0=1.83e-8,
        R=1.03,
        σ_r=0.025,
        σ_z=0.054,
    ),
    ComponentLabel.FEATURE: dict(
        x_0=0.0,
        y_0=0.0,
        z_0=0.0,
        i=0.0,
        Ω=0.0,
        n_0=1.9e-8,
        R=1.06,
        σ_r=0.10,
        σ_z=0.091,
        θ=-10.0,
        σ_θ=12.1,
    ),
}

PLANCK = K98.copy()
PLANCK.pop(ComponentLabel.RING)
PLANCK.pop(ComponentLabel.FEATURE)
