# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AllowedConfigListArgs',
    'AllowedSubjectAltNamesArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'CaOptionsArgs',
    'CertificateAuthorityPolicyArgs',
    'CertificateConfigArgs',
    'ExprArgs',
    'ExtendedKeyUsageOptionsArgs',
    'IssuanceModesArgs',
    'IssuingOptionsArgs',
    'KeyUsageArgs',
    'KeyUsageOptionsArgs',
    'KeyVersionSpecArgs',
    'ObjectIdArgs',
    'PublicKeyArgs',
    'ReusableConfigValuesArgs',
    'ReusableConfigWrapperArgs',
    'SubjectArgs',
    'SubjectAltNamesArgs',
    'SubjectConfigArgs',
    'SubordinateConfigArgs',
    'SubordinateConfigChainArgs',
    'X509ExtensionArgs',
]

@pulumi.input_type
class AllowedConfigListArgs:
    def __init__(__self__, *,
                 allowed_config_values: Optional[pulumi.Input[Sequence[pulumi.Input['ReusableConfigWrapperArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReusableConfigWrapperArgs']]] allowed_config_values: Required. All Certificates issued by the CertificateAuthority must match at least one listed ReusableConfigWrapper. If a ReusableConfigWrapper has an empty field, any value will be allowed for that field.
        """
        if allowed_config_values is not None:
            pulumi.set(__self__, "allowed_config_values", allowed_config_values)

    @property
    @pulumi.getter(name="allowedConfigValues")
    def allowed_config_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReusableConfigWrapperArgs']]]]:
        """
        Required. All Certificates issued by the CertificateAuthority must match at least one listed ReusableConfigWrapper. If a ReusableConfigWrapper has an empty field, any value will be allowed for that field.
        """
        return pulumi.get(self, "allowed_config_values")

    @allowed_config_values.setter
    def allowed_config_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReusableConfigWrapperArgs']]]]):
        pulumi.set(self, "allowed_config_values", value)


@pulumi.input_type
class AllowedSubjectAltNamesArgs:
    def __init__(__self__, *,
                 allow_custom_sans: Optional[pulumi.Input[bool]] = None,
                 allow_globbing_dns_wildcards: Optional[pulumi.Input[bool]] = None,
                 allowed_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        AllowedSubjectAltNames specifies the allowed values for SubjectAltNames by the CertificateAuthority when issuing Certificates.
        :param pulumi.Input[bool] allow_custom_sans: Optional. Specifies if to allow custom X509Extension values.
        :param pulumi.Input[bool] allow_globbing_dns_wildcards: Optional. Specifies if glob patterns used for allowed_dns_names allow wildcard certificates. If this is set, certificate requests with wildcard domains will be permitted to match a glob pattern specified in allowed_dns_names. Otherwise, certificate requests with wildcard domains will be permitted only if allowed_dns_names contains a literal wildcard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_dns_names: Optional. Contains valid, fully-qualified host names. Glob patterns are also supported. To allow an explicit wildcard certificate, escape with backlash (i.e. "\*"). E.g. for globbed entries: '*bar.com' will allow 'foo.bar.com', but not '*.bar.com', unless the allow_globbing_dns_wildcards field is set. E.g. for wildcard entries: '\*.bar.com' will allow '*.bar.com', but not 'foo.bar.com'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_email_addresses: Optional. Contains valid RFC 2822 E-mail addresses. Glob patterns are also supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ips: Optional. Contains valid 32-bit IPv4 addresses and subnet ranges or RFC 4291 IPv6 addresses and subnet ranges. Subnet ranges are specified using the '/' notation (e.g. 10.0.0.0/8, 2001:700:300:1800::/64). Glob patterns are supported only for ip address entries (i.e. not for subnet ranges).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_uris: Optional. Contains valid RFC 3986 URIs. Glob patterns are also supported. To match across path seperators (i.e. '/') use the double star glob pattern (i.e. '**').
        """
        if allow_custom_sans is not None:
            pulumi.set(__self__, "allow_custom_sans", allow_custom_sans)
        if allow_globbing_dns_wildcards is not None:
            pulumi.set(__self__, "allow_globbing_dns_wildcards", allow_globbing_dns_wildcards)
        if allowed_dns_names is not None:
            pulumi.set(__self__, "allowed_dns_names", allowed_dns_names)
        if allowed_email_addresses is not None:
            pulumi.set(__self__, "allowed_email_addresses", allowed_email_addresses)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if allowed_uris is not None:
            pulumi.set(__self__, "allowed_uris", allowed_uris)

    @property
    @pulumi.getter(name="allowCustomSans")
    def allow_custom_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Specifies if to allow custom X509Extension values.
        """
        return pulumi.get(self, "allow_custom_sans")

    @allow_custom_sans.setter
    def allow_custom_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_custom_sans", value)

    @property
    @pulumi.getter(name="allowGlobbingDnsWildcards")
    def allow_globbing_dns_wildcards(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Specifies if glob patterns used for allowed_dns_names allow wildcard certificates. If this is set, certificate requests with wildcard domains will be permitted to match a glob pattern specified in allowed_dns_names. Otherwise, certificate requests with wildcard domains will be permitted only if allowed_dns_names contains a literal wildcard.
        """
        return pulumi.get(self, "allow_globbing_dns_wildcards")

    @allow_globbing_dns_wildcards.setter
    def allow_globbing_dns_wildcards(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_globbing_dns_wildcards", value)

    @property
    @pulumi.getter(name="allowedDnsNames")
    def allowed_dns_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Contains valid, fully-qualified host names. Glob patterns are also supported. To allow an explicit wildcard certificate, escape with backlash (i.e. "\*"). E.g. for globbed entries: '*bar.com' will allow 'foo.bar.com', but not '*.bar.com', unless the allow_globbing_dns_wildcards field is set. E.g. for wildcard entries: '\*.bar.com' will allow '*.bar.com', but not 'foo.bar.com'.
        """
        return pulumi.get(self, "allowed_dns_names")

    @allowed_dns_names.setter
    def allowed_dns_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_dns_names", value)

    @property
    @pulumi.getter(name="allowedEmailAddresses")
    def allowed_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Contains valid RFC 2822 E-mail addresses. Glob patterns are also supported.
        """
        return pulumi.get(self, "allowed_email_addresses")

    @allowed_email_addresses.setter
    def allowed_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_email_addresses", value)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Contains valid 32-bit IPv4 addresses and subnet ranges or RFC 4291 IPv6 addresses and subnet ranges. Subnet ranges are specified using the '/' notation (e.g. 10.0.0.0/8, 2001:700:300:1800::/64). Glob patterns are supported only for ip address entries (i.e. not for subnet ranges).
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @property
    @pulumi.getter(name="allowedUris")
    def allowed_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Contains valid RFC 3986 URIs. Glob patterns are also supported. To match across path seperators (i.e. '/') use the double star glob pattern (i.e. '**').
        """
        return pulumi.get(self, "allowed_uris")

    @allowed_uris.setter
    def allowed_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_uris", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input[str]] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[str] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CaOptionsArgs:
    def __init__(__self__, *,
                 is_ca: Optional[pulumi.Input[bool]] = None,
                 max_issuer_path_length: Optional[pulumi.Input[int]] = None):
        """
        Describes values that are relevant in a CA certificate.
        :param pulumi.Input[bool] is_ca: Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
        :param pulumi.Input[int] max_issuer_path_length: Optional. Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
        """
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)

    @property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "is_ca")

    @is_ca.setter
    def is_ca(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ca", value)

    @property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @max_issuer_path_length.setter
    def max_issuer_path_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_issuer_path_length", value)


@pulumi.input_type
class CertificateAuthorityPolicyArgs:
    def __init__(__self__, *,
                 allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_config_list: Optional[pulumi.Input['AllowedConfigListArgs']] = None,
                 allowed_issuance_modes: Optional[pulumi.Input['IssuanceModesArgs']] = None,
                 allowed_locations_and_organizations: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]] = None,
                 allowed_sans: Optional[pulumi.Input['AllowedSubjectAltNamesArgs']] = None,
                 maximum_lifetime: Optional[pulumi.Input[str]] = None,
                 overwrite_config_values: Optional[pulumi.Input['ReusableConfigWrapperArgs']] = None):
        """
        The issuing policy for a CertificateAuthority. Certificates will not be successfully issued from this CertificateAuthority if they violate the policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_common_names: Optional. If any value is specified here, then all Certificates issued by the CertificateAuthority must match at least one listed value. If no value is specified, all values will be allowed for this fied. Glob patterns are also supported.
        :param pulumi.Input['AllowedConfigListArgs'] allowed_config_list: Optional. All Certificates issued by the CertificateAuthority must match at least one listed ReusableConfigWrapper in the list.
        :param pulumi.Input['IssuanceModesArgs'] allowed_issuance_modes: Optional. If specified, then only methods allowed in the IssuanceModes may be used to issue Certificates.
        :param pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]] allowed_locations_and_organizations: Optional. If any Subject is specified here, then all Certificates issued by the CertificateAuthority must match at least one listed Subject. If a Subject has an empty field, any value will be allowed for that field.
        :param pulumi.Input['AllowedSubjectAltNamesArgs'] allowed_sans: Optional. If a AllowedSubjectAltNames is specified here, then all Certificates issued by the CertificateAuthority must match AllowedSubjectAltNames. If no value or an empty value is specified, any value will be allowed for the SubjectAltNames field.
        :param pulumi.Input[str] maximum_lifetime: Optional. The maximum lifetime allowed by the CertificateAuthority. Note that if the any part if the issuing chain expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated.
        :param pulumi.Input['ReusableConfigWrapperArgs'] overwrite_config_values: Optional. All Certificates issued by the CertificateAuthority will use the provided configuration values, overwriting any requested configuration values.
        """
        if allowed_common_names is not None:
            pulumi.set(__self__, "allowed_common_names", allowed_common_names)
        if allowed_config_list is not None:
            pulumi.set(__self__, "allowed_config_list", allowed_config_list)
        if allowed_issuance_modes is not None:
            pulumi.set(__self__, "allowed_issuance_modes", allowed_issuance_modes)
        if allowed_locations_and_organizations is not None:
            pulumi.set(__self__, "allowed_locations_and_organizations", allowed_locations_and_organizations)
        if allowed_sans is not None:
            pulumi.set(__self__, "allowed_sans", allowed_sans)
        if maximum_lifetime is not None:
            pulumi.set(__self__, "maximum_lifetime", maximum_lifetime)
        if overwrite_config_values is not None:
            pulumi.set(__self__, "overwrite_config_values", overwrite_config_values)

    @property
    @pulumi.getter(name="allowedCommonNames")
    def allowed_common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. If any value is specified here, then all Certificates issued by the CertificateAuthority must match at least one listed value. If no value is specified, all values will be allowed for this fied. Glob patterns are also supported.
        """
        return pulumi.get(self, "allowed_common_names")

    @allowed_common_names.setter
    def allowed_common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_common_names", value)

    @property
    @pulumi.getter(name="allowedConfigList")
    def allowed_config_list(self) -> Optional[pulumi.Input['AllowedConfigListArgs']]:
        """
        Optional. All Certificates issued by the CertificateAuthority must match at least one listed ReusableConfigWrapper in the list.
        """
        return pulumi.get(self, "allowed_config_list")

    @allowed_config_list.setter
    def allowed_config_list(self, value: Optional[pulumi.Input['AllowedConfigListArgs']]):
        pulumi.set(self, "allowed_config_list", value)

    @property
    @pulumi.getter(name="allowedIssuanceModes")
    def allowed_issuance_modes(self) -> Optional[pulumi.Input['IssuanceModesArgs']]:
        """
        Optional. If specified, then only methods allowed in the IssuanceModes may be used to issue Certificates.
        """
        return pulumi.get(self, "allowed_issuance_modes")

    @allowed_issuance_modes.setter
    def allowed_issuance_modes(self, value: Optional[pulumi.Input['IssuanceModesArgs']]):
        pulumi.set(self, "allowed_issuance_modes", value)

    @property
    @pulumi.getter(name="allowedLocationsAndOrganizations")
    def allowed_locations_and_organizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]:
        """
        Optional. If any Subject is specified here, then all Certificates issued by the CertificateAuthority must match at least one listed Subject. If a Subject has an empty field, any value will be allowed for that field.
        """
        return pulumi.get(self, "allowed_locations_and_organizations")

    @allowed_locations_and_organizations.setter
    def allowed_locations_and_organizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]):
        pulumi.set(self, "allowed_locations_and_organizations", value)

    @property
    @pulumi.getter(name="allowedSans")
    def allowed_sans(self) -> Optional[pulumi.Input['AllowedSubjectAltNamesArgs']]:
        """
        Optional. If a AllowedSubjectAltNames is specified here, then all Certificates issued by the CertificateAuthority must match AllowedSubjectAltNames. If no value or an empty value is specified, any value will be allowed for the SubjectAltNames field.
        """
        return pulumi.get(self, "allowed_sans")

    @allowed_sans.setter
    def allowed_sans(self, value: Optional[pulumi.Input['AllowedSubjectAltNamesArgs']]):
        pulumi.set(self, "allowed_sans", value)

    @property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The maximum lifetime allowed by the CertificateAuthority. Note that if the any part if the issuing chain expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated.
        """
        return pulumi.get(self, "maximum_lifetime")

    @maximum_lifetime.setter
    def maximum_lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_lifetime", value)

    @property
    @pulumi.getter(name="overwriteConfigValues")
    def overwrite_config_values(self) -> Optional[pulumi.Input['ReusableConfigWrapperArgs']]:
        """
        Optional. All Certificates issued by the CertificateAuthority will use the provided configuration values, overwriting any requested configuration values.
        """
        return pulumi.get(self, "overwrite_config_values")

    @overwrite_config_values.setter
    def overwrite_config_values(self, value: Optional[pulumi.Input['ReusableConfigWrapperArgs']]):
        pulumi.set(self, "overwrite_config_values", value)


@pulumi.input_type
class CertificateConfigArgs:
    def __init__(__self__, *,
                 public_key: Optional[pulumi.Input['PublicKeyArgs']] = None,
                 reusable_config: Optional[pulumi.Input['ReusableConfigWrapperArgs']] = None,
                 subject_config: Optional[pulumi.Input['SubjectConfigArgs']] = None):
        """
        A CertificateConfig describes an X.509 certificate or CSR that is to be created, as an alternative to using ASN.1.
        :param pulumi.Input['PublicKeyArgs'] public_key: Optional. The public key that corresponds to this config. This is, for example, used when issuing Certificates, but not when creating a self-signed CertificateAuthority or CertificateAuthority CSR.
        :param pulumi.Input['ReusableConfigWrapperArgs'] reusable_config: Required. Describes how some of the technical fields in a certificate should be populated.
        :param pulumi.Input['SubjectConfigArgs'] subject_config: Required. Specifies some of the values in a certificate that are related to the subject.
        """
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if reusable_config is not None:
            pulumi.set(__self__, "reusable_config", reusable_config)
        if subject_config is not None:
            pulumi.set(__self__, "subject_config", subject_config)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input['PublicKeyArgs']]:
        """
        Optional. The public key that corresponds to this config. This is, for example, used when issuing Certificates, but not when creating a self-signed CertificateAuthority or CertificateAuthority CSR.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input['PublicKeyArgs']]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> Optional[pulumi.Input['ReusableConfigWrapperArgs']]:
        """
        Required. Describes how some of the technical fields in a certificate should be populated.
        """
        return pulumi.get(self, "reusable_config")

    @reusable_config.setter
    def reusable_config(self, value: Optional[pulumi.Input['ReusableConfigWrapperArgs']]):
        pulumi.set(self, "reusable_config", value)

    @property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> Optional[pulumi.Input['SubjectConfigArgs']]:
        """
        Required. Specifies some of the values in a certificate that are related to the subject.
        """
        return pulumi.get(self, "subject_config")

    @subject_config.setter
    def subject_config(self, value: Optional[pulumi.Input['SubjectConfigArgs']]):
        pulumi.set(self, "subject_config", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ExtendedKeyUsageOptionsArgs:
    def __init__(__self__, *,
                 client_auth: Optional[pulumi.Input[bool]] = None,
                 code_signing: Optional[pulumi.Input[bool]] = None,
                 email_protection: Optional[pulumi.Input[bool]] = None,
                 ocsp_signing: Optional[pulumi.Input[bool]] = None,
                 server_auth: Optional[pulumi.Input[bool]] = None,
                 time_stamping: Optional[pulumi.Input[bool]] = None):
        """
        KeyUsage.ExtendedKeyUsageOptions has fields that correspond to certain common OIDs that could be specified as an extended key usage value.
        :param pulumi.Input[bool] client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param pulumi.Input[bool] code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param pulumi.Input[bool] email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param pulumi.Input[bool] ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param pulumi.Input[bool] server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param pulumi.Input[bool] time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @client_auth.setter
    def client_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_auth", value)

    @property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @code_signing.setter
    def code_signing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "code_signing", value)

    @property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @email_protection.setter
    def email_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_protection", value)

    @property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @ocsp_signing.setter
    def ocsp_signing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_signing", value)

    @property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @server_auth.setter
    def server_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "server_auth", value)

    @property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[pulumi.Input[bool]]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")

    @time_stamping.setter
    def time_stamping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "time_stamping", value)


@pulumi.input_type
class IssuanceModesArgs:
    def __init__(__self__, *,
                 allow_config_based_issuance: Optional[pulumi.Input[bool]] = None,
                 allow_csr_based_issuance: Optional[pulumi.Input[bool]] = None):
        """
        IssuanceModes specifies the allowed ways in which Certificates may be requested from this CertificateAuthority.
        :param pulumi.Input[bool] allow_config_based_issuance: Required. When true, allows callers to create Certificates by specifying a CertificateConfig.
        :param pulumi.Input[bool] allow_csr_based_issuance: Required. When true, allows callers to create Certificates by specifying a CSR.
        """
        if allow_config_based_issuance is not None:
            pulumi.set(__self__, "allow_config_based_issuance", allow_config_based_issuance)
        if allow_csr_based_issuance is not None:
            pulumi.set(__self__, "allow_csr_based_issuance", allow_csr_based_issuance)

    @property
    @pulumi.getter(name="allowConfigBasedIssuance")
    def allow_config_based_issuance(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. When true, allows callers to create Certificates by specifying a CertificateConfig.
        """
        return pulumi.get(self, "allow_config_based_issuance")

    @allow_config_based_issuance.setter
    def allow_config_based_issuance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_config_based_issuance", value)

    @property
    @pulumi.getter(name="allowCsrBasedIssuance")
    def allow_csr_based_issuance(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. When true, allows callers to create Certificates by specifying a CSR.
        """
        return pulumi.get(self, "allow_csr_based_issuance")

    @allow_csr_based_issuance.setter
    def allow_csr_based_issuance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_csr_based_issuance", value)


@pulumi.input_type
class IssuingOptionsArgs:
    def __init__(__self__, *,
                 include_ca_cert_url: Optional[pulumi.Input[bool]] = None,
                 include_crl_access_url: Optional[pulumi.Input[bool]] = None):
        """
        Options that affect all certificates issued by a CertificateAuthority.
        :param pulumi.Input[bool] include_ca_cert_url: Required. When true, includes a URL to the issuing CA certificate in the "authority information access" X.509 extension.
        :param pulumi.Input[bool] include_crl_access_url: Required. When true, includes a URL to the CRL corresponding to certificates issued from a CertificateAuthority. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        if include_ca_cert_url is not None:
            pulumi.set(__self__, "include_ca_cert_url", include_ca_cert_url)
        if include_crl_access_url is not None:
            pulumi.set(__self__, "include_crl_access_url", include_crl_access_url)

    @property
    @pulumi.getter(name="includeCaCertUrl")
    def include_ca_cert_url(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. When true, includes a URL to the issuing CA certificate in the "authority information access" X.509 extension.
        """
        return pulumi.get(self, "include_ca_cert_url")

    @include_ca_cert_url.setter
    def include_ca_cert_url(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_ca_cert_url", value)

    @property
    @pulumi.getter(name="includeCrlAccessUrl")
    def include_crl_access_url(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. When true, includes a URL to the CRL corresponding to certificates issued from a CertificateAuthority. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        return pulumi.get(self, "include_crl_access_url")

    @include_crl_access_url.setter
    def include_crl_access_url(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_crl_access_url", value)


@pulumi.input_type
class KeyUsageArgs:
    def __init__(__self__, *,
                 base_key_usage: Optional[pulumi.Input['KeyUsageOptionsArgs']] = None,
                 extended_key_usage: Optional[pulumi.Input['ExtendedKeyUsageOptionsArgs']] = None,
                 unknown_extended_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]] = None):
        """
        A KeyUsage describes key usage values that may appear in an X.509 certificate.
        :param pulumi.Input['KeyUsageOptionsArgs'] base_key_usage: Describes high-level ways in which a key may be used.
        :param pulumi.Input['ExtendedKeyUsageOptionsArgs'] extended_key_usage: Detailed scenarios in which a key may be used.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]] unknown_extended_key_usages: Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
        """
        if base_key_usage is not None:
            pulumi.set(__self__, "base_key_usage", base_key_usage)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> Optional[pulumi.Input['KeyUsageOptionsArgs']]:
        """
        Describes high-level ways in which a key may be used.
        """
        return pulumi.get(self, "base_key_usage")

    @base_key_usage.setter
    def base_key_usage(self, value: Optional[pulumi.Input['KeyUsageOptionsArgs']]):
        pulumi.set(self, "base_key_usage", value)

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional[pulumi.Input['ExtendedKeyUsageOptionsArgs']]:
        """
        Detailed scenarios in which a key may be used.
        """
        return pulumi.get(self, "extended_key_usage")

    @extended_key_usage.setter
    def extended_key_usage(self, value: Optional[pulumi.Input['ExtendedKeyUsageOptionsArgs']]):
        pulumi.set(self, "extended_key_usage", value)

    @property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]]:
        """
        Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
        """
        return pulumi.get(self, "unknown_extended_key_usages")

    @unknown_extended_key_usages.setter
    def unknown_extended_key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]]):
        pulumi.set(self, "unknown_extended_key_usages", value)


@pulumi.input_type
class KeyUsageOptionsArgs:
    def __init__(__self__, *,
                 cert_sign: Optional[pulumi.Input[bool]] = None,
                 content_commitment: Optional[pulumi.Input[bool]] = None,
                 crl_sign: Optional[pulumi.Input[bool]] = None,
                 data_encipherment: Optional[pulumi.Input[bool]] = None,
                 decipher_only: Optional[pulumi.Input[bool]] = None,
                 digital_signature: Optional[pulumi.Input[bool]] = None,
                 encipher_only: Optional[pulumi.Input[bool]] = None,
                 key_agreement: Optional[pulumi.Input[bool]] = None,
                 key_encipherment: Optional[pulumi.Input[bool]] = None):
        """
        KeyUsage.KeyUsageOptions corresponds to the key usage values described in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
        :param pulumi.Input[bool] cert_sign: The key may be used to sign certificates.
        :param pulumi.Input[bool] content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param pulumi.Input[bool] crl_sign: The key may be used sign certificate revocation lists.
        :param pulumi.Input[bool] data_encipherment: The key may be used to encipher data.
        :param pulumi.Input[bool] decipher_only: The key may be used to decipher only.
        :param pulumi.Input[bool] digital_signature: The key may be used for digital signatures.
        :param pulumi.Input[bool] encipher_only: The key may be used to encipher only.
        :param pulumi.Input[bool] key_agreement: The key may be used in a key agreement protocol.
        :param pulumi.Input[bool] key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @cert_sign.setter
    def cert_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cert_sign", value)

    @property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @content_commitment.setter
    def content_commitment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "content_commitment", value)

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @crl_sign.setter
    def crl_sign(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crl_sign", value)

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @data_encipherment.setter
    def data_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_encipherment", value)

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @decipher_only.setter
    def decipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decipher_only", value)

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @digital_signature.setter
    def digital_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "digital_signature", value)

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @encipher_only.setter
    def encipher_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encipher_only", value)

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @key_agreement.setter
    def key_agreement(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_agreement", value)

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[pulumi.Input[bool]]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")

    @key_encipherment.setter
    def key_encipherment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_encipherment", value)


@pulumi.input_type
class KeyVersionSpecArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 cloud_kms_key_version: Optional[pulumi.Input[str]] = None):
        """
        A Cloud KMS key configuration that a CertificateAuthority will use.
        :param pulumi.Input[str] algorithm: Required. The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience. All managed keys will be have their ProtectionLevel as `HSM`.
        :param pulumi.Input[str] cloud_kms_key_version: Required. The resource name for an existing Cloud KMS CryptoKeyVersion in the format `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`. This option enables full flexibility in the key's capabilities and properties.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if cloud_kms_key_version is not None:
            pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience. All managed keys will be have their ProtectionLevel as `HSM`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name for an existing Cloud KMS CryptoKeyVersion in the format `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`. This option enables full flexibility in the key's capabilities and properties.
        """
        return pulumi.get(self, "cloud_kms_key_version")

    @cloud_kms_key_version.setter
    def cloud_kms_key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_kms_key_version", value)


@pulumi.input_type
class ObjectIdArgs:
    def __init__(__self__, *,
                 object_id_path: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] object_id_path: Required. The parts of an OID path. The most significant parts of the path come first.
        """
        if object_id_path is not None:
            pulumi.set(__self__, "object_id_path", object_id_path)

    @property
    @pulumi.getter(name="objectIdPath")
    def object_id_path(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Required. The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_path")

    @object_id_path.setter
    def object_id_path(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "object_id_path", value)


@pulumi.input_type
class PublicKeyArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A PublicKey describes a public key.
        :param pulumi.Input[str] key: Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1) structure containing an algorithm identifier and a key.
        :param pulumi.Input[str] type: Optional. The type of public key. If specified, it must match the public key used for the`key` field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#section-4.1) structure containing an algorithm identifier and a key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The type of public key. If specified, it must match the public key used for the`key` field.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ReusableConfigValuesArgs:
    def __init__(__self__, *,
                 additional_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]] = None,
                 aia_ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ca_options: Optional[pulumi.Input['CaOptionsArgs']] = None,
                 key_usage: Optional[pulumi.Input['KeyUsageArgs']] = None,
                 policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]] = None):
        """
        A ReusableConfigValues is used to describe certain fields of an X.509 certificate, such as the key usage fields, fields specific to CA certificates, certificate policy extensions and custom extensions.
        :param pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]] additional_extensions: Optional. Describes custom X.509 extensions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aia_ocsp_servers: Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        :param pulumi.Input['CaOptionsArgs'] ca_options: Optional. Describes options in this ReusableConfigValues that are relevant in a CA certificate.
        :param pulumi.Input['KeyUsageArgs'] key_usage: Optional. Indicates the intended use for keys that correspond to a certificate.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]] policy_ids: Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if ca_options is not None:
            pulumi.set(__self__, "ca_options", ca_options)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]]:
        """
        Optional. Describes custom X.509 extensions.
        """
        return pulumi.get(self, "additional_extensions")

    @additional_extensions.setter
    def additional_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]]):
        pulumi.set(self, "additional_extensions", value)

    @property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @aia_ocsp_servers.setter
    def aia_ocsp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aia_ocsp_servers", value)

    @property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> Optional[pulumi.Input['CaOptionsArgs']]:
        """
        Optional. Describes options in this ReusableConfigValues that are relevant in a CA certificate.
        """
        return pulumi.get(self, "ca_options")

    @ca_options.setter
    def ca_options(self, value: Optional[pulumi.Input['CaOptionsArgs']]):
        pulumi.set(self, "ca_options", value)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input['KeyUsageArgs']]:
        """
        Optional. Indicates the intended use for keys that correspond to a certificate.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input['KeyUsageArgs']]):
        pulumi.set(self, "key_usage", value)

    @property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]]:
        """
        Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        return pulumi.get(self, "policy_ids")

    @policy_ids.setter
    def policy_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectIdArgs']]]]):
        pulumi.set(self, "policy_ids", value)


@pulumi.input_type
class ReusableConfigWrapperArgs:
    def __init__(__self__, *,
                 reusable_config: Optional[pulumi.Input[str]] = None,
                 reusable_config_values: Optional[pulumi.Input['ReusableConfigValuesArgs']] = None):
        """
        A ReusableConfigWrapper describes values that may assist in creating an X.509 certificate, or a reference to a pre-defined set of values.
        :param pulumi.Input[str] reusable_config: Required. A resource path to a ReusableConfig in the format `projects/*/locations/*/reusableConfigs/*`.
        :param pulumi.Input['ReusableConfigValuesArgs'] reusable_config_values: Required. A user-specified inline ReusableConfigValues.
        """
        if reusable_config is not None:
            pulumi.set(__self__, "reusable_config", reusable_config)
        if reusable_config_values is not None:
            pulumi.set(__self__, "reusable_config_values", reusable_config_values)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> Optional[pulumi.Input[str]]:
        """
        Required. A resource path to a ReusableConfig in the format `projects/*/locations/*/reusableConfigs/*`.
        """
        return pulumi.get(self, "reusable_config")

    @reusable_config.setter
    def reusable_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reusable_config", value)

    @property
    @pulumi.getter(name="reusableConfigValues")
    def reusable_config_values(self) -> Optional[pulumi.Input['ReusableConfigValuesArgs']]:
        """
        Required. A user-specified inline ReusableConfigValues.
        """
        return pulumi.get(self, "reusable_config_values")

    @reusable_config_values.setter
    def reusable_config_values(self, value: Optional[pulumi.Input['ReusableConfigValuesArgs']]):
        pulumi.set(self, "reusable_config_values", value)


@pulumi.input_type
class SubjectArgs:
    def __init__(__self__, *,
                 country_code: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None):
        """
        Subject describes parts of a distinguished name that, in turn, describes the subject of the certificate.
        :param pulumi.Input[str] country_code: The country code of the subject.
        :param pulumi.Input[str] locality: The locality or city of the subject.
        :param pulumi.Input[str] organization: The organization of the subject.
        :param pulumi.Input[str] organizational_unit: The organizational_unit of the subject.
        :param pulumi.Input[str] postal_code: The postal code of the subject.
        :param pulumi.Input[str] province: The province, territory, or regional state of the subject.
        :param pulumi.Input[str] street_address: The street address of the subject.
        """
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[str]]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The organizational_unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[str]]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address", value)


@pulumi.input_type
class SubjectAltNamesArgs:
    def __init__(__self__, *,
                 custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]] = None,
                 dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        SubjectAltNames corresponds to a more modern way of listing what the asserted identity is in a certificate (i.e., compared to the "common name" in the distinguished name).
        :param pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]] custom_sans: Contains additional subject alternative name values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_names: Contains only valid, fully-qualified host names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uris: Contains only valid RFC 3986 URIs.
        """
        if custom_sans is not None:
            pulumi.set(__self__, "custom_sans", custom_sans)
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]]:
        """
        Contains additional subject alternative name values.
        """
        return pulumi.get(self, "custom_sans")

    @custom_sans.setter
    def custom_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X509ExtensionArgs']]]]):
        pulumi.set(self, "custom_sans", value)

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @dns_names.setter
    def dns_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_names", value)

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "email_addresses", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")

    @uris.setter
    def uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uris", value)


@pulumi.input_type
class SubjectConfigArgs:
    def __init__(__self__, *,
                 common_name: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input['SubjectArgs']] = None,
                 subject_alt_name: Optional[pulumi.Input['SubjectAltNamesArgs']] = None):
        """
        These values are used to create the distinguished name and subject alternative name fields in an X.509 certificate.
        :param pulumi.Input[str] common_name: Optional. The "common name" of the distinguished name.
        :param pulumi.Input['SubjectArgs'] subject: Required. Contains distinguished name fields such as the location and organization.
        :param pulumi.Input['SubjectAltNamesArgs'] subject_alt_name: Optional. The subject alternative name fields.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The "common name" of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input['SubjectArgs']]:
        """
        Required. Contains distinguished name fields such as the location and organization.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input['SubjectArgs']]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional[pulumi.Input['SubjectAltNamesArgs']]:
        """
        Optional. The subject alternative name fields.
        """
        return pulumi.get(self, "subject_alt_name")

    @subject_alt_name.setter
    def subject_alt_name(self, value: Optional[pulumi.Input['SubjectAltNamesArgs']]):
        pulumi.set(self, "subject_alt_name", value)


@pulumi.input_type
class SubordinateConfigArgs:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 pem_issuer_chain: Optional[pulumi.Input['SubordinateConfigChainArgs']] = None):
        """
        Describes a subordinate CA's issuers. This is either a resource path to a known issuing CertificateAuthority, or a PEM issuer certificate chain.
        :param pulumi.Input[str] certificate_authority: Required. This can refer to a CertificateAuthority in the same project that was used to create a subordinate CertificateAuthority. This field is used for information and usability purposes only. The resource name is in the format `projects/*/locations/*/certificateAuthorities/*`.
        :param pulumi.Input['SubordinateConfigChainArgs'] pem_issuer_chain: Required. Contains the PEM certificate chain for the issuers of this CertificateAuthority, but not pem certificate for this CA itself.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if pem_issuer_chain is not None:
            pulumi.set(__self__, "pem_issuer_chain", pem_issuer_chain)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[str]]:
        """
        Required. This can refer to a CertificateAuthority in the same project that was used to create a subordinate CertificateAuthority. This field is used for information and usability purposes only. The resource name is in the format `projects/*/locations/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="pemIssuerChain")
    def pem_issuer_chain(self) -> Optional[pulumi.Input['SubordinateConfigChainArgs']]:
        """
        Required. Contains the PEM certificate chain for the issuers of this CertificateAuthority, but not pem certificate for this CA itself.
        """
        return pulumi.get(self, "pem_issuer_chain")

    @pem_issuer_chain.setter
    def pem_issuer_chain(self, value: Optional[pulumi.Input['SubordinateConfigChainArgs']]):
        pulumi.set(self, "pem_issuer_chain", value)


@pulumi.input_type
class SubordinateConfigChainArgs:
    def __init__(__self__, *,
                 pem_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        This message describes a subordinate CA's issuer certificate chain. This wrapper exists for compatibility reasons.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pem_certificates: Required. Expected to be in leaf-to-root order according to RFC 5246.
        """
        if pem_certificates is not None:
            pulumi.set(__self__, "pem_certificates", pem_certificates)

    @property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")

    @pem_certificates.setter
    def pem_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pem_certificates", value)


@pulumi.input_type
class X509ExtensionArgs:
    def __init__(__self__, *,
                 critical: Optional[pulumi.Input[bool]] = None,
                 object_id: Optional[pulumi.Input['ObjectIdArgs']] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        An X509Extension specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        :param pulumi.Input[bool] critical: Required. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        :param pulumi.Input['ObjectIdArgs'] object_id: Required. The OID for this X.509 extension.
        :param pulumi.Input[str] value: Required. The value of this X.509 extension.
        """
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input[bool]]:
        """
        Required. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "critical", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input['ObjectIdArgs']]:
        """
        Required. The OID for this X.509 extension.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input['ObjectIdArgs']]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The value of this X.509 extension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


