# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AggregationResponse',
    'AppEngineResponse',
    'AvailabilityCriteriaResponse',
    'BasicAuthenticationResponse',
    'BasicSliResponse',
    'CloudEndpointsResponse',
    'ClusterIstioResponse',
    'ConditionResponse',
    'ContentMatcherResponse',
    'CustomResponse',
    'DistributionCutResponse',
    'DocumentationResponse',
    'GoogleMonitoringV3RangeResponse',
    'HttpCheckResponse',
    'InternalCheckerResponse',
    'IstioCanonicalServiceResponse',
    'LabelDescriptorResponse',
    'LatencyCriteriaResponse',
    'MeshIstioResponse',
    'MetricAbsenceResponse',
    'MetricDescriptorMetadataResponse',
    'MetricRangeResponse',
    'MetricThresholdResponse',
    'MonitoredResourceResponse',
    'MonitoringQueryLanguageConditionResponse',
    'MutationRecordResponse',
    'PerformanceThresholdResponse',
    'RequestBasedSliResponse',
    'ResourceGroupResponse',
    'ServiceLevelIndicatorResponse',
    'StatusResponse',
    'TcpCheckResponse',
    'TelemetryResponse',
    'TimeSeriesRatioResponse',
    'TriggerResponse',
    'WindowsBasedSliResponse',
]

@pulumi.output_type
class AggregationResponse(dict):
    """
    Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: str,
                 cross_series_reducer: str,
                 group_by_fields: Sequence[str],
                 per_series_aligner: str):
        """
        Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
        :param str alignment_period: The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 104 weeks (2 years) for charts, and 90,000 seconds (25 hours) for alerting policies.
        :param str cross_series_reducer: The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        :param Sequence[str] group_by_fields: The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        :param str per_series_aligner: An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        pulumi.set(__self__, "alignment_period", alignment_period)
        pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        pulumi.set(__self__, "group_by_fields", group_by_fields)
        pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> str:
        """
        The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 104 weeks (2 years) for charts, and 90,000 seconds (25 hours) for alerting policies.
        """
        return pulumi.get(self, "alignment_period")

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> str:
        """
        The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "cross_series_reducer")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Sequence[str]:
        """
        The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> str:
        """
        An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AppEngineResponse(dict):
    """
    App Engine service. Learn more at https://cloud.google.com/appengine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "moduleId":
            suggest = "module_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEngineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEngineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEngineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 module_id: str):
        """
        App Engine service. Learn more at https://cloud.google.com/appengine.
        :param str module_id: The ID of the App Engine module underlying this service. Corresponds to the module_id resource label in the gae_app monitored resource: https://cloud.google.com/monitoring/api/resources#tag_gae_app
        """
        pulumi.set(__self__, "module_id", module_id)

    @property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> str:
        """
        The ID of the App Engine module underlying this service. Corresponds to the module_id resource label in the gae_app monitored resource: https://cloud.google.com/monitoring/api/resources#tag_gae_app
        """
        return pulumi.get(self, "module_id")


@pulumi.output_type
class AvailabilityCriteriaResponse(dict):
    """
    Future parameters for the availability SLI.
    """
    def __init__(__self__):
        """
        Future parameters for the availability SLI.
        """
        pass


@pulumi.output_type
class BasicAuthenticationResponse(dict):
    """
    The authentication parameters to provide to the specified resource or URL that requires a username and password. Currently, only Basic HTTP authentication (https://tools.ietf.org/html/rfc7617) is supported in Uptime checks.
    """
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        The authentication parameters to provide to the specified resource or URL that requires a username and password. Currently, only Basic HTTP authentication (https://tools.ietf.org/html/rfc7617) is supported in Uptime checks.
        :param str password: The password to use when authenticating with the HTTP server.
        :param str username: The username to use when authenticating with the HTTP server.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to use when authenticating with the HTTP server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to use when authenticating with the HTTP server.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class BasicSliResponse(dict):
    """
    An SLI measuring performance on a well-known service type. Performance will be computed on the basis of pre-defined metrics. The type of the service_resource determines the metrics to use and the service_resource.labels and metric_labels are used to construct a monitoring filter to filter that metric down to just the data relevant to this service.
    """
    def __init__(__self__, *,
                 availability: 'outputs.AvailabilityCriteriaResponse',
                 latency: 'outputs.LatencyCriteriaResponse',
                 location: Sequence[str],
                 method: Sequence[str],
                 version: Sequence[str]):
        """
        An SLI measuring performance on a well-known service type. Performance will be computed on the basis of pre-defined metrics. The type of the service_resource determines the metrics to use and the service_resource.labels and metric_labels are used to construct a monitoring filter to filter that metric down to just the data relevant to this service.
        :param 'AvailabilityCriteriaResponseArgs' availability: Good service is defined to be the count of requests made to this service that return successfully.
        :param 'LatencyCriteriaResponseArgs' latency: Good service is defined to be the count of requests made to this service that are fast enough with respect to latency.threshold.
        :param Sequence[str] location: OPTIONAL: The set of locations to which this SLI is relevant. Telemetry from other locations will not be used to calculate performance for this SLI. If omitted, this SLI applies to all locations in which the Service has activity. For service types that don't support breaking down by location, setting this field will result in an error.
        :param Sequence[str] method: OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from other methods will not be used to calculate performance for this SLI. If omitted, this SLI applies to all the Service's methods. For service types that don't support breaking down by method, setting this field will result in an error.
        :param Sequence[str] version: OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry from other API versions will not be used to calculate performance for this SLI. If omitted, this SLI applies to all API versions. For service types that don't support breaking down by version, setting this field will result in an error.
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "latency", latency)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def availability(self) -> 'outputs.AvailabilityCriteriaResponse':
        """
        Good service is defined to be the count of requests made to this service that return successfully.
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter
    def latency(self) -> 'outputs.LatencyCriteriaResponse':
        """
        Good service is defined to be the count of requests made to this service that are fast enough with respect to latency.threshold.
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter
    def location(self) -> Sequence[str]:
        """
        OPTIONAL: The set of locations to which this SLI is relevant. Telemetry from other locations will not be used to calculate performance for this SLI. If omitted, this SLI applies to all locations in which the Service has activity. For service types that don't support breaking down by location, setting this field will result in an error.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def method(self) -> Sequence[str]:
        """
        OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from other methods will not be used to calculate performance for this SLI. If omitted, this SLI applies to all the Service's methods. For service types that don't support breaking down by method, setting this field will result in an error.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def version(self) -> Sequence[str]:
        """
        OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry from other API versions will not be used to calculate performance for this SLI. If omitted, this SLI applies to all API versions. For service types that don't support breaking down by version, setting this field will result in an error.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class CloudEndpointsResponse(dict):
    """
    Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
    """
    def __init__(__self__, *,
                 service: str):
        """
        Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
        :param str service: The name of the Cloud Endpoints service underlying this service. Corresponds to the service resource label in the api monitored resource: https://cloud.google.com/monitoring/api/resources#tag_api
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the Cloud Endpoints service underlying this service. Corresponds to the service resource label in the api monitored resource: https://cloud.google.com/monitoring/api/resources#tag_api
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ClusterIstioResponse(dict):
    """
    Istio service scoped to a single Kubernetes cluster. Learn more at https://istio.io. Clusters running OSS Istio will have their services ingested as this type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "serviceNamespace":
            suggest = "service_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterIstioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterIstioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterIstioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str,
                 location: str,
                 service_name: str,
                 service_namespace: str):
        """
        Istio service scoped to a single Kubernetes cluster. Learn more at https://istio.io. Clusters running OSS Istio will have their services ingested as this type.
        :param str cluster_name: The name of the Kubernetes cluster in which this Istio service is defined. Corresponds to the cluster_name resource label in k8s_cluster resources.
        :param str location: The location of the Kubernetes cluster in which this Istio service is defined. Corresponds to the location resource label in k8s_cluster resources.
        :param str service_name: The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        :param str service_namespace: The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_namespace", service_namespace)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the Kubernetes cluster in which this Istio service is defined. Corresponds to the cluster_name resource label in k8s_cluster resources.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the Kubernetes cluster in which this Istio service is defined. Corresponds to the location resource label in k8s_cluster resources.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> str:
        """
        The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        return pulumi.get(self, "service_namespace")


@pulumi.output_type
class ConditionResponse(dict):
    """
    A condition is a true/false test that determines when an alerting policy should open an incident. If a condition evaluates to true, it signifies that something is wrong.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionAbsent":
            suggest = "condition_absent"
        elif key == "conditionMonitoringQueryLanguage":
            suggest = "condition_monitoring_query_language"
        elif key == "conditionThreshold":
            suggest = "condition_threshold"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_absent: 'outputs.MetricAbsenceResponse',
                 condition_monitoring_query_language: 'outputs.MonitoringQueryLanguageConditionResponse',
                 condition_threshold: 'outputs.MetricThresholdResponse',
                 display_name: str,
                 name: str):
        """
        A condition is a true/false test that determines when an alerting policy should open an incident. If a condition evaluates to true, it signifies that something is wrong.
        :param 'MetricAbsenceResponseArgs' condition_absent: A condition that checks that a time series continues to receive new data points.
        :param 'MonitoringQueryLanguageConditionResponseArgs' condition_monitoring_query_language: A condition that uses the Monitoring Query Language to define alerts.
        :param 'MetricThresholdResponseArgs' condition_threshold: A condition that compares a time series against a threshold.
        :param str display_name: A short name or phrase used to identify the condition in dashboards, notifications, and incidents. To avoid confusion, don't use the same display name for multiple conditions in the same policy.
        :param str name: Required if the condition exists. The unique resource name for this condition. Its format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID] [CONDITION_ID] is assigned by Stackdriver Monitoring when the condition is created as part of a new or updated alerting policy.When calling the alertPolicies.create method, do not include the name field in the conditions of the requested alerting policy. Stackdriver Monitoring creates the condition identifiers and includes them in the new policy.When calling the alertPolicies.update method to update a policy, including a condition name causes the existing condition to be updated. Conditions without names are added to the updated policy. Existing conditions are deleted if they are not updated.Best practice is to preserve [CONDITION_ID] if you make only small changes, such as those to condition thresholds, durations, or trigger values. Otherwise, treat the change as a new condition and let the existing condition be deleted.
        """
        pulumi.set(__self__, "condition_absent", condition_absent)
        pulumi.set(__self__, "condition_monitoring_query_language", condition_monitoring_query_language)
        pulumi.set(__self__, "condition_threshold", condition_threshold)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="conditionAbsent")
    def condition_absent(self) -> 'outputs.MetricAbsenceResponse':
        """
        A condition that checks that a time series continues to receive new data points.
        """
        return pulumi.get(self, "condition_absent")

    @property
    @pulumi.getter(name="conditionMonitoringQueryLanguage")
    def condition_monitoring_query_language(self) -> 'outputs.MonitoringQueryLanguageConditionResponse':
        """
        A condition that uses the Monitoring Query Language to define alerts.
        """
        return pulumi.get(self, "condition_monitoring_query_language")

    @property
    @pulumi.getter(name="conditionThreshold")
    def condition_threshold(self) -> 'outputs.MetricThresholdResponse':
        """
        A condition that compares a time series against a threshold.
        """
        return pulumi.get(self, "condition_threshold")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A short name or phrase used to identify the condition in dashboards, notifications, and incidents. To avoid confusion, don't use the same display name for multiple conditions in the same policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required if the condition exists. The unique resource name for this condition. Its format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID] [CONDITION_ID] is assigned by Stackdriver Monitoring when the condition is created as part of a new or updated alerting policy.When calling the alertPolicies.create method, do not include the name field in the conditions of the requested alerting policy. Stackdriver Monitoring creates the condition identifiers and includes them in the new policy.When calling the alertPolicies.update method to update a policy, including a condition name causes the existing condition to be updated. Conditions without names are added to the updated policy. Existing conditions are deleted if they are not updated.Best practice is to preserve [CONDITION_ID] if you make only small changes, such as those to condition thresholds, durations, or trigger values. Otherwise, treat the change as a new condition and let the existing condition be deleted.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContentMatcherResponse(dict):
    """
    Optional. Used to perform content matching. This allows matching based on substrings and regular expressions, together with their negations. Only the first 4 MB of an HTTP or HTTPS check's response (and the first 1 MB of a TCP check's response) are examined for purposes of content matching.
    """
    def __init__(__self__, *,
                 content: str,
                 matcher: str):
        """
        Optional. Used to perform content matching. This allows matching based on substrings and regular expressions, together with their negations. Only the first 4 MB of an HTTP or HTTPS check's response (and the first 1 MB of a TCP check's response) are examined for purposes of content matching.
        :param str content: String or regex content to match. Maximum 1024 bytes. An empty content string indicates no content matching is to be performed.
        :param str matcher: The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "matcher", matcher)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        String or regex content to match. Maximum 1024 bytes. An empty content string indicates no content matching is to be performed.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def matcher(self) -> str:
        """
        The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        """
        return pulumi.get(self, "matcher")


@pulumi.output_type
class CustomResponse(dict):
    """
    Custom view of service telemetry. Currently a place-holder pending final design.
    """
    def __init__(__self__):
        """
        Custom view of service telemetry. Currently a place-holder pending final design.
        """
        pass


@pulumi.output_type
class DistributionCutResponse(dict):
    """
    A DistributionCut defines a TimeSeries and thresholds used for measuring good service and total service. The TimeSeries must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE. The computed good_service will be the count of values x in the Distribution such that range.min <= x < range.max.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionFilter":
            suggest = "distribution_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_filter: str,
                 range: 'outputs.GoogleMonitoringV3RangeResponse'):
        """
        A DistributionCut defines a TimeSeries and thresholds used for measuring good service and total service. The TimeSeries must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE. The computed good_service will be the count of values x in the Distribution such that range.min <= x < range.max.
        :param str distribution_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries aggregating values. Must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param 'GoogleMonitoringV3RangeResponseArgs' range: Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        pulumi.set(__self__, "distribution_filter", distribution_filter)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries aggregating values. Must have ValueType = DISTRIBUTION and MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @property
    @pulumi.getter
    def range(self) -> 'outputs.GoogleMonitoringV3RangeResponse':
        """
        Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class DocumentationResponse(dict):
    """
    A content string and a MIME type that describes the content string's format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 mime_type: str):
        """
        A content string and a MIME type that describes the content string's format.
        :param str content: The text of the documentation, interpreted according to mime_type. The content may not exceed 8,192 Unicode characters and may not exceed more than 10,240 bytes when encoded in UTF-8 format, whichever is smaller.
        :param str mime_type: The format of the content field. Presently, only the value "text/markdown" is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for more information.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the documentation, interpreted according to mime_type. The content may not exceed 8,192 Unicode characters and may not exceed more than 10,240 bytes when encoded in UTF-8 format, whichever is smaller.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        The format of the content field. Presently, only the value "text/markdown" is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for more information.
        """
        return pulumi.get(self, "mime_type")


@pulumi.output_type
class GoogleMonitoringV3RangeResponse(dict):
    """
    Range of numerical values, inclusive of min and exclusive of max. If the open range "< range.max" is desired, set range.min = -infinity. If the open range ">= range.min" is desired, set range.max = infinity.
    """
    def __init__(__self__, *,
                 max: float,
                 min: float):
        """
        Range of numerical values, inclusive of min and exclusive of max. If the open range "< range.max" is desired, set range.min = -infinity. If the open range ">= range.min" is desired, set range.max = infinity.
        :param float max: Range maximum.
        :param float min: Range minimum.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        Range maximum.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        Range minimum.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class HttpCheckResponse(dict):
    """
    Information involved in an HTTP/HTTPS Uptime check request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authInfo":
            suggest = "auth_info"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "maskHeaders":
            suggest = "mask_headers"
        elif key == "requestMethod":
            suggest = "request_method"
        elif key == "useSsl":
            suggest = "use_ssl"
        elif key == "validateSsl":
            suggest = "validate_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_info: 'outputs.BasicAuthenticationResponse',
                 body: str,
                 content_type: str,
                 headers: Mapping[str, str],
                 mask_headers: bool,
                 path: str,
                 port: int,
                 request_method: str,
                 use_ssl: bool,
                 validate_ssl: bool):
        """
        Information involved in an HTTP/HTTPS Uptime check request.
        :param 'BasicAuthenticationResponseArgs' auth_info: The authentication information. Optional when creating an HTTP check; defaults to empty.
        :param str body: The request body associated with the HTTP POST request. If content_type is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the request_method is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note: As with all bytes fields, JSON representations are base64 encoded. e.g.: "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
        :param str content_type: The content type header to use for the check. The following configurations result in errors: 1. Content type is specified in both the headers field and the content_type field. 2. Request method is GET and content_type is not TYPE_UNSPECIFIED 3. Request method is POST and content_type is TYPE_UNSPECIFIED. 4. Request method is POST and a "Content-Type" header is provided via headers field. The content_type field should be used instead.
        :param Mapping[str, str] headers: The list of headers to send as part of the Uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        :param bool mask_headers: Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to true then the headers will be obscured with ******.
        :param str path: Optional (defaults to "/"). The path to the page against which to run the check. Will be combined with the host (specified within the monitored_resource) and port to construct the full URL. If the provided path does not begin with "/", a "/" will be prepended automatically.
        :param int port: Optional (defaults to 80 when use_ssl is false, and 443 when use_ssl is true). The TCP port on the HTTP server against which to run the check. Will be combined with host (specified within the monitored_resource) and path to construct the full URL.
        :param str request_method: The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then request_method defaults to GET.
        :param bool use_ssl: If true, use HTTPS instead of HTTP to run the check.
        :param bool validate_ssl: Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitored_resource is set to uptime_url. If use_ssl is false, setting validate_ssl to true has no effect.
        """
        pulumi.set(__self__, "auth_info", auth_info)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "mask_headers", mask_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "request_method", request_method)
        pulumi.set(__self__, "use_ssl", use_ssl)
        pulumi.set(__self__, "validate_ssl", validate_ssl)

    @property
    @pulumi.getter(name="authInfo")
    def auth_info(self) -> 'outputs.BasicAuthenticationResponse':
        """
        The authentication information. Optional when creating an HTTP check; defaults to empty.
        """
        return pulumi.get(self, "auth_info")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The request body associated with the HTTP POST request. If content_type is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the request_method is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note: As with all bytes fields, JSON representations are base64 encoded. e.g.: "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type header to use for the check. The following configurations result in errors: 1. Content type is specified in both the headers field and the content_type field. 2. Request method is GET and content_type is not TYPE_UNSPECIFIED 3. Request method is POST and content_type is TYPE_UNSPECIFIED. 4. Request method is POST and a "Content-Type" header is provided via headers field. The content_type field should be used instead.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        """
        The list of headers to send as part of the Uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="maskHeaders")
    def mask_headers(self) -> bool:
        """
        Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to true then the headers will be obscured with ******.
        """
        return pulumi.get(self, "mask_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Optional (defaults to "/"). The path to the page against which to run the check. Will be combined with the host (specified within the monitored_resource) and port to construct the full URL. If the provided path does not begin with "/", a "/" will be prepended automatically.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Optional (defaults to 80 when use_ssl is false, and 443 when use_ssl is true). The TCP port on the HTTP server against which to run the check. Will be combined with host (specified within the monitored_resource) and path to construct the full URL.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> str:
        """
        The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then request_method defaults to GET.
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> bool:
        """
        If true, use HTTPS instead of HTTP to run the check.
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter(name="validateSsl")
    def validate_ssl(self) -> bool:
        """
        Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitored_resource is set to uptime_url. If use_ssl is false, setting validate_ssl to true has no effect.
        """
        return pulumi.get(self, "validate_ssl")


@pulumi.output_type
class InternalCheckerResponse(dict):
    """
    An internal checker allows Uptime checks to run on private/internal GCP resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "gcpZone":
            suggest = "gcp_zone"
        elif key == "peerProjectId":
            suggest = "peer_project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternalCheckerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternalCheckerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternalCheckerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 gcp_zone: str,
                 name: str,
                 network: str,
                 peer_project_id: str,
                 state: str):
        """
        An internal checker allows Uptime checks to run on private/internal GCP resources.
        :param str display_name: The checker's human-readable name. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        :param str gcp_zone: The GCP zone the Uptime check should egress from. Only respected for internal Uptime checks, where internal_network is specified.
        :param str name: A unique resource name for this InternalChecker. The format is: projects/[PROJECT_ID_OR_NUMBER]/internalCheckers/[INTERNAL_CHECKER_ID] [PROJECT_ID_OR_NUMBER] is the Stackdriver Workspace project for the Uptime check config associated with the internal checker.
        :param str network: The GCP VPC network (https://cloud.google.com/vpc/docs/vpc) where the internal resource lives (ex: "default").
        :param str peer_project_id: The GCP project ID where the internal checker lives. Not necessary the same as the Workspace project.
        :param str state: The current operational state of the internal checker.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gcp_zone", gcp_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "peer_project_id", peer_project_id)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The checker's human-readable name. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gcpZone")
    def gcp_zone(self) -> str:
        """
        The GCP zone the Uptime check should egress from. Only respected for internal Uptime checks, where internal_network is specified.
        """
        return pulumi.get(self, "gcp_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique resource name for this InternalChecker. The format is: projects/[PROJECT_ID_OR_NUMBER]/internalCheckers/[INTERNAL_CHECKER_ID] [PROJECT_ID_OR_NUMBER] is the Stackdriver Workspace project for the Uptime check config associated with the internal checker.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The GCP VPC network (https://cloud.google.com/vpc/docs/vpc) where the internal resource lives (ex: "default").
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="peerProjectId")
    def peer_project_id(self) -> str:
        """
        The GCP project ID where the internal checker lives. Not necessary the same as the Workspace project.
        """
        return pulumi.get(self, "peer_project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current operational state of the internal checker.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class IstioCanonicalServiceResponse(dict):
    """
    Canonical service scoped to an Istio mesh. Anthos clusters running ASM >= 1.6.8 will have their services ingested as this type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalService":
            suggest = "canonical_service"
        elif key == "canonicalServiceNamespace":
            suggest = "canonical_service_namespace"
        elif key == "meshUid":
            suggest = "mesh_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IstioCanonicalServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IstioCanonicalServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IstioCanonicalServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_service: str,
                 canonical_service_namespace: str,
                 mesh_uid: str):
        """
        Canonical service scoped to an Istio mesh. Anthos clusters running ASM >= 1.6.8 will have their services ingested as this type.
        :param str canonical_service: The name of the canonical service underlying this service. Corresponds to the destination_canonical_service_name metric label in label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        :param str canonical_service_namespace: The namespace of the canonical service underlying this service. Corresponds to the destination_canonical_service_namespace metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        :param str mesh_uid: Identifier for the Istio mesh in which this canonical service is defined. Corresponds to the mesh_uid metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        pulumi.set(__self__, "canonical_service", canonical_service)
        pulumi.set(__self__, "canonical_service_namespace", canonical_service_namespace)
        pulumi.set(__self__, "mesh_uid", mesh_uid)

    @property
    @pulumi.getter(name="canonicalService")
    def canonical_service(self) -> str:
        """
        The name of the canonical service underlying this service. Corresponds to the destination_canonical_service_name metric label in label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "canonical_service")

    @property
    @pulumi.getter(name="canonicalServiceNamespace")
    def canonical_service_namespace(self) -> str:
        """
        The namespace of the canonical service underlying this service. Corresponds to the destination_canonical_service_namespace metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "canonical_service_namespace")

    @property
    @pulumi.getter(name="meshUid")
    def mesh_uid(self) -> str:
        """
        Identifier for the Istio mesh in which this canonical service is defined. Corresponds to the mesh_uid metric label in Istio metrics (https://cloud.google.com/monitoring/api/metrics_istio).
        """
        return pulumi.get(self, "mesh_uid")


@pulumi.output_type
class LabelDescriptorResponse(dict):
    """
    A description of a label.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 key: str,
                 value_type: str):
        """
        A description of a label.
        :param str description: A human-readable description for the label.
        :param str key: The key for this label. The key must meet the following criteria: Does not exceed 100 characters. Matches the following regular expression: [a-zA-Z][a-zA-Z0-9_]* The first character must be an upper- or lower-case letter. The remaining characters must be letters, digits, or underscores.
        :param str value_type: The type of data that can be assigned to the label.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key for this label. The key must meet the following criteria: Does not exceed 100 characters. Matches the following regular expression: [a-zA-Z][a-zA-Z0-9_]* The first character must be an upper- or lower-case letter. The remaining characters must be letters, digits, or underscores.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of data that can be assigned to the label.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class LatencyCriteriaResponse(dict):
    """
    Parameters for a latency threshold SLI.
    """
    def __init__(__self__, *,
                 threshold: str):
        """
        Parameters for a latency threshold SLI.
        :param str threshold: Good service is defined to be the count of requests made to this service that return in no more than threshold.
        """
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> str:
        """
        Good service is defined to be the count of requests made to this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class MeshIstioResponse(dict):
    """
    Istio service scoped to an Istio mesh. Anthos clusters running ASM < 1.6.8 will have their services ingested as this type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "meshUid":
            suggest = "mesh_uid"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "serviceNamespace":
            suggest = "service_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MeshIstioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MeshIstioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MeshIstioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mesh_uid: str,
                 service_name: str,
                 service_namespace: str):
        """
        Istio service scoped to an Istio mesh. Anthos clusters running ASM < 1.6.8 will have their services ingested as this type.
        :param str mesh_uid: Identifier for the mesh in which this Istio service is defined. Corresponds to the mesh_uid metric label in Istio metrics.
        :param str service_name: The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        :param str service_namespace: The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        pulumi.set(__self__, "mesh_uid", mesh_uid)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_namespace", service_namespace)

    @property
    @pulumi.getter(name="meshUid")
    def mesh_uid(self) -> str:
        """
        Identifier for the mesh in which this Istio service is defined. Corresponds to the mesh_uid metric label in Istio metrics.
        """
        return pulumi.get(self, "mesh_uid")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the Istio service underlying this service. Corresponds to the destination_service_name metric label in Istio metrics.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> str:
        """
        The namespace of the Istio service underlying this service. Corresponds to the destination_service_namespace metric label in Istio metrics.
        """
        return pulumi.get(self, "service_namespace")


@pulumi.output_type
class MetricAbsenceResponse(dict):
    """
    A condition type that checks that monitored resources are reporting data. The configuration defines a metric and a set of monitored resources. The predicate is considered in violation when a time series for the specified metric of a monitored resource does not include any data in the specified duration.
    """
    def __init__(__self__, *,
                 aggregations: Sequence['outputs.AggregationResponse'],
                 duration: str,
                 filter: str,
                 trigger: 'outputs.TriggerResponse'):
        """
        A condition type that checks that monitored resources are reporting data. The configuration defines a metric and a set of monitored resources. The predicate is considered in violation when a time series for the specified metric of a monitored resource does not include any data in the specified duration.
        :param Sequence['AggregationResponseArgs'] aggregations: Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resrouces). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        :param str duration: The amount of time that a time series must fail to report new data to be considered failing. The minimum value of this field is 120 seconds. Larger values that are a multiple of a minute--for example, 240 or 300 seconds--are supported. If an invalid value is given, an error will be returned. The Duration.nanos field is ignored.
        :param str filter: Required. A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        :param 'TriggerResponseArgs' trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations.
        """
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence['outputs.AggregationResponse']:
        """
        Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resrouces). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must fail to report new data to be considered failing. The minimum value of this field is 120 seconds. Larger values that are a multiple of a minute--for example, 240 or 300 seconds--are supported. If an invalid value is given, an error will be returned. The Duration.nanos field is ignored.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Required. A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.TriggerResponse':
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class MetricDescriptorMetadataResponse(dict):
    """
    Additional annotations that can be used to guide the usage of a metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestDelay":
            suggest = "ingest_delay"
        elif key == "samplePeriod":
            suggest = "sample_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingest_delay: str,
                 sample_period: str):
        """
        Additional annotations that can be used to guide the usage of a metric.
        :param str ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        :param str sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        pulumi.set(__self__, "ingest_delay", ingest_delay)
        pulumi.set(__self__, "sample_period", sample_period)

    @property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> str:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        """
        return pulumi.get(self, "ingest_delay")

    @property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> str:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        return pulumi.get(self, "sample_period")


@pulumi.output_type
class MetricRangeResponse(dict):
    """
    A MetricRange is used when each window is good when the value x of a single TimeSeries satisfies range.min <= x < range.max. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSeries":
            suggest = "time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: 'outputs.GoogleMonitoringV3RangeResponse',
                 time_series: str):
        """
        A MetricRange is used when each window is good when the value x of a single TimeSeries satisfies range.min <= x < range.max. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
        :param 'GoogleMonitoringV3RangeResponseArgs' range: Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        :param str time_series: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "time_series", time_series)

    @property
    @pulumi.getter
    def range(self) -> 'outputs.GoogleMonitoringV3RangeResponse':
        """
        Range of values considered "good." For a one-sided range, set one bound to an infinite value.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality.
        """
        return pulumi.get(self, "time_series")


@pulumi.output_type
class MetricThresholdResponse(dict):
    """
    A condition type that compares a collection of time series against a threshold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denominatorAggregations":
            suggest = "denominator_aggregations"
        elif key == "denominatorFilter":
            suggest = "denominator_filter"
        elif key == "thresholdValue":
            suggest = "threshold_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricThresholdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricThresholdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricThresholdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregations: Sequence['outputs.AggregationResponse'],
                 comparison: str,
                 denominator_aggregations: Sequence['outputs.AggregationResponse'],
                 denominator_filter: str,
                 duration: str,
                 filter: str,
                 threshold_value: float,
                 trigger: 'outputs.TriggerResponse'):
        """
        A condition type that compares a collection of time series against a threshold.
        :param Sequence['AggregationResponseArgs'] aggregations: Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resrouces). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        :param str comparison: The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value). The comparison is applied on each time series, with the time series on the left-hand side and the threshold on the right-hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.
        :param Sequence['AggregationResponseArgs'] denominator_aggregations: Specifies the alignment of data points in individual time series selected by denominatorFilter as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources).When computing ratios, the aggregations and denominator_aggregations fields must use the same alignment period and produce time series that have the same periodicity and labels.
        :param str denominator_filter: A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold. If a denominator_filter is specified, the time series specified by the filter field will be used as the numerator.The filter must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
        :param str duration: The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        :param str filter: Required. A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        :param float threshold_value: A value against which to compare the time series.
        :param 'TriggerResponseArgs' trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "denominator_aggregations", denominator_aggregations)
        pulumi.set(__self__, "denominator_filter", denominator_filter)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "threshold_value", threshold_value)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence['outputs.AggregationResponse']:
        """
        Specifies the alignment of data points in individual time series as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resrouces). Multiple aggregations are applied in the order specified.This field is similar to the one in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list). It is advisable to use the ListTimeSeries method when debugging this field.
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def comparison(self) -> str:
        """
        The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value). The comparison is applied on each time series, with the time series on the left-hand side and the threshold on the right-hand side.Only COMPARISON_LT and COMPARISON_GT are supported currently.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter(name="denominatorAggregations")
    def denominator_aggregations(self) -> Sequence['outputs.AggregationResponse']:
        """
        Specifies the alignment of data points in individual time series selected by denominatorFilter as well as how to combine the retrieved time series together (such as when aggregating multiple streams on each resource to a single stream for each resource or when aggregating streams across all members of a group of resources).When computing ratios, the aggregations and denominator_aggregations fields must use the same alignment period and produce time series that have the same periodicity and labels.
        """
        return pulumi.get(self, "denominator_aggregations")

    @property
    @pulumi.getter(name="denominatorFilter")
    def denominator_filter(self) -> str:
        """
        A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold. If a denominator_filter is specified, the time series specified by the filter field will be used as the numerator.The filter must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "denominator_filter")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Required. A filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the ListTimeSeries request (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) (that call is useful to verify the time series that will be retrieved / processed). The filter must specify the metric type and the resource type. Optionally, it can specify resource labels and metric labels. This field must not exceed 2048 Unicode characters in length.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="thresholdValue")
    def threshold_value(self) -> float:
        """
        A value against which to compare the time series.
        """
        return pulumi.get(self, "threshold_value")

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.TriggerResponse':
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class MonitoredResourceResponse(dict):
    """
    An object representing a resource that can be used for monitoring, logging, billing, or other purposes. Examples include virtual machine instances, databases, and storage devices such as disks. The type field identifies a MonitoredResourceDescriptor object that describes the resource's schema. Information in the labels field identifies the actual resource and its attributes according to the schema. For example, a particular Compute Engine VM instance could be represented by the following object, because the MonitoredResourceDescriptor for "gce_instance" has labels "instance_id" and "zone": { "type": "gce_instance", "labels": { "instance_id": "12345678901234", "zone": "us-central1-a" }} 
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str],
                 type: str):
        """
        An object representing a resource that can be used for monitoring, logging, billing, or other purposes. Examples include virtual machine instances, databases, and storage devices such as disks. The type field identifies a MonitoredResourceDescriptor object that describes the resource's schema. Information in the labels field identifies the actual resource and its attributes according to the schema. For example, a particular Compute Engine VM instance could be represented by the following object, because the MonitoredResourceDescriptor for "gce_instance" has labels "instance_id" and "zone": { "type": "gce_instance", "labels": { "instance_id": "12345678901234", "zone": "us-central1-a" }} 
        :param Mapping[str, str] labels: Required. Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        :param str type: Required. The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types and Logging resource types.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Required. Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types and Logging resource types.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoringQueryLanguageConditionResponse(dict):
    """
    A condition type that allows alert policies to be defined using Monitoring Query Language (https://cloud.google.com/monitoring/mql).
    """
    def __init__(__self__, *,
                 duration: str,
                 query: str,
                 trigger: 'outputs.TriggerResponse'):
        """
        A condition type that allows alert policies to be defined using Monitoring Query Language (https://cloud.google.com/monitoring/mql).
        :param str duration: The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        :param str query: Monitoring Query Language (https://cloud.google.com/monitoring/mql) query that outputs a boolean stream.
        :param 'TriggerResponseArgs' trigger: The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must violate the threshold to be considered failing. Currently, only values that are a multiple of a minute--e.g., 0, 60, 120, or 300 seconds--are supported. If an invalid value is given, an error will be returned. When choosing a duration, it is useful to keep in mind the frequency of the underlying time series data (which may also be affected by any alignments specified in the aggregations field); a good duration is long enough so that a single outlier does not generate spurious alerts, but short enough that unhealthy states are detected and alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Monitoring Query Language (https://cloud.google.com/monitoring/mql) query that outputs a boolean stream.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.TriggerResponse':
        """
        The number/percent of time series for which the comparison must hold in order for the condition to trigger. If unspecified, then the condition will trigger if the comparison is true for any of the time series that have been identified by filter and aggregations, or by the ratio, if denominator_filter and denominator_aggregations are specified.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class MutationRecordResponse(dict):
    """
    Describes a change made to a configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mutateTime":
            suggest = "mutate_time"
        elif key == "mutatedBy":
            suggest = "mutated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MutationRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MutationRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MutationRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mutate_time: str,
                 mutated_by: str):
        """
        Describes a change made to a configuration.
        :param str mutate_time: When the change occurred.
        :param str mutated_by: The email address of the user making the change.
        """
        pulumi.set(__self__, "mutate_time", mutate_time)
        pulumi.set(__self__, "mutated_by", mutated_by)

    @property
    @pulumi.getter(name="mutateTime")
    def mutate_time(self) -> str:
        """
        When the change occurred.
        """
        return pulumi.get(self, "mutate_time")

    @property
    @pulumi.getter(name="mutatedBy")
    def mutated_by(self) -> str:
        """
        The email address of the user making the change.
        """
        return pulumi.get(self, "mutated_by")


@pulumi.output_type
class PerformanceThresholdResponse(dict):
    """
    A PerformanceThreshold is used when each window is good when that window has a sufficiently high performance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicSliPerformance":
            suggest = "basic_sli_performance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerformanceThresholdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerformanceThresholdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerformanceThresholdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_sli_performance: 'outputs.BasicSliResponse',
                 performance: 'outputs.RequestBasedSliResponse',
                 threshold: float):
        """
        A PerformanceThreshold is used when each window is good when that window has a sufficiently high performance.
        :param 'BasicSliResponseArgs' basic_sli_performance: BasicSli to evaluate to judge window quality.
        :param 'RequestBasedSliResponseArgs' performance: RequestBasedSli to evaluate to judge window quality.
        :param float threshold: If window performance >= threshold, the window is counted as good.
        """
        pulumi.set(__self__, "basic_sli_performance", basic_sli_performance)
        pulumi.set(__self__, "performance", performance)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="basicSliPerformance")
    def basic_sli_performance(self) -> 'outputs.BasicSliResponse':
        """
        BasicSli to evaluate to judge window quality.
        """
        return pulumi.get(self, "basic_sli_performance")

    @property
    @pulumi.getter
    def performance(self) -> 'outputs.RequestBasedSliResponse':
        """
        RequestBasedSli to evaluate to judge window quality.
        """
        return pulumi.get(self, "performance")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        If window performance >= threshold, the window is counted as good.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class RequestBasedSliResponse(dict):
    """
    Service Level Indicators for which atomic units of service are counted directly.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionCut":
            suggest = "distribution_cut"
        elif key == "goodTotalRatio":
            suggest = "good_total_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestBasedSliResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestBasedSliResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestBasedSliResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_cut: 'outputs.DistributionCutResponse',
                 good_total_ratio: 'outputs.TimeSeriesRatioResponse'):
        """
        Service Level Indicators for which atomic units of service are counted directly.
        :param 'DistributionCutResponseArgs' distribution_cut: distribution_cut is used when good_service is a count of values aggregated in a Distribution that fall into a good range. The total_service is the total count of all values aggregated in the Distribution.
        :param 'TimeSeriesRatioResponseArgs' good_total_ratio: good_total_ratio is used when the ratio of good_service to total_service is computed from two TimeSeries.
        """
        pulumi.set(__self__, "distribution_cut", distribution_cut)
        pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> 'outputs.DistributionCutResponse':
        """
        distribution_cut is used when good_service is a count of values aggregated in a Distribution that fall into a good range. The total_service is the total count of all values aggregated in the Distribution.
        """
        return pulumi.get(self, "distribution_cut")

    @property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> 'outputs.TimeSeriesRatioResponse':
        """
        good_total_ratio is used when the ratio of good_service to total_service is computed from two TimeSeries.
        """
        return pulumi.get(self, "good_total_ratio")


@pulumi.output_type
class ResourceGroupResponse(dict):
    """
    The resource submessage for group checks. It can be used instead of a monitored resource, when multiple resources are being monitored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: str,
                 resource_type: str):
        """
        The resource submessage for group checks. It can be used instead of a monitored resource, when multiple resources are being monitored.
        :param str group_id: The group of resources being monitored. Should be only the [GROUP_ID], and not the full-path projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID].
        :param str resource_type: The resource type of the group members.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The group of resources being monitored. Should be only the [GROUP_ID], and not the full-path projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID].
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type of the group members.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class ServiceLevelIndicatorResponse(dict):
    """
    A Service-Level Indicator (SLI) describes the "performance" of a service. For some services, the SLI is well-defined. In such cases, the SLI can be described easily by referencing the well-known SLI and providing the needed parameters. Alternatively, a "custom" SLI can be defined with a query to the underlying metric store. An SLI is defined to be good_service / total_service over any queried time interval. The value of performance always falls into the range 0 <= performance <= 1. A custom SLI describes how to compute this ratio, whether this is by dividing values from a pair of time series, cutting a Distribution into good and bad counts, or counting time windows in which the service complies with a criterion. For separation of concerns, a single Service-Level Indicator measures performance for only one aspect of service quality, such as fraction of successful queries or fast-enough queries.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicSli":
            suggest = "basic_sli"
        elif key == "requestBased":
            suggest = "request_based"
        elif key == "windowsBased":
            suggest = "windows_based"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelIndicatorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelIndicatorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelIndicatorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_sli: 'outputs.BasicSliResponse',
                 request_based: 'outputs.RequestBasedSliResponse',
                 windows_based: 'outputs.WindowsBasedSliResponse'):
        """
        A Service-Level Indicator (SLI) describes the "performance" of a service. For some services, the SLI is well-defined. In such cases, the SLI can be described easily by referencing the well-known SLI and providing the needed parameters. Alternatively, a "custom" SLI can be defined with a query to the underlying metric store. An SLI is defined to be good_service / total_service over any queried time interval. The value of performance always falls into the range 0 <= performance <= 1. A custom SLI describes how to compute this ratio, whether this is by dividing values from a pair of time series, cutting a Distribution into good and bad counts, or counting time windows in which the service complies with a criterion. For separation of concerns, a single Service-Level Indicator measures performance for only one aspect of service quality, such as fraction of successful queries or fast-enough queries.
        :param 'BasicSliResponseArgs' basic_sli: Basic SLI on a well-known service type.
        :param 'RequestBasedSliResponseArgs' request_based: Request-based SLIs
        :param 'WindowsBasedSliResponseArgs' windows_based: Windows-based SLIs
        """
        pulumi.set(__self__, "basic_sli", basic_sli)
        pulumi.set(__self__, "request_based", request_based)
        pulumi.set(__self__, "windows_based", windows_based)

    @property
    @pulumi.getter(name="basicSli")
    def basic_sli(self) -> 'outputs.BasicSliResponse':
        """
        Basic SLI on a well-known service type.
        """
        return pulumi.get(self, "basic_sli")

    @property
    @pulumi.getter(name="requestBased")
    def request_based(self) -> 'outputs.RequestBasedSliResponse':
        """
        Request-based SLIs
        """
        return pulumi.get(self, "request_based")

    @property
    @pulumi.getter(name="windowsBased")
    def windows_based(self) -> 'outputs.WindowsBasedSliResponse':
        """
        Windows-based SLIs
        """
        return pulumi.get(self, "windows_based")


@pulumi.output_type
class StatusResponse(dict):
    """
    The Status type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each Status message contains three pieces of data: error code, error message, and error details.You can find out more about this error model and how to work with it in the API Design Guide (https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The Status type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each Status message contains three pieces of data: error code, error message, and error details.You can find out more about this error model and how to work with it in the API Design Guide (https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class TcpCheckResponse(dict):
    """
    Information required for a TCP Uptime check request.
    """
    def __init__(__self__, *,
                 port: int):
        """
        Information required for a TCP Uptime check request.
        :param int port: The TCP port on the server against which to run the check. Will be combined with host (specified within the monitored_resource) to construct the full URL. Required.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port on the server against which to run the check. Will be combined with host (specified within the monitored_resource) to construct the full URL. Required.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TelemetryResponse(dict):
    """
    Configuration for how to query telemetry on a Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelemetryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelemetryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelemetryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: str):
        """
        Configuration for how to query telemetry on a Service.
        :param str resource_name: The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
        """
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class TimeSeriesRatioResponse(dict):
    """
    A TimeSeriesRatio specifies two TimeSeries to use for computing the good_service / total_service ratio. The specified TimeSeries must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE. The TimeSeriesRatio must specify exactly two of good, bad, and total, and the relationship good_service + bad_service = total_service will be assumed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badServiceFilter":
            suggest = "bad_service_filter"
        elif key == "goodServiceFilter":
            suggest = "good_service_filter"
        elif key == "totalServiceFilter":
            suggest = "total_service_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSeriesRatioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSeriesRatioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSeriesRatioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_service_filter: str,
                 good_service_filter: str,
                 total_service_filter: str):
        """
        A TimeSeriesRatio specifies two TimeSeries to use for computing the good_service / total_service ratio. The specified TimeSeries must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE. The TimeSeriesRatio must specify exactly two of good, bad, and total, and the relationship good_service + bad_service = total_service will be assumed.
        :param str bad_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying bad service, either demanded service that was not provided or demanded service that was of inadequate quality. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str good_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str total_service_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying total demanded service. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        pulumi.set(__self__, "good_service_filter", good_service_filter)
        pulumi.set(__self__, "total_service_filter", total_service_filter)

    @property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying bad service, either demanded service that was not provided or demanded service that was of inadequate quality. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries quantifying total demanded service. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")


@pulumi.output_type
class TriggerResponse(dict):
    """
    Specifies how many time series must fail a predicate to trigger a condition. If not specified, then a {count: 1} trigger is used.
    """
    def __init__(__self__, *,
                 count: int,
                 percent: float):
        """
        Specifies how many time series must fail a predicate to trigger a condition. If not specified, then a {count: 1} trigger is used.
        :param int count: The absolute number of time series that must fail the predicate for the condition to be triggered.
        :param float percent: The percentage of time series that must fail the predicate for the condition to be triggered.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The absolute number of time series that must fail the predicate for the condition to be triggered.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def percent(self) -> float:
        """
        The percentage of time series that must fail the predicate for the condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class WindowsBasedSliResponse(dict):
    """
    A WindowsBasedSli defines good_service as the count of time windows for which the provided service was of good quality. Criteria for determining if service was good are embedded in the window_criterion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "goodBadMetricFilter":
            suggest = "good_bad_metric_filter"
        elif key == "goodTotalRatioThreshold":
            suggest = "good_total_ratio_threshold"
        elif key == "metricMeanInRange":
            suggest = "metric_mean_in_range"
        elif key == "metricSumInRange":
            suggest = "metric_sum_in_range"
        elif key == "windowPeriod":
            suggest = "window_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsBasedSliResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsBasedSliResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsBasedSliResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 good_bad_metric_filter: str,
                 good_total_ratio_threshold: 'outputs.PerformanceThresholdResponse',
                 metric_mean_in_range: 'outputs.MetricRangeResponse',
                 metric_sum_in_range: 'outputs.MetricRangeResponse',
                 window_period: str):
        """
        A WindowsBasedSli defines good_service as the count of time windows for which the provided service was of good quality. Criteria for determining if service was good are embedded in the window_criterion.
        :param str good_bad_metric_filter: A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries with ValueType = BOOL. The window is good if any true values appear in the window.
        :param 'PerformanceThresholdResponseArgs' good_total_ratio_threshold: A window is good if its performance is high enough.
        :param 'MetricRangeResponseArgs' metric_mean_in_range: A window is good if the metric's value is in a good range, averaged across returned streams.
        :param 'MetricRangeResponseArgs' metric_sum_in_range: A window is good if the metric's value is in a good range, summed across returned streams.
        :param str window_period: Duration over which window quality is evaluated. Must be an integer fraction of a day and at least 60s.
        """
        pulumi.set(__self__, "good_bad_metric_filter", good_bad_metric_filter)
        pulumi.set(__self__, "good_total_ratio_threshold", good_total_ratio_threshold)
        pulumi.set(__self__, "metric_mean_in_range", metric_mean_in_range)
        pulumi.set(__self__, "metric_sum_in_range", metric_sum_in_range)
        pulumi.set(__self__, "window_period", window_period)

    @property
    @pulumi.getter(name="goodBadMetricFilter")
    def good_bad_metric_filter(self) -> str:
        """
        A monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) specifying a TimeSeries with ValueType = BOOL. The window is good if any true values appear in the window.
        """
        return pulumi.get(self, "good_bad_metric_filter")

    @property
    @pulumi.getter(name="goodTotalRatioThreshold")
    def good_total_ratio_threshold(self) -> 'outputs.PerformanceThresholdResponse':
        """
        A window is good if its performance is high enough.
        """
        return pulumi.get(self, "good_total_ratio_threshold")

    @property
    @pulumi.getter(name="metricMeanInRange")
    def metric_mean_in_range(self) -> 'outputs.MetricRangeResponse':
        """
        A window is good if the metric's value is in a good range, averaged across returned streams.
        """
        return pulumi.get(self, "metric_mean_in_range")

    @property
    @pulumi.getter(name="metricSumInRange")
    def metric_sum_in_range(self) -> 'outputs.MetricRangeResponse':
        """
        A window is good if the metric's value is in a good range, summed across returned streams.
        """
        return pulumi.get(self, "metric_sum_in_range")

    @property
    @pulumi.getter(name="windowPeriod")
    def window_period(self) -> str:
        """
        Duration over which window quality is evaluated. Must be an integer fraction of a day and at least 60s.
        """
        return pulumi.get(self, "window_period")


