# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'DataCatalogConfigResponse',
    'DatabaseDumpResponse',
    'ExprResponse',
    'HiveMetastoreConfigResponse',
    'KerberosConfigResponse',
    'MaintenanceWindowResponse',
    'MetadataExportResponse',
    'MetadataIntegrationResponse',
    'MetadataManagementActivityResponse',
    'RestoreResponse',
    'SecretResponse',
    'ServiceResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.If there are AuditConfigs for both allServices and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.If there are AuditConfigs for both allServices and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponseArgs'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, storage.googleapis.com, cloudsql.googleapis.com. allServices is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates members with a role.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates members with a role.
        :param 'ExprResponseArgs' condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        :param str role: Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class DataCatalogConfigResponse(dict):
    """
    Specifies how metastore metadata should be integrated with the Data Catalog service.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Specifies how metastore metadata should be integrated with the Data Catalog service.
        :param bool enabled: Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DatabaseDumpResponse(dict):
    """
    A specification of the location of and metadata about a database dump from a relational database management system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseType":
            suggest = "database_type"
        elif key == "gcsUri":
            suggest = "gcs_uri"
        elif key == "sourceDatabase":
            suggest = "source_database"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseDumpResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseDumpResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseDumpResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_type: str,
                 gcs_uri: str,
                 source_database: str,
                 type: str):
        """
        A specification of the location of and metadata about a database dump from a relational database management system.
        :param str database_type: The type of the database.
        :param str gcs_uri: A Cloud Storage object or folder URI that specifies the source from which to import metadata. It must begin with gs://.
        :param str source_database: The name of the source database.
        :param str type: Optional. The type of the database dump. If unspecified, defaults to MYSQL.
        """
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "gcs_uri", gcs_uri)
        pulumi.set(__self__, "source_database", source_database)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        """
        The type of the database.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> str:
        """
        A Cloud Storage object or folder URI that specifies the source from which to import metadata. It must begin with gs://.
        """
        return pulumi.get(self, "gcs_uri")

    @property
    @pulumi.getter(name="sourceDatabase")
    def source_database(self) -> str:
        """
        The name of the source database.
        """
        return pulumi.get(self, "source_database")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Optional. The type of the database dump. If unspecified, defaults to MYSQL.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class HiveMetastoreConfigResponse(dict):
    """
    Specifies configuration information specific to running Hive metastore software as the metastore service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configOverrides":
            suggest = "config_overrides"
        elif key == "kerberosConfig":
            suggest = "kerberos_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HiveMetastoreConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HiveMetastoreConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HiveMetastoreConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_overrides: Mapping[str, str],
                 kerberos_config: 'outputs.KerberosConfigResponse',
                 version: str):
        """
        Specifies configuration information specific to running Hive metastore software as the metastore service.
        :param Mapping[str, str] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml). The mappings override system defaults (some keys cannot be overridden).
        :param 'KerberosConfigResponseArgs' kerberos_config: Information used to configure the Hive metastore service as a service principal in a Kerberos realm. To disable Kerberos, use the UpdateService method and specify this field's path (hive_metastore_config.kerberos_config) in the request's update_mask while omitting this field from the request's service.
        :param str version: Immutable. The Hive metastore schema version.
        """
        pulumi.set(__self__, "config_overrides", config_overrides)
        pulumi.set(__self__, "kerberos_config", kerberos_config)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Mapping[str, str]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml). The mappings override system defaults (some keys cannot be overridden).
        """
        return pulumi.get(self, "config_overrides")

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> 'outputs.KerberosConfigResponse':
        """
        Information used to configure the Hive metastore service as a service principal in a Kerberos realm. To disable Kerberos, use the UpdateService method and specify this field's path (hive_metastore_config.kerberos_config) in the request's update_mask while omitting this field from the request's service.
        """
        return pulumi.get(self, "kerberos_config")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Immutable. The Hive metastore schema version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class KerberosConfigResponse(dict):
    """
    Configuration information for a Kerberos principal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "krb5ConfigGcsUri":
            suggest = "krb5_config_gcs_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KerberosConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KerberosConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KerberosConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keytab: 'outputs.SecretResponse',
                 krb5_config_gcs_uri: str,
                 principal: str):
        """
        Configuration information for a Kerberos principal.
        :param 'SecretResponseArgs' keytab: A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        :param str krb5_config_gcs_uri: A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        :param str principal: A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form primary/instance@REALM, but there is no exact format.
        """
        pulumi.set(__self__, "keytab", keytab)
        pulumi.set(__self__, "krb5_config_gcs_uri", krb5_config_gcs_uri)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def keytab(self) -> 'outputs.SecretResponse':
        """
        A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        """
        return pulumi.get(self, "keytab")

    @property
    @pulumi.getter(name="krb5ConfigGcsUri")
    def krb5_config_gcs_uri(self) -> str:
        """
        A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        """
        return pulumi.get(self, "krb5_config_gcs_uri")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form primary/instance@REALM, but there is no exact format.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    Maintenance window. This specifies when Dataproc Metastore may perform system maintenance operation to the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "hourOfDay":
            suggest = "hour_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 hour_of_day: int):
        """
        Maintenance window. This specifies when Dataproc Metastore may perform system maintenance operation to the service.
        :param str day_of_week: The day of week, when the window starts.
        :param int hour_of_day: The hour of day (0-23) when the window starts.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        The day of week, when the window starts.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> int:
        """
        The hour of day (0-23) when the window starts.
        """
        return pulumi.get(self, "hour_of_day")


@pulumi.output_type
class MetadataExportResponse(dict):
    """
    The details of a metadata export operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseDumpType":
            suggest = "database_dump_type"
        elif key == "destinationGcsUri":
            suggest = "destination_gcs_uri"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataExportResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataExportResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataExportResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_dump_type: str,
                 destination_gcs_uri: str,
                 end_time: str,
                 start_time: str,
                 state: str):
        """
        The details of a metadata export operation.
        :param str database_dump_type: The type of the database dump.
        :param str destination_gcs_uri: A Cloud Storage URI of a folder that metadata are exported to, in the form of gs:////, where is automatically generated.
        :param str end_time: The time when the export ended.
        :param str start_time: The time when the export started.
        :param str state: The current state of the export.
        """
        pulumi.set(__self__, "database_dump_type", database_dump_type)
        pulumi.set(__self__, "destination_gcs_uri", destination_gcs_uri)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="databaseDumpType")
    def database_dump_type(self) -> str:
        """
        The type of the database dump.
        """
        return pulumi.get(self, "database_dump_type")

    @property
    @pulumi.getter(name="destinationGcsUri")
    def destination_gcs_uri(self) -> str:
        """
        A Cloud Storage URI of a folder that metadata are exported to, in the form of gs:////, where is automatically generated.
        """
        return pulumi.get(self, "destination_gcs_uri")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time when the export ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time when the export started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the export.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MetadataIntegrationResponse(dict):
    """
    Specifies how metastore metadata should be integrated with external services.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCatalogConfig":
            suggest = "data_catalog_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataIntegrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataIntegrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataIntegrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_catalog_config: 'outputs.DataCatalogConfigResponse'):
        """
        Specifies how metastore metadata should be integrated with external services.
        :param 'DataCatalogConfigResponseArgs' data_catalog_config: The integration config for the Data Catalog service.
        """
        pulumi.set(__self__, "data_catalog_config", data_catalog_config)

    @property
    @pulumi.getter(name="dataCatalogConfig")
    def data_catalog_config(self) -> 'outputs.DataCatalogConfigResponse':
        """
        The integration config for the Data Catalog service.
        """
        return pulumi.get(self, "data_catalog_config")


@pulumi.output_type
class MetadataManagementActivityResponse(dict):
    """
    The metadata management activities of the metastore service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataExports":
            suggest = "metadata_exports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataManagementActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataManagementActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataManagementActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_exports: Sequence['outputs.MetadataExportResponse'],
                 restores: Sequence['outputs.RestoreResponse']):
        """
        The metadata management activities of the metastore service.
        :param Sequence['MetadataExportResponseArgs'] metadata_exports: The latest metadata exports of the metastore service.
        :param Sequence['RestoreResponseArgs'] restores: The latest restores of the metastore service.
        """
        pulumi.set(__self__, "metadata_exports", metadata_exports)
        pulumi.set(__self__, "restores", restores)

    @property
    @pulumi.getter(name="metadataExports")
    def metadata_exports(self) -> Sequence['outputs.MetadataExportResponse']:
        """
        The latest metadata exports of the metastore service.
        """
        return pulumi.get(self, "metadata_exports")

    @property
    @pulumi.getter
    def restores(self) -> Sequence['outputs.RestoreResponse']:
        """
        The latest restores of the metastore service.
        """
        return pulumi.get(self, "restores")


@pulumi.output_type
class RestoreResponse(dict):
    """
    The details of a metadata restore operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup: str,
                 details: str,
                 end_time: str,
                 start_time: str,
                 state: str,
                 type: str):
        """
        The details of a metadata restore operation.
        :param str backup: The relative resource name of the metastore service backup to restore from, in the following form:projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}.
        :param str details: The restore details containing the revision of the service to be restored to, in format of JSON.
        :param str end_time: The time when the restore ended.
        :param str start_time: The time when the restore started.
        :param str state: The current state of the restore.
        :param str type: The type of restore.
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backup(self) -> str:
        """
        The relative resource name of the metastore service backup to restore from, in the following form:projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        The restore details containing the revision of the service to be restored to, in format of JSON.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time when the restore ended.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time when the restore started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the restore.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of restore.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SecretResponse(dict):
    """
    A securely stored value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSecret":
            suggest = "cloud_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_secret: str):
        """
        A securely stored value.
        :param str cloud_secret: The relative resource name of a Secret Manager secret version, in the following form:projects/{project_number}/secrets/{secret_id}/versions/{version_id}.
        """
        pulumi.set(__self__, "cloud_secret", cloud_secret)

    @property
    @pulumi.getter(name="cloudSecret")
    def cloud_secret(self) -> str:
        """
        The relative resource name of a Secret Manager secret version, in the following form:projects/{project_number}/secrets/{secret_id}/versions/{version_id}.
        """
        return pulumi.get(self, "cloud_secret")


@pulumi.output_type
class ServiceResponse(dict):
    """
    A managed metastore service that serves metadata queries.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactGcsUri":
            suggest = "artifact_gcs_uri"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "hiveMetastoreConfig":
            suggest = "hive_metastore_config"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "metadataIntegration":
            suggest = "metadata_integration"
        elif key == "metadataManagementActivity":
            suggest = "metadata_management_activity"
        elif key == "releaseChannel":
            suggest = "release_channel"
        elif key == "stateMessage":
            suggest = "state_message"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_gcs_uri: str,
                 create_time: str,
                 endpoint_uri: str,
                 hive_metastore_config: 'outputs.HiveMetastoreConfigResponse',
                 labels: Mapping[str, str],
                 maintenance_window: 'outputs.MaintenanceWindowResponse',
                 metadata_integration: 'outputs.MetadataIntegrationResponse',
                 metadata_management_activity: 'outputs.MetadataManagementActivityResponse',
                 name: str,
                 network: str,
                 port: int,
                 release_channel: str,
                 state: str,
                 state_message: str,
                 tier: str,
                 uid: str,
                 update_time: str):
        """
        A managed metastore service that serves metadata queries.
        :param str artifact_gcs_uri: A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        :param str create_time: The time when the metastore service was created.
        :param str endpoint_uri: The URI of the endpoint used to access the metastore service.
        :param 'HiveMetastoreConfigResponseArgs' hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
        :param Mapping[str, str] labels: User-defined labels for the metastore service.
        :param 'MaintenanceWindowResponseArgs' maintenance_window: The one hour maintenance window of the metastore service. This specifies when the service can be restarted for maintenance purposes in UTC time.
        :param 'MetadataIntegrationResponseArgs' metadata_integration: The setting that defines how metastore metadata should be integrated with external services and systems.
        :param 'MetadataManagementActivityResponseArgs' metadata_management_activity: The metadata management activities of the metastore service.
        :param str name: Immutable. The relative resource name of the metastore service, of the form:projects/{project_number}/locations/{location_id}/services/{service_id}.
        :param str network: Immutable. The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:projects/{project_number}/global/networks/{network_id}.
        :param int port: The TCP port at which the metastore service is reached. Default: 9083.
        :param str release_channel: Immutable. The release channel of the service. If unspecified, defaults to STABLE.
        :param str state: The current state of the metastore service.
        :param str state_message: Additional information about the current state of the metastore service, if available.
        :param str tier: The tier of the service.
        :param str uid: The globally unique resource identifier of the metastore service.
        :param str update_time: The time when the metastore service was last updated.
        """
        pulumi.set(__self__, "artifact_gcs_uri", artifact_gcs_uri)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "hive_metastore_config", hive_metastore_config)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "metadata_integration", metadata_integration)
        pulumi.set(__self__, "metadata_management_activity", metadata_management_activity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "release_channel", release_channel)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="artifactGcsUri")
    def artifact_gcs_uri(self) -> str:
        """
        A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        """
        return pulumi.get(self, "artifact_gcs_uri")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the metastore service was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> str:
        """
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="hiveMetastoreConfig")
    def hive_metastore_config(self) -> 'outputs.HiveMetastoreConfigResponse':
        """
        Configuration information specific to running Hive metastore software as the metastore service.
        """
        return pulumi.get(self, "hive_metastore_config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-defined labels for the metastore service.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> 'outputs.MaintenanceWindowResponse':
        """
        The one hour maintenance window of the metastore service. This specifies when the service can be restarted for maintenance purposes in UTC time.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="metadataIntegration")
    def metadata_integration(self) -> 'outputs.MetadataIntegrationResponse':
        """
        The setting that defines how metastore metadata should be integrated with external services and systems.
        """
        return pulumi.get(self, "metadata_integration")

    @property
    @pulumi.getter(name="metadataManagementActivity")
    def metadata_management_activity(self) -> 'outputs.MetadataManagementActivityResponse':
        """
        The metadata management activities of the metastore service.
        """
        return pulumi.get(self, "metadata_management_activity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The relative resource name of the metastore service, of the form:projects/{project_number}/locations/{location_id}/services/{service_id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Immutable. The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:projects/{project_number}/global/networks/{network_id}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP port at which the metastore service is reached. Default: 9083.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> str:
        """
        Immutable. The release channel of the service. If unspecified, defaults to STABLE.
        """
        return pulumi.get(self, "release_channel")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the metastore service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        Additional information about the current state of the metastore service, if available.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier of the service.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        The globally unique resource identifier of the metastore service.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the metastore service was last updated.
        """
        return pulumi.get(self, "update_time")


