# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 jobs_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_info: Optional[pulumi.Input['ApplicationInfoArgs']] = None,
                 company_display_name: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compensation_info: Optional[pulumi.Input['CompensationInfoArgs']] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 degree_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 department: Optional[pulumi.Input[str]] = None,
                 derived_info: Optional[pulumi.Input['JobDerivedInfoArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 employment_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 incentives: Optional[pulumi.Input[str]] = None,
                 job_benefits: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 job_end_time: Optional[pulumi.Input[str]] = None,
                 job_level: Optional[pulumi.Input[str]] = None,
                 job_start_time: Optional[pulumi.Input[str]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 posting_create_time: Optional[pulumi.Input[str]] = None,
                 posting_expire_time: Optional[pulumi.Input[str]] = None,
                 posting_publish_time: Optional[pulumi.Input[str]] = None,
                 posting_region: Optional[pulumi.Input[str]] = None,
                 posting_update_time: Optional[pulumi.Input[str]] = None,
                 processing_options: Optional[pulumi.Input['ProcessingOptionsArgs']] = None,
                 promotion_value: Optional[pulumi.Input[int]] = None,
                 qualifications: Optional[pulumi.Input[str]] = None,
                 requisition_id: Optional[pulumi.Input[str]] = None,
                 responsibilities: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Optional but strongly recommended for the best service experience. Location(s) where the employer is looking to hire for this job posting. Specifying the full street address(es) of the hiring location enables better API results, especially job searches by commute time. At most 50 locations are allowed for best search performance. If a job has more locations, it is suggested to split it into multiple jobs with unique requisition_ids (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', etc.) as multiple jobs with the same company_name, language_code and requisition_id are not allowed. If the original requisition_id must be preserved, a custom field should be used for storage. It is also suggested to group the locations that close to each other in the same job for better search experience. The maximum number of allowed characters is 500.
        :param pulumi.Input['ApplicationInfoArgs'] application_info: Required. At least one field within ApplicationInfo must be specified. Job application information.
        :param pulumi.Input[str] company_display_name: Display name of the company listing the job.
        :param pulumi.Input[str] company_name: Required. The resource name of the company listing the job, such as "projects/api-test-project/companies/foo".
        :param pulumi.Input['CompensationInfoArgs'] compensation_info: Optional. Job compensation information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Optional. A map of fields to hold both filterable and non-filterable custom job attributes that are not covered by the provided structured fields. The keys of the map are strings up to 64 bytes and must match the pattern: a-zA-Z*. For example, key0LikeThis or KEY_1_LIKE_THIS. At most 100 filterable and at most 100 unfilterable keys are supported. For filterable `string_values`, across all keys at most 200 values are allowed, with each string no more than 255 characters. For unfilterable `string_values`, the maximum total size of `string_values` across all keys is 50KB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] degree_types: Optional. The desired education degrees for the job, such as Bachelors, Masters.
        :param pulumi.Input[str] department: Optional. The department or functional area within the company with the open position. The maximum number of allowed characters is 255.
        :param pulumi.Input['JobDerivedInfoArgs'] derived_info: Derived details about the job posting.
        :param pulumi.Input[str] description: Required. The description of the job, which typically includes a multi-paragraph description of the company and related information. Separate fields are provided on the job object for responsibilities, qualifications, and other job characteristics. Use of these separate job fields is recommended. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 100,000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] employment_types: Optional. The employment type(s) of a job, for example, full time or part time.
        :param pulumi.Input[str] incentives: Optional. A description of bonus, commission, and other compensation incentives associated with the job not including salary or pay. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] job_benefits: Optional. The benefits included with the job.
        :param pulumi.Input[str] job_end_time: Optional. The end timestamp of the job. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        :param pulumi.Input[str] job_level: Optional. The experience level associated with the job, such as "Entry Level".
        :param pulumi.Input[str] job_start_time: Optional. The start timestamp of the job in UTC time zone. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        :param pulumi.Input[str] language_code: Optional. The language of the posting. This field is distinct from any requirements for fluency that are associated with the job. Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){: class="external" target="_blank" }. If this field is unspecified and Job.description is present, detected language code based on Job.description is assigned, otherwise defaults to 'en_US'.
        :param pulumi.Input[str] name: Required during job update. The resource name for the job. This is generated by the service when a job is created. The format is "projects/{project_id}/jobs/{job_id}", for example, "projects/api-test-project/jobs/1234". Use of this field in job queries and API calls is preferred over the use of requisition_id since this value is unique.
        :param pulumi.Input[str] posting_create_time: The timestamp when this job posting was created.
        :param pulumi.Input[str] posting_expire_time: Optional but strongly recommended for the best service experience. The expiration timestamp of the job. After this timestamp, the job is marked as expired, and it no longer appears in search results. The expired job can't be deleted or listed by the DeleteJob and ListJobs APIs, but it can be retrieved with the GetJob API or updated with the UpdateJob API. An expired job can be updated and opened again by using a future expiration timestamp. Updating an expired job fails if there is another existing open job with same company_name, language_code and requisition_id. The expired jobs are retained in our system for 90 days. However, the overall expired job count cannot exceed 3 times the maximum of open jobs count over the past week, otherwise jobs with earlier expire time are cleaned first. Expired jobs are no longer accessible after they are cleaned out. Invalid timestamps are ignored, and treated as expire time not provided. Timestamp before the instant request is made is considered valid, the job will be treated as expired immediately. If this value is not provided at the time of job creation or is invalid, the job posting expires after 30 days from the job's creation time. For example, if the job was created on 2017/01/01 13:00AM UTC with an unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC. If this value is not provided on job update, it depends on the field masks set by UpdateJobRequest.update_mask. If the field masks include expiry_time, or the masks are empty meaning that every field is updated, the job posting expires after 30 days from the job's last update time. Otherwise the expiration date isn't updated.
        :param pulumi.Input[str] posting_publish_time: Optional. The timestamp this job posting was most recently published. The default value is the time the request arrives at the server. Invalid timestamps are ignored.
        :param pulumi.Input[str] posting_region: Optional. The job PostingRegion (for example, state, country) throughout which the job is available. If this field is set, a LocationFilter in a search query within the job region finds this job posting if an exact location match isn't specified. If this field is set to PostingRegion.NATION or PostingRegion.ADMINISTRATIVE_AREA, setting job Job.addresses to the same location level as this field is strongly recommended.
        :param pulumi.Input[str] posting_update_time: The timestamp when this job posting was last updated.
        :param pulumi.Input['ProcessingOptionsArgs'] processing_options: Optional. Options for job processing.
        :param pulumi.Input[int] promotion_value: Optional. A promotion value of the job, as determined by the client. The value determines the sort order of the jobs returned when searching for jobs using the featured jobs search call, with higher promotional values being returned first and ties being resolved by relevance sort. Only the jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH. Default value is 0, and negative values are treated as 0.
        :param pulumi.Input[str] qualifications: Optional. A description of the qualifications required to perform the job. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[str] requisition_id: Required. The requisition ID, also referred to as the posting ID, assigned by the client to identify a job. This field is intended to be used by clients for client identification and tracking of postings. A job is not allowed to be created if there is another job with the same [company_name], language_code and requisition_id. The maximum number of allowed characters is 255.
        :param pulumi.Input[str] responsibilities: Optional. A description of job responsibilities. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[str] title: Required. The title of the job, such as "Software Engineer" The maximum number of allowed characters is 500.
        """
        pulumi.set(__self__, "jobs_id", jobs_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if application_info is not None:
            pulumi.set(__self__, "application_info", application_info)
        if company_display_name is not None:
            pulumi.set(__self__, "company_display_name", company_display_name)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if compensation_info is not None:
            pulumi.set(__self__, "compensation_info", compensation_info)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if degree_types is not None:
            pulumi.set(__self__, "degree_types", degree_types)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if derived_info is not None:
            pulumi.set(__self__, "derived_info", derived_info)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if employment_types is not None:
            pulumi.set(__self__, "employment_types", employment_types)
        if incentives is not None:
            pulumi.set(__self__, "incentives", incentives)
        if job_benefits is not None:
            pulumi.set(__self__, "job_benefits", job_benefits)
        if job_end_time is not None:
            pulumi.set(__self__, "job_end_time", job_end_time)
        if job_level is not None:
            pulumi.set(__self__, "job_level", job_level)
        if job_start_time is not None:
            pulumi.set(__self__, "job_start_time", job_start_time)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if posting_create_time is not None:
            pulumi.set(__self__, "posting_create_time", posting_create_time)
        if posting_expire_time is not None:
            pulumi.set(__self__, "posting_expire_time", posting_expire_time)
        if posting_publish_time is not None:
            pulumi.set(__self__, "posting_publish_time", posting_publish_time)
        if posting_region is not None:
            pulumi.set(__self__, "posting_region", posting_region)
        if posting_update_time is not None:
            pulumi.set(__self__, "posting_update_time", posting_update_time)
        if processing_options is not None:
            pulumi.set(__self__, "processing_options", processing_options)
        if promotion_value is not None:
            pulumi.set(__self__, "promotion_value", promotion_value)
        if qualifications is not None:
            pulumi.set(__self__, "qualifications", qualifications)
        if requisition_id is not None:
            pulumi.set(__self__, "requisition_id", requisition_id)
        if responsibilities is not None:
            pulumi.set(__self__, "responsibilities", responsibilities)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="jobsId")
    def jobs_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "jobs_id")

    @jobs_id.setter
    def jobs_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "jobs_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional but strongly recommended for the best service experience. Location(s) where the employer is looking to hire for this job posting. Specifying the full street address(es) of the hiring location enables better API results, especially job searches by commute time. At most 50 locations are allowed for best search performance. If a job has more locations, it is suggested to split it into multiple jobs with unique requisition_ids (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', etc.) as multiple jobs with the same company_name, language_code and requisition_id are not allowed. If the original requisition_id must be preserved, a custom field should be used for storage. It is also suggested to group the locations that close to each other in the same job for better search experience. The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="applicationInfo")
    def application_info(self) -> Optional[pulumi.Input['ApplicationInfoArgs']]:
        """
        Required. At least one field within ApplicationInfo must be specified. Job application information.
        """
        return pulumi.get(self, "application_info")

    @application_info.setter
    def application_info(self, value: Optional[pulumi.Input['ApplicationInfoArgs']]):
        pulumi.set(self, "application_info", value)

    @property
    @pulumi.getter(name="companyDisplayName")
    def company_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the company listing the job.
        """
        return pulumi.get(self, "company_display_name")

    @company_display_name.setter
    def company_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_display_name", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The resource name of the company listing the job, such as "projects/api-test-project/companies/foo".
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="compensationInfo")
    def compensation_info(self) -> Optional[pulumi.Input['CompensationInfoArgs']]:
        """
        Optional. Job compensation information.
        """
        return pulumi.get(self, "compensation_info")

    @compensation_info.setter
    def compensation_info(self, value: Optional[pulumi.Input['CompensationInfoArgs']]):
        pulumi.set(self, "compensation_info", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A map of fields to hold both filterable and non-filterable custom job attributes that are not covered by the provided structured fields. The keys of the map are strings up to 64 bytes and must match the pattern: a-zA-Z*. For example, key0LikeThis or KEY_1_LIKE_THIS. At most 100 filterable and at most 100 unfilterable keys are supported. For filterable `string_values`, across all keys at most 200 values are allowed, with each string no more than 255 characters. For unfilterable `string_values`, the maximum total size of `string_values` across all keys is 50KB.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="degreeTypes")
    def degree_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The desired education degrees for the job, such as Bachelors, Masters.
        """
        return pulumi.get(self, "degree_types")

    @degree_types.setter
    def degree_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "degree_types", value)

    @property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The department or functional area within the company with the open position. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department", value)

    @property
    @pulumi.getter(name="derivedInfo")
    def derived_info(self) -> Optional[pulumi.Input['JobDerivedInfoArgs']]:
        """
        Derived details about the job posting.
        """
        return pulumi.get(self, "derived_info")

    @derived_info.setter
    def derived_info(self, value: Optional[pulumi.Input['JobDerivedInfoArgs']]):
        pulumi.set(self, "derived_info", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The description of the job, which typically includes a multi-paragraph description of the company and related information. Separate fields are provided on the job object for responsibilities, qualifications, and other job characteristics. Use of these separate job fields is recommended. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 100,000.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="employmentTypes")
    def employment_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The employment type(s) of a job, for example, full time or part time.
        """
        return pulumi.get(self, "employment_types")

    @employment_types.setter
    def employment_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "employment_types", value)

    @property
    @pulumi.getter
    def incentives(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A description of bonus, commission, and other compensation incentives associated with the job not including salary or pay. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "incentives")

    @incentives.setter
    def incentives(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "incentives", value)

    @property
    @pulumi.getter(name="jobBenefits")
    def job_benefits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The benefits included with the job.
        """
        return pulumi.get(self, "job_benefits")

    @job_benefits.setter
    def job_benefits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "job_benefits", value)

    @property
    @pulumi.getter(name="jobEndTime")
    def job_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The end timestamp of the job. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_end_time")

    @job_end_time.setter
    def job_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_end_time", value)

    @property
    @pulumi.getter(name="jobLevel")
    def job_level(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The experience level associated with the job, such as "Entry Level".
        """
        return pulumi.get(self, "job_level")

    @job_level.setter
    def job_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_level", value)

    @property
    @pulumi.getter(name="jobStartTime")
    def job_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The start timestamp of the job in UTC time zone. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_start_time")

    @job_start_time.setter
    def job_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_start_time", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The language of the posting. This field is distinct from any requirements for fluency that are associated with the job. Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){: class="external" target="_blank" }. If this field is unspecified and Job.description is present, detected language code based on Job.description is assigned, otherwise defaults to 'en_US'.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required during job update. The resource name for the job. This is generated by the service when a job is created. The format is "projects/{project_id}/jobs/{job_id}", for example, "projects/api-test-project/jobs/1234". Use of this field in job queries and API calls is preferred over the use of requisition_id since this value is unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="postingCreateTime")
    def posting_create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when this job posting was created.
        """
        return pulumi.get(self, "posting_create_time")

    @posting_create_time.setter
    def posting_create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "posting_create_time", value)

    @property
    @pulumi.getter(name="postingExpireTime")
    def posting_expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional but strongly recommended for the best service experience. The expiration timestamp of the job. After this timestamp, the job is marked as expired, and it no longer appears in search results. The expired job can't be deleted or listed by the DeleteJob and ListJobs APIs, but it can be retrieved with the GetJob API or updated with the UpdateJob API. An expired job can be updated and opened again by using a future expiration timestamp. Updating an expired job fails if there is another existing open job with same company_name, language_code and requisition_id. The expired jobs are retained in our system for 90 days. However, the overall expired job count cannot exceed 3 times the maximum of open jobs count over the past week, otherwise jobs with earlier expire time are cleaned first. Expired jobs are no longer accessible after they are cleaned out. Invalid timestamps are ignored, and treated as expire time not provided. Timestamp before the instant request is made is considered valid, the job will be treated as expired immediately. If this value is not provided at the time of job creation or is invalid, the job posting expires after 30 days from the job's creation time. For example, if the job was created on 2017/01/01 13:00AM UTC with an unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC. If this value is not provided on job update, it depends on the field masks set by UpdateJobRequest.update_mask. If the field masks include expiry_time, or the masks are empty meaning that every field is updated, the job posting expires after 30 days from the job's last update time. Otherwise the expiration date isn't updated.
        """
        return pulumi.get(self, "posting_expire_time")

    @posting_expire_time.setter
    def posting_expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "posting_expire_time", value)

    @property
    @pulumi.getter(name="postingPublishTime")
    def posting_publish_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The timestamp this job posting was most recently published. The default value is the time the request arrives at the server. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "posting_publish_time")

    @posting_publish_time.setter
    def posting_publish_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "posting_publish_time", value)

    @property
    @pulumi.getter(name="postingRegion")
    def posting_region(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The job PostingRegion (for example, state, country) throughout which the job is available. If this field is set, a LocationFilter in a search query within the job region finds this job posting if an exact location match isn't specified. If this field is set to PostingRegion.NATION or PostingRegion.ADMINISTRATIVE_AREA, setting job Job.addresses to the same location level as this field is strongly recommended.
        """
        return pulumi.get(self, "posting_region")

    @posting_region.setter
    def posting_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "posting_region", value)

    @property
    @pulumi.getter(name="postingUpdateTime")
    def posting_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when this job posting was last updated.
        """
        return pulumi.get(self, "posting_update_time")

    @posting_update_time.setter
    def posting_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "posting_update_time", value)

    @property
    @pulumi.getter(name="processingOptions")
    def processing_options(self) -> Optional[pulumi.Input['ProcessingOptionsArgs']]:
        """
        Optional. Options for job processing.
        """
        return pulumi.get(self, "processing_options")

    @processing_options.setter
    def processing_options(self, value: Optional[pulumi.Input['ProcessingOptionsArgs']]):
        pulumi.set(self, "processing_options", value)

    @property
    @pulumi.getter(name="promotionValue")
    def promotion_value(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. A promotion value of the job, as determined by the client. The value determines the sort order of the jobs returned when searching for jobs using the featured jobs search call, with higher promotional values being returned first and ties being resolved by relevance sort. Only the jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH. Default value is 0, and negative values are treated as 0.
        """
        return pulumi.get(self, "promotion_value")

    @promotion_value.setter
    def promotion_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "promotion_value", value)

    @property
    @pulumi.getter
    def qualifications(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A description of the qualifications required to perform the job. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "qualifications")

    @qualifications.setter
    def qualifications(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifications", value)

    @property
    @pulumi.getter(name="requisitionId")
    def requisition_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The requisition ID, also referred to as the posting ID, assigned by the client to identify a job. This field is intended to be used by clients for client identification and tracking of postings. A job is not allowed to be created if there is another job with the same [company_name], language_code and requisition_id. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "requisition_id")

    @requisition_id.setter
    def requisition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requisition_id", value)

    @property
    @pulumi.getter
    def responsibilities(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A description of job responsibilities. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "responsibilities")

    @responsibilities.setter
    def responsibilities(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "responsibilities", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The title of the job, such as "Software Engineer" The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_info: Optional[pulumi.Input[pulumi.InputType['ApplicationInfoArgs']]] = None,
                 company_display_name: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compensation_info: Optional[pulumi.Input[pulumi.InputType['CompensationInfoArgs']]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 degree_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 department: Optional[pulumi.Input[str]] = None,
                 derived_info: Optional[pulumi.Input[pulumi.InputType['JobDerivedInfoArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 employment_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 incentives: Optional[pulumi.Input[str]] = None,
                 job_benefits: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 job_end_time: Optional[pulumi.Input[str]] = None,
                 job_level: Optional[pulumi.Input[str]] = None,
                 job_start_time: Optional[pulumi.Input[str]] = None,
                 jobs_id: Optional[pulumi.Input[str]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 posting_create_time: Optional[pulumi.Input[str]] = None,
                 posting_expire_time: Optional[pulumi.Input[str]] = None,
                 posting_publish_time: Optional[pulumi.Input[str]] = None,
                 posting_region: Optional[pulumi.Input[str]] = None,
                 posting_update_time: Optional[pulumi.Input[str]] = None,
                 processing_options: Optional[pulumi.Input[pulumi.InputType['ProcessingOptionsArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 promotion_value: Optional[pulumi.Input[int]] = None,
                 qualifications: Optional[pulumi.Input[str]] = None,
                 requisition_id: Optional[pulumi.Input[str]] = None,
                 responsibilities: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new job. Typically, the job becomes searchable within 10 seconds, but it may take up to 5 minutes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Optional but strongly recommended for the best service experience. Location(s) where the employer is looking to hire for this job posting. Specifying the full street address(es) of the hiring location enables better API results, especially job searches by commute time. At most 50 locations are allowed for best search performance. If a job has more locations, it is suggested to split it into multiple jobs with unique requisition_ids (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', etc.) as multiple jobs with the same company_name, language_code and requisition_id are not allowed. If the original requisition_id must be preserved, a custom field should be used for storage. It is also suggested to group the locations that close to each other in the same job for better search experience. The maximum number of allowed characters is 500.
        :param pulumi.Input[pulumi.InputType['ApplicationInfoArgs']] application_info: Required. At least one field within ApplicationInfo must be specified. Job application information.
        :param pulumi.Input[str] company_display_name: Display name of the company listing the job.
        :param pulumi.Input[str] company_name: Required. The resource name of the company listing the job, such as "projects/api-test-project/companies/foo".
        :param pulumi.Input[pulumi.InputType['CompensationInfoArgs']] compensation_info: Optional. Job compensation information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_attributes: Optional. A map of fields to hold both filterable and non-filterable custom job attributes that are not covered by the provided structured fields. The keys of the map are strings up to 64 bytes and must match the pattern: a-zA-Z*. For example, key0LikeThis or KEY_1_LIKE_THIS. At most 100 filterable and at most 100 unfilterable keys are supported. For filterable `string_values`, across all keys at most 200 values are allowed, with each string no more than 255 characters. For unfilterable `string_values`, the maximum total size of `string_values` across all keys is 50KB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] degree_types: Optional. The desired education degrees for the job, such as Bachelors, Masters.
        :param pulumi.Input[str] department: Optional. The department or functional area within the company with the open position. The maximum number of allowed characters is 255.
        :param pulumi.Input[pulumi.InputType['JobDerivedInfoArgs']] derived_info: Derived details about the job posting.
        :param pulumi.Input[str] description: Required. The description of the job, which typically includes a multi-paragraph description of the company and related information. Separate fields are provided on the job object for responsibilities, qualifications, and other job characteristics. Use of these separate job fields is recommended. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 100,000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] employment_types: Optional. The employment type(s) of a job, for example, full time or part time.
        :param pulumi.Input[str] incentives: Optional. A description of bonus, commission, and other compensation incentives associated with the job not including salary or pay. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] job_benefits: Optional. The benefits included with the job.
        :param pulumi.Input[str] job_end_time: Optional. The end timestamp of the job. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        :param pulumi.Input[str] job_level: Optional. The experience level associated with the job, such as "Entry Level".
        :param pulumi.Input[str] job_start_time: Optional. The start timestamp of the job in UTC time zone. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        :param pulumi.Input[str] language_code: Optional. The language of the posting. This field is distinct from any requirements for fluency that are associated with the job. Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){: class="external" target="_blank" }. If this field is unspecified and Job.description is present, detected language code based on Job.description is assigned, otherwise defaults to 'en_US'.
        :param pulumi.Input[str] name: Required during job update. The resource name for the job. This is generated by the service when a job is created. The format is "projects/{project_id}/jobs/{job_id}", for example, "projects/api-test-project/jobs/1234". Use of this field in job queries and API calls is preferred over the use of requisition_id since this value is unique.
        :param pulumi.Input[str] posting_create_time: The timestamp when this job posting was created.
        :param pulumi.Input[str] posting_expire_time: Optional but strongly recommended for the best service experience. The expiration timestamp of the job. After this timestamp, the job is marked as expired, and it no longer appears in search results. The expired job can't be deleted or listed by the DeleteJob and ListJobs APIs, but it can be retrieved with the GetJob API or updated with the UpdateJob API. An expired job can be updated and opened again by using a future expiration timestamp. Updating an expired job fails if there is another existing open job with same company_name, language_code and requisition_id. The expired jobs are retained in our system for 90 days. However, the overall expired job count cannot exceed 3 times the maximum of open jobs count over the past week, otherwise jobs with earlier expire time are cleaned first. Expired jobs are no longer accessible after they are cleaned out. Invalid timestamps are ignored, and treated as expire time not provided. Timestamp before the instant request is made is considered valid, the job will be treated as expired immediately. If this value is not provided at the time of job creation or is invalid, the job posting expires after 30 days from the job's creation time. For example, if the job was created on 2017/01/01 13:00AM UTC with an unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC. If this value is not provided on job update, it depends on the field masks set by UpdateJobRequest.update_mask. If the field masks include expiry_time, or the masks are empty meaning that every field is updated, the job posting expires after 30 days from the job's last update time. Otherwise the expiration date isn't updated.
        :param pulumi.Input[str] posting_publish_time: Optional. The timestamp this job posting was most recently published. The default value is the time the request arrives at the server. Invalid timestamps are ignored.
        :param pulumi.Input[str] posting_region: Optional. The job PostingRegion (for example, state, country) throughout which the job is available. If this field is set, a LocationFilter in a search query within the job region finds this job posting if an exact location match isn't specified. If this field is set to PostingRegion.NATION or PostingRegion.ADMINISTRATIVE_AREA, setting job Job.addresses to the same location level as this field is strongly recommended.
        :param pulumi.Input[str] posting_update_time: The timestamp when this job posting was last updated.
        :param pulumi.Input[pulumi.InputType['ProcessingOptionsArgs']] processing_options: Optional. Options for job processing.
        :param pulumi.Input[int] promotion_value: Optional. A promotion value of the job, as determined by the client. The value determines the sort order of the jobs returned when searching for jobs using the featured jobs search call, with higher promotional values being returned first and ties being resolved by relevance sort. Only the jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH. Default value is 0, and negative values are treated as 0.
        :param pulumi.Input[str] qualifications: Optional. A description of the qualifications required to perform the job. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[str] requisition_id: Required. The requisition ID, also referred to as the posting ID, assigned by the client to identify a job. This field is intended to be used by clients for client identification and tracking of postings. A job is not allowed to be created if there is another job with the same [company_name], language_code and requisition_id. The maximum number of allowed characters is 255.
        :param pulumi.Input[str] responsibilities: Optional. A description of job responsibilities. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        :param pulumi.Input[str] title: Required. The title of the job, such as "Software Engineer" The maximum number of allowed characters is 500.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new job. Typically, the job becomes searchable within 10 seconds, but it may take up to 5 minutes.

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 application_info: Optional[pulumi.Input[pulumi.InputType['ApplicationInfoArgs']]] = None,
                 company_display_name: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compensation_info: Optional[pulumi.Input[pulumi.InputType['CompensationInfoArgs']]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 degree_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 department: Optional[pulumi.Input[str]] = None,
                 derived_info: Optional[pulumi.Input[pulumi.InputType['JobDerivedInfoArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 employment_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 incentives: Optional[pulumi.Input[str]] = None,
                 job_benefits: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 job_end_time: Optional[pulumi.Input[str]] = None,
                 job_level: Optional[pulumi.Input[str]] = None,
                 job_start_time: Optional[pulumi.Input[str]] = None,
                 jobs_id: Optional[pulumi.Input[str]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 posting_create_time: Optional[pulumi.Input[str]] = None,
                 posting_expire_time: Optional[pulumi.Input[str]] = None,
                 posting_publish_time: Optional[pulumi.Input[str]] = None,
                 posting_region: Optional[pulumi.Input[str]] = None,
                 posting_update_time: Optional[pulumi.Input[str]] = None,
                 processing_options: Optional[pulumi.Input[pulumi.InputType['ProcessingOptionsArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 promotion_value: Optional[pulumi.Input[int]] = None,
                 qualifications: Optional[pulumi.Input[str]] = None,
                 requisition_id: Optional[pulumi.Input[str]] = None,
                 responsibilities: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["application_info"] = application_info
            __props__.__dict__["company_display_name"] = company_display_name
            __props__.__dict__["company_name"] = company_name
            __props__.__dict__["compensation_info"] = compensation_info
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["degree_types"] = degree_types
            __props__.__dict__["department"] = department
            __props__.__dict__["derived_info"] = derived_info
            __props__.__dict__["description"] = description
            __props__.__dict__["employment_types"] = employment_types
            __props__.__dict__["incentives"] = incentives
            __props__.__dict__["job_benefits"] = job_benefits
            __props__.__dict__["job_end_time"] = job_end_time
            __props__.__dict__["job_level"] = job_level
            __props__.__dict__["job_start_time"] = job_start_time
            if jobs_id is None and not opts.urn:
                raise TypeError("Missing required property 'jobs_id'")
            __props__.__dict__["jobs_id"] = jobs_id
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["name"] = name
            __props__.__dict__["posting_create_time"] = posting_create_time
            __props__.__dict__["posting_expire_time"] = posting_expire_time
            __props__.__dict__["posting_publish_time"] = posting_publish_time
            __props__.__dict__["posting_region"] = posting_region
            __props__.__dict__["posting_update_time"] = posting_update_time
            __props__.__dict__["processing_options"] = processing_options
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["promotion_value"] = promotion_value
            __props__.__dict__["qualifications"] = qualifications
            __props__.__dict__["requisition_id"] = requisition_id
            __props__.__dict__["responsibilities"] = responsibilities
            __props__.__dict__["title"] = title
        super(Job, __self__).__init__(
            'gcp-native:jobs/v3:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = JobArgs.__new__(JobArgs)

        __props__.__dict__["addresses"] = None
        __props__.__dict__["application_info"] = None
        __props__.__dict__["company_display_name"] = None
        __props__.__dict__["company_name"] = None
        __props__.__dict__["compensation_info"] = None
        __props__.__dict__["custom_attributes"] = None
        __props__.__dict__["degree_types"] = None
        __props__.__dict__["department"] = None
        __props__.__dict__["derived_info"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["employment_types"] = None
        __props__.__dict__["incentives"] = None
        __props__.__dict__["job_benefits"] = None
        __props__.__dict__["job_end_time"] = None
        __props__.__dict__["job_level"] = None
        __props__.__dict__["job_start_time"] = None
        __props__.__dict__["language_code"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["posting_create_time"] = None
        __props__.__dict__["posting_expire_time"] = None
        __props__.__dict__["posting_publish_time"] = None
        __props__.__dict__["posting_region"] = None
        __props__.__dict__["posting_update_time"] = None
        __props__.__dict__["processing_options"] = None
        __props__.__dict__["promotion_value"] = None
        __props__.__dict__["qualifications"] = None
        __props__.__dict__["requisition_id"] = None
        __props__.__dict__["responsibilities"] = None
        __props__.__dict__["title"] = None
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional but strongly recommended for the best service experience. Location(s) where the employer is looking to hire for this job posting. Specifying the full street address(es) of the hiring location enables better API results, especially job searches by commute time. At most 50 locations are allowed for best search performance. If a job has more locations, it is suggested to split it into multiple jobs with unique requisition_ids (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', etc.) as multiple jobs with the same company_name, language_code and requisition_id are not allowed. If the original requisition_id must be preserved, a custom field should be used for storage. It is also suggested to group the locations that close to each other in the same job for better search experience. The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="applicationInfo")
    def application_info(self) -> pulumi.Output['outputs.ApplicationInfoResponse']:
        """
        Required. At least one field within ApplicationInfo must be specified. Job application information.
        """
        return pulumi.get(self, "application_info")

    @property
    @pulumi.getter(name="companyDisplayName")
    def company_display_name(self) -> pulumi.Output[str]:
        """
        Display name of the company listing the job.
        """
        return pulumi.get(self, "company_display_name")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> pulumi.Output[str]:
        """
        Required. The resource name of the company listing the job, such as "projects/api-test-project/companies/foo".
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="compensationInfo")
    def compensation_info(self) -> pulumi.Output['outputs.CompensationInfoResponse']:
        """
        Optional. Job compensation information.
        """
        return pulumi.get(self, "compensation_info")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. A map of fields to hold both filterable and non-filterable custom job attributes that are not covered by the provided structured fields. The keys of the map are strings up to 64 bytes and must match the pattern: a-zA-Z*. For example, key0LikeThis or KEY_1_LIKE_THIS. At most 100 filterable and at most 100 unfilterable keys are supported. For filterable `string_values`, across all keys at most 200 values are allowed, with each string no more than 255 characters. For unfilterable `string_values`, the maximum total size of `string_values` across all keys is 50KB.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="degreeTypes")
    def degree_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. The desired education degrees for the job, such as Bachelors, Masters.
        """
        return pulumi.get(self, "degree_types")

    @property
    @pulumi.getter
    def department(self) -> pulumi.Output[str]:
        """
        Optional. The department or functional area within the company with the open position. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "department")

    @property
    @pulumi.getter(name="derivedInfo")
    def derived_info(self) -> pulumi.Output['outputs.JobDerivedInfoResponse']:
        """
        Derived details about the job posting.
        """
        return pulumi.get(self, "derived_info")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Required. The description of the job, which typically includes a multi-paragraph description of the company and related information. Separate fields are provided on the job object for responsibilities, qualifications, and other job characteristics. Use of these separate job fields is recommended. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 100,000.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="employmentTypes")
    def employment_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. The employment type(s) of a job, for example, full time or part time.
        """
        return pulumi.get(self, "employment_types")

    @property
    @pulumi.getter
    def incentives(self) -> pulumi.Output[str]:
        """
        Optional. A description of bonus, commission, and other compensation incentives associated with the job not including salary or pay. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "incentives")

    @property
    @pulumi.getter(name="jobBenefits")
    def job_benefits(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. The benefits included with the job.
        """
        return pulumi.get(self, "job_benefits")

    @property
    @pulumi.getter(name="jobEndTime")
    def job_end_time(self) -> pulumi.Output[str]:
        """
        Optional. The end timestamp of the job. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_end_time")

    @property
    @pulumi.getter(name="jobLevel")
    def job_level(self) -> pulumi.Output[str]:
        """
        Optional. The experience level associated with the job, such as "Entry Level".
        """
        return pulumi.get(self, "job_level")

    @property
    @pulumi.getter(name="jobStartTime")
    def job_start_time(self) -> pulumi.Output[str]:
        """
        Optional. The start timestamp of the job in UTC time zone. Typically this field is used for contracting engagements. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "job_start_time")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[str]:
        """
        Optional. The language of the posting. This field is distinct from any requirements for fluency that are associated with the job. Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){: class="external" target="_blank" }. If this field is unspecified and Job.description is present, detected language code based on Job.description is assigned, otherwise defaults to 'en_US'.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required during job update. The resource name for the job. This is generated by the service when a job is created. The format is "projects/{project_id}/jobs/{job_id}", for example, "projects/api-test-project/jobs/1234". Use of this field in job queries and API calls is preferred over the use of requisition_id since this value is unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="postingCreateTime")
    def posting_create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when this job posting was created.
        """
        return pulumi.get(self, "posting_create_time")

    @property
    @pulumi.getter(name="postingExpireTime")
    def posting_expire_time(self) -> pulumi.Output[str]:
        """
        Optional but strongly recommended for the best service experience. The expiration timestamp of the job. After this timestamp, the job is marked as expired, and it no longer appears in search results. The expired job can't be deleted or listed by the DeleteJob and ListJobs APIs, but it can be retrieved with the GetJob API or updated with the UpdateJob API. An expired job can be updated and opened again by using a future expiration timestamp. Updating an expired job fails if there is another existing open job with same company_name, language_code and requisition_id. The expired jobs are retained in our system for 90 days. However, the overall expired job count cannot exceed 3 times the maximum of open jobs count over the past week, otherwise jobs with earlier expire time are cleaned first. Expired jobs are no longer accessible after they are cleaned out. Invalid timestamps are ignored, and treated as expire time not provided. Timestamp before the instant request is made is considered valid, the job will be treated as expired immediately. If this value is not provided at the time of job creation or is invalid, the job posting expires after 30 days from the job's creation time. For example, if the job was created on 2017/01/01 13:00AM UTC with an unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC. If this value is not provided on job update, it depends on the field masks set by UpdateJobRequest.update_mask. If the field masks include expiry_time, or the masks are empty meaning that every field is updated, the job posting expires after 30 days from the job's last update time. Otherwise the expiration date isn't updated.
        """
        return pulumi.get(self, "posting_expire_time")

    @property
    @pulumi.getter(name="postingPublishTime")
    def posting_publish_time(self) -> pulumi.Output[str]:
        """
        Optional. The timestamp this job posting was most recently published. The default value is the time the request arrives at the server. Invalid timestamps are ignored.
        """
        return pulumi.get(self, "posting_publish_time")

    @property
    @pulumi.getter(name="postingRegion")
    def posting_region(self) -> pulumi.Output[str]:
        """
        Optional. The job PostingRegion (for example, state, country) throughout which the job is available. If this field is set, a LocationFilter in a search query within the job region finds this job posting if an exact location match isn't specified. If this field is set to PostingRegion.NATION or PostingRegion.ADMINISTRATIVE_AREA, setting job Job.addresses to the same location level as this field is strongly recommended.
        """
        return pulumi.get(self, "posting_region")

    @property
    @pulumi.getter(name="postingUpdateTime")
    def posting_update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when this job posting was last updated.
        """
        return pulumi.get(self, "posting_update_time")

    @property
    @pulumi.getter(name="processingOptions")
    def processing_options(self) -> pulumi.Output['outputs.ProcessingOptionsResponse']:
        """
        Optional. Options for job processing.
        """
        return pulumi.get(self, "processing_options")

    @property
    @pulumi.getter(name="promotionValue")
    def promotion_value(self) -> pulumi.Output[int]:
        """
        Optional. A promotion value of the job, as determined by the client. The value determines the sort order of the jobs returned when searching for jobs using the featured jobs search call, with higher promotional values being returned first and ties being resolved by relevance sort. Only the jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH. Default value is 0, and negative values are treated as 0.
        """
        return pulumi.get(self, "promotion_value")

    @property
    @pulumi.getter
    def qualifications(self) -> pulumi.Output[str]:
        """
        Optional. A description of the qualifications required to perform the job. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "qualifications")

    @property
    @pulumi.getter(name="requisitionId")
    def requisition_id(self) -> pulumi.Output[str]:
        """
        Required. The requisition ID, also referred to as the posting ID, assigned by the client to identify a job. This field is intended to be used by clients for client identification and tracking of postings. A job is not allowed to be created if there is another job with the same [company_name], language_code and requisition_id. The maximum number of allowed characters is 255.
        """
        return pulumi.get(self, "requisition_id")

    @property
    @pulumi.getter
    def responsibilities(self) -> pulumi.Output[str]:
        """
        Optional. A description of job responsibilities. The use of this field is recommended as an alternative to using the more general description field. This field accepts and sanitizes HTML input, and also accepts bold, italic, ordered list, and unordered list markup tags. The maximum number of allowed characters is 10,000.
        """
        return pulumi.get(self, "responsibilities")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Required. The title of the job, such as "Software Engineer" The maximum number of allowed characters is 500.
        """
        return pulumi.get(self, "title")

