# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['BrandIdentityAwareProxyClientArgs', 'BrandIdentityAwareProxyClient']

@pulumi.input_type
class BrandIdentityAwareProxyClientArgs:
    def __init__(__self__, *,
                 brands_id: pulumi.Input[str],
                 identity_aware_proxy_clients_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BrandIdentityAwareProxyClient resource.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        """
        pulumi.set(__self__, "brands_id", brands_id)
        pulumi.set(__self__, "identity_aware_proxy_clients_id", identity_aware_proxy_clients_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="brandsId")
    def brands_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "brands_id")

    @brands_id.setter
    def brands_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "brands_id", value)

    @property
    @pulumi.getter(name="identityAwareProxyClientsId")
    def identity_aware_proxy_clients_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "identity_aware_proxy_clients_id")

    @identity_aware_proxy_clients_id.setter
    def identity_aware_proxy_clients_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_aware_proxy_clients_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


class BrandIdentityAwareProxyClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brands_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 identity_aware_proxy_clients_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned by IAP. Requires that the brand for the project exists and that it is set for internal-only use.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BrandIdentityAwareProxyClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned by IAP. Requires that the brand for the project exists and that it is set for internal-only use.

        :param str resource_name: The name of the resource.
        :param BrandIdentityAwareProxyClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BrandIdentityAwareProxyClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brands_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 identity_aware_proxy_clients_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BrandIdentityAwareProxyClientArgs.__new__(BrandIdentityAwareProxyClientArgs)

            if brands_id is None and not opts.urn:
                raise TypeError("Missing required property 'brands_id'")
            __props__.__dict__["brands_id"] = brands_id
            __props__.__dict__["display_name"] = display_name
            if identity_aware_proxy_clients_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_aware_proxy_clients_id'")
            __props__.__dict__["identity_aware_proxy_clients_id"] = identity_aware_proxy_clients_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["name"] = None
            __props__.__dict__["secret"] = None
        super(BrandIdentityAwareProxyClient, __self__).__init__(
            'gcp-native:iap/v1:BrandIdentityAwareProxyClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BrandIdentityAwareProxyClient':
        """
        Get an existing BrandIdentityAwareProxyClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BrandIdentityAwareProxyClientArgs.__new__(BrandIdentityAwareProxyClientArgs)

        __props__.__dict__["display_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["secret"] = None
        return BrandIdentityAwareProxyClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique identifier of the OAuth client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        Client secret of the OAuth client.
        """
        return pulumi.get(self, "secret")

