# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetConsentStoreConsentArtifactArgs', 'DatasetConsentStoreConsentArtifact']

@pulumi.input_type
class DatasetConsentStoreConsentArtifactArgs:
    def __init__(__self__, *,
                 consent_artifacts_id: pulumi.Input[str],
                 consent_stores_id: pulumi.Input[str],
                 datasets_id: pulumi.Input[str],
                 locations_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 consent_content_screenshots: Optional[pulumi.Input[Sequence[pulumi.Input['ImageArgs']]]] = None,
                 consent_content_version: Optional[pulumi.Input[str]] = None,
                 guardian_signature: Optional[pulumi.Input['SignatureArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_signature: Optional[pulumi.Input['SignatureArgs']] = None,
                 witness_signature: Optional[pulumi.Input['SignatureArgs']] = None):
        """
        The set of arguments for constructing a DatasetConsentStoreConsentArtifact resource.
        :param pulumi.Input[Sequence[pulumi.Input['ImageArgs']]] consent_content_screenshots: Optional. Screenshots, PDFs, or other binary information documenting the user's consent.
        :param pulumi.Input[str] consent_content_version: Optional. An string indicating the version of the consent information shown to the user.
        :param pulumi.Input['SignatureArgs'] guardian_signature: Optional. A signature from a guardian.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Optional. Metadata associated with the Consent artifact. For example, the consent locale or user agent version.
        :param pulumi.Input[str] name: Resource name of the Consent artifact, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be changed after creation.
        :param pulumi.Input[str] user_id: Required. User's UUID provided by the client.
        :param pulumi.Input['SignatureArgs'] user_signature: Optional. User's signature.
        :param pulumi.Input['SignatureArgs'] witness_signature: Optional. A signature from a witness.
        """
        pulumi.set(__self__, "consent_artifacts_id", consent_artifacts_id)
        pulumi.set(__self__, "consent_stores_id", consent_stores_id)
        pulumi.set(__self__, "datasets_id", datasets_id)
        pulumi.set(__self__, "locations_id", locations_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if consent_content_screenshots is not None:
            pulumi.set(__self__, "consent_content_screenshots", consent_content_screenshots)
        if consent_content_version is not None:
            pulumi.set(__self__, "consent_content_version", consent_content_version)
        if guardian_signature is not None:
            pulumi.set(__self__, "guardian_signature", guardian_signature)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_signature is not None:
            pulumi.set(__self__, "user_signature", user_signature)
        if witness_signature is not None:
            pulumi.set(__self__, "witness_signature", witness_signature)

    @property
    @pulumi.getter(name="consentArtifactsId")
    def consent_artifacts_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "consent_artifacts_id")

    @consent_artifacts_id.setter
    def consent_artifacts_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "consent_artifacts_id", value)

    @property
    @pulumi.getter(name="consentStoresId")
    def consent_stores_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "consent_stores_id")

    @consent_stores_id.setter
    def consent_stores_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "consent_stores_id", value)

    @property
    @pulumi.getter(name="datasetsId")
    def datasets_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "datasets_id")

    @datasets_id.setter
    def datasets_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "datasets_id", value)

    @property
    @pulumi.getter(name="locationsId")
    def locations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locations_id")

    @locations_id.setter
    def locations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locations_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="consentContentScreenshots")
    def consent_content_screenshots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageArgs']]]]:
        """
        Optional. Screenshots, PDFs, or other binary information documenting the user's consent.
        """
        return pulumi.get(self, "consent_content_screenshots")

    @consent_content_screenshots.setter
    def consent_content_screenshots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageArgs']]]]):
        pulumi.set(self, "consent_content_screenshots", value)

    @property
    @pulumi.getter(name="consentContentVersion")
    def consent_content_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An string indicating the version of the consent information shown to the user.
        """
        return pulumi.get(self, "consent_content_version")

    @consent_content_version.setter
    def consent_content_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent_content_version", value)

    @property
    @pulumi.getter(name="guardianSignature")
    def guardian_signature(self) -> Optional[pulumi.Input['SignatureArgs']]:
        """
        Optional. A signature from a guardian.
        """
        return pulumi.get(self, "guardian_signature")

    @guardian_signature.setter
    def guardian_signature(self, value: Optional[pulumi.Input['SignatureArgs']]):
        pulumi.set(self, "guardian_signature", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Metadata associated with the Consent artifact. For example, the consent locale or user agent version.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of the Consent artifact, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be changed after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userSignature")
    def user_signature(self) -> Optional[pulumi.Input['SignatureArgs']]:
        """
        Optional. User's signature.
        """
        return pulumi.get(self, "user_signature")

    @user_signature.setter
    def user_signature(self, value: Optional[pulumi.Input['SignatureArgs']]):
        pulumi.set(self, "user_signature", value)

    @property
    @pulumi.getter(name="witnessSignature")
    def witness_signature(self) -> Optional[pulumi.Input['SignatureArgs']]:
        """
        Optional. A signature from a witness.
        """
        return pulumi.get(self, "witness_signature")

    @witness_signature.setter
    def witness_signature(self, value: Optional[pulumi.Input['SignatureArgs']]):
        pulumi.set(self, "witness_signature", value)


class DatasetConsentStoreConsentArtifact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consent_artifacts_id: Optional[pulumi.Input[str]] = None,
                 consent_content_screenshots: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageArgs']]]]] = None,
                 consent_content_version: Optional[pulumi.Input[str]] = None,
                 consent_stores_id: Optional[pulumi.Input[str]] = None,
                 datasets_id: Optional[pulumi.Input[str]] = None,
                 guardian_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 witness_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 __props__=None):
        """
        Creates a new Consent artifact in the parent consent store.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageArgs']]]] consent_content_screenshots: Optional. Screenshots, PDFs, or other binary information documenting the user's consent.
        :param pulumi.Input[str] consent_content_version: Optional. An string indicating the version of the consent information shown to the user.
        :param pulumi.Input[pulumi.InputType['SignatureArgs']] guardian_signature: Optional. A signature from a guardian.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Optional. Metadata associated with the Consent artifact. For example, the consent locale or user agent version.
        :param pulumi.Input[str] name: Resource name of the Consent artifact, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be changed after creation.
        :param pulumi.Input[str] user_id: Required. User's UUID provided by the client.
        :param pulumi.Input[pulumi.InputType['SignatureArgs']] user_signature: Optional. User's signature.
        :param pulumi.Input[pulumi.InputType['SignatureArgs']] witness_signature: Optional. A signature from a witness.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetConsentStoreConsentArtifactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Consent artifact in the parent consent store.

        :param str resource_name: The name of the resource.
        :param DatasetConsentStoreConsentArtifactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetConsentStoreConsentArtifactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consent_artifacts_id: Optional[pulumi.Input[str]] = None,
                 consent_content_screenshots: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageArgs']]]]] = None,
                 consent_content_version: Optional[pulumi.Input[str]] = None,
                 consent_stores_id: Optional[pulumi.Input[str]] = None,
                 datasets_id: Optional[pulumi.Input[str]] = None,
                 guardian_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 witness_signature: Optional[pulumi.Input[pulumi.InputType['SignatureArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetConsentStoreConsentArtifactArgs.__new__(DatasetConsentStoreConsentArtifactArgs)

            if consent_artifacts_id is None and not opts.urn:
                raise TypeError("Missing required property 'consent_artifacts_id'")
            __props__.__dict__["consent_artifacts_id"] = consent_artifacts_id
            __props__.__dict__["consent_content_screenshots"] = consent_content_screenshots
            __props__.__dict__["consent_content_version"] = consent_content_version
            if consent_stores_id is None and not opts.urn:
                raise TypeError("Missing required property 'consent_stores_id'")
            __props__.__dict__["consent_stores_id"] = consent_stores_id
            if datasets_id is None and not opts.urn:
                raise TypeError("Missing required property 'datasets_id'")
            __props__.__dict__["datasets_id"] = datasets_id
            __props__.__dict__["guardian_signature"] = guardian_signature
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__.__dict__["locations_id"] = locations_id
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["user_signature"] = user_signature
            __props__.__dict__["witness_signature"] = witness_signature
        super(DatasetConsentStoreConsentArtifact, __self__).__init__(
            'gcp-native:healthcare/v1:DatasetConsentStoreConsentArtifact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DatasetConsentStoreConsentArtifact':
        """
        Get an existing DatasetConsentStoreConsentArtifact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatasetConsentStoreConsentArtifactArgs.__new__(DatasetConsentStoreConsentArtifactArgs)

        __props__.__dict__["consent_content_screenshots"] = None
        __props__.__dict__["consent_content_version"] = None
        __props__.__dict__["guardian_signature"] = None
        __props__.__dict__["metadata"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["user_id"] = None
        __props__.__dict__["user_signature"] = None
        __props__.__dict__["witness_signature"] = None
        return DatasetConsentStoreConsentArtifact(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consentContentScreenshots")
    def consent_content_screenshots(self) -> pulumi.Output[Sequence['outputs.ImageResponse']]:
        """
        Optional. Screenshots, PDFs, or other binary information documenting the user's consent.
        """
        return pulumi.get(self, "consent_content_screenshots")

    @property
    @pulumi.getter(name="consentContentVersion")
    def consent_content_version(self) -> pulumi.Output[str]:
        """
        Optional. An string indicating the version of the consent information shown to the user.
        """
        return pulumi.get(self, "consent_content_version")

    @property
    @pulumi.getter(name="guardianSignature")
    def guardian_signature(self) -> pulumi.Output['outputs.SignatureResponse']:
        """
        Optional. A signature from a guardian.
        """
        return pulumi.get(self, "guardian_signature")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. Metadata associated with the Consent artifact. For example, the consent locale or user agent version.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of the Consent artifact, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be changed after creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Required. User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userSignature")
    def user_signature(self) -> pulumi.Output['outputs.SignatureResponse']:
        """
        Optional. User's signature.
        """
        return pulumi.get(self, "user_signature")

    @property
    @pulumi.getter(name="witnessSignature")
    def witness_signature(self) -> pulumi.Output['outputs.SignatureResponse']:
        """
        Optional. A signature from a witness.
        """
        return pulumi.get(self, "witness_signature")

