# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'FileArgs',
    'MetadataArgs',
    'SourceArgs',
]

@pulumi.input_type
class FileArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        `File` containing source content.
        :param pulumi.Input[str] content: Textual Content.
        :param pulumi.Input[str] fingerprint: Fingerprint (e.g. github sha) associated with the `File`.
        :param pulumi.Input[str] name: File name.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Textual Content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint (e.g. github sha) associated with the `File`.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        File name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MetadataArgs:
    def __init__(__self__, *,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Metadata for a Ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] services: Services that this ruleset has declarations for (e.g., "cloud.firestore"). There may be 0+ of these.
        """
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Services that this ruleset has declarations for (e.g., "cloud.firestore"). There may be 0+ of these.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "services", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input['FileArgs']]]] = None):
        """
        `Source` is one or more `File` messages comprising a logical set of rules.
        :param pulumi.Input[Sequence[pulumi.Input['FileArgs']]] files: `File` set constituting the `Source` bundle.
        """
        if files is not None:
            pulumi.set(__self__, "files", files)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileArgs']]]]:
        """
        `File` set constituting the `Source` bundle.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileArgs']]]]):
        pulumi.set(self, "files", value)


