# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AcceleratorConfigArgs',
    'AutoscalingConfigArgs',
    'BasicAutoscalingAlgorithmArgs',
    'BasicYarnAutoscalingConfigArgs',
    'BindingArgs',
    'ClusterConfigArgs',
    'ClusterSelectorArgs',
    'DiskConfigArgs',
    'EncryptionConfigArgs',
    'EndpointConfigArgs',
    'ExprArgs',
    'GceClusterConfigArgs',
    'GkeClusterConfigArgs',
    'HadoopJobArgs',
    'HiveJobArgs',
    'IdentityConfigArgs',
    'InstanceGroupAutoscalingPolicyConfigArgs',
    'InstanceGroupConfigArgs',
    'JobPlacementArgs',
    'JobReferenceArgs',
    'JobSchedulingArgs',
    'KerberosConfigArgs',
    'LifecycleConfigArgs',
    'LoggingConfigArgs',
    'ManagedClusterArgs',
    'MetastoreConfigArgs',
    'NamespacedGkeDeploymentTargetArgs',
    'NodeGroupAffinityArgs',
    'NodeInitializationActionArgs',
    'OrderedJobArgs',
    'ParameterValidationArgs',
    'PigJobArgs',
    'PrestoJobArgs',
    'PySparkJobArgs',
    'QueryListArgs',
    'RegexValidationArgs',
    'ReservationAffinityArgs',
    'SecurityConfigArgs',
    'ShieldedInstanceConfigArgs',
    'SoftwareConfigArgs',
    'SparkJobArgs',
    'SparkRJobArgs',
    'SparkSqlJobArgs',
    'TemplateParameterArgs',
    'ValueValidationArgs',
    'WorkflowTemplatePlacementArgs',
]

@pulumi.input_type
class AcceleratorConfigArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type_uri: Optional[pulumi.Input[str]] = None):
        """
        Specifies the type and number of accelerator cards attached to the instances of an instance. See GPUs on Compute Engine (https://cloud.google.com/compute/docs/gpus/).
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param pulumi.Input[str] accelerator_type_uri: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type_uri is not None:
            pulumi.set(__self__, "accelerator_type_uri", accelerator_type_uri)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorTypeUri")
    def accelerator_type_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        return pulumi.get(self, "accelerator_type_uri")

    @accelerator_type_uri.setter
    def accelerator_type_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type_uri", value)


@pulumi.input_type
class AutoscalingConfigArgs:
    def __init__(__self__, *,
                 policy_uri: Optional[pulumi.Input[str]] = None):
        """
        Autoscaling Policy config associated with the cluster.
        :param pulumi.Input[str] policy_uri: Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        if policy_uri is not None:
            pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        return pulumi.get(self, "policy_uri")

    @policy_uri.setter
    def policy_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_uri", value)


@pulumi.input_type
class BasicAutoscalingAlgorithmArgs:
    def __init__(__self__, *,
                 cooldown_period: Optional[pulumi.Input[str]] = None,
                 yarn_config: Optional[pulumi.Input['BasicYarnAutoscalingConfigArgs']] = None):
        """
        Basic algorithm for autoscaling.
        :param pulumi.Input[str] cooldown_period: Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        :param pulumi.Input['BasicYarnAutoscalingConfigArgs'] yarn_config: Required. YARN autoscaling configuration.
        """
        if cooldown_period is not None:
            pulumi.set(__self__, "cooldown_period", cooldown_period)
        if yarn_config is not None:
            pulumi.set(__self__, "yarn_config", yarn_config)

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    @cooldown_period.setter
    def cooldown_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cooldown_period", value)

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> Optional[pulumi.Input['BasicYarnAutoscalingConfigArgs']]:
        """
        Required. YARN autoscaling configuration.
        """
        return pulumi.get(self, "yarn_config")

    @yarn_config.setter
    def yarn_config(self, value: Optional[pulumi.Input['BasicYarnAutoscalingConfigArgs']]):
        pulumi.set(self, "yarn_config", value)


@pulumi.input_type
class BasicYarnAutoscalingConfigArgs:
    def __init__(__self__, *,
                 graceful_decommission_timeout: Optional[pulumi.Input[str]] = None,
                 scale_down_factor: Optional[pulumi.Input[float]] = None,
                 scale_down_min_worker_fraction: Optional[pulumi.Input[float]] = None,
                 scale_up_factor: Optional[pulumi.Input[float]] = None,
                 scale_up_min_worker_fraction: Optional[pulumi.Input[float]] = None):
        """
        Basic autoscaling configurations for YARN.
        :param pulumi.Input[str] graceful_decommission_timeout: Required. Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        :param pulumi.Input[float] scale_down_factor: Required. Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param pulumi.Input[float] scale_down_min_worker_fraction: Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        :param pulumi.Input[float] scale_up_factor: Required. Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param pulumi.Input[float] scale_up_min_worker_fraction: Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        if graceful_decommission_timeout is not None:
            pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        if scale_down_factor is not None:
            pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        if scale_down_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        if scale_up_factor is not None:
            pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        if scale_up_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @graceful_decommission_timeout.setter
    def graceful_decommission_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graceful_decommission_timeout", value)

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> Optional[pulumi.Input[float]]:
        """
        Required. Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_down_factor")

    @scale_down_factor.setter
    def scale_down_factor(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_factor", value)

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @scale_down_min_worker_fraction.setter
    def scale_down_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_min_worker_fraction", value)

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> Optional[pulumi.Input[float]]:
        """
        Required. Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_up_factor")

    @scale_up_factor.setter
    def scale_up_factor(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_up_factor", value)

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")

    @scale_up_min_worker_fraction.setter
    def scale_up_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_up_min_worker_fraction", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates members with a role.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[str] role: Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ClusterConfigArgs:
    def __init__(__self__, *,
                 autoscaling_config: Optional[pulumi.Input['AutoscalingConfigArgs']] = None,
                 config_bucket: Optional[pulumi.Input[str]] = None,
                 encryption_config: Optional[pulumi.Input['EncryptionConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input['EndpointConfigArgs']] = None,
                 gce_cluster_config: Optional[pulumi.Input['GceClusterConfigArgs']] = None,
                 gke_cluster_config: Optional[pulumi.Input['GkeClusterConfigArgs']] = None,
                 initialization_actions: Optional[pulumi.Input[Sequence[pulumi.Input['NodeInitializationActionArgs']]]] = None,
                 lifecycle_config: Optional[pulumi.Input['LifecycleConfigArgs']] = None,
                 master_config: Optional[pulumi.Input['InstanceGroupConfigArgs']] = None,
                 metastore_config: Optional[pulumi.Input['MetastoreConfigArgs']] = None,
                 secondary_worker_config: Optional[pulumi.Input['InstanceGroupConfigArgs']] = None,
                 security_config: Optional[pulumi.Input['SecurityConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['SoftwareConfigArgs']] = None,
                 temp_bucket: Optional[pulumi.Input[str]] = None,
                 worker_config: Optional[pulumi.Input['InstanceGroupConfigArgs']] = None):
        """
        The cluster config.
        :param pulumi.Input['AutoscalingConfigArgs'] autoscaling_config: Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        :param pulumi.Input[str] config_bucket: Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging bucket (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        :param pulumi.Input['EncryptionConfigArgs'] encryption_config: Optional. Encryption settings for the cluster.
        :param pulumi.Input['EndpointConfigArgs'] endpoint_config: Optional. Port/endpoint configuration for this cluster
        :param pulumi.Input['GceClusterConfigArgs'] gce_cluster_config: Optional. The shared Compute Engine config settings for all instances in a cluster.
        :param pulumi.Input['GkeClusterConfigArgs'] gke_cluster_config: Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        :param pulumi.Input[Sequence[pulumi.Input['NodeInitializationActionArgs']]] initialization_actions: Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        :param pulumi.Input['LifecycleConfigArgs'] lifecycle_config: Optional. Lifecycle setting for the cluster.
        :param pulumi.Input['InstanceGroupConfigArgs'] master_config: Optional. The Compute Engine config settings for the master instance in a cluster.
        :param pulumi.Input['MetastoreConfigArgs'] metastore_config: Optional. Metastore configuration.
        :param pulumi.Input['InstanceGroupConfigArgs'] secondary_worker_config: Optional. The Compute Engine config settings for additional worker instances in a cluster.
        :param pulumi.Input['SecurityConfigArgs'] security_config: Optional. Security settings for the cluster.
        :param pulumi.Input['SoftwareConfigArgs'] software_config: Optional. The config settings for software inside the cluster.
        :param pulumi.Input[str] temp_bucket: Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        :param pulumi.Input['InstanceGroupConfigArgs'] worker_config: Optional. The Compute Engine config settings for worker instances in a cluster.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if config_bucket is not None:
            pulumi.set(__self__, "config_bucket", config_bucket)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if gke_cluster_config is not None:
            pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if secondary_worker_config is not None:
            pulumi.set(__self__, "secondary_worker_config", secondary_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if temp_bucket is not None:
            pulumi.set(__self__, "temp_bucket", temp_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['AutoscalingConfigArgs']]:
        """
        Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        """
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['AutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter(name="configBucket")
    def config_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging bucket (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "config_bucket")

    @config_bucket.setter
    def config_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_bucket", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['EncryptionConfigArgs']]:
        """
        Optional. Encryption settings for the cluster.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['EncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['EndpointConfigArgs']]:
        """
        Optional. Port/endpoint configuration for this cluster
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['EndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional[pulumi.Input['GceClusterConfigArgs']]:
        """
        Optional. The shared Compute Engine config settings for all instances in a cluster.
        """
        return pulumi.get(self, "gce_cluster_config")

    @gce_cluster_config.setter
    def gce_cluster_config(self, value: Optional[pulumi.Input['GceClusterConfigArgs']]):
        pulumi.set(self, "gce_cluster_config", value)

    @property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> Optional[pulumi.Input['GkeClusterConfigArgs']]:
        """
        Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        """
        return pulumi.get(self, "gke_cluster_config")

    @gke_cluster_config.setter
    def gke_cluster_config(self, value: Optional[pulumi.Input['GkeClusterConfigArgs']]):
        pulumi.set(self, "gke_cluster_config", value)

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeInitializationActionArgs']]]]:
        """
        Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        """
        return pulumi.get(self, "initialization_actions")

    @initialization_actions.setter
    def initialization_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeInitializationActionArgs']]]]):
        pulumi.set(self, "initialization_actions", value)

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional[pulumi.Input['LifecycleConfigArgs']]:
        """
        Optional. Lifecycle setting for the cluster.
        """
        return pulumi.get(self, "lifecycle_config")

    @lifecycle_config.setter
    def lifecycle_config(self, value: Optional[pulumi.Input['LifecycleConfigArgs']]):
        pulumi.set(self, "lifecycle_config", value)

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional[pulumi.Input['InstanceGroupConfigArgs']]:
        """
        Optional. The Compute Engine config settings for the master instance in a cluster.
        """
        return pulumi.get(self, "master_config")

    @master_config.setter
    def master_config(self, value: Optional[pulumi.Input['InstanceGroupConfigArgs']]):
        pulumi.set(self, "master_config", value)

    @property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional[pulumi.Input['MetastoreConfigArgs']]:
        """
        Optional. Metastore configuration.
        """
        return pulumi.get(self, "metastore_config")

    @metastore_config.setter
    def metastore_config(self, value: Optional[pulumi.Input['MetastoreConfigArgs']]):
        pulumi.set(self, "metastore_config", value)

    @property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> Optional[pulumi.Input['InstanceGroupConfigArgs']]:
        """
        Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "secondary_worker_config")

    @secondary_worker_config.setter
    def secondary_worker_config(self, value: Optional[pulumi.Input['InstanceGroupConfigArgs']]):
        pulumi.set(self, "secondary_worker_config", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['SecurityConfigArgs']]:
        """
        Optional. Security settings for the cluster.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['SecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['SoftwareConfigArgs']]:
        """
        Optional. The config settings for software inside the cluster.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['SoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "temp_bucket")

    @temp_bucket.setter
    def temp_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_bucket", value)

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional[pulumi.Input['InstanceGroupConfigArgs']]:
        """
        Optional. The Compute Engine config settings for worker instances in a cluster.
        """
        return pulumi.get(self, "worker_config")

    @worker_config.setter
    def worker_config(self, value: Optional[pulumi.Input['InstanceGroupConfigArgs']]):
        pulumi.set(self, "worker_config", value)


@pulumi.input_type
class ClusterSelectorArgs:
    def __init__(__self__, *,
                 cluster_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        A selector that chooses target cluster for jobs based on metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_labels: Required. The cluster labels. Cluster must have all labels to match.
        :param pulumi.Input[str] zone: Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        if cluster_labels is not None:
            pulumi.set(__self__, "cluster_labels", cluster_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Required. The cluster labels. Cluster must have all labels to match.
        """
        return pulumi.get(self, "cluster_labels")

    @cluster_labels.setter
    def cluster_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_labels", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        Specifies the config of disk options for a group of VM instances.
        :param pulumi.Input[int] boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param pulumi.Input[str] boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        :param pulumi.Input[int] num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class EncryptionConfigArgs:
    def __init__(__self__, *,
                 gce_pd_kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        Encryption settings for the cluster.
        :param pulumi.Input[str] gce_pd_kms_key_name: Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        if gce_pd_kms_key_name is not None:
            pulumi.set(__self__, "gce_pd_kms_key_name", gce_pd_kms_key_name)

    @property
    @pulumi.getter(name="gcePdKmsKeyName")
    def gce_pd_kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        return pulumi.get(self, "gce_pd_kms_key_name")

    @gce_pd_kms_key_name.setter
    def gce_pd_kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gce_pd_kms_key_name", value)


@pulumi.input_type
class EndpointConfigArgs:
    def __init__(__self__, *,
                 enable_http_port_access: Optional[pulumi.Input[bool]] = None):
        """
        Endpoint config for this cluster
        :param pulumi.Input[bool] enable_http_port_access: Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        if enable_http_port_access is not None:
            pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @enable_http_port_access.setter
    def enable_http_port_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_http_port_access", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GceClusterConfigArgs:
    def __init__(__self__, *,
                 internal_ip_only: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network_uri: Optional[pulumi.Input[str]] = None,
                 node_group_affinity: Optional[pulumi.Input['NodeGroupAffinityArgs']] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['ReservationAffinityArgs']] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ShieldedInstanceConfigArgs']] = None,
                 subnetwork_uri: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone_uri: Optional[pulumi.Input[str]] = None):
        """
        Common config settings for resources of Compute Engine cluster instances, applicable to all instances in the cluster.
        :param pulumi.Input[bool] internal_ip_only: Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param pulumi.Input[str] network_uri: Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        :param pulumi.Input['NodeGroupAffinityArgs'] node_group_affinity: Optional. Node Group Affinity for sole-tenant clusters.
        :param pulumi.Input[str] private_ipv6_google_access: Optional. The type of IPv6 access for a cluster.
        :param pulumi.Input['ReservationAffinityArgs'] reservation_affinity: Optional. Reservation Affinity for consuming Zonal reservation.
        :param pulumi.Input[str] service_account: Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        :param pulumi.Input['ShieldedInstanceConfigArgs'] shielded_instance_config: Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param pulumi.Input[str] subnetwork_uri: Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param pulumi.Input[str] zone_uri: Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_uri is not None:
            pulumi.set(__self__, "network_uri", network_uri)
        if node_group_affinity is not None:
            pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnetwork_uri is not None:
            pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_uri is not None:
            pulumi.set(__self__, "zone_uri", zone_uri)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @internal_ip_only.setter
    def internal_ip_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_ip_only", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        """
        return pulumi.get(self, "network_uri")

    @network_uri.setter
    def network_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_uri", value)

    @property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> Optional[pulumi.Input['NodeGroupAffinityArgs']]:
        """
        Optional. Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @node_group_affinity.setter
    def node_group_affinity(self, value: Optional[pulumi.Input['NodeGroupAffinityArgs']]):
        pulumi.set(self, "node_group_affinity", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The type of IPv6 access for a cluster.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['ReservationAffinityArgs']]:
        """
        Optional. Reservation Affinity for consuming Zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['ReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ShieldedInstanceConfigArgs']]:
        """
        Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        """
        return pulumi.get(self, "subnetwork_uri")

    @subnetwork_uri.setter
    def subnetwork_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork_uri", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="zoneUri")
    def zone_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        return pulumi.get(self, "zone_uri")

    @zone_uri.setter
    def zone_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_uri", value)


@pulumi.input_type
class GkeClusterConfigArgs:
    def __init__(__self__, *,
                 namespaced_gke_deployment_target: Optional[pulumi.Input['NamespacedGkeDeploymentTargetArgs']] = None):
        """
        The GKE config for this cluster.
        :param pulumi.Input['NamespacedGkeDeploymentTargetArgs'] namespaced_gke_deployment_target: Optional. A target for the deployment.
        """
        if namespaced_gke_deployment_target is not None:
            pulumi.set(__self__, "namespaced_gke_deployment_target", namespaced_gke_deployment_target)

    @property
    @pulumi.getter(name="namespacedGkeDeploymentTarget")
    def namespaced_gke_deployment_target(self) -> Optional[pulumi.Input['NamespacedGkeDeploymentTargetArgs']]:
        """
        Optional. A target for the deployment.
        """
        return pulumi.get(self, "namespaced_gke_deployment_target")

    @namespaced_gke_deployment_target.setter
    def namespaced_gke_deployment_target(self, value: Optional[pulumi.Input['NamespacedGkeDeploymentTargetArgs']]):
        pulumi.set(self, "namespaced_gke_deployment_target", value)


@pulumi.input_type
class HadoopJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache Hadoop MapReduce (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class HiveJobArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['QueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache Hive (https://hive.apache.org/) queries on YARN.
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains Hive queries.
        :param pulumi.Input['QueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains Hive queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['QueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['QueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class IdentityConfigArgs:
    def __init__(__self__, *,
                 user_service_account_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_service_account_mapping: Required. Map of user to service account.
        """
        if user_service_account_mapping is not None:
            pulumi.set(__self__, "user_service_account_mapping", user_service_account_mapping)

    @property
    @pulumi.getter(name="userServiceAccountMapping")
    def user_service_account_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Required. Map of user to service account.
        """
        return pulumi.get(self, "user_service_account_mapping")

    @user_service_account_mapping.setter
    def user_service_account_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_service_account_mapping", value)


@pulumi.input_type
class InstanceGroupAutoscalingPolicyConfigArgs:
    def __init__(__self__, *,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Configuration for the size bounds of an instance group, including its proportional size to other groups.
        :param pulumi.Input[int] max_instances: Required. Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        :param pulumi.Input[int] min_instances: Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        :param pulumi.Input[int] weight: Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class InstanceGroupConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['DiskConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 machine_type_uri: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None,
                 preemptibility: Optional[pulumi.Input[str]] = None):
        """
        The config settings for Compute Engine resources in an instance group, such as a master or worker group.
        :param pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param pulumi.Input['DiskConfigArgs'] disk_config: Optional. Disk option config settings.
        :param pulumi.Input[str] image_uri: Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        :param pulumi.Input[str] machine_type_uri: Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        :param pulumi.Input[str] min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param pulumi.Input[int] num_instances: Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        :param pulumi.Input[str] preemptibility: Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if machine_type_uri is not None:
            pulumi.set(__self__, "machine_type_uri", machine_type_uri)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorConfigArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['DiskConfigArgs']]:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['DiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="machineTypeUri")
    def machine_type_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        """
        return pulumi.get(self, "machine_type_uri")

    @machine_type_uri.setter
    def machine_type_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type_uri", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)

    @property
    @pulumi.getter
    def preemptibility(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        return pulumi.get(self, "preemptibility")

    @preemptibility.setter
    def preemptibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemptibility", value)


@pulumi.input_type
class JobPlacementArgs:
    def __init__(__self__, *,
                 cluster_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None):
        """
        Dataproc job config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_labels: Optional. Cluster labels to identify a cluster where the job will be submitted.
        :param pulumi.Input[str] cluster_name: Required. The name of the cluster where the job will be submitted.
        """
        if cluster_labels is not None:
            pulumi.set(__self__, "cluster_labels", cluster_labels)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Cluster labels to identify a cluster where the job will be submitted.
        """
        return pulumi.get(self, "cluster_labels")

    @cluster_labels.setter
    def cluster_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_labels", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the cluster where the job will be submitted.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)


@pulumi.input_type
class JobReferenceArgs:
    def __init__(__self__, *,
                 job_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        Encapsulates the full scoping used to reference a job.
        :param pulumi.Input[str] job_id: Optional. The job ID, which must be unique within the project.The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or hyphens (-). The maximum length is 100 characters.If not specified by the caller, the job ID will be provided by the server.
        :param pulumi.Input[str] project_id: Optional. The ID of the Google Cloud Platform project that the job belongs to. If specified, must match the request project ID.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The job ID, which must be unique within the project.The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or hyphens (-). The maximum length is 100 characters.If not specified by the caller, the job ID will be provided by the server.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The ID of the Google Cloud Platform project that the job belongs to. If specified, must match the request project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobSchedulingArgs:
    def __init__(__self__, *,
                 max_failures_per_hour: Optional[pulumi.Input[int]] = None,
                 max_failures_total: Optional[pulumi.Input[int]] = None):
        """
        Job scheduling options.
        :param pulumi.Input[int] max_failures_per_hour: Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.
        :param pulumi.Input[int] max_failures_total: Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
        """
        if max_failures_per_hour is not None:
            pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        if max_failures_total is not None:
            pulumi.set(__self__, "max_failures_total", max_failures_total)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @max_failures_per_hour.setter
    def max_failures_per_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_failures_per_hour", value)

    @property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
        """
        return pulumi.get(self, "max_failures_total")

    @max_failures_total.setter
    def max_failures_total(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_failures_total", value)


@pulumi.input_type
class KerberosConfigArgs:
    def __init__(__self__, *,
                 cross_realm_trust_admin_server: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_kdc: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_realm: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_shared_password_uri: Optional[pulumi.Input[str]] = None,
                 enable_kerberos: Optional[pulumi.Input[bool]] = None,
                 kdc_db_key_uri: Optional[pulumi.Input[str]] = None,
                 key_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_uri: Optional[pulumi.Input[str]] = None,
                 kms_key_uri: Optional[pulumi.Input[str]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 root_principal_password_uri: Optional[pulumi.Input[str]] = None,
                 tgt_lifetime_hours: Optional[pulumi.Input[int]] = None,
                 truststore_password_uri: Optional[pulumi.Input[str]] = None,
                 truststore_uri: Optional[pulumi.Input[str]] = None):
        """
        Specifies Kerberos related configuration.
        :param pulumi.Input[str] cross_realm_trust_admin_server: Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_kdc: Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_realm: Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        :param pulumi.Input[str] cross_realm_trust_shared_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        :param pulumi.Input[bool] enable_kerberos: Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        :param pulumi.Input[str] kdc_db_key_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        :param pulumi.Input[str] key_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] keystore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] keystore_uri: Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param pulumi.Input[str] kms_key_uri: Optional. The uri of the KMS key used to encrypt various sensitive files.
        :param pulumi.Input[str] realm: Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        :param pulumi.Input[str] root_principal_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        :param pulumi.Input[int] tgt_lifetime_hours: Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        :param pulumi.Input[str] truststore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] truststore_uri: Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password_uri is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key_uri is not None:
            pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        if key_password_uri is not None:
            pulumi.set(__self__, "key_password_uri", key_password_uri)
        if keystore_password_uri is not None:
            pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        if keystore_uri is not None:
            pulumi.set(__self__, "keystore_uri", keystore_uri)
        if kms_key_uri is not None:
            pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if root_principal_password_uri is not None:
            pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore_password_uri is not None:
            pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @cross_realm_trust_admin_server.setter
    def cross_realm_trust_admin_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_admin_server", value)

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @cross_realm_trust_kdc.setter
    def cross_realm_trust_kdc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_kdc", value)

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @cross_realm_trust_realm.setter
    def cross_realm_trust_realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_realm", value)

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @cross_realm_trust_shared_password_uri.setter
    def cross_realm_trust_shared_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_shared_password_uri", value)

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @enable_kerberos.setter
    def enable_kerberos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kerberos", value)

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @kdc_db_key_uri.setter
    def kdc_db_key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kdc_db_key_uri", value)

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @key_password_uri.setter
    def key_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_password_uri", value)

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @keystore_password_uri.setter
    def keystore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_password_uri", value)

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @keystore_uri.setter
    def keystore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_uri", value)

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The uri of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @kms_key_uri.setter
    def kms_key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_uri", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @root_principal_password_uri.setter
    def root_principal_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_principal_password_uri", value)

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @tgt_lifetime_hours.setter
    def tgt_lifetime_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tgt_lifetime_hours", value)

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @truststore_password_uri.setter
    def truststore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_password_uri", value)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_uri", value)


@pulumi.input_type
class LifecycleConfigArgs:
    def __init__(__self__, *,
                 auto_delete_time: Optional[pulumi.Input[str]] = None,
                 auto_delete_ttl: Optional[pulumi.Input[str]] = None,
                 idle_delete_ttl: Optional[pulumi.Input[str]] = None):
        """
        Specifies the cluster auto-delete schedule configuration.
        :param pulumi.Input[str] auto_delete_time: Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param pulumi.Input[str] auto_delete_ttl: Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param pulumi.Input[str] idle_delete_ttl: Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if auto_delete_ttl is not None:
            pulumi.set(__self__, "auto_delete_ttl", auto_delete_ttl)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_time")

    @auto_delete_time.setter
    def auto_delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_time", value)

    @property
    @pulumi.getter(name="autoDeleteTtl")
    def auto_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_ttl")

    @auto_delete_ttl.setter
    def auto_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_ttl", value)

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_delete_ttl")

    @idle_delete_ttl.setter
    def idle_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_delete_ttl", value)


@pulumi.input_type
class LoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The runtime logging config of the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class ManagedClusterArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['ClusterConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Cluster that is managed by the workflow.
        :param pulumi.Input[str] cluster_name: Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        :param pulumi.Input['ClusterConfigArgs'] config: Required. The cluster configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ClusterConfigArgs']]:
        """
        Required. The cluster configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ClusterConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class MetastoreConfigArgs:
    def __init__(__self__, *,
                 dataproc_metastore_service: Optional[pulumi.Input[str]] = None):
        """
        Specifies a Metastore configuration.
        :param pulumi.Input[str] dataproc_metastore_service: Required. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        if dataproc_metastore_service is not None:
            pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        return pulumi.get(self, "dataproc_metastore_service")

    @dataproc_metastore_service.setter
    def dataproc_metastore_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataproc_metastore_service", value)


@pulumi.input_type
class NamespacedGkeDeploymentTargetArgs:
    def __init__(__self__, *,
                 cluster_namespace: Optional[pulumi.Input[str]] = None,
                 target_gke_cluster: Optional[pulumi.Input[str]] = None):
        """
        A full, namespace-isolated deployment target for an existing GKE cluster.
        :param pulumi.Input[str] cluster_namespace: Optional. A namespace within the GKE cluster to deploy into.
        :param pulumi.Input[str] target_gke_cluster: Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        if cluster_namespace is not None:
            pulumi.set(__self__, "cluster_namespace", cluster_namespace)
        if target_gke_cluster is not None:
            pulumi.set(__self__, "target_gke_cluster", target_gke_cluster)

    @property
    @pulumi.getter(name="clusterNamespace")
    def cluster_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A namespace within the GKE cluster to deploy into.
        """
        return pulumi.get(self, "cluster_namespace")

    @cluster_namespace.setter
    def cluster_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_namespace", value)

    @property
    @pulumi.getter(name="targetGkeCluster")
    def target_gke_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "target_gke_cluster")

    @target_gke_cluster.setter
    def target_gke_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_gke_cluster", value)


@pulumi.input_type
class NodeGroupAffinityArgs:
    def __init__(__self__, *,
                 node_group_uri: Optional[pulumi.Input[str]] = None):
        """
        Node Group Affinity for clusters using sole-tenant node groups.
        :param pulumi.Input[str] node_group_uri: Required. The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        if node_group_uri is not None:
            pulumi.set(__self__, "node_group_uri", node_group_uri)

    @property
    @pulumi.getter(name="nodeGroupUri")
    def node_group_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        return pulumi.get(self, "node_group_uri")

    @node_group_uri.setter
    def node_group_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_uri", value)


@pulumi.input_type
class NodeInitializationActionArgs:
    def __init__(__self__, *,
                 executable_file: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None):
        """
        Specifies an executable to run on a fully configured node and a timeout period for executable completion.
        :param pulumi.Input[str] executable_file: Required. Cloud Storage URI of executable file.
        :param pulumi.Input[str] execution_timeout: Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        if executable_file is not None:
            pulumi.set(__self__, "executable_file", executable_file)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)

    @property
    @pulumi.getter(name="executableFile")
    def executable_file(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Cloud Storage URI of executable file.
        """
        return pulumi.get(self, "executable_file")

    @executable_file.setter
    def executable_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable_file", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_timeout", value)


@pulumi.input_type
class OrderedJobArgs:
    def __init__(__self__, *,
                 hadoop_job: Optional[pulumi.Input['HadoopJobArgs']] = None,
                 hive_job: Optional[pulumi.Input['HiveJobArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_job: Optional[pulumi.Input['PigJobArgs']] = None,
                 prerequisite_step_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 presto_job: Optional[pulumi.Input['PrestoJobArgs']] = None,
                 pyspark_job: Optional[pulumi.Input['PySparkJobArgs']] = None,
                 scheduling: Optional[pulumi.Input['JobSchedulingArgs']] = None,
                 spark_job: Optional[pulumi.Input['SparkJobArgs']] = None,
                 spark_r_job: Optional[pulumi.Input['SparkRJobArgs']] = None,
                 spark_sql_job: Optional[pulumi.Input['SparkSqlJobArgs']] = None,
                 step_id: Optional[pulumi.Input[str]] = None):
        """
        A job executed by the workflow.
        :param pulumi.Input['HadoopJobArgs'] hadoop_job: Optional. Job is a Hadoop job.
        :param pulumi.Input['HiveJobArgs'] hive_job: Optional. Job is a Hive job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        :param pulumi.Input['PigJobArgs'] pig_job: Optional. Job is a Pig job.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prerequisite_step_ids: Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        :param pulumi.Input['PrestoJobArgs'] presto_job: Optional. Job is a Presto job.
        :param pulumi.Input['PySparkJobArgs'] pyspark_job: Optional. Job is a PySpark job.
        :param pulumi.Input['JobSchedulingArgs'] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input['SparkJobArgs'] spark_job: Optional. Job is a Spark job.
        :param pulumi.Input['SparkRJobArgs'] spark_r_job: Optional. Job is a SparkR job.
        :param pulumi.Input['SparkSqlJobArgs'] spark_sql_job: Optional. Job is a SparkSql job.
        :param pulumi.Input[str] step_id: Required. The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        if hadoop_job is not None:
            pulumi.set(__self__, "hadoop_job", hadoop_job)
        if hive_job is not None:
            pulumi.set(__self__, "hive_job", hive_job)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pig_job is not None:
            pulumi.set(__self__, "pig_job", pig_job)
        if prerequisite_step_ids is not None:
            pulumi.set(__self__, "prerequisite_step_ids", prerequisite_step_ids)
        if presto_job is not None:
            pulumi.set(__self__, "presto_job", presto_job)
        if pyspark_job is not None:
            pulumi.set(__self__, "pyspark_job", pyspark_job)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spark_job is not None:
            pulumi.set(__self__, "spark_job", spark_job)
        if spark_r_job is not None:
            pulumi.set(__self__, "spark_r_job", spark_r_job)
        if spark_sql_job is not None:
            pulumi.set(__self__, "spark_sql_job", spark_sql_job)
        if step_id is not None:
            pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> Optional[pulumi.Input['HadoopJobArgs']]:
        """
        Optional. Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @hadoop_job.setter
    def hadoop_job(self, value: Optional[pulumi.Input['HadoopJobArgs']]):
        pulumi.set(self, "hadoop_job", value)

    @property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> Optional[pulumi.Input['HiveJobArgs']]:
        """
        Optional. Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @hive_job.setter
    def hive_job(self, value: Optional[pulumi.Input['HiveJobArgs']]):
        pulumi.set(self, "hive_job", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> Optional[pulumi.Input['PigJobArgs']]:
        """
        Optional. Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @pig_job.setter
    def pig_job(self, value: Optional[pulumi.Input['PigJobArgs']]):
        pulumi.set(self, "pig_job", value)

    @property
    @pulumi.getter(name="prerequisiteStepIds")
    def prerequisite_step_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        """
        return pulumi.get(self, "prerequisite_step_ids")

    @prerequisite_step_ids.setter
    def prerequisite_step_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prerequisite_step_ids", value)

    @property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> Optional[pulumi.Input['PrestoJobArgs']]:
        """
        Optional. Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @presto_job.setter
    def presto_job(self, value: Optional[pulumi.Input['PrestoJobArgs']]):
        pulumi.set(self, "presto_job", value)

    @property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> Optional[pulumi.Input['PySparkJobArgs']]:
        """
        Optional. Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @pyspark_job.setter
    def pyspark_job(self, value: Optional[pulumi.Input['PySparkJobArgs']]):
        pulumi.set(self, "pyspark_job", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['JobSchedulingArgs']]:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['JobSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> Optional[pulumi.Input['SparkJobArgs']]:
        """
        Optional. Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @spark_job.setter
    def spark_job(self, value: Optional[pulumi.Input['SparkJobArgs']]):
        pulumi.set(self, "spark_job", value)

    @property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> Optional[pulumi.Input['SparkRJobArgs']]:
        """
        Optional. Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @spark_r_job.setter
    def spark_r_job(self, value: Optional[pulumi.Input['SparkRJobArgs']]):
        pulumi.set(self, "spark_r_job", value)

    @property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> Optional[pulumi.Input['SparkSqlJobArgs']]:
        """
        Optional. Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")

    @spark_sql_job.setter
    def spark_sql_job(self, value: Optional[pulumi.Input['SparkSqlJobArgs']]):
        pulumi.set(self, "spark_sql_job", value)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        return pulumi.get(self, "step_id")

    @step_id.setter
    def step_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_id", value)


@pulumi.input_type
class ParameterValidationArgs:
    def __init__(__self__, *,
                 regex: Optional[pulumi.Input['RegexValidationArgs']] = None,
                 values: Optional[pulumi.Input['ValueValidationArgs']] = None):
        """
        Configuration for parameter validation.
        :param pulumi.Input['RegexValidationArgs'] regex: Validation based on regular expressions.
        :param pulumi.Input['ValueValidationArgs'] values: Validation based on a list of allowed values.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input['RegexValidationArgs']]:
        """
        Validation based on regular expressions.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input['RegexValidationArgs']]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input['ValueValidationArgs']]:
        """
        Validation based on a list of allowed values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input['ValueValidationArgs']]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class PigJobArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['QueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache Pig (https://pig.apache.org/) queries on YARN.
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains the Pig queries.
        :param pulumi.Input['QueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains the Pig queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['QueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['QueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class PrestoJobArgs:
    def __init__(__self__, *,
                 client_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['QueryListArgs']] = None):
        """
        A Dataproc job for running Presto (https://prestosql.io/) queries. IMPORTANT: The Dataproc Presto Optional Component (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be enabled when the cluster is created to submit a Presto job to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_tags: Optional. Presto client tags to attach to this query
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] output_format: Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['QueryListArgs'] query_list: A list of queries.
        """
        if client_tags is not None:
            pulumi.set(__self__, "client_tags", client_tags)
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)

    @property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Presto client tags to attach to this query
        """
        return pulumi.get(self, "client_tags")

    @client_tags.setter
    def client_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_tags", value)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['QueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['QueryListArgs']]):
        pulumi.set(self, "query_list", value)


@pulumi.input_type
class PySparkJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 main_python_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache PySpark (https://spark.apache.org/docs/0.9.0/python-programming-guide.html) applications on YARN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_python_file_uri: Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] python_file_uris: Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_python_file_uri is not None:
            pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @main_python_file_uri.setter
    def main_python_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_python_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    @python_file_uris.setter
    def python_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "python_file_uris", value)


@pulumi.input_type
class QueryListArgs:
    def __init__(__self__, *,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A list of queries to run on a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        if queries is not None:
            pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class RegexValidationArgs:
    def __init__(__self__, *,
                 regexes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Validation based on regular expressions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regexes: Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        if regexes is not None:
            pulumi.set(__self__, "regexes", regexes)

    @property
    @pulumi.getter
    def regexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        return pulumi.get(self, "regexes")

    @regexes.setter
    def regexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regexes", value)


@pulumi.input_type
class ReservationAffinityArgs:
    def __init__(__self__, *,
                 consume_reservation_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Reservation Affinity for consuming Zonal reservation.
        :param pulumi.Input[str] consume_reservation_type: Optional. Type of reservation to consume
        :param pulumi.Input[str] key: Optional. Corresponds to the label key of reservation resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Optional. Corresponds to the label values of reservation resource.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of reservation to consume
        """
        return pulumi.get(self, "consume_reservation_type")

    @consume_reservation_type.setter
    def consume_reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consume_reservation_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class SecurityConfigArgs:
    def __init__(__self__, *,
                 identity_config: Optional[pulumi.Input['IdentityConfigArgs']] = None,
                 kerberos_config: Optional[pulumi.Input['KerberosConfigArgs']] = None):
        """
        Security related configuration, including encryption, Kerberos, etc.
        :param pulumi.Input['IdentityConfigArgs'] identity_config: Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param pulumi.Input['KerberosConfigArgs'] kerberos_config: Optional. Kerberos related configuration.
        """
        if identity_config is not None:
            pulumi.set(__self__, "identity_config", identity_config)
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="identityConfig")
    def identity_config(self) -> Optional[pulumi.Input['IdentityConfigArgs']]:
        """
        Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        """
        return pulumi.get(self, "identity_config")

    @identity_config.setter
    def identity_config(self, value: Optional[pulumi.Input['IdentityConfigArgs']]):
        pulumi.set(self, "identity_config", value)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional[pulumi.Input['KerberosConfigArgs']]:
        """
        Optional. Kerberos related configuration.
        """
        return pulumi.get(self, "kerberos_config")

    @kerberos_config.setter
    def kerberos_config(self, value: Optional[pulumi.Input['KerberosConfigArgs']]):
        pulumi.set(self, "kerberos_config", value)


@pulumi.input_type
class ShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None):
        """
        Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param pulumi.Input[bool] enable_integrity_monitoring: Optional. Defines whether instances have integrity monitoring enabled.
        :param pulumi.Input[bool] enable_secure_boot: Optional. Defines whether instances have Secure Boot enabled.
        :param pulumi.Input[bool] enable_vtpm: Optional. Defines whether instances have the vTPM enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Defines whether instances have integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Defines whether instances have Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Defines whether instances have the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)


@pulumi.input_type
class SoftwareConfigArgs:
    def __init__(__self__, *,
                 image_version: Optional[pulumi.Input[str]] = None,
                 optional_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Specifies the selection and config of software inside the cluster.
        :param pulumi.Input[str] image_version: Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] optional_components: Optional. The set of components to activate on the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of components to activate on the cluster.
        """
        return pulumi.get(self, "optional_components")

    @optional_components.setter
    def optional_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "optional_components", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SparkJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache Spark (http://spark.apache.org/) applications on YARN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SparkRJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 main_r_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_r_file_uri: Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_r_file_uri is not None:
            pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @main_r_file_uri.setter
    def main_r_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_r_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SparkSqlJobArgs:
    def __init__(__self__, *,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['LoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['QueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['LoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['QueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['LoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['LoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['QueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['QueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class TemplateParameterArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 validation: Optional[pulumi.Input['ParameterValidationArgs']] = None):
        """
        A configurable parameter that replaces one or more fields in the template. Parameterizable fields: - Labels - File uris - Job properties - Job arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone (in ClusterSelector)
        :param pulumi.Input[str] description: Optional. Brief description of the parameter. Must not exceed 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fields: Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        :param pulumi.Input[str] name: Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        :param pulumi.Input['ParameterValidationArgs'] validation: Optional. Validation rules to be applied to this parameter's value.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Brief description of the parameter. Must not exceed 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['ParameterValidationArgs']]:
        """
        Optional. Validation rules to be applied to this parameter's value.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['ParameterValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class ValueValidationArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Validation based on a list of allowed values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Required. List of allowed values for the parameter.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. List of allowed values for the parameter.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class WorkflowTemplatePlacementArgs:
    def __init__(__self__, *,
                 cluster_selector: Optional[pulumi.Input['ClusterSelectorArgs']] = None,
                 managed_cluster: Optional[pulumi.Input['ManagedClusterArgs']] = None):
        """
        Specifies workflow execution target.Either managed_cluster or cluster_selector is required.
        :param pulumi.Input['ClusterSelectorArgs'] cluster_selector: Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        :param pulumi.Input['ManagedClusterArgs'] managed_cluster: A cluster that is managed by the workflow.
        """
        if cluster_selector is not None:
            pulumi.set(__self__, "cluster_selector", cluster_selector)
        if managed_cluster is not None:
            pulumi.set(__self__, "managed_cluster", managed_cluster)

    @property
    @pulumi.getter(name="clusterSelector")
    def cluster_selector(self) -> Optional[pulumi.Input['ClusterSelectorArgs']]:
        """
        Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        """
        return pulumi.get(self, "cluster_selector")

    @cluster_selector.setter
    def cluster_selector(self, value: Optional[pulumi.Input['ClusterSelectorArgs']]):
        pulumi.set(self, "cluster_selector", value)

    @property
    @pulumi.getter(name="managedCluster")
    def managed_cluster(self) -> Optional[pulumi.Input['ManagedClusterArgs']]:
        """
        A cluster that is managed by the workflow.
        """
        return pulumi.get(self, "managed_cluster")

    @managed_cluster.setter
    def managed_cluster(self, value: Optional[pulumi.Input['ManagedClusterArgs']]):
        pulumi.set(self, "managed_cluster", value)


