# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'CloudSqlConnectionProfileArgs',
    'CloudSqlSettingsArgs',
    'DatabaseTypeArgs',
    'ExprArgs',
    'MySqlConnectionProfileArgs',
    'PostgreSqlConnectionProfileArgs',
    'ReverseSshConnectivityArgs',
    'SqlAclEntryArgs',
    'SqlIpConfigArgs',
    'SslConfigArgs',
    'StaticIpConnectivityArgs',
    'VpcPeeringConnectivityArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input[str]] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[str] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CloudSqlConnectionProfileArgs:
    def __init__(__self__, *,
                 settings: Optional[pulumi.Input['CloudSqlSettingsArgs']] = None):
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        :param pulumi.Input['CloudSqlSettingsArgs'] settings: Immutable. Metadata used to create the destination Cloud SQL database.
        """
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['CloudSqlSettingsArgs']]:
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['CloudSqlSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class CloudSqlSettingsArgs:
    def __init__(__self__, *,
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 auto_storage_increase: Optional[pulumi.Input[bool]] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[str]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 ip_config: Optional[pulumi.Input['SqlIpConfigArgs']] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 storage_auto_resize_limit: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Settings for creating a Cloud SQL database instance.
        :param pulumi.Input[str] activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'. Valid values: 'ALWAYS': The instance is on, and remains so even in the absence of connection requests. `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        :param pulumi.Input[bool] auto_storage_increase: [default: ON] If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity. If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        :param pulumi.Input[str] collation: The Cloud SQL default instance level collation.
        :param pulumi.Input[str] data_disk_size_gb: The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        :param pulumi.Input[str] data_disk_type: The type of storage: `PD_SSD` (default) or `PD_HDD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: The database flags passed to the Cloud SQL instance at startup. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] database_version: The database engine type and version.
        :param pulumi.Input['SqlIpConfigArgs'] ip_config: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        :param pulumi.Input[str] root_password: Input only. Initial root password.
        :param pulumi.Input[str] source_id: The Database Migration Service source connection profile ID, in the format: `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
        :param pulumi.Input[str] storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[str] tier: The tier (or machine type) for this instance, for example: `db-n1-standard-1` (MySQL instances) or `db-custom-1-3840` (PostgreSQL instances). For more information, see [Cloud SQL Instance Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
        :param pulumi.Input[str] zone: The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if auto_storage_increase is not None:
            pulumi.set(__self__, "auto_storage_increase", auto_storage_increase)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if ip_config is not None:
            pulumi.set(__self__, "ip_config", ip_config)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if storage_auto_resize_limit is not None:
            pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'. Valid values: 'ALWAYS': The instance is on, and remains so even in the absence of connection requests. `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="autoStorageIncrease")
    def auto_storage_increase(self) -> Optional[pulumi.Input[bool]]:
        """
        [default: ON] If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity. If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        return pulumi.get(self, "auto_storage_increase")

    @auto_storage_increase.setter
    def auto_storage_increase(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_storage_increase", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud SQL default instance level collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of storage: `PD_SSD` (default) or `PD_HDD`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The database flags passed to the Cloud SQL instance at startup. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine type and version.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="ipConfig")
    def ip_config(self) -> Optional[pulumi.Input['SqlIpConfigArgs']]:
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        """
        return pulumi.get(self, "ip_config")

    @ip_config.setter
    def ip_config(self, value: Optional[pulumi.Input['SqlIpConfigArgs']]):
        pulumi.set(self, "ip_config", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Initial root password.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Database Migration Service source connection profile ID, in the format: `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @storage_auto_resize_limit.setter
    def storage_auto_resize_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_auto_resize_limit", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier (or machine type) for this instance, for example: `db-n1-standard-1` (MySQL instances) or `db-custom-1-3840` (PostgreSQL instances). For more information, see [Cloud SQL Instance Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DatabaseTypeArgs:
    def __init__(__self__, *,
                 engine: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None):
        """
        A message defining the database engine and provider.
        :param pulumi.Input[str] engine: The database engine.
        :param pulumi.Input[str] provider: The database provider.
        """
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[str]]:
        """
        The database provider.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class MySqlConnectionProfileArgs:
    def __init__(__self__, *,
                 cloud_sql_id: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 ssl: Optional[pulumi.Input['SslConfigArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Specifies connection parameters required specifically for MySQL databases.
        :param pulumi.Input[str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[str] host: Required. The IP or hostname of the source MySQL database.
        :param pulumi.Input[str] password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        :param pulumi.Input[int] port: Required. The network port of the source MySQL database.
        :param pulumi.Input['SslConfigArgs'] ssl: SSL configuration for the destination to connect to the source database.
        :param pulumi.Input[str] username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['SslConfigArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['SslConfigArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class PostgreSqlConnectionProfileArgs:
    def __init__(__self__, *,
                 cloud_sql_id: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 ssl: Optional[pulumi.Input['SslConfigArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        :param pulumi.Input[str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[str] host: Required. The IP or hostname of the source PostgreSQL database.
        :param pulumi.Input[str] password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        :param pulumi.Input[int] port: Required. The network port of the source PostgreSQL database.
        :param pulumi.Input['SslConfigArgs'] ssl: SSL configuration for the destination to connect to the source database.
        :param pulumi.Input[str] username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The IP or hostname of the source PostgreSQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The network port of the source PostgreSQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['SslConfigArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['SslConfigArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ReverseSshConnectivityArgs:
    def __init__(__self__, *,
                 vm: Optional[pulumi.Input[str]] = None,
                 vm_ip: Optional[pulumi.Input[str]] = None,
                 vm_port: Optional[pulumi.Input[int]] = None,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        The details needed to configure a reverse SSH tunnel between the source and destination databases. These details will be used when calling the generateSshScript method (see https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript) to produce the script that will help set up the reverse SSH tunnel, and to set up the VPC peering between the Cloud SQL private network and the VPC.
        :param pulumi.Input[str] vm: The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param pulumi.Input[str] vm_ip: Required. The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param pulumi.Input[int] vm_port: Required. The forwarding port of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param pulumi.Input[str] vpc: The name of the VPC to peer with the Cloud SQL private network.
        """
        if vm is not None:
            pulumi.set(__self__, "vm", vm)
        if vm_ip is not None:
            pulumi.set(__self__, "vm_ip", vm_ip)
        if vm_port is not None:
            pulumi.set(__self__, "vm_port", vm_port)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vm(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm")

    @vm.setter
    def vm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm", value)

    @property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_ip", value)

    @property
    @pulumi.getter(name="vmPort")
    def vm_port(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The forwarding port of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_port")

    @vm_port.setter
    def vm_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_port", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class SqlAclEntryArgs:
    def __init__(__self__, *,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        An entry for an Access Control list.
        :param pulumi.Input[str] expire_time: The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
        :param pulumi.Input[str] label: A label to identify this entry.
        :param pulumi.Input[str] ttl: Input only. The time-to-leave of this access control entry.
        :param pulumi.Input[str] value: The allowlisted value for the access control list.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label to identify this entry.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The time-to-leave of this access control entry.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SqlIpConfigArgs:
    def __init__(__self__, *,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['SqlAclEntryArgs']]]] = None,
                 enable_ipv4: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        IP Management configuration.
        :param pulumi.Input[Sequence[pulumi.Input['SqlAclEntryArgs']]] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP. See https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as 'slash' notation (e.g. `192.168.100.0/24`).
        :param pulumi.Input[bool] enable_ipv4: Whether the instance should be assigned an IPv4 address or not.
        :param pulumi.Input[str] private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `/projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP should be enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlAclEntryArgs']]]]:
        """
        The list of external networks that are allowed to connect to the instance using the IP. See https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as 'slash' notation (e.g. `192.168.100.0/24`).
        """
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlAclEntryArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `/projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP should be enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class SslConfigArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None):
        """
        SSL configuration information.
        :param pulumi.Input[str] ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate. The replica will use this certificate to verify it's connecting to the right host.
        :param pulumi.Input[str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.If this field is used then the 'client_key' field is mandatory.
        :param pulumi.Input[str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' field is mandatory.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate. The replica will use this certificate to verify it's connecting to the right host.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.If this field is used then the 'client_key' field is mandatory.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' field is mandatory.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)


@pulumi.input_type
class StaticIpConnectivityArgs:
    def __init__(__self__):
        """
        The source database will allow incoming connections from the destination database's public IP. You can retrieve the Cloud SQL instance's public IP from the Cloud SQL console or using Cloud SQL APIs. No additional configuration is required.
        """
        pass


@pulumi.input_type
class VpcPeeringConnectivityArgs:
    def __init__(__self__, *,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        The details of the VPC where the source database is located in Google Cloud. We will use this information to set up the VPC peering connection between Cloud SQL and this VPC.
        :param pulumi.Input[str] vpc: The name of the VPC network to peer with the Cloud SQL private network.
        """
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC network to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


