# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OccurrenceArgs', 'Occurrence']

@pulumi.input_type
class OccurrenceArgs:
    def __init__(__self__, *,
                 occurrences_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 attestation: Optional[pulumi.Input['AttestationArgs']] = None,
                 build_details: Optional[pulumi.Input['BuildDetailsArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deployment: Optional[pulumi.Input['DeploymentArgs']] = None,
                 derived_image: Optional[pulumi.Input['DerivedArgs']] = None,
                 discovered: Optional[pulumi.Input['DiscoveredArgs']] = None,
                 installation: Optional[pulumi.Input['InstallationArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 note_name: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input['ResourceArgs']] = None,
                 resource_url: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input['UpgradeOccurrenceArgs']] = None,
                 vulnerability_details: Optional[pulumi.Input['VulnerabilityDetailsArgs']] = None):
        """
        The set of arguments for constructing a Occurrence resource.
        :param pulumi.Input['AttestationArgs'] attestation: Describes an attestation of an artifact.
        :param pulumi.Input['BuildDetailsArgs'] build_details: Build details for a verifiable build.
        :param pulumi.Input[str] create_time: The time this `Occurrence` was created.
        :param pulumi.Input['DeploymentArgs'] deployment: Describes the deployment of an artifact on a runtime.
        :param pulumi.Input['DerivedArgs'] derived_image: Describes how this resource derives from the basis in the associated note.
        :param pulumi.Input['DiscoveredArgs'] discovered: Describes the initial scan status for this resource.
        :param pulumi.Input['InstallationArgs'] installation: Describes the installation of a package on the linked resource.
        :param pulumi.Input[str] kind: This explicitly denotes which of the `Occurrence` details are specified. This field can be used as a filter in list requests.
        :param pulumi.Input[str] name: The name of the `Occurrence` in the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
        :param pulumi.Input[str] note_name: An analysis note associated with this image, in the form "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a filter in list requests.
        :param pulumi.Input[str] remediation: A description of actions that can be taken to remedy the `Note`
        :param pulumi.Input['ResourceArgs'] resource:  The resource for which the `Occurrence` applies.
        :param pulumi.Input[str] resource_url: The unique URL of the image or the container for which the `Occurrence` applies. For example, https://gcr.io/project/image@sha256:foo This field can be used as a filter in list requests.
        :param pulumi.Input[str] update_time: The time this `Occurrence` was last updated.
        :param pulumi.Input['UpgradeOccurrenceArgs'] upgrade: Describes an upgrade.
        :param pulumi.Input['VulnerabilityDetailsArgs'] vulnerability_details: Details of a security vulnerability note.
        """
        pulumi.set(__self__, "occurrences_id", occurrences_id)
        pulumi.set(__self__, "projects_id", projects_id)
        if attestation is not None:
            pulumi.set(__self__, "attestation", attestation)
        if build_details is not None:
            pulumi.set(__self__, "build_details", build_details)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if derived_image is not None:
            pulumi.set(__self__, "derived_image", derived_image)
        if discovered is not None:
            pulumi.set(__self__, "discovered", discovered)
        if installation is not None:
            pulumi.set(__self__, "installation", installation)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if note_name is not None:
            pulumi.set(__self__, "note_name", note_name)
        if remediation is not None:
            pulumi.set(__self__, "remediation", remediation)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if upgrade is not None:
            pulumi.set(__self__, "upgrade", upgrade)
        if vulnerability_details is not None:
            pulumi.set(__self__, "vulnerability_details", vulnerability_details)

    @property
    @pulumi.getter(name="occurrencesId")
    def occurrences_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "occurrences_id")

    @occurrences_id.setter
    def occurrences_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "occurrences_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter
    def attestation(self) -> Optional[pulumi.Input['AttestationArgs']]:
        """
        Describes an attestation of an artifact.
        """
        return pulumi.get(self, "attestation")

    @attestation.setter
    def attestation(self, value: Optional[pulumi.Input['AttestationArgs']]):
        pulumi.set(self, "attestation", value)

    @property
    @pulumi.getter(name="buildDetails")
    def build_details(self) -> Optional[pulumi.Input['BuildDetailsArgs']]:
        """
        Build details for a verifiable build.
        """
        return pulumi.get(self, "build_details")

    @build_details.setter
    def build_details(self, value: Optional[pulumi.Input['BuildDetailsArgs']]):
        pulumi.set(self, "build_details", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this `Occurrence` was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['DeploymentArgs']]:
        """
        Describes the deployment of an artifact on a runtime.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['DeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="derivedImage")
    def derived_image(self) -> Optional[pulumi.Input['DerivedArgs']]:
        """
        Describes how this resource derives from the basis in the associated note.
        """
        return pulumi.get(self, "derived_image")

    @derived_image.setter
    def derived_image(self, value: Optional[pulumi.Input['DerivedArgs']]):
        pulumi.set(self, "derived_image", value)

    @property
    @pulumi.getter
    def discovered(self) -> Optional[pulumi.Input['DiscoveredArgs']]:
        """
        Describes the initial scan status for this resource.
        """
        return pulumi.get(self, "discovered")

    @discovered.setter
    def discovered(self, value: Optional[pulumi.Input['DiscoveredArgs']]):
        pulumi.set(self, "discovered", value)

    @property
    @pulumi.getter
    def installation(self) -> Optional[pulumi.Input['InstallationArgs']]:
        """
        Describes the installation of a package on the linked resource.
        """
        return pulumi.get(self, "installation")

    @installation.setter
    def installation(self, value: Optional[pulumi.Input['InstallationArgs']]):
        pulumi.set(self, "installation", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This explicitly denotes which of the `Occurrence` details are specified. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the `Occurrence` in the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noteName")
    def note_name(self) -> Optional[pulumi.Input[str]]:
        """
        An analysis note associated with this image, in the form "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "note_name")

    @note_name.setter
    def note_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note_name", value)

    @property
    @pulumi.getter
    def remediation(self) -> Optional[pulumi.Input[str]]:
        """
        A description of actions that can be taken to remedy the `Note`
        """
        return pulumi.get(self, "remediation")

    @remediation.setter
    def remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceArgs']]:
        """
         The resource for which the `Occurrence` applies.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceArgs']]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL of the image or the container for which the `Occurrence` applies. For example, https://gcr.io/project/image@sha256:foo This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_url", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this `Occurrence` was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def upgrade(self) -> Optional[pulumi.Input['UpgradeOccurrenceArgs']]:
        """
        Describes an upgrade.
        """
        return pulumi.get(self, "upgrade")

    @upgrade.setter
    def upgrade(self, value: Optional[pulumi.Input['UpgradeOccurrenceArgs']]):
        pulumi.set(self, "upgrade", value)

    @property
    @pulumi.getter(name="vulnerabilityDetails")
    def vulnerability_details(self) -> Optional[pulumi.Input['VulnerabilityDetailsArgs']]:
        """
        Details of a security vulnerability note.
        """
        return pulumi.get(self, "vulnerability_details")

    @vulnerability_details.setter
    def vulnerability_details(self, value: Optional[pulumi.Input['VulnerabilityDetailsArgs']]):
        pulumi.set(self, "vulnerability_details", value)


class Occurrence(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation: Optional[pulumi.Input[pulumi.InputType['AttestationArgs']]] = None,
                 build_details: Optional[pulumi.Input[pulumi.InputType['BuildDetailsArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['DeploymentArgs']]] = None,
                 derived_image: Optional[pulumi.Input[pulumi.InputType['DerivedArgs']]] = None,
                 discovered: Optional[pulumi.Input[pulumi.InputType['DiscoveredArgs']]] = None,
                 installation: Optional[pulumi.Input[pulumi.InputType['InstallationArgs']]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 note_name: Optional[pulumi.Input[str]] = None,
                 occurrences_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[pulumi.InputType['ResourceArgs']]] = None,
                 resource_url: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']]] = None,
                 vulnerability_details: Optional[pulumi.Input[pulumi.InputType['VulnerabilityDetailsArgs']]] = None,
                 __props__=None):
        """
        Creates a new `Occurrence`. Use this method to create `Occurrences` for a resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AttestationArgs']] attestation: Describes an attestation of an artifact.
        :param pulumi.Input[pulumi.InputType['BuildDetailsArgs']] build_details: Build details for a verifiable build.
        :param pulumi.Input[str] create_time: The time this `Occurrence` was created.
        :param pulumi.Input[pulumi.InputType['DeploymentArgs']] deployment: Describes the deployment of an artifact on a runtime.
        :param pulumi.Input[pulumi.InputType['DerivedArgs']] derived_image: Describes how this resource derives from the basis in the associated note.
        :param pulumi.Input[pulumi.InputType['DiscoveredArgs']] discovered: Describes the initial scan status for this resource.
        :param pulumi.Input[pulumi.InputType['InstallationArgs']] installation: Describes the installation of a package on the linked resource.
        :param pulumi.Input[str] kind: This explicitly denotes which of the `Occurrence` details are specified. This field can be used as a filter in list requests.
        :param pulumi.Input[str] name: The name of the `Occurrence` in the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
        :param pulumi.Input[str] note_name: An analysis note associated with this image, in the form "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a filter in list requests.
        :param pulumi.Input[str] remediation: A description of actions that can be taken to remedy the `Note`
        :param pulumi.Input[pulumi.InputType['ResourceArgs']] resource:  The resource for which the `Occurrence` applies.
        :param pulumi.Input[str] resource_url: The unique URL of the image or the container for which the `Occurrence` applies. For example, https://gcr.io/project/image@sha256:foo This field can be used as a filter in list requests.
        :param pulumi.Input[str] update_time: The time this `Occurrence` was last updated.
        :param pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']] upgrade: Describes an upgrade.
        :param pulumi.Input[pulumi.InputType['VulnerabilityDetailsArgs']] vulnerability_details: Details of a security vulnerability note.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccurrenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new `Occurrence`. Use this method to create `Occurrences` for a resource.

        :param str resource_name: The name of the resource.
        :param OccurrenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccurrenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation: Optional[pulumi.Input[pulumi.InputType['AttestationArgs']]] = None,
                 build_details: Optional[pulumi.Input[pulumi.InputType['BuildDetailsArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['DeploymentArgs']]] = None,
                 derived_image: Optional[pulumi.Input[pulumi.InputType['DerivedArgs']]] = None,
                 discovered: Optional[pulumi.Input[pulumi.InputType['DiscoveredArgs']]] = None,
                 installation: Optional[pulumi.Input[pulumi.InputType['InstallationArgs']]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 note_name: Optional[pulumi.Input[str]] = None,
                 occurrences_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[pulumi.InputType['ResourceArgs']]] = None,
                 resource_url: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 upgrade: Optional[pulumi.Input[pulumi.InputType['UpgradeOccurrenceArgs']]] = None,
                 vulnerability_details: Optional[pulumi.Input[pulumi.InputType['VulnerabilityDetailsArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccurrenceArgs.__new__(OccurrenceArgs)

            __props__.__dict__["attestation"] = attestation
            __props__.__dict__["build_details"] = build_details
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["derived_image"] = derived_image
            __props__.__dict__["discovered"] = discovered
            __props__.__dict__["installation"] = installation
            __props__.__dict__["kind"] = kind
            __props__.__dict__["name"] = name
            __props__.__dict__["note_name"] = note_name
            if occurrences_id is None and not opts.urn:
                raise TypeError("Missing required property 'occurrences_id'")
            __props__.__dict__["occurrences_id"] = occurrences_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            __props__.__dict__["remediation"] = remediation
            __props__.__dict__["resource"] = resource
            __props__.__dict__["resource_url"] = resource_url
            __props__.__dict__["update_time"] = update_time
            __props__.__dict__["upgrade"] = upgrade
            __props__.__dict__["vulnerability_details"] = vulnerability_details
        super(Occurrence, __self__).__init__(
            'gcp-native:containeranalysis/v1alpha1:Occurrence',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Occurrence':
        """
        Get an existing Occurrence resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OccurrenceArgs.__new__(OccurrenceArgs)

        __props__.__dict__["attestation"] = None
        __props__.__dict__["build_details"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["deployment"] = None
        __props__.__dict__["derived_image"] = None
        __props__.__dict__["discovered"] = None
        __props__.__dict__["installation"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["note_name"] = None
        __props__.__dict__["remediation"] = None
        __props__.__dict__["resource"] = None
        __props__.__dict__["resource_url"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["upgrade"] = None
        __props__.__dict__["vulnerability_details"] = None
        return Occurrence(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attestation(self) -> pulumi.Output['outputs.AttestationResponse']:
        """
        Describes an attestation of an artifact.
        """
        return pulumi.get(self, "attestation")

    @property
    @pulumi.getter(name="buildDetails")
    def build_details(self) -> pulumi.Output['outputs.BuildDetailsResponse']:
        """
        Build details for a verifiable build.
        """
        return pulumi.get(self, "build_details")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time this `Occurrence` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output['outputs.DeploymentResponse']:
        """
        Describes the deployment of an artifact on a runtime.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter(name="derivedImage")
    def derived_image(self) -> pulumi.Output['outputs.DerivedResponse']:
        """
        Describes how this resource derives from the basis in the associated note.
        """
        return pulumi.get(self, "derived_image")

    @property
    @pulumi.getter
    def discovered(self) -> pulumi.Output['outputs.DiscoveredResponse']:
        """
        Describes the initial scan status for this resource.
        """
        return pulumi.get(self, "discovered")

    @property
    @pulumi.getter
    def installation(self) -> pulumi.Output['outputs.InstallationResponse']:
        """
        Describes the installation of a package on the linked resource.
        """
        return pulumi.get(self, "installation")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This explicitly denotes which of the `Occurrence` details are specified. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the `Occurrence` in the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noteName")
    def note_name(self) -> pulumi.Output[str]:
        """
        An analysis note associated with this image, in the form "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "note_name")

    @property
    @pulumi.getter
    def remediation(self) -> pulumi.Output[str]:
        """
        A description of actions that can be taken to remedy the `Note`
        """
        return pulumi.get(self, "remediation")

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Output['outputs.ResourceResponse']:
        """
         The resource for which the `Occurrence` applies.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> pulumi.Output[str]:
        """
        The unique URL of the image or the container for which the `Occurrence` applies. For example, https://gcr.io/project/image@sha256:foo This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "resource_url")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time this `Occurrence` was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def upgrade(self) -> pulumi.Output['outputs.UpgradeOccurrenceResponse']:
        """
        Describes an upgrade.
        """
        return pulumi.get(self, "upgrade")

    @property
    @pulumi.getter(name="vulnerabilityDetails")
    def vulnerability_details(self) -> pulumi.Output['outputs.VulnerabilityDetailsResponse']:
        """
        Details of a security vulnerability note.
        """
        return pulumi.get(self, "vulnerability_details")

