# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['AppFirewallIngressRuleArgs', 'AppFirewallIngressRule']

@pulumi.input_type
class AppFirewallIngressRuleArgs:
    def __init__(__self__, *,
                 apps_id: pulumi.Input[str],
                 ingress_rules_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_range: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppFirewallIngressRule resource.
        :param pulumi.Input[str] action: The action to take on matched requests.
        :param pulumi.Input[str] description: An optional string description of this rule. This field has a maximum length of 100 characters.
        :param pulumi.Input[int] priority: A positive integer between 1, Int32.MaxValue-1 that defines the order of rule evaluation. Rules with the lowest priority are evaluated first.A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        :param pulumi.Input[str] source_range: IP address or range, defined using CIDR notation, of requests that this rule applies to. You can use the wildcard character "*" to match all IPs equivalent to "0/0" and "::/0" together. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. Truncation will be silently performed on addresses which are not properly truncated. For example, 1.2.3.4/24 is accepted as the same address as 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 is accepted as the same address as 2001:db8::/32.
        """
        pulumi.set(__self__, "apps_id", apps_id)
        pulumi.set(__self__, "ingress_rules_id", ingress_rules_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_range is not None:
            pulumi.set(__self__, "source_range", source_range)

    @property
    @pulumi.getter(name="appsId")
    def apps_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "apps_id")

    @apps_id.setter
    def apps_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apps_id", value)

    @property
    @pulumi.getter(name="ingressRulesId")
    def ingress_rules_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ingress_rules_id")

    @ingress_rules_id.setter
    def ingress_rules_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ingress_rules_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take on matched requests.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional string description of this rule. This field has a maximum length of 100 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        A positive integer between 1, Int32.MaxValue-1 that defines the order of rule evaluation. Rules with the lowest priority are evaluated first.A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceRange")
    def source_range(self) -> Optional[pulumi.Input[str]]:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. You can use the wildcard character "*" to match all IPs equivalent to "0/0" and "::/0" together. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. Truncation will be silently performed on addresses which are not properly truncated. For example, 1.2.3.4/24 is accepted as the same address as 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 is accepted as the same address as 2001:db8::/32.
        """
        return pulumi.get(self, "source_range")

    @source_range.setter
    def source_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_range", value)


class AppFirewallIngressRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingress_rules_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_range: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a firewall rule for the application.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The action to take on matched requests.
        :param pulumi.Input[str] description: An optional string description of this rule. This field has a maximum length of 100 characters.
        :param pulumi.Input[int] priority: A positive integer between 1, Int32.MaxValue-1 that defines the order of rule evaluation. Rules with the lowest priority are evaluated first.A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        :param pulumi.Input[str] source_range: IP address or range, defined using CIDR notation, of requests that this rule applies to. You can use the wildcard character "*" to match all IPs equivalent to "0/0" and "::/0" together. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. Truncation will be silently performed on addresses which are not properly truncated. For example, 1.2.3.4/24 is accepted as the same address as 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 is accepted as the same address as 2001:db8::/32.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppFirewallIngressRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a firewall rule for the application.

        :param str resource_name: The name of the resource.
        :param AppFirewallIngressRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppFirewallIngressRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingress_rules_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_range: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppFirewallIngressRuleArgs.__new__(AppFirewallIngressRuleArgs)

            __props__.__dict__["action"] = action
            if apps_id is None and not opts.urn:
                raise TypeError("Missing required property 'apps_id'")
            __props__.__dict__["apps_id"] = apps_id
            __props__.__dict__["description"] = description
            if ingress_rules_id is None and not opts.urn:
                raise TypeError("Missing required property 'ingress_rules_id'")
            __props__.__dict__["ingress_rules_id"] = ingress_rules_id
            __props__.__dict__["priority"] = priority
            __props__.__dict__["source_range"] = source_range
        super(AppFirewallIngressRule, __self__).__init__(
            'gcp-native:appengine/v1:AppFirewallIngressRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AppFirewallIngressRule':
        """
        Get an existing AppFirewallIngressRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AppFirewallIngressRuleArgs.__new__(AppFirewallIngressRuleArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["priority"] = None
        __props__.__dict__["source_range"] = None
        return AppFirewallIngressRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The action to take on matched requests.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional string description of this rule. This field has a maximum length of 100 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        A positive integer between 1, Int32.MaxValue-1 that defines the order of rule evaluation. Rules with the lowest priority are evaluated first.A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceRange")
    def source_range(self) -> pulumi.Output[str]:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. You can use the wildcard character "*" to match all IPs equivalent to "0/0" and "::/0" together. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. Truncation will be silently performed on addresses which are not properly truncated. For example, 1.2.3.4/24 is accepted as the same address as 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 is accepted as the same address as 2001:db8::/32.
        """
        return pulumi.get(self, "source_range")

