"""Monitor Admin console."""

from loguru import logger

import tf2mon
from tf2mon.player import Player
from tf2mon.regex import Regex


class Admin:
    """Monitor Admin console."""

    regex_list = [
        # stop single-stepping
        Regex("^(c|cont|continue)$", lambda m: tf2mon.SingleStepControl.stop_single_stepping()),
        # stop single-stepping until eof, then single-step again
        Regex("^(r|run|g|go)$", lambda m: tf2mon.SingleStepControl.set_single_step_lineno(0)),
        # dump internals
        Regex("^dump$", lambda m: tf2mon.dump()),
        # pause when logfile reaches `lineno`.
        Regex(
            R"^(b|break|breakpoint)[= ](?P<lineno>\d+)$",
            lambda m: tf2mon.SingleStepControl.set_single_step_lineno(int(m.group("lineno"))),
        ),
        # pause when logfile reaches next line that matches `pattern`.
        Regex(
            "^/(?P<pattern>.*)$",
            lambda m: tf2mon.SingleStepControl.set_single_step_pattern(m.group("pattern")),
        ),
        # kick cheater
        Regex(
            R"^kick[= ](?P<userid>\d+)$",
            lambda m: tf2mon.users.kick_userid(int(m.group("userid")), Player.CHEATER),
        ),
        # kick racist
        Regex(
            R"^kkk[= ](?P<userid>\d+)$",
            lambda m: tf2mon.users.kick_userid(int(m.group("userid")), Player.RACIST),
        ),
        # mark suspect
        Regex(
            R"^suspect[= ](?P<userid>\d+)$",
            lambda m: tf2mon.users.kick_userid(int(m.group("userid")), Player.SUSPECT),
        ),
        # drop to python debugger
        Regex("^PDB$", lambda m: tf2mon.debugger()),
        # deprecated, legacy, support old conlogs.
        Regex(
            "^(TOGGLE-SCOREBOARD|TOGGLE-QUEUES|CHATS-POP|CHATS-POPLEFT|CHATS-CLEAR)$",
            lambda m: logger.debug("ignore"),
        ),
        # The following aren't commands, but other items that may be in
        # the conlog. They don't belong in `gameplay` because they're
        # not generated by tf2.
        # qvalve
        Regex("^(QVALVE) (.*)", lambda m: logger.log(m.group(1), m.group(2))),
    ]
