import pathlib

import pkg_resources
import setuptools
import os

with open("README.md", "r") as fh:
    long_description = fh.read()

with pathlib.Path("requirements.txt").open() as requirements_txt:
    install_requires = [
        str(requirement)
        for requirement in pkg_resources.parse_requirements(requirements_txt)
    ]


setuptools.setup(
    name="sheet2csv",
    version=os.getenv("PACKAGE_VERSION", "1.0.2"),
    author="",
    author_email="",
    description="A package to export Google Sheet to CSV via API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/sledilnik/sheet2csv/",
    packages=setuptools.find_packages(exclude=("tests",)),
    install_requires=install_requires,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)
