# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer"></a>

```typescript
import { PDKNagApp } from '@aws-prototyping-sdk/pdk-nag'

new PDKNagApp(props?: PDKNagAppProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps">PDKNagAppProps</a></code> | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps">PDKNagAppProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult">addNagResult</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults">nagResults</a></code> | Returns a list of NagResult. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth"></a>

```typescript
public synth(options?: StageSynthesisOptions): CloudAssembly
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth.parameter.options"></a>

- *Type:* aws-cdk-lib.StageSynthesisOptions

---

##### `addNagResult` <a name="addNagResult" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult"></a>

```typescript
public addNagResult(result: NagResult): void
```

###### `result`<sup>Required</sup> <a name="result" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult.parameter.result"></a>

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.NagResult">NagResult</a>

---

##### `nagResults` <a name="nagResults" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults"></a>

```typescript
public nagResults(): NagResult[]
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage">isStage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp">isApp</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct"></a>

```typescript
import { PDKNagApp } from '@aws-prototyping-sdk/pdk-nag'

PDKNagApp.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isStage` <a name="isStage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage"></a>

```typescript
import { PDKNagApp } from '@aws-prototyping-sdk/pdk-nag'

PDKNagApp.isStage(x: any)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* any

---

##### `of` <a name="of" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of"></a>

```typescript
import { PDKNagApp } from '@aws-prototyping-sdk/pdk-nag'

PDKNagApp.of(construct: IConstruct)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isApp` <a name="isApp" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp"></a>

```typescript
import { PDKNagApp } from '@aws-prototyping-sdk/pdk-nag'

PDKNagApp.isApp(obj: any)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* any

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId">artifactId</a></code> | <code>string</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir">assetOutdir</a></code> | <code>string</code> | The cloud assembly asset output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir">outdir</a></code> | <code>string</code> | The cloud assembly output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.policyValidationBeta1">policyValidationBeta1</a></code> | <code>aws-cdk-lib.IPolicyValidationPluginBeta1[]</code> | Validation plugins to run during synthesis. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName">stageName</a></code> | <code>string</code> | The name of the stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account">account</a></code> | <code>string</code> | The default account for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage">parentStage</a></code> | <code>aws-cdk-lib.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region">region</a></code> | <code>string</code> | The default region for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks">nagPacks</a></code> | <code>cdk-nag.NagPack[]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `assetOutdir`<sup>Required</sup> <a name="assetOutdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir"></a>

```typescript
public readonly assetOutdir: string;
```

- *Type:* string

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string

The cloud assembly output directory.

---

##### `policyValidationBeta1`<sup>Required</sup> <a name="policyValidationBeta1" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.policyValidationBeta1"></a>

```typescript
public readonly policyValidationBeta1: IPolicyValidationPluginBeta1[];
```

- *Type:* aws-cdk-lib.IPolicyValidationPluginBeta1[]
- *Default:* no validation plugins are used

Validation plugins to run during synthesis.

If any plugin reports any violation,
synthesis will be interrupted and the report displayed to the user.

---

##### `stageName`<sup>Required</sup> <a name="stageName" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName"></a>

```typescript
public readonly stageName: string;
```

- *Type:* string

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string

The default account for all resources defined within this stage.

---

##### `parentStage`<sup>Optional</sup> <a name="parentStage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage"></a>

```typescript
public readonly parentStage: Stage;
```

- *Type:* aws-cdk-lib.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

The default region for all resources defined within this stage.

---

##### `nagPacks`<sup>Required</sup> <a name="nagPacks" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks"></a>

```typescript
public readonly nagPacks: NagPack[];
```

- *Type:* cdk-nag.NagPack[]

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="@aws-prototyping-sdk/pdk-nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.Message.Initializer"></a>

```typescript
import { Message } from '@aws-prototyping-sdk/pdk-nag'

const message: Message = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription">messageDescription</a></code> | <code>string</code> | Message description. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageType">messageType</a></code> | <code>string</code> | Message type as returned from cdk-nag. |

---

##### `messageDescription`<sup>Required</sup> <a name="messageDescription" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription"></a>

```typescript
public readonly messageDescription: string;
```

- *Type:* string

Message description.

---

##### `messageType`<sup>Required</sup> <a name="messageType" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageType"></a>

```typescript
public readonly messageType: string;
```

- *Type:* string

Message type as returned from cdk-nag.

---

### NagResult <a name="NagResult" id="@aws-prototyping-sdk/pdk-nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.NagResult.Initializer"></a>

```typescript
import { NagResult } from '@aws-prototyping-sdk/pdk-nag'

const nagResult: NagResult = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.messages">messages</a></code> | <code><a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>[]</code> | List of messages. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.resource">resource</a></code> | <code>string</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.messages"></a>

```typescript
public readonly messages: Message[];
```

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>[]

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.resource"></a>

```typescript
public readonly resource: string;
```

- *Type:* string

Resource which triggered the message.

---

### PDKNagAppProps <a name="PDKNagAppProps" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.Initializer"></a>

```typescript
import { PDKNagAppProps } from '@aws-prototyping-sdk/pdk-nag'

const pDKNagAppProps: PDKNagAppProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting">analyticsReporting</a></code> | <code>boolean</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth">autoSynth</a></code> | <code>boolean</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context">context</a></code> | <code>{[ key: string ]: any}</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer">defaultStackSynthesizer</a></code> | <code>aws-cdk-lib.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>string</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.policyValidationBeta1">policyValidationBeta1</a></code> | <code>aws-cdk-lib.IPolicyValidationPluginBeta1[]</code> | Validation plugins to run after synthesis. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext">postCliContext</a></code> | <code>{[ key: string ]: any}</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces">stackTraces</a></code> | <code>boolean</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata">treeMetadata</a></code> | <code>boolean</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError">failOnError</a></code> | <code>boolean</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning">failOnWarning</a></code> | <code>boolean</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks">nagPacks</a></code> | <code>cdk-nag.NagPack[]</code> | Custom nag packs to execute. |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting"></a>

```typescript
public readonly analyticsReporting: boolean;
```

- *Type:* boolean
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `autoSynth`<sup>Optional</sup> <a name="autoSynth" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth"></a>

```typescript
public readonly autoSynth: boolean;
```

- *Type:* boolean
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context"></a>

```typescript
public readonly context: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `defaultStackSynthesizer`<sup>Optional</sup> <a name="defaultStackSynthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```typescript
public readonly defaultStackSynthesizer: IReusableStackSynthesizer;
```

- *Type:* aws-cdk-lib.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir"></a>

```typescript
public readonly outdir: string;
```

- *Type:* string
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `policyValidationBeta1`<sup>Optional</sup> <a name="policyValidationBeta1" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.policyValidationBeta1"></a>

```typescript
public readonly policyValidationBeta1: IPolicyValidationPluginBeta1[];
```

- *Type:* aws-cdk-lib.IPolicyValidationPluginBeta1[]
- *Default:* no validation plugins

Validation plugins to run after synthesis.

---

##### `postCliContext`<sup>Optional</sup> <a name="postCliContext" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext"></a>

```typescript
public readonly postCliContext: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```typescript
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stackTraces`<sup>Optional</sup> <a name="stackTraces" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces"></a>

```typescript
public readonly stackTraces: boolean;
```

- *Type:* boolean
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `treeMetadata`<sup>Optional</sup> <a name="treeMetadata" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata"></a>

```typescript
public readonly treeMetadata: boolean;
```

- *Type:* boolean
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `failOnError`<sup>Optional</sup> <a name="failOnError" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError"></a>

```typescript
public readonly failOnError: boolean;
```

- *Type:* boolean
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `failOnWarning`<sup>Optional</sup> <a name="failOnWarning" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning"></a>

```typescript
public readonly failOnWarning: boolean;
```

- *Type:* boolean
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nagPacks`<sup>Optional</sup> <a name="nagPacks" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks"></a>

```typescript
public readonly nagPacks: NagPack[];
```

- *Type:* cdk-nag.NagPack[]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer"></a>

```typescript
import { AwsPrototypingChecks } from '@aws-prototyping-sdk/pdk-nag'

new AwsPrototypingChecks(props?: NagPackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.props">props</a></code> | <code>cdk-nag.NagPackProps</code> | *No description.* |

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.props"></a>

- *Type:* cdk-nag.NagPackProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit"></a>

```typescript
public visit(node: IConstruct): void
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName">readPackName</a></code> | <code>string</code> | *No description.* |

---

##### `readPackName`<sup>Required</sup> <a name="readPackName" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName"></a>

```typescript
public readonly readPackName: string;
```

- *Type:* string

---


### PDKNag <a name="PDKNag" id="@aws-prototyping-sdk/pdk-nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNag.Initializer"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

new PDKNag()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow">addResourceSuppressionsByPathNoThrow</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex">getStackAccountRegex</a></code> | Returns a stack account regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex">getStackPartitionRegex</a></code> | Returns a stack partition regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix">getStackPrefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex">getStackRegionRegex</a></code> | Returns a stack region regex. |

---

##### `addResourceSuppressionsByPathNoThrow` <a name="addResourceSuppressionsByPathNoThrow" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.addResourceSuppressionsByPathNoThrow(stack: Stack, path: string, suppressions: NagPackSuppression[], applyToChildren?: boolean)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* string

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* cdk-nag.NagPackSuppression[]

list of suppressions to apply.

---

###### `applyToChildren`<sup>Optional</sup> <a name="applyToChildren" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* boolean

whether to apply to children.

---

##### `app` <a name="app" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.app(props?: PDKNagAppProps)
```

Returns an instance of an App with Nag enabled.

###### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps">PDKNagAppProps</a>

props to initialize the app with.

---

##### `getStackAccountRegex` <a name="getStackAccountRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.getStackAccountRegex(stack: Stack)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackPartitionRegex` <a name="getStackPartitionRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.getStackPartitionRegex(stack: Stack)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackPrefix` <a name="getStackPrefix" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.getStackPrefix(stack: Stack)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---

##### `getStackRegionRegex` <a name="getStackRegionRegex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex"></a>

```typescript
import { PDKNag } from '@aws-prototyping-sdk/pdk-nag'

PDKNag.getStackRegionRegex(stack: Stack)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* aws-cdk-lib.Stack

stack instance.

---




