# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_train.ipynb.

# %% auto 0
__all__ = ['train_tree_models']

# %% ../nbs/01_train.ipynb 3
from typing import List
import pandas as pd
from sklearn.pipeline import Pipeline
from sklearn.metrics import roc_auc_score
from feature_engine.imputation import ArbitraryNumberImputer
from feature_engine.imputation import CategoricalImputer
from feature_engine.encoding import OneHotEncoder
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import RandomForestClassifier

def train_tree_models(df_train: pd.DataFrame, # train dataset
                      df_test: pd.DataFrame,  # test dataset
                      target: str,            # target variable
                      folds: int,             # cross-validation number of folds
                      cat_features: List,     # categorical features
                      num_features: List,     # numeric features
                      seed: int):             # seed
    
    features = cat_features + num_features
    X_train, y_train = df_train[features], df_train[target]
    X_test, y_test = df_test[features], df_test[target]

    base_pipe = Pipeline(steps=[
        ('numeric_imputer', ArbitraryNumberImputer(variables=num_features)),
        ('categoric_imputer', CategoricalImputer(variables=cat_features)),
        ('one_hot_encoder', OneHotEncoder(variables=cat_features))
    ])

    dt = Pipeline(steps=base_pipe.steps + [('dt', DecisionTreeClassifier(max_depth=5, random_state=seed))])
    rf = Pipeline(steps=base_pipe.steps + [('rf', RandomForestClassifier(n_estimators=300, max_depth=5, random_state=seed))])
    models = [dt, rf]

    metrics = {}
    for model in models:
        model.fit(X_train, y_train)
        y_prob_train = model.predict_proba(X_train)[:,1]
        y_prob_test = model.predict_proba(X_test)[:,1]

        metrics[model.steps[-1][0]] = {
            'auc': {
                'train': roc_auc_score(y_train, y_prob_train),
                'test': roc_auc_score(y_test, y_prob_test)
            }
        }

    return metrics    
