# coding: utf-8

"""
    LogicMonitor API-Ingest Rest API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. API-Ingest provides the entry point in the form of public rest APIs for ingesting metrics into LogicMonitor. For using this application users have to create LMAuth token using access id and key from santaba.  # noqa: E501

    OpenAPI spec version: 3.0.0

"""

import pprint
import re  # noqa: F401

import six

from logicmonitor_data_sdk.models.map_string_string import \
  MapStringString  # noqa: F401,E501


class PushMetricAPIResponse(object):
  """NOTE: This class is auto generated by the swagger code generator program.

  Do not edit the class manually.
  """

  """
  Attributes:
    swagger_types (dict): The key is attribute name
                          and the value is attribute type.
    attribute_map (dict): The key is attribute name
                          and the value is json key in definition.
  """
  swagger_types = {
    'message': 'str',
    'resource_ids': 'MapStringString',
    'timestamp': 'int'
  }

  attribute_map = {
    'message': 'message',
    'resource_ids': 'resourceIds',
    'timestamp': 'timestamp'
  }

  def __init__(self, message=None, resource_ids=None,
      timestamp=None):  # noqa: E501
    """PushMetricAPIResponse - a model defined in Swagger"""  # noqa: E501

    self._message = None
    self._resource_ids = None
    self._timestamp = None
    self.discriminator = None

    if message is not None:
      self.message = message
    if resource_ids is not None:
      self.resource_ids = resource_ids
    if timestamp is not None:
      self.timestamp = timestamp

  @property
  def message(self):
    """Gets the message of this PushMetricAPIResponse.  # noqa: E501


    :return: The message of this PushMetricAPIResponse.  # noqa: E501
    :rtype: str
    """
    return self._message

  @message.setter
  def message(self, message):
    """Sets the message of this PushMetricAPIResponse.


    :param message: The message of this PushMetricAPIResponse.  # noqa: E501
    :type: str
    """

    self._message = message

  @property
  def resource_ids(self):
    """Gets the resource_ids of this PushMetricAPIResponse.  # noqa: E501


    :return: The resource_ids of this PushMetricAPIResponse.  # noqa: E501
    :rtype: MapStringString
    """
    return self._resource_ids

  @resource_ids.setter
  def resource_ids(self, resource_ids):
    """Sets the resource_ids of this PushMetricAPIResponse.


    :param resource_ids: The resource_ids of this PushMetricAPIResponse.  # noqa: E501
    :type: MapStringString
    """

    self._resource_ids = resource_ids

  @property
  def timestamp(self):
    """Gets the timestamp of this PushMetricAPIResponse.  # noqa: E501


    :return: The timestamp of this PushMetricAPIResponse.  # noqa: E501
    :rtype: int
    """
    return self._timestamp

  @timestamp.setter
  def timestamp(self, timestamp):
    """Sets the timestamp of this PushMetricAPIResponse.


    :param timestamp: The timestamp of this PushMetricAPIResponse.  # noqa: E501
    :type: int
    """

    self._timestamp = timestamp

  def to_dict(self):
    """Returns the model properties as a dict"""
    result = {}

    for attr, _ in six.iteritems(self.swagger_types):
      value = getattr(self, attr)
      if isinstance(value, list):
        result[attr] = list(map(
            lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
            value
        ))
      elif hasattr(value, "to_dict"):
        result[attr] = value.to_dict()
      elif isinstance(value, dict):
        result[attr] = dict(map(
            lambda item: (item[0], item[1].to_dict())
            if hasattr(item[1], "to_dict") else item,
            value.items()
        ))
      else:
        result[attr] = value
    if issubclass(PushMetricAPIResponse, dict):
      for key, value in self.items():
        result[key] = value

    return result

  def to_str(self):
    """Returns the string representation of the model"""
    return pprint.pformat(self.to_dict())

  def __repr__(self):
    """For `print` and `pprint`"""
    return self.to_str()

  def __eq__(self, other):
    """Returns true if both objects are equal"""
    if not isinstance(other, PushMetricAPIResponse):
      return False

    return self.__dict__ == other.__dict__

  def __ne__(self, other):
    """Returns true if both objects are not equal"""
    return not self == other
