# Copyright 2016-2018 Euratom
# Copyright 2016-2018 United Kingdom Atomic Energy Authority
# Copyright 2016-2018 Centro de Investigaciones Energéticas, Medioambientales y Tecnológicas
#
# Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the
# European Commission - subsequent versions of the EUPL (the "Licence");
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# https://joinup.ec.europa.eu/software/page/eupl5
#
# Unless required by applicable law or agreed to in writing, software distributed
# under the Licence is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR
# CONDITIONS OF ANY KIND, either express or implied.
#
# See the Licence for the specific language governing permissions and limitations
# under the Licence.

import numpy as np

# linearly interpolated data sampled on self.xsamples, self.ysamples
# and self.zsamples
# calculated from successive linear interpolations on each dimension.
linear_interpolated_data = np.array([
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.040875493463e+00, -9.055945797664e-01, -7.703136660693e-01, -6.350327523722e-01, -5.022092691790e-01, -3.718432164897e-01, -2.414771638004e-01, -1.111111111111e-01,  1.115170569206e-02,  1.334145224952e-01,  2.556773392984e-01,  3.712601674181e-01,  4.801630068543e-01,  5.890658462905e-01,  6.979686857268e-01],
        [-1.081750986927e+00, -9.540463023899e-01, -8.263416178529e-01, -6.986369333158e-01, -5.758471097865e-01, -4.579721472651e-01, -3.400971847437e-01, -2.222222222222e-01, -1.205537314730e-01, -1.888524072383e-02,  8.278325002537e-02,  1.710917634076e-01,  2.460402994229e-01,  3.209888354382e-01,  3.959373714535e-01],
        [-1.183939720586e+00, -1.075175608949e+00, -9.664114973118e-01, -8.576473856748e-01, -7.599417113054e-01, -6.732944742036e-01, -5.866472371018e-01, -5.000000000000e-01, -4.498173243857e-01, -3.996346487715e-01, -3.494519731572e-01, -3.293292466186e-01, -3.392664691555e-01, -3.492036916925e-01, -3.591409142295e-01],
        [-1.306566200976e+00, -1.220530776819e+00, -1.134495352662e+00, -1.048459928506e+00, -9.808552331281e-01, -9.316812665298e-01, -8.825072999316e-01, -8.333333333333e-01, -8.449336358810e-01, -8.565339384286e-01, -8.681342409763e-01, -9.298344586500e-01, -1.041634591450e+00, -1.153434724249e+00, -1.265234857049e+00],
        [-1.470068174830e+00, -1.414337667313e+00, -1.358607159797e+00, -1.302876652280e+00, -1.275406595558e+00, -1.276196989631e+00, -1.276987383705e+00, -1.277777777778e+00, -1.371755384541e+00, -1.465732991305e+00, -1.559710598068e+00, -1.730508074692e+00, -1.978125421175e+00, -2.225742767659e+00, -2.473360114142e+00],
        [-1.674445642148e+00, -1.656596280431e+00, -1.638746918715e+00, -1.620897556998e+00, -1.643595798596e+00, -1.706841643508e+00, -1.770087488421e+00, -1.833333333333e+00, -2.030282570367e+00, -2.227231807400e+00, -2.424181044434e+00, -2.731350094744e+00, -3.148738958332e+00, -3.566127821920e+00, -3.983516685508e+00],
        [-1.899260856197e+00, -1.923080754861e+00, -1.946900653524e+00, -1.970720552188e+00, -2.048603921938e+00, -2.180550762773e+00, -2.312497603609e+00, -2.444444444444e+00, -2.754662474775e+00, -3.064880505105e+00, -3.375098535435e+00, -3.832276316802e+00, -4.436413849205e+00, -5.040551381608e+00, -5.644688914011e+00],
        [-2.185389310441e+00, -2.262242813225e+00, -2.339096316009e+00, -2.415949818793e+00, -2.564068806190e+00, -2.783453278201e+00, -3.002837750212e+00, -3.222222222222e+00, -3.676600534930e+00, -4.130978847638e+00, -4.585357160346e+00, -5.233455144875e+00, -6.075272801225e+00, -6.917090457574e+00, -7.758908113924e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.023665924308e+00, -8.851952353046e-01, -7.467245463015e-01, -6.082538572984e-01, -4.712059612544e-01, -3.355808581694e-01, -1.999557550843e-01, -6.433065199933e-02,  6.660287305496e-02,  1.975363981093e-01,  3.284699231635e-01,  4.555358959716e-01,  5.787343165335e-01,  7.019327370954e-01,  8.251311576573e-01],
        [-1.047331848615e+00, -9.132476134664e-01, -7.791633783173e-01, -6.450791431683e-01, -5.138404939373e-01, -3.854474306245e-01, -2.570543673116e-01, -1.286613039987e-01, -9.651396747216e-03,  1.093585105042e-01,  2.283684177557e-01,  3.396432205147e-01,  4.431829187813e-01,  5.467226170480e-01,  6.502623153146e-01],
        [-1.110382745293e+00, -9.879849266610e-01, -8.655871080294e-01, -7.431892893979e-01, -6.274276701710e-01, -5.183022503487e-01, -4.091768305264e-01, -3.000514107042e-01, -2.128084771120e-01, -1.255655435198e-01, -3.832260992765e-02,  3.088126341285e-02,  8.204607650167e-02,  1.332108895905e-01,  1.843757026793e-01],
        [-1.186561966093e+00, -1.078283884867e+00, -9.700058036403e-01, -8.617277224140e-01, -7.646657275882e-01, -6.788198191627e-01, -5.929739107372e-01, -5.071280023118e-01, -4.582664943310e-01, -4.094049863502e-01, -3.605434783695e-01, -3.421704542373e-01, -3.542859139538e-01, -3.664013736703e-01, -3.785168333868e-01],
        [-1.288997835139e+00, -1.199706133094e+00, -1.110414431049e+00, -1.021122729003e+00, -9.492055473725e-01, -8.946628861561e-01, -8.401202249398e-01, -7.855775637235e-01, -7.883263852584e-01, -7.910752067933e-01, -7.938240283282e-01, -8.438016929841e-01, -9.410082007610e-01, -1.038214708538e+00, -1.135421216315e+00],
        [-1.417690352432e+00, -1.352251671343e+00, -1.286812990255e+00, -1.221374309166e+00, -1.181047129524e+00, -1.165831451329e+00, -1.150615773134e+00, -1.135400094939e+00, -1.202988149894e+00, -1.270576204849e+00, -1.338164259804e+00, -1.474012452828e+00, -1.678120783920e+00, -1.882229115012e+00, -2.086337446104e+00],
        [-1.559511193848e+00, -1.520358854604e+00, -1.481206515359e+00, -1.442054176115e+00, -1.436539592859e+00, -1.464662765592e+00, -1.492785938324e+00, -1.520909111057e+00, -1.659950851384e+00, -1.798992591711e+00, -1.938034332038e+00, -2.168512973219e+00, -2.490428515254e+00, -2.812344057290e+00, -3.134259599325e+00],
        [-1.740717007634e+00, -1.735150972897e+00, -1.729584938160e+00, -1.724018903423e+00, -1.762984699745e+00, -1.846482327123e+00, -1.929979954502e+00, -2.013477581881e+00, -2.243816363437e+00, -2.474155144992e+00, -2.704493926548e+00, -3.055882775256e+00, -3.528321691116e+00, -4.000760606977e+00, -4.473199522838e+00],
        [-1.921922821419e+00, -1.949943091190e+00, -1.977963360961e+00, -2.005983630732e+00, -2.089429806630e+00, -2.228301888655e+00, -2.367173970680e+00, -2.506046052705e+00, -2.827681875489e+00, -3.149317698273e+00, -3.470953521057e+00, -3.943252577293e+00, -4.566214866979e+00, -5.189177156665e+00, -5.812139446351e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.006141122158e+00, -8.644222297495e-01, -7.227033373409e-01, -5.809844449323e-01, -4.396347561624e-01, -2.986542710312e-01, -1.576737858999e-01, -1.669330076868e-02,  1.230697565779e-01,  2.628328139246e-01,  4.025958712712e-01,  5.413553290758e-01,  6.791111873384e-01,  8.168670456009e-01,  9.546229038635e-01],
        [-1.012282244316e+00, -8.717016023561e-01, -7.311209603961e-01, -5.905403184360e-01, -4.506980837533e-01, -3.115942563480e-01, -1.724904289427e-01, -3.338660153735e-02,  1.032823702987e-01,  2.399513421348e-01,  3.766203139709e-01,  5.112820867230e-01,  6.439366603910e-01,  7.765912340590e-01,  9.092458077270e-01],
        [-1.027232224485e+00, -8.894225454203e-01, -7.516128663551e-01, -6.138031872900e-01, -4.776307067874e-01, -3.430954248473e-01, -2.085601429072e-01, -7.402486096706e-02,  5.511185278438e-02,  1.842485665358e-01,  3.133852802873e-01,  4.380716269367e-01,  5.583076064841e-01,  6.785435860316e-01,  7.987795655790e-01],
        [-1.045118490658e+00, -9.106240119702e-01, -7.761295332822e-01, -6.416350545941e-01, -5.098530949692e-01, -3.807836544074e-01, -2.517142138456e-01, -1.226447732838e-01, -2.519708475042e-03,  1.176053563337e-01,  2.377304211425e-01,  3.504820946726e-01,  4.558603769241e-01,  5.612386591757e-01,  6.666169414272e-01],
        [-1.068877328839e+00, -9.387865254918e-01, -8.086957221451e-01, -6.786049187984e-01, -5.526550134464e-01, -4.308460060891e-01, -3.090369987318e-01, -1.872279913745e-01, -7.907335722457e-02,  2.908127692540e-02,  1.372359110754e-01,  2.341344174528e-01,  3.197767960578e-01,  4.054191746628e-01,  4.910615532677e-01],
        [-1.098508739026e+00, -9.739100859851e-01, -8.493114329440e-01, -7.247127799029e-01, -6.060364622190e-01, -4.932824798925e-01, -3.805284975659e-01, -2.677745152393e-01, -1.745490934642e-01, -8.132367168911e-02,  1.190175008599e-02,  8.902859527740e-02,  1.500568638851e-01,  2.110851324928e-01,  2.721134011006e-01],
        [-1.131076435218e+00, -1.012514169964e+00, -8.939519047108e-01, -7.753896394574e-01, -6.647076761394e-01, -5.619060147566e-01, -4.591043533738e-01, -3.563026919911e-01, -2.794858734489e-01, -2.026690549067e-01, -1.258522363645e-01, -7.045629937585e-02, -3.648124394070e-02, -2.506188505557e-03,  3.146886692959e-02],
        [-1.172452989420e+00, -1.061559824401e+00, -9.506666593815e-01, -8.397734943623e-01, -7.392481855028e-01, -6.490907328032e-01, -5.589332801035e-01, -4.687758274039e-01, -4.128057846688e-01, -3.568357419336e-01, -3.008656991984e-01, -2.730784114626e-01, -2.734738787260e-01, -2.738693459895e-01, -2.742648132529e-01],
        [-1.213829543622e+00, -1.110605478837e+00, -1.007381414052e+00, -9.041573492671e-01, -8.137886948663e-01, -7.362754508497e-01, -6.587622068332e-01, -5.812489628167e-01, -5.461256958886e-01, -5.110024289605e-01, -4.758791620324e-01, -4.757005235493e-01, -5.104665135113e-01, -5.452325034733e-01, -5.799984934354e-01]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.882222787662e-01, -8.431821478277e-01, -6.981420168892e-01, -5.531018859507e-01, -4.073536796111e-01, -2.608973978706e-01, -1.144411161300e-01,  3.201516561057e-02,  1.808062853010e-01,  3.295974049915e-01,  4.783885246819e-01,  6.291043928682e-01,  7.817450095502e-01,  9.343856262323e-01,  1.087026242914e+00],
        [-9.764445575323e-01, -8.292214385125e-01, -6.819983194926e-01, -5.347752004728e-01, -3.861359306508e-01, -2.360805100268e-01, -8.602508940285e-02,  6.403033122114e-02,  2.187554277449e-01,  3.734805242686e-01,  5.282056207924e-01,  6.867802143077e-01,  8.492043048147e-01,  1.011628395322e+00,  1.174052485829e+00],
        [-9.320897717856e-01, -7.766455404882e-01, -6.212013091909e-01, -4.657570778935e-01, -3.062300905925e-01, -1.426203472878e-01,  2.098939601696e-02,  1.845991393217e-01,  3.616715359591e-01,  5.387439325965e-01,  7.158163292339e-01,  9.039868073261e-01,  1.103255366873e+00,  1.302523926420e+00,  1.501792485967e+00],
        [-8.768759645346e-01, -7.111979128943e-01, -5.455198612541e-01, -3.798418096138e-01, -2.067615535014e-01, -2.627909291690e-02,  1.542033676677e-01,  3.346858282522e-01,  5.395766327634e-01,  7.444674372745e-01,  9.493582417857e-01,  1.174370324204e+00,  1.419503684530e+00,  1.664637044855e+00,  1.909770405181e+00],
        [-7.999441142749e-01, -6.200068261611e-01, -4.400695380472e-01, -2.601322499333e-01, -6.816762234504e-02,  1.358243447175e-01,  3.398163117801e-01,  5.438082788427e-01,  7.874597067479e-01,  1.031111134653e+00,  1.274762562558e+00,  1.551107688801e+00,  1.860146513382e+00,  2.169185337963e+00,  2.478224162544e+00],
        [-7.012942210067e-01, -5.030722802884e-01, -3.048503395701e-01, -1.066283988518e-01,  1.095517028767e-01,  3.436899656156e-01,  5.778282283544e-01,  8.119664910932e-01,  1.105320757913e+00,  1.398675024732e+00,  1.692029291551e+00,  2.034198901118e+00,  2.425183853430e+00,  2.816168805743e+00,  3.207153758056e+00],
        [-5.917853062341e-01, -3.732660048461e-01, -1.547467034580e-01,  6.377259793006e-02,  3.068337251312e-01,  5.744366781454e-01,  8.420396311595e-01,  1.109642584174e+00,  1.458170797667e+00,  1.806699011161e+00,  2.155227224655e+00,  2.570467037294e+00,  3.052418449077e+00,  3.534369860860e+00,  4.016321272644e+00],
        [-4.496993269487e-01, -2.048445406947e-01,  4.001024555929e-02,  2.848650318133e-01,  5.628038384837e-01,  8.738266655705e-01,  1.184849492657e+00,  1.495872319744e+00,  1.915987803193e+00,  2.336103286641e+00,  2.756218770089e+00,  3.266265945048e+00,  3.866244811517e+00,  4.466223677986e+00,  5.066202544455e+00],
        [-3.076133476632e-01, -3.642307654332e-02,  2.347671945766e-01,  5.059574656965e-01,  8.187739518362e-01,  1.173216652996e+00,  1.527659354155e+00,  1.882102055315e+00,  2.373804808718e+00,  2.865507562121e+00,  3.357210315524e+00,  3.962064852803e+00,  4.680071173958e+00,  5.398077495112e+00,  6.116083816267e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.864560013358e-01, -8.410884927576e-01, -6.957209841794e-01, -5.503534756011e-01, -4.041717032027e-01, -2.571756669839e-01, -1.101796307652e-01,  3.681640545351e-02,  1.864974298331e-01,  3.361784542126e-01,  4.858594785921e-01,  6.377539015179e-01,  7.918617229897e-01,  9.459695444616e-01,  1.100077365933e+00],
        [-9.729120026716e-01, -8.250341283723e-01, -6.771562540730e-01, -5.292783797737e-01, -3.797719778339e-01, -2.286370482536e-01, -7.750211867329e-02,  7.363281090702e-02,  2.301377168090e-01,  3.866426227109e-01,  5.431475286129e-01,  7.040792316071e-01,  8.694377316937e-01,  1.034796231780e+00,  1.200154731867e+00],
        [-9.090415815469e-01, -7.493253927470e-01, -5.896092039471e-01, -4.298930151471e-01, -2.647084154938e-01, -9.405540498707e-02,  7.659760551966e-02,  2.472506160264e-01,  4.359353971150e-01,  6.246201782035e-01,  8.133049592921e-01,  1.016854422234e+00,  1.235268567029e+00,  1.453682711825e+00,  1.672096856620e+00],
        [-8.283956862687e-01, -6.537318667083e-01, -4.790680471479e-01, -3.044042275875e-01, -1.194235741632e-01,  7.587391312486e-02,  2.711714004129e-01,  4.664688877010e-01,  6.957855418643e-01,  9.251021960276e-01,  1.154418850191e+00,  1.411779566373e+00,  1.697184344575e+00,  1.982589122777e+00,  2.267993900979e+00],
        [-7.141988426834e-01, -5.183687598428e-01, -3.225386770023e-01, -1.267085941617e-01,  8.630382514824e-02,  3.164985809276e-01,  5.466933367069e-01,  7.768880924862e-01,  1.063740615500e+00,  1.350593138515e+00,  1.637445661529e+00,  1.971004617538e+00,  2.351270006543e+00,  2.731535395547e+00,  3.111800784552e+00],
        [-5.664510507911e-01, -3.432360721507e-01, -1.200210935103e-01,  1.031938851302e-01,  3.524737824406e-01,  6.278185984211e-01,  9.031634144016e-01,  1.178508230382e+00,  1.539800618023e+00,  1.901093005664e+00,  2.262385393305e+00,  2.694529575728e+00,  3.197525552931e+00,  3.700521530134e+00,  4.203517507337e+00],
        [-4.019277847453e-01, -1.482185940452e-01,  1.054905966550e-01,  3.591997873551e-01,  6.488650187234e-01,  9.744862907600e-01,  1.300107562797e+00,  1.625728834833e+00,  2.069913084989e+00,  2.514097335146e+00,  2.958281585302e+00,  3.500204487430e+00,  4.139866041529e+00,  4.779527595629e+00,  5.419189149729e+00],
        [-1.870780962389e-01,  1.064532553004e-01,  3.999846068398e-01,  6.935159583792e-01,  1.035920091978e+00,  1.427197007635e+00,  1.818473923293e+00,  2.209750838950e+00,  2.762182945286e+00,  3.314615051621e+00,  3.867047157957e+00,  4.552329259669e+00,  5.370461356760e+00,  6.188593453850e+00,  7.006725550940e+00],
        [ 2.777159226742e-02,  3.611251046461e-01,  6.944786170247e-01,  1.027832129403e+00,  1.422975165232e+00,  1.879907724510e+00,  2.336840283789e+00,  2.793772843067e+00,  3.454452805582e+00,  4.115132768097e+00,  4.775812730611e+00,  5.604454031909e+00,  6.601056671990e+00,  7.597659312071e+00,  8.594261952151e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.892330408356e-01, -8.443802535696e-01, -6.995274663037e-01, -5.546746790378e-01, -4.091745832835e-01, -2.630271790408e-01, -1.168797747982e-01,  2.926762944446e-02,  1.775494962341e-01,  3.258313630237e-01,  4.741132298132e-01,  6.241546635042e-01,  7.759556640964e-01,  9.277566646887e-01,  1.079557665281e+00],
        [-9.784660816711e-01, -8.316176499964e-01, -6.847692183217e-01, -5.379207866470e-01, -3.897777379956e-01, -2.403400723674e-01, -9.090240673925e-02,  5.853525888892e-02,  2.122418496110e-01,  3.659484403330e-01,  5.196550310551e-01,  6.768807555798e-01,  8.376256139072e-01,  9.983704722345e-01,  1.159115330562e+00],
        [-9.169288529992e-01, -7.586745615589e-01, -6.004202701187e-01, -4.421659786784e-01, -2.789174583411e-01, -1.106747091069e-01,  5.756804012736e-02,  2.258107893616e-01,  4.105217214223e-01,  5.952326534830e-01,  7.799435855437e-01,  9.782302392623e-01,  1.190092614639e+00,  1.401954990015e+00,  1.613817365392e+00],
        [-8.384682011580e-01, -6.656713115000e-01, -4.928744218419e-01, -3.200775321838e-01, -1.375693672312e-01,  5.465007301599e-02,  2.468695132632e-01,  4.390889535104e-01,  6.633307660452e-01,  8.875725785799e-01,  1.111814391115e+00,  1.362454186814e+00,  1.639491965677e+00,  1.916529744541e+00,  2.193567523404e+00],
        [-7.261607029786e-01, -5.325477381982e-01, -3.389347734178e-01, -1.453218086374e-01,  6.475434678973e-02,  2.912936928636e-01,  5.178330389375e-01,  7.443723850113e-01,  1.025198156291e+00,  1.306023927571e+00,  1.586849698850e+00,  1.912427062103e+00,  2.282756017330e+00,  2.653084972556e+00,  3.023413927783e+00],
        [-5.800063584608e-01, -3.593038416535e-01, -1.386013248463e-01,  8.210119196093e-02,  3.280536837217e-01,  5.992561504359e-01,  8.704586171502e-01,  1.141661083864e+00,  1.496123892160e+00,  1.850586700455e+00,  2.205049508750e+00,  2.628148865131e+00,  3.119884769596e+00,  3.611620674062e+00,  4.103356578528e+00],
        [-4.169285907738e-01, -1.659997834875e-01,  8.492902379887e-02,  3.358578310852e-01,  6.218408321091e-01,  9.428780268706e-01,  1.263915221632e+00,  1.584952416394e+00,  2.021578800840e+00,  2.458205185286e+00,  2.894831569733e+00,  3.426745132027e+00,  4.053945872170e+00,  4.681146612312e+00,  5.308347352455e+00],
        [-2.030805535793e-01,  8.748475954290e-02,  3.780500726651e-01,  6.686153857873e-01,  1.007091414863e+00,  1.393478159892e+00,  1.779864904922e+00,  2.166251649951e+00,  2.710621227955e+00,  3.254990805958e+00,  3.799360383962e+00,  4.473964790530e+00,  5.278804025664e+00,  6.083643260798e+00,  6.888482495931e+00],
        [ 1.076748361520e-02,  3.409693025733e-01,  6.711711215313e-01,  1.001372940489e+00,  1.392341997617e+00,  1.844078292914e+00,  2.295814588211e+00,  2.747550883508e+00,  3.399663655069e+00,  4.051776426630e+00,  4.703889198191e+00,  5.521184449034e+00,  6.503662179158e+00,  7.486139909283e+00,  8.468617639408e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.970585727051e-01, -8.536562394330e-01, -7.102539061608e-01, -5.668515728887e-01, -4.232724013072e-01, -2.795163914163e-01, -1.357603815254e-01,  7.995628365492e-03,  1.523347524207e-01,  2.966738764760e-01,  4.410130005312e-01,  5.858328209494e-01,  7.311333377306e-01,  8.764338545118e-01,  1.021734371293e+00],
        [-9.941171454102e-01, -8.501696217231e-01, -7.062220980360e-01, -5.622745743489e-01, -4.179733740430e-01, -2.733184971183e-01, -1.286636201937e-01,  1.599125673098e-02,  1.618123619843e-01,  3.076334672376e-01,  4.534545724909e-01,  6.002370704702e-01,  7.479809611755e-01,  8.957248518808e-01,  1.043468742586e+00],
        [-9.686634822180e-01, -8.199981491795e-01, -6.713328161410e-01, -5.226674831025e-01, -3.721182018065e-01, -2.196849722530e-01, -6.725174269955e-02,  8.518148685390e-02,  2.438269275373e-01,  4.024723682208e-01,  5.611178089042e-01,  7.248843519016e-01,  8.937719972131e-01,  1.062659642525e+00,  1.231547287836e+00],
        [-9.357057403935e-01, -7.809317250247e-01, -6.261577096560e-01, -4.713836942872e-01, -3.127443145792e-01, -1.502395705319e-01,  1.226517351536e-02,  1.747699175626e-01,  3.500204784202e-01,  5.252710392777e-01,  7.005216001353e-01,  8.862793106366e-01,  1.082544170782e+00,  1.278809030927e+00,  1.475073891072e+00],
        [-8.877398413041e-01, -7.240753976475e-01, -5.604109539908e-01, -3.967465103342e-01, -2.263329973703e-01, -4.917041509924e-02,  1.279921671719e-01,  3.051547494430e-01,  5.045719999626e-01,  7.039892504823e-01,  9.034065010020e-01,  1.121169623979e+00,  1.357278619412e+00,  1.593387614845e+00,  1.829496610279e+00],
        [-8.247657849499e-01, -6.494291670478e-01, -4.740925491457e-01, -2.987559312435e-01, -1.128842501800e-01,  8.352249404499e-02,  2.799292382700e-01,  4.763359824949e-01,  7.074814921648e-01,  9.386270018346e-01,  1.169772511504e+00,  1.429555291928e+00,  1.717975343104e+00,  2.006395394281e+00,  2.294815445457e+00],
        [-7.542876499633e-01, -5.658879848369e-01, -3.774883197104e-01, -1.890886545840e-01,  1.408321200115e-02,  2.320272800450e-01,  4.499713480889e-01,  6.679154161327e-01,  9.345699696967e-01,  1.201224523261e+00,  1.467879076825e+00,  1.774688637180e+00,  2.121653204327e+00,  2.468617771474e+00,  2.815582338621e+00],
        [-6.612972790795e-01, -4.556619477923e-01, -2.500266165051e-01, -4.439128521790e-02,  1.816068191546e-01,  4.279676966124e-01,  6.743285740701e-01,  9.206894515279e-01,  1.234195403218e+00,  1.547701354908e+00,  1.861207306598e+00,  2.230065014343e+00,  2.654274478143e+00,  3.078483941943e+00,  3.502693405742e+00],
        [-5.683069081956e-01, -3.454359107477e-01, -1.225649132997e-01,  1.003060841482e-01,  3.491304263080e-01,  6.239081131797e-01,  8.986858000514e-01,  1.173463486923e+00,  1.533820836739e+00,  1.894178186556e+00,  2.254535536372e+00,  2.685441391506e+00,  3.186895751959e+00,  3.688350112411e+00,  4.189804472863e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.977030179212e-01, -8.544201318832e-01, -7.111372458453e-01, -5.678543598073e-01, -4.244333794407e-01, -2.808743047454e-01, -1.373152300502e-01,  6.243844645030e-03,  1.502582774542e-01,  2.942727102634e-01,  4.382871430726e-01,  5.826769551859e-01,  7.274421466034e-01,  8.722073380209e-01,  1.016972529438e+00],
        [-9.954060358424e-01, -8.516974066236e-01, -7.079887774048e-01, -5.642801481860e-01, -4.202953303099e-01, -2.760343237766e-01, -1.317733172433e-01,  1.248768929006e-02,  1.576594120513e-01,  3.028311348126e-01,  4.480028575738e-01,  5.939253389433e-01,  7.405985789211e-01,  8.872718188988e-01,  1.033945058877e+00],
        [-1.007885638954e+00, -8.664900908752e-01, -7.250945427960e-01, -5.836989947168e-01, -4.427775304484e-01, -3.023301499908e-01, -1.618827695332e-01, -2.143538907557e-02,  1.174487272561e-01,  2.563328435878e-01,  3.952169599195e-01,  5.328123828432e-01,  6.691191123587e-01,  8.054258418743e-01,  9.417325713899e-01],
        [-1.025290770463e+00, -8.871212449638e-01, -7.489517194644e-01, -6.107821939649e-01, -4.741331470099e-01, -3.390045785993e-01, -2.038760101887e-01, -6.874744177809e-02,  6.136743599686e-02,  1.914823137718e-01,  3.215971915468e-01,  4.475789801239e-01,  5.694276795031e-01,  6.912763788823e-01,  8.131250782616e-01],
        [-1.052546958766e+00, -9.194293387266e-01, -7.863117186872e-01, -6.531940986478e-01, -5.232355964176e-01, -3.964362119965e-01, -2.696368275755e-01, -1.428374431544e-01, -2.645506819058e-02,  8.992730677322e-02,  2.063096817370e-01,  3.141046841662e-01,  4.133123140608e-01,  5.125199439553e-01,  6.117275738499e-01],
        [-1.089654203863e+00, -9.634143721635e-01, -8.371745404644e-01, -7.109347087654e-01, -5.900848786713e-01, -4.746250501824e-01, -3.591652216934e-01, -2.437053932045e-01, -1.460187853062e-01, -4.833217740793e-02,  4.935443049033e-02,  1.323894949702e-01,  2.007730160318e-01,  2.691565370933e-01,  3.375400581548e-01],
        [-1.131686977356e+00, -1.013237875437e+00, -8.947887735188e-01, -7.763396716003e-01, -6.658075773482e-01, -5.631924907626e-01, -4.605774041770e-01, -3.579623175914e-01, -2.814531088859e-01, -2.049439001804e-01, -1.284346914749e-01, -7.344614084492e-02, -3.997824829056e-02, -6.510355736210e-03,  2.695753681815e-02],
        [-1.188496336040e+00, -1.080576788223e+00, -9.726572404049e-01, -8.647376925873e-01, -7.681505252942e-01, -6.828957385258e-01, -5.976409517574e-01, -5.123861649890e-01, -4.644992518579e-01, -4.166123387267e-01, -3.687254255955e-01, -3.516431165176e-01, -3.653654114929e-01, -3.790877064682e-01, -3.928100014436e-01],
        [-1.245305694724e+00, -1.147915701008e+00, -1.050525707291e+00, -9.531357135742e-01, -8.704934732403e-01, -8.025989862891e-01, -7.347044993379e-01, -6.668100123867e-01, -6.475453948298e-01, -6.282807772730e-01, -6.090161597161e-01, -6.298400921902e-01, -6.907525746952e-01, -7.516650572002e-01, -8.125775397052e-01]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.952878855481e-01, -8.515573572981e-01, -7.078268290481e-01, -5.640963007982e-01, -4.200824807073e-01, -2.757853687754e-01, -1.314882568436e-01,  1.280885508822e-02,  1.580401055879e-01,  3.032713560877e-01,  4.485026065874e-01,  5.945039241505e-01,  7.412753087769e-01,  8.880466934033e-01,  1.034818078030e+00],
        [-9.905757710962e-01, -8.459718574534e-01, -7.013679438106e-01, -5.567640301678e-01, -4.115935328431e-01, -2.658564518366e-01, -1.201193708301e-01,  2.561771017644e-02,  1.732230683188e-01,  3.208284264611e-01,  4.684337846034e-01,  6.175792768724e-01,  7.682649032680e-01,  9.189505296637e-01,  1.069636156059e+00],
        [-1.033231510680e+00, -8.965337929190e-01, -7.598360751578e-01, -6.231383573966e-01, -4.884385146729e-01, -3.557365469868e-01, -2.230345793006e-01, -9.033261161437e-02,  3.578147793073e-02,  1.618955674758e-01,  2.880096570209e-01,  4.086929591560e-01,  5.239454738812e-01,  6.391979886063e-01,  7.544505033314e-01],
        [-1.091676534943e+00, -9.658115401548e-01, -8.399465453667e-01, -7.140815505786e-01, -5.937281397341e-01, -4.788863128333e-01, -3.640444859324e-01, -2.492026590315e-01, -1.525349634969e-01, -5.586726796228e-02,  4.080042757235e-02,  1.224860846270e-01,  1.891897032016e-01,  2.558933217763e-01,  3.225969403509e-01],
        [-1.181700128563e+00, -1.072520910931e+00, -9.633416932988e-01, -8.541624756668e-01, -7.559070512580e-01, -6.685754200724e-01, -5.812437888869e-01, -4.939121577014e-01, -4.426011070038e-01, -3.912900563061e-01, -3.399790056085e-01, -3.183619035275e-01, -3.264387500633e-01, -3.345155965990e-01, -3.425924431347e-01],
        [-1.303302291540e+00, -1.216661905247e+00, -1.130021518954e+00, -1.043381132661e+00, -9.749752492445e-01, -9.248038687043e-01, -8.746324881641e-01, -8.244611076239e-01, -8.344169525898e-01, -8.443727975557e-01, -8.543286425216e-01, -9.138510053076e-01, -1.022939885914e+00, -1.132028766519e+00, -1.241117647125e+00],
        [-1.440693739196e+00, -1.379518711334e+00, -1.318343683471e+00, -1.257168655609e+00, -1.222488090462e+00, -1.214301988032e+00, -1.206115885603e+00, -1.197929783173e+00, -1.277107649216e+00, -1.356285515258e+00, -1.435463381301e+00, -1.586660663900e+00, -1.809877363056e+00, -2.033094062213e+00, -2.256310761369e+00],
        [-1.625453040888e+00, -1.598522952731e+00, -1.571592864573e+00, -1.544662776415e+00, -1.555334861374e+00, -1.603609119450e+00, -1.651883377525e+00, -1.700157635601e+00, -1.872422898960e+00, -2.044688162319e+00, -2.216953425679e+00, -2.491431992931e+00, -2.868123864077e+00, -3.244815735223e+00, -3.621507606369e+00],
        [-1.810212342580e+00, -1.817527194127e+00, -1.824842045675e+00, -1.832156897222e+00, -1.888181632286e+00, -1.992916250867e+00, -2.097650869448e+00, -2.202385488029e+00, -2.467738148705e+00, -2.733090809380e+00, -2.998443470056e+00, -3.396203321962e+00, -3.926370365098e+00, -4.456537408234e+00, -4.986704451370e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.893453182659e-01, -8.445133415021e-01, -6.996813647383e-01, -5.548493879744e-01, -4.093768528299e-01, -2.632637593047e-01, -1.171506657795e-01,  2.896242774569e-02,  1.771877257256e-01,  3.254130237055e-01,  4.736383216855e-01,  6.236048378717e-01,  7.753125722642e-01,  9.270203066567e-01,  1.078728041049e+00],
        [-9.786906365319e-01, -8.318838258614e-01, -6.850770151908e-01, -5.382702045203e-01, -3.901822770884e-01, -2.408132328951e-01, -9.144418870188e-02,  5.792485549139e-02,  2.115183085941e-01,  3.651117616968e-01,  5.187052147995e-01,  6.757811043148e-01,  8.363394302427e-01,  9.968977561705e-01,  1.157456082098e+00],
        [-1.022522857352e+00, -8.838403021062e-01, -7.451577468608e-01, -6.064751916154e-01, -4.691467082600e-01, -3.331722967947e-01, -1.971978853294e-01, -6.122347386405e-02,  7.028596334687e-02,  2.017954005578e-01,  3.333048377687e-01,  4.611335259665e-01,  5.852814651511e-01,  7.094294043356e-01,  8.335773435202e-01],
        [-1.084517379023e+00, -9.573254423130e-01, -8.301335056033e-01, -7.029415688935e-01, -5.808308084026e-01, -4.638012241306e-01, -3.467716398586e-01, -2.297420555865e-01, -1.294673579389e-01, -2.919266029131e-02,  7.108203735630e-02,  1.575446660210e-01,  2.301952257028e-01,  3.028457853845e-01,  3.754963450663e-01],
        [-1.182836502396e+00, -1.073867910444e+00, -9.648993184906e-01, -8.559307265378e-01, -7.579542464873e-01, -6.709698783392e-01, -5.839855101912e-01, -4.970011420431e-01, -4.462626313019e-01, -3.955241205606e-01, -3.447856098193e-01, -3.239267571188e-01, -3.329475624589e-01, -3.419683677990e-01, -3.509891731392e-01],
        [-1.317480227473e+00, -1.233467706498e+00, -1.149455185523e+00, -1.065442664548e+00, -1.000517022514e+00, -9.546782594206e-01, -9.088394963272e-01, -8.630007332338e-01, -8.800998567419e-01, -8.971989802501e-01, -9.142981037582e-01, -9.832807434529e-01, -1.104146899334e+00, -1.225013055215e+00, -1.345879211096e+00],
        [-1.470286253400e+00, -1.414596166514e+00, -1.358906079628e+00, -1.303215992742e+00, -1.275799467512e+00, -1.276656503938e+00, -1.277513540365e+00, -1.278370576791e+00, -1.372458058221e+00, -1.466545539650e+00, -1.560633021079e+00, -1.731576011384e+00, -1.979374510566e+00, -2.227173009747e+00, -2.474971508929e+00],
        [-1.677579181881e+00, -1.660310618416e+00, -1.643042054950e+00, -1.625773491484e+00, -1.649240919423e+00, -1.713444338765e+00, -1.777647758108e+00, -1.841851177450e+00, -2.040379187815e+00, -2.238907198179e+00, -2.437435208544e+00, -2.746695124107e+00, -3.166686944868e+00, -3.586678765628e+00, -4.006670586389e+00],
        [-1.884872110363e+00, -1.906025070317e+00, -1.927178030272e+00, -1.948330990227e+00, -2.022682371334e+00, -2.150232173592e+00, -2.277781975851e+00, -2.405331778109e+00, -2.708300317409e+00, -3.011268856709e+00, -3.314237396009e+00, -3.761814236829e+00, -4.353999379169e+00, -4.946184521509e+00, -5.538369663849e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.920387746669e-01, -8.477060271771e-01, -7.033732796873e-01, -5.590405321974e-01, -4.142291566514e-01, -2.689391530492e-01, -1.236491494470e-01,  2.164085415515e-02,  1.685091062713e-01,  3.153773583875e-01,  4.622456105036e-01,  6.104149085675e-01,  7.598852525791e-01,  9.093555965907e-01,  1.058825940602e+00],
        [-9.840775493339e-01, -8.382691972113e-01, -6.924608450888e-01, -5.466524929663e-01, -3.998868847314e-01, -2.521640203842e-01, -1.044411560369e-01,  4.328170831031e-02,  1.941610696855e-01,  3.450404310607e-01,  4.959197924359e-01,  6.494012457065e-01,  8.054847908725e-01,  9.615683360385e-01,  1.117651881205e+00],
        [-1.010608185252e+00, -8.697172582280e-01, -7.288263312041e-01, -5.879354041802e-01, -4.476822401732e-01, -3.080668391831e-01, -1.684514381931e-01, -2.883603720301e-02,  1.086763768838e-01,  2.461887909705e-01,  3.837012050573e-01,  5.194799995243e-01,  6.535251743717e-01,  7.875703492190e-01,  9.216155240663e-01],
        [-1.048636108254e+00, -9.147936162387e-01, -7.809511242239e-01, -6.471086322091e-01, -5.161901380689e-01, -3.881956418034e-01, -2.602011455380e-01, -1.322066492725e-01, -1.385386798994e-02,  1.044989132926e-01,  2.228516945752e-01,  3.332562255685e-01,  4.357125062727e-01,  5.381687869769e-01,  6.406250676811e-01],
        [-1.109658605423e+00, -9.871265682377e-01, -8.645945310528e-01, -7.420624938679e-01, -6.261231208725e-01, -5.167764120664e-01, -4.074297032604e-01, -2.980829944543e-01, -2.104752170076e-01, -1.228674395609e-01, -3.525966211415e-02,  3.442739606535e-02,  8.619373497764e-02,  1.379600738899e-01,  1.897264128022e-01],
        [-1.193675676759e+00, -1.086716114225e+00, -9.797565516909e-01, -8.727969891568e-01, -7.774811885839e-01, -6.938091499720e-01, -6.101371113602e-01, -5.264650727484e-01, -4.811876701692e-01, -4.359102675899e-01, -3.906328650106e-01, -3.770064889852e-01, -3.950311395136e-01, -4.130557900420e-01, -4.310804405704e-01],
        [-1.289190035179e+00, -1.199933957206e+00, -1.110677879233e+00, -1.021421801261e+00, -9.495517987492e-01, -8.950678716990e-01, -8.405839446489e-01, -7.861000175987e-01, -7.889456754027e-01, -7.917913332067e-01, -7.946369910107e-01, -8.447429018095e-01, -9.421090656029e-01, -1.039475229396e+00, -1.136841393190e+00],
        [-1.419196254850e+00, -1.354036691170e+00, -1.288877127490e+00, -1.223717563810e+00, -1.183760036276e+00, -1.169004544890e+00, -1.154249053504e+00, -1.139493562117e+00, -1.207840336852e+00, -1.276187111587e+00, -1.344533886322e+00, -1.481386897955e+00, -1.686746146487e+00, -1.892105395018e+00, -2.097464643550e+00],
        [-1.549202474521e+00, -1.508139425134e+00, -1.467076375746e+00, -1.426013326358e+00, -1.417968273803e+00, -1.442941218081e+00, -1.467914162359e+00, -1.492887106636e+00, -1.626734998302e+00, -1.760582889967e+00, -1.894430781632e+00, -2.118030894100e+00, -2.431383227370e+00, -2.744735560640e+00, -3.058087893910e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000347197391e+00, -8.575544072005e-01, -7.147616170099e-01, -5.719688268193e-01, -4.291969101004e-01, -2.864458668534e-01, -1.436948236064e-01, -9.437803593130e-04,  1.417384338138e-01,  2.844206479870e-01,  4.271028621602e-01,  5.697283363542e-01,  7.122970705692e-01,  8.548658047842e-01,  9.974345389992e-01],
        [-1.000694394782e+00, -8.579659572582e-01, -7.152375197341e-01, -5.725090822100e-01, -4.298223916294e-01, -2.871774479925e-01, -1.445325043556e-01, -1.887560718626e-03,  1.406197247705e-01,  2.831270102597e-01,  4.256342957489e-01,  5.680281012799e-01,  7.103084268527e-01,  8.525887524256e-01,  9.948690779984e-01],
        [-1.001610389042e+00, -8.590517300779e-01, -7.164930711138e-01, -5.739344121498e-01, -4.314725696109e-01, -2.891075434971e-01, -1.467425173834e-01, -4.377491269716e-03,  1.376682882449e-01,  2.797140677594e-01,  4.217598472740e-01,  5.635424524593e-01,  7.050618833153e-01,  8.465813141713e-01,  9.881007450273e-01],
        [-1.002715982258e+00, -8.603622438183e-01, -7.180085053788e-01, -5.756547669392e-01, -4.334643130764e-01, -2.914371437903e-01, -1.494099745042e-01, -7.382805218065e-03,  1.341059425584e-01,  2.755946903349e-01,  4.170834381113e-01,  5.581283323900e-01,  6.987293731709e-01,  8.393304139518e-01,  9.799314547327e-01],
        [-1.004200773386e+00, -8.621222394001e-01, -7.200437054141e-01, -5.779651714281e-01, -4.361391875102e-01, -2.945657536604e-01, -1.529923198107e-01, -1.141888596093e-02,  1.293217785503e-01,  2.700624430616e-01,  4.108031075729e-01,  5.508572698232e-01,  6.902249298125e-01,  8.295925898018e-01,  9.689602497912e-01],
        [-1.006064762427e+00, -8.643317168232e-01, -7.225986712198e-01, -5.808656256163e-01, -4.394971929123e-01, -2.984933731076e-01, -1.574895533030e-01, -1.648573349832e-02,  1.233157962207e-01,  2.631173259397e-01,  4.029188556587e-01,  5.417292647589e-01,  6.795485532401e-01,  8.173678417214e-01,  9.551871302027e-01],
        [-1.008118350423e+00, -8.667659351670e-01, -7.254135199106e-01, -5.840611046542e-01, -4.431967637985e-01, -3.028204973433e-01, -1.624442308881e-01, -2.206796443296e-02,  1.166989047303e-01,  2.554657738935e-01,  3.942326430567e-01,  5.316727884458e-01,  6.677862100608e-01,  8.038996316758e-01,  9.400130532908e-01],
        [-1.010740735289e+00, -8.698743762728e-01, -7.290080172570e-01, -5.881416582412e-01, -4.479210311371e-01, -3.083461359445e-01, -1.687712407519e-01, -2.919634555938e-02,  1.082492857574e-01,  2.456949170743e-01,  3.831405483911e-01,  5.188308983865e-01,  6.527659670605e-01,  7.867010357345e-01,  9.206361044085e-01],
        [-1.013363120154e+00, -8.729828173787e-01, -7.326025146034e-01, -5.922222118282e-01, -4.526452984756e-01, -3.138717745457e-01, -1.750982506158e-01, -3.632472668580e-02,  9.979966678464e-02,  2.359240602551e-01,  3.720484537255e-01,  5.059890083272e-01,  6.377457240602e-01,  7.695024397932e-01,  9.012591555262e-01]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.019031255969e+00, -8.797015361276e-01, -7.403718162862e-01, -6.010420964448e-01, -4.628565337740e-01, -3.258151282737e-01, -1.887737227735e-01, -5.173231727317e-02,  8.153629569891e-02,  2.148049086710e-01,  3.480735216431e-01,  4.782319929696e-01,  6.052803226505e-01,  7.323286523314e-01,  8.593769820123e-01],
        [-1.038062511938e+00, -9.022602151123e-01, -7.664579182867e-01, -6.306556214611e-01, -4.971416389766e-01, -3.659159708332e-01, -2.346903026898e-01, -1.034646345463e-01,  2.021544854068e-02,  1.438955316277e-01,  2.675756147147e-01,  3.850354145106e-01,  4.962749310152e-01,  6.075144475199e-01,  7.187539640245e-01],
        [-1.020771675038e+00, -8.817645400161e-01, -7.427574049946e-01, -6.037502699732e-01, -4.659919259394e-01, -3.294823728933e-01, -1.929728198473e-01, -5.646326680117e-02,  7.592846971679e-02,  2.083202062347e-01,  3.407119427527e-01,  4.697091134213e-01,  5.953117182405e-01,  7.209143230597e-01,  8.465169278789e-01],
        [-9.913734738474e-01, -8.469174135595e-01, -7.024613532717e-01, -5.580052929838e-01, -4.130306068223e-01, -2.675372947870e-01, -1.220439827518e-01,  2.344932928344e-02,  1.706527803377e-01,  3.178562313919e-01,  4.650596824461e-01,  6.136729047886e-01,  7.636958984193e-01,  9.137188920500e-01,  1.063741885681e+00],
        [-9.377605440776e-01, -7.833673843823e-01, -6.289742246870e-01, -4.745810649917e-01, -3.164460755453e-01, -1.545692563479e-01,  7.307562849534e-03,  1.691843820469e-01,  3.433996698481e-01,  5.176149576493e-01,  6.918302454505e-01,  8.762168810691e-01,  1.070774864505e+00,  1.265332847941e+00,  1.459890831377e+00],
        [-8.599328857283e-01, -6.911144524845e-01, -5.222960192406e-01, -3.534775859967e-01, -1.762383321084e-01,  9.421742424155e-03,  1.950818169567e-01,  3.807418914893e-01,  5.941691382481e-01,  8.075963850069e-01,  1.021023631766e+00,  1.257341042263e+00,  1.516548616498e+00,  1.775756190733e+00,  2.034963764969e+00],
        [-7.699978630893e-01, -5.845100692263e-01, -3.990222753633e-01, -2.135344815003e-01, -1.421898259166e-02,  1.989242213626e-01,  4.120674253169e-01,  6.252106292712e-01,  8.839498960929e-01,  1.142689162915e+00,  1.401428429736e+00,  1.697755295913e+00,  2.031669761444e+00,  2.365584226976e+00,  2.699498692507e+00],
        [-6.437407475809e-01, -4.348513318871e-01, -2.259619161934e-01, -1.707250049969e-02,  2.132351851649e-01,  4.649611408004e-01,  7.166870964359e-01,  9.684130520714e-01,  1.290764522272e+00,  1.613115992473e+00,  1.935467462673e+00,  2.316039826933e+00,  2.754833085251e+00,  3.193626343570e+00,  3.632419601888e+00],
        [-5.174836320724e-01, -2.851925945480e-01, -5.290155702354e-02,  1.793894805009e-01,  4.406893529215e-01,  7.309980602382e-01,  1.021306767555e+00,  1.311615474872e+00,  1.697579148451e+00,  2.083542822031e+00,  2.469506495610e+00,  2.934324357953e+00,  3.477996409058e+00,  4.021668460164e+00,  4.565340511269e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.029821775146e+00, -8.924920665365e-01, -7.551623579271e-01, -6.178326493178e-01, -4.822958227929e-01, -3.485518783524e-01, -2.148079339119e-01, -8.106398947149e-02,  4.676802931195e-02,  1.746000480954e-01,  3.024320668788e-01,  4.253905268715e-01,  5.434754280734e-01,  6.615603292753e-01,  7.796452304773e-01],
        [-1.059643550292e+00, -9.278412759302e-01, -7.960390015686e-01, -6.642367272070e-01, -5.360202170143e-01, -4.113894709905e-01, -2.867587249667e-01, -1.621279789430e-01, -4.932108423325e-02,  6.348581047648e-02,  1.762927051862e-01,  2.793524823144e-01,  3.726651418611e-01,  4.659778014078e-01,  5.592904609545e-01],
        [-1.037201513595e+00, -9.012396316445e-01, -7.652777496935e-01, -6.293158677425e-01, -4.955905370000e-01, -3.641017574659e-01, -2.326129779317e-01, -1.011241983976e-01,  2.298968203579e-02,  1.471035624692e-01,  2.712174429026e-01,  3.892517468278e-01,  5.012064742446e-01,  6.131612016614e-01,  7.251159290782e-01],
        [-9.973382062850e-01, -8.539877027989e-01, -7.106371993129e-01, -5.672866958268e-01, -4.237761655737e-01, -2.801056085536e-01, -1.364350515335e-01,  7.235505486680e-03,  1.514337415762e-01,  2.956319776658e-01,  4.398302137554e-01,  5.844634476979e-01,  7.295316794933e-01,  8.745999112887e-01,  1.019668143084e+00],
        [-9.226323577463e-01, -7.654352048338e-01, -6.082380519213e-01, -4.510408990087e-01, -2.891924113237e-01, -1.226925888662e-01,  4.380723359136e-02,  2.103070560489e-01,  3.921443876595e-01,  5.739817192702e-01,  7.558190508808e-01,  9.503000212816e-01,  1.157424630473e+00,  1.364549239663e+00,  1.571673848854e+00],
        [-8.130839679795e-01, -6.355821377491e-01, -4.580803075186e-01, -2.805784772882e-01, -9.183927424981e-02,  1.081373015965e-01,  3.081138774427e-01,  5.080904532890e-01,  7.451216202856e-01,  9.821527872823e-01,  1.219183954279e+00,  1.486761467579e+00,  1.784885327182e+00,  2.083009186786e+00,  2.381133046389e+00],
        [-6.861143075986e-01, -4.850787861045e-01, -2.840432646105e-01, -8.300774311639e-02,  1.368985542360e-01,  3.756756274467e-01,  6.144527006574e-01,  8.532297738680e-01,  1.154232146183e+00,  1.455234518498e+00,  1.756236890813e+00,  2.108535350233e+00,  2.512129896757e+00,  2.915724443281e+00,  3.319318989806e+00],
        [-5.068808353754e-01, -2.726245807806e-01, -3.836832618578e-02,  1.958879284090e-01,  4.597904569575e-01,  7.533392594597e-01,  1.046888061962e+00,  1.340436864464e+00,  1.731742551895e+00,  2.123048239326e+00,  2.514353926757e+00,  2.986246541958e+00,  3.538726084928e+00,  4.091205627898e+00,  4.643685170869e+00],
        [-3.276473631522e-01, -6.017037545666e-02,  2.073066122389e-01,  4.747835999345e-01,  7.826823596790e-01,  1.131002891473e+00,  1.479323423266e+00,  1.827643955060e+00,  2.309252957607e+00,  2.790861960153e+00,  3.272470962700e+00,  3.863957733682e+00,  4.565322273099e+00,  5.266686812515e+00,  5.968051351932e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034297462802e+00, -8.977973181310e-01, -7.612971734598e-01, -6.247970287886e-01, -4.903588440879e-01, -3.579826193577e-01, -2.256063946276e-01, -9.323016989738e-02,  3.234686030735e-02,  1.579238905121e-01,  2.835009207168e-01,  4.034729626027e-01,  5.178400161697e-01,  6.322070697368e-01,  7.465741233038e-01],
        [-1.068594925604e+00, -9.384517791191e-01, -8.083086326338e-01, -6.781654861486e-01, -5.521462596044e-01, -4.302509530012e-01, -3.083556463980e-01, -1.864603397948e-01, -7.816342224244e-02,  3.013349530990e-02,  1.384304128622e-01,  2.355173537768e-01,  3.213943180538e-01,  4.072712823307e-01,  4.931482466076e-01],
        [-1.051446194203e+00, -9.181245486250e-01, -7.848029030468e-01, -6.514812574686e-01, -5.212525518461e-01, -3.941167861794e-01, -2.669810205128e-01, -1.398452548461e-01, -2.290828096754e-02,  9.402869291099e-02,  2.109656667895e-01,  3.194951581898e-01,  4.196171671117e-01,  5.197391760337e-01,  6.198611849557e-01],
        [-1.017148731401e+00, -8.774700876369e-01, -7.377914438727e-01, -5.981128001086e-01, -4.594651363297e-01, -3.218484525360e-01, -1.842317687423e-01, -4.661508494869e-02,  8.760200158225e-02,  2.218190881132e-01,  3.560361746441e-01,  4.874507670156e-01,  6.160628652277e-01,  7.446749634398e-01,  8.732870616519e-01],
        [-9.485538057967e-01, -7.961611656607e-01, -6.437685255246e-01, -4.913758853886e-01, -3.358903052967e-01, -1.773117852491e-01, -1.873326520153e-02,  1.398452548461e-01,  3.086225666818e-01,  4.773998785176e-01,  6.461771903533e-01,  8.233619846674e-01,  1.008954261460e+00,  1.194546538252e+00,  1.380138815044e+00],
        [-8.456614173902e-01, -6.741977826963e-01, -5.027341480024e-01, -3.312705133085e-01, -1.505280587473e-01,  3.949321568119e-02,  2.295144901097e-01,  4.195357645382e-01,  6.401534143312e-01,  8.607710641242e-01,  1.081388713917e+00,  1.327228811145e+00,  1.598291355808e+00,  1.869353900470e+00,  2.140416445133e+00],
        [-7.256202975827e-01, -5.319071692379e-01, -3.381940408932e-01, -1.444809125485e-01,  6.572789556031e-02,  2.924323834332e-01,  5.191368713061e-01,  7.458413591791e-01,  1.026939403255e+00,  1.308037447332e+00,  1.589135491408e+00,  1.915073442035e+00,  2.285851299214e+00,  2.656629156392e+00,  3.027407013570e+00],
        [-5.541329835718e-01, -3.286348642974e-01, -1.031367450229e-01,  1.223613742515e-01,  3.746649731426e-01,  6.537740516504e-01,  9.328831301582e-01,  1.211992208666e+00,  1.579490816004e+00,  1.946989423343e+00,  2.314488030681e+00,  2.754851486165e+00,  3.268079789793e+00,  3.781308093422e+00,  4.294536397051e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]]
                                    ],
                                    dtype=np.float64)

# nearestly extrapolated data sampled on self.xsamples_ex,
# self.ysamples_ex and self.zsamples_ex
# calculated from nearest edge value.
linear_nearest_extrapolated_data = [
        [  # x inf
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.040875493463e+00, -1.040875493463e+00, -1.040875493463e+00],
        [-1.081750986927e+00, -1.081750986927e+00, -1.081750986927e+00],
        [-1.183939720586e+00, -1.183939720586e+00, -1.183939720586e+00],
        [-1.306566200976e+00, -1.306566200976e+00, -1.306566200976e+00],
        [-1.470068174830e+00, -1.470068174830e+00, -1.470068174830e+00],
        [-1.674445642148e+00, -1.674445642148e+00, -1.674445642148e+00],
        [-1.899260856197e+00, -1.899260856197e+00, -1.899260856197e+00],
        [-2.185389310441e+00, -2.185389310441e+00, -2.185389310441e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.040875493463e+00, -1.040875493463e+00, -1.040875493463e+00],
        [-1.081750986927e+00, -1.081750986927e+00, -1.081750986927e+00],
        [-1.183939720586e+00, -1.183939720586e+00, -1.183939720586e+00],
        [-1.306566200976e+00, -1.306566200976e+00, -1.306566200976e+00],
        [-1.470068174830e+00, -1.470068174830e+00, -1.470068174830e+00],
        [-1.674445642148e+00, -1.674445642148e+00, -1.674445642148e+00],
        [-1.899260856197e+00, -1.899260856197e+00, -1.899260856197e+00],
        [-2.185389310441e+00, -2.185389310441e+00, -2.185389310441e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.040875493463e+00, -1.040875493463e+00, -1.040875493463e+00],
        [-1.081750986927e+00, -1.081750986927e+00, -1.081750986927e+00],
        [-1.183939720586e+00, -1.183939720586e+00, -1.183939720586e+00],
        [-1.306566200976e+00, -1.306566200976e+00, -1.306566200976e+00],
        [-1.470068174830e+00, -1.470068174830e+00, -1.470068174830e+00],
        [-1.674445642148e+00, -1.674445642148e+00, -1.674445642148e+00],
        [-1.899260856197e+00, -1.899260856197e+00, -1.899260856197e+00],
        [-2.185389310441e+00, -2.185389310441e+00, -2.185389310441e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.040875493463e+00, -9.055945797664e-01, -7.703136660693e-01, -6.350327523722e-01, -5.022092691790e-01, -3.718432164897e-01, -2.414771638004e-01, -1.111111111111e-01,  1.115170569206e-02,  1.334145224952e-01,  2.556773392984e-01,  3.712601674181e-01,  4.801630068543e-01,  5.890658462905e-01,  6.979686857268e-01],
        [-1.081750986927e+00, -9.540463023899e-01, -8.263416178529e-01, -6.986369333158e-01, -5.758471097865e-01, -4.579721472651e-01, -3.400971847437e-01, -2.222222222222e-01, -1.205537314730e-01, -1.888524072383e-02,  8.278325002537e-02,  1.710917634076e-01,  2.460402994229e-01,  3.209888354382e-01,  3.959373714535e-01],
        [-1.183939720586e+00, -1.075175608949e+00, -9.664114973118e-01, -8.576473856748e-01, -7.599417113054e-01, -6.732944742036e-01, -5.866472371018e-01, -5.000000000000e-01, -4.498173243857e-01, -3.996346487715e-01, -3.494519731572e-01, -3.293292466186e-01, -3.392664691555e-01, -3.492036916925e-01, -3.591409142295e-01],
        [-1.306566200976e+00, -1.220530776819e+00, -1.134495352662e+00, -1.048459928506e+00, -9.808552331281e-01, -9.316812665298e-01, -8.825072999316e-01, -8.333333333333e-01, -8.449336358810e-01, -8.565339384286e-01, -8.681342409763e-01, -9.298344586500e-01, -1.041634591450e+00, -1.153434724249e+00, -1.265234857049e+00],
        [-1.470068174830e+00, -1.414337667313e+00, -1.358607159797e+00, -1.302876652280e+00, -1.275406595558e+00, -1.276196989631e+00, -1.276987383705e+00, -1.277777777778e+00, -1.371755384541e+00, -1.465732991305e+00, -1.559710598068e+00, -1.730508074692e+00, -1.978125421175e+00, -2.225742767659e+00, -2.473360114142e+00],
        [-1.674445642148e+00, -1.656596280431e+00, -1.638746918715e+00, -1.620897556998e+00, -1.643595798596e+00, -1.706841643508e+00, -1.770087488421e+00, -1.833333333333e+00, -2.030282570367e+00, -2.227231807400e+00, -2.424181044434e+00, -2.731350094744e+00, -3.148738958332e+00, -3.566127821920e+00, -3.983516685508e+00],
        [-1.899260856197e+00, -1.923080754861e+00, -1.946900653524e+00, -1.970720552188e+00, -2.048603921938e+00, -2.180550762773e+00, -2.312497603609e+00, -2.444444444444e+00, -2.754662474775e+00, -3.064880505105e+00, -3.375098535435e+00, -3.832276316802e+00, -4.436413849205e+00, -5.040551381608e+00, -5.644688914011e+00],
        [-2.185389310441e+00, -2.262242813225e+00, -2.339096316009e+00, -2.415949818793e+00, -2.564068806190e+00, -2.783453278201e+00, -3.002837750212e+00, -3.222222222222e+00, -3.676600534930e+00, -4.130978847638e+00, -4.585357160346e+00, -5.233455144875e+00, -6.075272801225e+00, -6.917090457574e+00, -7.758908113924e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.040875493463e+00, -9.055945797664e-01, -7.703136660693e-01, -6.350327523722e-01, -5.022092691790e-01, -3.718432164897e-01, -2.414771638004e-01, -1.111111111111e-01,  1.115170569206e-02,  1.334145224952e-01,  2.556773392984e-01,  3.712601674181e-01,  4.801630068543e-01,  5.890658462905e-01,  6.979686857268e-01],
        [-1.081750986927e+00, -9.540463023899e-01, -8.263416178529e-01, -6.986369333158e-01, -5.758471097865e-01, -4.579721472651e-01, -3.400971847437e-01, -2.222222222222e-01, -1.205537314730e-01, -1.888524072383e-02,  8.278325002537e-02,  1.710917634076e-01,  2.460402994229e-01,  3.209888354382e-01,  3.959373714535e-01],
        [-1.183939720586e+00, -1.075175608949e+00, -9.664114973118e-01, -8.576473856748e-01, -7.599417113054e-01, -6.732944742036e-01, -5.866472371018e-01, -5.000000000000e-01, -4.498173243857e-01, -3.996346487715e-01, -3.494519731572e-01, -3.293292466186e-01, -3.392664691555e-01, -3.492036916925e-01, -3.591409142295e-01],
        [-1.306566200976e+00, -1.220530776819e+00, -1.134495352662e+00, -1.048459928506e+00, -9.808552331281e-01, -9.316812665298e-01, -8.825072999316e-01, -8.333333333333e-01, -8.449336358810e-01, -8.565339384286e-01, -8.681342409763e-01, -9.298344586500e-01, -1.041634591450e+00, -1.153434724249e+00, -1.265234857049e+00],
        [-1.470068174830e+00, -1.414337667313e+00, -1.358607159797e+00, -1.302876652280e+00, -1.275406595558e+00, -1.276196989631e+00, -1.276987383705e+00, -1.277777777778e+00, -1.371755384541e+00, -1.465732991305e+00, -1.559710598068e+00, -1.730508074692e+00, -1.978125421175e+00, -2.225742767659e+00, -2.473360114142e+00],
        [-1.674445642148e+00, -1.656596280431e+00, -1.638746918715e+00, -1.620897556998e+00, -1.643595798596e+00, -1.706841643508e+00, -1.770087488421e+00, -1.833333333333e+00, -2.030282570367e+00, -2.227231807400e+00, -2.424181044434e+00, -2.731350094744e+00, -3.148738958332e+00, -3.566127821920e+00, -3.983516685508e+00],
        [-1.899260856197e+00, -1.923080754861e+00, -1.946900653524e+00, -1.970720552188e+00, -2.048603921938e+00, -2.180550762773e+00, -2.312497603609e+00, -2.444444444444e+00, -2.754662474775e+00, -3.064880505105e+00, -3.375098535435e+00, -3.832276316802e+00, -4.436413849205e+00, -5.040551381608e+00, -5.644688914011e+00],
        [-2.185389310441e+00, -2.262242813225e+00, -2.339096316009e+00, -2.415949818793e+00, -2.564068806190e+00, -2.783453278201e+00, -3.002837750212e+00, -3.222222222222e+00, -3.676600534930e+00, -4.130978847638e+00, -4.585357160346e+00, -5.233455144875e+00, -6.075272801225e+00, -6.917090457574e+00, -7.758908113924e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.040875493463e+00, -9.055945797664e-01, -7.703136660693e-01, -6.350327523722e-01, -5.022092691790e-01, -3.718432164897e-01, -2.414771638004e-01, -1.111111111111e-01,  1.115170569206e-02,  1.334145224952e-01,  2.556773392984e-01,  3.712601674181e-01,  4.801630068543e-01,  5.890658462905e-01,  6.979686857268e-01],
        [-1.081750986927e+00, -9.540463023899e-01, -8.263416178529e-01, -6.986369333158e-01, -5.758471097865e-01, -4.579721472651e-01, -3.400971847437e-01, -2.222222222222e-01, -1.205537314730e-01, -1.888524072383e-02,  8.278325002537e-02,  1.710917634076e-01,  2.460402994229e-01,  3.209888354382e-01,  3.959373714535e-01],
        [-1.183939720586e+00, -1.075175608949e+00, -9.664114973118e-01, -8.576473856748e-01, -7.599417113054e-01, -6.732944742036e-01, -5.866472371018e-01, -5.000000000000e-01, -4.498173243857e-01, -3.996346487715e-01, -3.494519731572e-01, -3.293292466186e-01, -3.392664691555e-01, -3.492036916925e-01, -3.591409142295e-01],
        [-1.306566200976e+00, -1.220530776819e+00, -1.134495352662e+00, -1.048459928506e+00, -9.808552331281e-01, -9.316812665298e-01, -8.825072999316e-01, -8.333333333333e-01, -8.449336358810e-01, -8.565339384286e-01, -8.681342409763e-01, -9.298344586500e-01, -1.041634591450e+00, -1.153434724249e+00, -1.265234857049e+00],
        [-1.470068174830e+00, -1.414337667313e+00, -1.358607159797e+00, -1.302876652280e+00, -1.275406595558e+00, -1.276196989631e+00, -1.276987383705e+00, -1.277777777778e+00, -1.371755384541e+00, -1.465732991305e+00, -1.559710598068e+00, -1.730508074692e+00, -1.978125421175e+00, -2.225742767659e+00, -2.473360114142e+00],
        [-1.674445642148e+00, -1.656596280431e+00, -1.638746918715e+00, -1.620897556998e+00, -1.643595798596e+00, -1.706841643508e+00, -1.770087488421e+00, -1.833333333333e+00, -2.030282570367e+00, -2.227231807400e+00, -2.424181044434e+00, -2.731350094744e+00, -3.148738958332e+00, -3.566127821920e+00, -3.983516685508e+00],
        [-1.899260856197e+00, -1.923080754861e+00, -1.946900653524e+00, -1.970720552188e+00, -2.048603921938e+00, -2.180550762773e+00, -2.312497603609e+00, -2.444444444444e+00, -2.754662474775e+00, -3.064880505105e+00, -3.375098535435e+00, -3.832276316802e+00, -4.436413849205e+00, -5.040551381608e+00, -5.644688914011e+00],
        [-2.185389310441e+00, -2.262242813225e+00, -2.339096316009e+00, -2.415949818793e+00, -2.564068806190e+00, -2.783453278201e+00, -3.002837750212e+00, -3.222222222222e+00, -3.676600534930e+00, -4.130978847638e+00, -4.585357160346e+00, -5.233455144875e+00, -6.075272801225e+00, -6.917090457574e+00, -7.758908113924e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.979686857268e-01,  6.979686857268e-01,  6.979686857268e-01],
        [ 3.959373714535e-01,  3.959373714535e-01,  3.959373714535e-01],
        [-3.591409142295e-01, -3.591409142295e-01, -3.591409142295e-01],
        [-1.265234857049e+00, -1.265234857049e+00, -1.265234857049e+00],
        [-2.473360114142e+00, -2.473360114142e+00, -2.473360114142e+00],
        [-3.983516685508e+00, -3.983516685508e+00, -3.983516685508e+00],
        [-5.644688914011e+00, -5.644688914011e+00, -5.644688914011e+00],
        [-7.758908113924e+00, -7.758908113924e+00, -7.758908113924e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.979686857268e-01,  6.979686857268e-01,  6.979686857268e-01],
        [ 3.959373714535e-01,  3.959373714535e-01,  3.959373714535e-01],
        [-3.591409142295e-01, -3.591409142295e-01, -3.591409142295e-01],
        [-1.265234857049e+00, -1.265234857049e+00, -1.265234857049e+00],
        [-2.473360114142e+00, -2.473360114142e+00, -2.473360114142e+00],
        [-3.983516685508e+00, -3.983516685508e+00, -3.983516685508e+00],
        [-5.644688914011e+00, -5.644688914011e+00, -5.644688914011e+00],
        [-7.758908113924e+00, -7.758908113924e+00, -7.758908113924e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.979686857268e-01,  6.979686857268e-01,  6.979686857268e-01],
        [ 3.959373714535e-01,  3.959373714535e-01,  3.959373714535e-01],
        [-3.591409142295e-01, -3.591409142295e-01, -3.591409142295e-01],
        [-1.265234857049e+00, -1.265234857049e+00, -1.265234857049e+00],
        [-2.473360114142e+00, -2.473360114142e+00, -2.473360114142e+00],
        [-3.983516685508e+00, -3.983516685508e+00, -3.983516685508e+00],
        [-5.644688914011e+00, -5.644688914011e+00, -5.644688914011e+00],
        [-7.758908113924e+00, -7.758908113924e+00, -7.758908113924e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],
       [[-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],
       [[-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x mid
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.040875493463e+00, -1.040875493463e+00, -1.040875493463e+00],
        [-1.081750986927e+00, -1.081750986927e+00, -1.081750986927e+00],
        [-1.183939720586e+00, -1.183939720586e+00, -1.183939720586e+00],
        [-1.306566200976e+00, -1.306566200976e+00, -1.306566200976e+00],
        [-1.470068174830e+00, -1.470068174830e+00, -1.470068174830e+00],
        [-1.674445642148e+00, -1.674445642148e+00, -1.674445642148e+00],
        [-1.899260856197e+00, -1.899260856197e+00, -1.899260856197e+00],
        [-2.185389310441e+00, -2.185389310441e+00, -2.185389310441e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.023665924308e+00, -1.023665924308e+00, -1.023665924308e+00],
        [-1.047331848615e+00, -1.047331848615e+00, -1.047331848615e+00],
        [-1.110382745293e+00, -1.110382745293e+00, -1.110382745293e+00],
        [-1.186561966093e+00, -1.186561966093e+00, -1.186561966093e+00],
        [-1.288997835139e+00, -1.288997835139e+00, -1.288997835139e+00],
        [-1.417690352432e+00, -1.417690352432e+00, -1.417690352432e+00],
        [-1.559511193848e+00, -1.559511193848e+00, -1.559511193848e+00],
        [-1.740717007634e+00, -1.740717007634e+00, -1.740717007634e+00],
        [-1.921922821419e+00, -1.921922821419e+00, -1.921922821419e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.006141122158e+00, -1.006141122158e+00, -1.006141122158e+00],
        [-1.012282244316e+00, -1.012282244316e+00, -1.012282244316e+00],
        [-1.027232224485e+00, -1.027232224485e+00, -1.027232224485e+00],
        [-1.045118490658e+00, -1.045118490658e+00, -1.045118490658e+00],
        [-1.068877328839e+00, -1.068877328839e+00, -1.068877328839e+00],
        [-1.098508739026e+00, -1.098508739026e+00, -1.098508739026e+00],
        [-1.131076435218e+00, -1.131076435218e+00, -1.131076435218e+00],
        [-1.172452989420e+00, -1.172452989420e+00, -1.172452989420e+00],
        [-1.213829543622e+00, -1.213829543622e+00, -1.213829543622e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.882222787662e-01, -9.882222787662e-01, -9.882222787662e-01],
        [-9.764445575323e-01, -9.764445575323e-01, -9.764445575323e-01],
        [-9.320897717856e-01, -9.320897717856e-01, -9.320897717856e-01],
        [-8.768759645346e-01, -8.768759645346e-01, -8.768759645346e-01],
        [-7.999441142749e-01, -7.999441142749e-01, -7.999441142749e-01],
        [-7.012942210067e-01, -7.012942210067e-01, -7.012942210067e-01],
        [-5.917853062341e-01, -5.917853062341e-01, -5.917853062341e-01],
        [-4.496993269487e-01, -4.496993269487e-01, -4.496993269487e-01],
        [-3.076133476632e-01, -3.076133476632e-01, -3.076133476632e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.864560013358e-01, -9.864560013358e-01, -9.864560013358e-01],
        [-9.729120026716e-01, -9.729120026716e-01, -9.729120026716e-01],
        [-9.090415815469e-01, -9.090415815469e-01, -9.090415815469e-01],
        [-8.283956862687e-01, -8.283956862687e-01, -8.283956862687e-01],
        [-7.141988426834e-01, -7.141988426834e-01, -7.141988426834e-01],
        [-5.664510507911e-01, -5.664510507911e-01, -5.664510507911e-01],
        [-4.019277847453e-01, -4.019277847453e-01, -4.019277847453e-01],
        [-1.870780962389e-01, -1.870780962389e-01, -1.870780962389e-01],
        [ 2.777159226742e-02,  2.777159226742e-02,  2.777159226742e-02]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.892330408356e-01, -9.892330408356e-01, -9.892330408356e-01],
        [-9.784660816711e-01, -9.784660816711e-01, -9.784660816711e-01],
        [-9.169288529992e-01, -9.169288529992e-01, -9.169288529992e-01],
        [-8.384682011580e-01, -8.384682011580e-01, -8.384682011580e-01],
        [-7.261607029786e-01, -7.261607029786e-01, -7.261607029786e-01],
        [-5.800063584608e-01, -5.800063584608e-01, -5.800063584608e-01],
        [-4.169285907738e-01, -4.169285907738e-01, -4.169285907738e-01],
        [-2.030805535793e-01, -2.030805535793e-01, -2.030805535793e-01],
        [ 1.076748361520e-02,  1.076748361520e-02,  1.076748361520e-02]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.970585727051e-01, -9.970585727051e-01, -9.970585727051e-01],
        [-9.941171454102e-01, -9.941171454102e-01, -9.941171454102e-01],
        [-9.686634822180e-01, -9.686634822180e-01, -9.686634822180e-01],
        [-9.357057403935e-01, -9.357057403935e-01, -9.357057403935e-01],
        [-8.877398413041e-01, -8.877398413041e-01, -8.877398413041e-01],
        [-8.247657849499e-01, -8.247657849499e-01, -8.247657849499e-01],
        [-7.542876499633e-01, -7.542876499633e-01, -7.542876499633e-01],
        [-6.612972790795e-01, -6.612972790795e-01, -6.612972790795e-01],
        [-5.683069081956e-01, -5.683069081956e-01, -5.683069081956e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.977030179212e-01, -9.977030179212e-01, -9.977030179212e-01],
        [-9.954060358424e-01, -9.954060358424e-01, -9.954060358424e-01],
        [-1.007885638954e+00, -1.007885638954e+00, -1.007885638954e+00],
        [-1.025290770463e+00, -1.025290770463e+00, -1.025290770463e+00],
        [-1.052546958766e+00, -1.052546958766e+00, -1.052546958766e+00],
        [-1.089654203863e+00, -1.089654203863e+00, -1.089654203863e+00],
        [-1.131686977356e+00, -1.131686977356e+00, -1.131686977356e+00],
        [-1.188496336040e+00, -1.188496336040e+00, -1.188496336040e+00],
        [-1.245305694724e+00, -1.245305694724e+00, -1.245305694724e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.952878855481e-01, -9.952878855481e-01, -9.952878855481e-01],
        [-9.905757710962e-01, -9.905757710962e-01, -9.905757710962e-01],
        [-1.033231510680e+00, -1.033231510680e+00, -1.033231510680e+00],
        [-1.091676534943e+00, -1.091676534943e+00, -1.091676534943e+00],
        [-1.181700128563e+00, -1.181700128563e+00, -1.181700128563e+00],
        [-1.303302291540e+00, -1.303302291540e+00, -1.303302291540e+00],
        [-1.440693739196e+00, -1.440693739196e+00, -1.440693739196e+00],
        [-1.625453040888e+00, -1.625453040888e+00, -1.625453040888e+00],
        [-1.810212342580e+00, -1.810212342580e+00, -1.810212342580e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.893453182659e-01, -9.893453182659e-01, -9.893453182659e-01],
        [-9.786906365319e-01, -9.786906365319e-01, -9.786906365319e-01],
        [-1.022522857352e+00, -1.022522857352e+00, -1.022522857352e+00],
        [-1.084517379023e+00, -1.084517379023e+00, -1.084517379023e+00],
        [-1.182836502396e+00, -1.182836502396e+00, -1.182836502396e+00],
        [-1.317480227473e+00, -1.317480227473e+00, -1.317480227473e+00],
        [-1.470286253400e+00, -1.470286253400e+00, -1.470286253400e+00],
        [-1.677579181881e+00, -1.677579181881e+00, -1.677579181881e+00],
        [-1.884872110363e+00, -1.884872110363e+00, -1.884872110363e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.920387746669e-01, -9.920387746669e-01, -9.920387746669e-01],
        [-9.840775493339e-01, -9.840775493339e-01, -9.840775493339e-01],
        [-1.010608185252e+00, -1.010608185252e+00, -1.010608185252e+00],
        [-1.048636108254e+00, -1.048636108254e+00, -1.048636108254e+00],
        [-1.109658605423e+00, -1.109658605423e+00, -1.109658605423e+00],
        [-1.193675676759e+00, -1.193675676759e+00, -1.193675676759e+00],
        [-1.289190035179e+00, -1.289190035179e+00, -1.289190035179e+00],
        [-1.419196254850e+00, -1.419196254850e+00, -1.419196254850e+00],
        [-1.549202474521e+00, -1.549202474521e+00, -1.549202474521e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000347197391e+00, -1.000347197391e+00, -1.000347197391e+00],
        [-1.000694394782e+00, -1.000694394782e+00, -1.000694394782e+00],
        [-1.001610389042e+00, -1.001610389042e+00, -1.001610389042e+00],
        [-1.002715982258e+00, -1.002715982258e+00, -1.002715982258e+00],
        [-1.004200773386e+00, -1.004200773386e+00, -1.004200773386e+00],
        [-1.006064762427e+00, -1.006064762427e+00, -1.006064762427e+00],
        [-1.008118350423e+00, -1.008118350423e+00, -1.008118350423e+00],
        [-1.010740735289e+00, -1.010740735289e+00, -1.010740735289e+00],
        [-1.013363120154e+00, -1.013363120154e+00, -1.013363120154e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.019031255969e+00, -1.019031255969e+00, -1.019031255969e+00],
        [-1.038062511938e+00, -1.038062511938e+00, -1.038062511938e+00],
        [-1.020771675038e+00, -1.020771675038e+00, -1.020771675038e+00],
        [-9.913734738474e-01, -9.913734738474e-01, -9.913734738474e-01],
        [-9.377605440776e-01, -9.377605440776e-01, -9.377605440776e-01],
        [-8.599328857283e-01, -8.599328857283e-01, -8.599328857283e-01],
        [-7.699978630893e-01, -7.699978630893e-01, -7.699978630893e-01],
        [-6.437407475809e-01, -6.437407475809e-01, -6.437407475809e-01],
        [-5.174836320724e-01, -5.174836320724e-01, -5.174836320724e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.029821775146e+00, -1.029821775146e+00, -1.029821775146e+00],
        [-1.059643550292e+00, -1.059643550292e+00, -1.059643550292e+00],
        [-1.037201513595e+00, -1.037201513595e+00, -1.037201513595e+00],
        [-9.973382062850e-01, -9.973382062850e-01, -9.973382062850e-01],
        [-9.226323577463e-01, -9.226323577463e-01, -9.226323577463e-01],
        [-8.130839679795e-01, -8.130839679795e-01, -8.130839679795e-01],
        [-6.861143075986e-01, -6.861143075986e-01, -6.861143075986e-01],
        [-5.068808353754e-01, -5.068808353754e-01, -5.068808353754e-01],
        [-3.276473631522e-01, -3.276473631522e-01, -3.276473631522e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.034297462802e+00, -1.034297462802e+00, -1.034297462802e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.051446194203e+00, -1.051446194203e+00, -1.051446194203e+00],
        [-1.017148731401e+00, -1.017148731401e+00, -1.017148731401e+00],
        [-9.485538057967e-01, -9.485538057967e-01, -9.485538057967e-01],
        [-8.456614173902e-01, -8.456614173902e-01, -8.456614173902e-01],
        [-7.256202975827e-01, -7.256202975827e-01, -7.256202975827e-01],
        [-5.541329835718e-01, -5.541329835718e-01, -5.541329835718e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]]
                ], dtype=np.float64),

                None,  # z mid (interpolation area)

                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.979686857268e-01,  6.979686857268e-01,  6.979686857268e-01],
        [ 3.959373714535e-01,  3.959373714535e-01,  3.959373714535e-01],
        [-3.591409142295e-01, -3.591409142295e-01, -3.591409142295e-01],
        [-1.265234857049e+00, -1.265234857049e+00, -1.265234857049e+00],
        [-2.473360114142e+00, -2.473360114142e+00, -2.473360114142e+00],
        [-3.983516685508e+00, -3.983516685508e+00, -3.983516685508e+00],
        [-5.644688914011e+00, -5.644688914011e+00, -5.644688914011e+00],
        [-7.758908113924e+00, -7.758908113924e+00, -7.758908113924e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 8.251311576573e-01,  8.251311576573e-01,  8.251311576573e-01],
        [ 6.502623153146e-01,  6.502623153146e-01,  6.502623153146e-01],
        [ 1.843757026793e-01,  1.843757026793e-01,  1.843757026793e-01],
        [-3.785168333868e-01, -3.785168333868e-01, -3.785168333868e-01],
        [-1.135421216315e+00, -1.135421216315e+00, -1.135421216315e+00],
        [-2.086337446104e+00, -2.086337446104e+00, -2.086337446104e+00],
        [-3.134259599325e+00, -3.134259599325e+00, -3.134259599325e+00],
        [-4.473199522838e+00, -4.473199522838e+00, -4.473199522838e+00],
        [-5.812139446351e+00, -5.812139446351e+00, -5.812139446351e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 9.546229038635e-01,  9.546229038635e-01,  9.546229038635e-01],
        [ 9.092458077270e-01,  9.092458077270e-01,  9.092458077270e-01],
        [ 7.987795655790e-01,  7.987795655790e-01,  7.987795655790e-01],
        [ 6.666169414272e-01,  6.666169414272e-01,  6.666169414272e-01],
        [ 4.910615532677e-01,  4.910615532677e-01,  4.910615532677e-01],
        [ 2.721134011006e-01,  2.721134011006e-01,  2.721134011006e-01],
        [ 3.146886692959e-02,  3.146886692959e-02,  3.146886692959e-02],
        [-2.742648132529e-01, -2.742648132529e-01, -2.742648132529e-01],
        [-5.799984934354e-01, -5.799984934354e-01, -5.799984934354e-01]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.087026242914e+00,  1.087026242914e+00,  1.087026242914e+00],
        [ 1.174052485829e+00,  1.174052485829e+00,  1.174052485829e+00],
        [ 1.501792485967e+00,  1.501792485967e+00,  1.501792485967e+00],
        [ 1.909770405181e+00,  1.909770405181e+00,  1.909770405181e+00],
        [ 2.478224162544e+00,  2.478224162544e+00,  2.478224162544e+00],
        [ 3.207153758056e+00,  3.207153758056e+00,  3.207153758056e+00],
        [ 4.016321272644e+00,  4.016321272644e+00,  4.016321272644e+00],
        [ 5.066202544455e+00,  5.066202544455e+00,  5.066202544455e+00],
        [ 6.116083816267e+00,  6.116083816267e+00,  6.116083816267e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.100077365933e+00,  1.100077365933e+00,  1.100077365933e+00],
        [ 1.200154731867e+00,  1.200154731867e+00,  1.200154731867e+00],
        [ 1.672096856620e+00,  1.672096856620e+00,  1.672096856620e+00],
        [ 2.267993900979e+00,  2.267993900979e+00,  2.267993900979e+00],
        [ 3.111800784552e+00,  3.111800784552e+00,  3.111800784552e+00],
        [ 4.203517507337e+00,  4.203517507337e+00,  4.203517507337e+00],
        [ 5.419189149729e+00,  5.419189149729e+00,  5.419189149729e+00],
        [ 7.006725550940e+00,  7.006725550940e+00,  7.006725550940e+00],
        [ 8.594261952151e+00,  8.594261952151e+00,  8.594261952151e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.079557665281e+00,  1.079557665281e+00,  1.079557665281e+00],
        [ 1.159115330562e+00,  1.159115330562e+00,  1.159115330562e+00],
        [ 1.613817365392e+00,  1.613817365392e+00,  1.613817365392e+00],
        [ 2.193567523404e+00,  2.193567523404e+00,  2.193567523404e+00],
        [ 3.023413927783e+00,  3.023413927783e+00,  3.023413927783e+00],
        [ 4.103356578528e+00,  4.103356578528e+00,  4.103356578528e+00],
        [ 5.308347352455e+00,  5.308347352455e+00,  5.308347352455e+00],
        [ 6.888482495931e+00,  6.888482495931e+00,  6.888482495931e+00],
        [ 8.468617639408e+00,  8.468617639408e+00,  8.468617639408e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.021734371293e+00,  1.021734371293e+00,  1.021734371293e+00],
        [ 1.043468742586e+00,  1.043468742586e+00,  1.043468742586e+00],
        [ 1.231547287836e+00,  1.231547287836e+00,  1.231547287836e+00],
        [ 1.475073891072e+00,  1.475073891072e+00,  1.475073891072e+00],
        [ 1.829496610279e+00,  1.829496610279e+00,  1.829496610279e+00],
        [ 2.294815445457e+00,  2.294815445457e+00,  2.294815445457e+00],
        [ 2.815582338621e+00,  2.815582338621e+00,  2.815582338621e+00],
        [ 3.502693405742e+00,  3.502693405742e+00,  3.502693405742e+00],
        [ 4.189804472863e+00,  4.189804472863e+00,  4.189804472863e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.016972529438e+00,  1.016972529438e+00,  1.016972529438e+00],
        [ 1.033945058877e+00,  1.033945058877e+00,  1.033945058877e+00],
        [ 9.417325713899e-01,  9.417325713899e-01,  9.417325713899e-01],
        [ 8.131250782616e-01,  8.131250782616e-01,  8.131250782616e-01],
        [ 6.117275738499e-01,  6.117275738499e-01,  6.117275738499e-01],
        [ 3.375400581548e-01,  3.375400581548e-01,  3.375400581548e-01],
        [ 2.695753681815e-02,  2.695753681815e-02,  2.695753681815e-02],
        [-3.928100014436e-01, -3.928100014436e-01, -3.928100014436e-01],
        [-8.125775397052e-01, -8.125775397052e-01, -8.125775397052e-01]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.034818078030e+00,  1.034818078030e+00,  1.034818078030e+00],
        [ 1.069636156059e+00,  1.069636156059e+00,  1.069636156059e+00],
        [ 7.544505033314e-01,  7.544505033314e-01,  7.544505033314e-01],
        [ 3.225969403509e-01,  3.225969403509e-01,  3.225969403509e-01],
        [-3.425924431347e-01, -3.425924431347e-01, -3.425924431347e-01],
        [-1.241117647125e+00, -1.241117647125e+00, -1.241117647125e+00],
        [-2.256310761369e+00, -2.256310761369e+00, -2.256310761369e+00],
        [-3.621507606369e+00, -3.621507606369e+00, -3.621507606369e+00],
        [-4.986704451370e+00, -4.986704451370e+00, -4.986704451370e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.078728041049e+00,  1.078728041049e+00,  1.078728041049e+00],
        [ 1.157456082098e+00,  1.157456082098e+00,  1.157456082098e+00],
        [ 8.335773435202e-01,  8.335773435202e-01,  8.335773435202e-01],
        [ 3.754963450663e-01,  3.754963450663e-01,  3.754963450663e-01],
        [-3.509891731392e-01, -3.509891731392e-01, -3.509891731392e-01],
        [-1.345879211096e+00, -1.345879211096e+00, -1.345879211096e+00],
        [-2.474971508929e+00, -2.474971508929e+00, -2.474971508929e+00],
        [-4.006670586389e+00, -4.006670586389e+00, -4.006670586389e+00],
        [-5.538369663849e+00, -5.538369663849e+00, -5.538369663849e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.058825940602e+00,  1.058825940602e+00,  1.058825940602e+00],
        [ 1.117651881205e+00,  1.117651881205e+00,  1.117651881205e+00],
        [ 9.216155240663e-01,  9.216155240663e-01,  9.216155240663e-01],
        [ 6.406250676811e-01,  6.406250676811e-01,  6.406250676811e-01],
        [ 1.897264128022e-01,  1.897264128022e-01,  1.897264128022e-01],
        [-4.310804405704e-01, -4.310804405704e-01, -4.310804405704e-01],
        [-1.136841393190e+00, -1.136841393190e+00, -1.136841393190e+00],
        [-2.097464643550e+00, -2.097464643550e+00, -2.097464643550e+00],
        [-3.058087893910e+00, -3.058087893910e+00, -3.058087893910e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 9.974345389992e-01,  9.974345389992e-01,  9.974345389992e-01],
        [ 9.948690779984e-01,  9.948690779984e-01,  9.948690779984e-01],
        [ 9.881007450273e-01,  9.881007450273e-01,  9.881007450273e-01],
        [ 9.799314547327e-01,  9.799314547327e-01,  9.799314547327e-01],
        [ 9.689602497912e-01,  9.689602497912e-01,  9.689602497912e-01],
        [ 9.551871302027e-01,  9.551871302027e-01,  9.551871302027e-01],
        [ 9.400130532908e-01,  9.400130532908e-01,  9.400130532908e-01],
        [ 9.206361044085e-01,  9.206361044085e-01,  9.206361044085e-01],
        [ 9.012591555262e-01,  9.012591555262e-01,  9.012591555262e-01]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 8.593769820123e-01,  8.593769820123e-01,  8.593769820123e-01],
        [ 7.187539640245e-01,  7.187539640245e-01,  7.187539640245e-01],
        [ 8.465169278789e-01,  8.465169278789e-01,  8.465169278789e-01],
        [ 1.063741885681e+00,  1.063741885681e+00,  1.063741885681e+00],
        [ 1.459890831377e+00,  1.459890831377e+00,  1.459890831377e+00],
        [ 2.034963764969e+00,  2.034963764969e+00,  2.034963764969e+00],
        [ 2.699498692507e+00,  2.699498692507e+00,  2.699498692507e+00],
        [ 3.632419601888e+00,  3.632419601888e+00,  3.632419601888e+00],
        [ 4.565340511269e+00,  4.565340511269e+00,  4.565340511269e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.796452304773e-01,  7.796452304773e-01,  7.796452304773e-01],
        [ 5.592904609545e-01,  5.592904609545e-01,  5.592904609545e-01],
        [ 7.251159290782e-01,  7.251159290782e-01,  7.251159290782e-01],
        [ 1.019668143084e+00,  1.019668143084e+00,  1.019668143084e+00],
        [ 1.571673848854e+00,  1.571673848854e+00,  1.571673848854e+00],
        [ 2.381133046389e+00,  2.381133046389e+00,  2.381133046389e+00],
        [ 3.319318989806e+00,  3.319318989806e+00,  3.319318989806e+00],
        [ 4.643685170869e+00,  4.643685170869e+00,  4.643685170869e+00],
        [ 5.968051351932e+00,  5.968051351932e+00,  5.968051351932e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.465741233038e-01,  7.465741233038e-01,  7.465741233038e-01],
        [ 4.931482466076e-01,  4.931482466076e-01,  4.931482466076e-01],
        [ 6.198611849557e-01,  6.198611849557e-01,  6.198611849557e-01],
        [ 8.732870616519e-01,  8.732870616519e-01,  8.732870616519e-01],
        [ 1.380138815044e+00,  1.380138815044e+00,  1.380138815044e+00],
        [ 2.140416445133e+00,  2.140416445133e+00,  2.140416445133e+00],
        [ 3.027407013570e+00,  3.027407013570e+00,  3.027407013570e+00],
        [ 4.294536397051e+00,  4.294536397051e+00,  4.294536397051e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.921922821419e+00, -1.921922821419e+00, -1.921922821419e+00],
        [-1.921922821419e+00, -1.921922821419e+00, -1.921922821419e+00],
        [-1.921922821419e+00, -1.921922821419e+00, -1.921922821419e+00]],
       [[-1.213829543622e+00, -1.213829543622e+00, -1.213829543622e+00],
        [-1.213829543622e+00, -1.213829543622e+00, -1.213829543622e+00],
        [-1.213829543622e+00, -1.213829543622e+00, -1.213829543622e+00]],
       [[-3.076133476632e-01, -3.076133476632e-01, -3.076133476632e-01],
        [-3.076133476632e-01, -3.076133476632e-01, -3.076133476632e-01],
        [-3.076133476632e-01, -3.076133476632e-01, -3.076133476632e-01]],
       [[ 2.777159226742e-02,  2.777159226742e-02,  2.777159226742e-02],
        [ 2.777159226742e-02,  2.777159226742e-02,  2.777159226742e-02],
        [ 2.777159226742e-02,  2.777159226742e-02,  2.777159226742e-02]],
       [[ 1.076748361520e-02,  1.076748361520e-02,  1.076748361520e-02],
        [ 1.076748361520e-02,  1.076748361520e-02,  1.076748361520e-02],
        [ 1.076748361520e-02,  1.076748361520e-02,  1.076748361520e-02]],
       [[-5.683069081956e-01, -5.683069081956e-01, -5.683069081956e-01],
        [-5.683069081956e-01, -5.683069081956e-01, -5.683069081956e-01],
        [-5.683069081956e-01, -5.683069081956e-01, -5.683069081956e-01]],
       [[-1.245305694724e+00, -1.245305694724e+00, -1.245305694724e+00],
        [-1.245305694724e+00, -1.245305694724e+00, -1.245305694724e+00],
        [-1.245305694724e+00, -1.245305694724e+00, -1.245305694724e+00]],
       [[-1.810212342580e+00, -1.810212342580e+00, -1.810212342580e+00],
        [-1.810212342580e+00, -1.810212342580e+00, -1.810212342580e+00],
        [-1.810212342580e+00, -1.810212342580e+00, -1.810212342580e+00]],
       [[-1.884872110363e+00, -1.884872110363e+00, -1.884872110363e+00],
        [-1.884872110363e+00, -1.884872110363e+00, -1.884872110363e+00],
        [-1.884872110363e+00, -1.884872110363e+00, -1.884872110363e+00]],
       [[-1.549202474521e+00, -1.549202474521e+00, -1.549202474521e+00],
        [-1.549202474521e+00, -1.549202474521e+00, -1.549202474521e+00],
        [-1.549202474521e+00, -1.549202474521e+00, -1.549202474521e+00]],
       [[-1.013363120154e+00, -1.013363120154e+00, -1.013363120154e+00],
        [-1.013363120154e+00, -1.013363120154e+00, -1.013363120154e+00],
        [-1.013363120154e+00, -1.013363120154e+00, -1.013363120154e+00]],
       [[-5.174836320724e-01, -5.174836320724e-01, -5.174836320724e-01],
        [-5.174836320724e-01, -5.174836320724e-01, -5.174836320724e-01],
        [-5.174836320724e-01, -5.174836320724e-01, -5.174836320724e-01]],
       [[-3.276473631522e-01, -3.276473631522e-01, -3.276473631522e-01],
        [-3.276473631522e-01, -3.276473631522e-01, -3.276473631522e-01],
        [-3.276473631522e-01, -3.276473631522e-01, -3.276473631522e-01]],
       [[-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.601404871590e+00, -2.731291978494e+00, -2.861179085398e+00, -3.079533690443e+00, -3.386355793629e+00, -3.693177896814e+00, -4.000000000000e+00, -4.598538595086e+00, -5.197077190172e+00, -5.795615785258e+00, -6.634633972948e+00, -7.714131753244e+00, -8.793629533540e+00, -9.873127313836e+00]],
       [[-1.921922821419e+00, -1.949943091190e+00, -1.977963360961e+00, -2.005983630732e+00, -2.089429806630e+00, -2.228301888655e+00, -2.367173970680e+00, -2.506046052705e+00, -2.827681875489e+00, -3.149317698273e+00, -3.470953521057e+00, -3.943252577293e+00, -4.566214866979e+00, -5.189177156665e+00, -5.812139446351e+00],
        [-1.921922821419e+00, -1.949943091190e+00, -1.977963360961e+00, -2.005983630732e+00, -2.089429806630e+00, -2.228301888655e+00, -2.367173970680e+00, -2.506046052705e+00, -2.827681875489e+00, -3.149317698273e+00, -3.470953521057e+00, -3.943252577293e+00, -4.566214866979e+00, -5.189177156665e+00, -5.812139446351e+00],
        [-1.921922821419e+00, -1.949943091190e+00, -1.977963360961e+00, -2.005983630732e+00, -2.089429806630e+00, -2.228301888655e+00, -2.367173970680e+00, -2.506046052705e+00, -2.827681875489e+00, -3.149317698273e+00, -3.470953521057e+00, -3.943252577293e+00, -4.566214866979e+00, -5.189177156665e+00, -5.812139446351e+00]],
       [[-1.213829543622e+00, -1.110605478837e+00, -1.007381414052e+00, -9.041573492671e-01, -8.137886948663e-01, -7.362754508497e-01, -6.587622068332e-01, -5.812489628167e-01, -5.461256958886e-01, -5.110024289605e-01, -4.758791620324e-01, -4.757005235493e-01, -5.104665135113e-01, -5.452325034733e-01, -5.799984934354e-01],
        [-1.213829543622e+00, -1.110605478837e+00, -1.007381414052e+00, -9.041573492671e-01, -8.137886948663e-01, -7.362754508497e-01, -6.587622068332e-01, -5.812489628167e-01, -5.461256958886e-01, -5.110024289605e-01, -4.758791620324e-01, -4.757005235493e-01, -5.104665135113e-01, -5.452325034733e-01, -5.799984934354e-01],
        [-1.213829543622e+00, -1.110605478837e+00, -1.007381414052e+00, -9.041573492671e-01, -8.137886948663e-01, -7.362754508497e-01, -6.587622068332e-01, -5.812489628167e-01, -5.461256958886e-01, -5.110024289605e-01, -4.758791620324e-01, -4.757005235493e-01, -5.104665135113e-01, -5.452325034733e-01, -5.799984934354e-01]],
       [[-3.076133476632e-01, -3.642307654332e-02,  2.347671945766e-01,  5.059574656965e-01,  8.187739518362e-01,  1.173216652996e+00,  1.527659354155e+00,  1.882102055315e+00,  2.373804808718e+00,  2.865507562121e+00,  3.357210315524e+00,  3.962064852803e+00,  4.680071173958e+00,  5.398077495112e+00,  6.116083816267e+00],
        [-3.076133476632e-01, -3.642307654332e-02,  2.347671945766e-01,  5.059574656965e-01,  8.187739518362e-01,  1.173216652996e+00,  1.527659354155e+00,  1.882102055315e+00,  2.373804808718e+00,  2.865507562121e+00,  3.357210315524e+00,  3.962064852803e+00,  4.680071173958e+00,  5.398077495112e+00,  6.116083816267e+00],
        [-3.076133476632e-01, -3.642307654332e-02,  2.347671945766e-01,  5.059574656965e-01,  8.187739518362e-01,  1.173216652996e+00,  1.527659354155e+00,  1.882102055315e+00,  2.373804808718e+00,  2.865507562121e+00,  3.357210315524e+00,  3.962064852803e+00,  4.680071173958e+00,  5.398077495112e+00,  6.116083816267e+00]],
       [[ 2.777159226742e-02,  3.611251046461e-01,  6.944786170247e-01,  1.027832129403e+00,  1.422975165232e+00,  1.879907724510e+00,  2.336840283789e+00,  2.793772843067e+00,  3.454452805582e+00,  4.115132768097e+00,  4.775812730611e+00,  5.604454031909e+00,  6.601056671990e+00,  7.597659312071e+00,  8.594261952151e+00],
        [ 2.777159226742e-02,  3.611251046461e-01,  6.944786170247e-01,  1.027832129403e+00,  1.422975165232e+00,  1.879907724510e+00,  2.336840283789e+00,  2.793772843067e+00,  3.454452805582e+00,  4.115132768097e+00,  4.775812730611e+00,  5.604454031909e+00,  6.601056671990e+00,  7.597659312071e+00,  8.594261952151e+00],
        [ 2.777159226742e-02,  3.611251046461e-01,  6.944786170247e-01,  1.027832129403e+00,  1.422975165232e+00,  1.879907724510e+00,  2.336840283789e+00,  2.793772843067e+00,  3.454452805582e+00,  4.115132768097e+00,  4.775812730611e+00,  5.604454031909e+00,  6.601056671990e+00,  7.597659312071e+00,  8.594261952151e+00]],
       [[ 1.076748361520e-02,  3.409693025733e-01,  6.711711215313e-01,  1.001372940489e+00,  1.392341997617e+00,  1.844078292914e+00,  2.295814588211e+00,  2.747550883508e+00,  3.399663655069e+00,  4.051776426630e+00,  4.703889198191e+00,  5.521184449034e+00,  6.503662179158e+00,  7.486139909283e+00,  8.468617639408e+00],
        [ 1.076748361520e-02,  3.409693025733e-01,  6.711711215313e-01,  1.001372940489e+00,  1.392341997617e+00,  1.844078292914e+00,  2.295814588211e+00,  2.747550883508e+00,  3.399663655069e+00,  4.051776426630e+00,  4.703889198191e+00,  5.521184449034e+00,  6.503662179158e+00,  7.486139909283e+00,  8.468617639408e+00],
        [ 1.076748361520e-02,  3.409693025733e-01,  6.711711215313e-01,  1.001372940489e+00,  1.392341997617e+00,  1.844078292914e+00,  2.295814588211e+00,  2.747550883508e+00,  3.399663655069e+00,  4.051776426630e+00,  4.703889198191e+00,  5.521184449034e+00,  6.503662179158e+00,  7.486139909283e+00,  8.468617639408e+00]],
       [[-5.683069081956e-01, -3.454359107477e-01, -1.225649132997e-01,  1.003060841482e-01,  3.491304263080e-01,  6.239081131797e-01,  8.986858000514e-01,  1.173463486923e+00,  1.533820836739e+00,  1.894178186556e+00,  2.254535536372e+00,  2.685441391506e+00,  3.186895751959e+00,  3.688350112411e+00,  4.189804472863e+00],
        [-5.683069081956e-01, -3.454359107477e-01, -1.225649132997e-01,  1.003060841482e-01,  3.491304263080e-01,  6.239081131797e-01,  8.986858000514e-01,  1.173463486923e+00,  1.533820836739e+00,  1.894178186556e+00,  2.254535536372e+00,  2.685441391506e+00,  3.186895751959e+00,  3.688350112411e+00,  4.189804472863e+00],
        [-5.683069081956e-01, -3.454359107477e-01, -1.225649132997e-01,  1.003060841482e-01,  3.491304263080e-01,  6.239081131797e-01,  8.986858000514e-01,  1.173463486923e+00,  1.533820836739e+00,  1.894178186556e+00,  2.254535536372e+00,  2.685441391506e+00,  3.186895751959e+00,  3.688350112411e+00,  4.189804472863e+00]],
       [[-1.245305694724e+00, -1.147915701008e+00, -1.050525707291e+00, -9.531357135742e-01, -8.704934732403e-01, -8.025989862891e-01, -7.347044993379e-01, -6.668100123867e-01, -6.475453948298e-01, -6.282807772730e-01, -6.090161597161e-01, -6.298400921902e-01, -6.907525746952e-01, -7.516650572002e-01, -8.125775397052e-01],
        [-1.245305694724e+00, -1.147915701008e+00, -1.050525707291e+00, -9.531357135742e-01, -8.704934732403e-01, -8.025989862891e-01, -7.347044993379e-01, -6.668100123867e-01, -6.475453948298e-01, -6.282807772730e-01, -6.090161597161e-01, -6.298400921902e-01, -6.907525746952e-01, -7.516650572002e-01, -8.125775397052e-01],
        [-1.245305694724e+00, -1.147915701008e+00, -1.050525707291e+00, -9.531357135742e-01, -8.704934732403e-01, -8.025989862891e-01, -7.347044993379e-01, -6.668100123867e-01, -6.475453948298e-01, -6.282807772730e-01, -6.090161597161e-01, -6.298400921902e-01, -6.907525746952e-01, -7.516650572002e-01, -8.125775397052e-01]],
       [[-1.810212342580e+00, -1.817527194127e+00, -1.824842045675e+00, -1.832156897222e+00, -1.888181632286e+00, -1.992916250867e+00, -2.097650869448e+00, -2.202385488029e+00, -2.467738148705e+00, -2.733090809380e+00, -2.998443470056e+00, -3.396203321962e+00, -3.926370365098e+00, -4.456537408234e+00, -4.986704451370e+00],
        [-1.810212342580e+00, -1.817527194127e+00, -1.824842045675e+00, -1.832156897222e+00, -1.888181632286e+00, -1.992916250867e+00, -2.097650869448e+00, -2.202385488029e+00, -2.467738148705e+00, -2.733090809380e+00, -2.998443470056e+00, -3.396203321962e+00, -3.926370365098e+00, -4.456537408234e+00, -4.986704451370e+00],
        [-1.810212342580e+00, -1.817527194127e+00, -1.824842045675e+00, -1.832156897222e+00, -1.888181632286e+00, -1.992916250867e+00, -2.097650869448e+00, -2.202385488029e+00, -2.467738148705e+00, -2.733090809380e+00, -2.998443470056e+00, -3.396203321962e+00, -3.926370365098e+00, -4.456537408234e+00, -4.986704451370e+00]],
       [[-1.884872110363e+00, -1.906025070317e+00, -1.927178030272e+00, -1.948330990227e+00, -2.022682371334e+00, -2.150232173592e+00, -2.277781975851e+00, -2.405331778109e+00, -2.708300317409e+00, -3.011268856709e+00, -3.314237396009e+00, -3.761814236829e+00, -4.353999379169e+00, -4.946184521509e+00, -5.538369663849e+00],
        [-1.884872110363e+00, -1.906025070317e+00, -1.927178030272e+00, -1.948330990227e+00, -2.022682371334e+00, -2.150232173592e+00, -2.277781975851e+00, -2.405331778109e+00, -2.708300317409e+00, -3.011268856709e+00, -3.314237396009e+00, -3.761814236829e+00, -4.353999379169e+00, -4.946184521509e+00, -5.538369663849e+00],
        [-1.884872110363e+00, -1.906025070317e+00, -1.927178030272e+00, -1.948330990227e+00, -2.022682371334e+00, -2.150232173592e+00, -2.277781975851e+00, -2.405331778109e+00, -2.708300317409e+00, -3.011268856709e+00, -3.314237396009e+00, -3.761814236829e+00, -4.353999379169e+00, -4.946184521509e+00, -5.538369663849e+00]],
       [[-1.549202474521e+00, -1.508139425134e+00, -1.467076375746e+00, -1.426013326358e+00, -1.417968273803e+00, -1.442941218081e+00, -1.467914162359e+00, -1.492887106636e+00, -1.626734998302e+00, -1.760582889967e+00, -1.894430781632e+00, -2.118030894100e+00, -2.431383227370e+00, -2.744735560640e+00, -3.058087893910e+00],
        [-1.549202474521e+00, -1.508139425134e+00, -1.467076375746e+00, -1.426013326358e+00, -1.417968273803e+00, -1.442941218081e+00, -1.467914162359e+00, -1.492887106636e+00, -1.626734998302e+00, -1.760582889967e+00, -1.894430781632e+00, -2.118030894100e+00, -2.431383227370e+00, -2.744735560640e+00, -3.058087893910e+00],
        [-1.549202474521e+00, -1.508139425134e+00, -1.467076375746e+00, -1.426013326358e+00, -1.417968273803e+00, -1.442941218081e+00, -1.467914162359e+00, -1.492887106636e+00, -1.626734998302e+00, -1.760582889967e+00, -1.894430781632e+00, -2.118030894100e+00, -2.431383227370e+00, -2.744735560640e+00, -3.058087893910e+00]],
       [[-1.013363120154e+00, -8.729828173787e-01, -7.326025146034e-01, -5.922222118282e-01, -4.526452984756e-01, -3.138717745457e-01, -1.750982506158e-01, -3.632472668580e-02,  9.979966678464e-02,  2.359240602551e-01,  3.720484537255e-01,  5.059890083272e-01,  6.377457240602e-01,  7.695024397932e-01,  9.012591555262e-01],
        [-1.013363120154e+00, -8.729828173787e-01, -7.326025146034e-01, -5.922222118282e-01, -4.526452984756e-01, -3.138717745457e-01, -1.750982506158e-01, -3.632472668580e-02,  9.979966678464e-02,  2.359240602551e-01,  3.720484537255e-01,  5.059890083272e-01,  6.377457240602e-01,  7.695024397932e-01,  9.012591555262e-01],
        [-1.013363120154e+00, -8.729828173787e-01, -7.326025146034e-01, -5.922222118282e-01, -4.526452984756e-01, -3.138717745457e-01, -1.750982506158e-01, -3.632472668580e-02,  9.979966678464e-02,  2.359240602551e-01,  3.720484537255e-01,  5.059890083272e-01,  6.377457240602e-01,  7.695024397932e-01,  9.012591555262e-01]],
       [[-5.174836320724e-01, -2.851925945480e-01, -5.290155702354e-02,  1.793894805009e-01,  4.406893529215e-01,  7.309980602382e-01,  1.021306767555e+00,  1.311615474872e+00,  1.697579148451e+00,  2.083542822031e+00,  2.469506495610e+00,  2.934324357953e+00,  3.477996409058e+00,  4.021668460164e+00,  4.565340511269e+00],
        [-5.174836320724e-01, -2.851925945480e-01, -5.290155702354e-02,  1.793894805009e-01,  4.406893529215e-01,  7.309980602382e-01,  1.021306767555e+00,  1.311615474872e+00,  1.697579148451e+00,  2.083542822031e+00,  2.469506495610e+00,  2.934324357953e+00,  3.477996409058e+00,  4.021668460164e+00,  4.565340511269e+00],
        [-5.174836320724e-01, -2.851925945480e-01, -5.290155702354e-02,  1.793894805009e-01,  4.406893529215e-01,  7.309980602382e-01,  1.021306767555e+00,  1.311615474872e+00,  1.697579148451e+00,  2.083542822031e+00,  2.469506495610e+00,  2.934324357953e+00,  3.477996409058e+00,  4.021668460164e+00,  4.565340511269e+00]],
       [[-3.276473631522e-01, -6.017037545666e-02,  2.073066122389e-01,  4.747835999345e-01,  7.826823596790e-01,  1.131002891473e+00,  1.479323423266e+00,  1.827643955060e+00,  2.309252957607e+00,  2.790861960153e+00,  3.272470962700e+00,  3.863957733682e+00,  4.565322273099e+00,  5.266686812515e+00,  5.968051351932e+00],
        [-3.276473631522e-01, -6.017037545666e-02,  2.073066122389e-01,  4.747835999345e-01,  7.826823596790e-01,  1.131002891473e+00,  1.479323423266e+00,  1.827643955060e+00,  2.309252957607e+00,  2.790861960153e+00,  3.272470962700e+00,  3.863957733682e+00,  4.565322273099e+00,  5.266686812515e+00,  5.968051351932e+00],
        [-3.276473631522e-01, -6.017037545666e-02,  2.073066122389e-01,  4.747835999345e-01,  7.826823596790e-01,  1.131002891473e+00,  1.479323423266e+00,  1.827643955060e+00,  2.309252957607e+00,  2.790861960153e+00,  3.272470962700e+00,  3.863957733682e+00,  4.565322273099e+00,  5.266686812515e+00,  5.968051351932e+00]],
       [[-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-5.812139446351e+00, -5.812139446351e+00, -5.812139446351e+00],
        [-5.812139446351e+00, -5.812139446351e+00, -5.812139446351e+00],
        [-5.812139446351e+00, -5.812139446351e+00, -5.812139446351e+00]],
       [[-5.799984934354e-01, -5.799984934354e-01, -5.799984934354e-01],
        [-5.799984934354e-01, -5.799984934354e-01, -5.799984934354e-01],
        [-5.799984934354e-01, -5.799984934354e-01, -5.799984934354e-01]],
       [[ 6.116083816267e+00,  6.116083816267e+00,  6.116083816267e+00],
        [ 6.116083816267e+00,  6.116083816267e+00,  6.116083816267e+00],
        [ 6.116083816267e+00,  6.116083816267e+00,  6.116083816267e+00]],
       [[ 8.594261952151e+00,  8.594261952151e+00,  8.594261952151e+00],
        [ 8.594261952151e+00,  8.594261952151e+00,  8.594261952151e+00],
        [ 8.594261952151e+00,  8.594261952151e+00,  8.594261952151e+00]],
       [[ 8.468617639408e+00,  8.468617639408e+00,  8.468617639408e+00],
        [ 8.468617639408e+00,  8.468617639408e+00,  8.468617639408e+00],
        [ 8.468617639408e+00,  8.468617639408e+00,  8.468617639408e+00]],
       [[ 4.189804472863e+00,  4.189804472863e+00,  4.189804472863e+00],
        [ 4.189804472863e+00,  4.189804472863e+00,  4.189804472863e+00],
        [ 4.189804472863e+00,  4.189804472863e+00,  4.189804472863e+00]],
       [[-8.125775397052e-01, -8.125775397052e-01, -8.125775397052e-01],
        [-8.125775397052e-01, -8.125775397052e-01, -8.125775397052e-01],
        [-8.125775397052e-01, -8.125775397052e-01, -8.125775397052e-01]],
       [[-4.986704451370e+00, -4.986704451370e+00, -4.986704451370e+00],
        [-4.986704451370e+00, -4.986704451370e+00, -4.986704451370e+00],
        [-4.986704451370e+00, -4.986704451370e+00, -4.986704451370e+00]],
       [[-5.538369663849e+00, -5.538369663849e+00, -5.538369663849e+00],
        [-5.538369663849e+00, -5.538369663849e+00, -5.538369663849e+00],
        [-5.538369663849e+00, -5.538369663849e+00, -5.538369663849e+00]],
       [[-3.058087893910e+00, -3.058087893910e+00, -3.058087893910e+00],
        [-3.058087893910e+00, -3.058087893910e+00, -3.058087893910e+00],
        [-3.058087893910e+00, -3.058087893910e+00, -3.058087893910e+00]],
       [[ 9.012591555262e-01,  9.012591555262e-01,  9.012591555262e-01],
        [ 9.012591555262e-01,  9.012591555262e-01,  9.012591555262e-01],
        [ 9.012591555262e-01,  9.012591555262e-01,  9.012591555262e-01]],
       [[ 4.565340511269e+00,  4.565340511269e+00,  4.565340511269e+00],
        [ 4.565340511269e+00,  4.565340511269e+00,  4.565340511269e+00],
        [ 4.565340511269e+00,  4.565340511269e+00,  4.565340511269e+00]],
       [[ 5.968051351932e+00,  5.968051351932e+00,  5.968051351932e+00],
        [ 5.968051351932e+00,  5.968051351932e+00,  5.968051351932e+00],
        [ 5.968051351932e+00,  5.968051351932e+00,  5.968051351932e+00]],
       [[ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x sup
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.034297462802e+00, -1.034297462802e+00, -1.034297462802e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.051446194203e+00, -1.051446194203e+00, -1.051446194203e+00],
        [-1.017148731401e+00, -1.017148731401e+00, -1.017148731401e+00],
        [-9.485538057967e-01, -9.485538057967e-01, -9.485538057967e-01],
        [-8.456614173902e-01, -8.456614173902e-01, -8.456614173902e-01],
        [-7.256202975827e-01, -7.256202975827e-01, -7.256202975827e-01],
        [-5.541329835718e-01, -5.541329835718e-01, -5.541329835718e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.034297462802e+00, -1.034297462802e+00, -1.034297462802e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.051446194203e+00, -1.051446194203e+00, -1.051446194203e+00],
        [-1.017148731401e+00, -1.017148731401e+00, -1.017148731401e+00],
        [-9.485538057967e-01, -9.485538057967e-01, -9.485538057967e-01],
        [-8.456614173902e-01, -8.456614173902e-01, -8.456614173902e-01],
        [-7.256202975827e-01, -7.256202975827e-01, -7.256202975827e-01],
        [-5.541329835718e-01, -5.541329835718e-01, -5.541329835718e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.034297462802e+00, -1.034297462802e+00, -1.034297462802e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.051446194203e+00, -1.051446194203e+00, -1.051446194203e+00],
        [-1.017148731401e+00, -1.017148731401e+00, -1.017148731401e+00],
        [-9.485538057967e-01, -9.485538057967e-01, -9.485538057967e-01],
        [-8.456614173902e-01, -8.456614173902e-01, -8.456614173902e-01],
        [-7.256202975827e-01, -7.256202975827e-01, -7.256202975827e-01],
        [-5.541329835718e-01, -5.541329835718e-01, -5.541329835718e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034297462802e+00, -8.977973181310e-01, -7.612971734598e-01, -6.247970287886e-01, -4.903588440879e-01, -3.579826193577e-01, -2.256063946276e-01, -9.323016989738e-02,  3.234686030735e-02,  1.579238905121e-01,  2.835009207168e-01,  4.034729626027e-01,  5.178400161697e-01,  6.322070697368e-01,  7.465741233038e-01],
        [-1.068594925604e+00, -9.384517791191e-01, -8.083086326338e-01, -6.781654861486e-01, -5.521462596044e-01, -4.302509530012e-01, -3.083556463980e-01, -1.864603397948e-01, -7.816342224244e-02,  3.013349530990e-02,  1.384304128622e-01,  2.355173537768e-01,  3.213943180538e-01,  4.072712823307e-01,  4.931482466076e-01],
        [-1.051446194203e+00, -9.181245486250e-01, -7.848029030468e-01, -6.514812574686e-01, -5.212525518461e-01, -3.941167861794e-01, -2.669810205128e-01, -1.398452548461e-01, -2.290828096754e-02,  9.402869291099e-02,  2.109656667895e-01,  3.194951581898e-01,  4.196171671117e-01,  5.197391760337e-01,  6.198611849557e-01],
        [-1.017148731401e+00, -8.774700876369e-01, -7.377914438727e-01, -5.981128001086e-01, -4.594651363297e-01, -3.218484525360e-01, -1.842317687423e-01, -4.661508494869e-02,  8.760200158225e-02,  2.218190881132e-01,  3.560361746441e-01,  4.874507670156e-01,  6.160628652277e-01,  7.446749634398e-01,  8.732870616519e-01],
        [-9.485538057967e-01, -7.961611656607e-01, -6.437685255246e-01, -4.913758853886e-01, -3.358903052967e-01, -1.773117852491e-01, -1.873326520153e-02,  1.398452548461e-01,  3.086225666818e-01,  4.773998785176e-01,  6.461771903533e-01,  8.233619846674e-01,  1.008954261460e+00,  1.194546538252e+00,  1.380138815044e+00],
        [-8.456614173902e-01, -6.741977826963e-01, -5.027341480024e-01, -3.312705133085e-01, -1.505280587473e-01,  3.949321568119e-02,  2.295144901097e-01,  4.195357645382e-01,  6.401534143312e-01,  8.607710641242e-01,  1.081388713917e+00,  1.327228811145e+00,  1.598291355808e+00,  1.869353900470e+00,  2.140416445133e+00],
        [-7.256202975827e-01, -5.319071692379e-01, -3.381940408932e-01, -1.444809125485e-01,  6.572789556031e-02,  2.924323834332e-01,  5.191368713061e-01,  7.458413591791e-01,  1.026939403255e+00,  1.308037447332e+00,  1.589135491408e+00,  1.915073442035e+00,  2.285851299214e+00,  2.656629156392e+00,  3.027407013570e+00],
        [-5.541329835718e-01, -3.286348642974e-01, -1.031367450229e-01,  1.223613742515e-01,  3.746649731426e-01,  6.537740516504e-01,  9.328831301582e-01,  1.211992208666e+00,  1.579490816004e+00,  1.946989423343e+00,  2.314488030681e+00,  2.754851486165e+00,  3.268079789793e+00,  3.781308093422e+00,  4.294536397051e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034297462802e+00, -8.977973181310e-01, -7.612971734598e-01, -6.247970287886e-01, -4.903588440879e-01, -3.579826193577e-01, -2.256063946276e-01, -9.323016989738e-02,  3.234686030735e-02,  1.579238905121e-01,  2.835009207168e-01,  4.034729626027e-01,  5.178400161697e-01,  6.322070697368e-01,  7.465741233038e-01],
        [-1.068594925604e+00, -9.384517791191e-01, -8.083086326338e-01, -6.781654861486e-01, -5.521462596044e-01, -4.302509530012e-01, -3.083556463980e-01, -1.864603397948e-01, -7.816342224244e-02,  3.013349530990e-02,  1.384304128622e-01,  2.355173537768e-01,  3.213943180538e-01,  4.072712823307e-01,  4.931482466076e-01],
        [-1.051446194203e+00, -9.181245486250e-01, -7.848029030468e-01, -6.514812574686e-01, -5.212525518461e-01, -3.941167861794e-01, -2.669810205128e-01, -1.398452548461e-01, -2.290828096754e-02,  9.402869291099e-02,  2.109656667895e-01,  3.194951581898e-01,  4.196171671117e-01,  5.197391760337e-01,  6.198611849557e-01],
        [-1.017148731401e+00, -8.774700876369e-01, -7.377914438727e-01, -5.981128001086e-01, -4.594651363297e-01, -3.218484525360e-01, -1.842317687423e-01, -4.661508494869e-02,  8.760200158225e-02,  2.218190881132e-01,  3.560361746441e-01,  4.874507670156e-01,  6.160628652277e-01,  7.446749634398e-01,  8.732870616519e-01],
        [-9.485538057967e-01, -7.961611656607e-01, -6.437685255246e-01, -4.913758853886e-01, -3.358903052967e-01, -1.773117852491e-01, -1.873326520153e-02,  1.398452548461e-01,  3.086225666818e-01,  4.773998785176e-01,  6.461771903533e-01,  8.233619846674e-01,  1.008954261460e+00,  1.194546538252e+00,  1.380138815044e+00],
        [-8.456614173902e-01, -6.741977826963e-01, -5.027341480024e-01, -3.312705133085e-01, -1.505280587473e-01,  3.949321568119e-02,  2.295144901097e-01,  4.195357645382e-01,  6.401534143312e-01,  8.607710641242e-01,  1.081388713917e+00,  1.327228811145e+00,  1.598291355808e+00,  1.869353900470e+00,  2.140416445133e+00],
        [-7.256202975827e-01, -5.319071692379e-01, -3.381940408932e-01, -1.444809125485e-01,  6.572789556031e-02,  2.924323834332e-01,  5.191368713061e-01,  7.458413591791e-01,  1.026939403255e+00,  1.308037447332e+00,  1.589135491408e+00,  1.915073442035e+00,  2.285851299214e+00,  2.656629156392e+00,  3.027407013570e+00],
        [-5.541329835718e-01, -3.286348642974e-01, -1.031367450229e-01,  1.223613742515e-01,  3.746649731426e-01,  6.537740516504e-01,  9.328831301582e-01,  1.211992208666e+00,  1.579490816004e+00,  1.946989423343e+00,  2.314488030681e+00,  2.754851486165e+00,  3.268079789793e+00,  3.781308093422e+00,  4.294536397051e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034297462802e+00, -8.977973181310e-01, -7.612971734598e-01, -6.247970287886e-01, -4.903588440879e-01, -3.579826193577e-01, -2.256063946276e-01, -9.323016989738e-02,  3.234686030735e-02,  1.579238905121e-01,  2.835009207168e-01,  4.034729626027e-01,  5.178400161697e-01,  6.322070697368e-01,  7.465741233038e-01],
        [-1.068594925604e+00, -9.384517791191e-01, -8.083086326338e-01, -6.781654861486e-01, -5.521462596044e-01, -4.302509530012e-01, -3.083556463980e-01, -1.864603397948e-01, -7.816342224244e-02,  3.013349530990e-02,  1.384304128622e-01,  2.355173537768e-01,  3.213943180538e-01,  4.072712823307e-01,  4.931482466076e-01],
        [-1.051446194203e+00, -9.181245486250e-01, -7.848029030468e-01, -6.514812574686e-01, -5.212525518461e-01, -3.941167861794e-01, -2.669810205128e-01, -1.398452548461e-01, -2.290828096754e-02,  9.402869291099e-02,  2.109656667895e-01,  3.194951581898e-01,  4.196171671117e-01,  5.197391760337e-01,  6.198611849557e-01],
        [-1.017148731401e+00, -8.774700876369e-01, -7.377914438727e-01, -5.981128001086e-01, -4.594651363297e-01, -3.218484525360e-01, -1.842317687423e-01, -4.661508494869e-02,  8.760200158225e-02,  2.218190881132e-01,  3.560361746441e-01,  4.874507670156e-01,  6.160628652277e-01,  7.446749634398e-01,  8.732870616519e-01],
        [-9.485538057967e-01, -7.961611656607e-01, -6.437685255246e-01, -4.913758853886e-01, -3.358903052967e-01, -1.773117852491e-01, -1.873326520153e-02,  1.398452548461e-01,  3.086225666818e-01,  4.773998785176e-01,  6.461771903533e-01,  8.233619846674e-01,  1.008954261460e+00,  1.194546538252e+00,  1.380138815044e+00],
        [-8.456614173902e-01, -6.741977826963e-01, -5.027341480024e-01, -3.312705133085e-01, -1.505280587473e-01,  3.949321568119e-02,  2.295144901097e-01,  4.195357645382e-01,  6.401534143312e-01,  8.607710641242e-01,  1.081388713917e+00,  1.327228811145e+00,  1.598291355808e+00,  1.869353900470e+00,  2.140416445133e+00],
        [-7.256202975827e-01, -5.319071692379e-01, -3.381940408932e-01, -1.444809125485e-01,  6.572789556031e-02,  2.924323834332e-01,  5.191368713061e-01,  7.458413591791e-01,  1.026939403255e+00,  1.308037447332e+00,  1.589135491408e+00,  1.915073442035e+00,  2.285851299214e+00,  2.656629156392e+00,  3.027407013570e+00],
        [-5.541329835718e-01, -3.286348642974e-01, -1.031367450229e-01,  1.223613742515e-01,  3.746649731426e-01,  6.537740516504e-01,  9.328831301582e-01,  1.211992208666e+00,  1.579490816004e+00,  1.946989423343e+00,  2.314488030681e+00,  2.754851486165e+00,  3.268079789793e+00,  3.781308093422e+00,  4.294536397051e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.465741233038e-01,  7.465741233038e-01,  7.465741233038e-01],
        [ 4.931482466076e-01,  4.931482466076e-01,  4.931482466076e-01],
        [ 6.198611849557e-01,  6.198611849557e-01,  6.198611849557e-01],
        [ 8.732870616519e-01,  8.732870616519e-01,  8.732870616519e-01],
        [ 1.380138815044e+00,  1.380138815044e+00,  1.380138815044e+00],
        [ 2.140416445133e+00,  2.140416445133e+00,  2.140416445133e+00],
        [ 3.027407013570e+00,  3.027407013570e+00,  3.027407013570e+00],
        [ 4.294536397051e+00,  4.294536397051e+00,  4.294536397051e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.465741233038e-01,  7.465741233038e-01,  7.465741233038e-01],
        [ 4.931482466076e-01,  4.931482466076e-01,  4.931482466076e-01],
        [ 6.198611849557e-01,  6.198611849557e-01,  6.198611849557e-01],
        [ 8.732870616519e-01,  8.732870616519e-01,  8.732870616519e-01],
        [ 1.380138815044e+00,  1.380138815044e+00,  1.380138815044e+00],
        [ 2.140416445133e+00,  2.140416445133e+00,  2.140416445133e+00],
        [ 3.027407013570e+00,  3.027407013570e+00,  3.027407013570e+00],
        [ 4.294536397051e+00,  4.294536397051e+00,  4.294536397051e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.465741233038e-01,  7.465741233038e-01,  7.465741233038e-01],
        [ 4.931482466076e-01,  4.931482466076e-01,  4.931482466076e-01],
        [ 6.198611849557e-01,  6.198611849557e-01,  6.198611849557e-01],
        [ 8.732870616519e-01,  8.732870616519e-01,  8.732870616519e-01],
        [ 1.380138815044e+00,  1.380138815044e+00,  1.380138815044e+00],
        [ 2.140416445133e+00,  2.140416445133e+00,  2.140416445133e+00],
        [ 3.027407013570e+00,  3.027407013570e+00,  3.027407013570e+00],
        [ 4.294536397051e+00,  4.294536397051e+00,  4.294536397051e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]],
       [[-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]],
       [[-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01],
        [-3.826456695610e-01, -3.826456695610e-01, -3.826456695610e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]],
       [[-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]],
       [[-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00],
        [-3.826456695610e-01, -1.253625593568e-01,  1.319205508474e-01,  3.892036610516e-01,  6.836020507250e-01,  1.015115719868e+00,  1.346629389010e+00,  1.678143058153e+00,  2.132042228753e+00,  2.585941399354e+00,  3.039840569954e+00,  3.594629530294e+00,  4.250308280373e+00,  4.905987030453e+00,  5.561665780532e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]],
       [[ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]],
       [[ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00],
        [ 5.561665780532e+00,  5.561665780532e+00,  5.561665780532e+00]]
                ], dtype=np.float64)
            ]
        ]
                               ]

# Linearly extrapolated data sampled on self.xsamples_ex,
# self.ysamples_ex and self.zsamples_ex.
# Calculated from the nearest trilinear part of the interpolation f:
# if f is known at 8 points (xn, yn, zn), (xn, yn, zr), (xn, yr, zn),
# (xn, yr, zr), (xr, yn, zn), (xr, yn, zr), (xr, yr, zn) & (xr, yr, zr)
# (inside the interpolation area), one can calculate the value of f on
# every point (x, y) aligned with (xn, yn, zn) and (xr, yr, zr) (in the
# extrapolation area in particular) via this formula:
# f(x, y, z) = f(xn, yn, zn) + (x-xn)*(f(xn, yn, zn)-f(xr, yn, zn))/(xn-xr)
#                            + (y-yn)*(f(xn, yn, zn)-f(xn, yr, zn))/(yn-yr)
#                            + (z-zn)*(f(xn, yn, zn)-f(xn, yn, zr))/(zn-zr)
#                            + (x-xn)*(y-yn)*(f(xn, yn, zn)-f(xr, yn, zn)-f(xn, yr, zn)+f(xr, yr, zn))/(xn-xr)/(yn-yr)
#                            + (y-yn)*(z-zn)*(f(xn, yn, zn)-f(xn, yr, zn)-f(xn, yn, zr)+f(xn, yr, zr))/(yn-yr)/(zn-zr)
#                            + (z-zn)*(x-xn)*(f(xn, yn, zn)-f(xn, yn, zr)-f(xr, yn, zn)+f(xr, yn, zr))/(zn-zr)/(xn-xr)
#                            + (x-xn)*(y-yn)*(z-zn)*(f(xn, yn, zn)-f(xr, yn, zn)-f(xn, yr, zn)+f(xr, yr, zn)-f(xn, yn, zr)+f(xr, yn, zr)+f(xn, yr, zr)-f(xr, yr, zr))/(xn-xr)/(yn-yr)/(zn-zr)
linear_linear_extrapolated_data = [
        [  # x inf
            [  # y inf
                np.array([  # z inf
       [[-1.125682222317e+00, -1.062310832000e+00, -9.989394416836e-01],
        [-1.138551388948e+00, -1.076444270000e+00, -1.014337151052e+00],
        [-1.151420555579e+00, -1.090577708000e+00, -1.029734860421e+00]],
       [[-1.129806057411e+00, -1.066839794076e+00, -1.003873530742e+00],
        [-1.141128785882e+00, -1.079274871298e+00, -1.017420956714e+00],
        [-1.152451514353e+00, -1.091709948519e+00, -1.030968382685e+00]],
       [[-1.133929892505e+00, -1.071368756152e+00, -1.008807619800e+00],
        [-1.143706182816e+00, -1.082105472595e+00, -1.020504762375e+00],
        [-1.153482473126e+00, -1.092842189038e+00, -1.032201904950e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.566918481391e-01, -8.058075854799e-01, -6.549233228208e-01, -5.040390601617e-01, -3.505511158236e-01, -1.944594898065e-01, -3.836786378937e-02,  1.177237622277e-01,  2.824008789774e-01,  4.470779957272e-01,  6.117551124769e-01,  7.835097698217e-01,  9.623419677616e-01,  1.141174165702e+00,  1.320006363641e+00],
        [-9.729324050869e-01, -8.250583123535e-01, -6.771842196202e-01, -5.293101268868e-01, -3.798087331040e-01, -2.286800382719e-01, -7.755134343979e-02,  7.357735139234e-02,  2.300719779323e-01,  3.865666044723e-01,  5.430612310123e-01,  7.039793204243e-01,  8.693208727082e-01,  1.034662424992e+00,  1.200003977276e+00],
        [-9.891729620348e-01, -8.443090392271e-01, -6.994451164195e-01, -5.545811936119e-01, -4.090663503845e-01, -2.629005867373e-01, -1.167348230902e-01,  2.943094055694e-02,  1.777430768872e-01,  3.260552132175e-01,  4.743673495478e-01,  6.244488710269e-01,  7.762997776547e-01,  9.281506842825e-01,  1.080001590910e+00]],
       [[-9.618960218518e-01, -8.119763472452e-01, -6.620566726386e-01, -5.121369980320e-01, -3.599265161400e-01, -2.054252269626e-01, -5.092393778511e-02,  1.035773513923e-01,  2.656324459669e-01,  4.276875405415e-01,  5.897426351160e-01,  7.580247895071e-01,  9.325340037146e-01,  1.107043217922e+00,  1.281552432130e+00],
        [-9.761850136574e-01, -8.289137884568e-01, -6.816425632563e-01, -5.343713380557e-01, -3.856683583018e-01, -2.355336239945e-01, -8.539888968712e-02,  6.473584462021e-02,  2.195917073007e-01,  3.744475699813e-01,  5.293034326618e-01,  6.880512077276e-01,  8.506908951788e-01,  1.013330582630e+00,  1.175970270081e+00],
        [-9.904740054629e-01, -8.458512296684e-01, -7.012284538739e-01, -5.566056780794e-01, -4.114102004636e-01, -2.656420210264e-01, -1.198738415891e-01,  2.589433784808e-02,  1.735509686346e-01,  3.212075994211e-01,  4.688642302076e-01,  6.180776259482e-01,  7.688477866429e-01,  9.196179473377e-01,  1.070388108032e+00]],
       [[-9.671001955645e-01, -8.181451090104e-01, -6.691900224564e-01, -5.202349359023e-01, -3.693019164564e-01, -2.163909641186e-01, -6.348001178084e-02,  8.943094055694e-02,  2.488640129564e-01,  4.082970853558e-01,  5.677301577552e-01,  7.325398091925e-01,  9.027260396676e-01,  1.072912270143e+00,  1.243098500618e+00],
        [-9.794376222278e-01, -8.327692645601e-01, -6.861009068924e-01, -5.394325492247e-01, -3.915279834995e-01, -2.423872097170e-01, -9.324643593445e-02,  5.589433784808e-02,  2.091114366692e-01,  3.623285354902e-01,  5.155456343113e-01,  6.721230950310e-01,  8.320609176494e-01,  9.919987402678e-01,  1.151936562886e+00],
        [-9.917750488911e-01, -8.473934201097e-01, -7.030117913284e-01, -5.586301625470e-01, -4.137540505427e-01, -2.683834553154e-01, -1.230128600881e-01,  2.235773513923e-02,  1.693588603819e-01,  3.163599856247e-01,  4.633611108674e-01,  6.117063808696e-01,  7.613957956312e-01,  9.110852103928e-01,  1.060774625154e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.370079379065e+00,  1.445188902199e+00,  1.520298425334e+00],
        [ 1.246299611915e+00,  1.315743063875e+00,  1.385186515834e+00],
        [ 1.122519844766e+00,  1.186297225550e+00,  1.250074606334e+00]],
       [[ 1.330415012108e+00,  1.403708882075e+00,  1.477002752042e+00],
        [ 1.221509382567e+00,  1.289818051297e+00,  1.358126720026e+00],
        [ 1.112603753027e+00,  1.175927220519e+00,  1.239250688011e+00]],
       [[ 1.290750645151e+00,  1.362228861951e+00,  1.433707078750e+00],
        [ 1.196719153219e+00,  1.263893038719e+00,  1.331066924219e+00],
        [ 1.102687661288e+00,  1.165557215488e+00,  1.228426769688e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.207663580115e+00, -1.152346066666e+00, -1.097028553217e+00],
        [-1.255327160230e+00, -1.204692133332e+00, -1.154057106434e+00],
        [-1.371037215893e+00, -1.331769584776e+00, -1.292501953659e+00],
        [-1.509429430073e+00, -1.483757497813e+00, -1.458085565553e+00],
        [-1.693185961286e+00, -1.685566334035e+00, -1.677946706784e+00],
        [-1.922306809531e+00, -1.937196093443e+00, -1.952085377354e+00],
        [-2.174109816292e+00, -2.213736314443e+00, -2.253362812593e+00],
        [-2.493959298602e+00, -2.565007920221e+00, -2.636056541840e+00],
        [-2.813808780912e+00, -2.916279525999e+00, -3.018750271086e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.201936031373e+00, -1.146055841561e+00, -1.090175651748e+00],
        [-1.243872062747e+00, -1.192111683121e+00, -1.140351303496e+00],
        [-1.346556582041e+00, -1.304883965009e+00, -1.263211347978e+00],
        [-1.469490597308e+00, -1.439895060340e+00, -1.410299523373e+00],
        [-1.632923604522e+00, -1.619383782556e+00, -1.605843960591e+00],
        [-1.836855603683e+00, -1.843350131658e+00, -1.849844659632e+00],
        [-2.061037098817e+00, -2.089555294201e+00, -2.118073489585e+00],
        [-2.345967081872e+00, -2.402476897073e+00, -2.458986712273e+00],
        [-2.630897064927e+00, -2.715398499944e+00, -2.799899934961e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.196208482632e+00, -1.139765616455e+00, -1.083322750278e+00],
        [-1.232416965264e+00, -1.179531232910e+00, -1.126645500557e+00],
        [-1.322075948188e+00, -1.277998345243e+00, -1.233920742298e+00],
        [-1.429551764542e+00, -1.396032622868e+00, -1.362513481193e+00],
        [-1.572661247758e+00, -1.553201231078e+00, -1.533741214397e+00],
        [-1.751404397835e+00, -1.749504169873e+00, -1.747603941910e+00],
        [-1.947964381343e+00, -1.965374273960e+00, -1.982784166577e+00],
        [-2.197974865143e+00, -2.239945873925e+00, -2.281916882706e+00],
        [-2.447985348943e+00, -2.514517473889e+00, -2.581049598836e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.060150210918e+00, -9.284418455636e-01, -7.967334802092e-01, -6.650251148548e-01, -5.369329740545e-01, -4.124570578085e-01, -2.879811415624e-01, -1.635052253163e-01, -5.095360175439e-02,  6.159802180752e-02,  1.741496453694e-01,  2.768713514381e-01,  3.697631400136e-01,  4.626549285891e-01,  5.555467171646e-01],
        [-1.120300421836e+00, -9.997408339843e-01, -8.791812461326e-01, -7.586216582810e-01, -6.452945195376e-01, -5.391998299026e-01, -4.331051402676e-01, -3.270104506326e-01, -2.447643463659e-01, -1.625182420992e-01, -8.027213783256e-02, -1.768586855231e-02,  2.524056574152e-02,  6.816700003534e-02,  1.110934343292e-01],
        [-1.266323532914e+00, -1.172829173111e+00, -1.079334813308e+00, -9.858404535049e-01, -9.083574373760e-01, -8.468857649211e-01, -7.854140924662e-01, -7.239424200113e-01, -7.152672333323e-01, -7.065920466533e-01, -6.979168599743e-01, -7.327650178537e-01, -8.111365202916e-01, -8.895080227295e-01, -9.678795251674e-01],
        [-1.440970944046e+00, -1.379847295806e+00, -1.318723647567e+00, -1.257599999328e+00, -1.222987479333e+00, -1.214886087581e+00, -1.206784695829e+00, -1.198683304077e+00, -1.278000834417e+00, -1.357318364756e+00, -1.436635895096e+00, -1.588018143592e+00, -1.811465110245e+00, -2.034912076898e+00, -2.258359043551e+00],
        [-1.672866955284e+00, -1.654724985639e+00, -1.636583015995e+00, -1.618441046350e+00, -1.640751769526e+00, -1.703515185524e+00, -1.766278601521e+00, -1.829042017519e+00, -2.025195863738e+00, -2.221349709958e+00, -2.417503556177e+00, -2.723619222205e+00, -3.139696708039e+00, -3.555774193874e+00, -3.971851679709e+00],
        [-1.962011566629e+00, -1.997462242609e+00, -2.032912918590e+00, -2.068363594570e+00, -2.161650307957e+00, -2.312773058749e+00, -2.463895809542e+00, -2.615018560335e+00, -2.956852321296e+00, -3.298686082257e+00, -3.640519843219e+00, -4.139568253691e+00, -4.795831313674e+00, -5.452094373657e+00, -6.108357433641e+00],
        [-2.279780478027e+00, -2.374129283148e+00, -2.468478088269e+00, -2.562826893390e+00, -2.734115970506e+00, -2.982345319617e+00, -3.230574668727e+00, -3.478804017838e+00, -3.980739492972e+00, -4.482674968106e+00, -4.984610443240e+00, -5.695691261614e+00, -6.615917423229e+00, -7.536143584845e+00, -8.456369746460e+00],
        [-2.683422289586e+00, -2.852585674393e+00, -3.021749059200e+00, -3.190912444007e+00, -3.461283005410e+00, -3.832860743408e+00, -4.204438481406e+00, -4.576016219404e+00, -5.281318807003e+00, -5.986621394602e+00, -6.691923982201e+00, -7.672336198849e+00, -8.927858044546e+00, -1.018337989024e+01, -1.143890173594e+01],
        [-3.087064101144e+00, -3.331042065638e+00, -3.575020030131e+00, -3.818997994625e+00, -4.188450040314e+00, -4.683376167199e+00, -5.178302294085e+00, -5.673228420970e+00, -6.581898121034e+00, -7.490567821098e+00, -8.399237521162e+00, -9.648981136083e+00, -1.123979866586e+01, -1.283061619564e+01, -1.442143372542e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.052922191873e+00, -9.198741208896e-01, -7.868260499067e-01, -6.537779789238e-01, -5.239115847262e-01, -3.972268673139e-01, -2.705421499016e-01, -1.438574324894e-01, -2.766411146197e-02,  8.852920956541e-02,  2.047225305928e-01,  3.122671574306e-01,  4.111630900789e-01,  5.100590227271e-01,  6.089549553754e-01],
        [-1.105844383745e+00, -9.826053846364e-01, -8.593663855277e-01, -7.361273864190e-01, -6.192517408810e-01, -5.087394489135e-01, -3.982271569461e-01, -2.877148649787e-01, -1.981853657811e-01, -1.086558665835e-01, -1.912636738584e-02,  5.310574343267e-02,  1.080404658720e-01,  1.629751883114e-01,  2.179099107508e-01],
        [-1.235429603291e+00, -1.136209086550e+00, -1.036988569809e+00, -9.377680530686e-01, -8.527015400995e-01, -7.817890309020e-01, -7.108765217046e-01, -6.399640125071e-01, -6.157235174773e-01, -5.914830224476e-01, -5.672425274179e-01, -5.814766036405e-01, -6.341852511156e-01, -6.868938985907e-01, -7.396025460657e-01],
        [-1.390569165395e+00, -1.320103601186e+00, -1.249638036978e+00, -1.179172472770e+00, -1.132187887006e+00, -1.108684279687e+00, -1.085180672368e+00, -1.061677065048e+00, -1.115600634966e+00, -1.169524204884e+00, -1.223447774801e+00, -1.341199261739e+00, -1.522778665697e+00, -1.704358069655e+00, -1.885937473613e+00],
        [-1.596817412614e+00, -1.564579741267e+00, -1.532342069920e+00, -1.500104398574e+00, -1.503747329288e+00, -1.543270862064e+00, -1.582794394840e+00, -1.622317927616e+00, -1.780155684039e+00, -1.937993440463e+00, -2.095831196887e+00, -2.351202541887e+00, -2.704107475465e+00, -3.057012409043e+00, -3.409917342621e+00],
        [-1.854174344948e+00, -1.869637506793e+00, -1.885100668637e+00, -1.900563830481e+00, -1.967379866947e+00, -2.085548778034e+00, -2.203717689122e+00, -2.321886600209e+00, -2.609388664698e+00, -2.896890729186e+00, -3.184392793674e+00, -3.611486444086e+00, -4.178171680421e+00, -4.744856916756e+00, -5.311542153091e+00],
        [-2.137085619841e+00, -2.204986085040e+00, -2.272886550240e+00, -2.340787015439e+00, -2.477048952293e+00, -2.681672360800e+00, -2.886295769308e+00, -3.090919177815e+00, -3.520960611148e+00, -3.951002044481e+00, -4.381043477813e+00, -4.996910657310e+00, -5.798603582970e+00, -6.600296508631e+00, -7.401989434291e+00],
        [-2.496659922407e+00, -2.631207101455e+00, -2.765754280504e+00, -2.900301459552e+00, -3.124827680703e+00, -3.439332943955e+00, -3.753838207208e+00, -4.068343470461e+00, -4.679549454976e+00, -5.290755439491e+00, -5.901961424005e+00, -6.757755803609e+00, -7.858138578300e+00, -8.958521352992e+00, -1.005890412768e+01],
        [-2.856234224972e+00, -3.057428117870e+00, -3.258622010767e+00, -3.459815903665e+00, -3.772606409113e+00, -4.196993527110e+00, -4.621380645108e+00, -5.045767763106e+00, -5.838138298803e+00, -6.630508834500e+00, -7.422879370198e+00, -8.518600949908e+00, -9.917673573630e+00, -1.131674619735e+01, -1.271581882108e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.045694172827e+00, -9.113063962157e-01, -7.769186196043e-01, -6.425308429928e-01, -5.108901953979e-01, -3.819966768194e-01, -2.531031582409e-01, -1.242096396624e-01, -4.374621169554e-03,  1.154603973233e-01,  2.352954158162e-01,  3.476629634231e-01,  4.525630401441e-01,  5.574631168652e-01,  6.623631935862e-01],
        [-1.091388345654e+00, -9.654699352885e-01, -8.395515249228e-01, -7.136331145571e-01, -5.932089622243e-01, -4.782790679245e-01, -3.633491736246e-01, -2.484192793248e-01, -1.516063851963e-01, -5.479349106768e-02,  4.201940306089e-02,  1.238973554176e-01,  1.908403660026e-01,  2.577833765875e-01,  3.247263871725e-01],
        [-1.204535673668e+00, -1.099588999989e+00, -9.946423263108e-01, -8.896956526323e-01, -7.970456428231e-01, -7.166922968830e-01, -6.363389509429e-01, -5.559856050028e-01, -5.161798016224e-01, -4.763739982419e-01, -4.365681948615e-01, -4.301881894274e-01, -4.572339819396e-01, -4.842797744518e-01, -5.113255669640e-01],
        [-1.340167386744e+00, -1.260359906566e+00, -1.180552426389e+00, -1.100744946211e+00, -1.041388294679e+00, -1.002482471793e+00, -9.635766489060e-01, -9.246708260194e-01, -9.532004355150e-01, -9.817300450106e-01, -1.010259654506e+00, -1.094380379886e+00, -1.234092221149e+00, -1.373804062412e+00, -1.513515903675e+00],
        [-1.520767869944e+00, -1.474434496895e+00, -1.428101123846e+00, -1.381767750798e+00, -1.366742889050e+00, -1.383026538605e+00, -1.399310188159e+00, -1.415593837713e+00, -1.535115504341e+00, -1.654637170968e+00, -1.774158837596e+00, -1.978785861570e+00, -2.268518242891e+00, -2.558250624213e+00, -2.847983005534e+00],
        [-1.746337123268e+00, -1.741812770976e+00, -1.737288418683e+00, -1.732764066391e+00, -1.773109425936e+00, -1.858324497319e+00, -1.943539568701e+00, -2.028754640084e+00, -2.261925008099e+00, -2.495095376114e+00, -2.728265744130e+00, -3.083404634481e+00, -3.560512047168e+00, -4.037619459855e+00, -4.514726872541e+00],
        [-1.994390761654e+00, -2.035842886932e+00, -2.077295012210e+00, -2.118747137488e+00, -2.219981934080e+00, -2.380999401984e+00, -2.542016869888e+00, -2.703034337793e+00, -3.061181729324e+00, -3.419329120855e+00, -3.777476512386e+00, -4.298130053005e+00, -4.981289742711e+00, -5.664449432417e+00, -6.347609122123e+00],
        [-2.309897555227e+00, -2.409828528517e+00, -2.509759501807e+00, -2.609690475097e+00, -2.788372355995e+00, -3.045805144503e+00, -3.303237933010e+00, -3.560670721518e+00, -4.077780102948e+00, -4.594889484379e+00, -5.111998865810e+00, -5.843175408369e+00, -6.788419112055e+00, -7.733662815741e+00, -8.678906519428e+00],
        [-2.625404348800e+00, -2.783814170102e+00, -2.942223991403e+00, -3.100633812705e+00, -3.356762777911e+00, -3.710610887021e+00, -4.064458996132e+00, -4.418307105242e+00, -5.094378476573e+00, -5.770449847903e+00, -6.446521219234e+00, -7.388220763732e+00, -8.595548481399e+00, -9.802876199065e+00, -1.101020391673e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 5.815564179657e-01,  6.205709691674e-01,  6.595855203691e-01],
        [ 1.231128359314e-01,  1.411419383348e-01,  1.591710407383e-01],
        [-9.898235458500e-01, -1.022739576874e+00, -1.055655607898e+00],
        [-2.320924194214e+00, -2.414771920208e+00, -2.508619646202e+00],
        [-4.088353375743e+00, -4.263105919793e+00, -4.437858463844e+00],
        [-6.292111090436e+00, -6.567741575629e+00, -6.843372060822e+00],
        [-8.714033071712e+00, -9.100528059590e+00, -9.487023047469e+00],
        [-1.179044785274e+01, -1.231776702793e+01, -1.284508620312e+01],
        [-1.486686263376e+01, -1.553500599627e+01, -1.620314935877e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.366458165169e-01,  6.781821082292e-01,  7.197183999415e-01],
        [ 2.332916330338e-01,  2.563642164584e-01,  2.794367998829e-01],
        [-7.543609673587e-01, -7.764985992983e-01, -7.986362312378e-01],
        [-1.936779706721e+00, -2.013043056383e+00, -2.089306406046e+00],
        [-3.508730724023e+00, -3.656950796126e+00, -3.805170868229e+00],
        [-5.470214019265e+00, -5.708221818526e+00, -5.946229617786e+00],
        [-7.626463453476e+00, -7.963174482254e+00, -8.299885511031e+00],
        [-1.036701130460e+01, -1.082917206997e+01, -1.129133283534e+01],
        [-1.310755915572e+01, -1.369516965768e+01, -1.428278015965e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.917352150681e-01,  7.357932472910e-01,  7.798512795138e-01],
        [ 3.434704301362e-01,  3.715864945819e-01,  3.997025590276e-01],
        [-5.188983888674e-01, -5.302576217225e-01, -5.416168545777e-01],
        [-1.552635219228e+00, -1.611314192559e+00, -1.669993165889e+00],
        [-2.929108072304e+00, -3.050795672459e+00, -3.172483272614e+00],
        [-4.648316948094e+00, -4.848702061422e+00, -5.049087174751e+00],
        [-6.538893835241e+00, -6.825820904917e+00, -7.112747974594e+00],
        [-8.943574756460e+00, -9.340577112008e+00, -9.737579467556e+00],
        [-1.134825567768e+01, -1.185533331910e+01, -1.236241096052e+01]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.871381687728e+00, -2.979508415039e+00, -3.087635142351e+00],
        [-2.957741047951e+00, -3.074351748599e+00, -3.190962449247e+00],
        [-3.044100408175e+00, -3.169195082159e+00, -3.294289756144e+00]],
       [[-2.682184461877e+00, -2.771724388461e+00, -2.861264315045e+00],
        [-2.759115557302e+00, -2.856213221236e+00, -2.953310885171e+00],
        [-2.836046652727e+00, -2.940702054012e+00, -3.045357455296e+00]],
       [[-2.492987236027e+00, -2.563940361883e+00, -2.634893487739e+00],
        [-2.560490066653e+00, -2.638074693873e+00, -2.715659321094e+00],
        [-2.627992897279e+00, -2.712209025864e+00, -2.796425154449e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.159719627225e+00, -3.417164216062e+00, -3.674608804899e+00, -3.932053393736e+00, -4.319340106597e+00, -4.836468943482e+00, -5.353597780367e+00, -5.870726617252e+00, -6.816002397559e+00, -7.761278177867e+00, -8.706553958175e+00, -1.000477722479e+01, -1.165594797770e+01, -1.330711873061e+01, -1.495828948353e+01],
        [-3.268702916346e+00, -3.546347441698e+00, -3.823991967050e+00, -4.101636492402e+00, -4.515675206021e+00, -5.066108107905e+00, -5.616541009790e+00, -6.166973911675e+00, -7.167158812348e+00, -8.167343713021e+00, -9.167528613694e+00, -1.053847135784e+01, -1.228017194545e+01, -1.402187253307e+01, -1.576357312069e+01],
        [-3.377686205467e+00, -3.675530667334e+00, -3.973375129202e+00, -4.271219591069e+00, -4.712010305445e+00, -5.295747272329e+00, -5.879484239213e+00, -6.463221206097e+00, -7.518315227136e+00, -8.573409248175e+00, -9.628503269214e+00, -1.107216549089e+01, -1.290439591321e+01, -1.473662633553e+01, -1.656885675785e+01]],
       [[-2.920957599434e+00, -3.134147900825e+00, -3.347338202215e+00, -3.560528503605e+00, -3.889206580226e+00, -4.333372432078e+00, -4.777538283930e+00, -5.221704135782e+00, -6.046684290692e+00, -6.871664445602e+00, -7.696644600512e+00, -8.835553076241e+00, -1.028838987279e+01, -1.174122666934e+01, -1.319406346589e+01],
        [-3.018042661127e+00, -3.249227575257e+00, -3.480412489386e+00, -3.711597403516e+00, -4.064106836897e+00, -4.537940789530e+00, -5.011774742163e+00, -5.485608694797e+00, -6.359503278526e+00, -7.233397862255e+00, -8.107292445984e+00, -9.310981265742e+00, -1.084446432153e+01, -1.237794737732e+01, -1.391143043310e+01],
        [-3.115127722820e+00, -3.364307249689e+00, -3.613486776557e+00, -3.862666303426e+00, -4.239007093568e+00, -4.742509146982e+00, -5.246011200396e+00, -5.749513253811e+00, -6.672322266359e+00, -7.595131278908e+00, -8.517940291456e+00, -9.786409455243e+00, -1.140053877027e+01, -1.301466808529e+01, -1.462879740032e+01]],
       [[-2.682195571644e+00, -2.851131585587e+00, -3.020067599531e+00, -3.189003613474e+00, -3.459073053856e+00, -3.830275920675e+00, -4.201478787494e+00, -4.572681654313e+00, -5.277366183825e+00, -5.982050713338e+00, -6.686735242850e+00, -7.666328927698e+00, -8.920831767881e+00, -1.017533460806e+01, -1.142983744825e+01],
        [-2.767382405908e+00, -2.952107708815e+00, -3.136833011722e+00, -3.321558314629e+00, -3.612538467773e+00, -4.009773471155e+00, -4.407008474537e+00, -4.804243477919e+00, -5.551847744704e+00, -6.299452011489e+00, -7.047056278274e+00, -8.083491173646e+00, -9.408756697604e+00, -1.073402222156e+01, -1.205928774552e+01],
        [-2.852569240173e+00, -3.053083832043e+00, -3.253598423913e+00, -3.454113015783e+00, -3.766003881690e+00, -4.189271021635e+00, -4.612538161580e+00, -5.035805301524e+00, -5.826329305582e+00, -6.616853309641e+00, -7.407377313699e+00, -8.500653419594e+00, -9.896681627326e+00, -1.129270983506e+01, -1.268873804279e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.542061729434e+01, -1.611410901057e+01, -1.680760072679e+01],
        [-1.625124928522e+01, -1.698276353202e+01, -1.771427777882e+01],
        [-1.708188127609e+01, -1.785141805347e+01, -1.862095483084e+01]],
       [[-1.360085776892e+01, -1.421104922347e+01, -1.482124067802e+01],
        [-1.434080568872e+01, -1.498486857215e+01, -1.562893145558e+01],
        [-1.508075360853e+01, -1.575868792084e+01, -1.643662223315e+01]],
       [[-1.178109824350e+01, -1.230798943638e+01, -1.283488062925e+01],
        [-1.243036209223e+01, -1.298697361229e+01, -1.354358513235e+01],
        [-1.307962594096e+01, -1.366595778820e+01, -1.425228963545e+01]]
                ], dtype=np.float64)
            ]
        ],
        [  # x mid
            [  # y inf
                np.array([  # z inf
       [[-1.136679115901e+00, -1.074388064203e+00, -1.012097012505e+00],
        [-1.145424447438e+00, -1.083992540127e+00, -1.022560632816e+00],
        [-1.154169778975e+00, -1.093597016051e+00, -1.033024253126e+00]],
       [[-1.146497770886e+00, -1.085171307241e+00, -1.023844843595e+00],
        [-1.151561106804e+00, -1.090732067026e+00, -1.029903027247e+00],
        [-1.156624442722e+00, -1.096292826810e+00, -1.035961210899e+00]],
       [[-1.156496277208e+00, -1.096152070272e+00, -1.035807863337e+00],
        [-1.157810173255e+00, -1.097595043920e+00, -1.037379914585e+00],
        [-1.159124069302e+00, -1.099038017568e+00, -1.038951965834e+00]],
       [[-1.166719597700e+00, -1.107379733295e+00, -1.048039868891e+00],
        [-1.164199748562e+00, -1.104612333310e+00, -1.045024918057e+00],
        [-1.161679899425e+00, -1.101844933324e+00, -1.042009967223e+00]],
       [[-1.167727320121e+00, -1.108486454715e+00, -1.049245589309e+00],
        [-1.164829575075e+00, -1.105304034197e+00, -1.045778493318e+00],
        [-1.161931830030e+00, -1.102121613679e+00, -1.042311397327e+00]],
       [[-1.166142922947e+00, -1.106746405816e+00, -1.047349888686e+00],
        [-1.163839326842e+00, -1.104216503635e+00, -1.044593680428e+00],
        [-1.161535730737e+00, -1.101686601454e+00, -1.041837472171e+00]],
       [[-1.161678186102e+00, -1.101843051683e+00, -1.042007917265e+00],
        [-1.161048866314e+00, -1.101151907302e+00, -1.041254948290e+00],
        [-1.160419546525e+00, -1.100460762921e+00, -1.040501979316e+00]],
       [[-1.161310507796e+00, -1.101439252534e+00, -1.041567997271e+00],
        [-1.160819067372e+00, -1.100899532833e+00, -1.040979998295e+00],
        [-1.160327626949e+00, -1.100359813133e+00, -1.040391999318e+00]],
       [[-1.162688424425e+00, -1.102952536167e+00, -1.043216647910e+00],
        [-1.161680265265e+00, -1.101845335105e+00, -1.042010404944e+00],
        [-1.160672106106e+00, -1.100738134042e+00, -1.040804161978e+00]],
       [[-1.166078864786e+00, -1.106676054560e+00, -1.047273244333e+00],
        [-1.163799290491e+00, -1.104172534100e+00, -1.044545777708e+00],
        [-1.161519716197e+00, -1.101669013640e+00, -1.041818311083e+00]],
       [[-1.164542154664e+00, -1.104988377505e+00, -1.045434600346e+00],
        [-1.162838846665e+00, -1.103117735941e+00, -1.043396625216e+00],
        [-1.161135538666e+00, -1.101247094376e+00, -1.041358650086e+00]],
       [[-1.159801911869e+00, -1.099782451622e+00, -1.039762991376e+00],
        [-1.159876194918e+00, -1.099864032264e+00, -1.039851869610e+00],
        [-1.159950477967e+00, -1.099945612906e+00, -1.039940747844e+00]],
       [[-1.149142009622e+00, -1.088075316902e+00, -1.027008624182e+00],
        [-1.153213756014e+00, -1.092547073064e+00, -1.031880390114e+00],
        [-1.157285502406e+00, -1.097018829226e+00, -1.036752156046e+00]],
       [[-1.142985644872e+00, -1.081314148756e+00, -1.019642652639e+00],
        [-1.149366028045e+00, -1.088321342972e+00, -1.027276657900e+00],
        [-1.155746411218e+00, -1.095328537189e+00, -1.034910663160e+00]],
       [[-1.140432110120e+00, -1.078509753868e+00, -1.016587397617e+00],
        [-1.147770068825e+00, -1.086568596168e+00, -1.025367123510e+00],
        [-1.155108027530e+00, -1.094627438467e+00, -1.034146849404e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.705696447063e-01, -8.222576168539e-01, -6.739455890015e-01, -5.256335611492e-01, -3.755521833340e-01, -2.237014555560e-01, -7.185072777800e-02,  8.000000000000e-02,  2.376850576160e-01,  3.953701152320e-01,  5.530551728480e-01,  7.155498223161e-01,  8.828540636363e-01,  1.050158304957e+00,  1.217462546277e+00],
        [-9.816060279414e-01, -8.353395819623e-01, -6.890731359831e-01, -5.428066900039e-01, -3.954344002980e-01, -2.469562668654e-01, -9.847813343268e-02,  5.000000000000e-02,  2.021245895814e-01,  3.542491791629e-01,  5.063737687443e-01,  6.615043532333e-01,  8.196409326298e-01,  9.777775120264e-01,  1.135914091423e+00],
        [-9.926424111766e-01, -8.484215470706e-01, -7.042006829647e-01, -5.599798188587e-01, -4.153166172621e-01, -2.702110781747e-01, -1.251055390874e-01,  2.000000000000e-02,  1.665641215469e-01,  3.131282430937e-01,  4.596923646406e-01,  6.074588841505e-01,  7.564278016234e-01,  9.053967190963e-01,  1.054365636569e+00]],
       [[-9.829605344985e-01, -8.369451448664e-01, -6.909297552343e-01, -5.449143656023e-01, -3.978745650397e-01, -2.498103535466e-01, -1.017461420536e-01,  4.631806943952e-02,  1.977602171147e-01,  3.492023647899e-01,  5.006445124651e-01,  6.548712977576e-01,  8.118827206673e-01,  9.688941435770e-01,  1.125905566487e+00],
        [-9.893503340615e-01, -8.445192869701e-01, -6.996882398786e-01, -5.548571927871e-01, -4.093858888641e-01, -2.632743281095e-01, -1.171627673549e-01,  2.894879339970e-02,  1.771715642681e-01,  3.253943351365e-01,  4.736171060050e-01,  6.235802753842e-01,  7.752838432742e-01,  9.269874111642e-01,  1.078690979054e+00],
        [-9.957401336246e-01, -8.520934290737e-01, -7.084467245229e-01, -5.648000199720e-01, -4.208972126885e-01, -2.767383026724e-01, -1.325793926562e-01,  1.157951735988e-02,  1.565829114215e-01,  3.015863054832e-01,  4.465896995448e-01,  5.922892530108e-01,  7.386849658811e-01,  8.850806787514e-01,  1.031476391622e+00]],
       [[-9.955783920462e-01, -8.519017088661e-01, -7.082250256860e-01, -5.645483425059e-01, -4.206058327059e-01, -2.763974962861e-01, -1.321891598663e-01,  1.201917655345e-02,  1.571040609782e-01,  3.021889454029e-01,  4.472738298276e-01,  5.930813059226e-01,  7.396113736878e-01,  8.861414414530e-01,  1.032671509218e+00],
        [-9.972364950289e-01, -8.538671394699e-01, -7.104977839109e-01, -5.671284283519e-01, -4.235929311555e-01, -2.798912923217e-01, -1.361896534879e-01,  7.511985345904e-03,  1.517614666828e-01,  2.960109480197e-01,  4.402604293565e-01,  5.849615304873e-01,  7.301142514120e-01,  8.752669723367e-01,  1.020419693261e+00],
        [-9.988945980115e-01, -8.558325700737e-01, -7.127705421358e-01, -5.697085141979e-01, -4.265800296051e-01, -2.833850883573e-01, -1.401901471094e-01,  3.004794138362e-03,  1.464188723874e-01,  2.898329506364e-01,  4.332470288855e-01,  5.768417550521e-01,  7.206171291362e-01,  8.643925032204e-01,  1.008167877305e+00]],
       [[-1.008479959288e+00, -8.671945678498e-01, -7.259091764112e-01, -5.846237849727e-01, -4.438482078228e-01, -3.035824449618e-01, -1.633166821007e-01, -2.305091923961e-02,  1.155337602976e-01,  2.541184398347e-01,  3.927031193719e-01,  5.299019799921e-01,  6.657150216953e-01,  8.015280633985e-01,  9.373411051017e-01],
        [-1.005299974555e+00, -8.634251763347e-01, -7.215503781142e-01, -5.796755798936e-01, -4.381194156036e-01, -2.968818852440e-01, -1.556443548844e-01, -1.440682452476e-02,  1.257800287574e-01,  2.659668820396e-01,  4.061537353217e-01,  5.454744517808e-01,  6.839290314167e-01,  8.223836110526e-01,  9.608381906886e-01],
        [-1.002119989822e+00, -8.596557848196e-01, -7.171915798171e-01, -5.747273748146e-01, -4.323906233843e-01, -2.901813255262e-01, -1.479720276680e-01, -5.762729809902e-03,  1.360262972172e-01,  2.778153242444e-01,  4.196043512715e-01,  5.610469235694e-01,  7.021430411381e-01,  8.432391587068e-01,  9.843352762754e-01]],
       [[-1.009751679038e+00, -8.687019995002e-01, -7.276523199623e-01, -5.866026404243e-01, -4.461392308369e-01, -3.062620912001e-01, -1.663849515633e-01, -2.650781192653e-02,  1.114361362345e-01,  2.493800843955e-01,  3.873240325565e-01,  5.236743337643e-01,  6.584309880188e-01,  7.931876422734e-01,  9.279442965279e-01],
        [-1.006094799399e+00, -8.643673211162e-01, -7.226398428336e-01, -5.809123645509e-01, -4.395513049874e-01, -2.985566641429e-01, -1.575620232985e-01, -1.656738245408e-02,  1.232190137180e-01,  2.630054098900e-01,  4.027918060621e-01,  5.415821728884e-01,  6.793765103689e-01,  8.171708478494e-01,  9.549651853299e-01],
        [-1.002437919760e+00, -8.600326427322e-01, -7.176273657049e-01, -5.752220886775e-01, -4.329633791378e-01, -2.908512370857e-01, -1.487390950337e-01, -6.626952981632e-03,  1.350018912015e-01,  2.766307353846e-01,  4.182595795677e-01,  5.594900120125e-01,  7.003220327190e-01,  8.411540534255e-01,  9.819860741320e-01]],
       [[-1.007752210598e+00, -8.663319317156e-01, -7.249116528328e-01, -5.834913739499e-01, -4.425371571787e-01, -3.020490025192e-01, -1.615608478596e-01, -2.107269320001e-02,  1.178786484258e-01,  2.568299900515e-01,  3.957813316773e-01,  5.334657851341e-01,  6.698833504220e-01,  8.063009157099e-01,  9.427184809977e-01],
        [-1.004845131624e+00, -8.628860287508e-01, -7.209269258776e-01, -5.789678230044e-01, -4.373000089510e-01, -2.959234837173e-01, -1.545469584837e-01, -1.317043325001e-02,  1.272455838375e-01,  2.676616009251e-01,  4.080776180126e-01,  5.477018299945e-01,  6.865342368709e-01,  8.253666437472e-01,  9.641990506236e-01],
        [-1.001938052650e+00, -8.594401257860e-01, -7.169421989225e-01, -5.744442720589e-01, -4.320628607233e-01, -2.897979649155e-01, -1.475330691078e-01, -5.268173300003e-03,  1.366125192493e-01,  2.784932117986e-01,  4.203739043479e-01,  5.619378748550e-01,  7.031851233198e-01,  8.444323717846e-01,  9.856796202494e-01]],
       [[-1.002117827652e+00, -8.596532218940e-01, -7.171886161356e-01, -5.747240103773e-01, -4.323867282017e-01, -2.901767696088e-01, -1.479668110160e-01, -5.756852423154e-03,  1.360332639714e-01,  2.778233803659e-01,  4.196134967604e-01,  5.610575117736e-01,  7.021554254054e-01,  8.432533390372e-01,  9.843512526690e-01],
        [-1.001323642283e+00, -8.587118351123e-01, -7.161000279419e-01, -5.734882207715e-01, -4.309559908403e-01, -2.885033381484e-01, -1.460506854564e-01, -3.598032764472e-03,  1.385922185535e-01,  2.807824698715e-01,  4.229727211895e-01,  5.649466591442e-01,  7.067042837355e-01,  8.484619083268e-01,  9.902195329181e-01],
        [-1.000529456913e+00, -8.577704483306e-01, -7.150114397482e-01, -5.722524311657e-01, -4.295252534790e-01, -2.868299066879e-01, -1.441345598969e-01, -1.439213105789e-03,  1.411511731357e-01,  2.837415593772e-01,  4.263319456187e-01,  5.688358065148e-01,  7.112531420656e-01,  8.536704776164e-01,  9.960878131673e-01]],
       [[-1.001653827097e+00, -8.591032193298e-01, -7.165526115628e-01, -5.740020037959e-01, -4.315508239456e-01, -2.891990720118e-01, -1.468473200781e-01, -4.495568144422e-03,  1.375283259472e-01,  2.795522200389e-01,  4.215761141306e-01,  5.633297351233e-01,  7.048130830170e-01,  8.462964309107e-01,  9.877797788044e-01],
        [-1.001033641935e+00, -8.583680835097e-01, -7.157025250839e-01, -5.730369666581e-01, -4.304335506803e-01, -2.878922771503e-01, -1.453510036203e-01, -2.809730090264e-03,  1.395266322885e-01,  2.818629946672e-01,  4.241993570459e-01,  5.663667987378e-01,  7.083653197428e-01,  8.503638407478e-01,  9.923623617528e-01],
        [-1.000413456774e+00, -8.576329476896e-01, -7.148524386050e-01, -5.720719295204e-01, -4.293162774150e-01, -2.865854822887e-01, -1.438546871624e-01, -1.123892036105e-03,  1.415249386297e-01,  2.841737692954e-01,  4.268225999612e-01,  5.694038623522e-01,  7.119175564685e-01,  8.544312505848e-01,  9.969449447011e-01]],
       [[-1.003392722405e+00, -8.611644170311e-01, -7.189361116568e-01, -5.767078062825e-01, -4.346834710336e-01, -2.928631059103e-01, -1.510427407869e-01, -9.222375663519e-03,  1.319254096910e-01,  2.730731950454e-01,  4.142209803999e-01,  5.548143174688e-01,  6.948532062521e-01,  8.348920950354e-01,  9.749309838186e-01],
        [-1.002120451503e+00, -8.596563320730e-01, -7.171922126426e-01, -5.747280932123e-01, -4.323914551103e-01, -2.901822983368e-01, -1.479731415632e-01, -5.763984789700e-03,  1.360248096283e-01,  2.778136040463e-01,  4.196023984642e-01,  5.610446627037e-01,  7.021403967647e-01,  8.432361308257e-01,  9.843318648866e-01],
        [-1.000848180601e+00, -8.581482471149e-01, -7.154483136285e-01, -5.727483801420e-01, -4.300994391870e-01, -2.875014907633e-01, -1.449035423396e-01, -2.305593915880e-03,  1.401242095656e-01,  2.825540130471e-01,  4.249838165286e-01,  5.672750079386e-01,  7.094275872773e-01,  8.515801666160e-01,  9.937327459547e-01]],
       [[-1.007671370849e+00, -8.662361084042e-01, -7.248008459599e-01, -5.833655835155e-01, -4.423915231053e-01, -3.018786647292e-01, -1.613658063530e-01, -2.085294797690e-02,  1.181391231918e-01,  2.571311943606e-01,  3.961232655293e-01,  5.338616595895e-01,  6.703463765412e-01,  8.068310934929e-01,  9.433158104446e-01],
        [-1.004794606780e+00, -8.628261391812e-01, -7.208576715821e-01, -5.788892039829e-01, -4.372089876551e-01, -2.958170225986e-01, -1.544250575421e-01, -1.303309248556e-02,  1.274083805663e-01,  2.678498536182e-01,  4.082913266701e-01,  5.479492515292e-01,  6.868236281954e-01,  8.256980048616e-01,  9.645723815279e-01],
        [-1.001917842712e+00, -8.594161699582e-01, -7.169144972043e-01, -5.744128244503e-01, -4.320264522049e-01, -2.897553804680e-01, -1.474843087311e-01, -5.213236994225e-03,  1.366776379408e-01,  2.785685128759e-01,  4.204593878109e-01,  5.620368434688e-01,  7.033008798496e-01,  8.445649162304e-01,  9.858289526111e-01]],
       [[-1.005732082240e+00, -8.639373747182e-01, -7.221426671966e-01, -5.803479596750e-01, -4.388978643538e-01, -2.977923812331e-01, -1.566868981124e-01, -1.558141499171e-02,  1.243877291989e-01,  2.643568733896e-01,  4.043260175802e-01,  5.433584086885e-01,  6.814540467145e-01,  8.195496847404e-01,  9.576453227664e-01],
        [-1.003582551400e+00, -8.613894306274e-01, -7.191963098550e-01, -5.770031890826e-01, -4.350254509354e-01, -2.932630954136e-01, -1.515007398917e-01, -9.738384369820e-03,  1.313137593208e-01,  2.723659030113e-01,  4.134180467019e-01,  5.538847197160e-01,  6.937659220537e-01,  8.336471243913e-01,  9.735283267290e-01],
        [-1.001433020560e+00, -8.588414865367e-01, -7.162499525134e-01, -5.736584184902e-01, -4.311530375170e-01, -2.887338095940e-01, -1.463145816710e-01, -3.895353747928e-03,  1.382397894426e-01,  2.803749326331e-01,  4.225100758236e-01,  5.644110307436e-01,  7.060777973929e-01,  8.477445640422e-01,  9.894113306916e-01]],
       [[-9.997500178784e-01, -8.568465411013e-01, -7.139430643243e-01, -5.710395875473e-01, -4.281210818705e-01, -2.851875472941e-01, -1.422540127177e-01,  6.795218587054e-04,  1.436626133683e-01,  2.866457048779e-01,  4.296287963875e-01,  5.726527406821e-01,  7.157175377616e-01,  8.587823348411e-01,  1.001847131921e+00],
        [-9.998437611740e-01, -8.569576596169e-01, -7.140715580598e-01, -5.711854565028e-01, -4.282899618834e-01, -2.853850742017e-01, -1.424801865200e-01,  4.247011616909e-04,  1.433605619266e-01,  2.862964226916e-01,  4.292322834565e-01,  5.721936772120e-01,  7.151806039581e-01,  8.581675307042e-01,  1.001154457450e+00],
        [-9.999375044696e-01, -8.570687781325e-01, -7.142000517954e-01, -5.713313254582e-01, -4.284588418962e-01, -2.855826011092e-01, -1.427063603223e-01,  1.698804646763e-04,  1.430585104849e-01,  2.859471405052e-01,  4.288357705255e-01,  5.717346137420e-01,  7.146436701547e-01,  8.575527265674e-01,  1.000461782980e+00]],
       [[-9.862974957024e-01, -8.409006082739e-01, -6.955037208454e-01, -5.501068334169e-01, -4.038861528256e-01, -2.568416790715e-01, -1.097972053174e-01,  3.724726843668e-02,  1.870081528111e-01,  3.367690371855e-01,  4.865299215598e-01,  6.385301079191e-01,  7.927695962631e-01,  9.470090846071e-01,  1.101248572951e+00],
        [-9.914359348140e-01, -8.469914515997e-01, -7.025469683855e-01, -5.581024851712e-01, -4.131431312303e-01, -2.676689065625e-01, -1.221946818948e-01,  2.327954277293e-02,  1.704515240783e-01,  3.176235053838e-01,  4.647954866892e-01,  6.133670317351e-01,  7.633381405216e-01,  9.133092493080e-01,  1.063280358094e+00],
        [-9.965743739256e-01, -8.530822949256e-01, -7.095902159256e-01, -5.660981369256e-01, -4.224001096350e-01, -2.784961340536e-01, -1.345921584722e-01,  9.311817109171e-03,  1.538948953456e-01,  2.984779735821e-01,  4.430610518185e-01,  5.882039555512e-01,  7.339066847801e-01,  8.796094140089e-01,  1.025312143238e+00]],
       [[-9.785283218950e-01, -8.316914263794e-01, -6.848545308639e-01, -5.380176353483e-01, -3.898898647320e-01, -2.404712190148e-01, -9.105257329768e-02,  5.836607241947e-02,  2.120413046097e-01,  3.657165367999e-01,  5.193917689901e-01,  6.765759635097e-01,  8.372691203586e-01,  9.979622772075e-01,  1.158655434056e+00],
        [-9.865802011843e-01, -8.412357129157e-01, -6.958912246471e-01, -5.505467363784e-01, -4.043954511718e-01, -2.574373690271e-01, -1.104792868825e-01,  3.647879526217e-02,  1.860972439525e-01,  3.357156926428e-01,  4.853341413331e-01,  6.371456914793e-01,  7.911503430812e-01,  9.451549946832e-01,  1.099159646285e+00],
        [-9.946320804737e-01, -8.507799994520e-01, -7.069279184303e-01, -5.630758374085e-01, -4.189010376116e-01, -2.744035190394e-01, -1.299060004673e-01,  1.459151810487e-02,  1.601531832953e-01,  3.057148484857e-01,  4.512765136761e-01,  5.977154194488e-01,  7.450315658039e-01,  8.923477121590e-01,  1.039663858514e+00]],
       [[-9.753058267824e-01, -8.278716452314e-01, -6.804374636804e-01, -5.330032821294e-01, -3.840844893996e-01, -2.336810854910e-01, -8.327768158245e-02,  6.712572232612e-02,  2.224245462930e-01,  3.777233702599e-01,  5.330221942267e-01,  6.923566097832e-01,  8.557266169292e-01,  1.019096624075e+00,  1.182466631221e+00],
        [-9.845661417390e-01, -8.388483496982e-01, -6.931305576574e-01, -5.474127656166e-01, -4.007670915890e-01, -2.531935355747e-01, -1.056199795605e-01,  4.195357645382e-02,  1.925867700045e-01,  3.432199635553e-01,  4.938531571060e-01,  6.470085954002e-01,  8.026862784379e-01,  9.583639614756e-01,  1.114041644513e+00],
        [-9.938264566956e-01, -8.498250541650e-01, -7.058236516344e-01, -5.618222491038e-01, -4.174496937785e-01, -2.727059856585e-01, -1.279622775385e-01,  1.678143058153e-02,  1.627489937161e-01,  3.087165568507e-01,  4.546841199853e-01,  6.016605810172e-01,  7.496459399466e-01,  8.976312988760e-01,  1.045616657805e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.264307733846e+00,  1.334575515201e+00,  1.404843296555e+00],
        [ 1.180192333654e+00,  1.246609697001e+00,  1.313027060347e+00],
        [ 1.096076933462e+00,  1.158643878800e+00,  1.221210824139e+00]],
       [[ 1.169868764901e+00,  1.235813562524e+00,  1.301758360146e+00],
        [ 1.121167978063e+00,  1.184883476577e+00,  1.248598975091e+00],
        [ 1.072467191225e+00,  1.133953390631e+00,  1.195439590036e+00]],
       [[ 1.073699928193e+00,  1.135242556654e+00,  1.196785185115e+00],
        [ 1.061062455120e+00,  1.122026597909e+00,  1.182990740697e+00],
        [ 1.048424982048e+00,  1.108810639163e+00,  1.169196296279e+00]],
       [[ 9.753687567786e-01,  1.032410234294e+00,  1.089451711809e+00],
        [ 9.996054729866e-01,  1.057756396434e+00,  1.115907319881e+00],
        [ 1.023842189195e+00,  1.083102558573e+00,  1.142362927952e+00]],
       [[ 9.656761597192e-01,  1.022273954506e+00,  1.078871749293e+00],
        [ 9.935475998245e-01,  1.051421221566e+00,  1.109294843308e+00],
        [ 1.021419039930e+00,  1.080568488627e+00,  1.139717937323e+00]],
       [[ 9.809153992783e-01,  1.038210776699e+00,  1.095506154120e+00],
        [ 1.003072124549e+00,  1.061381735437e+00,  1.119691346325e+00],
        [ 1.025228849820e+00,  1.084552694175e+00,  1.143876538530e+00]],
       [[ 1.023858668486e+00,  1.083119792211e+00,  1.142380915937e+00],
        [ 1.029911667804e+00,  1.089449870132e+00,  1.148988072460e+00],
        [ 1.035964667121e+00,  1.095779948053e+00,  1.155595228984e+00]],
       [[ 1.027395116215e+00,  1.086818122330e+00,  1.146241128445e+00],
        [ 1.032121947634e+00,  1.091761326456e+00,  1.151400705278e+00],
        [ 1.036848779054e+00,  1.096704530583e+00,  1.156560282111e+00]],
       [[ 1.014141872678e+00,  1.072958205967e+00,  1.131774539256e+00],
        [ 1.023838670424e+00,  1.083098878729e+00,  1.142359087035e+00],
        [ 1.033535468169e+00,  1.093239551492e+00,  1.152943634814e+00]],
       [[ 9.815315311911e-01,  1.038855112311e+00,  1.096178693430e+00],
        [ 1.003457206994e+00,  1.061784445194e+00,  1.120111683394e+00],
        [ 1.025382882798e+00,  1.084713778078e+00,  1.144044673358e+00]],
       [[ 9.963121014136e-01,  1.054312269385e+00,  1.112312437355e+00],
        [ 1.012695063384e+00,  1.071445168365e+00,  1.130195273347e+00],
        [ 1.029078025353e+00,  1.088578067346e+00,  1.148078109339e+00]],
       [[ 1.041905275103e+00,  1.101992489876e+00,  1.162079704650e+00],
        [ 1.041190796939e+00,  1.101245306173e+00,  1.161299815406e+00],
        [ 1.040476318776e+00,  1.100498122469e+00,  1.160519926162e+00]],
       [[ 1.144435629688e+00,  1.209216214792e+00,  1.273996799896e+00],
        [ 1.105272268555e+00,  1.168260134245e+00,  1.231247999935e+00],
        [ 1.066108907422e+00,  1.127304053698e+00,  1.188499199974e+00]],
       [[ 1.203649517974e+00,  1.271140643851e+00,  1.338631769727e+00],
        [ 1.142280948734e+00,  1.206962902407e+00,  1.271644856079e+00],
        [ 1.080912379494e+00,  1.142785160963e+00,  1.204657942432e+00]],
       [[ 1.228210233222e+00,  1.296825636223e+00,  1.365441039225e+00],
        [ 1.157631395764e+00,  1.223016022640e+00,  1.288400649516e+00],
        [ 1.087052558306e+00,  1.149206409056e+00,  1.211360259806e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.192390116804e+00, -1.135572133051e+00, -1.078754149299e+00],
        [-1.224780233609e+00, -1.171144266103e+00, -1.117508298597e+00],
        [-1.305755525619e+00, -1.260074598732e+00, -1.214393671844e+00],
        [-1.402925876032e+00, -1.366790997886e+00, -1.330656119740e+00],
        [-1.532486343249e+00, -1.509079530092e+00, -1.485672716935e+00],
        [-1.694436927270e+00, -1.686940195349e+00, -1.679443463428e+00],
        [-1.872582569694e+00, -1.882586927132e+00, -1.892591284571e+00],
        [-2.099313387323e+00, -2.131591858493e+00, -2.163870329662e+00],
        [-2.326044204953e+00, -2.380596789853e+00, -2.435149374753e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.178753095991e+00, -1.120595406610e+00, -1.062437717229e+00],
        [-1.197506191982e+00, -1.141190813220e+00, -1.084875434457e+00],
        [-1.247468302160e+00, -1.196061218335e+00, -1.144654134509e+00],
        [-1.307833417066e+00, -1.262356622951e+00, -1.216879828836e+00],
        [-1.389004541430e+00, -1.351502026571e+00, -1.313999511712e+00],
        [-1.490981675252e+00, -1.463497429194e+00, -1.436013183137e+00],
        [-1.603361813802e+00, -1.586917831319e+00, -1.570473848837e+00],
        [-1.746950966539e+00, -1.744613231949e+00, -1.742275497360e+00],
        [-1.890540119276e+00, -1.902308632579e+00, -1.914077145883e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.164866281656e+00, -1.105344346844e+00, -1.045822412032e+00],
        [-1.169732563311e+00, -1.110688693688e+00, -1.051644824065e+00],
        [-1.181579065038e+00, -1.123698999831e+00, -1.065818934624e+00],
        [-1.195752306789e+00, -1.139264625740e+00, -1.082776944691e+00],
        [-1.214579028587e+00, -1.159940891181e+00, -1.105302753776e+00],
        [-1.238059230432e+00, -1.185727796155e+00, -1.133396361878e+00],
        [-1.263866172301e+00, -1.214070020895e+00, -1.164273869489e+00],
        [-1.296653334242e+00, -1.250078204934e+00, -1.203503075625e+00],
        [-1.329440496182e+00, -1.286086388972e+00, -1.242732281762e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.150667225417e+00, -1.089750370423e+00, -1.028833515429e+00],
        [-1.141334450835e+00, -1.079500740846e+00, -1.017667030858e+00],
        [-1.106187310839e+00, -1.040900733694e+00, -9.756141565489e-01],
        [-1.062435382372e+00, -9.928506006827e-01, -9.232658189938e-01],
        [-1.001473876962e+00, -9.259002159547e-01, -8.503265549468e-01],
        [-9.233027946112e-01, -8.400495795095e-01, -7.567963644078e-01],
        [-8.365269237888e-01, -7.447488172058e-01, -6.529707106228e-01],
        [-7.239366875532e-01, -6.210976773265e-01, -5.182586670998e-01],
        [-6.113464513175e-01, -4.974465374472e-01, -3.835466235768e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.149267610943e+00, -1.088213257341e+00, -1.027158903738e+00],
        [-1.138535221887e+00, -1.076426514681e+00, -1.014317807475e+00],
        [-1.087923713003e+00, -1.020842913707e+00, -9.537621144109e-01],
        [-1.024019164176e+00, -9.506603599610e-01, -8.773015557456e-01],
        [-9.335285354648e-01, -8.512799006718e-01, -7.690312658788e-01],
        [-8.164518268684e-01, -7.227015358394e-01, -6.289512448104e-01],
        [-6.860820783294e-01, -5.795242182354e-01, -4.729663581413e-01],
        [-5.158332099630e-01, -3.925500423165e-01, -2.692668746700e-01],
        [-3.455843415966e-01, -2.055758663976e-01, -6.556739119860e-02]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.151468162573e+00, -1.090629991922e+00, -1.029791821270e+00],
        [-1.142936325147e+00, -1.081259983843e+00, -1.019583642540e+00],
        [-1.094173659412e+00, -1.027706857007e+00, -9.612400546024e-01],
        [-1.032000717575e+00, -9.594260239187e-01, -8.868513302623e-01],
        [-9.430072235326e-01, -8.616897783248e-01, -7.803723331171e-01],
        [-8.271931772849e-01, -7.344981202258e-01, -6.418030631668e-01],
        [-6.979688549345e-01, -5.925787558742e-01, -4.871886568140e-01],
        [-5.285137042761e-01, -4.064762727648e-01, -2.844388412535e-01],
        [-3.590585536178e-01, -2.203737896554e-01, -8.168902569305e-02]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.157669185970e+00, -1.097440205996e+00, -1.037211226021e+00],
        [-1.155338371940e+00, -1.094880411991e+00, -1.034422452043e+00],
        [-1.135168655221e+00, -1.072729215345e+00, -1.010289775469e+00],
        [-1.109052637606e+00, -1.044047551152e+00, -9.790424646967e-01],
        [-1.071044018200e+00, -1.002304951864e+00, -9.335658855280e-01],
        [-1.021142797000e+00, -9.475014174814e-01, -8.738600379625e-01],
        [-9.652952749049e-01, -8.861674155518e-01, -8.070395561987e-01],
        [-8.916088501211e-01, -8.052420109805e-01, -7.188751718399e-01],
        [-8.179224253373e-01, -7.243166064092e-01, -6.307107874810e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.158179850284e+00, -1.098001038148e+00, -1.037822226012e+00],
        [-1.156359700568e+00, -1.096002076296e+00, -1.035644452024e+00],
        [-1.166248652803e+00, -1.106862522610e+00, -1.047476392417e+00],
        [-1.180040639023e+00, -1.122009438313e+00, -1.063978237603e+00],
        [-1.201638693210e+00, -1.145729292794e+00, -1.089819892377e+00],
        [-1.231042815365e+00, -1.178022086052e+00, -1.125001356738e+00],
        [-1.264349971505e+00, -1.214601348699e+00, -1.164852725893e+00],
        [-1.309366229596e+00, -1.264040019512e+00, -1.218713809429e+00],
        [-1.354382487687e+00, -1.313478690326e+00, -1.272574892965e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.156266077188e+00, -1.095899255323e+00, -1.035532433458e+00],
        [-1.152532154376e+00, -1.091798510646e+00, -1.031064866916e+00],
        [-1.186332954573e+00, -1.128919913113e+00, -1.071506871653e+00],
        [-1.232645329106e+00, -1.179782031295e+00, -1.126918733484e+00],
        [-1.303980852311e+00, -1.258125580905e+00, -1.212270309500e+00],
        [-1.400339524189e+00, -1.363950561945e+00, -1.327561599702e+00],
        [-1.509209770402e+00, -1.483516258700e+00, -1.457822746998e+00],
        [-1.655614739625e+00, -1.644304102599e+00, -1.632993465572e+00],
        [-1.802019708847e+00, -1.805091946497e+00, -1.808164184147e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.151557132241e+00, -1.090727702001e+00, -1.029898271760e+00],
        [-1.143114264483e+00, -1.081455404001e+00, -1.019796543520e+00],
        [-1.177847319227e+00, -1.119600646023e+00, -1.061353972820e+00],
        [-1.226972348138e+00, -1.173551734720e+00, -1.120131121301e+00],
        [-1.304881325384e+00, -1.259114516763e+00, -1.213347708143e+00],
        [-1.411574250964e+00, -1.376288992155e+00, -1.341003733346e+00],
        [-1.532659150713e+00, -1.509269314220e+00, -1.485879477728e+00],
        [-1.696919972963e+00, -1.689667176307e+00, -1.682414379652e+00],
        [-1.861180795213e+00, -1.870065038394e+00, -1.878949281575e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.153691451856e+00, -1.093071697910e+00, -1.032451943964e+00],
        [-1.147382903711e+00, -1.086143395820e+00, -1.024903887928e+00],
        [-1.168406023519e+00, -1.109231834169e+00, -1.050057644819e+00],
        [-1.198539699310e+00, -1.142325852664e+00, -1.086112006018e+00],
        [-1.246894487070e+00, -1.195431031452e+00, -1.143967575834e+00],
        [-1.313470386797e+00, -1.268547370533e+00, -1.223624354269e+00],
        [-1.389156842509e+00, -1.351669289760e+00, -1.314181737011e+00],
        [-1.492174966172e+00, -1.464807949426e+00, -1.437440932681e+00],
        [-1.595193089836e+00, -1.577946609093e+00, -1.560700128350e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.160275122405e+00, -1.100302150525e+00, -1.040329178645e+00],
        [-1.160550244809e+00, -1.100604301049e+00, -1.040658357289e+00],
        [-1.161276087082e+00, -1.101401450317e+00, -1.041526813552e+00],
        [-1.162152169310e+00, -1.102363599166e+00, -1.042575029021e+00],
        [-1.163328731450e+00, -1.103655747176e+00, -1.043982762902e+00],
        [-1.164805773503e+00, -1.105277894349e+00, -1.045750015196e+00],
        [-1.166433055511e+00, -1.107065041103e+00, -1.047697026695e+00],
        [-1.168511057386e+00, -1.109347186600e+00, -1.050183315813e+00],
        [-1.170589059262e+00, -1.111629332097e+00, -1.052669604931e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.175080542191e+00, -1.116562059858e+00, -1.058043577525e+00],
        [-1.190161084383e+00, -1.133124119716e+00, -1.076087155049e+00],
        [-1.176459666262e+00, -1.118076669553e+00, -1.059693672844e+00],
        [-1.153164261370e+00, -1.092492716049e+00, -1.031821170728e+00],
        [-1.110680882936e+00, -1.045835755864e+00, -9.809906287923e-01],
        [-1.049009530961e+00, -9.781057889991e-01, -9.072020470366e-01],
        [-9.777441922158e-01, -8.998393187934e-01, -8.219344453709e-01],
        [-8.776968931578e-01, -7.899633385665e-01, -7.022297839751e-01],
        [-7.776495940998e-01, -6.800873583396e-01, -5.825251225793e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.183631048788e+00, -1.125952571172e+00, -1.068274093557e+00],
        [-1.207262097577e+00, -1.151905142345e+00, -1.096548187113e+00],
        [-1.189478821381e+00, -1.132374830961e+00, -1.075270840542e+00],
        [-1.157890770189e+00, -1.097683558725e+00, -1.037476347261e+00],
        [-1.098693169008e+00, -1.032670364785e+00, -9.666475605618e-01],
        [-1.011886017838e+00, -9.373352491408e-01, -8.627844804440e-01],
        [-9.112740916719e-01, -8.268391726444e-01, -7.424042536169e-01],
        [-7.692478405216e-01, -6.708602135918e-01, -5.724725866620e-01],
        [-6.272215893713e-01, -5.148812545391e-01, -4.025409197070e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.187177624834e+00, -1.129847564072e+00, -1.072517503310e+00],
        [-1.214355249668e+00, -1.159695128144e+00, -1.105035006620e+00],
        [-1.200766437251e+00, -1.144771346108e+00, -1.088776254965e+00],
        [-1.173588812417e+00, -1.114923782036e+00, -1.056258751655e+00],
        [-1.119233562749e+00, -1.055228653892e+00, -9.912237450348e-01],
        [-1.037700688247e+00, -9.656859616760e-01, -8.936712351045e-01],
        [-9.425790013287e-01, -8.612194874240e-01, -7.798599735192e-01],
        [-8.066908771592e-01, -7.119816670639e-01, -6.172724569687e-01],
        [-6.708027529897e-01, -5.627438467039e-01, -4.546849404181e-01]]
                ], dtype=np.float64),

                None,  # z mid (interpolation area)

                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.284614807689e-01,  7.742006733321e-01,  8.199398658953e-01],
        [ 4.169229615378e-01,  4.484013466643e-01,  4.798797317907e-01],
        [-3.619233365399e-01, -3.660969700054e-01, -3.702706034709e-01],
        [-1.296538894233e+00, -1.343494950009e+00, -1.390451005785e+00],
        [-2.542692971157e+00, -2.646692256681e+00, -2.750691542204e+00],
        [-4.100385567313e+00, -4.275688890020e+00, -4.450992212727e+00],
        [-5.813847423084e+00, -6.067585186693e+00, -6.321322950302e+00],
        [-7.994617057701e+00, -8.348180473368e+00, -8.701743889035e+00],
        [-1.017538669232e+01, -1.062877576004e+01, -1.108216482777e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.596267154146e-01,  9.113700520506e-01,  9.631133886866e-01],
        [ 6.792534308293e-01,  7.227401041012e-01,  7.662267773732e-01],
        [ 1.987018503442e-01,  2.201910718415e-01,  2.416802933388e-01],
        [-3.819091621074e-01, -3.869976551884e-01, -3.920861482693e-01],
        [-1.162639038492e+00, -1.203465771758e+00, -1.244292505025e+00],
        [-2.143487778810e+00, -2.229213277869e+00, -2.314938776928e+00],
        [-3.224395951094e+00, -3.359600478749e+00, -3.494805006404e+00],
        [-4.605482419279e+00, -4.803906763940e+00, -5.002331108602e+00],
        [-5.986568887463e+00, -6.248213049131e+00, -6.509857210799e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 9.931945441770e-01,  1.051052004647e+00,  1.108909465118e+00],
        [ 9.463890883541e-01,  1.002104009295e+00,  1.057818930235e+00],
        [ 8.324456398523e-01,  8.829447512622e-01,  9.334438626722e-01],
        [ 6.961228604576e-01,  7.403817390033e-01,  7.846406175489e-01],
        [ 5.150414192771e-01,  5.510112182912e-01,  5.869810173053e-01],
        [ 2.892013163107e-01,  3.148331891260e-01,  3.404650619412e-01],
        [ 4.098188245143e-02,  5.525140573419e-02,  6.952092901695e-02],
        [-2.743755440866e-01, -2.745416403373e-01, -2.747077365879e-01],
        [-5.897329706247e-01, -6.043346864088e-01, -6.189364021928e-01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.129765615585e+00,  1.193874674592e+00,  1.257983733598e+00],
        [ 1.219531231171e+00,  1.287749349183e+00,  1.355967467196e+00],
        [ 1.557587682640e+00,  1.641280477650e+00,  1.724973272660e+00],
        [ 1.978407746072e+00,  2.081363757409e+00,  2.184319768745e+00],
        [ 2.564755033426e+00,  2.694551339750e+00,  2.824347646074e+00],
        [ 3.316629544704e+00,  3.480843224675e+00,  3.645056904647e+00],
        [ 4.151267667943e+00,  4.353687260892e+00,  4.556106853841e+00],
        [ 5.234196627067e+00,  5.486187750984e+00,  5.738178874901e+00],
        [ 6.317125586190e+00,  6.618688241075e+00,  6.920250895960e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.143227555946e+00,  1.207952840964e+00,  1.272678125982e+00],
        [ 1.246455111891e+00,  1.315905681928e+00,  1.385356251964e+00],
        [ 1.733252817162e+00,  1.824986757977e+00,  1.916720698791e+00],
        [ 2.347907238876e+00,  2.467777245721e+00,  2.587647252565e+00],
        [ 3.218275093473e+00,  3.377986556855e+00,  3.537698020237e+00],
        [ 4.344356380954e+00,  4.555614691379e+00,  4.766873001804e+00],
        [ 5.598294384877e+00,  5.866952237598e+00,  6.135610090320e+00],
        [ 7.235802538125e+00,  7.579418018903e+00,  7.923033499681e+00],
        [ 8.873310691374e+00,  9.291883800208e+00,  9.710456909042e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.122061945447e+00,  1.185818365696e+00,  1.249574785944e+00],
        [ 1.204123890894e+00,  1.271636731391e+00,  1.339149571889e+00],
        [ 1.673138830497e+00,  1.762121028155e+00,  1.851103225813e+00],
        [ 2.271138101486e+00,  2.387493968609e+00,  2.503849835732e+00],
        [ 3.127106035246e+00,  3.282644196442e+00,  3.438182357637e+00],
        [ 4.241042631778e+00,  4.447571711654e+00,  4.654100791529e+00],
        [ 5.483963559695e+00,  5.747387870555e+00,  6.010812181415e+00],
        [ 7.113837481769e+00,  7.451869960525e+00,  7.789902439281e+00],
        [ 8.743711403843e+00,  9.156352050495e+00,  9.568992697147e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.062418515992e+00,  1.123444733040e+00,  1.184470950088e+00],
        [ 1.084837031984e+00,  1.146889466080e+00,  1.208941900176e+00],
        [ 1.278835828523e+00,  1.349768639554e+00,  1.420701450585e+00],
        [ 1.530028051912e+00,  1.612459293173e+00,  1.694890534434e+00],
        [ 1.895607129000e+00,  1.994772907082e+00,  2.093938685164e+00],
        [ 2.375573059787e+00,  2.496709481281e+00,  2.617845902775e+00],
        [ 2.912732417422e+00,  3.058457535624e+00,  3.204182653826e+00],
        [ 3.621472055606e+00,  3.799640030402e+00,  3.977808005198e+00],
        [ 4.330211693790e+00,  4.540822525180e+00,  4.751433356570e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.057506783035e+00,  1.118308163431e+00,  1.179109543826e+00],
        [ 1.075013566070e+00,  1.136616326861e+00,  1.198219087652e+00],
        [ 9.798984556543e-01,  1.037147282051e+00,  1.094396108447e+00],
        [ 8.472427140877e-01,  8.984191678270e-01,  9.495956215663e-01],
        [ 6.395057102203e-01,  6.811729147761e-01,  7.228401193318e-01],
        [ 3.566874440521e-01,  3.854085228979e-01,  4.141296017438e-01],
        [ 3.632854673336e-02,  5.038506160619e-02,  6.444157647902e-02],
        [-3.966522440366e-01, -4.024156079263e-01, -4.081789718159e-01],
        [-8.296330348066e-01, -8.552162774588e-01, -8.807995201109e-01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.075914065725e+00,  1.137558047268e+00,  1.199202028811e+00],
        [ 1.111828131450e+00,  1.175116094536e+00,  1.238404057622e+00],
        [ 7.867212074544e-01,  8.351272636390e-01,  8.835333198235e-01],
        [ 3.412739535518e-01,  3.692894733531e-01,  3.973049931545e-01],
        [-3.448539601647e-01, -3.482462357097e-01, -3.516385112547e-01],
        [-1.271662533695e+00, -1.317479863550e+00, -1.363297193404e+00],
        [-2.318811437132e+00, -2.412562450778e+00, -2.506313464423e+00],
        [-3.726981330290e+00, -3.885191916172e+00, -4.043402502053e+00],
        [-5.135151223448e+00, -5.357821381566e+00, -5.580491539683e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.121206206679e+00,  1.184923455124e+00,  1.248640703569e+00],
        [ 1.202412413358e+00,  1.269846910248e+00,  1.337281407138e+00],
        [ 8.683387664919e-01,  9.204809009494e-01,  9.726230354069e-01],
        [ 3.958385017772e-01,  4.263517368435e-01,  4.568649719099e-01],
        [-3.535149986344e-01, -3.573037368772e-01, -3.610924751201e-01],
        [-1.379721734743e+00, -1.430485520213e+00, -1.481249305683e+00],
        [-2.544355088700e+00, -2.648430458356e+00, -2.752505828012e+00],
        [-4.124268296202e+00, -4.300664860922e+00, -4.477061425641e+00],
        [-5.704181503704e+00, -5.952899263487e+00, -6.201617023270e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.100677636926e+00,  1.163455181410e+00,  1.226232725895e+00],
        [ 1.161355273851e+00,  1.226910362821e+00,  1.292465451791e+00],
        [ 9.591481730235e-01,  1.015447146459e+00,  1.071746119895e+00],
        [ 6.693128262783e-01,  7.123444641740e-01,  7.553761020698e-01],
        [ 2.042209876977e-01,  2.259628500408e-01,  2.477047123840e-01],
        [-4.361273427184e-01, -4.436976959403e-01, -4.512680491622e-01],
        [-1.164103919052e+00, -1.204997707845e+00, -1.245891496639e+00],
        [-2.154965233139e+00, -2.241216117522e+00, -2.327467001906e+00],
        [-3.145826547226e+00, -3.277434527199e+00, -3.409042507172e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.037353784579e+00,  1.097232652950e+00,  1.157111521320e+00],
        [ 1.034707569159e+00,  1.094465305899e+00,  1.154223042640e+00],
        [ 1.027726185667e+00,  1.087164346626e+00,  1.146602507586e+00],
        [ 1.019299746151e+00,  1.078352183279e+00,  1.137404620407e+00],
        [ 1.007983194588e+00,  1.066517611784e+00,  1.125052028979e+00],
        [ 9.937765309775e-01,  1.051660632140e+00,  1.109544733302e+00],
        [ 9.781248113430e-01,  1.035292448421e+00,  1.092460085500e+00],
        [ 9.581379236372e-01,  1.014390652480e+00,  1.070643381323e+00],
        [ 9.381510359315e-01,  9.934888565393e-01,  1.048826677147e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.949505143229e-01,  9.483108127889e-01,  1.001671111255e+00],
        [ 7.499010286458e-01,  7.966216255778e-01,  8.433422225097e-01],
        [ 8.816856572283e-01,  9.344387512524e-01,  9.871918452765e-01],
        [ 1.105748323897e+00,  1.168757981222e+00,  1.231767638547e+00],
        [ 1.514367066739e+00,  1.596081419783e+00,  1.677795772826e+00],
        [ 2.107541885754e+00,  2.216409066933e+00,  2.325276248112e+00],
        [ 2.792994742856e+00,  2.933238818379e+00,  3.073482893903e+00],
        [ 3.755281714217e+00,  3.939574882711e+00,  4.123868051205e+00],
        [ 4.717568685578e+00,  4.945910947043e+00,  5.174253208507e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.127090028138e-01,  8.623046613186e-01,  9.119003198234e-01],
        [ 5.854180056276e-01,  6.246093226372e-01,  6.638006396468e-01],
        [ 7.564632527550e-01,  8.034842382700e-01,  8.505052237851e-01],
        [ 1.060287247987e+00,  1.121215905341e+00,  1.182144562695e+00],
        [ 1.629668739428e+00,  1.716661075288e+00,  1.803653411148e+00],
        [ 2.464607727078e+00,  2.589819748111e+00,  2.715031769145e+00],
        [ 3.432325462832e+00,  3.601835172373e+00,  3.771344881913e+00],
        [ 4.798379442901e+00,  5.030420850948e+00,  5.262462258996e+00],
        [ 6.164433422969e+00,  6.459006529524e+00,  6.753579636079e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.785968983026e-01,  8.266310608007e-01,  8.746652232989e-01],
        [ 5.171937966051e-01,  5.532621216014e-01,  5.893304465977e-01],
        [ 6.478953474538e-01,  6.899465912011e-01,  7.319978349483e-01],
        [ 9.092984491513e-01,  9.633155304004e-01,  1.017332611649e+00],
        [ 1.432104652546e+00,  1.510053408799e+00,  1.588002165052e+00],
        [ 2.216313957638e+00,  2.330160226397e+00,  2.444006495155e+00],
        [ 3.131224813580e+00,  3.286951513594e+00,  3.442678213609e+00],
        [ 4.438240322067e+00,  4.653796209591e+00,  4.869352097115e+00],
        [ 5.745255830554e+00,  6.020640905587e+00,  6.296025980620e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.366855752126e+00, -2.425417677498e+00, -2.483979602869e+00],
        [-2.428073072886e+00, -2.492649008965e+00, -2.557224945043e+00],
        [-2.489290393646e+00, -2.559880340432e+00, -2.630470287218e+00]],
       [[-1.916386166768e+00, -1.930693804693e+00, -1.945001442617e+00],
        [-1.955155238007e+00, -1.973271562863e+00, -1.991387887719e+00],
        [-1.993924309246e+00, -2.015849321033e+00, -2.037774332820e+00]],
       [[-1.335342185331e+00, -1.292567862099e+00, -1.249793538867e+00],
        [-1.344194719055e+00, -1.302290071789e+00, -1.260385424524e+00],
        [-1.353047252779e+00, -1.312012281480e+00, -1.270977310181e+00]],
       [[-5.910802087951e-01, -4.751893322689e-01, -3.592984557427e-01],
        [-5.606808450115e-01, -4.418035245015e-01, -3.229262039915e-01],
        [-5.302814812279e-01, -4.084177167341e-01, -2.865539522403e-01]],
       [[-3.149395452907e-01, -1.719205147322e-01, -2.890148417375e-02],
        [-2.689723508318e-01, -1.214374872341e-01,  2.609737636352e-02],
        [-2.230051563728e-01, -7.095445973603e-02,  8.109623690079e-02]],
       [[-3.285566264993e-01, -1.868753426958e-01, -4.519405889217e-02],
        [-2.828037358216e-01, -1.366276722562e-01,  9.548391309148e-03],
        [-2.370508451438e-01, -8.638000181668e-02,  6.429084151047e-02]],
       [[-8.046588688762e-01, -7.097500335863e-01, -6.148411982965e-01],
        [-7.847635341846e-01, -6.879001743521e-01, -5.910368145196e-01],
        [-7.648681994930e-01, -6.660503151178e-01, -5.672324307427e-01]],
       [[-1.362485414143e+00, -1.322377651072e+00, -1.282269888001e+00],
        [-1.374639803828e+00, -1.335726092192e+00, -1.296812380556e+00],
        [-1.386794193513e+00, -1.349074533312e+00, -1.311354873111e+00]],
       [[-1.828372603307e+00, -1.834033758399e+00, -1.839694913490e+00],
        [-1.867901944997e+00, -1.877446476251e+00, -1.886991007505e+00],
        [-1.907431286687e+00, -1.920859194104e+00, -1.934287101521e+00]],
       [[-1.890747743218e+00, -1.902536653570e+00, -1.914325563922e+00],
        [-1.935098165226e+00, -1.951244076334e+00, -1.967389987441e+00],
        [-1.979448587234e+00, -1.999951499097e+00, -2.020454410960e+00]],
       [[-1.613736352095e+00, -1.598311567833e+00, -1.582886783570e+00],
        [-1.641551245484e+00, -1.628859005943e+00, -1.616166766401e+00],
        [-1.669366138873e+00, -1.659406444053e+00, -1.649446749232e+00]],
       [[-1.170963099600e+00, -1.112040118286e+00, -1.053117136972e+00],
        [-1.171524160106e+00, -1.112656297570e+00, -1.053788435034e+00],
        [-1.172085220613e+00, -1.113272476854e+00, -1.054459733096e+00]],
       [[-7.596410802694e-01, -6.603096818987e-01, -5.609782835280e-01],
        [-7.326283095237e-01, -6.306431672374e-01, -5.286580249512e-01],
        [-7.056155387781e-01, -6.009766525762e-01, -4.963377663743e-01]],
       [[-6.016568641642e-01, -4.868050419096e-01, -3.719532196551e-01],
        [-5.633097763536e-01, -4.446907229654e-01, -3.260716695772e-01],
        [-5.249626885430e-01, -4.025764040212e-01, -2.801901194994e-01]],
       [[-6.463428906391e-01, -5.358810390391e-01, -4.254191874391e-01],
        [-6.096530971134e-01, -4.955868275419e-01, -3.815205579704e-01],
        [-5.729633035876e-01, -4.552926160447e-01, -3.376219285018e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.523020886450e+00, -2.662454042096e+00, -2.801887197742e+00, -2.941320353387e+00, -3.172317369609e+00, -3.494878246406e+00, -3.817439123203e+00, -4.140000000000e+00, -4.764487445914e+00, -5.388974891828e+00, -6.013462337742e+00, -6.886846162002e+00, -8.009126364608e+00, -9.131406567214e+00, -1.025368676982e+01],
        [-2.600275569096e+00, -2.754027797854e+00, -2.907780026612e+00, -3.061532255371e+00, -3.311492888357e+00, -3.657661925571e+00, -4.003830962786e+00, -4.350000000000e+00, -5.013410722156e+00, -5.676821444312e+00, -6.340232166468e+00, -7.265164445581e+00, -8.451618281653e+00, -9.638072117725e+00, -1.082452595380e+01],
        [-2.677530251742e+00, -2.845601553613e+00, -3.013672855483e+00, -3.181744157354e+00, -3.450668407105e+00, -3.820445604737e+00, -4.190222802368e+00, -4.560000000000e+00, -5.262333998398e+00, -5.964667996796e+00, -6.667001995194e+00, -7.643482729161e+00, -8.894110198699e+00, -1.014473766824e+01, -1.139536513777e+01]],
       [[-1.954539867901e+00, -1.988605672483e+00, -2.022671477065e+00, -2.056737281648e+00, -2.148189925870e+00, -2.297029409731e+00, -2.445868893592e+00, -2.594708377454e+00, -2.932777667659e+00, -3.270846957864e+00, -3.608916248069e+00, -4.102979141659e+00, -4.753035638634e+00, -5.403092135608e+00, -6.053148632583e+00],
        [-2.003465437623e+00, -2.046599544422e+00, -2.089733651222e+00, -2.132867758021e+00, -2.236330104729e+00, -2.400120691345e+00, -2.563911277960e+00, -2.727701864576e+00, -3.090421355913e+00, -3.453140847250e+00, -3.815860338587e+00, -4.342568988209e+00, -5.033266796117e+00, -5.723964604024e+00, -6.414662411931e+00],
        [-2.052391007345e+00, -2.104593416361e+00, -2.156795825378e+00, -2.208998234394e+00, -2.324470283588e+00, -2.503211972958e+00, -2.681953662328e+00, -2.860695351699e+00, -3.248065044167e+00, -3.635434736636e+00, -4.022804429104e+00, -4.582158834759e+00, -5.313497953599e+00, -6.044837072440e+00, -6.776176191280e+00]],
       [[-1.221277323379e+00, -1.119433696636e+00, -1.017590069893e+00, -9.157464431499e-01, -8.272059865517e-01, -7.519687000981e-01, -6.767314136446e-01, -6.014941271910e-01, -5.701232799082e-01, -5.387524326253e-01, -5.073815853425e-01, -5.121725037249e-01, -5.531251877727e-01, -5.940778718204e-01, -6.350305558682e-01],
        [-1.232448993014e+00, -1.132676023334e+00, -1.032903053654e+00, -9.331300839742e-01, -8.473319240798e-01, -7.755085739707e-01, -7.036852238616e-01, -6.318618737525e-01, -6.061196559375e-01, -5.803774381226e-01, -5.546352203076e-01, -5.668804739884e-01, -6.171131991647e-01, -6.673459243411e-01, -7.175786495175e-01],
        [-1.243620662648e+00, -1.145918350032e+00, -1.048216037415e+00, -9.505137247986e-01, -8.674578616079e-01, -7.990484478433e-01, -7.306390340786e-01, -6.622296203139e-01, -6.421160319669e-01, -6.220024436199e-01, -6.018888552728e-01, -6.215884442518e-01, -6.811012105568e-01, -7.406139768618e-01, -8.001267431667e-01]],
       [[-2.820378713919e-01, -6.107212996077e-03,  2.698234453997e-01,  5.457541037955e-01,  8.648485722397e-01,  1.227106850732e+00,  1.589365129225e+00,  1.951623407717e+00,  2.456211869712e+00,  2.960800331707e+00,  3.465388793702e+00,  4.087308656199e+00,  4.826559919197e+00,  5.565811182195e+00,  6.305062445193e+00],
        [-2.436746569848e-01,  3.936658232479e-02,  3.224078216344e-01,  6.054490609440e-01,  9.339605028448e-01,  1.307942147337e+00,  1.681923791829e+00,  2.055905436321e+00,  2.579822461204e+00,  3.103739486087e+00,  3.627656510970e+00,  4.275174361293e+00,  5.046293037056e+00,  5.817411712819e+00,  6.588530388582e+00],
        [-2.053114425777e-01,  8.484037764567e-02,  3.749921978690e-01,  6.651440180924e-01,  1.003072433450e+00,  1.388777443942e+00,  1.774482454434e+00,  2.160187464925e+00,  2.703433052696e+00,  3.246678640466e+00,  3.789924228237e+00,  4.463040066386e+00,  5.266026154915e+00,  6.069012243443e+00,  6.871998331972e+00]],
       [[ 6.644453619856e-02,  4.069660375283e-01,  7.474875388580e-01,  1.088009040188e+00,  1.492645078418e+00,  1.961395653548e+00,  2.430146228678e+00,  2.898896803808e+00,  3.579061380435e+00,  4.259225957062e+00,  4.939390533689e+00,  5.793836490912e+00,  6.822563828731e+00,  7.851291166550e+00,  8.880018504369e+00],
        [ 1.244539520953e-01,  4.757274368516e-01,  8.270009216079e-01,  1.178274406364e+00,  1.597149948196e+00,  2.083627547104e+00,  2.570105146012e+00,  3.056582744920e+00,  3.765974242715e+00,  4.475365740511e+00,  5.184757238306e+00,  6.077910179417e+00,  7.154824563843e+00,  8.231738948270e+00,  9.308653332696e+00],
        [ 1.824633679920e-01,  5.444888361749e-01,  9.065143043578e-01,  1.268539772541e+00,  1.701654817975e+00,  2.205859440660e+00,  2.710064063346e+00,  3.214268686031e+00,  3.952887104995e+00,  4.691505523959e+00,  5.430123942923e+00,  6.361983867922e+00,  7.487085298956e+00,  8.612186729990e+00,  9.737288161023e+00]],
       [[ 4.926013031021e-02,  3.865965203187e-01,  7.239329103273e-01,  1.061269300336e+00,  1.461687102513e+00,  1.925186316858e+00,  2.388685531203e+00,  2.852184745549e+00,  3.523691291950e+00,  4.195197838351e+00,  4.866704384752e+00,  5.709683987564e+00,  6.724136646787e+00,  7.738589306010e+00,  8.753041965233e+00],
        [ 1.069991003527e-01,  4.550373469369e-01,  8.030755935211e-01,  1.151113840105e+00,  1.565704759856e+00,  2.046848352774e+00,  2.527991945692e+00,  3.009135538609e+00,  3.709732747271e+00,  4.410329955932e+00,  5.110927164594e+00,  5.992433295360e+00,  7.054848348231e+00,  8.117263401101e+00,  9.179678453972e+00],
        [ 1.647380703952e-01,  5.234781735551e-01,  8.822182767150e-01,  1.240958379875e+00,  1.669722417200e+00,  2.168510388690e+00,  2.667298360180e+00,  3.166086331670e+00,  3.895774202592e+00,  4.625462073514e+00,  5.355149944436e+00,  6.275182603156e+00,  7.385560049674e+00,  8.495937496192e+00,  9.606314942711e+00]],
       [[-5.515686414365e-01, -3.255952240797e-01, -9.962180672278e-02,  1.263516106341e-01,  3.792846755956e-01,  6.591773881619e-01,  9.390701007281e-01,  1.218962813294e+00,  1.587753414773e+00,  1.956544016252e+00,  2.325334617731e+00,  2.767409139396e+00,  3.282767581245e+00,  3.798126023095e+00,  4.313484464945e+00],
        [-5.264612412979e-01, -2.958341940776e-01, -6.520714685733e-02,  1.654199003630e-01,  4.245160495271e-01,  7.120813006350e-01,  9.996465517430e-01,  1.287211802851e+00,  1.668652281824e+00,  2.050092760797e+00,  2.431533239770e+00,  2.890360761230e+00,  3.426575325176e+00,  3.962789889122e+00,  4.499004453068e+00],
        [-5.013538411593e-01, -2.660731640756e-01, -3.079248699189e-02,  2.044881900918e-01,  4.697474234585e-01,  7.649852131082e-01,  1.060223002758e+00,  1.355460792408e+00,  1.749551148875e+00,  2.143641505342e+00,  2.537731861809e+00,  3.013312383064e+00,  3.570383069106e+00,  4.127453755148e+00,  4.684524441191e+00]],
       [[-1.255531379287e+00, -1.160036705309e+00, -1.064542031330e+00, -9.690473573519e-01, -8.889152038706e-01, -8.241455708865e-01, -7.593759379024e-01, -6.946063049182e-01, -6.804937005648e-01, -6.663810962113e-01, -6.522684918579e-01, -6.799155478113e-01, -7.493222640717e-01, -8.187289803320e-01, -8.881356965924e-01],
        [-1.270869906132e+00, -1.178218211761e+00, -1.085566517390e+00, -9.929148230184e-01, -9.165477998160e-01, -8.564654477825e-01, -7.963830957491e-01, -7.363007437156e-01, -7.299161591672e-01, -7.235315746188e-01, -7.171469900704e-01, -7.550287312429e-01, -8.371767981363e-01, -9.193248650296e-01, -1.001472931923e+00],
        [-1.286208432977e+00, -1.196399718213e+00, -1.106591003449e+00, -1.016782288685e+00, -9.441803957614e-01, -8.887853246786e-01, -8.333902535958e-01, -7.779951825130e-01, -7.793386177696e-01, -7.806820530263e-01, -7.820254882830e-01, -8.301419146745e-01, -9.250313322009e-01, -1.019920749727e+00, -1.114810167254e+00]],
       [[-1.843469016885e+00, -1.856947957579e+00, -1.870426898273e+00, -1.883905838967e+00, -1.948094051050e+00, -2.062991534522e+00, -2.177889017994e+00, -2.292786501466e+00, -2.574894893659e+00, -2.857003285851e+00, -3.139111678044e+00, -3.559062161188e+00, -4.116854735282e+00, -4.674647309376e+00, -5.232439883471e+00],
        [-1.893354028341e+00, -1.916079102756e+00, -1.938804177170e+00, -1.961529251585e+00, -2.037962679196e+00, -2.168104460005e+00, -2.298246240813e+00, -2.428388021621e+00, -2.735630011090e+00, -3.042872000558e+00, -3.350113990026e+00, -3.803350420026e+00, -4.402581290558e+00, -5.001812161089e+00, -5.601043031621e+00],
        [-1.943239039798e+00, -1.975210247933e+00, -2.007181456068e+00, -2.039152664203e+00, -2.127831307343e+00, -2.273217385487e+00, -2.418603463632e+00, -2.563989541777e+00, -2.896365128521e+00, -3.228740715264e+00, -3.561116302008e+00, -4.047638678865e+00, -4.688307845833e+00, -5.328977012802e+00, -5.969646179771e+00]],
       [[-1.922184837489e+00, -1.950253671660e+00, -1.978322505830e+00, -2.006391340001e+00, -2.089901832678e+00, -2.228853983861e+00, -2.367806135044e+00, -2.506758286228e+00, -2.828526120736e+00, -3.150293955245e+00, -3.472061789753e+00, -3.944535677120e+00, -4.567715617344e+00, -5.190895557568e+00, -5.814075497792e+00],
        [-1.978153928179e+00, -2.016596573673e+00, -2.055039219167e+00, -2.093481864661e+00, -2.190731024693e+00, -2.346786699264e+00, -2.502842373835e+00, -2.658898048406e+00, -3.008864825727e+00, -3.358831603048e+00, -3.708798380369e+00, -4.218617837555e+00, -4.888289974605e+00, -5.557962111656e+00, -6.227634248706e+00],
        [-2.034123018869e+00, -2.082939475687e+00, -2.131755932504e+00, -2.180572389322e+00, -2.291560216709e+00, -2.464719414667e+00, -2.637878612625e+00, -2.811037810583e+00, -3.189203530717e+00, -3.567369250851e+00, -3.945534970984e+00, -4.492699997990e+00, -5.208864331867e+00, -5.925028665744e+00, -6.641192999620e+00]],
       [[-1.572603594062e+00, -1.535877917247e+00, -1.499152240432e+00, -1.462426563617e+00, -1.460125756558e+00, -1.492249819255e+00, -1.524373881952e+00, -1.556497944650e+00, -1.702136037363e+00, -1.847774130075e+00, -1.993412222788e+00, -2.232626813406e+00, -2.565417901929e+00, -2.898208990452e+00, -3.231000078975e+00],
        [-1.607705273373e+00, -1.577485655417e+00, -1.547266037461e+00, -1.517046419505e+00, -1.523361980691e+00, -1.566212721017e+00, -1.609063461343e+00, -1.651914201670e+00, -1.815237595954e+00, -1.978560990238e+00, -2.141884384522e+00, -2.404520692366e+00, -2.766469913768e+00, -3.128419135170e+00, -3.490368356572e+00],
        [-1.642806952685e+00, -1.619093393588e+00, -1.595379834491e+00, -1.571666275394e+00, -1.586598204823e+00, -1.640175622778e+00, -1.693753040734e+00, -1.747330458690e+00, -1.928339154545e+00, -2.109347850401e+00, -2.290356546256e+00, -2.576414571325e+00, -2.967521925606e+00, -3.358629279888e+00, -3.749736634169e+00]],
       [[-1.013835149430e+00, -8.735423367777e-01, -7.332495241258e-01, -5.929567114739e-01, -4.534956665966e-01, -3.148663894939e-01, -1.762371123912e-01, -3.760783528856e-02,  9.827873536953e-02,  2.341653060276e-01,  3.700518766857e-01,  5.036774681166e-01,  6.350420803202e-01,  7.664066925238e-01,  8.977713047274e-01],
        [-1.014543193343e+00, -8.743816158763e-01, -7.342200384093e-01, -5.940584609424e-01, -4.547712187780e-01, -3.163583119162e-01, -1.779454050545e-01, -3.953249819269e-02,  9.599733824687e-02,  2.315271746864e-01,  3.670570111260e-01,  5.002101578006e-01,  6.309866147101e-01,  7.617630716197e-01,  8.925395285292e-01],
        [-1.015251237257e+00, -8.752208949749e-01, -7.351905526929e-01, -5.951602104109e-01, -4.560467709594e-01, -3.178502343386e-01, -1.796536977177e-01, -4.145716109683e-02,  9.371594112421e-02,  2.288890433453e-01,  3.640621455663e-01,  4.967428474846e-01,  6.269311491000e-01,  7.571194507155e-01,  8.873077523310e-01]],
       [[-4.947573512809e-01, -2.582540218269e-01, -2.175069237296e-02,  2.147526370810e-01,  4.816311031177e-01,  7.788847057370e-01,  1.076138308356e+00,  1.373391910976e+00,  1.770805781163e+00,  2.168219651351e+00,  2.565633521539e+00,  3.045615573536e+00,  3.608165807343e+00,  4.170716041151e+00,  4.733266274958e+00],
        [-4.606679300937e-01, -2.178461627454e-01,  2.497560460290e-02,  2.677973719512e-01,  5.430437284119e-01,  8.507146739852e-01,  1.158385619558e+00,  1.466056565132e+00,  1.880645730232e+00,  2.295234895332e+00,  2.709824060432e+00,  3.212552396912e+00,  3.803419904771e+00,  4.394287412631e+00,  4.985154920490e+00],
        [-4.265785089064e-01, -1.774383036638e-01,  7.170190157877e-02,  3.208421068213e-01,  6.044563537062e-01,  9.225446422334e-01,  1.240632930761e+00,  1.558721219288e+00,  1.990485679300e+00,  2.422250139313e+00,  2.854014599325e+00,  3.379489220287e+00,  3.998674002199e+00,  4.617858784111e+00,  5.237043566023e+00]],
       [[-2.953853381520e-01, -2.192861849835e-02,  2.515281011553e-01,  5.249848208090e-01,  8.408029021689e-01,  1.198982345235e+00,  1.557161788301e+00,  1.915341231367e+00,  2.413204830635e+00,  2.911068429902e+00,  3.408932029170e+00,  4.021945748192e+00,  4.750109586969e+00,  5.478273425747e+00,  6.206437264524e+00],
        [-2.469923006518e-01,  3.543401693911e-02,  3.178603345300e-01,  6.002866521209e-01,  9.279837159037e-01,  1.300951525878e+00,  1.673919335853e+00,  2.046887145828e+00,  2.569132640177e+00,  3.091378134526e+00,  3.613623628875e+00,  4.258927769958e+00,  5.027290557776e+00,  5.795653345593e+00,  6.564016133411e+00],
        [-1.985992631515e-01,  9.279665237657e-02,  3.841925679047e-01,  6.755884834328e-01,  1.015164529639e+00,  1.402920706522e+00,  1.790676883405e+00,  2.178433060289e+00,  2.725060449719e+00,  3.271687839149e+00,  3.818315228580e+00,  4.495909791724e+00,  5.304471528582e+00,  6.113033265440e+00,  6.921595002298e+00]],
       [[-3.517779530390e-01, -8.877354446749e-02,  1.742308641040e-01,  4.372352726756e-01,  7.392107246898e-01,  1.080157220147e+00,  1.421103715604e+00,  1.762050211061e+00,  2.231501483048e+00,  2.700952755036e+00,  3.170404027023e+00,  3.745789578237e+00,  4.427109408678e+00,  5.108429239118e+00,  5.789749069558e+00],
        [-3.054763782561e-01, -3.389002213354e-02,  2.376963339890e-01,  5.092826901116e-01,  8.226237356370e-01,  1.177719470565e+00,  1.532815205494e+00,  1.887910940422e+00,  2.380690364490e+00,  2.873469788559e+00,  3.366249212627e+00,  3.972529650152e+00,  4.692311101134e+00,  5.412092552116e+00,  6.131874003098e+00],
        [-2.591748034732e-01,  2.099350020042e-02,  3.011618038740e-01,  5.813301075476e-01,  9.060367465843e-01,  1.275281720984e+00,  1.644526695384e+00,  2.013771669783e+00,  2.529879245933e+00,  3.045986822082e+00,  3.562094398231e+00,  4.199269722067e+00,  4.957512793591e+00,  5.715755865114e+00,  6.473998936638e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.056792522655e+01, -1.103928291164e+01, -1.151064059674e+01],
        [-1.115673302790e+01, -1.165504363905e+01, -1.215335425020e+01],
        [-1.174554082924e+01, -1.227080436645e+01, -1.279606790366e+01]],
       [[-6.235164451736e+00, -6.508188180465e+00, -6.781211909195e+00],
        [-6.608057798146e+00, -6.898150877467e+00, -7.188243956788e+00],
        [-6.980951144555e+00, -7.288113574468e+00, -7.595276004381e+00]],
       [[-6.464973074016e-01, -6.636974347016e-01, -6.808975620017e-01],
        [-7.316438125669e-01, -7.527415571409e-01, -7.738393017150e-01],
        [-8.167903177321e-01, -8.417856795802e-01, -8.667810414283e-01]],
       [[ 6.512052798833e+00,  6.822538329292e+00,  7.133023859751e+00],
        [ 6.804443617796e+00,  7.128313461617e+00,  7.452183305437e+00],
        [ 7.096834436759e+00,  7.434088593941e+00,  7.771342751123e+00]],
       [[ 9.168062158959e+00,  9.600127640843e+00,  1.003219312273e+01],
        [ 9.610189360336e+00,  1.006249340179e+01,  1.051479744325e+01],
        [ 1.005231656171e+01,  1.052485916275e+01,  1.099740176378e+01]],
       [[ 9.037088709816e+00,  9.463158826690e+00,  9.889228943563e+00],
        [ 9.477154668776e+00,  9.923368990981e+00,  1.036958331319e+01],
        [ 9.917220627736e+00,  1.038357915527e+01,  1.084993768281e+01]],
       [[ 4.457784828663e+00,  4.674235374240e+00,  4.890685919817e+00],
        [ 4.649144530973e+00,  4.874354647830e+00,  5.099564764687e+00],
        [ 4.840504233282e+00,  5.074473921420e+00,  5.308443609558e+00]],
       [[-9.075695771453e-01, -9.367203979746e-01, -9.658712188039e-01],
        [-1.024474390653e+00, -1.058976578748e+00, -1.093478766844e+00],
        [-1.141379204161e+00, -1.181232759522e+00, -1.221086314883e+00]],
       [[-5.388621804217e+00, -5.622894685336e+00, -5.857167566456e+00],
        [-5.768827675370e+00, -6.020504640993e+00, -6.272181606616e+00],
        [-6.149033546522e+00, -6.418114596649e+00, -6.687195646776e+00]],
       [[-5.988565881055e+00, -6.250301455949e+00, -6.512037030843e+00],
        [-6.415142447080e+00, -6.696404744642e+00, -6.977667042203e+00],
        [-6.841719013106e+00, -7.142508033334e+00, -7.443297053563e+00]],
       [[-3.324181583761e+00, -3.463953840941e+00, -3.603726098120e+00],
        [-3.591714138565e+00, -3.743732811554e+00, -3.895751484543e+00],
        [-3.859246693368e+00, -4.023511782166e+00, -4.187776870965e+00]],
       [[ 9.345533961444e-01,  9.897265332700e-01,  1.044899670395e+00],
        [ 9.291569364639e-01,  9.840830483659e-01,  1.039009160268e+00],
        [ 9.237604767833e-01,  9.784395634618e-01,  1.033118650140e+00]],
       [[ 4.890780340424e+00,  5.127051438622e+00,  5.363322536821e+00],
        [ 5.150597822691e+00,  5.398762175992e+00,  5.646926529293e+00],
        [ 5.410415304959e+00,  5.670472913362e+00,  5.930530521765e+00]],
       [[ 6.410323139381e+00,  6.716151951667e+00,  7.021980763954e+00],
        [ 6.779157714000e+00,  7.101870084883e+00,  7.424582455766e+00],
        [ 7.147992288618e+00,  7.487588218098e+00,  7.827184147579e+00]],
       [[ 5.980518622082e+00,  6.266672950867e+00,  6.552827279651e+00],
        [ 6.333412809373e+00,  6.635721018786e+00,  6.938029228198e+00],
        [ 6.686306996665e+00,  7.004769086705e+00,  7.323231176745e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x sup
            [  # y inf
                np.array([  # z inf
       [[-1.139717120389e+00, -1.077724523300e+00, -1.015731926210e+00],
        [-1.147323200243e+00, -1.086077827062e+00, -1.024832453882e+00],
        [-1.154929280097e+00, -1.094431130825e+00, -1.033932981553e+00]],
       [[-1.138644635793e+00, -1.076546677447e+00, -1.014448719101e+00],
        [-1.146652897370e+00, -1.085341673404e+00, -1.024030449438e+00],
        [-1.154661158948e+00, -1.094136669362e+00, -1.033612179775e+00]],
       [[-1.137572151196e+00, -1.075368831594e+00, -1.013165511991e+00],
        [-1.145982594498e+00, -1.084605519746e+00, -1.023228444995e+00],
        [-1.154393037799e+00, -1.093842207898e+00, -1.033291377998e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.744035281509e-01, -8.268021065100e-01, -6.792006848690e-01, -5.315992632281e-01, -3.824589843065e-01, -2.317798481043e-01, -8.110071190218e-02,  6.957842429998e-02,  2.253318539643e-01,  3.810852836287e-01,  5.368387132930e-01,  6.967751907398e-01,  8.608947159690e-01,  1.025014241198e+00,  1.189133766427e+00],
        [-9.840022050943e-01, -8.381798879973e-01, -6.923575709003e-01, -5.465352538032e-01, -3.997511509058e-01, -2.520052622081e-01, -1.042593735103e-01,  4.348651518749e-02,  1.944038372991e-01,  3.453211594108e-01,  4.962384815224e-01,  6.497702084981e-01,  8.059163403378e-01,  9.620624721775e-01,  1.118208604017e+00],
        [-9.936008820377e-01, -8.495576694846e-01, -7.055144569315e-01, -5.614712443784e-01, -4.170433175052e-01, -2.722306763118e-01, -1.274180351184e-01,  1.739460607499e-02,  1.634758206339e-01,  3.095570351929e-01,  4.556382497518e-01,  6.027652262564e-01,  7.509379647065e-01,  8.991107031567e-01,  1.047283441607e+00]],
       [[-9.730500802037e-01, -8.251977984278e-01, -6.773455166519e-01, -5.294932348761e-01, -3.800207266669e-01, -2.289279920243e-01, -7.783525738178e-02,  7.325747726077e-02,  2.296928154713e-01,  3.861281536818e-01,  5.425634918924e-01,  7.034030621747e-01,  8.686468645287e-01,  1.033890666883e+00,  1.199134469237e+00],
        [-9.831563001273e-01, -8.371771954460e-01, -6.911980907646e-01, -5.452189860833e-01, -3.982272398811e-01, -2.502228521581e-01, -1.022184644350e-01,  4.578592328798e-02,  1.971294382410e-01,  3.484729531940e-01,  4.998164681470e-01,  6.539126281449e-01,  8.107614331876e-01,  9.676102382302e-01,  1.124459043273e+00],
        [-9.932625200509e-01, -8.491565924641e-01, -7.050506648773e-01, -5.609447372904e-01, -4.164337530953e-01, -2.715177122918e-01, -1.266016714883e-01,  1.831436931519e-02,  1.645660610107e-01,  3.108177527062e-01,  4.570694444017e-01,  6.044221941151e-01,  7.528760018465e-01,  9.013298095778e-01,  1.049783617309e+00]],
       [[-9.716966322564e-01, -8.235934903457e-01, -6.754903484349e-01, -5.273872065241e-01, -3.775824690273e-01, -2.260761359443e-01, -7.456980286138e-02,  7.693653022156e-02,  2.340537769783e-01,  3.911710237350e-01,  5.482882704918e-01,  7.100309336095e-01,  8.763990130883e-01,  1.042767092567e+00,  1.209135172046e+00],
        [-9.823103951603e-01, -8.361745028946e-01, -6.900386106289e-01, -5.439027183633e-01, -3.967033288563e-01, -2.484404421081e-01, -1.001775553598e-01,  4.808533138847e-02,  1.998550391829e-01,  3.516247469773e-01,  5.033944547716e-01,  6.580550477917e-01,  8.156065260374e-01,  9.731580042830e-01,  1.130709482529e+00],
        [-9.929241580641e-01, -8.487555154436e-01, -7.045868728230e-01, -5.604182302025e-01, -4.158241886854e-01, -2.708047482718e-01, -1.257853078582e-01,  1.923413255539e-02,  1.656563013874e-01,  3.120784702195e-01,  4.585006390515e-01,  6.060791619738e-01,  7.548140389864e-01,  9.035489159989e-01,  1.052283793011e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.235087233492e+00,  1.304017434088e+00,  1.372947634684e+00],
        [ 1.161929520932e+00,  1.227510896305e+00,  1.293092271678e+00],
        [ 1.088771808373e+00,  1.151004358522e+00,  1.213236908671e+00]],
       [[ 1.245402733896e+00,  1.314805130884e+00,  1.384207527873e+00],
        [ 1.168376708685e+00,  1.234253206803e+00,  1.300129704921e+00],
        [ 1.091350683474e+00,  1.153701282721e+00,  1.216051881968e+00]],
       [[ 1.255718234300e+00,  1.325592827681e+00,  1.395467421062e+00],
        [ 1.174823896438e+00,  1.240995517301e+00,  1.307167138164e+00],
        [ 1.093929558575e+00,  1.156398206920e+00,  1.218866855266e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.188170666127e+00, -1.130938162084e+00, -1.073705658041e+00],
        [-1.216341332253e+00, -1.161876324168e+00, -1.107411316082e+00],
        [-1.203926969695e+00, -1.148242370349e+00, -1.092557771004e+00],
        [-1.177984264241e+00, -1.119751044563e+00, -1.061517824885e+00],
        [-1.124984872997e+00, -1.061544974842e+00, -9.981050766873e-01],
        [-1.044928795962e+00, -9.736241611858e-01, -9.023195264095e-01],
        [-9.513443760326e-01, -8.708459755622e-01, -7.903475750918e-01],
        [-8.171749274177e-01, -7.234956740361e-01, -6.298164206545e-01],
        [-6.830054788028e-01, -5.761453725100e-01, -4.692852662173e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.189660228066e+00, -1.132574059102e+00, -1.075487890138e+00],
        [-1.219320456132e+00, -1.165148118203e+00, -1.110975780275e+00],
        [-1.208667768360e+00, -1.153448906711e+00, -1.098230045062e+00],
        [-1.184577441976e+00, -1.126991938354e+00, -1.069406434731e+00],
        [-1.133611838368e+00, -1.071019456267e+00, -1.008427074166e+00],
        [-1.055770957534e+00, -9.855314604506e-01, -9.152919633669e-01],
        [-9.644924380885e-01, -8.852857077696e-01, -8.060789774507e-01],
        [-8.329010028055e-01, -7.407666844944e-01, -6.486323661834e-01],
        [-7.013095675225e-01, -5.962476612192e-01, -4.911857549160e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.191149790005e+00, -1.134209956119e+00, -1.077270122234e+00],
        [-1.222299580010e+00, -1.168419912239e+00, -1.114540244468e+00],
        [-1.213408567026e+00, -1.158655443073e+00, -1.103902319119e+00],
        [-1.191170619712e+00, -1.134232832144e+00, -1.077295044576e+00],
        [-1.142238803739e+00, -1.080493937692e+00, -1.018749071645e+00],
        [-1.066613119106e+00, -9.974387597154e-01, -9.282644003243e-01],
        [-9.776405001443e-01, -8.997254399770e-01, -8.218103798097e-01],
        [-8.486270781933e-01, -7.580376949527e-01, -6.674483117122e-01],
        [-7.196136562423e-01, -6.163499499285e-01, -5.130862436147e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.035550655346e+00, -8.992827885774e-01, -7.630149218089e-01, -6.267470550404e-01, -4.926164900505e-01, -3.606232268392e-01, -2.286299636279e-01, -9.663670041663e-02,  2.830893298607e-02,  1.532545663888e-01,  2.782001997915e-01,  3.973360446074e-01,  5.106621008367e-01,  6.239881570660e-01,  7.373142132952e-01],
        [-1.071101310692e+00, -9.414227200120e-01, -8.117441293321e-01, -6.820655386522e-01, -5.566615515296e-01, -4.355321679641e-01, -3.144027843987e-01, -1.932734008333e-01, -8.623927688501e-02,  2.079484706325e-02,  1.278289710115e-01,  2.232435177863e-01,  3.070384873877e-01,  3.908334569891e-01,  4.746284265904e-01],
        [-1.055434704773e+00, -9.228523253796e-01, -7.902699459857e-01, -6.576875665919e-01, -5.284379160031e-01, -4.025209942193e-01, -2.766040724354e-01, -1.506871506516e-01, -3.575971060847e-02,  7.916772943469e-02,  1.940951694779e-01,  2.999633133711e-01,  3.967721611146e-01,  4.935810088580e-01,  5.903898566014e-01],
        [-1.022695678434e+00, -8.840451553916e-01, -7.453946323495e-01, -6.067441093075e-01, -4.694580481413e-01, -3.335364488511e-01, -1.976148495608e-01, -6.169325027060e-02,  6.972911438393e-02,  2.011514790385e-01,  3.325738436930e-01,  4.602872164246e-01,  5.842915972334e-01,  7.082959780421e-01,  8.323003588509e-01],
        [-9.558118112509e-01, -8.047644346922e-01, -6.537170581336e-01, -5.026696815749e-01, -3.489657156092e-01, -1.926051602364e-01, -3.624460486353e-02,  1.201159505093e-01,  2.852364568081e-01,  4.503569631069e-01,  6.154774694056e-01,  7.878193344154e-01,  9.673825581361e-01,  1.146945781857e+00,  1.326509005577e+00],
        [-8.547831032253e-01, -6.850101632816e-01, -5.152372233379e-01, -3.454642833942e-01, -1.669609184066e-01,  2.027287162492e-02,  2.075066616565e-01,  3.947404516880e-01,  6.107623166640e-01,  8.267841816399e-01,  1.042806046616e+00,  1.282559667343e+00,  1.546045043823e+00,  1.809530420302e+00,  2.073015796781e+00],
        [-7.366819747782e-01, -5.450191165153e-01, -3.533562582524e-01, -1.616933999895e-01,  4.580011113112e-02,  2.691242751095e-01,  4.924484390878e-01,  7.157726030662e-01,  9.912974352357e-01,  1.266822267405e+00,  1.542347099575e+00,  1.860904107740e+00,  2.222493291901e+00,  2.584082476062e+00,  2.945671660224e+00],
        [-5.673635850668e-01, -3.443177436821e-01, -1.212719022973e-01,  1.017739390874e-01,  3.508298376745e-01,  6.258957934638e-01,  9.009617492532e-01,  1.176027705043e+00,  1.536860329955e+00,  1.897692954868e+00,  2.258525579780e+00,  2.690060870543e+00,  3.192298827156e+00,  3.694536783769e+00,  4.196774740382e+00],
        [-3.980451953554e-01, -1.436163708488e-01,  1.108124536578e-01,  3.652412781644e-01,  6.558595642178e-01,  9.826673118182e-01,  1.309475059419e+00,  1.636282807019e+00,  2.082423224674e+00,  2.528563642330e+00,  2.974704059985e+00,  3.519217633345e+00,  4.162104362410e+00,  4.804991091475e+00,  5.447877820540e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.037430444162e+00, -9.015109942471e-01, -7.655915443326e-01, -6.296720944181e-01, -4.960029589944e-01, -3.645841380615e-01, -2.331653171285e-01, -1.017464961955e-01,  2.225204200414e-02,  1.462505802038e-01,  2.702491184034e-01,  3.881306676146e-01,  4.998952278372e-01,  6.116597880598e-01,  7.234243482824e-01],
        [-1.074860888323e+00, -9.458791313513e-01, -8.168973743795e-01, -6.879156174077e-01, -5.634344894174e-01, -4.434539904086e-01, -3.234734913998e-01, -2.034929923910e-01, -9.835305884887e-02,  6.786874693285e-03,  1.119268082354e-01,  2.048327638005e-01,  2.855047413886e-01,  3.661767189767e-01,  4.468486965647e-01],
        [-1.061417470629e+00, -9.299439905114e-01, -7.984705103941e-01, -6.669970302768e-01, -5.392159622384e-01, -4.151273062790e-01, -2.910386503195e-01, -1.669499943600e-01, -5.503685506987e-02,  5.687628422024e-02,  1.687894235104e-01,  2.706655461432e-01,  3.625046521188e-01,  4.543437580943e-01,  5.461828640699e-01],
        [-1.031016098982e+00, -8.939077570235e-01, -7.567994150647e-01, -6.196910731058e-01, -4.844474158588e-01, -3.510684433237e-01, -2.176894707886e-01, -8.431049825345e-02,  4.291978358645e-02,  1.701500654264e-01,  2.973803472663e-01,  4.195418905381e-01,  5.366346952418e-01,  6.537274999456e-01,  7.708203046493e-01],
        [-9.666988194320e-01, -8.176693382395e-01, -6.686398570470e-01, -5.196103758545e-01, -3.685788310779e-01, -2.155452227172e-01, -6.251161435655e-02,  9.052199400411e-02,  2.501572919974e-01,  4.097925899908e-01,  5.694278879841e-01,  7.345053590374e-01,  9.050250031507e-01,  1.075544647264e+00,  1.246064291377e+00],
        [-8.684656319778e-01, -7.012287341594e-01, -5.339918363411e-01, -3.667549385228e-01, -1.916102078956e-01, -8.557644459496e-03,  1.744949189766e-01,  3.575474824127e-01,  5.666756701631e-01,  7.758038579135e-01,  9.849320456639e-01,  1.215555951641e+00,  1.467675575845e+00,  1.719795200050e+00,  1.971914824254e+00],
        [-7.532744905715e-01, -5.646870374313e-01, -3.760995842912e-01, -1.875121311510e-01,  1.590843448733e-02,  2.341621126238e-01,  4.524157907603e-01,  6.706694688968e-01,  9.378344832061e-01,  1.204999497515e+00,  1.472164511825e+00,  1.779650106297e+00,  2.127456280933e+00,  2.475262455569e+00,  2.823068630204e+00],
        [-5.872094873093e-01, -3.678420627591e-01, -1.484746382089e-01,  7.089278634127e-02,  3.150771344722e-01,  5.840784061840e-01,  8.530796778957e-01,  1.122080949607e+00,  1.472914600881e+00,  1.823748252155e+00,  2.174581903428e+00,  2.592874947110e+00,  3.078627383199e+00,  3.564379819289e+00,  4.050132255378e+00],
        [-4.211444840471e-01, -1.709970880869e-01,  7.915030787332e-02,  3.292977038335e-01,  6.142458344571e-01,  9.339946997441e-01,  1.253743565031e+00,  1.573492430318e+00,  2.007994718556e+00,  2.442497006794e+00,  2.876999295032e+00,  3.406099787922e+00,  4.029798485465e+00,  4.653497183008e+00,  5.277195880551e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.039310232977e+00, -9.037391999168e-01, -7.681681668563e-01, -6.325971337959e-01, -4.993894279383e-01, -3.685450492837e-01, -2.377006706290e-01, -1.068562919744e-01,  1.619515102221e-02,  1.392465940188e-01,  2.622980370154e-01,  3.789252906217e-01,  4.891283548376e-01,  5.993314190536e-01,  7.095344832695e-01],
        [-1.078620465954e+00, -9.503355426907e-01, -8.220506194269e-01, -6.937656961632e-01, -5.702074273053e-01, -4.513758128531e-01, -3.325441984009e-01, -2.137125839488e-01, -1.104668408127e-01, -7.221097676681e-03,  9.602464545936e-02,  1.864220098148e-01,  2.639709953895e-01,  3.415199809643e-01,  4.190689665390e-01],
        [-1.067400236484e+00, -9.370356556433e-01, -8.066710748025e-01, -6.763064939618e-01, -5.499940084738e-01, -4.277336183387e-01, -3.054732282035e-01, -1.832128380683e-01, -7.431399953127e-02,  3.458483900579e-02,  1.434836775429e-01,  2.413677789153e-01,  3.282371431230e-01,  4.151065073307e-01,  5.019758715384e-01],
        [-1.039336519531e+00, -9.037703586555e-01, -7.682041977798e-01, -6.326380369041e-01, -4.994367835763e-01, -3.686004377963e-01, -2.377640920163e-01, -1.069277462363e-01,  1.611045278897e-02,  1.391486518143e-01,  2.621868508395e-01,  3.787965646515e-01,  4.889777932503e-01,  5.991590218490e-01,  7.093402504478e-01],
        [-9.775858276132e-01, -8.305742417868e-01, -6.835626559604e-01, -5.365510701340e-01, -3.881919465465e-01, -2.384852851980e-01, -8.877862384956e-02,  6.092803749893e-02,  2.150781271868e-01,  3.692282168747e-01,  5.233783065626e-01,  6.811913836594e-01,  8.426674481653e-01,  1.004143512671e+00,  1.165619577177e+00],
        [-8.821481607303e-01, -7.174473050373e-01, -5.527464493443e-01, -3.880455936514e-01, -2.162594973845e-01, -3.738816054391e-02,  1.414831762967e-01,  3.203545131374e-01,  5.225890236622e-01,  7.248235341871e-01,  9.270580447119e-01,  1.148552235939e+00,  1.389306107868e+00,  1.630059979797e+00,  1.870813851726e+00],
        [-7.698670063648e-01, -5.843549583474e-01, -3.988429103299e-01, -2.133308623125e-01, -1.398324215645e-02,  1.991999501382e-01,  4.123831424328e-01,  6.255663347274e-01,  8.843715311764e-01,  1.143176727625e+00,  1.401981924075e+00,  1.698396104854e+00,  2.032419269965e+00,  2.366442435075e+00,  2.700465600185e+00],
        [-6.070553895518e-01, -3.913663818362e-01, -1.756773741205e-01,  4.001163359512e-02,  2.793244312700e-01,  5.422610189041e-01,  8.051976065382e-01,  1.068134194172e+00,  1.408968871807e+00,  1.749803549442e+00,  2.090638227077e+00,  2.495689023677e+00,  2.964955939243e+00,  3.434222854808e+00,  3.903489770374e+00],
        [-4.442437727388e-01, -1.983778053249e-01,  4.748816208889e-02,  2.933541295027e-01,  5.726321046964e-01,  8.853220876700e-01,  1.198012070644e+00,  1.510702053617e+00,  1.933566212438e+00,  2.356430371258e+00,  2.779294530079e+00,  3.292981942500e+00,  3.897492608521e+00,  4.502003274542e+00,  5.106513940563e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.690455090394e-01,  8.166424526557e-01,  8.642393962720e-01],
        [ 4.980910180788e-01,  5.332849053114e-01,  5.684787925440e-01],
        [ 6.174963339695e-01,  6.581560500218e-01,  6.988157660740e-01],
        [ 8.670215854773e-01,  9.191034254170e-01,  9.711852653567e-01],
        [ 1.376786708219e+00,  1.452203262182e+00,  1.527619816145e+00],
        [ 2.146791702195e+00,  2.257455560317e+00,  2.368119418438e+00],
        [ 3.046916631789e+00,  3.198784089136e+00,  3.350651546484e+00],
        [ 4.337401368233e+00,  4.548341310011e+00,  4.759281251788e+00],
        [ 5.627886104678e+00,  5.897898530885e+00,  6.167910957092e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.547184251447e-01,  8.016595404382e-01,  8.486006557317e-01],
        [ 4.694368502894e-01,  5.033190808764e-01,  5.372013114634e-01],
        [ 5.718978137431e-01,  6.104702382528e-01,  6.490426627625e-01],
        [ 8.036062899664e-01,  8.527852679419e-01,  9.019642459175e-01],
        [ 1.293809791729e+00,  1.365428042257e+00,  1.437046292784e+00],
        [ 2.042508319031e+00,  2.148398561197e+00,  2.254288803362e+00],
        [ 2.920454359102e+00,  3.066532952449e+00,  3.212611545796e+00],
        [ 4.186142937483e+00,  4.390158960640e+00,  4.594174983798e+00],
        [ 5.451831515863e+00,  5.713784968831e+00,  5.975738421800e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.403913412500e-01,  7.866766282207e-01,  8.329619151914e-01],
        [ 4.407826825000e-01,  4.733532564414e-01,  5.059238303828e-01],
        [ 5.262992935166e-01,  5.627844264838e-01,  5.992695594511e-01],
        [ 7.401909944554e-01,  7.864671104669e-01,  8.327432264784e-01],
        [ 1.210832875239e+00,  1.278652822331e+00,  1.346472769424e+00],
        [ 1.938224935866e+00,  2.039341562077e+00,  2.140458188287e+00],
        [ 2.793992086416e+00,  2.934281815763e+00,  3.074571545109e+00],
        [ 4.034884506733e+00,  4.231976611270e+00,  4.429068715808e+00],
        [ 5.275776927049e+00,  5.529671406778e+00,  5.783565886507e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-6.588549780521e-01, -5.496223182353e-01, -4.403896584186e-01],
        [-6.226292269261e-01, -5.098377368233e-01, -3.970462467205e-01],
        [-5.864034758001e-01, -4.700531554113e-01, -3.537028350224e-01]],
       [[-6.776231091716e-01, -5.702342370297e-01, -4.628453648878e-01],
        [-6.420934216452e-01, -5.312141007454e-01, -4.203347798456e-01],
        [-6.065637341188e-01, -4.921939644611e-01, -3.778241948034e-01]],
       [[-6.963912402911e-01, -5.908461558241e-01, -4.853010713571e-01],
        [-6.615576163643e-01, -5.525904646675e-01, -4.436233129708e-01],
        [-6.267239924375e-01, -5.143347735110e-01, -4.019455545844e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.675678852074e-01, -1.074901237389e-01,  1.525876377297e-01,  4.126653991982e-01,  7.107649149956e-01,  1.046886185122e+00,  1.383007455248e+00,  1.719128725375e+00,  2.180624545724e+00,  2.642120366073e+00,  3.103616186422e+00,  3.668465850650e+00,  4.336669358756e+00,  5.004872866862e+00,  5.673076374968e+00],
        [-3.218519199853e-01, -5.330075307388e-02,  2.152504138375e-01,  4.838015807490e-01,  7.931229411624e-01,  1.143214495078e+00,  1.493306048993e+00,  1.843397602908e+00,  2.327926527298e+00,  2.812455451688e+00,  3.296984376078e+00,  3.892338176607e+00,  4.598516853275e+00,  5.304695529943e+00,  6.010874206611e+00],
        [-2.761359547632e-01,  8.886175910957e-04,  2.779131899454e-01,  5.549377622997e-01,  8.754809673291e-01,  1.239542805033e+00,  1.603604642738e+00,  1.967666480442e+00,  2.475228508872e+00,  2.982790537303e+00,  3.490352565733e+00,  4.116210502563e+00,  4.860364347793e+00,  5.604518193023e+00,  6.348672038253e+00]],
       [[-3.912527834599e-01, -1.355649926459e-01,  1.201227981681e-01,  3.758105889821e-01,  6.680962004544e-01,  9.969796325849e-01,  1.325863064715e+00,  1.654746496846e+00,  2.104309139738e+00,  2.553871782629e+00,  3.003434425521e+00,  3.552480259269e+00,  4.201009283873e+00,  4.849538308478e+00,  5.498067333083e+00],
        [-3.464152325791e-01, -8.241684948439e-02,  1.815815336103e-01,  4.455799167051e-01,  7.488717494503e-01,  1.091457031846e+00,  1.434042314242e+00,  1.776627596638e+00,  2.248780771510e+00,  2.720933946382e+00,  3.193087121254e+00,  3.772050966288e+00,  4.457825481485e+00,  5.143599996682e+00,  5.829374511879e+00],
        [-3.015776816983e-01, -2.926870632289e-02,  2.430402690525e-01,  5.153492444280e-01,  8.296472984463e-01,  1.185934431107e+00,  1.542221563769e+00,  1.898508696430e+00,  2.393252403282e+00,  2.887996110134e+00,  3.382739816987e+00,  3.991621673308e+00,  4.714641679097e+00,  5.437661684887e+00,  6.160681690676e+00]],
       [[-4.149376817124e-01, -1.636398615529e-01,  8.765795860658e-02,  3.389557787661e-01,  6.254274859132e-01,  9.470730800479e-01,  1.268718674183e+00,  1.590364268317e+00,  2.027993733751e+00,  2.465623199185e+00,  2.903252664619e+00,  3.436494667888e+00,  4.065349208991e+00,  4.694203750094e+00,  5.323058291197e+00],
        [-3.709785451729e-01, -1.115329458949e-01,  1.479126533831e-01,  4.073582526611e-01,  7.046205577383e-01,  1.039699568615e+00,  1.374778579491e+00,  1.709857590367e+00,  2.169635015721e+00,  2.629412441076e+00,  3.089189866430e+00,  3.651763755970e+00,  4.317134109696e+00,  4.982504463422e+00,  5.647874817148e+00],
        [-3.270194086334e-01, -5.942603023687e-02,  2.081673481597e-01,  4.757607265562e-01,  7.838136295635e-01,  1.132326057181e+00,  1.480838484799e+00,  1.829350912417e+00,  2.311276297692e+00,  2.793201682966e+00,  3.275127068240e+00,  3.867032844052e+00,  4.568919010401e+00,  5.270805176750e+00,  5.972691343099e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 5.860173357238e+00,  6.140818830642e+00,  6.421464304047e+00],
        [ 6.208604236078e+00,  6.505199280278e+00,  6.801794324479e+00],
        [ 6.557035114918e+00,  6.869579729914e+00,  7.182124344911e+00]],
       [[ 5.679655459972e+00,  5.952037650306e+00,  6.224419840640e+00],
        [ 6.021391376135e+00,  6.309416672517e+00,  6.597441968900e+00],
        [ 6.363127292297e+00,  6.666795694729e+00,  6.970464097161e+00]],
       [[ 5.499137562706e+00,  5.763256469969e+00,  6.027375377233e+00],
        [ 5.834178516192e+00,  6.113634064757e+00,  6.393089613322e+00],
        [ 6.169219469677e+00,  6.464011659544e+00,  6.758803849410e+00]]
                ], dtype=np.float64)
            ]
        ]
                               ]

# Cubicly interpolated data sampled on self.xsamples, self.ysamples
# and self.zsamples.
# Calculated from solving manually the linear system given by the
# following constraints on the cubic splines:
#
# if Pijk is the cubic polynomial defining the spline on area
# [x[i], x[i+1]]*[y[j], y[j+1]]*[z[k], z[k+1]], constraints are:
# For each vertex (u, v, w) with u in [i, i+1], v in [j, j+1] and z
# in [k, k+1]:
#   Pijk(x[u], y[v], z[k]) = data[i, j, k]
#   dPijk/dx(x[u], y[v], z[w]) = (data[u+1, v, w]-data[u-1, v, w])/(x[u+1]-x[u-1])
#   dPijk/dy(x[u], y[v], z[w]) = (data[u, v+1, w]-data[u, v-1, w])/(y[v+1]-y[v-1])
#   dPijk/dz(x[u], y[v], z[w]) = (data[u, v, w+1]-data[u, v, w-1])/(z[w+1]-z[w-1])
#   d2Pijk/dxdy(x[u], y[v], z[w]) = (data[u+1, v+1, w]-data[u+1, v-1, w]-data[u-1, v+1, w]+data[u-1, v-1, w])/(x[u+1]-x[u-1])/(y[v+1]-y[v-1])
#   d2Pijk/dydz(x[u], y[v], z[w]) = (data[u, v+1, w+1]-data[u, v+1, w-1]-data[u, v-1, w+1]+data[u, v-1, w-1])/(y[v+1]-y[v-1])/(z[w+1]-z[w-1])
#   d2Pijk/dzdx(x[u], y[v], z[w]) = (data[u+1, v, w+1]-data[u-1, v, w+1]-data[u+1, v, w-1]+data[u-1, v, w-1])/(z[w+1]-z[w-1])/(x[u+1]-x[u-1])
#   d3Pijk/dxdydz(x[u], y[v], z[w]) = (data[u+1, v+1, w]-data[u+1, v-1, w]-data[u-1, v+1, w]+data[u-1, v-1, w]-data[u+1, v+1, w+1]+data[u+1, v-1, w+1]+data[u-1, v+1, w+1]-data[u-1, v-1, w+1])/(x[u+1]-x[u-1])/(y[v+1]-y[v-1])/(z[w+1]-z[w-1])
# for the edges of the interpolation area, where x, y, z or data are
# requested with indices out of their range, they return the nearest
# valid value, eg: x[-1] = x[0], y[10] = y[9], data[-1, 5, 2] = data[0, 5, 2], etc
cubic_interpolated_data = np.array([
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.030782779028e+00, -8.932535062520e-01, -7.555731593911e-01, -6.186481829547e-01, -4.831604436380e-01, -3.485495135622e-01, -2.151921120254e-01, -8.367626886145e-02,  4.625496567741e-02,  1.746042296982e-01,  3.004020259060e-01,  4.225324434334e-01,  5.404350544017e-01,  6.562843556713e-01,  7.725443188807e-01],
        [-1.073676815379e+00, -9.435716238632e-01, -8.131048451937e-01, -6.844460022944e-01, -5.592271039766e-01, -4.361067982684e-01, -3.159867411943e-01, -2.002743484225e-01, -8.835462547467e-02,  1.977874180704e-02,  1.218053172739e-01,  2.150542322926e-01,  2.981841348911e-01,  3.763995585388e-01,  4.555978779767e-01],
        [-1.163501973854e+00, -1.048943681920e+00, -9.335829636980e-01, -8.222343769115e-01, -7.185196397445e-01, -6.194620533001e-01, -5.270625528656e-01, -4.444444444444e-01, -3.702429457696e-01, -3.044440446004e-01, -2.521972019793e-01, -2.194295510376e-01, -2.091177906722e-01, -2.097121342799e-01, -2.081252570929e-01],
        [-1.290670175740e+00, -1.198122101190e+00, -1.104147491019e+00, -1.017305558954e+00, -9.440349151014e-01, -8.790436503113e-01, -8.258889828722e-01, -7.901234567901e-01, -7.693207924793e-01, -7.634560792897e-01, -7.816839146299e-01, -8.345414240669e-01, -9.273205167506e-01, -1.039488238720e+00, -1.147778234832e+00],
        [-1.454172149594e+00, -1.389922925967e+00, -1.323444740431e+00, -1.268111364437e+00, -1.233983126275e+00, -1.212791417897e+00, -1.210094392881e+00, -1.234567901235e+00, -1.282420881106e+00, -1.353614409604e+00, -1.462452545181e+00, -1.625399546533e+00, -1.850724021709e+00, -2.106343230143e+00, -2.355903491925e+00],
        [-1.654007895416e+00, -1.624346156249e+00, -1.591474711935e+00, -1.574651793360e+00, -1.588364273264e+00, -1.620705356057e+00, -1.679678782891e+00, -1.777777777778e+00, -1.909543211650e+00, -2.074919035545e+00, -2.294503093632e+00, -2.592003918436e+00, -2.979328305546e+00, -3.410277108548e+00, -3.832501028372e+00],
        [-1.891186684649e+00, -1.902575747746e+00, -1.909591092255e+00, -1.938475029709e+00, -2.008968159842e+00, -2.104845636197e+00, -2.237013791237e+00, -2.422496570645e+00, -2.653855068608e+00, -2.931012909767e+00, -3.282037835480e+00, -3.739236380038e+00, -4.318833389899e+00, -4.957875398575e+00, -5.585028407488e+00],
        [-2.175296596006e+00, -2.235859279689e+00, -2.290653905277e+00, -2.374288821335e+00, -2.512797921850e+00, -2.684783886663e+00, -2.904629982085e+00, -3.194787379973e+00, -3.545445654710e+00, -3.956504082505e+00, -4.464978387949e+00, -5.113474413830e+00, -5.923389480304e+00, -6.811700584288e+00, -7.684332480770e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.878888099752e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.016896542521e+00, -8.769638459364e-01, -7.369482253991e-01, -5.973472246232e-01, -4.585351174714e-01, -3.202042873547e-01, -1.825615139674e-01, -4.592956449968e-02,  8.983259972255e-02,  2.247264267456e-01,  3.582197634374e-01,  4.897000908503e-01,  6.188597923953e-01,  7.468924405770e-01,  8.751504994315e-01],
        [-1.042014049331e+00, -9.064286799618e-01, -7.706371162769e-01, -6.358765241702e-01, -5.030775532411e-01, -3.714753003429e-01, -2.415839329313e-01, -1.142060268368e-01,  1.100911725087e-02,  1.340650999670e-01,  2.536386974682e-01,  3.682068525220e-01,  4.770046619817e-01,  5.830000001347e-01,  6.895558325490e-01],
        [-1.098987792758e+00, -9.732634142611e-01, -8.470532287420e-01, -7.232720783326e-01, -6.041126331312e-01, -4.877727323042e-01, -3.754637873279e-01, -2.690767182940e-01, -1.677852551520e-01, -7.158091457437e-02,  1.641870326269e-02,  9.262517791250e-02,  1.552363485413e-01,  2.112447171707e-01,  2.685736462000e-01],
        [-1.181309509408e+00, -1.069833338025e+00, -9.574673454808e-01, -8.495504587481e-01, -7.500988492031e-01, -6.558116159212e-01, -5.689076226065e-01, -4.928503447500e-01, -4.261263571775e-01, -3.687201215293e-01, -3.263419435179e-01, -3.055644997595e-01, -3.096886911785e-01, -3.259068060793e-01, -3.397061362837e-01],
        [-1.288294118922e+00, -1.195334797486e+00, -1.100960601513e+00, -1.013660778221e+00, -9.398213058844e-01, -8.741935335819e-01, -8.203056014460e-01, -7.836646647183e-01, -7.618642772143e-01, -7.548797319135e-01, -7.717907928040e-01, -8.230484506814e-01, -9.139013564676e-01, -1.023984400959e+00, -1.130221417709e+00],
        [-1.419941621302e+00, -1.349767792642e+00, -1.277532996839e+00, -1.215603036751e+00, -1.173280003175e+00, -1.142918485286e+00, -1.129657723846e+00, -1.141519678199e+00, -1.174999015262e+00, -1.230059745727e+00, -1.319927844596e+00, -1.459826674853e+00, -1.657401647326e+00, -1.882988067468e+00, -2.102972198077e+00],
        [-1.576937096904e+00, -1.533935977263e+00, -1.488103396438e+00, -1.456428121534e+00, -1.451689836647e+00, -1.463384888646e+00, -1.498573827129e+00, -1.568277626678e+00, -1.667680482933e+00, -1.796732951954e+00, -1.973605548962e+00, -2.219212902088e+00, -2.544058664464e+00, -2.907387974263e+00, -3.263020574579e+00],
        [-1.765788809124e+00, -1.755474062158e+00, -1.741401017625e+00, -1.746119460932e+00, -1.786592314240e+00, -1.848877710979e+00, -1.942347365844e+00, -2.081629804278e+00, -2.260332840535e+00, -2.478390845944e+00, -2.759922181565e+00, -3.132687565603e+00, -3.610628864628e+00, -4.139650723580e+00, -4.658456470547e+00],
        [-1.962861485631e+00, -1.986655992285e+00, -2.005725018576e+00, -2.048421446683e+00, -2.136073538703e+00, -2.251151544660e+00, -2.405438952412e+00, -2.617328879715e+00, -2.878784137474e+00, -3.189722207744e+00, -3.580468215003e+00, -4.085926986869e+00, -4.723628273316e+00, -5.425555496774e+00, -6.114637532830e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.665692623358e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.003782778989e+00, -8.615803578834e-01, -7.193593718563e-01, -5.772312104363e-01, -4.352796656361e-01, -2.934358685987e-01, -1.517461129302e-01, -1.028265938712e-02,  1.309860676107e-01,  2.720603922503e-01,  4.128211766853e-01,  5.531312908606e-01,  6.929218659194e-01,  8.324601175353e-01,  9.720488338398e-01],
        [-1.009503137067e+00, -8.682907930636e-01, -7.270318100697e-01, -5.860060220279e-01, -4.454239321113e-01, -3.051125272551e-01, -1.651881067421e-01, -2.583220480301e-02,  1.130345030660e-01,  2.514128312908e-01,  3.890034805238e-01,  5.254619512018e-01,  6.606152302600e-01,  7.951346197174e-01,  9.297807870949e-01],
        [-1.022731614115e+00, -8.838088491978e-01, -7.447745232745e-01, -6.062980023820e-01, -4.688828125527e-01, -3.321151045281e-01, -1.962730675420e-01, -6.179093358038e-02,  7.152104249019e-02,  2.036648087859e-01,  3.339244377950e-01,  4.614758825657e-01,  5.859052938395e-01,  7.088184338343e-01,  8.320348280849e-01],
        [-1.041934293354e+00, -9.063351198545e-01, -7.705301434616e-01, -6.357541815363e-01, -5.029361170101e-01, -3.713124987649e-01, -2.413965182034e-01, -1.139892276131e-01,  1.125940657787e-02,  1.343529781697e-01,  2.539707752171e-01,  3.685926317327e-01,  4.774550965986e-01,  5.835204101360e-01,  6.901451539392e-01],
        [-1.066949709860e+00, -9.356801938304e-01, -8.040821055776e-01, -6.741268784423e-01, -5.472975096994e-01, -4.223751203177e-01, -3.001790400812e-01, -1.819881797322e-01, -6.724369722944e-02,  4.406014506686e-02,  1.498147798129e-01,  2.475932036270e-01,  3.361765374781e-01,  4.202941118067e-01,  5.053048380397e-01],
        [-1.097777863632e+00, -9.718440711254e-01, -8.454304096222e-01, -7.214160930999e-01, -6.019669906205e-01, -4.853029691865e-01, -3.726206331756e-01, -2.657877899375e-01, -1.639882689318e-01, -6.721369052272e-02,  2.145645158247e-02,  9.847759824865e-02,  1.620696164782e-01,  2.191395388463e-01,  2.775138803866e-01],
        [-1.134580219596e+00, -1.015016162943e+00, -8.947916206493e-01, -7.778695065578e-01, -6.672308955576e-01, -5.604256350190e-01, -4.591007161314e-01, -3.658269653982e-01, -2.794810159706e-01, -2.000513342236e-01, -1.317764964971e-01, -7.953518932675e-02, -4.577756534228e-02, -2.099687192949e-02,  5.579207597604e-03],
        [-1.178890694530e+00, -1.066995875714e+00, -9.542231066677e-01, -8.458400887782e-01, -7.458094144609e-01, -6.508742194682e-01, -5.632237660752e-01, -4.862753242204e-01, -4.185356590405e-01, -3.599894394699e-01, -3.162707911439e-01, -2.938647058793e-01, -2.960280479236e-01, -3.101239707703e-01, -3.218333774566e-01],
        [-1.225138748552e+00, -1.121248522926e+00, -1.016253373329e+00, -9.167828435824e-01, -8.278239627748e-01, -7.452778796894e-01, -6.718998397578e-01, -6.119905690714e-01, -5.636707914087e-01, -5.269212122116e-01, -5.088325300661e-01, -5.175662815229e-01, -5.572213177982e-01, -6.118938278215e-01, -6.635628430952e-01]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.953473919302e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.929147792443e-01, -8.488313294430e-01, -7.047826521111e-01, -5.605601124322e-01, -4.160067662896e-01, -2.712516064308e-01, -1.262079240050e-01,  1.925962683085e-02,  1.650919043833e-01,  3.112883014435e-01,  4.580719655822e-01,  6.056997441370e-01,  7.543006298552e-01,  9.033741224321e-01,  1.052353093637e+00],
        [-9.791571340923e-01, -8.326925170180e-01, -6.863301914520e-01, -5.394564083449e-01, -3.916094791636e-01, -2.431688668253e-01, -9.387949657512e-02,  5.665678364999e-02,  2.082659944594e-01,  3.609463496040e-01,  5.153542908593e-01,  6.722453958990e-01,  8.319991276403e-01,  9.931431451215e-01,  1.154009105455e+00],
        [-9.395438444045e-01, -7.862229762832e-01, -6.331988116653e-01, -4.786911295303e-01, -3.213607707663e-01, -1.623083934720e-01, -7.941359061936e-04,  1.643368691738e-01,  3.325799826670e-01,  5.039300234360e-01,  6.802910456684e-01,  8.638546539937e-01,  1.055721506511e+00,  1.251620977737e+00,  1.446713925221e+00],
        [-8.793572461614e-01, -7.156193076459e-01, -5.524734532180e-01, -3.863671783520e-01, -2.146281357660e-01, -3.945273412590e-02,  1.406354512110e-01,  3.279410054948e-01,  5.214569005705e-01,  7.211727972645e-01,  9.308883142987e-01,  1.154976889170e+00,  1.395634930546e+00,  1.644340229003e+00,  1.891436076043e+00],
        [-7.991533747293e-01, -6.215337848332e-01, -4.448998993172e-01, -2.633374919010e-01, -7.239762623307e-02,  1.242631061862e-01,  3.291026640616e-01,  5.459577317807e-01,  7.731518041242e-01,  1.010667668387e+00,  1.264830947728e+00,  1.542922561508e+00,  1.848599101227e+00,  2.167672752469e+00,  2.484066981406e+00],
        [-6.989322301082e-01, -5.039664078452e-01, -3.104781499628e-01, -1.096020701773e-01,  1.053307578325e-01,  3.288391274644e-01,  5.646075026456e-01,  8.183870480315e-01,  1.087664693328e+00,  1.372414636804e+00,  1.682118945956e+00,  2.027691671006e+00,  2.414614018556e+00,  2.821618548136e+00,  3.224606641310e+00],
        [-5.781377769319e-01, -3.622649029547e-01, -1.484624219477e-01,  7.569202391015e-02,  3.195430685010e-01,  5.754103347354e-01,  8.484565676780e-01,  1.146740415080e+00,  1.466740512228e+00,  1.808420705217e+00,  2.185067458006e+00,  2.611973757587e+00,  3.096819981049e+00,  3.609805762454e+00,  4.117163632270e+00],
        [-4.314876792198e-01, -1.902326697545e-01,  4.823222519474e-02,  3.006476927249e-01,  5.796068004409e-01,  8.747592757542e-01,  1.193062565949e+00,  1.545376710832e+00,  1.926956229259e+00,  2.337752399301e+00,  2.795670399587e+00,  3.321319450500e+00,  3.925049824627e+00,  4.566701786697e+00,  5.200769431179e+00],
        [-2.781651571114e-01, -1.037315182893e-02,  2.538762708218e-01,  5.358386066304e-01,  8.515031572248e-01,  1.187728277095e+00,  1.553347772798e+00,  1.962150536573e+00,  2.408111274840e+00,  2.891168125817e+00,  3.434055129435e+00,  4.062939622466e+00,  4.790963250421e+00,  5.567135568341e+00,  6.333678148268e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.908544880696e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.935612227527e-01, -8.495896591143e-01, -7.056496953642e-01, -5.615517321723e-01, -4.171531447368e-01, -2.725711567256e-01, -1.277269704565e-01,  1.750241118880e-02,  1.630632425045e-01,  3.089549716825e-01,  4.553803866882e-01,  6.025729005442e-01,  7.506497369189e-01,  8.991560603050e-01,  1.047576486289e+00],
        [-9.758270087247e-01, -8.287860149921e-01, -6.818636561797e-01, -5.343481227659e-01, -3.857039608965e-01, -2.363712613835e-01, -8.605419543612e-02,  6.570900292316e-02,  2.187165571099e-01,  3.729663954808e-01,  5.292198414248e-01,  6.883531934607e-01,  8.508065424004e-01,  1.014872307080e+00,  1.178615588612e+00],
        [-9.143229771714e-01, -7.566368922570e-01, -5.993712884762e-01, -4.400032790275e-01, -2.766350395344e-01, -1.108263964220e-01,  5.847116473612e-02,  2.328942942715e-01,  4.117278296778e-01,  5.949644283703e-01,  7.853024705636e-01,  9.858478461051e-01,  1.198160381420e+00,  1.416187847857e+00,  1.633072328070e+00],
        [-8.179913488775e-01, -6.436322273999e-01, -4.701663582952e-01, -2.922342273259e-01, -1.058041764884e-01,  8.581016479596e-02,  2.848362163195e-01,  4.947508089687e-01,  7.140346816996e-01,  9.426722362356e-01,  1.186395797614e+00,  1.451803387135e+00,  1.742208634221e+00,  2.044754439775e+00,  2.344872133635e+00],
        [-6.877734102414e-01, -4.908762242619e-01, -2.955113673252e-01, -9.248486517377e-02,  1.251193865745e-01,  3.516170250741e-01,  5.908290757623e-01,  8.487198653024e-01,  1.122683178596e+00,  1.412692257591e+00,  1.728580614524e+00,  2.081666819567e+00,  2.477635235568e+00,  2.894430162532e+00,  3.307059787304e+00],
        [-5.236691612632e-01, -2.983688828429e-01, -7.540631556640e-02,  1.592448074290e-01,  4.161356496542e-01,  6.865941844125e-01,  9.764497430647e-01,  1.294801463273e+00,  1.637673320366e+00,  2.005024492436e+00,  2.411856921293e+00,  2.875438143402e+00,  3.404440185460e+00,  3.965215016130e+00,  4.519635289077e+00],
        [-3.247373155444e-01, -6.500599930188e-02,  1.914112986700e-01,  4.643986879948e-01,  7.689138544179e-01,  1.092663040007e+00,  1.443910101778e+00,  1.835554284592e+00,  2.261959041590e+00,  2.723066502257e+00,  3.240143925974e+00,  3.837670355622e+00,  4.527939549135e+00,  5.263250920868e+00,  5.989553856957e+00],
        [-8.203565230032e-02,  2.197023628518e-01,  5.169352414253e-01,  8.366938028927e-01,  1.199311796703e+00,  1.588076865222e+00,  2.014223045643e+00,  2.495285805525e+00,  3.023602720777e+00,  3.599095121170e+00,  4.250674105057e+00,  5.011616927571e+00,  5.898635946347e+00,  6.846886119607e+00,  7.782890061971e+00],
        [ 1.719614477245e-01,  5.176611710993e-01,  8.576092044436e-01,  1.226315687941e+00,  1.649740638994e+00,  2.106547456789e+00,  2.611078592128e+00,  3.185721507004e+00,  3.820693614921e+00,  4.515894477912e+00,  5.308234780760e+00,  6.240199463320e+00,  7.333125126408e+00,  8.504224361960e+00,  9.659688883021e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -4.021497292953e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.978530139089e-01, -8.546242716276e-01, -7.114060662104e-01, -5.681351764728e-01, -4.247640447101e-01, -2.813317587144e-01, -1.378120436942e-01,  5.836113277511e-03,  1.495947908970e-01,  2.934638051659e-01,  4.375107749697e-01,  5.818135310042e-01,  7.264111610612e-01,  8.711520019493e-01,  1.015864200671e+00],
        [-9.847379600102e-01, -8.392392698723e-01, -6.938154819620e-01, -5.480171829131e-01, -4.015063045881e-01, -2.545607060032e-01, -1.069936104874e-01,  4.148652596933e-02,  1.907523081984e-01,  3.408024282317e-01,  4.921175608799e-01,  6.452509725090e-01,  8.004805221351e-01,  9.567280985840e-01,  1.112772069668e+00],
        [-9.291216433578e-01, -7.739969051867e-01, -6.192200200428e-01, -4.627038697633e-01, -3.028784339556e-01, -1.410341161610e-01,  2.369649213918e-02,  1.926673488916e-01,  3.652868188886e-01,  5.415488278024e-01,  7.236856748992e-01,  9.142667814897e-01,  1.114582551115e+00,  1.319626133554e+00,  1.523724153429e+00],
        [-8.396871176323e-01, -6.690830904277e-01, -4.992658382566e-01, -3.255147109180e-01, -1.442786315191e-01,  4.152376129086e-02,  2.338543747343e-01,  4.357755950080e-01,  6.459492598021e-01,  8.643616301834e-01,  1.096061727414e+00,  1.346861076419e+00,  1.619678315848e+00,  1.903188936660e+00,  2.184560881196e+00],
        [-7.173483884844e-01, -5.255700269485e-01, -3.351788479510e-01, -1.378517562610e-01,  7.267223969962e-02,  2.912472158764e-01,  5.213322594609e-01,  7.683267393673e-01,  1.029871308500e+00,  1.305941743407e+00,  1.605440098464e+00,  1.938612817136e+00,  2.310605823476e+00,  2.701452595252e+00,  3.088528613941e+00],
        [-5.621054559143e-01, -3.434577147491e-01, -1.269590491261e-01,  1.002849942077e-01,  3.479741797006e-01,  6.081362475957e-01,  8.861301463189e-01,  1.190320781970e+00,  1.517052964984e+00,  1.866289167473e+00,  2.251820788051e+00,  2.689522003641e+00,  3.187365073999e+00,  3.714417109329e+00,  4.235627351665e+00],
        [-3.730443142720e-01, -1.216739524772e-01,  1.266194695651e-01,  3.902975903710e-01,  6.832480515056e-01,  9.940565669244e-01,  1.330395813145e+00,  1.704242247766e+00,  2.110362551690e+00,  2.548702994349e+00,  3.039009416133e+00,  3.604009676094e+00,  4.255118060275e+00,  4.948046391544e+00,  5.632610733395e+00],
        [-1.414819098745e-01,  1.499671727262e-01,  4.372028659280e-01,  7.455055061264e-01,  1.093892053821e+00,  1.466732423384e+00,  1.874533149392e+00,  2.333694123793e+00,  2.837049131786e+00,  3.384524597731e+00,  4.003159372324e+00,  4.724075716022e+00,  5.562903714458e+00,  6.458997612095e+00,  7.343638329887e+00],
        [ 1.010485623302e-01,  4.344747141700e-01,  7.624971984645e-01,  1.117538020484e+00,  1.523986412398e+00,  1.961796805556e+00,  2.444443819682e+00,  2.992960299234e+00,  3.598155581142e+00,  4.259935304726e+00,  5.012976768027e+00,  5.897194237881e+00,  6.932633282940e+00,  8.041515784469e+00,  9.135709594706e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.314921782086e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.001667403016e+00, -8.590988535518e-01, -7.165221208957e-01, -5.739863041986e-01, -4.315283379616e-01, -2.891178656292e-01, -1.467752928606e-01, -4.532471319130e-03,  1.376245171272e-01,  2.796958153760e-01,  4.216289089123e-01,  5.633633524740e-01,  7.048687895058e-01,  8.462630054297e-01,  9.876794655752e-01],
        [-9.985850131794e-01, -8.554829650153e-01, -7.123878612482e-01, -5.692580354960e-01, -4.260621445071e-01, -2.828259493755e-01, -1.395321335086e-01,  3.846332962000e-03,  1.472976388705e-01,  2.908216629513e-01,  4.344629699236e-01,  5.782728546742e-01,  7.222770782970e-01,  8.663756860610e-01,  1.010455416997e+00],
        [-9.770971760388e-01, -8.302760223155e-01, -6.835672698530e-01, -5.362965110869e-01, -3.879564275299e-01, -2.389639854684e-01, -8.903890040443e-02,  6.225633019416e-02,  2.147305320726e-01,  3.683817424418e-01,  5.239312810326e-01,  6.822094013488e-01,  8.436330696767e-01,  1.006584429527e+00,  1.169230251073e+00],
        [-9.409641442692e-01, -7.878891010343e-01, -6.351037908306e-01, -4.808698154703e-01, -3.238794767819e-01, -1.652075750414e-01, -4.131630121142e-03,  1.604760938605e-01,  3.281228133173e-01,  4.988034688326e-01,  6.743773825419e-01,  8.569846715838e-01,  1.047700136234e+00,  1.242353481056e+00,  1.436219249843e+00],
        [-8.905817339418e-01, -7.287865249169e-01, -5.675283130359e-01, -4.035851154359e-01, -2.345332175002e-01, -6.236467610863e-02,  1.142595682284e-01,  2.974296843276e-01,  4.862323369817e-01,  6.806581489641e-01,  8.841532260623e-01,  1.100684105283e+00,  1.332242843506e+00,  1.571100129618e+00,  1.808497706152e+00],
        [-8.259499450565e-01, -6.529682939635e-01, -4.808408364687e-01, -3.044424109834e-01, -1.199176496847e-01,  6.956471133004e-02,  2.661346946440e-01,  4.731171015954e-01,  6.890591030659e-01,  9.139457828363e-01,  1.153258811594e+00,  1.413307702446e+00,  1.697261191490e+00,  1.992824375213e+00,  2.286065620000e+00],
        [-7.466729615417e-01, -5.599700844282e-01, -3.745104722739e-01, -1.828345353230e-01,  2.066915190164e-02,  2.313885452885e-01,  4.524238582388e-01,  6.886142852977e-01,  9.378452571926e-01,  1.200095063609e+00,  1.483342187525e+00,  1.796770023169e+00,  2.144990614652e+00,  2.510108928869e+00,  2.871847698541e+00],
        [-6.489905307230e-01, -4.453808207291e-01, -2.434937763314e-01, -3.299340395593e-02,  1.938954770103e-01,  4.307824269002e-01,  6.819630955856e-01,  9.541426619501e-01,  1.244391182778e+00,  1.552678576297e+00,  1.890059813555e+00,  2.269259388367e+00,  2.696667740406e+00,  3.147489545364e+00,  3.593628659739e+00],
        [-5.465583070529e-01, -3.252196720861e-01, -1.061064141316e-01,  1.241337288824e-01,  3.755449049643e-01,  6.398718046810e-01,  9.226636422884e-01,  1.232582314204e+00,  1.565842855837e+00,  1.922406406898e+00,  2.316554020255e+00,  2.764723474721e+00,  3.275170079727e+00,  3.815862694203e+00,  4.350506106781e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  4.355375654709e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.962709223269e-01, -8.527683523189e-01, -7.092840836798e-01, -5.657083081959e-01, -4.219584233877e-01, -2.781023204321e-01, -1.340943629189e-01,  1.013668407568e-02,  1.545596932268e-01,  2.991743449496e-01,  4.440980857786e-01,  5.894660990349e-01,  7.353462758950e-01,  8.814751941487e-01,  1.027554364124e+00],
        [-9.958666376014e-01, -8.522940941679e-01, -7.087418362304e-01, -5.650881508128e-01, -4.212414801594e-01, -2.772770758100e-01, -1.331443537229e-01,  1.123564389867e-02,  1.558284150876e-01,  3.006336056116e-01,  4.457813948695e-01,  5.914216219650e-01,  7.376295384378e-01,  8.841131633869e-01,  1.030541646641e+00],
        [-1.008345925548e+00, -8.669332918747e-01, -7.254796985125e-01, -5.842309035969e-01, -4.433717770079e-01, -3.027503737460e-01, -1.624688311525e-01, -2.268657775757e-02,  1.166660514766e-01,  2.555897718019e-01,  3.938217300097e-01,  5.310593767749e-01,  6.671507670978e-01,  8.026854575252e-01,  9.383314879317e-01],
        [-1.031076658415e+00, -8.935982501565e-01, -7.559673255273e-01, -6.190989827506e-01, -4.836815982187e-01, -3.491493937173e-01, -2.158826850369e-01, -8.447511585960e-02,  4.533271662992e-02,  1.735434757244e-01,  2.991784084578e-01,  4.211109504999e-01,  5.387753236361e-01,  6.543667843797e-01,  7.703728276019e-01],
        [-1.063781770126e+00, -9.319639484574e-01, -7.998331020115e-01, -6.692673794530e-01, -5.416796052955e-01, -4.159085756692e-01, -2.927348511478e-01, -1.733768267198e-01, -5.730210374323e-02,  5.549478392688e-02,  1.630050425571e-01,  2.629165101964e-01,  3.540679829747e-01,  4.409650079312e-01,  5.287129224518e-01],
        [-1.106461260679e+00, -9.820303867771e-01, -8.570770279653e-01, -7.347360937042e-01, -6.173657982383e-01, -5.030279196013e-01, -3.930253294850e-01, -2.893917103380e-01, -1.912384096430e-01, -9.855630359067e-02, -1.469836769256e-02,  5.647605586441e-02,  1.130287451141e-01,  1.624801281794e-01,  2.133517724815e-01],
        [-1.159392196152e+00, -1.044122585671e+00, -9.280707186502e-01, -8.159301343238e-01, -7.112315155432e-01, -6.110729855692e-01, -5.174051842771e-01, -4.332729104018e-01, -3.573456867778e-01, -2.896098533759e-01, -2.350854346342e-01, -1.995505795508e-01, -1.859071648691e-01, -1.828957188542e-01, -1.777578791089e-01],
        [-1.225206704299e+00, -1.121328240423e+00, -1.016344519070e+00, -9.168870851125e-01, -8.279444729258e-01, -7.454165940953e-01, -6.720595256955e-01, -6.121752919456e-01, -5.638840493864e-01, -5.271664976333e-01, -5.091154755260e-01, -5.178949830917e-01, -5.576051087323e-01, -6.123372409933e-01, -6.640649719245e-01],
        [-1.294346005393e+00, -1.202434141850e+00, -1.109077702644e+00, -1.022944141752e+00, -9.505534922623e-01, -8.865469232812e-01, -8.345266378556e-01, -8.001153977418e-01, -7.808562405025e-01, -7.767239404628e-01, -7.969888645345e-01, -8.523213913027e-01, -9.480803516663e-01, -1.063473130891e+00, -1.174939146350e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.896194949814e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.871535255018e-01, -8.420729203945e-01, -6.970553625310e-01, -5.517225684478e-01, -4.057899769912e-01, -2.594914696586e-01, -1.126698314420e-01,  3.492033818810e-02,  1.831718072503e-01,  3.320834747923e-01,  4.820599378865e-01,  6.335668958931e-01,  7.868382303094e-01,  9.409664656137e-01,  1.094923320740e+00],
        [-9.843010602870e-01, -8.387267517339e-01, -6.932294896017e-01, -5.473469953647e-01, -4.007315231574e-01, -2.536688861440e-01, -1.059669608797e-01,  4.267414254796e-02,  1.921233820849e-01,  3.423794123201e-01,  4.939366681316e-01,  6.473642539986e-01,  8.029479830854e-01,  9.595788816023e-01,  1.116000346233e+00],
        [-1.020175381045e+00, -8.808101844135e-01, -7.413459721205e-01, -6.023768381352e-01, -4.643496855907e-01, -3.268972037257e-01, -1.902662986228e-01, -5.484237167656e-02,  7.954298487971e-02,  2.128915000912e-01,  3.445677544810e-01,  4.738403674632e-01,  6.003420282765e-01,  7.254979267225e-01,  8.509229776421e-01],
        [-1.086864563760e+00, -9.590419020305e-01, -8.307929310176e-01, -7.046755064235e-01, -5.826137577419e-01, -4.630262383087e-01, -3.469759956624e-01, -2.361223652048e-01, -1.297402717979e-01, -2.782227108398e-02,  6.689585536496e-02,  1.512651679878e-01,  2.237042201203e-01,  2.903491283560e-01,  3.581528653710e-01],
        [-1.183535774324e+00, -1.072444923911e+00, -9.604533263906e-01, -8.529654644048e-01, -7.540468231322e-01, -6.603559705147e-01, -5.741390152610e-01, -4.989019602177e-01, -4.331127971514e-01, -3.767557969096e-01, -3.356113809607e-01, -3.163329305645e-01, -3.222618777791e-01, -3.404332474572e-01, -3.561561326425e-01],
        [-1.310189012739e+00, -1.221019250055e+00, -1.130327158240e+00, -1.047246712079e+00, -9.786488817615e-01, -9.188864003436e-01, -8.717553574185e-01, -8.431811567154e-01, -8.305745911808e-01, -8.339090773856e-01, -8.629539544960e-01, -9.289539281937e-01, -1.037556265422e+00, -1.166849200717e+00, -1.292004016399e+00],
        [-1.467657113110e+00, -1.405741861136e+00, -1.341531466467e+00, -1.288796785271e+00, -1.257896850109e+00, -1.240317547174e+00, -1.241782058873e+00, -1.271223832517e+00, -1.324739244682e+00, -1.402288216808e+00, -1.518599513497e+00, -1.690626238762e+00, -1.926882506411e+00, -2.194332997462e+00, -2.455544643833e+00],
        [-1.663851999454e+00, -1.635894073557e+00, -1.604678130142e+00, -1.589752274317e+00, -1.605821434723e+00, -1.640799595101e+00, -1.702810968632e+00, -1.804536826902e+00, -1.940435870224e+00, -2.110451205987e+00, -2.335490716393e+00, -2.639619793972e+00, -3.034924454986e+00, -3.474510165077e+00, -3.905239665354e+00],
        [-1.870040895082e+00, -1.877770054067e+00, -1.881229272644e+00, -1.906038193261e+00, -1.971469017084e+00, -2.061681875568e+00, -2.187324319244e+00, -2.365016355116e+00, -2.587495585324e+00, -2.854687446716e+00, -3.193993698360e+00, -3.636954315542e+00, -4.199409166808e+00, -4.819898525174e+00, -5.428780982121e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.588253311815e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.783305743698e-01, -8.317228966962e-01, -6.852215670767e-01, -5.381884971871e-01, -3.901436894407e-01, -2.414816550097e-01, -9.193720371110e-02,  5.890360592374e-02,  2.108598950519e-01,  3.639298065876e-01,  5.187958146346e-01,  6.762434606001e-01,  8.366672556562e-01,  9.985364706261e-01,  1.160116601613e+00],
        [-9.684321329716e-01, -8.201112373418e-01, -6.719452688100e-01, -5.230046647881e-01, -3.725901681641e-01, -2.212765000422e-01, -6.867733322641e-02,  8.581035930648e-02,  2.419230745290e-01,  3.996581070513e-01,  5.600096803538e-01,  7.241221656394e-01,  8.925702840126e-01,  1.063124079962e+00,  1.233256740396e+00],
        [-1.004146255473e+00, -8.620067447194e-01, -7.198468851943e-01, -5.777887695290e-01, -4.359242410727e-01, -2.941778135555e-01, -1.526002288045e-01, -1.127069090715e-02,  1.298454097246e-01,  2.707484284279e-01,  4.113077797394e-01,  5.513731571667e-01,  6.908690744401e-01,  8.300884232280e-01,  9.693630857130e-01],
        [-1.076154246022e+00, -9.464778471311e-01, -8.164277024837e-01, -6.882462866178e-01, -5.636204856984e-01, -4.411638439245e-01, -3.218083360885e-01, -2.070087031222e-01, -9.612927095948e-02,  1.083648687508e-02,  1.114901080642e-01,  2.030709142865e-01,  2.841924497412e-01,  3.602342537068e-01,  4.372920039701e-01],
        [-1.183475189268e+00, -1.072373852819e+00, -9.603720665998e-01, -8.528725292342e-01, -7.539393838868e-01, -6.602323015044e-01, -5.739966493566e-01, -4.987372729602e-01, -4.329226697969e-01, -3.765371159065e-01, -3.353591246435e-01, -3.160398809901e-01, -3.219197139997e-01, -3.400379282559e-01, -3.557084662628e-01],
        [-1.326109085210e+00, -1.239694761784e+00, -1.151679977542e+00, -1.071667497378e+00, -1.006880935638e+00, -9.513831862954e-01, -9.091651686088e-01, -8.864564004212e-01, -8.805347867876e-01, -8.913723799168e-01, -9.292399183834e-01, -1.005959228663e+00, -1.127467416782e+00, -1.270728122660e+00, -1.409638324986e+00],
        [-1.505036849200e+00, -1.449591265783e+00, -1.391667089390e+00, -1.346135877870e+00, -1.324184659107e+00, -1.316618787942e+00, -1.329618899567e+00, -1.372832489884e+00, -1.442043919658e+00, -1.537209906857e+00, -1.674236483184e+00, -1.871431810744e+00, -2.137990534693e+00, -2.438236829852e+00, -2.731745610769e+00],
        [-1.729577177090e+00, -1.712994936513e+00, -1.692832115889e+00, -1.690572195502e+00, -1.722375976760e+00, -1.774960858070e+00, -1.857255396588e+00, -1.983196382942e+00, -2.146693896810e+00, -2.347685412883e+00, -2.609148814318e+00, -2.957532106337e+00, -3.406117890529e+00, -3.903368803113e+00, -4.390886690018e+00],
        [-1.965888489212e+00, -1.990206908337e+00, -2.009784991330e+00, -2.053064754976e+00, -2.141441512267e+00, -2.257330403934e+00, -2.412551962270e+00, -2.625557128542e+00, -2.888283446680e+00, -3.200648139320e+00, -3.593071665797e+00, -4.100568586062e+00, -4.740723759382e+00, -5.445306780522e+00, -6.137004232098e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  6.186182518544e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.832247196401e-01, -8.374641185133e-01, -6.917858462148e-01, -5.456959297748e-01, -3.988227813984e-01, -2.514718099889e-01, -1.034377198571e-01,  4.559993976964e-02,  1.955011424158e-01,  3.462644504273e-01,  4.984181978093e-01,  6.525705076178e-01,  8.090267887563e-01,  9.666020346844e-01,  1.123953487655e+00],
        [-9.741909122314e-01, -8.268667436253e-01, -6.796692394868e-01, -5.318384130103e-01, -3.828025693087e-01, -2.330315857863e-01, -8.220961112198e-02,  7.015637429041e-02,  2.238509370560e-01,  3.788718653167e-01,  5.360320109842e-01,  6.962669829418e-01,  8.600466585942e-01,  1.025547882849e+00,  1.190704797384e+00],
        [-9.951553125088e-01, -8.514596532360e-01, -7.077877704625e-01, -5.639970051918e-01, -4.199800431670e-01, -2.758250862341e-01, -1.314728451630e-01,  1.316922597188e-02,  1.580606876371e-01,  3.032011246393e-01,  4.487431194146e-01,  5.948622974132e-01,  7.416468604807e-01,  8.887545796809e-01,  1.035797667654e+00],
        [-1.039989254386e+00, -9.040534343830e-01, -7.679213572456e-01, -6.327705657818e-01, -4.994868585323e-01, -3.673421955437e-01, -2.368259648541e-01, -1.087020635306e-01,  1.736330638652e-02,  1.413735720056e-01,  2.620692799841e-01,  3.780007742166e-01,  4.884400147500e-01,  5.962118442682e-01,  7.045171559888e-01],
        [-1.108047615116e+00, -9.838913067548e-01, -8.592047280572e-01, -7.371695010397e-01, -6.201789791478e-01, -5.062660594213e-01, -3.967530273396e-01, -2.937038687796e-01, -1.962166896198e-01, -1.042822300993e-01, -2.130342763594e-02,  4.880286842411e-02,  1.040695551213e-01,  1.521291207252e-01,  2.016301105480e-01],
        [-1.199330394701e+00, -1.090973270352e+00, -9.816378828978e-01, -8.771938109656e-01, -7.820564050133e-01, -6.925966778671e-01, -6.112540326196e-01, -5.418361897752e-01, -4.826793003812e-01, -4.337662816749e-01, -4.013750034446e-01, -3.927314199636e-01, -4.114645184056e-01, -4.434935909468e-01, -4.728634686679e-01],
        [-1.314482715887e+00, -1.226056105485e+00, -1.136086093549e+00, -1.053833089300e+00, -9.862631723845e-01, -9.276509051726e-01, -8.818449235482e-01, -8.548526519530e-01, -8.440490429779e-01, -8.494071452098e-01, -8.808315271147e-01, -9.497225460212e-01, -1.061805639551e+00, -1.194865734863e+00, -1.323730429812e+00],
        [-1.459633244749e+00, -1.396329225116e+00, -1.330769441892e+00, -1.276488476579e+00, -1.243667625709e+00, -1.223938857134e+00, -1.222927157259e+00, -1.249412696978e+00, -1.299558829630e+00, -1.373326164306e+00, -1.485190755532e+00, -1.651814832924e+00, -1.881566428636e+00, -2.141977030110e+00, -2.396255830429e+00],
        [-1.612525246579e+00, -1.575683708490e+00, -1.535836051595e+00, -1.511018988752e+00, -1.514800514111e+00, -1.536029060612e+00, -1.582200705228e+00, -1.665016247243e+00, -1.779362821197e+00, -1.925187933228e+00, -2.121782940006e+00, -2.391352580699e+00, -2.745048422372e+00, -3.139601654741e+00, -3.525983408963e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.056920772967e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-9.997433223064e-01, -8.568417537851e-01, -7.139414449729e-01, -5.710348376150e-01, -4.281162460661e-01, -2.851903433716e-01, -1.422539883131e-01,  6.977223101341e-04,  1.436626459603e-01,  2.866407606398e-01,  4.296401503600e-01,  5.726701199800e-01,  7.157353425458e-01,  8.588176863336e-01,  1.001896605877e+00],
        [-9.996031454136e-01, -8.566773151362e-01, -7.137534325208e-01, -5.708198115962e-01, -4.278676616707e-01, -2.849042078350e-01, -1.419245933872e-01,  1.078762610554e-03,  1.441025475371e-01,  2.871467273817e-01,  4.302238009978e-01,  5.733481548173e-01,  7.165270139309e-01,  8.597323445130e-01,  1.002932380801e+00],
        [-9.999144091238e-01, -8.570424522349e-01, -7.141709154043e-01, -5.712972782819e-01, -4.284196449515e-01, -2.855395736714e-01, -1.426560169814e-01,  2.326601235141e-04,  1.431257431996e-01,  2.860232249117e-01,  4.289278009271e-01,  5.718425740126e-01,  7.147691024261e-01,  8.577013400247e-01,  1.000632435786e+00],
        [-1.000584883636e+00, -8.578289721858e-01, -7.150701902748e-01, -5.723257606677e-01, -4.296086390715e-01, -2.869081771598e-01, -1.442315327313e-01, -1.589878560096e-03,  1.410216674893e-01,  2.836031555422e-01,  4.261361648085e-01,  5.685994925893e-01,  7.109824905571e-01,  8.533264749182e-01,  9.956782620004e-01],
        [-1.001604860551e+00, -8.590254862642e-01, -7.164382357280e-01, -5.738903664379e-01, -4.314174275217e-01, -2.889902010660e-01, -1.466283273355e-01, -4.362463272984e-03,  1.378207872001e-01,  2.799215616214e-01,  4.218893152378e-01,  5.636658700239e-01,  7.052220080636e-01,  8.466710967783e-01,  9.881415953578e-01],
        [-1.002974339868e+00, -8.606319944687e-01, -7.182750517628e-01, -5.759910955914e-01, -4.338460103015e-01, -2.917856453900e-01, -1.498464007942e-01, -8.085094014680e-03,  1.335231023320e-01,  2.749784431497e-01,  4.161872522152e-01,  5.570417063153e-01,  6.974876549453e-01,  8.377352056036e-01,  9.780224358565e-01],
        [-1.004703029992e+00, -8.626598855336e-01, -7.205936597827e-01, -5.786428404472e-01, -4.369116039183e-01, -2.953143273652e-01, -1.539085664049e-01, -1.278416095033e-02,  1.280981460953e-01,  2.687387577788e-01,  4.089895531453e-01,  5.486800419877e-01,  6.877246014653e-01,  8.264554538230e-01,  9.652490476014e-01],
        [-1.006883160717e+00, -8.652173523323e-01, -7.235177631528e-01, -5.819870780094e-01, -4.407777652178e-01, -2.997645107117e-01, -1.590315505420e-01, -1.871037067713e-02,  1.212564839351e-01,  2.608696031917e-01,  3.999122033689e-01,  5.381347620254e-01,  6.754119651025e-01,  8.122300393702e-01,  9.491399393842e-01],
        [-1.009179792245e+00, -8.679114838474e-01, -7.265981233700e-01, -5.855100233608e-01, -4.448505246189e-01, -3.044525008694e-01, -1.644282942934e-01, -2.495326241205e-02,  1.140492202562e-01,  2.525799404274e-01,  3.903497824369e-01,  5.270259683583e-01,  6.624413718507e-01,  7.972444539023e-01,  9.321700002365e-01]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.101355021753e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.026770593313e+00, -8.885468931688e-01, -7.501918097311e-01, -6.124936427601e-01, -4.760453853698e-01, -3.403596550918e-01, -2.057640701413e-01, -7.277001734021e-02,  5.884596257719e-02,  1.890861638707e-01,  3.171074522093e-01,  4.419393630362e-01,  5.630945138832e-01,  6.824639806358e-01,  8.021905842075e-01],
        [-1.045551850492e+00, -9.105788022175e-01, -7.753821969951e-01, -6.413033765123e-01, -5.093513558983e-01, -3.786968231889e-01, -2.498972414096e-01, -1.238227674446e-01, -9.317127999327e-05,  1.212954509116e-01,  2.389084529669e-01,  3.510945283237e-01,  4.570243650188e-01,  5.599157477673e-01,  6.634148213055e-01],
        [-1.033374430149e+00, -8.962937192287e-01, -7.590492150554e-01, -6.226236771442e-01, -4.877563796312e-01, -3.538397113239e-01, -2.212821081165e-01, -9.072110701031e-02,  3.812187475066e-02,  1.652496973800e-01,  2.896112400632e-01,  4.099966416228e-01,  5.257982908654e-01,  6.393737590001e-01,  7.533944633568e-01],
        [-9.965632233922e-01, -8.531112447262e-01, -7.096761328896e-01, -5.661566869061e-01, -4.224767790321e-01, -2.786989788438e-01, -1.347812271081e-01,  9.342127401105e-03,  1.536423972511e-01,  2.981192879086e-01,  4.428810399452e-01,  5.880522404351e-01,  7.336954589538e-01,  8.795679214519e-01,  1.025394535154e+00],
        [-9.357840082315e-01, -7.818123892916e-01, -6.281559261789e-01, -4.729236839298e-01, -3.146932196239e-01, -1.546336425224e-01,  8.040921948255e-03,  1.745571635199e-01,  3.443790590203e-01,  5.175011050906e-01,  6.959457711862e-01,  8.820409602889e-01,  1.076955781658e+00,  1.276154014820e+00,  1.474495565623e+00],
        [-8.510367846682e-01, -6.823971529254e-01, -5.144885949240e-01, -3.429246682153e-01, -1.644057014055e-01,  1.835629764090e-02,  2.071843390519e-01,  4.049240013462e-01,  6.103318600568e-01,  8.233951489266e-01,  1.048805433787e+00,  1.291962801182e+00,  1.555579258976e+00,  1.829132039104e+00,  2.100697554766e+00],
        [-7.416557746976e-01, -5.540845250475e-01, -3.677811634482e-01, -1.751383616372e-01,  2.956644114352e-02,  2.416298584193e-01,  4.642135038703e-01,  7.022524131494e-01,  9.535901375641e-01,  1.218204536824e+00,  1.504232109170e+00,  1.821038127582e+00,  2.173325978535e+00,  2.542846214595e+00,  2.908919973650e+00],
        [-6.013160872076e-01, -3.894549051397e-01, -1.795503627611e-01,  4.013737807088e-02,  2.784395304891e-01,  5.280976991570e-01,  7.939909732509e-01,  1.083735235492e+00,  1.394002594964e+00,  1.724758884145e+00,  2.088560570900e+00,  2.499860402007e+00,  2.965916772821e+00,  3.458566634232e+00,  3.945897797510e+00],
        [-4.529870635670e-01, -2.154531582373e-01,  1.939614610546e-02,  2.676684553500e-01,  5.414806061054e-01,  8.308737411742e-01,  1.142542198643e+00,  1.486935325067e+00,  1.859487098776e+00,  2.260150640346e+00,  2.706154009747e+00,  3.217327050109e+00,  3.803628618625e+00,  4.426417697450e+00,  5.041909274238e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  8.205599384852e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00],
        [-1.040768491563e+00, -9.049675415934e-01, -7.689665101907e-01, -6.339658859556e-01, -5.008687282442e-01, -3.689328103972e-01, -2.386570567483e-01, -1.108202497884e-01,  1.491791288402e-02,  1.385609251589e-01,  2.588247917786e-01,  3.742316084011e-01,  4.840391483673e-01,  5.911272997086e-01,  6.987593287750e-01],
        [-1.070358199011e+00, -9.396786228101e-01, -8.086537463839e-01, -6.793553710837e-01, -5.533419953348e-01, -4.293326855286e-01, -3.081884845004e-01, -1.912534138556e-01, -7.794018024170e-02,  3.175724609145e-02,  1.356229481346e-01,  2.311063608854e-01,  3.169265507347e-01,  3.980536239465e-01,  4.801193204857e-01],
        [-1.056630118018e+00, -9.235744914962e-01, -7.902409386944e-01, -6.582970172914e-01, -5.289971361696e-01, -4.013102936479e-01, -2.759295284635e-01, -1.539366207530e-01, -3.485886808338e-02,  8.130858278884e-02,  1.927821779428e-01,  2.975090109766e-01,  3.944580802101e-01,  4.876297396635e-01,  5.815568810730e-01],
        [-1.008434119341e+00, -8.670367502115e-01, -7.255979885602e-01, -5.843661895194e-01, -4.435281765427e-01, -3.029303989834e-01, -1.626760734979e-01, -2.292631334351e-02,  1.163892826882e-01,  2.552714374075e-01,  3.934545199600e-01,  5.306327838952e-01,  6.666526785672e-01,  8.021099905353e-01,  9.376798190454e-01],
        [-9.267017683217e-01, -7.711581992261e-01, -6.159743592911e-01, -4.589918735510e-01, -2.985871191690e-01, -1.360945556642e-01,  2.938283988527e-02,  1.992452512300e-01,  3.728808440021e-01,  5.502833364892e-01,  7.337612414242e-01,  9.259717033490e-01,  1.128249181783e+00,  1.335415886425e+00,  1.541604745824e+00],
        [-8.114330649598e-01, -6.359388385381e-01, -4.613700508864e-01, -2.821740693859e-01, -9.417396404885e-02,  9.919723630985e-02,  3.002472116853e-01,  5.125780729669e-01,  7.346158158585e-01,  9.663442800350e-01,  1.213702342335e+00,  1.483525769336e+00,  1.779247589855e+00,  2.087547427330e+00,  2.393331661412e+00],
        [-6.616964439177e-01, -4.602858678758e-01, -2.605356000454e-01, -5.248379124993e-02,  1.713632915404e-01,  4.048465310734e-01,  6.521060824202e-01,  9.196044090158e-01,  1.204517626331e+00,  1.506816741494e+00,  1.837156555455e+00,  2.207800958152e+00,  2.624909066808e+00,  3.064583103390e+00,  3.499743954407e+00],
        [-4.686420344219e-01, -2.338176846870e-01, -1.601105308737e-03,  2.436543258303e-01,  5.137186733700e-01,  7.989180928385e-01,  1.105755336931e+00,  1.444380702222e+00,  1.810358842083e+00,  2.203644218726e+00,  2.640971842032e+00,  3.141604044601e+00,  3.715214670887e+00,  4.324268570941e+00,  4.926233816263e+00],
        [-2.644088408301e-01,  5.764101716068e-03,  2.723269491416e-01,  5.569402722920e-01,  8.758980877913e-01,  1.215808304160e+00,  1.585673077593e+00,  1.999544081164e+00,  2.451281194685e+00,  2.940821377446e+00,  3.491331921761e+00,  4.129478846519e+00,  4.868654243258e+00,  5.656895920171e+00,  6.435324341043e+00]],

       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.042765972136e+00, -9.073107452406e-01, -7.716456337828e-01, -6.370299451369e-01, -5.044109846798e-01, -3.730101598411e-01, -2.433508400991e-01, -1.162499649338e-01,  8.649441408794e-03,  1.313510440043e-01,  2.505079373550e-01,  3.645698061689e-01,  4.727580578757e-01,  5.780936826226e-01,  6.839998327615e-01],
        [-1.075369733071e+00, -9.455575510181e-01, -8.153754733993e-01, -6.870428736075e-01, -5.622292601287e-01, -4.395624599179e-01, -3.199648469073e-01, -2.048761758238e-01, -9.366732108156e-02,  1.366817656199e-02,  1.147565628632e-01,  2.068655989907e-01,  2.886231118998e-01,  3.653532228400e-01,  4.430888141738e-01],
        [-1.068594925604e+00, -9.376101628046e-01, -8.062887534791e-01, -6.766505767825e-01, -5.502150730224e-01, -4.257334105513e-01, -3.040450532847e-01, -1.864603397948e-01, -7.240669510961e-02,  3.812175940691e-02,  1.429646406795e-01,  2.396353043783e-01,  3.268849188561e-01,  4.095590326647e-01,  4.931482466074e-01],
        [-1.030486633602e+00, -8.929061041034e-01, -7.551759539272e-01, -6.181939071414e-01, -4.826352705496e-01, -3.479450078640e-01, -2.144962141582e-01, -8.287126213094e-02,  4.718432598317e-02,  1.756731629112e-01,  3.016350783973e-01,  4.239648971846e-01,  5.421075829838e-01,  6.582167129308e-01,  7.747325540477e-01],
        [-9.618917079975e-01, -8.124387984416e-01, -6.631729147336e-01, -5.129719017871e-01, -3.609916260987e-01, -2.079258830271e-01, -5.330830373070e-02,  1.035890776637e-01,  2.624481639497e-01,  4.232656892181e-01,  5.872418662889e-01,  7.557581642338e-01,  9.295083784134e-01,  1.105800537408e+00,  1.281584307441e+00],
        [-8.628101487912e-01, -6.962082458196e-01, -5.302796358994e-01, -3.609845607205e-01, -1.852841396693e-01, -5.676036040391e-03,  1.795186779985e-01,  3.729206795895e-01,  5.733848187905e-01,  7.808993383286e-01,  9.997850043549e-01,  1.235015105528e+00,  1.489087305146e+00,  1.752310506099e+00,  2.013703506784e+00],
        [-7.323951050630e-01, -5.432210227156e-01, -3.553602774474e-01, -1.609328468541e-01,  4.598896212542e-02,  2.605331642651e-01,  4.859747052301e-01,  7.274255231455e-01,  9.826518687528e-01,  1.251630808091e+00,  1.542790502317e+00,  1.865831934233e+00,  2.225627089057e+00,  2.603272345222e+00,  2.977347581139e+00],
        [-5.626014929039e-01, -3.440396055983e-01, -1.276243594389e-01,  9.952409234143e-02,  3.470945264815e-01,  6.071237140121e-01,  8.849645328924e-01,  1.188972413622e+00,  1.515496307179e+00,  1.864498728169e+00,  2.249755452607e+00,  2.687122675530e+00,  3.184563625908e+00,  3.711180453978e+00,  4.231962106516e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]]
                                    ],
                                    dtype=np.float64)

# Nearestly extrapolated data sampled on self.xsamples_ex,
# self.ysamples_ex and self.zsamples_ex.
# Calculated from nearest edge value.
cubic_nearest_extrapolated_data = [
        [  # x inf
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.030782779028e+00, -1.030782779028e+00, -1.030782779028e+00],
        [-1.073676815379e+00, -1.073676815379e+00, -1.073676815379e+00],
        [-1.163501973854e+00, -1.163501973854e+00, -1.163501973854e+00],
        [-1.290670175740e+00, -1.290670175740e+00, -1.290670175740e+00],
        [-1.454172149594e+00, -1.454172149594e+00, -1.454172149594e+00],
        [-1.654007895416e+00, -1.654007895416e+00, -1.654007895416e+00],
        [-1.891186684649e+00, -1.891186684649e+00, -1.891186684649e+00],
        [-2.175296596006e+00, -2.175296596006e+00, -2.175296596006e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.030782779028e+00, -1.030782779028e+00, -1.030782779028e+00],
        [-1.073676815379e+00, -1.073676815379e+00, -1.073676815379e+00],
        [-1.163501973854e+00, -1.163501973854e+00, -1.163501973854e+00],
        [-1.290670175740e+00, -1.290670175740e+00, -1.290670175740e+00],
        [-1.454172149594e+00, -1.454172149594e+00, -1.454172149594e+00],
        [-1.654007895416e+00, -1.654007895416e+00, -1.654007895416e+00],
        [-1.891186684649e+00, -1.891186684649e+00, -1.891186684649e+00],
        [-2.175296596006e+00, -2.175296596006e+00, -2.175296596006e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.030782779028e+00, -1.030782779028e+00, -1.030782779028e+00],
        [-1.073676815379e+00, -1.073676815379e+00, -1.073676815379e+00],
        [-1.163501973854e+00, -1.163501973854e+00, -1.163501973854e+00],
        [-1.290670175740e+00, -1.290670175740e+00, -1.290670175740e+00],
        [-1.454172149594e+00, -1.454172149594e+00, -1.454172149594e+00],
        [-1.654007895416e+00, -1.654007895416e+00, -1.654007895416e+00],
        [-1.891186684649e+00, -1.891186684649e+00, -1.891186684649e+00],
        [-2.175296596006e+00, -2.175296596006e+00, -2.175296596006e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.030782779028e+00, -8.932535062520e-01, -7.555731593911e-01, -6.186481829547e-01, -4.831604436380e-01, -3.485495135622e-01, -2.151921120254e-01, -8.367626886145e-02,  4.625496567741e-02,  1.746042296982e-01,  3.004020259060e-01,  4.225324434334e-01,  5.404350544017e-01,  6.562843556713e-01,  7.725443188807e-01],
        [-1.073676815379e+00, -9.435716238632e-01, -8.131048451937e-01, -6.844460022944e-01, -5.592271039766e-01, -4.361067982684e-01, -3.159867411943e-01, -2.002743484225e-01, -8.835462547467e-02,  1.977874180704e-02,  1.218053172739e-01,  2.150542322926e-01,  2.981841348911e-01,  3.763995585388e-01,  4.555978779767e-01],
        [-1.163501973854e+00, -1.048943681920e+00, -9.335829636980e-01, -8.222343769115e-01, -7.185196397445e-01, -6.194620533001e-01, -5.270625528656e-01, -4.444444444444e-01, -3.702429457696e-01, -3.044440446004e-01, -2.521972019793e-01, -2.194295510376e-01, -2.091177906722e-01, -2.097121342799e-01, -2.081252570929e-01],
        [-1.290670175740e+00, -1.198122101190e+00, -1.104147491019e+00, -1.017305558954e+00, -9.440349151014e-01, -8.790436503113e-01, -8.258889828722e-01, -7.901234567901e-01, -7.693207924793e-01, -7.634560792897e-01, -7.816839146299e-01, -8.345414240669e-01, -9.273205167506e-01, -1.039488238720e+00, -1.147778234832e+00],
        [-1.454172149594e+00, -1.389922925967e+00, -1.323444740431e+00, -1.268111364437e+00, -1.233983126275e+00, -1.212791417897e+00, -1.210094392881e+00, -1.234567901235e+00, -1.282420881106e+00, -1.353614409604e+00, -1.462452545181e+00, -1.625399546533e+00, -1.850724021709e+00, -2.106343230143e+00, -2.355903491925e+00],
        [-1.654007895416e+00, -1.624346156249e+00, -1.591474711935e+00, -1.574651793360e+00, -1.588364273264e+00, -1.620705356057e+00, -1.679678782891e+00, -1.777777777778e+00, -1.909543211650e+00, -2.074919035545e+00, -2.294503093632e+00, -2.592003918436e+00, -2.979328305546e+00, -3.410277108548e+00, -3.832501028372e+00],
        [-1.891186684649e+00, -1.902575747746e+00, -1.909591092255e+00, -1.938475029709e+00, -2.008968159842e+00, -2.104845636197e+00, -2.237013791237e+00, -2.422496570645e+00, -2.653855068608e+00, -2.931012909767e+00, -3.282037835480e+00, -3.739236380038e+00, -4.318833389899e+00, -4.957875398575e+00, -5.585028407488e+00],
        [-2.175296596006e+00, -2.235859279689e+00, -2.290653905277e+00, -2.374288821335e+00, -2.512797921850e+00, -2.684783886663e+00, -2.904629982085e+00, -3.194787379973e+00, -3.545445654710e+00, -3.956504082505e+00, -4.464978387949e+00, -5.113474413830e+00, -5.923389480304e+00, -6.811700584288e+00, -7.684332480770e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.030782779028e+00, -8.932535062520e-01, -7.555731593911e-01, -6.186481829547e-01, -4.831604436380e-01, -3.485495135622e-01, -2.151921120254e-01, -8.367626886145e-02,  4.625496567741e-02,  1.746042296982e-01,  3.004020259060e-01,  4.225324434334e-01,  5.404350544017e-01,  6.562843556713e-01,  7.725443188807e-01],
        [-1.073676815379e+00, -9.435716238632e-01, -8.131048451937e-01, -6.844460022944e-01, -5.592271039766e-01, -4.361067982684e-01, -3.159867411943e-01, -2.002743484225e-01, -8.835462547467e-02,  1.977874180704e-02,  1.218053172739e-01,  2.150542322926e-01,  2.981841348911e-01,  3.763995585388e-01,  4.555978779767e-01],
        [-1.163501973854e+00, -1.048943681920e+00, -9.335829636980e-01, -8.222343769115e-01, -7.185196397445e-01, -6.194620533001e-01, -5.270625528656e-01, -4.444444444444e-01, -3.702429457696e-01, -3.044440446004e-01, -2.521972019793e-01, -2.194295510376e-01, -2.091177906722e-01, -2.097121342799e-01, -2.081252570929e-01],
        [-1.290670175740e+00, -1.198122101190e+00, -1.104147491019e+00, -1.017305558954e+00, -9.440349151014e-01, -8.790436503113e-01, -8.258889828722e-01, -7.901234567901e-01, -7.693207924793e-01, -7.634560792897e-01, -7.816839146299e-01, -8.345414240669e-01, -9.273205167506e-01, -1.039488238720e+00, -1.147778234832e+00],
        [-1.454172149594e+00, -1.389922925967e+00, -1.323444740431e+00, -1.268111364437e+00, -1.233983126275e+00, -1.212791417897e+00, -1.210094392881e+00, -1.234567901235e+00, -1.282420881106e+00, -1.353614409604e+00, -1.462452545181e+00, -1.625399546533e+00, -1.850724021709e+00, -2.106343230143e+00, -2.355903491925e+00],
        [-1.654007895416e+00, -1.624346156249e+00, -1.591474711935e+00, -1.574651793360e+00, -1.588364273264e+00, -1.620705356057e+00, -1.679678782891e+00, -1.777777777778e+00, -1.909543211650e+00, -2.074919035545e+00, -2.294503093632e+00, -2.592003918436e+00, -2.979328305546e+00, -3.410277108548e+00, -3.832501028372e+00],
        [-1.891186684649e+00, -1.902575747746e+00, -1.909591092255e+00, -1.938475029709e+00, -2.008968159842e+00, -2.104845636197e+00, -2.237013791237e+00, -2.422496570645e+00, -2.653855068608e+00, -2.931012909767e+00, -3.282037835480e+00, -3.739236380038e+00, -4.318833389899e+00, -4.957875398575e+00, -5.585028407488e+00],
        [-2.175296596006e+00, -2.235859279689e+00, -2.290653905277e+00, -2.374288821335e+00, -2.512797921850e+00, -2.684783886663e+00, -2.904629982085e+00, -3.194787379973e+00, -3.545445654710e+00, -3.956504082505e+00, -4.464978387949e+00, -5.113474413830e+00, -5.923389480304e+00, -6.811700584288e+00, -7.684332480770e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.030782779028e+00, -8.932535062520e-01, -7.555731593911e-01, -6.186481829547e-01, -4.831604436380e-01, -3.485495135622e-01, -2.151921120254e-01, -8.367626886145e-02,  4.625496567741e-02,  1.746042296982e-01,  3.004020259060e-01,  4.225324434334e-01,  5.404350544017e-01,  6.562843556713e-01,  7.725443188807e-01],
        [-1.073676815379e+00, -9.435716238632e-01, -8.131048451937e-01, -6.844460022944e-01, -5.592271039766e-01, -4.361067982684e-01, -3.159867411943e-01, -2.002743484225e-01, -8.835462547467e-02,  1.977874180704e-02,  1.218053172739e-01,  2.150542322926e-01,  2.981841348911e-01,  3.763995585388e-01,  4.555978779767e-01],
        [-1.163501973854e+00, -1.048943681920e+00, -9.335829636980e-01, -8.222343769115e-01, -7.185196397445e-01, -6.194620533001e-01, -5.270625528656e-01, -4.444444444444e-01, -3.702429457696e-01, -3.044440446004e-01, -2.521972019793e-01, -2.194295510376e-01, -2.091177906722e-01, -2.097121342799e-01, -2.081252570929e-01],
        [-1.290670175740e+00, -1.198122101190e+00, -1.104147491019e+00, -1.017305558954e+00, -9.440349151014e-01, -8.790436503113e-01, -8.258889828722e-01, -7.901234567901e-01, -7.693207924793e-01, -7.634560792897e-01, -7.816839146299e-01, -8.345414240669e-01, -9.273205167506e-01, -1.039488238720e+00, -1.147778234832e+00],
        [-1.454172149594e+00, -1.389922925967e+00, -1.323444740431e+00, -1.268111364437e+00, -1.233983126275e+00, -1.212791417897e+00, -1.210094392881e+00, -1.234567901235e+00, -1.282420881106e+00, -1.353614409604e+00, -1.462452545181e+00, -1.625399546533e+00, -1.850724021709e+00, -2.106343230143e+00, -2.355903491925e+00],
        [-1.654007895416e+00, -1.624346156249e+00, -1.591474711935e+00, -1.574651793360e+00, -1.588364273264e+00, -1.620705356057e+00, -1.679678782891e+00, -1.777777777778e+00, -1.909543211650e+00, -2.074919035545e+00, -2.294503093632e+00, -2.592003918436e+00, -2.979328305546e+00, -3.410277108548e+00, -3.832501028372e+00],
        [-1.891186684649e+00, -1.902575747746e+00, -1.909591092255e+00, -1.938475029709e+00, -2.008968159842e+00, -2.104845636197e+00, -2.237013791237e+00, -2.422496570645e+00, -2.653855068608e+00, -2.931012909767e+00, -3.282037835480e+00, -3.739236380038e+00, -4.318833389899e+00, -4.957875398575e+00, -5.585028407488e+00],
        [-2.175296596006e+00, -2.235859279689e+00, -2.290653905277e+00, -2.374288821335e+00, -2.512797921850e+00, -2.684783886663e+00, -2.904629982085e+00, -3.194787379973e+00, -3.545445654710e+00, -3.956504082505e+00, -4.464978387949e+00, -5.113474413830e+00, -5.923389480304e+00, -6.811700584288e+00, -7.684332480770e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.725443188807e-01,  7.725443188807e-01,  7.725443188807e-01],
        [ 4.555978779767e-01,  4.555978779767e-01,  4.555978779767e-01],
        [-2.081252570929e-01, -2.081252570929e-01, -2.081252570929e-01],
        [-1.147778234832e+00, -1.147778234832e+00, -1.147778234832e+00],
        [-2.355903491925e+00, -2.355903491925e+00, -2.355903491925e+00],
        [-3.832501028372e+00, -3.832501028372e+00, -3.832501028372e+00],
        [-5.585028407488e+00, -5.585028407488e+00, -5.585028407488e+00],
        [-7.684332480770e+00, -7.684332480770e+00, -7.684332480770e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.725443188807e-01,  7.725443188807e-01,  7.725443188807e-01],
        [ 4.555978779767e-01,  4.555978779767e-01,  4.555978779767e-01],
        [-2.081252570929e-01, -2.081252570929e-01, -2.081252570929e-01],
        [-1.147778234832e+00, -1.147778234832e+00, -1.147778234832e+00],
        [-2.355903491925e+00, -2.355903491925e+00, -2.355903491925e+00],
        [-3.832501028372e+00, -3.832501028372e+00, -3.832501028372e+00],
        [-5.585028407488e+00, -5.585028407488e+00, -5.585028407488e+00],
        [-7.684332480770e+00, -7.684332480770e+00, -7.684332480770e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.725443188807e-01,  7.725443188807e-01,  7.725443188807e-01],
        [ 4.555978779767e-01,  4.555978779767e-01,  4.555978779767e-01],
        [-2.081252570929e-01, -2.081252570929e-01, -2.081252570929e-01],
        [-1.147778234832e+00, -1.147778234832e+00, -1.147778234832e+00],
        [-2.355903491925e+00, -2.355903491925e+00, -2.355903491925e+00],
        [-3.832501028372e+00, -3.832501028372e+00, -3.832501028372e+00],
        [-5.585028407488e+00, -5.585028407488e+00, -5.585028407488e+00],
        [-7.684332480770e+00, -7.684332480770e+00, -7.684332480770e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],
       [[-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],
       [[-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x mid
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.878888099752e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.878888099752e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.878888099752e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.665692623358e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.665692623358e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.665692623358e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.953473919302e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.953473919302e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.953473919302e-18,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.908544880696e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.908544880696e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.908544880696e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -4.021497292953e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -4.021497292953e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -4.021497292953e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.314921782086e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.314921782086e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.314921782086e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  4.355375654709e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  4.355375654709e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  4.355375654709e-16,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.896194949814e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.896194949814e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  2.896194949814e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.588253311815e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.588253311815e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.588253311815e-17,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  6.186182518544e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  6.186182518544e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  6.186182518544e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.056920772967e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.056920772967e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -7.056920772967e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.101355021753e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.101355021753e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -3.101355021753e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  8.205599384852e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  8.205599384852e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  8.205599384852e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.030782779028e+00, -1.030782779028e+00, -1.030782779028e+00],
        [-1.073676815379e+00, -1.073676815379e+00, -1.073676815379e+00],
        [-1.163501973854e+00, -1.163501973854e+00, -1.163501973854e+00],
        [-1.290670175740e+00, -1.290670175740e+00, -1.290670175740e+00],
        [-1.454172149594e+00, -1.454172149594e+00, -1.454172149594e+00],
        [-1.654007895416e+00, -1.654007895416e+00, -1.654007895416e+00],
        [-1.891186684649e+00, -1.891186684649e+00, -1.891186684649e+00],
        [-2.175296596006e+00, -2.175296596006e+00, -2.175296596006e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.016896542521e+00, -1.016896542521e+00, -1.016896542521e+00],
        [-1.042014049331e+00, -1.042014049331e+00, -1.042014049331e+00],
        [-1.098987792758e+00, -1.098987792758e+00, -1.098987792758e+00],
        [-1.181309509408e+00, -1.181309509408e+00, -1.181309509408e+00],
        [-1.288294118922e+00, -1.288294118922e+00, -1.288294118922e+00],
        [-1.419941621302e+00, -1.419941621302e+00, -1.419941621302e+00],
        [-1.576937096904e+00, -1.576937096904e+00, -1.576937096904e+00],
        [-1.765788809124e+00, -1.765788809124e+00, -1.765788809124e+00],
        [-1.962861485631e+00, -1.962861485631e+00, -1.962861485631e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.003782778989e+00, -1.003782778989e+00, -1.003782778989e+00],
        [-1.009503137067e+00, -1.009503137067e+00, -1.009503137067e+00],
        [-1.022731614115e+00, -1.022731614115e+00, -1.022731614115e+00],
        [-1.041934293354e+00, -1.041934293354e+00, -1.041934293354e+00],
        [-1.066949709860e+00, -1.066949709860e+00, -1.066949709860e+00],
        [-1.097777863632e+00, -1.097777863632e+00, -1.097777863632e+00],
        [-1.134580219596e+00, -1.134580219596e+00, -1.134580219596e+00],
        [-1.178890694530e+00, -1.178890694530e+00, -1.178890694530e+00],
        [-1.225138748552e+00, -1.225138748552e+00, -1.225138748552e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.929147792443e-01, -9.929147792443e-01, -9.929147792443e-01],
        [-9.791571340923e-01, -9.791571340923e-01, -9.791571340923e-01],
        [-9.395438444045e-01, -9.395438444045e-01, -9.395438444045e-01],
        [-8.793572461614e-01, -8.793572461614e-01, -8.793572461614e-01],
        [-7.991533747293e-01, -7.991533747293e-01, -7.991533747293e-01],
        [-6.989322301082e-01, -6.989322301082e-01, -6.989322301082e-01],
        [-5.781377769319e-01, -5.781377769319e-01, -5.781377769319e-01],
        [-4.314876792198e-01, -4.314876792198e-01, -4.314876792198e-01],
        [-2.781651571114e-01, -2.781651571114e-01, -2.781651571114e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.935612227527e-01, -9.935612227527e-01, -9.935612227527e-01],
        [-9.758270087247e-01, -9.758270087247e-01, -9.758270087247e-01],
        [-9.143229771714e-01, -9.143229771714e-01, -9.143229771714e-01],
        [-8.179913488775e-01, -8.179913488775e-01, -8.179913488775e-01],
        [-6.877734102414e-01, -6.877734102414e-01, -6.877734102414e-01],
        [-5.236691612632e-01, -5.236691612632e-01, -5.236691612632e-01],
        [-3.247373155444e-01, -3.247373155444e-01, -3.247373155444e-01],
        [-8.203565230032e-02, -8.203565230032e-02, -8.203565230032e-02],
        [ 1.719614477245e-01,  1.719614477245e-01,  1.719614477245e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.978530139089e-01, -9.978530139089e-01, -9.978530139089e-01],
        [-9.847379600102e-01, -9.847379600102e-01, -9.847379600102e-01],
        [-9.291216433578e-01, -9.291216433578e-01, -9.291216433578e-01],
        [-8.396871176323e-01, -8.396871176323e-01, -8.396871176323e-01],
        [-7.173483884844e-01, -7.173483884844e-01, -7.173483884844e-01],
        [-5.621054559143e-01, -5.621054559143e-01, -5.621054559143e-01],
        [-3.730443142720e-01, -3.730443142720e-01, -3.730443142720e-01],
        [-1.414819098745e-01, -1.414819098745e-01, -1.414819098745e-01],
        [ 1.010485623302e-01,  1.010485623302e-01,  1.010485623302e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.001667403016e+00, -1.001667403016e+00, -1.001667403016e+00],
        [-9.985850131794e-01, -9.985850131794e-01, -9.985850131794e-01],
        [-9.770971760388e-01, -9.770971760388e-01, -9.770971760388e-01],
        [-9.409641442692e-01, -9.409641442692e-01, -9.409641442692e-01],
        [-8.905817339418e-01, -8.905817339418e-01, -8.905817339418e-01],
        [-8.259499450565e-01, -8.259499450565e-01, -8.259499450565e-01],
        [-7.466729615417e-01, -7.466729615417e-01, -7.466729615417e-01],
        [-6.489905307230e-01, -6.489905307230e-01, -6.489905307230e-01],
        [-5.465583070529e-01, -5.465583070529e-01, -5.465583070529e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.962709223269e-01, -9.962709223269e-01, -9.962709223269e-01],
        [-9.958666376014e-01, -9.958666376014e-01, -9.958666376014e-01],
        [-1.008345925548e+00, -1.008345925548e+00, -1.008345925548e+00],
        [-1.031076658415e+00, -1.031076658415e+00, -1.031076658415e+00],
        [-1.063781770126e+00, -1.063781770126e+00, -1.063781770126e+00],
        [-1.106461260679e+00, -1.106461260679e+00, -1.106461260679e+00],
        [-1.159392196152e+00, -1.159392196152e+00, -1.159392196152e+00],
        [-1.225206704299e+00, -1.225206704299e+00, -1.225206704299e+00],
        [-1.294346005393e+00, -1.294346005393e+00, -1.294346005393e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.871535255018e-01, -9.871535255018e-01, -9.871535255018e-01],
        [-9.843010602870e-01, -9.843010602870e-01, -9.843010602870e-01],
        [-1.020175381045e+00, -1.020175381045e+00, -1.020175381045e+00],
        [-1.086864563760e+00, -1.086864563760e+00, -1.086864563760e+00],
        [-1.183535774324e+00, -1.183535774324e+00, -1.183535774324e+00],
        [-1.310189012739e+00, -1.310189012739e+00, -1.310189012739e+00],
        [-1.467657113110e+00, -1.467657113110e+00, -1.467657113110e+00],
        [-1.663851999454e+00, -1.663851999454e+00, -1.663851999454e+00],
        [-1.870040895082e+00, -1.870040895082e+00, -1.870040895082e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.783305743698e-01, -9.783305743698e-01, -9.783305743698e-01],
        [-9.684321329716e-01, -9.684321329716e-01, -9.684321329716e-01],
        [-1.004146255473e+00, -1.004146255473e+00, -1.004146255473e+00],
        [-1.076154246022e+00, -1.076154246022e+00, -1.076154246022e+00],
        [-1.183475189268e+00, -1.183475189268e+00, -1.183475189268e+00],
        [-1.326109085210e+00, -1.326109085210e+00, -1.326109085210e+00],
        [-1.505036849200e+00, -1.505036849200e+00, -1.505036849200e+00],
        [-1.729577177090e+00, -1.729577177090e+00, -1.729577177090e+00],
        [-1.965888489212e+00, -1.965888489212e+00, -1.965888489212e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.832247196401e-01, -9.832247196401e-01, -9.832247196401e-01],
        [-9.741909122314e-01, -9.741909122314e-01, -9.741909122314e-01],
        [-9.951553125088e-01, -9.951553125088e-01, -9.951553125088e-01],
        [-1.039989254386e+00, -1.039989254386e+00, -1.039989254386e+00],
        [-1.108047615116e+00, -1.108047615116e+00, -1.108047615116e+00],
        [-1.199330394701e+00, -1.199330394701e+00, -1.199330394701e+00],
        [-1.314482715887e+00, -1.314482715887e+00, -1.314482715887e+00],
        [-1.459633244749e+00, -1.459633244749e+00, -1.459633244749e+00],
        [-1.612525246579e+00, -1.612525246579e+00, -1.612525246579e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-9.997433223064e-01, -9.997433223064e-01, -9.997433223064e-01],
        [-9.996031454136e-01, -9.996031454136e-01, -9.996031454136e-01],
        [-9.999144091238e-01, -9.999144091238e-01, -9.999144091238e-01],
        [-1.000584883636e+00, -1.000584883636e+00, -1.000584883636e+00],
        [-1.001604860551e+00, -1.001604860551e+00, -1.001604860551e+00],
        [-1.002974339868e+00, -1.002974339868e+00, -1.002974339868e+00],
        [-1.004703029992e+00, -1.004703029992e+00, -1.004703029992e+00],
        [-1.006883160717e+00, -1.006883160717e+00, -1.006883160717e+00],
        [-1.009179792245e+00, -1.009179792245e+00, -1.009179792245e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.026770593313e+00, -1.026770593313e+00, -1.026770593313e+00],
        [-1.045551850492e+00, -1.045551850492e+00, -1.045551850492e+00],
        [-1.033374430149e+00, -1.033374430149e+00, -1.033374430149e+00],
        [-9.965632233922e-01, -9.965632233922e-01, -9.965632233922e-01],
        [-9.357840082315e-01, -9.357840082315e-01, -9.357840082315e-01],
        [-8.510367846682e-01, -8.510367846682e-01, -8.510367846682e-01],
        [-7.416557746976e-01, -7.416557746976e-01, -7.416557746976e-01],
        [-6.013160872076e-01, -6.013160872076e-01, -6.013160872076e-01],
        [-4.529870635670e-01, -4.529870635670e-01, -4.529870635670e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.040768491563e+00, -1.040768491563e+00, -1.040768491563e+00],
        [-1.070358199011e+00, -1.070358199011e+00, -1.070358199011e+00],
        [-1.056630118018e+00, -1.056630118018e+00, -1.056630118018e+00],
        [-1.008434119341e+00, -1.008434119341e+00, -1.008434119341e+00],
        [-9.267017683217e-01, -9.267017683217e-01, -9.267017683217e-01],
        [-8.114330649598e-01, -8.114330649598e-01, -8.114330649598e-01],
        [-6.616964439177e-01, -6.616964439177e-01, -6.616964439177e-01],
        [-4.686420344219e-01, -4.686420344219e-01, -4.686420344219e-01],
        [-2.644088408301e-01, -2.644088408301e-01, -2.644088408301e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.042765972136e+00, -1.042765972136e+00, -1.042765972136e+00],
        [-1.075369733071e+00, -1.075369733071e+00, -1.075369733071e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.030486633602e+00, -1.030486633602e+00, -1.030486633602e+00],
        [-9.618917079975e-01, -9.618917079975e-01, -9.618917079975e-01],
        [-8.628101487912e-01, -8.628101487912e-01, -8.628101487912e-01],
        [-7.323951050630e-01, -7.323951050630e-01, -7.323951050630e-01],
        [-5.626014929039e-01, -5.626014929039e-01, -5.626014929039e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]]
                ], dtype=np.float64),

                None,  # z mid (interpolation area)

                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 7.725443188807e-01,  7.725443188807e-01,  7.725443188807e-01],
        [ 4.555978779767e-01,  4.555978779767e-01,  4.555978779767e-01],
        [-2.081252570929e-01, -2.081252570929e-01, -2.081252570929e-01],
        [-1.147778234832e+00, -1.147778234832e+00, -1.147778234832e+00],
        [-2.355903491925e+00, -2.355903491925e+00, -2.355903491925e+00],
        [-3.832501028372e+00, -3.832501028372e+00, -3.832501028372e+00],
        [-5.585028407488e+00, -5.585028407488e+00, -5.585028407488e+00],
        [-7.684332480770e+00, -7.684332480770e+00, -7.684332480770e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 8.751504994315e-01,  8.751504994315e-01,  8.751504994315e-01],
        [ 6.895558325490e-01,  6.895558325490e-01,  6.895558325490e-01],
        [ 2.685736462000e-01,  2.685736462000e-01,  2.685736462000e-01],
        [-3.397061362837e-01, -3.397061362837e-01, -3.397061362837e-01],
        [-1.130221417709e+00, -1.130221417709e+00, -1.130221417709e+00],
        [-2.102972198077e+00, -2.102972198077e+00, -2.102972198077e+00],
        [-3.263020574579e+00, -3.263020574579e+00, -3.263020574579e+00],
        [-4.658456470547e+00, -4.658456470547e+00, -4.658456470547e+00],
        [-6.114637532830e+00, -6.114637532830e+00, -6.114637532830e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 9.720488338398e-01,  9.720488338398e-01,  9.720488338398e-01],
        [ 9.297807870949e-01,  9.297807870949e-01,  9.297807870949e-01],
        [ 8.320348280849e-01,  8.320348280849e-01,  8.320348280849e-01],
        [ 6.901451539392e-01,  6.901451539392e-01,  6.901451539392e-01],
        [ 5.053048380397e-01,  5.053048380397e-01,  5.053048380397e-01],
        [ 2.775138803866e-01,  2.775138803866e-01,  2.775138803866e-01],
        [ 5.579207597604e-03,  5.579207597604e-03,  5.579207597604e-03],
        [-3.218333774566e-01, -3.218333774566e-01, -3.218333774566e-01],
        [-6.635628430952e-01, -6.635628430952e-01, -6.635628430952e-01]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.052353093637e+00,  1.052353093637e+00,  1.052353093637e+00],
        [ 1.154009105455e+00,  1.154009105455e+00,  1.154009105455e+00],
        [ 1.446713925221e+00,  1.446713925221e+00,  1.446713925221e+00],
        [ 1.891436076043e+00,  1.891436076043e+00,  1.891436076043e+00],
        [ 2.484066981406e+00,  2.484066981406e+00,  2.484066981406e+00],
        [ 3.224606641310e+00,  3.224606641310e+00,  3.224606641310e+00],
        [ 4.117163632270e+00,  4.117163632270e+00,  4.117163632270e+00],
        [ 5.200769431179e+00,  5.200769431179e+00,  5.200769431179e+00],
        [ 6.333678148268e+00,  6.333678148268e+00,  6.333678148268e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.047576486289e+00,  1.047576486289e+00,  1.047576486289e+00],
        [ 1.178615588612e+00,  1.178615588612e+00,  1.178615588612e+00],
        [ 1.633072328070e+00,  1.633072328070e+00,  1.633072328070e+00],
        [ 2.344872133635e+00,  2.344872133635e+00,  2.344872133635e+00],
        [ 3.307059787304e+00,  3.307059787304e+00,  3.307059787304e+00],
        [ 4.519635289077e+00,  4.519635289077e+00,  4.519635289077e+00],
        [ 5.989553856957e+00,  5.989553856957e+00,  5.989553856957e+00],
        [ 7.782890061971e+00,  7.782890061971e+00,  7.782890061971e+00],
        [ 9.659688883021e+00,  9.659688883021e+00,  9.659688883021e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.015864200671e+00,  1.015864200671e+00,  1.015864200671e+00],
        [ 1.112772069668e+00,  1.112772069668e+00,  1.112772069668e+00],
        [ 1.523724153429e+00,  1.523724153429e+00,  1.523724153429e+00],
        [ 2.184560881196e+00,  2.184560881196e+00,  2.184560881196e+00],
        [ 3.088528613941e+00,  3.088528613941e+00,  3.088528613941e+00],
        [ 4.235627351665e+00,  4.235627351665e+00,  4.235627351665e+00],
        [ 5.632610733395e+00,  5.632610733395e+00,  5.632610733395e+00],
        [ 7.343638329887e+00,  7.343638329887e+00,  7.343638329887e+00],
        [ 9.135709594706e+00,  9.135709594706e+00,  9.135709594706e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 9.876794655752e-01,  9.876794655752e-01,  9.876794655752e-01],
        [ 1.010455416997e+00,  1.010455416997e+00,  1.010455416997e+00],
        [ 1.169230251073e+00,  1.169230251073e+00,  1.169230251073e+00],
        [ 1.436219249843e+00,  1.436219249843e+00,  1.436219249843e+00],
        [ 1.808497706152e+00,  1.808497706152e+00,  1.808497706152e+00],
        [ 2.286065620000e+00,  2.286065620000e+00,  2.286065620000e+00],
        [ 2.871847698541e+00,  2.871847698541e+00,  2.871847698541e+00],
        [ 3.593628659739e+00,  3.593628659739e+00,  3.593628659739e+00],
        [ 4.350506106781e+00,  4.350506106781e+00,  4.350506106781e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.027554364124e+00,  1.027554364124e+00,  1.027554364124e+00],
        [ 1.030541646641e+00,  1.030541646641e+00,  1.030541646641e+00],
        [ 9.383314879317e-01,  9.383314879317e-01,  9.383314879317e-01],
        [ 7.703728276019e-01,  7.703728276019e-01,  7.703728276019e-01],
        [ 5.287129224518e-01,  5.287129224518e-01,  5.287129224518e-01],
        [ 2.133517724815e-01,  2.133517724815e-01,  2.133517724815e-01],
        [-1.777578791089e-01, -1.777578791089e-01, -1.777578791089e-01],
        [-6.640649719245e-01, -6.640649719245e-01, -6.640649719245e-01],
        [-1.174939146350e+00, -1.174939146350e+00, -1.174939146350e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.094923320740e+00,  1.094923320740e+00,  1.094923320740e+00],
        [ 1.116000346233e+00,  1.116000346233e+00,  1.116000346233e+00],
        [ 8.509229776421e-01,  8.509229776421e-01,  8.509229776421e-01],
        [ 3.581528653710e-01,  3.581528653710e-01,  3.581528653710e-01],
        [-3.561561326425e-01, -3.561561326425e-01, -3.561561326425e-01],
        [-1.292004016399e+00, -1.292004016399e+00, -1.292004016399e+00],
        [-2.455544643833e+00, -2.455544643833e+00, -2.455544643833e+00],
        [-3.905239665354e+00, -3.905239665354e+00, -3.905239665354e+00],
        [-5.428780982121e+00, -5.428780982121e+00, -5.428780982121e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.160116601613e+00,  1.160116601613e+00,  1.160116601613e+00],
        [ 1.233256740396e+00,  1.233256740396e+00,  1.233256740396e+00],
        [ 9.693630857130e-01,  9.693630857130e-01,  9.693630857130e-01],
        [ 4.372920039701e-01,  4.372920039701e-01,  4.372920039701e-01],
        [-3.557084662628e-01, -3.557084662628e-01, -3.557084662628e-01],
        [-1.409638324986e+00, -1.409638324986e+00, -1.409638324986e+00],
        [-2.731745610769e+00, -2.731745610769e+00, -2.731745610769e+00],
        [-4.390886690018e+00, -4.390886690018e+00, -4.390886690018e+00],
        [-6.137004232098e+00, -6.137004232098e+00, -6.137004232098e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.123953487655e+00,  1.123953487655e+00,  1.123953487655e+00],
        [ 1.190704797384e+00,  1.190704797384e+00,  1.190704797384e+00],
        [ 1.035797667654e+00,  1.035797667654e+00,  1.035797667654e+00],
        [ 7.045171559888e-01,  7.045171559888e-01,  7.045171559888e-01],
        [ 2.016301105480e-01,  2.016301105480e-01,  2.016301105480e-01],
        [-4.728634686679e-01, -4.728634686679e-01, -4.728634686679e-01],
        [-1.323730429812e+00, -1.323730429812e+00, -1.323730429812e+00],
        [-2.396255830429e+00, -2.396255830429e+00, -2.396255830429e+00],
        [-3.525983408963e+00, -3.525983408963e+00, -3.525983408963e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.001896605877e+00,  1.001896605877e+00,  1.001896605877e+00],
        [ 1.002932380801e+00,  1.002932380801e+00,  1.002932380801e+00],
        [ 1.000632435786e+00,  1.000632435786e+00,  1.000632435786e+00],
        [ 9.956782620004e-01,  9.956782620004e-01,  9.956782620004e-01],
        [ 9.881415953578e-01,  9.881415953578e-01,  9.881415953578e-01],
        [ 9.780224358565e-01,  9.780224358565e-01,  9.780224358565e-01],
        [ 9.652490476014e-01,  9.652490476014e-01,  9.652490476014e-01],
        [ 9.491399393842e-01,  9.491399393842e-01,  9.491399393842e-01],
        [ 9.321700002365e-01,  9.321700002365e-01,  9.321700002365e-01]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 8.021905842075e-01,  8.021905842075e-01,  8.021905842075e-01],
        [ 6.634148213055e-01,  6.634148213055e-01,  6.634148213055e-01],
        [ 7.533944633568e-01,  7.533944633568e-01,  7.533944633568e-01],
        [ 1.025394535154e+00,  1.025394535154e+00,  1.025394535154e+00],
        [ 1.474495565623e+00,  1.474495565623e+00,  1.474495565623e+00],
        [ 2.100697554766e+00,  2.100697554766e+00,  2.100697554766e+00],
        [ 2.908919973650e+00,  2.908919973650e+00,  2.908919973650e+00],
        [ 3.945897797510e+00,  3.945897797510e+00,  3.945897797510e+00],
        [ 5.041909274238e+00,  5.041909274238e+00,  5.041909274238e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.987593287750e-01,  6.987593287750e-01,  6.987593287750e-01],
        [ 4.801193204857e-01,  4.801193204857e-01,  4.801193204857e-01],
        [ 5.815568810730e-01,  5.815568810730e-01,  5.815568810730e-01],
        [ 9.376798190454e-01,  9.376798190454e-01,  9.376798190454e-01],
        [ 1.541604745824e+00,  1.541604745824e+00,  1.541604745824e+00],
        [ 2.393331661412e+00,  2.393331661412e+00,  2.393331661412e+00],
        [ 3.499743954407e+00,  3.499743954407e+00,  3.499743954407e+00],
        [ 4.926233816263e+00,  4.926233816263e+00,  4.926233816263e+00],
        [ 6.435324341043e+00,  6.435324341043e+00,  6.435324341043e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.839998327615e-01,  6.839998327615e-01,  6.839998327615e-01],
        [ 4.430888141738e-01,  4.430888141738e-01,  4.430888141738e-01],
        [ 4.931482466074e-01,  4.931482466074e-01,  4.931482466074e-01],
        [ 7.747325540477e-01,  7.747325540477e-01,  7.747325540477e-01],
        [ 1.281584307441e+00,  1.281584307441e+00,  1.281584307441e+00],
        [ 2.013703506784e+00,  2.013703506784e+00,  2.013703506784e+00],
        [ 2.977347581139e+00,  2.977347581139e+00,  2.977347581139e+00],
        [ 4.231962106516e+00,  4.231962106516e+00,  4.231962106516e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00],
        [-2.471517764686e+00, -2.471517764686e+00, -2.471517764686e+00]],
       [[-1.962861485631e+00, -1.962861485631e+00, -1.962861485631e+00],
        [-1.962861485631e+00, -1.962861485631e+00, -1.962861485631e+00],
        [-1.962861485631e+00, -1.962861485631e+00, -1.962861485631e+00]],
       [[-1.225138748552e+00, -1.225138748552e+00, -1.225138748552e+00],
        [-1.225138748552e+00, -1.225138748552e+00, -1.225138748552e+00],
        [-1.225138748552e+00, -1.225138748552e+00, -1.225138748552e+00]],
       [[-2.781651571114e-01, -2.781651571114e-01, -2.781651571114e-01],
        [-2.781651571114e-01, -2.781651571114e-01, -2.781651571114e-01],
        [-2.781651571114e-01, -2.781651571114e-01, -2.781651571114e-01]],
       [[ 1.719614477245e-01,  1.719614477245e-01,  1.719614477245e-01],
        [ 1.719614477245e-01,  1.719614477245e-01,  1.719614477245e-01],
        [ 1.719614477245e-01,  1.719614477245e-01,  1.719614477245e-01]],
       [[ 1.010485623302e-01,  1.010485623302e-01,  1.010485623302e-01],
        [ 1.010485623302e-01,  1.010485623302e-01,  1.010485623302e-01],
        [ 1.010485623302e-01,  1.010485623302e-01,  1.010485623302e-01]],
       [[-5.465583070529e-01, -5.465583070529e-01, -5.465583070529e-01],
        [-5.465583070529e-01, -5.465583070529e-01, -5.465583070529e-01],
        [-5.465583070529e-01, -5.465583070529e-01, -5.465583070529e-01]],
       [[-1.294346005393e+00, -1.294346005393e+00, -1.294346005393e+00],
        [-1.294346005393e+00, -1.294346005393e+00, -1.294346005393e+00],
        [-1.294346005393e+00, -1.294346005393e+00, -1.294346005393e+00]],
       [[-1.870040895082e+00, -1.870040895082e+00, -1.870040895082e+00],
        [-1.870040895082e+00, -1.870040895082e+00, -1.870040895082e+00],
        [-1.870040895082e+00, -1.870040895082e+00, -1.870040895082e+00]],
       [[-1.965888489212e+00, -1.965888489212e+00, -1.965888489212e+00],
        [-1.965888489212e+00, -1.965888489212e+00, -1.965888489212e+00],
        [-1.965888489212e+00, -1.965888489212e+00, -1.965888489212e+00]],
       [[-1.612525246579e+00, -1.612525246579e+00, -1.612525246579e+00],
        [-1.612525246579e+00, -1.612525246579e+00, -1.612525246579e+00],
        [-1.612525246579e+00, -1.612525246579e+00, -1.612525246579e+00]],
       [[-1.009179792245e+00, -1.009179792245e+00, -1.009179792245e+00],
        [-1.009179792245e+00, -1.009179792245e+00, -1.009179792245e+00],
        [-1.009179792245e+00, -1.009179792245e+00, -1.009179792245e+00]],
       [[-4.529870635670e-01, -4.529870635670e-01, -4.529870635670e-01],
        [-4.529870635670e-01, -4.529870635670e-01, -4.529870635670e-01],
        [-4.529870635670e-01, -4.529870635670e-01, -4.529870635670e-01]],
       [[-2.644088408301e-01, -2.644088408301e-01, -2.644088408301e-01],
        [-2.644088408301e-01, -2.644088408301e-01, -2.644088408301e-01],
        [-2.644088408301e-01, -2.644088408301e-01, -2.644088408301e-01]],
       [[-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00],
        [-2.471517764686e+00, -2.583350280133e+00, -2.687960958997e+00, -2.828680820775e+00, -3.038105329129e+00, -3.289444193986e+00, -3.600705832934e+00, -4.000000000000e+00, -4.475043654784e+00, -5.025710687118e+00, -5.698346246385e+00, -6.546294530767e+00, -7.596345830336e+00, -8.744552065662e+00, -9.873127313836e+00]],
       [[-1.962861485631e+00, -1.986655992285e+00, -2.005725018576e+00, -2.048421446683e+00, -2.136073538703e+00, -2.251151544660e+00, -2.405438952412e+00, -2.617328879715e+00, -2.878784137474e+00, -3.189722207744e+00, -3.580468215003e+00, -4.085926986869e+00, -4.723628273316e+00, -5.425555496774e+00, -6.114637532830e+00],
        [-1.962861485631e+00, -1.986655992285e+00, -2.005725018576e+00, -2.048421446683e+00, -2.136073538703e+00, -2.251151544660e+00, -2.405438952412e+00, -2.617328879715e+00, -2.878784137474e+00, -3.189722207744e+00, -3.580468215003e+00, -4.085926986869e+00, -4.723628273316e+00, -5.425555496774e+00, -6.114637532830e+00],
        [-1.962861485631e+00, -1.986655992285e+00, -2.005725018576e+00, -2.048421446683e+00, -2.136073538703e+00, -2.251151544660e+00, -2.405438952412e+00, -2.617328879715e+00, -2.878784137474e+00, -3.189722207744e+00, -3.580468215003e+00, -4.085926986869e+00, -4.723628273316e+00, -5.425555496774e+00, -6.114637532830e+00]],
       [[-1.225138748552e+00, -1.121248522926e+00, -1.016253373329e+00, -9.167828435824e-01, -8.278239627748e-01, -7.452778796894e-01, -6.718998397578e-01, -6.119905690714e-01, -5.636707914087e-01, -5.269212122116e-01, -5.088325300661e-01, -5.175662815229e-01, -5.572213177982e-01, -6.118938278215e-01, -6.635628430952e-01],
        [-1.225138748552e+00, -1.121248522926e+00, -1.016253373329e+00, -9.167828435824e-01, -8.278239627748e-01, -7.452778796894e-01, -6.718998397578e-01, -6.119905690714e-01, -5.636707914087e-01, -5.269212122116e-01, -5.088325300661e-01, -5.175662815229e-01, -5.572213177982e-01, -6.118938278215e-01, -6.635628430952e-01],
        [-1.225138748552e+00, -1.121248522926e+00, -1.016253373329e+00, -9.167828435824e-01, -8.278239627748e-01, -7.452778796894e-01, -6.718998397578e-01, -6.119905690714e-01, -5.636707914087e-01, -5.269212122116e-01, -5.088325300661e-01, -5.175662815229e-01, -5.572213177982e-01, -6.118938278215e-01, -6.635628430952e-01]],
       [[-2.781651571114e-01, -1.037315182893e-02,  2.538762708218e-01,  5.358386066304e-01,  8.515031572248e-01,  1.187728277095e+00,  1.553347772798e+00,  1.962150536573e+00,  2.408111274840e+00,  2.891168125817e+00,  3.434055129435e+00,  4.062939622466e+00,  4.790963250421e+00,  5.567135568341e+00,  6.333678148268e+00],
        [-2.781651571114e-01, -1.037315182893e-02,  2.538762708218e-01,  5.358386066304e-01,  8.515031572248e-01,  1.187728277095e+00,  1.553347772798e+00,  1.962150536573e+00,  2.408111274840e+00,  2.891168125817e+00,  3.434055129435e+00,  4.062939622466e+00,  4.790963250421e+00,  5.567135568341e+00,  6.333678148268e+00],
        [-2.781651571114e-01, -1.037315182893e-02,  2.538762708218e-01,  5.358386066304e-01,  8.515031572248e-01,  1.187728277095e+00,  1.553347772798e+00,  1.962150536573e+00,  2.408111274840e+00,  2.891168125817e+00,  3.434055129435e+00,  4.062939622466e+00,  4.790963250421e+00,  5.567135568341e+00,  6.333678148268e+00]],
       [[ 1.719614477245e-01,  5.176611710993e-01,  8.576092044436e-01,  1.226315687941e+00,  1.649740638994e+00,  2.106547456789e+00,  2.611078592128e+00,  3.185721507004e+00,  3.820693614921e+00,  4.515894477912e+00,  5.308234780760e+00,  6.240199463320e+00,  7.333125126408e+00,  8.504224361960e+00,  9.659688883021e+00],
        [ 1.719614477245e-01,  5.176611710993e-01,  8.576092044436e-01,  1.226315687941e+00,  1.649740638994e+00,  2.106547456789e+00,  2.611078592128e+00,  3.185721507004e+00,  3.820693614921e+00,  4.515894477912e+00,  5.308234780760e+00,  6.240199463320e+00,  7.333125126408e+00,  8.504224361960e+00,  9.659688883021e+00],
        [ 1.719614477245e-01,  5.176611710993e-01,  8.576092044436e-01,  1.226315687941e+00,  1.649740638994e+00,  2.106547456789e+00,  2.611078592128e+00,  3.185721507004e+00,  3.820693614921e+00,  4.515894477912e+00,  5.308234780760e+00,  6.240199463320e+00,  7.333125126408e+00,  8.504224361960e+00,  9.659688883021e+00]],
       [[ 1.010485623302e-01,  4.344747141700e-01,  7.624971984645e-01,  1.117538020484e+00,  1.523986412398e+00,  1.961796805556e+00,  2.444443819682e+00,  2.992960299234e+00,  3.598155581142e+00,  4.259935304726e+00,  5.012976768027e+00,  5.897194237881e+00,  6.932633282940e+00,  8.041515784469e+00,  9.135709594706e+00],
        [ 1.010485623302e-01,  4.344747141700e-01,  7.624971984645e-01,  1.117538020484e+00,  1.523986412398e+00,  1.961796805556e+00,  2.444443819682e+00,  2.992960299234e+00,  3.598155581142e+00,  4.259935304726e+00,  5.012976768027e+00,  5.897194237881e+00,  6.932633282940e+00,  8.041515784469e+00,  9.135709594706e+00],
        [ 1.010485623302e-01,  4.344747141700e-01,  7.624971984645e-01,  1.117538020484e+00,  1.523986412398e+00,  1.961796805556e+00,  2.444443819682e+00,  2.992960299234e+00,  3.598155581142e+00,  4.259935304726e+00,  5.012976768027e+00,  5.897194237881e+00,  6.932633282940e+00,  8.041515784469e+00,  9.135709594706e+00]],
       [[-5.465583070529e-01, -3.252196720861e-01, -1.061064141316e-01,  1.241337288824e-01,  3.755449049643e-01,  6.398718046810e-01,  9.226636422884e-01,  1.232582314204e+00,  1.565842855837e+00,  1.922406406898e+00,  2.316554020255e+00,  2.764723474721e+00,  3.275170079727e+00,  3.815862694203e+00,  4.350506106781e+00],
        [-5.465583070529e-01, -3.252196720861e-01, -1.061064141316e-01,  1.241337288824e-01,  3.755449049643e-01,  6.398718046810e-01,  9.226636422884e-01,  1.232582314204e+00,  1.565842855837e+00,  1.922406406898e+00,  2.316554020255e+00,  2.764723474721e+00,  3.275170079727e+00,  3.815862694203e+00,  4.350506106781e+00],
        [-5.465583070529e-01, -3.252196720861e-01, -1.061064141316e-01,  1.241337288824e-01,  3.755449049643e-01,  6.398718046810e-01,  9.226636422884e-01,  1.232582314204e+00,  1.565842855837e+00,  1.922406406898e+00,  2.316554020255e+00,  2.764723474721e+00,  3.275170079727e+00,  3.815862694203e+00,  4.350506106781e+00]],
       [[-1.294346005393e+00, -1.202434141850e+00, -1.109077702644e+00, -1.022944141752e+00, -9.505534922623e-01, -8.865469232812e-01, -8.345266378556e-01, -8.001153977418e-01, -7.808562405025e-01, -7.767239404628e-01, -7.969888645345e-01, -8.523213913027e-01, -9.480803516663e-01, -1.063473130891e+00, -1.174939146350e+00],
        [-1.294346005393e+00, -1.202434141850e+00, -1.109077702644e+00, -1.022944141752e+00, -9.505534922623e-01, -8.865469232812e-01, -8.345266378556e-01, -8.001153977418e-01, -7.808562405025e-01, -7.767239404628e-01, -7.969888645345e-01, -8.523213913027e-01, -9.480803516663e-01, -1.063473130891e+00, -1.174939146350e+00],
        [-1.294346005393e+00, -1.202434141850e+00, -1.109077702644e+00, -1.022944141752e+00, -9.505534922623e-01, -8.865469232812e-01, -8.345266378556e-01, -8.001153977418e-01, -7.808562405025e-01, -7.767239404628e-01, -7.969888645345e-01, -8.523213913027e-01, -9.480803516663e-01, -1.063473130891e+00, -1.174939146350e+00]],
       [[-1.870040895082e+00, -1.877770054067e+00, -1.881229272644e+00, -1.906038193261e+00, -1.971469017084e+00, -2.061681875568e+00, -2.187324319244e+00, -2.365016355116e+00, -2.587495585324e+00, -2.854687446716e+00, -3.193993698360e+00, -3.636954315542e+00, -4.199409166808e+00, -4.819898525174e+00, -5.428780982121e+00],
        [-1.870040895082e+00, -1.877770054067e+00, -1.881229272644e+00, -1.906038193261e+00, -1.971469017084e+00, -2.061681875568e+00, -2.187324319244e+00, -2.365016355116e+00, -2.587495585324e+00, -2.854687446716e+00, -3.193993698360e+00, -3.636954315542e+00, -4.199409166808e+00, -4.819898525174e+00, -5.428780982121e+00],
        [-1.870040895082e+00, -1.877770054067e+00, -1.881229272644e+00, -1.906038193261e+00, -1.971469017084e+00, -2.061681875568e+00, -2.187324319244e+00, -2.365016355116e+00, -2.587495585324e+00, -2.854687446716e+00, -3.193993698360e+00, -3.636954315542e+00, -4.199409166808e+00, -4.819898525174e+00, -5.428780982121e+00]],
       [[-1.965888489212e+00, -1.990206908337e+00, -2.009784991330e+00, -2.053064754976e+00, -2.141441512267e+00, -2.257330403934e+00, -2.412551962270e+00, -2.625557128542e+00, -2.888283446680e+00, -3.200648139320e+00, -3.593071665797e+00, -4.100568586062e+00, -4.740723759382e+00, -5.445306780522e+00, -6.137004232098e+00],
        [-1.965888489212e+00, -1.990206908337e+00, -2.009784991330e+00, -2.053064754976e+00, -2.141441512267e+00, -2.257330403934e+00, -2.412551962270e+00, -2.625557128542e+00, -2.888283446680e+00, -3.200648139320e+00, -3.593071665797e+00, -4.100568586062e+00, -4.740723759382e+00, -5.445306780522e+00, -6.137004232098e+00],
        [-1.965888489212e+00, -1.990206908337e+00, -2.009784991330e+00, -2.053064754976e+00, -2.141441512267e+00, -2.257330403934e+00, -2.412551962270e+00, -2.625557128542e+00, -2.888283446680e+00, -3.200648139320e+00, -3.593071665797e+00, -4.100568586062e+00, -4.740723759382e+00, -5.445306780522e+00, -6.137004232098e+00]],
       [[-1.612525246579e+00, -1.575683708490e+00, -1.535836051595e+00, -1.511018988752e+00, -1.514800514111e+00, -1.536029060612e+00, -1.582200705228e+00, -1.665016247243e+00, -1.779362821197e+00, -1.925187933228e+00, -2.121782940006e+00, -2.391352580699e+00, -2.745048422372e+00, -3.139601654741e+00, -3.525983408963e+00],
        [-1.612525246579e+00, -1.575683708490e+00, -1.535836051595e+00, -1.511018988752e+00, -1.514800514111e+00, -1.536029060612e+00, -1.582200705228e+00, -1.665016247243e+00, -1.779362821197e+00, -1.925187933228e+00, -2.121782940006e+00, -2.391352580699e+00, -2.745048422372e+00, -3.139601654741e+00, -3.525983408963e+00],
        [-1.612525246579e+00, -1.575683708490e+00, -1.535836051595e+00, -1.511018988752e+00, -1.514800514111e+00, -1.536029060612e+00, -1.582200705228e+00, -1.665016247243e+00, -1.779362821197e+00, -1.925187933228e+00, -2.121782940006e+00, -2.391352580699e+00, -2.745048422372e+00, -3.139601654741e+00, -3.525983408963e+00]],
       [[-1.009179792245e+00, -8.679114838474e-01, -7.265981233700e-01, -5.855100233608e-01, -4.448505246189e-01, -3.044525008694e-01, -1.644282942934e-01, -2.495326241205e-02,  1.140492202562e-01,  2.525799404274e-01,  3.903497824369e-01,  5.270259683583e-01,  6.624413718507e-01,  7.972444539023e-01,  9.321700002365e-01],
        [-1.009179792245e+00, -8.679114838474e-01, -7.265981233700e-01, -5.855100233608e-01, -4.448505246189e-01, -3.044525008694e-01, -1.644282942934e-01, -2.495326241205e-02,  1.140492202562e-01,  2.525799404274e-01,  3.903497824369e-01,  5.270259683583e-01,  6.624413718507e-01,  7.972444539023e-01,  9.321700002365e-01],
        [-1.009179792245e+00, -8.679114838474e-01, -7.265981233700e-01, -5.855100233608e-01, -4.448505246189e-01, -3.044525008694e-01, -1.644282942934e-01, -2.495326241205e-02,  1.140492202562e-01,  2.525799404274e-01,  3.903497824369e-01,  5.270259683583e-01,  6.624413718507e-01,  7.972444539023e-01,  9.321700002365e-01]],
       [[-4.529870635670e-01, -2.154531582373e-01,  1.939614610546e-02,  2.676684553500e-01,  5.414806061054e-01,  8.308737411742e-01,  1.142542198643e+00,  1.486935325067e+00,  1.859487098776e+00,  2.260150640346e+00,  2.706154009747e+00,  3.217327050109e+00,  3.803628618625e+00,  4.426417697450e+00,  5.041909274238e+00],
        [-4.529870635670e-01, -2.154531582373e-01,  1.939614610546e-02,  2.676684553500e-01,  5.414806061054e-01,  8.308737411742e-01,  1.142542198643e+00,  1.486935325067e+00,  1.859487098776e+00,  2.260150640346e+00,  2.706154009747e+00,  3.217327050109e+00,  3.803628618625e+00,  4.426417697450e+00,  5.041909274238e+00],
        [-4.529870635670e-01, -2.154531582373e-01,  1.939614610546e-02,  2.676684553500e-01,  5.414806061054e-01,  8.308737411742e-01,  1.142542198643e+00,  1.486935325067e+00,  1.859487098776e+00,  2.260150640346e+00,  2.706154009747e+00,  3.217327050109e+00,  3.803628618625e+00,  4.426417697450e+00,  5.041909274238e+00]],
       [[-2.644088408301e-01,  5.764101716068e-03,  2.723269491416e-01,  5.569402722920e-01,  8.758980877913e-01,  1.215808304160e+00,  1.585673077593e+00,  1.999544081164e+00,  2.451281194685e+00,  2.940821377446e+00,  3.491331921761e+00,  4.129478846519e+00,  4.868654243258e+00,  5.656895920171e+00,  6.435324341043e+00],
        [-2.644088408301e-01,  5.764101716068e-03,  2.723269491416e-01,  5.569402722920e-01,  8.758980877913e-01,  1.215808304160e+00,  1.585673077593e+00,  1.999544081164e+00,  2.451281194685e+00,  2.940821377446e+00,  3.491331921761e+00,  4.129478846519e+00,  4.868654243258e+00,  5.656895920171e+00,  6.435324341043e+00],
        [-2.644088408301e-01,  5.764101716068e-03,  2.723269491416e-01,  5.569402722920e-01,  8.758980877913e-01,  1.215808304160e+00,  1.585673077593e+00,  1.999544081164e+00,  2.451281194685e+00,  2.940821377446e+00,  3.491331921761e+00,  4.129478846519e+00,  4.868654243258e+00,  5.656895920171e+00,  6.435324341043e+00]],
       [[-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00],
        [-9.873127313836e+00, -9.873127313836e+00, -9.873127313836e+00]],
       [[-6.114637532830e+00, -6.114637532830e+00, -6.114637532830e+00],
        [-6.114637532830e+00, -6.114637532830e+00, -6.114637532830e+00],
        [-6.114637532830e+00, -6.114637532830e+00, -6.114637532830e+00]],
       [[-6.635628430952e-01, -6.635628430952e-01, -6.635628430952e-01],
        [-6.635628430952e-01, -6.635628430952e-01, -6.635628430952e-01],
        [-6.635628430952e-01, -6.635628430952e-01, -6.635628430952e-01]],
       [[ 6.333678148268e+00,  6.333678148268e+00,  6.333678148268e+00],
        [ 6.333678148268e+00,  6.333678148268e+00,  6.333678148268e+00],
        [ 6.333678148268e+00,  6.333678148268e+00,  6.333678148268e+00]],
       [[ 9.659688883021e+00,  9.659688883021e+00,  9.659688883021e+00],
        [ 9.659688883021e+00,  9.659688883021e+00,  9.659688883021e+00],
        [ 9.659688883021e+00,  9.659688883021e+00,  9.659688883021e+00]],
       [[ 9.135709594706e+00,  9.135709594706e+00,  9.135709594706e+00],
        [ 9.135709594706e+00,  9.135709594706e+00,  9.135709594706e+00],
        [ 9.135709594706e+00,  9.135709594706e+00,  9.135709594706e+00]],
       [[ 4.350506106781e+00,  4.350506106781e+00,  4.350506106781e+00],
        [ 4.350506106781e+00,  4.350506106781e+00,  4.350506106781e+00],
        [ 4.350506106781e+00,  4.350506106781e+00,  4.350506106781e+00]],
       [[-1.174939146350e+00, -1.174939146350e+00, -1.174939146350e+00],
        [-1.174939146350e+00, -1.174939146350e+00, -1.174939146350e+00],
        [-1.174939146350e+00, -1.174939146350e+00, -1.174939146350e+00]],
       [[-5.428780982121e+00, -5.428780982121e+00, -5.428780982121e+00],
        [-5.428780982121e+00, -5.428780982121e+00, -5.428780982121e+00],
        [-5.428780982121e+00, -5.428780982121e+00, -5.428780982121e+00]],
       [[-6.137004232098e+00, -6.137004232098e+00, -6.137004232098e+00],
        [-6.137004232098e+00, -6.137004232098e+00, -6.137004232098e+00],
        [-6.137004232098e+00, -6.137004232098e+00, -6.137004232098e+00]],
       [[-3.525983408963e+00, -3.525983408963e+00, -3.525983408963e+00],
        [-3.525983408963e+00, -3.525983408963e+00, -3.525983408963e+00],
        [-3.525983408963e+00, -3.525983408963e+00, -3.525983408963e+00]],
       [[ 9.321700002365e-01,  9.321700002365e-01,  9.321700002365e-01],
        [ 9.321700002365e-01,  9.321700002365e-01,  9.321700002365e-01],
        [ 9.321700002365e-01,  9.321700002365e-01,  9.321700002365e-01]],
       [[ 5.041909274238e+00,  5.041909274238e+00,  5.041909274238e+00],
        [ 5.041909274238e+00,  5.041909274238e+00,  5.041909274238e+00],
        [ 5.041909274238e+00,  5.041909274238e+00,  5.041909274238e+00]],
       [[ 6.435324341043e+00,  6.435324341043e+00,  6.435324341043e+00],
        [ 6.435324341043e+00,  6.435324341043e+00,  6.435324341043e+00],
        [ 6.435324341043e+00,  6.435324341043e+00,  6.435324341043e+00]],
       [[ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x sup
            [  # y inf
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.042765972136e+00, -1.042765972136e+00, -1.042765972136e+00],
        [-1.075369733071e+00, -1.075369733071e+00, -1.075369733071e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.030486633602e+00, -1.030486633602e+00, -1.030486633602e+00],
        [-9.618917079975e-01, -9.618917079975e-01, -9.618917079975e-01],
        [-8.628101487912e-01, -8.628101487912e-01, -8.628101487912e-01],
        [-7.323951050630e-01, -7.323951050630e-01, -7.323951050630e-01],
        [-5.626014929039e-01, -5.626014929039e-01, -5.626014929039e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.042765972136e+00, -1.042765972136e+00, -1.042765972136e+00],
        [-1.075369733071e+00, -1.075369733071e+00, -1.075369733071e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.030486633602e+00, -1.030486633602e+00, -1.030486633602e+00],
        [-9.618917079975e-01, -9.618917079975e-01, -9.618917079975e-01],
        [-8.628101487912e-01, -8.628101487912e-01, -8.628101487912e-01],
        [-7.323951050630e-01, -7.323951050630e-01, -7.323951050630e-01],
        [-5.626014929039e-01, -5.626014929039e-01, -5.626014929039e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]],
       [[-1.000000000000e+00, -1.000000000000e+00, -1.000000000000e+00],
        [-1.042765972136e+00, -1.042765972136e+00, -1.042765972136e+00],
        [-1.075369733071e+00, -1.075369733071e+00, -1.075369733071e+00],
        [-1.068594925604e+00, -1.068594925604e+00, -1.068594925604e+00],
        [-1.030486633602e+00, -1.030486633602e+00, -1.030486633602e+00],
        [-9.618917079975e-01, -9.618917079975e-01, -9.618917079975e-01],
        [-8.628101487912e-01, -8.628101487912e-01, -8.628101487912e-01],
        [-7.323951050630e-01, -7.323951050630e-01, -7.323951050630e-01],
        [-5.626014929039e-01, -5.626014929039e-01, -5.626014929039e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.042765972136e+00, -9.073107452406e-01, -7.716456337828e-01, -6.370299451369e-01, -5.044109846798e-01, -3.730101598411e-01, -2.433508400991e-01, -1.162499649338e-01,  8.649441408794e-03,  1.313510440043e-01,  2.505079373550e-01,  3.645698061689e-01,  4.727580578757e-01,  5.780936826226e-01,  6.839998327615e-01],
        [-1.075369733071e+00, -9.455575510181e-01, -8.153754733993e-01, -6.870428736075e-01, -5.622292601287e-01, -4.395624599179e-01, -3.199648469073e-01, -2.048761758238e-01, -9.366732108156e-02,  1.366817656199e-02,  1.147565628632e-01,  2.068655989907e-01,  2.886231118998e-01,  3.653532228400e-01,  4.430888141738e-01],
        [-1.068594925604e+00, -9.376101628046e-01, -8.062887534791e-01, -6.766505767825e-01, -5.502150730224e-01, -4.257334105513e-01, -3.040450532847e-01, -1.864603397948e-01, -7.240669510961e-02,  3.812175940691e-02,  1.429646406795e-01,  2.396353043783e-01,  3.268849188561e-01,  4.095590326647e-01,  4.931482466074e-01],
        [-1.030486633602e+00, -8.929061041034e-01, -7.551759539272e-01, -6.181939071414e-01, -4.826352705496e-01, -3.479450078640e-01, -2.144962141582e-01, -8.287126213094e-02,  4.718432598317e-02,  1.756731629112e-01,  3.016350783973e-01,  4.239648971846e-01,  5.421075829838e-01,  6.582167129308e-01,  7.747325540477e-01],
        [-9.618917079975e-01, -8.124387984416e-01, -6.631729147336e-01, -5.129719017871e-01, -3.609916260987e-01, -2.079258830271e-01, -5.330830373070e-02,  1.035890776637e-01,  2.624481639497e-01,  4.232656892181e-01,  5.872418662889e-01,  7.557581642338e-01,  9.295083784134e-01,  1.105800537408e+00,  1.281584307441e+00],
        [-8.628101487912e-01, -6.962082458196e-01, -5.302796358994e-01, -3.609845607205e-01, -1.852841396693e-01, -5.676036040391e-03,  1.795186779985e-01,  3.729206795895e-01,  5.733848187905e-01,  7.808993383286e-01,  9.997850043549e-01,  1.235015105528e+00,  1.489087305146e+00,  1.752310506099e+00,  2.013703506784e+00],
        [-7.323951050630e-01, -5.432210227156e-01, -3.553602774474e-01, -1.609328468541e-01,  4.598896212542e-02,  2.605331642651e-01,  4.859747052301e-01,  7.274255231455e-01,  9.826518687528e-01,  1.251630808091e+00,  1.542790502317e+00,  1.865831934233e+00,  2.225627089057e+00,  2.603272345222e+00,  2.977347581139e+00],
        [-5.626014929039e-01, -3.440396055983e-01, -1.276243594389e-01,  9.952409234143e-02,  3.470945264815e-01,  6.071237140121e-01,  8.849645328924e-01,  1.188972413622e+00,  1.515496307179e+00,  1.864498728169e+00,  2.249755452607e+00,  2.687122675530e+00,  3.184563625908e+00,  3.711180453978e+00,  4.231962106516e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.042765972136e+00, -9.073107452406e-01, -7.716456337828e-01, -6.370299451369e-01, -5.044109846798e-01, -3.730101598411e-01, -2.433508400991e-01, -1.162499649338e-01,  8.649441408794e-03,  1.313510440043e-01,  2.505079373550e-01,  3.645698061689e-01,  4.727580578757e-01,  5.780936826226e-01,  6.839998327615e-01],
        [-1.075369733071e+00, -9.455575510181e-01, -8.153754733993e-01, -6.870428736075e-01, -5.622292601287e-01, -4.395624599179e-01, -3.199648469073e-01, -2.048761758238e-01, -9.366732108156e-02,  1.366817656199e-02,  1.147565628632e-01,  2.068655989907e-01,  2.886231118998e-01,  3.653532228400e-01,  4.430888141738e-01],
        [-1.068594925604e+00, -9.376101628046e-01, -8.062887534791e-01, -6.766505767825e-01, -5.502150730224e-01, -4.257334105513e-01, -3.040450532847e-01, -1.864603397948e-01, -7.240669510961e-02,  3.812175940691e-02,  1.429646406795e-01,  2.396353043783e-01,  3.268849188561e-01,  4.095590326647e-01,  4.931482466074e-01],
        [-1.030486633602e+00, -8.929061041034e-01, -7.551759539272e-01, -6.181939071414e-01, -4.826352705496e-01, -3.479450078640e-01, -2.144962141582e-01, -8.287126213094e-02,  4.718432598317e-02,  1.756731629112e-01,  3.016350783973e-01,  4.239648971846e-01,  5.421075829838e-01,  6.582167129308e-01,  7.747325540477e-01],
        [-9.618917079975e-01, -8.124387984416e-01, -6.631729147336e-01, -5.129719017871e-01, -3.609916260987e-01, -2.079258830271e-01, -5.330830373070e-02,  1.035890776637e-01,  2.624481639497e-01,  4.232656892181e-01,  5.872418662889e-01,  7.557581642338e-01,  9.295083784134e-01,  1.105800537408e+00,  1.281584307441e+00],
        [-8.628101487912e-01, -6.962082458196e-01, -5.302796358994e-01, -3.609845607205e-01, -1.852841396693e-01, -5.676036040391e-03,  1.795186779985e-01,  3.729206795895e-01,  5.733848187905e-01,  7.808993383286e-01,  9.997850043549e-01,  1.235015105528e+00,  1.489087305146e+00,  1.752310506099e+00,  2.013703506784e+00],
        [-7.323951050630e-01, -5.432210227156e-01, -3.553602774474e-01, -1.609328468541e-01,  4.598896212542e-02,  2.605331642651e-01,  4.859747052301e-01,  7.274255231455e-01,  9.826518687528e-01,  1.251630808091e+00,  1.542790502317e+00,  1.865831934233e+00,  2.225627089057e+00,  2.603272345222e+00,  2.977347581139e+00],
        [-5.626014929039e-01, -3.440396055983e-01, -1.276243594389e-01,  9.952409234143e-02,  3.470945264815e-01,  6.071237140121e-01,  8.849645328924e-01,  1.188972413622e+00,  1.515496307179e+00,  1.864498728169e+00,  2.249755452607e+00,  2.687122675530e+00,  3.184563625908e+00,  3.711180453978e+00,  4.231962106516e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.258542641408e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.042765972136e+00, -9.073107452406e-01, -7.716456337828e-01, -6.370299451369e-01, -5.044109846798e-01, -3.730101598411e-01, -2.433508400991e-01, -1.162499649338e-01,  8.649441408794e-03,  1.313510440043e-01,  2.505079373550e-01,  3.645698061689e-01,  4.727580578757e-01,  5.780936826226e-01,  6.839998327615e-01],
        [-1.075369733071e+00, -9.455575510181e-01, -8.153754733993e-01, -6.870428736075e-01, -5.622292601287e-01, -4.395624599179e-01, -3.199648469073e-01, -2.048761758238e-01, -9.366732108156e-02,  1.366817656199e-02,  1.147565628632e-01,  2.068655989907e-01,  2.886231118998e-01,  3.653532228400e-01,  4.430888141738e-01],
        [-1.068594925604e+00, -9.376101628046e-01, -8.062887534791e-01, -6.766505767825e-01, -5.502150730224e-01, -4.257334105513e-01, -3.040450532847e-01, -1.864603397948e-01, -7.240669510961e-02,  3.812175940691e-02,  1.429646406795e-01,  2.396353043783e-01,  3.268849188561e-01,  4.095590326647e-01,  4.931482466074e-01],
        [-1.030486633602e+00, -8.929061041034e-01, -7.551759539272e-01, -6.181939071414e-01, -4.826352705496e-01, -3.479450078640e-01, -2.144962141582e-01, -8.287126213094e-02,  4.718432598317e-02,  1.756731629112e-01,  3.016350783973e-01,  4.239648971846e-01,  5.421075829838e-01,  6.582167129308e-01,  7.747325540477e-01],
        [-9.618917079975e-01, -8.124387984416e-01, -6.631729147336e-01, -5.129719017871e-01, -3.609916260987e-01, -2.079258830271e-01, -5.330830373070e-02,  1.035890776637e-01,  2.624481639497e-01,  4.232656892181e-01,  5.872418662889e-01,  7.557581642338e-01,  9.295083784134e-01,  1.105800537408e+00,  1.281584307441e+00],
        [-8.628101487912e-01, -6.962082458196e-01, -5.302796358994e-01, -3.609845607205e-01, -1.852841396693e-01, -5.676036040391e-03,  1.795186779985e-01,  3.729206795895e-01,  5.733848187905e-01,  7.808993383286e-01,  9.997850043549e-01,  1.235015105528e+00,  1.489087305146e+00,  1.752310506099e+00,  2.013703506784e+00],
        [-7.323951050630e-01, -5.432210227156e-01, -3.553602774474e-01, -1.609328468541e-01,  4.598896212542e-02,  2.605331642651e-01,  4.859747052301e-01,  7.274255231455e-01,  9.826518687528e-01,  1.251630808091e+00,  1.542790502317e+00,  1.865831934233e+00,  2.225627089057e+00,  2.603272345222e+00,  2.977347581139e+00],
        [-5.626014929039e-01, -3.440396055983e-01, -1.276243594389e-01,  9.952409234143e-02,  3.470945264815e-01,  6.071237140121e-01,  8.849645328924e-01,  1.188972413622e+00,  1.515496307179e+00,  1.864498728169e+00,  2.249755452607e+00,  2.687122675530e+00,  3.184563625908e+00,  3.711180453978e+00,  4.231962106516e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.839998327615e-01,  6.839998327615e-01,  6.839998327615e-01],
        [ 4.430888141738e-01,  4.430888141738e-01,  4.430888141738e-01],
        [ 4.931482466074e-01,  4.931482466074e-01,  4.931482466074e-01],
        [ 7.747325540477e-01,  7.747325540477e-01,  7.747325540477e-01],
        [ 1.281584307441e+00,  1.281584307441e+00,  1.281584307441e+00],
        [ 2.013703506784e+00,  2.013703506784e+00,  2.013703506784e+00],
        [ 2.977347581139e+00,  2.977347581139e+00,  2.977347581139e+00],
        [ 4.231962106516e+00,  4.231962106516e+00,  4.231962106516e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.839998327615e-01,  6.839998327615e-01,  6.839998327615e-01],
        [ 4.430888141738e-01,  4.430888141738e-01,  4.430888141738e-01],
        [ 4.931482466074e-01,  4.931482466074e-01,  4.931482466074e-01],
        [ 7.747325540477e-01,  7.747325540477e-01,  7.747325540477e-01],
        [ 1.281584307441e+00,  1.281584307441e+00,  1.281584307441e+00],
        [ 2.013703506784e+00,  2.013703506784e+00,  2.013703506784e+00],
        [ 2.977347581139e+00,  2.977347581139e+00,  2.977347581139e+00],
        [ 4.231962106516e+00,  4.231962106516e+00,  4.231962106516e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]],
       [[ 1.000000000000e+00,  1.000000000000e+00,  1.000000000000e+00],
        [ 6.839998327615e-01,  6.839998327615e-01,  6.839998327615e-01],
        [ 4.430888141738e-01,  4.430888141738e-01,  4.430888141738e-01],
        [ 4.931482466074e-01,  4.931482466074e-01,  4.931482466074e-01],
        [ 7.747325540477e-01,  7.747325540477e-01,  7.747325540477e-01],
        [ 1.281584307441e+00,  1.281584307441e+00,  1.281584307441e+00],
        [ 2.013703506784e+00,  2.013703506784e+00,  2.013703506784e+00],
        [ 2.977347581139e+00,  2.977347581139e+00,  2.977347581139e+00],
        [ 4.231962106516e+00,  4.231962106516e+00,  4.231962106516e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]],
       [[-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]],
       [[-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01],
        [-3.826456695679e-01, -3.826456695679e-01, -3.826456695679e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]],
       [[-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]],
       [[-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00],
        [-3.826456695679e-01, -1.329371061788e-01,  1.137416384640e-01,  3.755694767668e-01,  6.662213714908e-01,  9.744578378211e-01,  1.307834050998e+00,  1.678143058150e+00,  2.080231684559e+00,  2.514047022467e+00,  2.999032519598e+00,  3.557567974878e+00,  4.200892873156e+00,  4.885397277447e+00,  5.561665780513e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]],
       [[ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]],
       [[ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00],
        [ 5.561665780513e+00,  5.561665780513e+00,  5.561665780513e+00]]
                ], dtype=np.float64)
            ]
        ]
                               ]

# Linearly extrapolated data sampled on self.xsamples_ex,
# self.ysamples_ex and self.zsamples_ex
# Calculated at (x, y, z) from the formula:
# Pijk(xn, yn, zn) + (x-xn)*dPijk/dx(xn, yn, zn)
#                  + (y-yn)*dPijk/dy(xn, yn, zn)
#                  + (z-zn)*dPijk/dz(xn, yn, zn)
# where (xn, yn, zn) is the nearest coordinates in the
# interpolated range form (x, y, z), and Pijk the nearest interpolation
# polynomial.
# NB: this extrapolation is not entirely trilinear as some higher
# level derivatives are not taken into account.
cubic_linear_extrapolated_data = [
        [  # x inf
            [  # y inf
                np.array([  # z inf
       [[-1.130569644706e+00, -1.070569644706e+00, -1.010569644706e+00],
        [-1.141606027941e+00, -1.081606027941e+00, -1.021606027941e+00],
        [-1.152642411177e+00, -1.092642411177e+00, -1.032642411177e+00]],
       [[-1.130569644706e+00, -1.070569644706e+00, -1.010569644706e+00],
        [-1.141606027941e+00, -1.081606027941e+00, -1.021606027941e+00],
        [-1.152642411177e+00, -1.092642411177e+00, -1.032642411177e+00]],
       [[-1.130569644706e+00, -1.070569644706e+00, -1.010569644706e+00],
        [-1.141606027941e+00, -1.081606027941e+00, -1.021606027941e+00],
        [-1.152642411177e+00, -1.092642411177e+00, -1.032642411177e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.705696447063e-01, -8.226187086831e-01, -6.748122093915e-01, -5.262835264416e-01, -3.763807505603e-01, -2.256396875488e-01, -7.370016905561e-02,  8.000000000000e-02,  2.352151588100e-01,  3.919427851709e-01,  5.511097820706e-01,  7.137830334725e-01,  8.804983451781e-01,  1.049176755599e+00,  1.217462546277e+00],
        [-9.816060279414e-01, -8.355652643555e-01, -6.896147737268e-01, -5.432129183117e-01, -3.959522548145e-01, -2.481676618609e-01, -9.963403423119e-02,  5.000000000000e-02,  2.005809028277e-01,  3.521070978747e-01,  5.051578995084e-01,  6.604001102060e-01,  8.181686085935e-01,  9.771640436779e-01,  1.135914091423e+00],
        [-9.926424111766e-01, -8.485118200279e-01, -7.044173380622e-01, -5.601423101818e-01, -4.155237590686e-01, -2.706956361729e-01, -1.255678994068e-01,  2.000000000000e-02,  1.659466468453e-01,  3.122714105784e-01,  4.592060169462e-01,  6.070171869395e-01,  7.558388720088e-01,  9.051513317569e-01,  1.054365636569e+00]],
       [[-9.705696447063e-01, -8.226187086831e-01, -6.748122093915e-01, -5.262835264416e-01, -3.763807505603e-01, -2.256396875488e-01, -7.370016905561e-02,  8.000000000000e-02,  2.352151588100e-01,  3.919427851709e-01,  5.511097820706e-01,  7.137830334725e-01,  8.804983451781e-01,  1.049176755599e+00,  1.217462546277e+00],
        [-9.816060279414e-01, -8.355652643555e-01, -6.896147737268e-01, -5.432129183117e-01, -3.959522548145e-01, -2.481676618609e-01, -9.963403423119e-02,  5.000000000000e-02,  2.005809028277e-01,  3.521070978747e-01,  5.051578995084e-01,  6.604001102060e-01,  8.181686085935e-01,  9.771640436779e-01,  1.135914091423e+00],
        [-9.926424111766e-01, -8.485118200279e-01, -7.044173380622e-01, -5.601423101818e-01, -4.155237590686e-01, -2.706956361729e-01, -1.255678994068e-01,  2.000000000000e-02,  1.659466468453e-01,  3.122714105784e-01,  4.592060169462e-01,  6.070171869395e-01,  7.558388720088e-01,  9.051513317569e-01,  1.054365636569e+00]],
       [[-9.705696447063e-01, -8.226187086831e-01, -6.748122093915e-01, -5.262835264416e-01, -3.763807505603e-01, -2.256396875488e-01, -7.370016905561e-02,  8.000000000000e-02,  2.352151588100e-01,  3.919427851709e-01,  5.511097820706e-01,  7.137830334725e-01,  8.804983451781e-01,  1.049176755599e+00,  1.217462546277e+00],
        [-9.816060279414e-01, -8.355652643555e-01, -6.896147737268e-01, -5.432129183117e-01, -3.959522548145e-01, -2.481676618609e-01, -9.963403423119e-02,  5.000000000000e-02,  2.005809028277e-01,  3.521070978747e-01,  5.051578995084e-01,  6.604001102060e-01,  8.181686085935e-01,  9.771640436779e-01,  1.135914091423e+00],
        [-9.926424111766e-01, -8.485118200279e-01, -7.044173380622e-01, -5.601423101818e-01, -4.155237590686e-01, -2.706956361729e-01, -1.255678994068e-01,  2.000000000000e-02,  1.659466468453e-01,  3.122714105784e-01,  4.592060169462e-01,  6.070171869395e-01,  7.558388720088e-01,  9.051513317569e-01,  1.054365636569e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.257462546277e+00,  1.317462546277e+00,  1.377462546277e+00],
        [ 1.175914091423e+00,  1.235914091423e+00,  1.295914091423e+00],
        [ 1.094365636569e+00,  1.154365636569e+00,  1.214365636569e+00]],
       [[ 1.257462546277e+00,  1.317462546277e+00,  1.377462546277e+00],
        [ 1.175914091423e+00,  1.235914091423e+00,  1.295914091423e+00],
        [ 1.094365636569e+00,  1.154365636569e+00,  1.214365636569e+00]],
       [[ 1.257462546277e+00,  1.317462546277e+00,  1.377462546277e+00],
        [ 1.175914091423e+00,  1.235914091423e+00,  1.295914091423e+00],
        [ 1.094365636569e+00,  1.154365636569e+00,  1.214365636569e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.199624532173e+00, -1.142020865396e+00, -1.084417198619e+00],
        [-1.253697426849e+00, -1.199432912924e+00, -1.145168398999e+00],
        [-1.363757726224e+00, -1.316485791213e+00, -1.269213856201e+00],
        [-1.518367143316e+00, -1.480994814407e+00, -1.443622485499e+00],
        [-1.716321647917e+00, -1.691677383998e+00, -1.667033120078e+00],
        [-1.957621240028e+00, -1.948533499983e+00, -1.939445759939e+00],
        [-2.243469949855e+00, -2.252845760875e+00, -2.262221571894e+00],
        [-2.585306064382e+00, -2.616798852527e+00, -2.648291640672e+00],
        [-2.941590541412e+00, -2.996143126311e+00, -3.050695711211e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.193912541520e+00, -1.136308874744e+00, -1.078705207967e+00],
        [-1.240454211472e+00, -1.186189697548e+00, -1.131925183623e+00],
        [-1.335933754096e+00, -1.288661819085e+00, -1.241389884074e+00],
        [-1.470353109384e+00, -1.432980780475e+00, -1.395608451567e+00],
        [-1.642659849966e+00, -1.618015586046e+00, -1.593371322126e+00],
        [-1.852853975843e+00, -1.843766235798e+00, -1.834678495754e+00],
        [-2.101987914383e+00, -2.111363725403e+00, -2.120739536422e+00],
        [-2.400059725596e+00, -2.431552513741e+00, -2.463045301886e+00],
        [-2.710760665240e+00, -2.765313250139e+00, -2.819865835039e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.188200550868e+00, -1.130596884091e+00, -1.072993217314e+00],
        [-1.227210996096e+00, -1.172946482171e+00, -1.118681968246e+00],
        [-1.308109781969e+00, -1.260837846958e+00, -1.213565911946e+00],
        [-1.422339075452e+00, -1.384966746543e+00, -1.347594417634e+00],
        [-1.568998052015e+00, -1.544353788095e+00, -1.519709524175e+00],
        [-1.748086711658e+00, -1.738998971613e+00, -1.729911231569e+00],
        [-1.960505878911e+00, -1.969881689931e+00, -1.979257500950e+00],
        [-2.214813386809e+00, -2.246306174955e+00, -2.277798963100e+00],
        [-2.479930789068e+00, -2.534483373967e+00, -2.589035958867e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.046014754101e+00, -9.111218249836e-01, -7.760030671041e-01, -6.420134530327e-01, -5.101722516368e-01, -3.796417233799e-01, -2.509849962970e-01, -1.250810699151e-01, -1.545850275522e-03,  1.196246061204e-01,  2.369810740551e-01,  3.488554661831e-01,  4.544100429679e-01,  5.568952886572e-01,  6.599944005656e-01],
        [-1.108992056383e+00, -9.849992115070e-01, -8.604714612167e-01, -7.386182379994e-01, -6.218538155381e-01, -5.081938964792e-01, -3.989723243632e-01, -2.962711263116e-01, -1.991805247710e-01, -1.076911790409e-01, -2.523577152310e-02,  4.423461136311e-02,  9.873567226421e-02,  1.459666148228e-01,  1.946515810500e-01],
        [-1.237699232861e+00, -1.135982970426e+00, -1.033100140345e+00, -9.360501484962e-01, -8.500982501787e-01, -7.709169193838e-01, -7.014151166068e-01, -6.461335053239e-01, -6.030879645472e-01, -5.722581232759e-01, -5.611302699662e-01, -5.783212730580e-01, -6.281586585596e-01, -6.938513422376e-01, -7.563729662804e-01],
        [-1.418707599560e+00, -1.348320186950e+00, -1.275877863463e+00, -1.213710094361e+00, -1.171091635730e+00, -1.140399543209e+00, -1.126757955615e+00, -1.138165259321e+00, -1.171126421859e+00, -1.225605559677e+00, -1.314789782517e+00, -1.453857718667e+00, -1.650432312490e+00, -1.874936040790e+00, -2.093853942194e+00],
        [-1.650603610798e+00, -1.620352659522e+00, -1.586908710465e+00, -1.569429750314e+00, -1.582327243789e+00, -1.613756373334e+00, -1.671679218503e+00, -1.768523972762e+00, -1.898859923259e+00, -2.062631312781e+00, -2.280328768253e+00, -2.575537413000e+00, -2.960102064577e+00, -3.388064055388e+00, -3.807346578352e+00],
        [-1.933387266575e+00, -1.952080388142e+00, -1.966192681350e+00, -2.003209116354e+00, -2.083805074356e+00, -2.190987409761e+00, -2.336178905270e+00, -2.537209645647e+00, -2.786288468747e+00, -3.083335382586e+00, -3.457747227175e+00, -3.943360356056e+00, -4.557167914823e+00, -5.233235386032e+00, -5.896850874754e+00],
        [-2.268472112574e+00, -2.345161574367e+00, -2.415625696225e+00, -2.517216517762e+00, -2.678031855834e+00, -2.874978047108e+00, -3.123578638801e+00, -3.448064693517e+00, -3.837848031770e+00, -4.292819944558e+00, -4.852930700205e+00, -5.564163860299e+00, -6.449613088174e+00, -7.419673458168e+00, -8.372811599739e+00],
        [-2.669286832769e+00, -2.815349132988e+00, -2.953218996116e+00, -3.132051044701e+00, -3.388821508051e+00, -3.693139534260e+00, -4.065433836511e+00, -4.537592064003e+00, -5.095680360075e+00, -5.739555665603e+00, -6.521791826099e+00, -7.502902394145e+00, -8.713278221646e+00, -1.003500081353e+01, -1.133445405254e+01],
        [-3.087064101144e+00, -3.305435110292e+00, -3.513563337301e+00, -3.772905475002e+00, -4.129691901104e+00, -4.545925756846e+00, -5.047148508846e+00, -5.673228420970e+00, -6.406744369742e+00, -7.247517492216e+00, -8.261279443055e+00, -9.523688677564e+00, -1.107274205450e+01, -1.276100927424e+01, -1.442143372542e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.040302763449e+00, -9.044212054593e-01, -7.683418517117e-01, -6.332514767534e-01, -5.000428236372e-01, -3.679821446983e-01, -2.375626646951e-01, -1.095542695200e-01,  1.637945570683e-02,  1.402419649621e-01,  2.607639309992e-01,  3.764843326519e-01,  4.866694222555e-01,  5.941661887875e-01,  7.022006199337e-01],
        [-1.095748841006e+00, -9.694638661406e-01, -8.427089802081e-01, -7.183036496100e-01, -5.983687987025e-01, -4.811612346502e-01, -3.678527306749e-01, -2.602723346032e-01, -1.576208125349e-01, -5.988995872294e-02,  2.990463677576e-02,  1.082919692117e-01,  1.735288457493e-01,  2.323789687163e-01,  2.925064423975e-01],
        [-1.209875260733e+00, -1.103343237236e+00, -9.957811991022e-01, -8.933692341520e-01, -8.007562712659e-01, -7.141213446024e-01, -6.360329052039e-01, -5.705001074941e-01, -5.157710825056e-01, -4.718278437726e-01, -4.452803694711e-01, -4.437368773003e-01, -4.710183331018e-01, -5.122991392535e-01, -5.507800753351e-01],
        [-1.370693565627e+00, -1.291995904790e+00, -1.211478973797e+00, -1.140058393583e+00, -1.085945365494e+00, -1.042391083372e+00, -1.013932090837e+00, -1.007649583372e+00, -1.020449310841e+00, -1.052299504532e+00, -1.114875082059e+00, -1.221614108192e+00, -1.379265389088e+00, -1.561643115014e+00, -1.739075551933e+00],
        [-1.576941812847e+00, -1.533941509439e+00, -1.488109721702e+00, -1.456435355610e+00, -1.451698199721e+00, -1.463394515045e+00, -1.498584908895e+00, -1.568290445939e+00, -1.667695282451e+00, -1.796749974089e+00, -1.973625184601e+00, -2.219235713075e+00, -2.544085298502e+00, -2.907418745921e+00, -3.263055420942e+00],
        [-1.828620002391e+00, -1.829180051182e+00, -1.825673442819e+00, -1.842500120231e+00, -1.898014773947e+00, -1.977131639622e+00, -2.089991359378e+00, -2.252422695196e+00, -2.457508997336e+00, -2.705179252446e+00, -3.021530677096e+00, -3.436601691948e+00, -3.965478061344e+00, -4.549626031976e+00, -5.122719682360e+00],
        [-2.126990077102e+00, -2.179191889385e+00, -2.225862719736e+00, -2.300188459742e+00, -2.427132969837e+00, -2.586178393016e+00, -2.791116820965e+00, -3.063476647440e+00, -3.393850670585e+00, -3.782142306511e+00, -4.263845875933e+00, -4.879816055202e+00, -5.650570701321e+00, -6.496499185821e+00, -7.327392902645e+00],
        [-2.484040493983e+00, -2.598040438001e+00, -2.704757087051e+00, -2.847890210939e+00, -3.060312663225e+00, -3.315006166411e+00, -3.630132391101e+00, -4.034040307491e+00, -4.514342345563e+00, -5.070911321941e+00, -5.750486786793e+00, -6.606866901527e+00, -7.667069943643e+00, -8.826263227565e+00, -9.965658463125e+00],
        [-2.856234224972e+00, -3.034653298982e+00, -3.203962445437e+00, -3.418821229667e+00, -3.720346936613e+00, -4.074745170774e+00, -4.504732505379e+00, -5.045767763106e+00, -5.682356601633e+00, -6.414339940305e+00, -7.300179494304e+00, -8.407165872515e+00, -9.769093470440e+00, -1.125483782102e+01, -1.271581882108e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  0.000000000000e+00,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034590772796e+00, -8.977205859349e-01, -7.606806363194e-01, -6.244895004742e-01, -4.899133956377e-01, -3.563225660167e-01, -2.241403330933e-01, -9.402746912486e-02,  3.430476168918e-02,  1.608593238038e-01,  2.845467879433e-01,  4.041131991208e-01,  5.189288015432e-01,  6.314370889178e-01,  7.444068393019e-01],
        [-1.082505625630e+00, -9.539285207742e-01, -8.249464991995e-01, -6.979890612206e-01, -5.748837818670e-01, -4.541285728211e-01, -3.367331369865e-01, -2.242735428948e-01, -1.160611002987e-01, -1.208873840495e-02,  8.504504507463e-02,  1.723493270602e-01,  2.483220192344e-01,  3.187913226098e-01,  3.903613037450e-01],
        [-1.182051288606e+00, -1.070703504046e+00, -9.584622578597e-01, -8.506883198077e-01, -7.514142923531e-01, -6.573257698210e-01, -5.706506938009e-01, -4.948667096643e-01, -4.284542004640e-01, -3.713975642693e-01, -3.294304689760e-01, -3.091524815427e-01, -3.138780076441e-01, -3.307469362693e-01, -3.451871843898e-01],
        [-1.322679531695e+00, -1.235671622630e+00, -1.147080084130e+00, -1.066406692806e+00, -1.000799095259e+00, -9.443826235356e-01, -9.011062260580e-01, -8.771339074227e-01, -8.697721998242e-01, -8.789934493865e-01, -9.149603816016e-01, -9.893704977169e-01, -1.108098465685e+00, -1.248350189237e+00, -1.384297161672e+00],
        [-1.503280014895e+00, -1.447530359356e+00, -1.389310732940e+00, -1.343440960906e+00, -1.321069155653e+00, -1.313032656756e+00, -1.325490599286e+00, -1.368056919116e+00, -1.436530641644e+00, -1.530868635398e+00, -1.666921600949e+00, -1.862934013150e+00, -2.128068532426e+00, -2.426773436454e+00, -2.718764263532e+00],
        [-1.723852738206e+00, -1.706279714223e+00, -1.685154204289e+00, -1.681791124109e+00, -1.712224473537e+00, -1.763275869483e+00, -1.843803813486e+00, -1.967635744745e+00, -2.128729525924e+00, -2.327023122305e+00, -2.585314127017e+00, -2.929843027841e+00, -3.373788207865e+00, -3.866016677919e+00, -4.348588489967e+00],
        [-1.985508041630e+00, -2.013222204402e+00, -2.036099743248e+00, -2.083160401722e+00, -2.176234083840e+00, -2.297378738925e+00, -2.458655003128e+00, -2.678888601363e+00, -2.949853309399e+00, -3.271464668464e+00, -3.674761051661e+00, -4.195468250104e+00, -4.851528314468e+00, -5.573324913473e+00, -6.281974205551e+00],
        [-2.298794155197e+00, -2.380731743013e+00, -2.456295177987e+00, -2.563729377177e+00, -2.731803818400e+00, -2.936872798562e+00, -3.194830945691e+00, -3.530488550980e+00, -3.933004331051e+00, -4.402266978279e+00, -4.979181747487e+00, -5.710831408909e+00, -6.620861665639e+00, -7.617525641599e+00, -8.596862873712e+00],
        [-2.625404348800e+00, -2.763871487672e+00, -2.894361553573e+00, -3.064736984332e+00, -3.311001972123e+00, -3.603564584701e+00, -3.962316501912e+00, -4.418307105242e+00, -4.957968833523e+00, -5.581162388393e+00, -6.339079545553e+00, -7.290643067466e+00, -8.465444886378e+00, -9.748666367807e+00, -1.101020391673e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.928346536220e-01,  7.420950332067e-01,  7.913554127913e-01],
        [ 2.175151375457e-01,  2.518104722893e-01,  2.861058070328e-01],
        [-7.544017861118e-01, -7.514450158589e-01, -7.484882456061e-01],
        [-2.121460733006e+00, -2.162870919223e+00, -2.204281105440e+00],
        [-3.872982188995e+00, -3.971435604959e+00, -4.069889020924e+00],
        [-6.008966154079e+00, -6.177139073068e+00, -6.345311992057e+00],
        [-8.540092142400e+00, -8.791012956392e+00, -9.041933770385e+00],
        [-1.156781553830e+01, -1.191785776695e+01, -1.226789999559e+01],
        [-1.472369310390e+01, -1.517708217163e+01, -1.563047123935e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.350408729902e-01,  7.843012525748e-01,  8.335616321595e-01],
        [ 3.153699988932e-01,  3.496653336368e-01,  3.839606683803e-01],
        [-5.488088951665e-01, -5.458521249136e-01, -5.428953546608e-01],
        [-1.766682342745e+00, -1.808092528962e+00, -1.849502715179e+00],
        [-3.328691031585e+00, -3.427144447549e+00, -3.525597863513e+00],
        [-5.234834961686e+00, -5.403007880675e+00, -5.571180799663e+00],
        [-7.494673445306e+00, -7.745594259298e+00, -7.996515073290e+00],
        [-1.019901994889e+01, -1.054906217753e+01, -1.089910440618e+01],
        [-1.301807819956e+01, -1.347146726728e+01, -1.392485633501e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.772470923583e-01,  8.265074719430e-01,  8.757678515276e-01],
        [ 4.132248602407e-01,  4.475201949843e-01,  4.818155297278e-01],
        [-3.432160042212e-01, -3.402592339683e-01, -3.373024637155e-01],
        [-1.411903952484e+00, -1.453314138701e+00, -1.494724324918e+00],
        [-2.784399874174e+00, -2.882853290139e+00, -2.981306706103e+00],
        [-4.460703769293e+00, -4.628876688281e+00, -4.797049607270e+00],
        [-6.449254748212e+00, -6.700175562204e+00, -6.951096376196e+00],
        [-8.830224359476e+00, -9.180266588121e+00, -9.530308816766e+00],
        [-1.131246329521e+01, -1.176585236294e+01, -1.221924143066e+01]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.993093663176e+00, -3.047646248075e+00, -3.102198832975e+00],
        [-3.070348345822e+00, -3.124900930721e+00, -3.179453515621e+00],
        [-3.147603028468e+00, -3.202155613367e+00, -3.256708198267e+00]],
       [[-2.762263787004e+00, -2.816816371903e+00, -2.871368956803e+00],
        [-2.839518469650e+00, -2.894071054549e+00, -2.948623639449e+00],
        [-2.916773152296e+00, -2.971325737195e+00, -3.025878322095e+00]],
       [[-2.531433910832e+00, -2.585986495731e+00, -2.640539080631e+00],
        [-2.608688593478e+00, -2.663241178377e+00, -2.717793763277e+00],
        [-2.685943276124e+00, -2.740495861023e+00, -2.795048445923e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.138567222908e+00, -3.365852370096e+00, -3.582641970865e+00, -3.851909303729e+00, -4.221025587623e+00, -4.651056303636e+00, -5.168173212999e+00, -5.813228420970e+00, -6.568370897659e+00, -7.433417366266e+00, -8.475721561679e+00, -9.772808986141e+00, -1.136361415857e+01, -1.309706859654e+01, -1.480199318140e+01],
        [-3.215821905554e+00, -3.456478259803e+00, -3.686259921213e+00, -3.970415046819e+00, -4.358026117403e+00, -4.808752123820e+00, -5.349710269228e+00, -6.023228420970e+00, -6.810810689535e+00, -7.712267177339e+00, -8.797384739614e+00, -1.014648944901e+01, -1.179992231466e+01, -1.360115757999e+01, -1.537283236538e+01],
        [-3.293076588200e+00, -3.547104149510e+00, -3.789877871560e+00, -4.088920789910e+00, -4.495026647182e+00, -4.966447944004e+00, -5.531247325457e+00, -6.233228420970e+00, -7.053250481412e+00, -7.991116988413e+00, -9.119047917549e+00, -1.052016991187e+01, -1.223623047075e+01, -1.410524656343e+01, -1.594367154936e+01]],
       [[-2.907737346736e+00, -3.095070558787e+00, -3.273041079002e+00, -3.497825058394e+00, -3.811680623133e+00, -4.179875717563e+00, -4.625757209532e+00, -5.185767763106e+00, -5.843983129550e+00, -6.600239814354e+00, -7.514621612928e+00, -8.656286181092e+00, -1.005996557450e+01, -1.159089714332e+01, -1.309637827706e+01],
        [-2.984992029382e+00, -3.185696448494e+00, -3.376659029349e+00, -3.616330801485e+00, -3.948681152912e+00, -4.337571537748e+00, -4.807294265761e+00, -5.395767763106e+00, -6.086422921426e+00, -6.879089625427e+00, -7.836284790863e+00, -9.029966643957e+00, -1.049627373059e+01, -1.209498612677e+01, -1.366721746104e+01],
        [-3.062246712028e+00, -3.276322338201e+00, -3.480276979696e+00, -3.734836544575e+00, -4.085681682692e+00, -4.495267357932e+00, -4.988831321990e+00, -5.605767763106e+00, -6.328862713302e+00, -7.157939436501e+00, -8.157947968798e+00, -9.403647106823e+00, -1.093258188669e+01, -1.259907511022e+01, -1.423805664501e+01]],
       [[-2.676907470564e+00, -2.824288747477e+00, -2.963440187138e+00, -3.143740813059e+00, -3.402335658643e+00, -3.708695131491e+00, -4.083341206064e+00, -4.558307105242e+00, -5.119595361441e+00, -5.767062262442e+00, -6.553521664176e+00, -7.539763376043e+00, -8.756316990439e+00, -1.008472569010e+01, -1.139076337272e+01],
        [-2.754162153210e+00, -2.914914637184e+00, -3.067058137485e+00, -3.262246556150e+00, -3.539336188422e+00, -3.866390951675e+00, -4.264878262293e+00, -4.768307105242e+00, -5.362035153317e+00, -6.045912073516e+00, -6.875184842112e+00, -7.913443838908e+00, -9.192625146532e+00, -1.058881467355e+01, -1.196160255669e+01],
        [-2.831416835856e+00, -3.005540526891e+00, -3.170676087832e+00, -3.380752299240e+00, -3.676336718201e+00, -4.024086771859e+00, -4.446415318522e+00, -4.978307105242e+00, -5.604474945193e+00, -6.324761884589e+00, -7.196848020047e+00, -8.287124301774e+00, -9.628933302625e+00, -1.109290365700e+01, -1.253244174067e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.510425255989e+01, -1.555764162761e+01, -1.601103069534e+01],
        [-1.567509174386e+01, -1.612848081159e+01, -1.658186987931e+01],
        [-1.624593092784e+01, -1.669931999556e+01, -1.715270906329e+01]],
       [[-1.339863765554e+01, -1.385202672327e+01, -1.430541579099e+01],
        [-1.396947683952e+01, -1.442286590724e+01, -1.487625497497e+01],
        [-1.454031602350e+01, -1.499370509122e+01, -1.544709415894e+01]],
       [[-1.169302275120e+01, -1.214641181892e+01, -1.259980088665e+01],
        [-1.226386193518e+01, -1.271725100290e+01, -1.317064007062e+01],
        [-1.283470111915e+01, -1.328809018688e+01, -1.374147925460e+01]]
                ], dtype=np.float64)
            ]
        ],
        [  # x mid
            [  # y inf
                np.array([  # z inf
       [[-1.130569644706e+00, -1.070569644706e+00, -1.010569644706e+00],
        [-1.141606027941e+00, -1.081606027941e+00, -1.021606027941e+00],
        [-1.152642411177e+00, -1.092642411177e+00, -1.032642411177e+00]],
       [[-1.142901910812e+00, -1.082901910812e+00, -1.022901910812e+00],
        [-1.149313694257e+00, -1.089313694257e+00, -1.029313694257e+00],
        [-1.155725477703e+00, -1.095725477703e+00, -1.035725477703e+00]],
       [[-1.156113851674e+00, -1.096113851674e+00, -1.036113851674e+00],
        [-1.157571157297e+00, -1.097571157297e+00, -1.037571157297e+00],
        [-1.159028462919e+00, -1.099028462919e+00, -1.039028462919e+00]],
       [[-1.169104813582e+00, -1.109104813582e+00, -1.049104813582e+00],
        [-1.165690508489e+00, -1.105690508489e+00, -1.045690508489e+00],
        [-1.162276203395e+00, -1.102276203395e+00, -1.042276203395e+00]],
       [[-1.171413181686e+00, -1.111413181686e+00, -1.051413181686e+00],
        [-1.167133238554e+00, -1.107133238554e+00, -1.047133238554e+00],
        [-1.162853295422e+00, -1.102853295422e+00, -1.042853295422e+00]],
       [[-1.168126670670e+00, -1.108126670670e+00, -1.048126670670e+00],
        [-1.165079169169e+00, -1.105079169169e+00, -1.045079169169e+00],
        [-1.162031667668e+00, -1.102031667668e+00, -1.042031667668e+00]],
       [[-1.161649345540e+00, -1.101649345540e+00, -1.041649345540e+00],
        [-1.161030840963e+00, -1.101030840963e+00, -1.041030840963e+00],
        [-1.160412336385e+00, -1.100412336385e+00, -1.040412336385e+00]],
       [[-1.160690060156e+00, -1.100690060156e+00, -1.040690060156e+00],
        [-1.160431287598e+00, -1.100431287598e+00, -1.040431287598e+00],
        [-1.160172515039e+00, -1.100172515039e+00, -1.040172515039e+00]],
       [[-1.163253056069e+00, -1.103253056069e+00, -1.043253056069e+00],
        [-1.162033160043e+00, -1.102033160043e+00, -1.042033160043e+00],
        [-1.160813264017e+00, -1.100813264017e+00, -1.040813264017e+00]],
       [[-1.168539395915e+00, -1.108539395915e+00, -1.048539395915e+00],
        [-1.165337122447e+00, -1.105337122447e+00, -1.045337122447e+00],
        [-1.162134848979e+00, -1.102134848979e+00, -1.042134848979e+00]],
       [[-1.167433318088e+00, -1.107433318088e+00, -1.047433318088e+00],
        [-1.164645823805e+00, -1.104645823805e+00, -1.044645823805e+00],
        [-1.161858329522e+00, -1.101858329522e+00, -1.041858329522e+00]],
       [[-1.160114907459e+00, -1.100114907459e+00, -1.040114907459e+00],
        [-1.160071817162e+00, -1.100071817162e+00, -1.040071817162e+00],
        [-1.160028726865e+00, -1.100028726865e+00, -1.040028726865e+00]],
       [[-1.145518774495e+00, -1.085518774495e+00, -1.025518774495e+00],
        [-1.150949234060e+00, -1.090949234060e+00, -1.030949234060e+00],
        [-1.156379693624e+00, -1.096379693624e+00, -1.036379693624e+00]],
       [[-1.137353956543e+00, -1.077353956543e+00, -1.017353956543e+00],
        [-1.145846222840e+00, -1.085846222840e+00, -1.025846222840e+00],
        [-1.154338489136e+00, -1.094338489136e+00, -1.034338489136e+00]],
       [[-1.135305826782e+00, -1.075305826782e+00, -1.015305826782e+00],
        [-1.144566141739e+00, -1.084566141739e+00, -1.024566141739e+00],
        [-1.153826456696e+00, -1.093826456696e+00, -1.033826456696e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.705696447063e-01, -8.226187086831e-01, -6.748122093915e-01, -5.262835264416e-01, -3.763807505603e-01, -2.256396875488e-01, -7.370016905561e-02,  8.000000000000e-02,  2.352151588100e-01,  3.919427851709e-01,  5.511097820706e-01,  7.137830334725e-01,  8.804983451781e-01,  1.049176755599e+00,  1.217462546277e+00],
        [-9.816060279414e-01, -8.355652643555e-01, -6.896147737268e-01, -5.432129183117e-01, -3.959522548145e-01, -2.481676618609e-01, -9.963403423119e-02,  5.000000000000e-02,  2.005809028277e-01,  3.521070978747e-01,  5.051578995084e-01,  6.604001102060e-01,  8.181686085935e-01,  9.771640436779e-01,  1.135914091423e+00],
        [-9.926424111766e-01, -8.485118200279e-01, -7.044173380622e-01, -5.601423101818e-01, -4.155237590686e-01, -2.706956361729e-01, -1.255678994068e-01,  2.000000000000e-02,  1.659466468453e-01,  3.122714105784e-01,  4.592060169462e-01,  6.070171869395e-01,  7.558388720088e-01,  9.051513317569e-01,  1.054365636569e+00]],
       [[-9.829019108116e-01, -8.370854380724e-01, -6.913528784254e-01, -5.452007533170e-01, -3.982503244416e-01, -2.508128777245e-01, -1.026791669456e-01,  4.647742514224e-02,  1.965141775163e-01,  3.474296248576e-01,  4.997622679690e-01,  6.541319320949e-01,  8.108499031607e-01,  9.687083713962e-01,  1.126338740198e+00],
        [-9.893136942572e-01, -8.446069702238e-01, -6.999526918730e-01, -5.550361851089e-01, -4.096207384903e-01, -2.639009057207e-01, -1.177459079124e-01,  2.904839071390e-02,  1.763927895191e-01,  3.242863726789e-01,  4.730657031949e-01,  6.231181718451e-01,  7.746383323326e-01,  9.268713035512e-01,  1.078961712624e+00],
        [-9.957254777029e-01, -8.521285023752e-01, -7.085525053206e-01, -5.648716169007e-01, -4.209911525390e-01, -2.769889337168e-01, -1.328126488793e-01,  1.161935628556e-02,  1.562714015219e-01,  3.011431205001e-01,  4.463691384208e-01,  5.921044115952e-01,  7.384267615045e-01,  8.850342357062e-01,  1.031584685049e+00]],
       [[-9.961138516745e-01, -8.525840959458e-01, -7.090734124492e-01, -5.654673677927e-01, -4.216798802385e-01, -2.777817005743e-01, -1.337252701612e-01,  1.056364637599e-02,  1.550526106136e-01,  2.997412895057e-01,  4.447520764947e-01,  5.902258488920e-01,  7.362333574853e-01,  8.825000845865e-01,  1.028714967986e+00],
        [-9.975711572965e-01, -8.542936313947e-01, -7.110280256379e-01, -5.677028191561e-01, -4.242642108634e-01, -2.807564200018e-01, -1.371497224222e-01,  6.602278984993e-03,  1.504793102049e-01,  2.944811630839e-01,  4.386843335235e-01,  5.831768698432e-01,  7.280029912855e-01,  8.729911242951e-01,  1.017946854991e+00],
        [-9.990284629186e-01, -8.560031668436e-01, -7.129826388266e-01, -5.699382705196e-01, -4.268485414882e-01, -2.837311394293e-01, -1.405741746832e-01,  2.640911593997e-03,  1.459060097962e-01,  2.892210366621e-01,  4.326165905522e-01,  5.761278907944e-01,  7.197726250856e-01,  8.634821640038e-01,  1.007178741997e+00]],
       [[-1.009104813582e+00, -8.678235279218e-01, -7.264975581421e-01, -5.853950089605e-01, -4.447175603208e-01, -3.042994509916e-01, -1.642521055773e-01, -2.474944931119e-02,  1.142845174283e-01,  2.528505749305e-01,  3.906619689639e-01,  5.273886396464e-01,  6.628648257463e-01,  7.977336916945e-01,  9.327240216730e-01],
        [-1.005690508489e+00, -8.638182763797e-01, -7.219181166960e-01, -5.801575948860e-01, -4.386627609148e-01, -2.973300140126e-01, -1.562289945573e-01, -1.546840581949e-02,  1.249992519641e-01,  2.651744664744e-01,  4.048780163167e-01,  5.439036140647e-01,  6.821476589486e-01,  8.200121287376e-01,  9.579525135456e-01],
        [-1.002276203395e+00, -8.598130248376e-01, -7.173386752498e-01, -5.749201808116e-01, -4.326079615088e-01, -2.903605770336e-01, -1.482058835372e-01, -6.187362327797e-03,  1.357139864999e-01,  2.774983580183e-01,  4.190940636695e-01,  5.604185884830e-01,  7.014304921509e-01,  8.422905657808e-01,  9.831810054183e-01]],
       [[-1.011413181686e+00, -8.705314273796e-01, -7.295936600670e-01, -5.889359577832e-01, -4.488111329358e-01, -3.090113983982e-01, -1.696764285575e-01, -3.102424438327e-02,  1.070404221362e-01,  2.445185491191e-01,  3.810506807554e-01,  5.162230761848e-01,  6.498279482808e-01,  7.826715246982e-01,  9.156673602513e-01],
        [-1.007133238554e+00, -8.655107135408e-01, -7.238531803990e-01, -5.823706879002e-01, -4.412212437991e-01, -3.002749811417e-01, -1.596191964198e-01, -1.939015273954e-02,  1.204716924066e-01,  2.599669503423e-01,  3.988709611864e-01,  5.369251369012e-01,  6.739996105326e-01,  8.105982743649e-01,  9.472921001571e-01],
        [-1.002853295422e+00, -8.604899997020e-01, -7.181127007310e-01, -5.758054180172e-01, -4.336313546625e-01, -2.915385638853e-01, -1.495619642822e-01, -7.756061095817e-03,  1.339029626769e-01,  2.754153515655e-01,  4.166912416174e-01,  5.576271976176e-01,  6.981712727845e-01,  8.385250240317e-01,  9.789168400628e-01]],
       [[-1.008126670670e+00, -8.666760884579e-01, -7.251856226038e-01, -5.838945749591e-01, -4.429829587080e-01, -3.023028205810e-01, -1.619536146808e-01, -2.209058120839e-02,  1.173541147115e-01,  2.563811695406e-01,  3.947346354575e-01,  5.321199113766e-01,  6.683890440283e-01,  8.041161017852e-01,  9.399515745211e-01],
        [-1.005079169169e+00, -8.631011267147e-01, -7.210981569845e-01, -5.792198236351e-01, -4.375786349068e-01, -2.960821200060e-01, -1.547924377469e-01, -1.380661325525e-02,  1.269177502661e-01,  2.673810881057e-01,  4.074234328752e-01,  5.468606588961e-01,  6.856002953749e-01,  8.240011350444e-01,  9.624697340757e-01],
        [-1.002031667668e+00, -8.595261649716e-01, -7.170106913652e-01, -5.745450723112e-01, -4.321743111056e-01, -2.898614194310e-01, -1.476312608130e-01, -5.522645302099e-03,  1.364813858207e-01,  2.783810066709e-01,  4.201122302929e-01,  5.616014064156e-01,  7.028115467214e-01,  8.438861683035e-01,  9.849878936303e-01]],
       [[-1.001649345540e+00, -8.590776706957e-01, -7.164979012810e-01, -5.739586047177e-01, -4.314963155173e-01, -2.890810058767e-01, -1.467328604679e-01, -4.483386010384e-03,  1.376811848988e-01,  2.797609936097e-01,  4.217040943238e-01,  5.634506963830e-01,  7.049707719846e-01,  8.463808309696e-01,  9.878128932780e-01],
        [-1.001030840963e+00, -8.583521156134e-01, -7.156683311578e-01, -5.730098422343e-01, -4.303994829126e-01, -2.878184858158e-01, -1.452794663639e-01, -2.802116256490e-03,  1.396221691332e-01,  2.819934781489e-01,  4.242793446666e-01,  5.664423995251e-01,  7.084638753475e-01,  8.504165907846e-01,  9.923830582988e-01],
        [-1.000412336385e+00, -8.576265605311e-01, -7.148387610345e-01, -5.720610797509e-01, -4.293026503079e-01, -2.865559657549e-01, -1.438260722598e-01, -1.120846502596e-03,  1.415631533675e-01,  2.842259626881e-01,  4.268545950095e-01,  5.694341026672e-01,  7.119569787104e-01,  8.544523505996e-01,  9.969532233195e-01]],
       [[-1.000690060156e+00, -8.579523526123e-01, -7.152112584281e-01, -5.724870974464e-01, -4.297951551305e-01, -2.871228683214e-01, -1.444786819674e-01, -1.875777982871e-03,  1.406916036963e-01,  2.832235222089e-01,  4.256982442520e-01,  5.680907543578e-01,  7.103884893669e-01,  8.526401951592e-01,  9.949011067949e-01],
        [-1.000431287598e+00, -8.576487918113e-01, -7.148641793747e-01, -5.720901501897e-01, -4.293362576708e-01, -2.865946498437e-01, -1.438706048010e-01, -1.172361239294e-03,  1.415036808816e-01,  2.841575585234e-01,  4.267756883718e-01,  5.693424357593e-01,  7.118499487115e-01,  8.543286934031e-01,  9.968131917468e-01],
        [-1.000172515039e+00, -8.573452310102e-01, -7.145171003213e-01, -5.716932029330e-01, -4.288773602112e-01, -2.860664313661e-01, -1.432625276347e-01, -4.689444957174e-04,  1.423157580669e-01,  2.850915948379e-01,  4.278531324916e-01,  5.705941171609e-01,  7.133114080560e-01,  8.560171916470e-01,  9.987252766987e-01]],
       [[-1.003253056069e+00, -8.609589507490e-01, -7.186488802539e-01, -5.764186356361e-01, -4.343402750614e-01, -2.923545737498e-01, -1.505013425643e-01, -8.842723198491e-03,  1.326484382292e-01,  2.739724205082e-01,  4.150267693065e-01,  5.556935576295e-01,  6.959135606973e-01,  8.359165745332e-01,  9.759629862154e-01],
        [-1.002033160043e+00, -8.595279156467e-01, -7.170126930158e-01, -5.745473615583e-01, -4.321769576276e-01, -2.898644657365e-01, -1.476347676741e-01, -5.526701999057e-03,  1.364767024647e-01,  2.783756199605e-01,  4.201060165309e-01,  5.615941878042e-01,  7.028031182929e-01,  8.438764305118e-01,  9.849768663847e-01],
        [-1.000813264017e+00, -8.580968805444e-01, -7.153765057778e-01, -5.726760874805e-01, -4.300136401939e-01, -2.873743577232e-01, -1.447681927839e-01, -2.210680799623e-03,  1.403049667002e-01,  2.827788194128e-01,  4.251852637552e-01,  5.674948179788e-01,  7.096926758886e-01,  8.518362864904e-01,  9.939907465539e-01]],
       [[-1.008539395915e+00, -8.671602480091e-01, -7.257391909109e-01, -5.845276797769e-01, -4.437148700331e-01, -3.031452943794e-01, -1.629234578455e-01, -2.321248474050e-02,  1.160589049076e-01,  2.548914429312e-01,  3.930161828124e-01,  5.301235617044e-01,  6.660581123074e-01,  8.014230579232e-01,  9.369019245365e-01],
        [-1.005337122447e+00, -8.634037264343e-01, -7.214441371764e-01, -5.796155141463e-01, -4.380360794849e-01, -2.966086661300e-01, -1.553985897249e-01, -1.450780296281e-02,  1.261082441386e-01,  2.664500089749e-01,  4.063493999720e-01,  5.456129403510e-01,  6.841434630493e-01,  8.223179826306e-01,  9.605637028353e-01],
        [-1.002134848979e+00, -8.596472048594e-01, -7.171490834420e-01, -5.747033485157e-01, -4.323572889368e-01, -2.900720378806e-01, -1.478737216042e-01, -5.803121185124e-03,  1.361575833697e-01,  2.780085750185e-01,  4.196826171317e-01,  5.611023189975e-01,  7.022288137911e-01,  8.432129073380e-01,  9.842254811341e-01]],
       [[-1.007433318088e+00, -8.658627307112e-01, -7.242556624910e-01, -5.828309984857e-01, -4.417533934860e-01, -3.008875173229e-01, -1.603243388582e-01, -2.020585348482e-02,  1.195299861260e-01,  2.588838170151e-01,  3.976215283580e-01,  5.354736538914e-01,  6.723048634465e-01,  8.086402469388e-01,  9.450747956437e-01],
        [-1.004645823805e+00, -8.625927781231e-01, -7.205169319140e-01, -5.785550883393e-01, -4.368101566430e-01, -2.951975554697e-01, -1.537741403578e-01, -1.262865842801e-02,  1.282776699002e-01,  2.689452427773e-01,  4.092277409380e-01,  5.489567479679e-01,  6.880476825112e-01,  8.268287257653e-01,  9.656717472773e-01],
        [-1.001858329522e+00, -8.593228255349e-01, -7.167782013370e-01, -5.742791781929e-01, -4.318669198001e-01, -2.895075936164e-01, -1.472239418574e-01, -5.051463371200e-03,  1.370253536744e-01,  2.790066685395e-01,  4.208339535181e-01,  5.624398420443e-01,  7.037905015759e-01,  8.450172045919e-01,  9.862686989109e-01]],
       [[-1.000114907459e+00, -8.572776527350e-01, -7.144398340745e-01, -5.716048350975e-01, -4.287752011093e-01, -2.859488401174e-01, -1.431271583580e-01, -3.123508574915e-04,  1.424965415387e-01,  2.852995286781e-01,  4.280929915741e-01,  5.708727647000e-01,  7.136367560634e-01,  8.563930827323e-01,  9.991509423400e-01],
        [-1.000071817162e+00, -8.572271043880e-01, -7.143820391537e-01, -5.715387362216e-01, -4.286987864076e-01, -2.858608822162e-01, -1.430259025452e-01, -1.952192859349e-04,  1.426317670331e-01,  2.854550625667e-01,  4.282724054481e-01,  5.710811922232e-01,  7.138801153968e-01,  8.566742481362e-01,  9.994693389625e-01],
        [-1.000028726865e+00, -8.571765560409e-01, -7.143242442329e-01, -5.714726373458e-01, -4.286223717059e-01, -2.857729243151e-01, -1.429246467324e-01, -7.808771437818e-05,  1.427669925275e-01,  2.856105964552e-01,  4.284518193221e-01,  5.712896197464e-01,  7.141234747301e-01,  8.569554135402e-01,  9.997877355850e-01]],
       [[-9.855187744952e-01, -8.401552273906e-01, -6.948627504739e-01, -5.492149226175e-01, -4.028909714385e-01, -2.561545405307e-01, -1.088284088220e-01,  3.936405214347e-02,  1.883019648051e-01,  3.379840881110e-01,  4.888665052804e-01,  6.414741772630e-01,  7.960707476527e-01,  9.516332620446e-01,  1.107002587636e+00],
        [-9.909492340595e-01, -8.465255885477e-01, -7.021463619034e-01, -5.575450409216e-01, -4.125211428633e-01, -2.672394449746e-01, -1.215891840852e-01,  2.460253258967e-02,  1.712601565746e-01,  3.183829122122e-01,  4.662558515145e-01,  6.152070750751e-01,  7.654013601401e-01,  9.161993602065e-01,  1.066876617273e+00],
        [-9.963796936238e-01, -8.528959497048e-01, -7.094299733328e-01, -5.658751592258e-01, -4.221513142882e-01, -2.783243494184e-01, -1.343499593484e-01,  9.841013035866e-03,  1.542183483441e-01,  2.987817363135e-01,  4.436451977487e-01,  5.889399728872e-01,  7.347319726275e-01,  8.807654583683e-01,  1.026750646909e+00]],
       [[-9.773539565433e-01, -8.305772462787e-01, -6.839116770611e-01, -5.366904026084e-01, -3.884117923563e-01, -2.394881376735e-01, -8.964229653893e-02,  6.155832841492e-02,  2.139247063293e-01,  3.674548964215e-01,  5.228621311730e-01,  6.809673555014e-01,  8.421828607754e-01,  1.004908929492e+00,  1.167332885521e+00],
        [-9.858462228396e-01, -8.405393503528e-01, -6.953019410204e-01, -5.497172159160e-01, -4.034716559370e-01, -2.568229431888e-01, -1.095978639083e-01,  3.847395525933e-02,  1.872743700272e-01,  3.368021674063e-01,  4.875031176974e-01,  6.398903114741e-01,  7.942214308418e-01,  9.494966523612e-01,  1.104583053450e+00],
        [-9.943384891358e-01, -8.505014544268e-01, -7.066922049796e-01, -5.627440292235e-01, -4.185315195177e-01, -2.741577487041e-01, -1.295534312776e-01,  1.538958210374e-02,  1.606240337252e-01,  3.061494383911e-01,  4.521441042218e-01,  5.988132674468e-01,  7.462600009081e-01,  8.940843752302e-01,  1.041833221380e+00]],
       [[-9.753058267824e-01, -8.281746271046e-01, -6.811646201761e-01, -5.335486495012e-01, -3.847797165691e-01, -2.353074007730e-01, -8.482949510319e-02,  6.712572232612e-02,  2.203521245251e-01,  3.748475951849e-01,  5.313898722125e-01,  6.908741475666e-01,  8.537500006405e-01,  1.018273033955e+00,  1.182466631221e+00],
        [-9.845661417390e-01, -8.390377133690e-01, -6.935850304672e-01, -5.477536202239e-01, -4.012016085700e-01, -2.542099826260e-01, -1.065898630109e-01,  4.195357645383e-02,  1.912915063996e-01,  3.414226041334e-01,  4.928329558471e-01,  6.460820565149e-01,  8.014508932574e-01,  9.578492176504e-01,  1.114041644513e+00],
        [-9.938264566956e-01, -8.499007996333e-01, -7.060054407583e-01, -5.619585909467e-01, -4.176235005708e-01, -2.731125644790e-01, -1.283502309187e-01,  1.678143058153e-02,  1.622308882741e-01,  3.079976130819e-01,  4.542760394817e-01,  6.012899654631e-01,  7.491517858744e-01,  8.974254013459e-01,  1.045616657805e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.257462546277e+00,  1.317462546277e+00,  1.377462546277e+00],
        [ 1.175914091423e+00,  1.235914091423e+00,  1.295914091423e+00],
        [ 1.094365636569e+00,  1.154365636569e+00,  1.214365636569e+00]],
       [[ 1.166338740198e+00,  1.226338740198e+00,  1.286338740198e+00],
        [ 1.118961712624e+00,  1.178961712624e+00,  1.238961712624e+00],
        [ 1.071584685049e+00,  1.131584685049e+00,  1.191584685049e+00]],
       [[ 1.068714967986e+00,  1.128714967986e+00,  1.188714967986e+00],
        [ 1.057946854991e+00,  1.117946854991e+00,  1.177946854991e+00],
        [ 1.047178741997e+00,  1.107178741997e+00,  1.167178741997e+00]],
       [[ 9.727240216730e-01,  1.032724021673e+00,  1.092724021673e+00],
        [ 9.979525135456e-01,  1.057952513546e+00,  1.117952513546e+00],
        [ 1.023181005418e+00,  1.083181005418e+00,  1.143181005418e+00]],
       [[ 9.556673602513e-01,  1.015667360251e+00,  1.075667360251e+00],
        [ 9.872921001571e-01,  1.047292100157e+00,  1.107292100157e+00],
        [ 1.018916840063e+00,  1.078916840063e+00,  1.138916840063e+00]],
       [[ 9.799515745211e-01,  1.039951574521e+00,  1.099951574521e+00],
        [ 1.002469734076e+00,  1.062469734076e+00,  1.122469734076e+00],
        [ 1.024987893630e+00,  1.084987893630e+00,  1.144987893630e+00]],
       [[ 1.027812893278e+00,  1.087812893278e+00,  1.147812893278e+00],
        [ 1.032383058299e+00,  1.092383058299e+00,  1.152383058299e+00],
        [ 1.036953223319e+00,  1.096953223319e+00,  1.156953223319e+00]],
       [[ 1.034901106795e+00,  1.094901106795e+00,  1.154901106795e+00],
        [ 1.036813191747e+00,  1.096813191747e+00,  1.156813191747e+00],
        [ 1.038725276699e+00,  1.098725276699e+00,  1.158725276699e+00]],
       [[ 1.015962986215e+00,  1.075962986215e+00,  1.135962986215e+00],
        [ 1.024976866385e+00,  1.084976866385e+00,  1.144976866385e+00],
        [ 1.033990746554e+00,  1.093990746554e+00,  1.153990746554e+00]],
       [[ 9.769019245365e-01,  1.036901924537e+00,  1.096901924537e+00],
        [ 1.000563702835e+00,  1.060563702835e+00,  1.120563702835e+00],
        [ 1.024225481134e+00,  1.084225481134e+00,  1.144225481134e+00]],
       [[ 9.850747956437e-01,  1.045074795644e+00,  1.105074795644e+00],
        [ 1.005671747277e+00,  1.065671747277e+00,  1.125671747277e+00],
        [ 1.026268698911e+00,  1.086268698911e+00,  1.146268698911e+00]],
       [[ 1.039150942340e+00,  1.099150942340e+00,  1.159150942340e+00],
        [ 1.039469338963e+00,  1.099469338963e+00,  1.159469338962e+00],
        [ 1.039787735585e+00,  1.099787735585e+00,  1.159787735585e+00]],
       [[ 1.147002587636e+00,  1.207002587636e+00,  1.267002587636e+00],
        [ 1.106876617273e+00,  1.166876617273e+00,  1.226876617273e+00],
        [ 1.066750646909e+00,  1.126750646909e+00,  1.186750646909e+00]],
       [[ 1.207332885521e+00,  1.267332885521e+00,  1.327332885521e+00],
        [ 1.144583053450e+00,  1.204583053450e+00,  1.264583053450e+00],
        [ 1.081833221380e+00,  1.141833221380e+00,  1.201833221380e+00]],
       [[ 1.222466631221e+00,  1.282466631221e+00,  1.342466631221e+00],
        [ 1.154041644513e+00,  1.214041644513e+00,  1.274041644513e+00],
        [ 1.085616657805e+00,  1.145616657805e+00,  1.205616657805e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.184392557099e+00, -1.126788890323e+00, -1.069185223546e+00],
        [-1.218382185845e+00, -1.164117671920e+00, -1.109853157995e+00],
        [-1.289560467217e+00, -1.242288532206e+00, -1.195016597195e+00],
        [-1.390329719497e+00, -1.352957390588e+00, -1.315585061680e+00],
        [-1.519890186714e+00, -1.495245922794e+00, -1.470601658874e+00],
        [-1.678241868868e+00, -1.669154128823e+00, -1.660066388779e+00],
        [-1.866184521930e+00, -1.875560332949e+00, -1.884936143969e+00],
        [-2.091315827619e+00, -2.122808615764e+00, -2.154301403909e+00],
        [-2.326044204953e+00, -2.380596789853e+00, -2.435149374753e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.173388975630e+00, -1.114704313214e+00, -1.056019650799e+00],
        [-1.193292318941e+00, -1.136562967837e+00, -1.079833616734e+00],
        [-1.238438837014e+00, -1.186144695418e+00, -1.133850553822e+00],
        [-1.303671322101e+00, -1.257785642341e+00, -1.211899962581e+00],
        [-1.388446910230e+00, -1.350889613490e+00, -1.313332316749e+00],
        [-1.492765601401e+00, -1.465456608864e+00, -1.438147616327e+00],
        [-1.617170259586e+00, -1.602082823581e+00, -1.586995387575e+00],
        [-1.766818092534e+00, -1.766432111255e+00, -1.766046129976e+00],
        [-1.922980293162e+00, -1.937935740338e+00, -1.952891187514e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.162997508847e+00, -1.103291985151e+00, -1.043586461454e+00],
        [-1.167530373178e+00, -1.108270159636e+00, -1.049009946095e+00],
        [-1.178012740005e+00, -1.119782317796e+00, -1.061551895588e+00],
        [-1.193229119571e+00, -1.136493559740e+00, -1.079757999908e+00],
        [-1.213051565587e+00, -1.158263369689e+00, -1.103475173791e+00],
        [-1.237480078051e+00, -1.185091747644e+00, -1.132703417237e+00],
        [-1.266642603255e+00, -1.217119209383e+00, -1.167595815511e+00],
        [-1.301754630955e+00, -1.255680654795e+00, -1.209606678636e+00],
        [-1.338402014138e+00, -1.295928289543e+00, -1.253454564949e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.154385605936e+00, -1.093834045927e+00, -1.033282485917e+00],
        [-1.143483921438e+00, -1.081861376184e+00, -1.020238830929e+00],
        [-1.112093986510e+00, -1.047387683220e+00, -9.826813799309e-01],
        [-1.064401572744e+00, -9.950099502756e-01, -9.256183278071e-01],
        [-1.000847287677e+00, -9.252120703216e-01, -8.495768529662e-01],
        [-9.214311313086e-01, -8.379940433584e-01, -7.545569554083e-01],
        [-8.257124961028e-01, -7.328719764137e-01, -6.400314567246e-01],
        [-7.095056104663e-01, -6.052488862489e-01, -5.009921620315e-01],
        [-5.880114343960e-01, -4.718190804143e-01, -3.556267264326e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.154897853715e+00, -1.094396617104e+00, -1.033895380493e+00],
        [-1.140845099482e+00, -1.078963315448e+00, -1.017081531414e+00],
        [-1.092108739450e+00, -1.025439078595e+00, -9.587694177409e-01],
        [-1.015774671577e+00, -9.416059255644e-01, -8.674371795523e-01],
        [-9.125887798589e-01, -8.282830162523e-01, -7.439772526458e-01],
        [-7.825510642965e-01, -6.854703506590e-01, -5.883896370215e-01],
        [-6.249156408937e-01, -5.123487688877e-01, -3.997818968817e-01],
        [-4.325966116914e-01, -3.011362519198e-01, -1.696758921481e-01],
        [-2.313269745410e-01, -8.009381619142e-02,  7.113934215813e-02]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.158298708483e+00, -1.098131573018e+00, -1.037964437552e+00],
        [-1.147906219202e+00, -1.086718122005e+00, -1.025530024808e+00],
        [-1.103835338585e+00, -1.038317702875e+00, -9.728000671647e-01],
        [-1.032966598195e+00, -9.604867929841e-01, -8.880069877730e-01],
        [-9.360242645125e-01, -8.540208110020e-01, -7.720173574915e-01],
        [-8.130083375373e-01, -7.189197569287e-01, -6.248311763200e-01],
        [-6.631945507903e-01, -5.543882120959e-01, -4.455818734016e-01],
        [-4.797023727053e-01, -3.528696991438e-01, -2.260370255822e-01],
        [-2.875189968566e-01, -1.418061621615e-01,  3.906672533515e-03]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.161321265479e+00, -1.101451067055e+00, -1.041580868632e+00],
        [-1.158878751435e+00, -1.098768599589e+00, -1.038658447743e+00],
        [-1.141851591739e+00, -1.080068685851e+00, -1.018285779964e+00],
        [-1.113219445180e+00, -1.048623707339e+00, -9.840279694969e-01],
        [-1.073295960052e+00, -1.004778125261e+00, -9.362602904694e-01],
        [-1.022081136355e+00, -9.485319396182e-01, -8.749827428812e-01],
        [-9.592613257947e-01, -8.795406891998e-01, -7.998200526050e-01],
        [-8.818568695824e-01, -7.945319925101e-01, -7.072071154378e-01],
        [-8.006886338486e-01, -7.053897613002e-01, -6.100908887518e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.157045044569e+00, -1.096754748728e+00, -1.036464452887e+00],
        [-1.156724685636e+00, -1.096402917623e+00, -1.036081149610e+00],
        [-1.166613388131e+00, -1.107263089662e+00, -1.047912791193e+00],
        [-1.184625429828e+00, -1.127044640548e+00, -1.069463851268e+00],
        [-1.210541261017e+00, -1.155506451933e+00, -1.100471642849e+00],
        [-1.244360881700e+00, -1.192648523817e+00, -1.140936165934e+00],
        [-1.286303841583e+00, -1.238711974547e+00, -1.191120107510e+00],
        [-1.338455862896e+00, -1.295987428422e+00, -1.253518993948e+00],
        [-1.393242480706e+00, -1.356156302464e+00, -1.319070124221e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.149820335505e+00, -1.088820281754e+00, -1.027820228003e+00],
        [-1.147560015845e+00, -1.086337907511e+00, -1.025115799177e+00],
        [-1.175987157420e+00, -1.117557741279e+00, -1.059128325139e+00],
        [-1.228832278902e+00, -1.175594385723e+00, -1.122356492545e+00],
        [-1.305435434888e+00, -1.259723062177e+00, -1.214010689465e+00],
        [-1.405796625378e+00, -1.369943770639e+00, -1.334090915899e+00],
        [-1.530575795776e+00, -1.506981289776e+00, -1.483386783777e+00],
        [-1.686042427408e+00, -1.677721016926e+00, -1.669399606443e+00],
        [-1.849428403876e+00, -1.857158088078e+00, -1.864887772280e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.142828947915e+00, -1.081142057836e+00, -1.019455167756e+00],
        [-1.134985331951e+00, -1.072527882334e+00, -1.010070432717e+00],
        [-1.163285530955e+00, -1.103608302649e+00, -1.043931074343e+00],
        [-1.220345324663e+00, -1.166273670172e+00, -1.112202015682e+00],
        [-1.305387426732e+00, -1.259670337683e+00, -1.213953248634e+00],
        [-1.418411837164e+00, -1.383798305181e+00, -1.349184773198e+00],
        [-1.560195842300e+00, -1.539511219888e+00, -1.518826597475e+00],
        [-1.738123662403e+00, -1.734918730411e+00, -1.731713798418e+00],
        [-1.925378918628e+00, -1.940570007597e+00, -1.955761096566e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.146707113621e+00, -1.085401215878e+00, -1.024095318135e+00],
        [-1.139548641580e+00, -1.077539493074e+00, -1.015530344568e+00],
        [-1.156161025093e+00, -1.095783882874e+00, -1.035406740655e+00],
        [-1.191687852812e+00, -1.134800878402e+00, -1.077913903992e+00],
        [-1.245617923540e+00, -1.194029057881e+00, -1.142440192222e+00],
        [-1.317951237280e+00, -1.273468421313e+00, -1.228985605346e+00],
        [-1.409198995227e+00, -1.373680390475e+00, -1.338161785722e+00],
        [-1.524217608717e+00, -1.499998472229e+00, -1.475779335741e+00],
        [-1.645370636564e+00, -1.633053615319e+00, -1.620736594075e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.159796606236e+00, -1.099776624762e+00, -1.039756643289e+00],
        [-1.159685528777e+00, -1.099654635016e+00, -1.039623741254e+00],
        [-1.159932177003e+00, -1.099925514048e+00, -1.039918851094e+00],
        [-1.160463467171e+00, -1.100508998345e+00, -1.040554529520e+00],
        [-1.161271706255e+00, -1.101396639116e+00, -1.041521571977e+00],
        [-1.162356894255e+00, -1.102588436360e+00, -1.042819978465e+00],
        [-1.163726724205e+00, -1.104092838875e+00, -1.044458953545e+00],
        [-1.165454279837e+00, -1.105990110167e+00, -1.046525940497e+00],
        [-1.167274151773e+00, -1.107988766950e+00, -1.048703382127e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.181213264254e+00, -1.123297262651e+00, -1.065381261048e+00],
        [-1.196095705105e+00, -1.139641759625e+00, -1.083187814145e+00],
        [-1.186446205274e+00, -1.129044289602e+00, -1.071642373931e+00],
        [-1.157276666620e+00, -1.097009125410e+00, -1.036741584199e+00],
        [-1.109114657761e+00, -1.044115664187e+00, -9.791166706138e-01],
        [-1.041960178696e+00, -9.703639059358e-01, -8.987676331752e-01],
        [-9.552856608158e-01, -8.751744535215e-01, -7.950632462272e-01],
        [-8.440792022601e-01, -7.530430341154e-01, -6.620068659707e-01],
        [-7.265419202781e-01, -6.239588490114e-01, -5.213757777448e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.192305327514e+00, -1.135479014032e+00, -1.078652700551e+00],
        [-1.215752483726e+00, -1.161229626958e+00, -1.106706770190e+00],
        [-1.204874226140e+00, -1.149282685594e+00, -1.093691145049e+00],
        [-1.166683273704e+00, -1.107339840818e+00, -1.047996407931e+00],
        [-1.101917807360e+00, -1.036211792721e+00, -9.705057780813e-01],
        [-1.010577827107e+00, -9.358985413019e-01, -8.612192554966e-01],
        [-8.919251520076e-01, -8.055893864739e-01, -7.192536209401e-01],
        [-7.389470631016e-01, -6.375826773467e-01, -5.362182915918e-01],
        [-5.771108029096e-01, -4.598475671298e-01, -3.425843313500e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.193888149484e+00, -1.137217332979e+00, -1.080546516473e+00],
        [-1.219723669388e+00, -1.165590943269e+00, -1.111458217151e+00],
        [-1.214355249668e+00, -1.159695128144e+00, -1.105035006620e+00],
        [-1.184157888741e+00, -1.126531168064e+00, -1.068904447387e+00],
        [-1.129802639073e+00, -1.066836039920e+00, -1.003869440766e+00],
        [-1.051289500664e+00, -9.806097437117e-01, -9.099299867594e-01],
        [-9.479474210647e-01, -8.671153025641e-01, -7.862831840634e-01],
        [-8.134014018108e-01, -7.193514359707e-01, -6.253014701307e-01],
        [-6.708027529978e-01, -5.627438467116e-01, -4.546849404254e-01]]
                ], dtype=np.float64),

                None,  # z mid (interpolation area)

                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.053845719371e-01,  8.546449515217e-01,  9.039053311064e-01],
        [ 4.784614344724e-01,  5.127567692159e-01,  5.470521039595e-01],
        [-2.061540769243e-01, -2.031973066715e-01, -2.002405364186e-01],
        [-1.175385025643e+00, -1.216795211860e+00, -1.258205398078e+00],
        [-2.421539102568e+00, -2.519992518532e+00, -2.618445934496e+00],
        [-3.944616307697e+00, -4.112789226686e+00, -4.280962145674e+00],
        [-5.752308950149e+00, -6.003229764141e+00, -6.254150578134e+00],
        [-7.917693966533e+00, -8.267736195179e+00, -8.617778423824e+00],
        [-1.017538669232e+01, -1.062877576004e+01, -1.108216482777e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 9.112205433816e-01,  9.653256093067e-01,  1.019430675232e+00],
        [ 7.197838116080e-01,  7.651257801964e-01,  8.104677487848e-01],
        [ 2.855501386081e-01,  3.110148772203e-01,  3.364796158325e-01],
        [-3.418767994535e-01, -3.451327942082e-01, -3.483887889629e-01],
        [-1.157275562981e+00, -1.197856780888e+00, -1.238437998795e+00],
        [-2.160646151973e+00, -2.247157082818e+00, -2.333668013663e+00],
        [-3.357210006027e+00, -3.498494153201e+00, -3.639778300374e+00],
        [-4.796570801308e+00, -5.003742297449e+00, -5.210913793591e+00],
        [-6.298588871744e+00, -6.574515880115e+00, -6.850442888486e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.011168999687e+00,  1.069849248458e+00,  1.128529497229e+00],
        [ 9.675704585048e-01,  1.024254965619e+00,  1.080939472734e+00],
        [ 8.667476964542e-01,  9.188169990080e-01,  9.708863015618e-01],
        [ 7.203916833900e-01,  7.657614775663e-01,  8.111312717426e-01],
        [ 5.297330477181e-01,  5.663753622358e-01,  6.030176767534e-01],
        [ 2.947717894385e-01,  3.206586530164e-01,  3.465455165942e-01],
        [ 1.427728014524e-02,  2.732438896668e-02,  4.037149778813e-02],
        [-3.234414500164e-01, -3.258535588561e-01, -3.282656676958e-01],
        [-6.759277210471e-01, -6.944750379750e-01, -7.130223549029e-01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.094001040614e+00,  1.156472961080e+00,  1.218944881546e+00],
        [ 1.198856934344e+00,  1.266128677679e+00,  1.333400421014e+00],
        [ 1.500775383897e+00,  1.581867571912e+00,  1.662959759926e+00],
        [ 1.959496297223e+00,  2.061586628993e+00,  2.163676960763e+00],
        [ 2.570781769895e+00,  2.700853952629e+00,  2.830926135363e+00],
        [ 3.334631801915e+00,  3.499669542821e+00,  3.664707283728e+00],
        [ 4.255284297707e+00,  4.462465295862e+00,  4.669646294016e+00],
        [ 5.372999349321e+00,  5.631344226536e+00,  5.889689103750e+00],
        [ 6.541569254052e+00,  6.853405912729e+00,  7.165242571405e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.089074077383e+00,  1.151320464023e+00,  1.213566850664e+00],
        [ 1.224237969237e+00,  1.292671540175e+00,  1.361105111113e+00],
        [ 1.692999892172e+00,  1.782891238326e+00,  1.872782584480e+00],
        [ 2.427205409730e+00,  2.550705323873e+00,  2.674205238016e+00],
        [ 3.419680370705e+00,  3.588611245807e+00,  3.757542120908e+00],
        [ 4.670424775096e+00,  4.896609004126e+00,  5.122793233155e+00],
        [ 6.186612774111e+00,  6.482201149842e+00,  6.777789525573e+00],
        [ 8.036398804205e+00,  8.416661917556e+00,  8.796925030907e+00],
        [ 9.972274648772e+00,  1.044115329740e+01,  1.091003194603e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.056363566797e+00,  1.117112615986e+00,  1.177861665174e+00],
        [ 1.156321857817e+00,  1.221646540039e+00,  1.286971222262e+00],
        [ 1.580209705201e+00,  1.664938032858e+00,  1.749666360515e+00],
        [ 2.261847952273e+00,  2.377778558887e+00,  2.493709165502e+00],
        [ 3.194270372013e+00,  3.352883009121e+00,  3.511495646229e+00],
        [ 4.377476964423e+00,  4.590251383560e+00,  4.803025802697e+00],
        [ 5.818433956521e+00,  6.097168791211e+00,  6.375903625900e+00],
        [ 7.583320504982e+00,  7.942843767624e+00,  8.302367030266e+00],
        [ 9.431801777666e+00,  9.875940052106e+00,  1.032007832655e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.027291645371e+00,  1.086709915065e+00,  1.146128184759e+00],
        [ 1.050784527879e+00,  1.111278194202e+00,  1.171771860526e+00],
        [ 1.214557204293e+00,  1.282547634123e+00,  1.350538063952e+00],
        [ 1.489950361879e+00,  1.570547029934e+00,  1.651143697989e+00],
        [ 1.873947230877e+00,  1.972121517965e+00,  2.070295805052e+00],
        [ 2.366547811286e+00,  2.487271098214e+00,  2.607994385142e+00],
        [ 2.970768872866e+00,  3.119150634354e+00,  3.267532395841e+00],
        [ 3.715269728355e+00,  3.897731331279e+00,  4.080192934203e+00],
        [ 4.495971820979e+00,  4.714170392275e+00,  4.932368963570e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.068421707922e+00,  1.129722723619e+00,  1.191023739315e+00],
        [ 1.071503022765e+00,  1.132945086952e+00,  1.194387151138e+00],
        [ 9.763903144309e-01,  1.033478554180e+00,  1.090566793928e+00],
        [ 8.031447274391e-01,  8.523025771948e-01,  9.014604269506e-01],
        [ 5.538779612127e-01,  5.916255193540e-01,  6.293730774953e-01],
        [ 2.285900157519e-01,  2.514473806574e-01,  2.743047455630e-01],
        [-1.748308083659e-01, -1.704402022514e-01, -1.660495961369e-01],
        [-6.764456556602e-01, -6.950166812636e-01, -7.135877068671e-01],
        [-1.203400896036e+00, -1.246093520566e+00, -1.288786145095e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.137911274052e+00,  1.202393204018e+00,  1.266875133985e+00],
        [ 1.159651752610e+00,  1.225128862174e+00,  1.290605971739e+00],
        [ 8.862303986309e-01,  9.391915301142e-01,  9.921526615975e-01],
        [ 3.779490918808e-01,  4.076434316454e-01,  4.373377714101e-01],
        [-3.588446013495e-01, -3.628773044100e-01, -3.669100074705e-01],
        [-1.324150681060e+00, -1.372370678052e+00, -1.420590675044e+00],
        [-2.524316713541e+00, -2.627474818102e+00, -2.730632922663e+00],
        [-4.019644578560e+00, -4.191251948369e+00, -4.362859318178e+00],
        [-5.591143239072e+00, -5.834686624499e+00, -6.078230009925e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.205156679502e+00,  1.272716796334e+00,  1.340276913167e+00],
        [ 1.280599090457e+00,  1.351612615549e+00,  1.422626140640e+00],
        [ 1.008398710797e+00,  1.066952148422e+00,  1.125505586048e+00],
        [ 4.595793364523e-01,  4.930103351757e-01,  5.264413338990e-01],
        [-3.583828435302e-01, -3.623944094313e-01, -3.664059753323e-01],
        [-1.445487829151e+00, -1.499262085399e+00, -1.553036341646e+00],
        [-2.809211809456e+00, -2.925411107487e+00, -3.041610405518e+00],
        [-4.520578580377e+00, -4.715116415916e+00, -4.909654251454e+00],
        [-6.321659619845e+00, -6.598642701465e+00, -6.875625783085e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.167855239416e+00,  1.233707867057e+00,  1.299560494699e+00],
        [ 1.236707716649e+00,  1.305712095547e+00,  1.374716474445e+00],
        [ 1.076924490428e+00,  1.138614724589e+00,  1.200304958751e+00],
        [ 7.352160808129e-01,  7.812644680490e-01,  8.273128552852e-01],
        [ 2.164993846514e-01,  2.388032958064e-01,  2.611072069614e-01],
        [-4.792255980559e-01, -4.887687921379e-01, -4.983119862198e-01],
        [-1.356875764149e+00, -1.406593765655e+00, -1.456311767162e+00],
        [-2.463161633712e+00, -2.563520338636e+00, -2.663879043561e+00],
        [-3.628450265449e+00, -3.782150550177e+00, -3.935850834906e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.041956306378e+00,  1.102045857130e+00,  1.162135407881e+00],
        [ 1.043024684957e+00,  1.103163141189e+00,  1.163301597422e+00],
        [ 1.040652343313e+00,  1.100682204604e+00,  1.160712065895e+00],
        [ 1.035542224288e+00,  1.095338167720e+00,  1.155134111153e+00],
        [ 1.027768321866e+00,  1.087208411628e+00,  1.146648501389e+00],
        [ 1.017330636043e+00,  1.076292936324e+00,  1.135255236604e+00],
        [ 1.004155172854e+00,  1.062514360733e+00,  1.120873548612e+00],
        [ 9.875389894231e-01,  1.045137564482e+00,  1.102736139540e+00],
        [ 9.700348782151e-01,  1.026832195183e+00,  1.083629512151e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.359640289807e-01,  8.866241961406e-01,  9.372843633004e-01],
        [ 6.928199454486e-01,  7.369276316632e-01,  7.810353178778e-01],
        [ 7.856319259317e-01,  8.339881197940e-01,  8.823443136564e-01],
        [ 1.066193892833e+00,  1.127392929352e+00,  1.188591965872e+00],
        [ 1.529431522197e+00,  1.611835457058e+00,  1.694239391919e+00],
        [ 2.175344814024e+00,  2.287315702912e+00,  2.399286591799e+00],
        [ 3.009008092265e+00,  3.159140270187e+00,  3.309272448109e+00],
        [ 4.078627434545e+00,  4.277721890098e+00,  4.476816345650e+00],
        [ 5.209138664286e+00,  5.459982749358e+00,  5.710826834431e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.292770113210e-01,  7.750535351400e-01,  8.208300589591e-01],
        [ 5.037547518460e-01,  5.392078988864e-01,  5.746610459268e-01],
        [ 6.083853180368e-01,  6.486279734826e-01,  6.888706289284e-01],
        [ 9.757181326064e-01,  1.032775602948e+00,  1.089833073290e+00],
        [ 1.598653134787e+00,  1.684225718232e+00,  1.769798301676e+00],
        [ 2.477190324581e+00,  2.602978319335e+00,  2.728766314089e+00],
        [ 3.618429762777e+00,  3.796458475332e+00,  3.974487187886e+00],
        [ 5.089822026621e+00,  5.335204342158e+00,  5.580586657695e+00],
        [ 6.646415019662e+00,  6.963051037591e+00,  7.279687055519e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.140529225747e-01,  7.591325572947e-01,  8.042121920146e-01],
        [ 4.655586160229e-01,  4.992633187966e-01,  5.329680215703e-01],
        [ 5.171937966049e-01,  5.532621216013e-01,  5.893304465976e-01],
        [ 8.076416873800e-01,  8.570053873785e-01,  9.063690873770e-01],
        [ 1.330447890776e+00,  1.403743265778e+00,  1.477038640780e+00],
        [ 2.085612406789e+00,  2.193475756797e+00,  2.301339106804e+00],
        [ 3.079589633001e+00,  3.232952710795e+00,  3.386315788589e+00],
        [ 4.373696346347e+00,  4.586297706094e+00,  4.798899065840e+00],
        [ 5.745255830536e+00,  6.020640905570e+00,  6.296025980604e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.377547326717e+00, -2.432099911617e+00, -2.486652496517e+00],
        [-2.454802009363e+00, -2.509354594263e+00, -2.563907179163e+00],
        [-2.532056692009e+00, -2.586609276909e+00, -2.641161861809e+00]],
       [[-1.957220230290e+00, -1.972175677466e+00, -1.987131124642e+00],
        [-2.008580135982e+00, -2.023535583158e+00, -2.038491030334e+00],
        [-2.059940041675e+00, -2.074895488851e+00, -2.089850936027e+00]],
       [[-1.346436026999e+00, -1.303962302404e+00, -1.261488577809e+00],
        [-1.358487046290e+00, -1.316013321695e+00, -1.273539597100e+00],
        [-1.370538065581e+00, -1.328064340986e+00, -1.285590616391e+00]],
       [[-5.614142440760e-01, -4.452218900942e-01, -3.290295361125e-01],
        [-5.215184585959e-01, -4.053261046141e-01, -2.891337506324e-01],
        [-4.816226731158e-01, -3.654303191340e-01, -2.492379651523e-01]],
       [[-1.873018120536e-01, -3.606865370406e-02,  1.151645046455e-01],
        [-1.212640683226e-01,  2.996909002698e-02,  1.812022483765e-01],
        [-5.522632459153e-02,  9.600683375802e-02,  2.472399921076e-01]],
       [[-2.455087220309e-01, -9.979588733587e-02,  4.591694735919e-02],
        [-1.824933097924e-01, -3.678047509735e-02,  1.089323595977e-01],
        [-1.194778975539e-01,  2.623493714116e-02,  1.719477718362e-01]],
       [[-7.829633025157e-01, -6.876644299673e-01, -5.923655574189e-01],
        [-7.563753055164e-01, -6.610764329680e-01, -5.657775604196e-01],
        [-7.297873085171e-01, -6.344884359687e-01, -5.391895634203e-01]],
       [[-1.405188835961e+00, -1.368102657718e+00, -1.331016479476e+00],
        [-1.423108368843e+00, -1.386022190600e+00, -1.348936012358e+00],
        [-1.441027901725e+00, -1.403941723482e+00, -1.366855545240e+00]],
       [[-1.885043303696e+00, -1.892772987898e+00, -1.900502672101e+00],
        [-1.938465653427e+00, -1.946195337629e+00, -1.953925021831e+00],
        [-1.991888003157e+00, -1.999617687360e+00, -2.007347371562e+00]],
       [[-1.966149307175e+00, -1.981340396144e+00, -1.996531485113e+00],
        [-2.027304889995e+00, -2.042495978964e+00, -2.057687067934e+00],
        [-2.088460472816e+00, -2.103651561785e+00, -2.118842650754e+00]],
       [[-1.671729975949e+00, -1.659412954704e+00, -1.647095933460e+00],
        [-1.711268985026e+00, -1.698951963782e+00, -1.686634942538e+00],
        [-1.750807994104e+00, -1.738490972860e+00, -1.726173951616e+00]],
       [[-1.167670070327e+00, -1.108384685504e+00, -1.049099300681e+00],
        [-1.168263948158e+00, -1.108978563335e+00, -1.049693178512e+00],
        [-1.168857825989e+00, -1.109572441166e+00, -1.050287056343e+00]],
       [[-7.010410964446e-01, -5.984580251779e-01, -4.958749539112e-01],
        [-6.627898606943e-01, -5.602067894276e-01, -4.576237181609e-01],
        [-6.245386249440e-01, -5.219555536773e-01, -4.193724824106e-01]],
       [[-5.420256456786e-01, -4.247624098988e-01, -3.074991741191e-01],
        [-4.893979098322e-01, -3.721346740524e-01, -2.548714382727e-01],
        [-4.367701739858e-01, -3.195069382061e-01, -2.022437024263e-01]],
       [[-6.399350364757e-01, -5.318761301894e-01, -4.238172239032e-01],
        [-5.936334616924e-01, -4.855745554061e-01, -3.775156491199e-01],
        [-5.473318869091e-01, -4.392729806228e-01, -3.312140743366e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.523020886450e+00, -2.643767539937e+00, -2.757039592562e+00, -2.907684649502e+00, -3.129439015649e+00, -3.394574740776e+00, -3.721730537086e+00, -4.140000000000e+00, -4.636670182701e+00, -5.211610561167e+00, -5.912788365009e+00, -6.795414839344e+00, -7.887217934398e+00, -9.080611387960e+00, -1.025368676982e+01],
        [-2.600275569096e+00, -2.734393429644e+00, -2.860657542909e+00, -3.026190392593e+00, -3.266439545428e+00, -3.552270560960e+00, -3.903267593315e+00, -4.350000000000e+00, -4.879109974577e+00, -5.490460372241e+00, -6.234451542944e+00, -7.169095302209e+00, -8.323526090490e+00, -9.584700371407e+00, -1.082452595380e+01],
        [-2.677530251742e+00, -2.825019319351e+00, -2.964275493256e+00, -3.144696135684e+00, -3.403440075207e+00, -3.709966381145e+00, -4.084804649544e+00, -4.560000000000e+00, -5.121549766453e+00, -5.769310183315e+00, -6.556114720879e+00, -7.542775765074e+00, -8.759834246583e+00, -1.008878935485e+01, -1.139536513777e+01]],
       [[-1.997101422759e+00, -2.026822162923e+00, -2.051649381782e+00, -2.100944207165e+00, -2.196793347075e+00, -2.321043683021e+00, -2.485897730817e+00, -2.710402678618e+00, -2.986235530022e+00, -3.313310832696e+00, -3.723032090897e+00, -4.251545369034e+00, -4.917003785601e+00, -5.648972052367e+00, -6.367638349093e+00],
        [-2.048461328452e+00, -2.087071418880e+00, -2.120535926592e+00, -2.179728347888e+00, -2.287873059635e+00, -2.425881890561e+00, -2.606585898423e+00, -2.850013376972e+00, -3.147412618845e+00, -3.498693770125e+00, -3.936877904737e+00, -4.499972942282e+00, -5.207067054029e+00, -5.984096885757e+00, -6.747139573489e+00],
        [-2.099821234144e+00, -2.147320674837e+00, -2.189422471402e+00, -2.258512488612e+00, -2.378952772194e+00, -2.530720098102e+00, -2.727274066030e+00, -2.989624075327e+00, -3.308589707667e+00, -3.684076707554e+00, -4.150723718578e+00, -4.748400515530e+00, -5.497130322457e+00, -6.319221719147e+00, -7.126640797885e+00]],
       [[-1.233172761413e+00, -1.130673059258e+00, -1.027029004232e+00, -9.291067135596e-01, -8.420711770597e-01, -7.616772771634e-01, -6.907785794598e-01, -6.338292802402e-01, -5.888830418403e-01, -5.559198811808e-01, -5.422835264308e-01, -5.564267562750e-01, -6.025946882817e-01, -6.643159883592e-01, -7.229266148225e-01],
        [-1.245223780704e+00, -1.144809863756e+00, -1.043192450585e+00, -9.475925185254e-01, -8.634419984871e-01, -7.862763733744e-01, -7.190966890129e-01, -6.665873469935e-01, -6.267014174876e-01, -5.994178846346e-01, -5.924600209779e-01, -6.147174684033e-01, -6.706547440068e-01, -7.429492291657e-01, -8.119722724134e-01],
        [-1.257274799995e+00, -1.158946668254e+00, -1.059355896939e+00, -9.660783234912e-01, -8.848128199145e-01, -8.108754695854e-01, -7.474147985660e-01, -6.993454137468e-01, -6.645197931348e-01, -6.429158880884e-01, -6.426365155249e-01, -6.730081805316e-01, -7.387147997320e-01, -8.215824699722e-01, -9.010179300043e-01]],
       [[-2.515679667913e-01,  2.082746868889e-02,  2.895497892620e-01,  5.766376843698e-01,  8.986696077193e-01,  1.242019688288e+00,  1.615847228745e+00,  2.034449195708e+00,  2.491578283762e+00,  2.987170351725e+00,  3.544797112568e+00,  4.191590081562e+00,  4.941175129731e+00,  5.740682985426e+00,  6.530206279617e+00],
        [-2.116721813112e-01,  6.762839946561e-02,  3.430600669223e-01,  6.378363009788e-01,  9.694192834611e-01,  1.323456805078e+00,  1.709596412664e+00,  2.142897184411e+00,  2.616778797146e+00,  3.131173690587e+00,  3.710910087267e+00,  4.384565770206e+00,  5.166492948697e+00,  6.001004111055e+00,  6.824998476640e+00],
        [-1.717763958311e-01,  1.144293302423e-01,  3.965703445826e-01,  6.990349175879e-01,  1.040168959203e+00,  1.404893921867e+00,  1.803345596583e+00,  2.251345173114e+00,  2.741979310529e+00,  3.275177029450e+00,  3.877023061966e+00,  4.577541458850e+00,  5.391810767663e+00,  6.261325236684e+00,  7.119790673664e+00]],
       [[ 2.159866102119e-01,  5.693061896698e-01,  9.166580147474e-01,  1.293848611727e+00,  1.727813195606e+00,  2.196413648318e+00,  2.714531200103e+00,  3.305394306188e+00,  3.958852893623e+00,  4.674802751451e+00,  5.491541127893e+00,  6.453148925184e+00,  7.581764261391e+00,  8.791489789042e+00,  9.984993278404e+00],
        [ 2.820243539429e-01,  6.467737175256e-01,  1.005231230203e+00,  1.395147997406e+00,  1.844922030523e+00,  2.331212935612e+00,  2.869710112064e+00,  3.484903504965e+00,  4.166091811677e+00,  4.913165161760e+00,  5.766500648594e+00,  6.772573117981e+00,  7.954722963867e+00,  9.222387929664e+00,  1.047294987148e+01],
        [ 3.480620976739e-01,  7.242412453813e-01,  1.093804445659e+00,  1.496447383085e+00,  1.962030865441e+00,  2.466012222906e+00,  3.024889024026e+00,  3.664412703741e+00,  4.373330729730e+00,  5.151527572069e+00,  6.041460169294e+00,  7.091997310778e+00,  8.327681666342e+00,  9.653286070287e+00,  1.096090646456e+01]],
       [[ 1.430588371559e-01,  4.837561091938e-01,  8.188435378950e-01,  1.181980183278e+00,  1.598485843502e+00,  2.047550115490e+00,  2.543161740228e+00,  3.107156065901e+00,  3.729991761637e+00,  4.411570866443e+00,  5.187893783327e+00,  6.100397699526e+00,  7.169893018121e+00,  8.315634012723e+00,  9.446125872125e+00],
        [ 2.060742493944e-01,  5.576782017294e-01,  9.033630470407e-01,  1.278643427469e+00,  1.710234990159e+00,  2.176180080391e+00,  2.691238621046e+00,  3.278449715902e+00,  3.927746032380e+00,  4.639024209019e+00,  5.450269306277e+00,  6.405202891994e+00,  7.525782620894e+00,  8.726811355103e+00,  9.911750288253e+00],
        [ 2.690896616329e-01,  6.316002942651e-01,  9.878825561865e-01,  1.375306671660e+00,  1.821984136816e+00,  2.304810045292e+00,  2.839315501865e+00,  3.449743365903e+00,  4.125500303122e+00,  4.866477551595e+00,  5.712644829226e+00,  6.710008084461e+00,  7.881672223667e+00,  9.137988697484e+00,  1.037737470438e+01]],
       [[-5.288329757200e-01, -3.044264480720e-01, -8.233228887426e-02,  1.513237125726e-01,  4.069783365693e-01,  6.760535682563e-01,  9.643155442915e-01,  1.280764760269e+00,  1.621468294866e+00,  1.986385768720e+00,  2.390356490360e+00,  2.850460802091e+00,  3.375276718769e+00,  3.931520981142e+00,  4.481479574372e+00],
        [-5.022449787207e-01, -2.732366120510e-01, -4.667110098828e-02,  1.921086881078e-01,  4.541284839767e-01,  7.303262136191e-01,  1.026793397296e+00,  1.353038429368e+00,  1.704906453411e+00,  2.082354811451e+00,  2.501060195519e+00,  2.979066793146e+00,  3.525436677332e+00,  4.105008411550e+00,  4.677939775758e+00],
        [-4.756569817214e-01, -2.420467760299e-01, -1.100991310229e-02,  2.328936636430e-01,  5.012786313842e-01,  7.845988589819e-01,  1.089271250301e+00,  1.425312098466e+00,  1.788344611955e+00,  2.178323854183e+00,  2.611763900677e+00,  3.107672784202e+00,  3.675596635896e+00,  4.278495841959e+00,  4.874399977144e+00]],
       [[-1.306292360647e+00, -1.216448167105e+00, -1.125100768214e+00, -1.041269396070e+00, -9.717387064497e-01, -9.109323744357e-01, -8.625988024331e-01, -8.325889581472e-01, -8.183461606271e-01, -8.198441603862e-01, -8.467295723385e-01, -9.101058440798e-01, -1.015549300534e+00, -1.141423435908e+00, -1.263211435505e+00],
        [-1.324211893529e+00, -1.237469204988e+00, -1.149135366569e+00, -1.068757277546e+00, -1.003516527731e+00, -9.475105511674e-01, -9.047070492993e-01, -8.812992987552e-01, -8.745810408139e-01, -8.845244902713e-01, -9.213406340446e-01, -9.967825232454e-01, -1.116752723836e+00, -1.258348893434e+00, -1.395619869238e+00],
        [-1.342131426411e+00, -1.258490242872e+00, -1.173169964923e+00, -1.096245159022e+00, -1.035294349012e+00, -9.840887278991e-01, -9.468152961655e-01, -9.300096393633e-01, -9.308159210008e-01, -9.492048201563e-01, -9.959516957506e-01, -1.083459202411e+00, -1.217956147137e+00, -1.375274350960e+00, -1.528028302971e+00]],
       [[-1.905655794902e+00, -1.919549165345e+00, -1.928997806470e+00, -1.960670094186e+00, -2.034627132247e+00, -2.134380651171e+00, -2.271014056226e+00, -2.461827690121e+00, -2.699261870608e+00, -2.983238982315e+00, -3.342282468253e+00, -3.809223384470e+00, -4.400550000449e+00, -5.052286751120e+00, -5.691941474852e+00],
        [-1.959078144633e+00, -1.982217832263e+00, -2.000650607209e+00, -2.042617945574e+00, -2.129364304991e+00, -2.243428814576e+00, -2.396548661700e+00, -2.607044692627e+00, -2.866911298535e+00, -3.176066285713e+00, -3.564715623093e+00, -4.067626987863e+00, -4.702261250911e+00, -5.400869090037e+00, -6.086682213949e+00],
        [-2.012500494363e+00, -2.044886499181e+00, -2.072303407949e+00, -2.124565796961e+00, -2.224101477736e+00, -2.352476977980e+00, -2.522083267173e+00, -2.752261695133e+00, -3.034560726461e+00, -3.368893589111e+00, -3.787148777934e+00, -4.326030591256e+00, -5.003972501372e+00, -5.749451428955e+00, -6.481422953045e+00]],
       [[-2.006658877759e+00, -2.038033818101e+00, -2.064468331568e+00, -2.115604979405e+00, -2.213742175980e+00, -2.340552800829e+00, -2.508356333794e+00, -2.736382534869e+00, -3.016228629748e+00, -3.347808347017e+00, -3.762826201012e+00, -4.297774724792e+00, -4.970981038823e+00, -5.711334715833e+00, -6.438258920248e+00],
        [-2.067814460580e+00, -2.109774182747e+00, -2.146493341925e+00, -2.209415316049e+00, -2.322193171550e+00, -2.465386396172e+00, -2.652062891079e+00, -2.902620644360e+00, -3.208146404352e+00, -3.568548658563e+00, -4.017458003833e+00, -4.593583932889e+00, -5.316366957985e+00, -6.110376618800e+00, -6.890140952473e+00],
        [-2.128970043400e+00, -2.181514547394e+00, -2.228518352283e+00, -2.303225652692e+00, -2.430644167120e+00, -2.590219991515e+00, -2.795769448365e+00, -3.068858753850e+00, -3.400064178955e+00, -3.789288970108e+00, -4.272089806655e+00, -4.889393140985e+00, -5.661752877147e+00, -6.509418521768e+00, -7.342022984697e+00]],
       [[-1.638884585964e+00, -1.606605310936e+00, -1.571190552139e+00, -1.551453212209e+00, -1.561545168762e+00, -1.589834959510e+00, -1.644141246723e+00, -1.736668360504e+00, -1.862083408942e+00, -2.020331639160e+00, -2.231534589803e+00, -2.518852556169e+00, -2.893917000548e+00, -3.311597087768e+00, -3.720754046411e+00],
        [-1.678423595042e+00, -1.652987714605e+00, -1.624222302954e+00, -1.612104547395e+00, -1.631662150737e+00, -1.670543807857e+00, -1.737052058966e+00, -1.844146530395e+00, -1.986164290560e+00, -2.163047198059e+00, -2.396162064498e+00, -2.710102519374e+00, -3.117219867812e+00, -3.569590237307e+00, -4.012910002583e+00],
        [-1.717962604120e+00, -1.699370118274e+00, -1.677254053770e+00, -1.672755882581e+00, -1.701779132712e+00, -1.751252656205e+00, -1.829962871209e+00, -1.951624700286e+00, -2.110245172177e+00, -2.305762756958e+00, -2.560789539192e+00, -2.901352482578e+00, -3.340522735076e+00, -3.827583386847e+00, -4.305065958754e+00]],
       [[-1.009575710799e+00, -8.683759278134e-01, -7.271291496804e-01, -5.861173473554e-01, -4.455526315954e-01, -3.052606680763e-01, -1.653586442262e-01, -2.602948062296e-02,  1.128067530227e-01,  2.511508773570e-01,  3.887013073421e-01,  5.251109125533e-01,  6.602053585984e-01,  7.946610741703e-01,  9.292445358312e-01],
        [-1.010169588630e+00, -8.690725937624e-01, -7.279256891462e-01, -5.870283333472e-01, -4.466057920602e-01, -3.064729188867e-01, -1.667541691254e-01, -2.764380793933e-02,  1.109430521725e-01,  2.490072827515e-01,  3.862285947000e-01,  5.222383288458e-01,  6.568513387198e-01,  7.907860045723e-01,  9.248563392232e-01],
        [-1.010763466461e+00, -8.697692597114e-01, -7.287222286119e-01, -5.879393193390e-01, -4.476589525250e-01, -3.076851696971e-01, -1.681496940246e-01, -2.925813525570e-02,  1.090793513223e-01,  2.468636881459e-01,  3.837558820579e-01,  5.193657451382e-01,  6.534973188413e-01,  7.869109349743e-01,  9.204681426151e-01]],
       [[-4.274862397334e-01, -1.855386628431e-01,  5.359916147394e-02,  3.067857486240e-01,  5.867028017756e-01,  8.829271985457e-01,  1.202465355812e+00,  1.556253751106e+00,  1.939513502500e+00,  2.352195545131e+00,  2.812331082171e+00,  3.340674390715e+00,  3.947648593141e+00,  4.592811292288e+00,  5.230336292115e+00],
        [-3.892350039831e-01, -1.406669197517e-01,  1.049036845267e-01,  3.654616885350e-01,  6.545360952808e-01,  9.610073846031e-01,  1.292350091565e+00,  1.660231390163e+00,  2.059553108087e+00,  2.490262902308e+00,  2.971596690807e+00,  3.525695401624e+00,  4.163678554914e+00,  4.842401684545e+00,  5.512976818932e+00],
        [-3.509837682328e-01, -9.579517666029e-02,  1.562082075794e-01,  4.241376284459e-01,  7.223693887860e-01,  1.039087570660e+00,  1.382234827319e+00,  1.764209029221e+00,  2.179592713673e+00,  2.628330259486e+00,  3.130862299444e+00,  3.710716412533e+00,  4.379708516688e+00,  5.091992076802e+00,  5.795617345748e+00]],
       [[-2.293236835992e-01,  4.692178278681e-02,  3.193849649846e-01,  6.107595682455e-01,  9.381167774996e-01,  1.287425744766e+00,  1.668117997990e+00,  2.094915426514e+00,  2.561385047626e+00,  3.067460813793e+00,  3.637415017139e+00,  4.299185553541e+00,  5.066803271038e+00,  5.885827560780e+00,  6.694570536066e+00],
        [-1.766959477528e-01,  1.086583043929e-01,  3.899719887491e-01,  6.914885121757e-01,  1.031444812062e+00,  1.394851905674e+00,  1.791785378586e+00,  2.237972444539e+00,  2.726540827038e+00,  3.257419968312e+00,  3.856539660205e+00,  4.553745614074e+00,  5.364026812709e+00,  6.229225021692e+00,  7.083439828599e+00],
        [-1.240682119064e-01,  1.703948259990e-01,  4.605590125136e-01,  7.722174561059e-01,  1.124772846625e+00,  1.502278066582e+00,  1.915452759183e+00,  2.381029462565e+00,  2.891696606450e+00,  3.447379122832e+00,  4.075664303271e+00,  4.808305674606e+00,  5.661250354379e+00,  6.572622482605e+00,  7.472309121132e+00]],
       [[-3.517779530457e-01, -9.672681863052e-02,  1.551430061014e-01,  4.229193791764e-01,  7.209610114938e-01,  1.037466443998e+00,  1.380368610690e+00,  1.762050211057e+00,  2.177100411644e+00,  2.625463659305e+00,  3.127555574150e+00,  3.706874945050e+00,  4.375223231099e+00,  5.086809998461e+00,  5.789749069540e+00],
        [-3.054763782624e-01, -4.241138730808e-02,  2.172450575575e-01,  4.939442327908e-01,  8.030704714982e-01,  1.131979353263e+00,  1.489170450229e+00,  1.887910940418e+00,  2.322403502272e+00,  2.792588614562e+00,  3.320340155977e+00,  3.930835400309e+00,  4.636718768014e+00,  5.388929079983e+00,  6.131874003081e+00],
        [-2.591748034791e-01,  1.190404401435e-02,  2.793471090136e-01,  5.649690864051e-01,  8.851799315026e-01,  1.226492262528e+00,  1.597972289768e+00,  2.013771669780e+00,  2.467706592899e+00,  2.959713569820e+00,  3.513124737804e+00,  4.154795855568e+00,  4.898214304929e+00,  5.691048161505e+00,  6.473998936622e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.055594614830e+01, -1.100933521603e+01, -1.146272428375e+01],
        [-1.112678533228e+01, -1.158017440000e+01, -1.203356346773e+01],
        [-1.169762451626e+01, -1.215101358398e+01, -1.260440265170e+01]],
       [[-6.551589688007e+00, -6.827516696379e+00, -7.103443704750e+00],
        [-6.931090912403e+00, -7.207017920774e+00, -7.482944929145e+00],
        [-7.310592136799e+00, -7.586519145170e+00, -7.862446153541e+00]],
       [[-7.352914927744e-01, -7.538388097023e-01, -7.723861266302e-01],
        [-8.243371503653e-01, -8.428844672932e-01, -8.614317842211e-01],
        [-9.133828079562e-01, -9.319301248841e-01, -9.504774418120e-01]],
       [[ 6.738097385401e+00,  7.049934044078e+00,  7.361770702754e+00],
        [ 7.032889582425e+00,  7.344726241101e+00,  7.656562899778e+00],
        [ 7.327681779448e+00,  7.639518438125e+00,  7.951355096801e+00]],
       [[ 1.029757904416e+01,  1.076645769278e+01,  1.123533634141e+01],
        [ 1.078553563723e+01,  1.125441428586e+01,  1.172329293449e+01],
        [ 1.127349223031e+01,  1.174237087893e+01,  1.221124952756e+01]],
       [[ 9.742218055085e+00,  1.018635632952e+01,  1.063049460397e+01],
        [ 1.020784247121e+01,  1.065198074565e+01,  1.109611902009e+01],
        [ 1.067346688734e+01,  1.111760516178e+01,  1.156174343622e+01]],
       [[ 4.626945288569e+00,  4.845143859865e+00,  5.063342431161e+00],
        [ 4.823405489955e+00,  5.041604061251e+00,  5.259802632547e+00],
        [ 5.019865691341e+00,  5.238064262637e+00,  5.456262833933e+00]],
       [[-1.291673185192e+00, -1.334365809721e+00, -1.377058434251e+00],
        [-1.424081618924e+00, -1.466774243454e+00, -1.509466867983e+00],
        [-1.556490052657e+00, -1.599182677187e+00, -1.641875301716e+00]],
       [[-5.854303731803e+00, -6.097847117230e+00, -6.341390502656e+00],
        [-6.249044470900e+00, -6.492587856326e+00, -6.736131241752e+00],
        [-6.643785209996e+00, -6.887328595423e+00, -7.130871980849e+00]],
       [[-6.622914307995e+00, -6.899897389614e+00, -7.176880471234e+00],
        [-7.074796340219e+00, -7.351779421839e+00, -7.628762503459e+00],
        [-7.526678372444e+00, -7.803661454064e+00, -8.080644535684e+00]],
       [[-3.823220902897e+00, -3.976921187625e+00, -4.130621472354e+00],
        [-4.115376859068e+00, -4.269077143797e+00, -4.422777428525e+00],
        [-4.407532815240e+00, -4.561233099969e+00, -4.714933384697e+00]],
       [[ 9.671094138097e-01,  1.023906730778e+00,  1.080704047745e+00],
        [ 9.627212172017e-01,  1.019518534170e+00,  1.076315851137e+00],
        [ 9.583330205937e-01,  1.015130337562e+00,  1.071927654529e+00]],
       [[ 5.397565682164e+00,  5.648409767236e+00,  5.899253852309e+00],
        [ 5.680206208980e+00,  5.931050294053e+00,  6.181894379125e+00],
        [ 5.962846735796e+00,  6.213690820869e+00,  6.464534905941e+00]],
       [[ 6.905661214684e+00,  7.222297232613e+00,  7.538933250541e+00],
        [ 7.294530507218e+00,  7.611166525146e+00,  7.927802543075e+00],
        [ 7.683399799751e+00,  8.000035817680e+00,  8.316671835608e+00]],
       [[ 5.973339119563e+00,  6.248724194597e+00,  6.524109269631e+00],
        [ 6.315464053104e+00,  6.590849128138e+00,  6.866234203172e+00],
        [ 6.657588986645e+00,  6.932974061679e+00,  7.208359136713e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x sup
            [  # y inf
                np.array([  # z inf
       [[-1.135305826782e+00, -1.075305826782e+00, -1.015305826782e+00],
        [-1.144566141739e+00, -1.084566141739e+00, -1.024566141739e+00],
        [-1.153826456696e+00, -1.093826456696e+00, -1.033826456696e+00]],
       [[-1.135305826782e+00, -1.075305826782e+00, -1.015305826782e+00],
        [-1.144566141739e+00, -1.084566141739e+00, -1.024566141739e+00],
        [-1.153826456696e+00, -1.093826456696e+00, -1.033826456696e+00]],
       [[-1.135305826782e+00, -1.075305826782e+00, -1.015305826782e+00],
        [-1.144566141739e+00, -1.084566141739e+00, -1.024566141739e+00],
        [-1.153826456696e+00, -1.093826456696e+00, -1.033826456696e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.753058267824e-01, -8.281746271046e-01, -6.811646201761e-01, -5.335486495012e-01, -3.847797165691e-01, -2.353074007730e-01, -8.482949510319e-02,  6.712572232612e-02,  2.203521245251e-01,  3.748475951849e-01,  5.313898722125e-01,  6.908741475666e-01,  8.537500006405e-01,  1.018273033955e+00,  1.182466631221e+00],
        [-9.845661417390e-01, -8.390377133690e-01, -6.935850304672e-01, -5.477536202239e-01, -4.012016085700e-01, -2.542099826260e-01, -1.065898630109e-01,  4.195357645383e-02,  1.912915063996e-01,  3.414226041334e-01,  4.928329558471e-01,  6.460820565149e-01,  8.014508932574e-01,  9.578492176504e-01,  1.114041644513e+00],
        [-9.938264566956e-01, -8.499007996333e-01, -7.060054407583e-01, -5.619585909467e-01, -4.176235005708e-01, -2.731125644790e-01, -1.283502309187e-01,  1.678143058153e-02,  1.622308882741e-01,  3.079976130819e-01,  4.542760394817e-01,  6.012899654631e-01,  7.491517858744e-01,  8.974254013459e-01,  1.045616657805e+00]],
       [[-9.753058267824e-01, -8.281746271046e-01, -6.811646201761e-01, -5.335486495012e-01, -3.847797165691e-01, -2.353074007730e-01, -8.482949510319e-02,  6.712572232612e-02,  2.203521245251e-01,  3.748475951849e-01,  5.313898722125e-01,  6.908741475666e-01,  8.537500006405e-01,  1.018273033955e+00,  1.182466631221e+00],
        [-9.845661417390e-01, -8.390377133690e-01, -6.935850304672e-01, -5.477536202239e-01, -4.012016085700e-01, -2.542099826260e-01, -1.065898630109e-01,  4.195357645383e-02,  1.912915063996e-01,  3.414226041334e-01,  4.928329558471e-01,  6.460820565149e-01,  8.014508932574e-01,  9.578492176504e-01,  1.114041644513e+00],
        [-9.938264566956e-01, -8.499007996333e-01, -7.060054407583e-01, -5.619585909467e-01, -4.176235005708e-01, -2.731125644790e-01, -1.283502309187e-01,  1.678143058153e-02,  1.622308882741e-01,  3.079976130819e-01,  4.542760394817e-01,  6.012899654631e-01,  7.491517858744e-01,  8.974254013459e-01,  1.045616657805e+00]],
       [[-9.753058267824e-01, -8.281746271046e-01, -6.811646201761e-01, -5.335486495012e-01, -3.847797165691e-01, -2.353074007730e-01, -8.482949510319e-02,  6.712572232612e-02,  2.203521245251e-01,  3.748475951849e-01,  5.313898722125e-01,  6.908741475666e-01,  8.537500006405e-01,  1.018273033955e+00,  1.182466631221e+00],
        [-9.845661417390e-01, -8.390377133690e-01, -6.935850304672e-01, -5.477536202239e-01, -4.012016085700e-01, -2.542099826260e-01, -1.065898630109e-01,  4.195357645383e-02,  1.912915063996e-01,  3.414226041334e-01,  4.928329558471e-01,  6.460820565149e-01,  8.014508932574e-01,  9.578492176504e-01,  1.114041644513e+00],
        [-9.938264566956e-01, -8.499007996333e-01, -7.060054407583e-01, -5.619585909467e-01, -4.176235005708e-01, -2.731125644790e-01, -1.283502309187e-01,  1.678143058153e-02,  1.622308882741e-01,  3.079976130819e-01,  4.542760394817e-01,  6.012899654631e-01,  7.491517858744e-01,  8.974254013459e-01,  1.045616657805e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.222466631221e+00,  1.282466631221e+00,  1.342466631221e+00],
        [ 1.154041644513e+00,  1.214041644513e+00,  1.274041644513e+00],
        [ 1.085616657805e+00,  1.145616657805e+00,  1.205616657805e+00]],
       [[ 1.222466631221e+00,  1.282466631221e+00,  1.342466631221e+00],
        [ 1.154041644513e+00,  1.214041644513e+00,  1.274041644513e+00],
        [ 1.085616657805e+00,  1.145616657805e+00,  1.205616657805e+00]],
       [[ 1.222466631221e+00,  1.282466631221e+00,  1.342466631221e+00],
        [ 1.154041644513e+00,  1.214041644513e+00,  1.274041644513e+00],
        [ 1.085616657805e+00,  1.145616657805e+00,  1.205616657805e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.195103657594e+00, -1.138432841088e+00, -1.081762024582e+00],
        [-1.222199906928e+00, -1.168067180809e+00, -1.113934454691e+00],
        [-1.218267449258e+00, -1.163607327735e+00, -1.108947206211e+00],
        [-1.189645482789e+00, -1.132018762112e+00, -1.074392041435e+00],
        [-1.137001291543e+00, -1.074034692390e+00, -1.011068093236e+00],
        [-1.060334875519e+00, -9.896551185671e-01, -9.189753616148e-01],
        [-9.589789507130e-01, -8.781468322124e-01, -7.973147137117e-01],
        [-8.265943188713e-01, -7.325443530312e-01, -6.384943871911e-01],
        [-6.862022787923e-01, -5.781433725060e-01, -4.700844662198e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.196926919758e+00, -1.140256103252e+00, -1.083585286747e+00],
        [-1.225914263238e+00, -1.171781537119e+00, -1.117648811001e+00],
        [-1.224135748644e+00, -1.169475627120e+00, -1.114815505597e+00],
        [-1.197876873862e+00, -1.140250153185e+00, -1.082623432507e+00],
        [-1.147799270248e+00, -1.084832671095e+00, -1.021866071941e+00],
        [-1.073902937802e+00, -1.003223180850e+00, -9.325434238978e-01],
        [-9.755262451855e-01, -8.946941266849e-01, -8.138620081842e-01],
        [-8.463836944620e-01, -7.523337286219e-01, -6.582837627818e-01],
        [-7.093015674839e-01, -6.012426611976e-01, -4.931837549114e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.198750181922e+00, -1.142079365416e+00, -1.085408548911e+00],
        [-1.229628619548e+00, -1.175495893429e+00, -1.121363167311e+00],
        [-1.230004048030e+00, -1.175343926506e+00, -1.120683804982e+00],
        [-1.206108264934e+00, -1.148481544257e+00, -1.090854823580e+00],
        [-1.158597248953e+00, -1.095630649800e+00, -1.032664050646e+00],
        [-1.087471000085e+00, -1.016791243133e+00, -9.461114861808e-01],
        [-9.920735396580e-01, -9.112414211573e-01, -8.304093026567e-01],
        [-8.661730700527e-01, -7.721231042126e-01, -6.780731383725e-01],
        [-7.324008561755e-01, -6.243419498893e-01, -5.162830436030e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.269503924963e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.043981480245e+00, -9.087366329679e-01, -7.732759357219e-01, -6.388944883180e-01, -5.065665207486e-01, -3.754913110371e-01, -2.462071040359e-01, -1.195540585398e-01,  4.834947284104e-03,  1.269636826814e-01,  2.454469599764e-01,  3.586904003211e-01,  4.658932817385e-01,  5.701624579222e-01,  6.750183751527e-01],
        [-1.077845970611e+00, -9.484623746806e-01, -8.186967304375e-01, -6.908413277555e-01, -5.666205260458e-01, -4.446170701560e-01, -3.257836381849e-01, -2.116072873317e-01, -1.014382223819e-01,  4.730228122465e-03,  1.044463213457e-01,  1.948880520198e-01,  2.746381649928e-01,  3.491957030424e-01,  4.247917560764e-01],
        [-1.072507125195e+00, -9.421994842083e-01, -8.115359966111e-01, -6.826517420675e-01, -5.571528196826e-01, -4.337191727346e-01, -3.132381425930e-01, -1.970948008511e-01, -8.468391665820e-02,  2.400072390015e-02,  1.266755238271e-01,  2.207120170934e-01,  3.047901469775e-01,  3.840318199819e-01,  4.642407843626e-01],
        [-1.035974227650e+00, -8.993434885563e-01, -7.625361970626e-01, -6.266116675697e-01, -4.923667621056e-01, -3.591465378510e-01, -2.273912469924e-01, -9.778808931452e-02,  2.996321894584e-02,  1.558657608066e-01,  2.787865353659e-01,  3.974214358206e-01,  5.111155193494e-01,  6.224100069726e-01,  7.341844137763e-01],
        [-9.690903604674e-01, -8.208833905677e-01, -6.728281173524e-01, -5.240143607163e-01, -3.737574438887e-01, -2.226201043557e-01, -7.022407030241e-02,  8.402111146520e-02,  2.398574322707e-01,  3.972822431346e-01,  5.572690367978e-01,  7.209383229653e-01,  8.888528391252e-01,  1.058829126984e+00,  1.228393060504e+00],
        [-8.718555236465e-01, -7.068191902429e-01, -5.424117574813e-01, -3.748598215080e-01, -2.013248650311e-01, -2.413987224857e-02,  1.582633874777e-01,  3.483328014885e-01,  5.449987233169e-01,  7.482501708850e-01,  9.621230281233e-01,  1.191262678530e+00,  1.438002106306e+00,  1.693289180018e+00,  1.946866724542e+00],
        [-7.434266347113e-01, -5.561618847441e-01, -3.701563319026e-01, -1.778547935066e-01,  2.642606503873e-02,  2.380150973187e-01,  4.600522452650e-01,  6.974387165631e-01,  9.480328442441e-01,  1.211812639756e+00,  1.496858828501e+00,  1.812472487740e+00,  2.163324763881e+00,  2.531291303093e+00,  2.895834989713e+00],
        [-5.757944099644e-01, -3.595159470376e-01, -1.453193777616e-01,  7.928665965454e-02,  3.236987067755e-01,  5.801937234245e-01,  8.539631327930e-01,  1.153110346911e+00,  1.474094440562e+00,  1.816879058994e+00,  2.194824470010e+00,  2.623308610351e+00,  3.110054520194e+00,  3.625096298016e+00,  4.134478902248e+00],
        [-3.980451953623e-01, -1.510019752376e-01,  9.308700311399e-02,  3.519471902594e-01,  6.389124353860e-01,  9.430236157464e-01,  1.271647447360e+00,  1.636282807016e+00,  2.031905062784e+00,  2.458462626657e+00,  2.934913941460e+00,  3.483080555738e+00,  4.113921592271e+00,  4.784914937252e+00,  5.447877820521e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.285945850295e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.045804742409e+00, -9.108754645587e-01, -7.757213886306e-01, -6.416913030896e-01, -5.097998248520e-01, -3.792130378312e-01, -2.504914999412e-01, -1.245101989488e-01, -8.867939029304e-04,  1.203826406970e-01,  2.378554939084e-01,  3.498712915493e-01,  4.555961175328e-01,  5.582656208717e-01,  6.615461887395e-01],
        [-1.081560326921e+00, -9.528196101744e-01, -8.236786159947e-01, -6.965390089774e-01, -5.732074249215e-01, -4.521989855131e-01, -3.345118251013e-01, -2.217039545936e-01, -1.130945743325e-01, -8.676694536818e-03,  8.898095906948e-02,  1.769217315636e-01,  2.536607446323e-01,  3.249594233459e-01,  3.973461689305e-01],
        [-1.078375424581e+00, -9.490834663138e-01, -8.194068613089e-01, -6.916534899949e-01, -5.675594396728e-01, -4.456978160095e-01, -3.270277765554e-01, -2.130464924355e-01, -1.030997489811e-01,  2.819170640007e-03,  1.022418485486e-01,  1.923270861659e-01,  2.716479891596e-01,  3.457410009578e-01,  4.208795909954e-01],
        [-1.044205618723e+00, -9.089995652357e-01, -7.735765617658e-01, -6.392383082122e-01, -5.069639994398e-01, -3.759488328314e-01, -2.467337962437e-01, -1.201633300899e-01,  4.131558389848e-03,  1.261546576498e-01,  2.445137208189e-01,  3.576062437746e-01,  4.646274238978e-01,  5.686999480352e-01,  6.733622033692e-01],
        [-9.798883391724e-01, -8.335502787569e-01, -6.873109212806e-01, -5.405780491100e-01, -3.929061705736e-01, -2.446614363486e-01, -9.559772015997e-02,  5.466916216750e-02,  2.059713347521e-01,  3.583070740093e-01,  5.123097925612e-01,  6.687085610626e-01,  8.278695301928e-01,  9.883720113472e-01,  1.148606190098e+00],
        [-8.854235859296e-01, -7.227356068780e-01, -5.606099398542e-01, -3.956727126892e-01, -2.253859530738e-01, -5.183562656084e-02,  1.263804516966e-01,  3.114509843371e-01,  5.024195801064e-01,  6.992764197197e-01,  9.056300637759e-01,  1.125634038033e+00,  1.361374308045e+00,  1.604757190897e+00,  1.846611551179e+00],
        [-7.599739291838e-01, -5.755731777870e-01, -3.923504135855e-01, -2.032377134854e-01, -2.918280591300e-03,  2.042379968992e-01,  4.211685553173e-01,  6.524585066895e-01,  8.961043074810e-01,  1.152085387255e+00,  1.427961317776e+00,  1.732433317999e+00,  2.069871276116e+00,  2.423319739900e+00,  2.773566102573e+00],
        [-5.955837855551e-01, -3.827304591966e-01, -1.718619052456e-01,  4.893051062421e-02,  2.886049772165e-01,  5.397987375430e-01,  8.074610326439e-01,  1.099317246846e+00,  1.411991640637e+00,  1.745449555231e+00,  2.112427996115e+00,  2.527587512583e+00,  2.998290861624e+00,  3.495970064073e+00,  3.988254095845e+00],
        [-4.211444840539e-01, -1.780992788258e-01,  6.210505008892e-02,  3.165137604982e-01,  5.979490312286e-01,  8.958722826343e-01,  1.217367541904e+00,  1.573492430315e+00,  1.959415130121e+00,  2.375086032941e+00,  2.838736074254e+00,  3.371349427028e+00,  3.983464670944e+00,  4.634191426960e+00,  5.277195880532e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.302387775628e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.047628004574e+00, -9.130142961496e-01, -7.781668415392e-01, -6.444881178612e-01, -5.130331289553e-01, -3.829347646252e-01, -2.547758958466e-01, -1.294663393579e-01, -6.608535089965e-03,  1.138015987126e-01,  2.302640278405e-01,  3.410521827775e-01,  4.452989533270e-01,  5.463687838211e-01,  6.480740023263e-01],
        [-1.085274683231e+00, -9.571768456681e-01, -8.286605015519e-01, -7.022366901994e-01, -5.797943237971e-01, -4.597809008702e-01, -3.432400120177e-01, -2.318006218555e-01, -1.247509262830e-01, -2.208361719610e-02,  7.351559679323e-02,  1.589554111073e-01,  2.326833242717e-01,  3.007231436495e-01,  3.699005817845e-01],
        [-1.084243723967e+00, -9.559674484194e-01, -8.272777260068e-01, -7.006552379224e-01, -5.779660596630e-01, -4.576764592844e-01, -3.408174105179e-01, -2.289981840199e-01, -1.215155813040e-01, -1.836238262014e-02,  7.780817327002e-02,  1.639421552385e-01,  2.385058313416e-01,  3.074501819336e-01,  3.775183976282e-01],
        [-1.052437009795e+00, -9.186556419151e-01, -7.846169264690e-01, -6.518649488546e-01, -5.215612367739e-01, -3.927511278118e-01, -2.660763454950e-01, -1.425385708653e-01, -2.170010216614e-02,  9.644355449292e-02,  2.102409062719e-01,  3.177910517286e-01,  4.181393284462e-01,  5.149898890979e-01,  6.125399929621e-01],
        [-9.906863178773e-01, -8.462171669461e-01, -7.017937252088e-01, -5.571417375037e-01, -4.120548972586e-01, -2.667027683415e-01, -1.209713700175e-01,  2.531721286979e-02,  1.720852372336e-01,  3.193319048840e-01,  4.673505483246e-01,  6.164787991600e-01,  7.668862212604e-01,  9.179148957107e-01,  1.068819319692e+00],
        [-8.989916482126e-01, -7.386520235130e-01, -5.788081222272e-01, -4.164856038705e-01, -2.494470411165e-01, -7.953138087311e-02,  9.449751591542e-02,  2.745691671857e-01,  4.598404368959e-01,  6.503026685543e-01,  8.491370994285e-01,  1.060005397535e+00,  1.284746509785e+00,  1.516225201775e+00,  1.746356377816e+00],
        [-7.765212236563e-01, -5.949844708298e-01, -4.145444952683e-01, -2.286206334641e-01, -3.226262622133e-02,  1.704608964797e-01,  3.822848653696e-01,  6.074782968159e-01,  8.441757707178e-01,  1.092358134753e+00,  1.359063807052e+00,  1.652394148259e+00,  1.976417788352e+00,  2.315348176707e+00,  2.651297215434e+00],
        [-6.153731611458e-01, -4.059449713556e-01, -1.984044327297e-01,  1.857436159388e-02,  2.535112476575e-01,  4.994037516616e-01,  7.609589324948e-01,  1.045524146780e+00,  1.349888840712e+00,  1.674020051469e+00,  2.030031522220e+00,  2.431866414814e+00,  2.886527203054e+00,  3.366843830130e+00,  3.842029289442e+00],
        [-4.442437727455e-01, -2.051965824139e-01,  3.112309706385e-02,  2.810803307370e-01,  5.569856270713e-01,  8.487209495223e-01,  1.163087636448e+00,  1.510702053614e+00,  1.886925197458e+00,  2.291709439225e+00,  2.742558207048e+00,  3.259618298319e+00,  3.853007749617e+00,  4.483467916668e+00,  5.106513940543e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.050714649659e-01,  7.501510996859e-01,  7.952307344058e-01],
        [ 4.472615579256e-01,  4.809662606993e-01,  5.146709634730e-01],
        [ 4.882863343602e-01,  5.243546593565e-01,  5.604229843528e-01],
        [ 7.670935471086e-01,  8.164572471071e-01,  8.658209471056e-01],
        [ 1.277256643838e+00,  1.350552018841e+00,  1.423847393843e+00],
        [ 2.018775624547e+00,  2.126638974554e+00,  2.234502324562e+00],
        [ 2.998077041575e+00,  3.151440119369e+00,  3.304803197163e+00],
        [ 4.276213142079e+00,  4.488814501825e+00,  4.701415861572e+00],
        [ 5.631467870543e+00,  5.906852945577e+00,  6.182238020612e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.915992785527e-01,  7.366789132727e-01,  7.817585479926e-01],
        [ 4.198159707796e-01,  4.535206735533e-01,  4.872253763270e-01],
        [ 4.449251409930e-01,  4.809934659893e-01,  5.170617909856e-01],
        [ 7.062713367015e-01,  7.556350367000e-01,  8.049987366985e-01],
        [ 1.197469773433e+00,  1.270765148435e+00,  1.344060523437e+00],
        [ 1.918520451184e+00,  2.026383801191e+00,  2.134247151199e+00],
        [ 2.875808154436e+00,  3.029171232230e+00,  3.182534310024e+00],
        [ 4.129988335676e+00,  4.342589695422e+00,  4.555191055169e+00],
        [ 5.460785930555e+00,  5.736171005589e+00,  6.011556080623e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.781270921396e-01,  7.232067268595e-01,  7.682863615794e-01],
        [ 3.923703836336e-01,  4.260750864073e-01,  4.597797891810e-01],
        [ 4.015639476258e-01,  4.376322726221e-01,  4.737005976184e-01],
        [ 6.454491262944e-01,  6.948128262929e-01,  7.441765262913e-01],
        [ 1.117682903027e+00,  1.190978278029e+00,  1.264273653031e+00],
        [ 1.818265277821e+00,  1.926128627828e+00,  2.033991977836e+00],
        [ 2.753539267297e+00,  2.906902345091e+00,  3.060265422884e+00],
        [ 3.983763529273e+00,  4.196364889019e+00,  4.408966248766e+00],
        [ 5.290103990566e+00,  5.565489065600e+00,  5.840874140634e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-6.553345622701e-01, -5.472756559838e-01, -4.392167496976e-01],
        [-6.090329874868e-01, -5.009740812005e-01, -3.929151749143e-01],
        [-5.627314127035e-01, -4.546725064173e-01, -3.466136001310e-01]],
       [[-6.784338509617e-01, -5.703749446755e-01, -4.623160383892e-01],
        [-6.321322761784e-01, -5.240733698922e-01, -4.160144636059e-01],
        [-5.858307013951e-01, -4.777717951089e-01, -3.697128888227e-01]],
       [[-7.015331396533e-01, -5.934742333671e-01, -4.854153270808e-01],
        [-6.552315648700e-01, -5.471726585838e-01, -4.391137522976e-01],
        [-6.089299900868e-01, -5.008710838005e-01, -3.928121775143e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.671774788401e-01, -1.147916876893e-01,  1.344883707514e-01,  3.992970926689e-01,  6.936520753889e-01,  1.006032221923e+00,  1.344182007053e+00,  1.720189959923e+00,  2.128773789869e+00,  2.569879263495e+00,  3.063436996012e+00,  3.632387525911e+00,  4.288251950214e+00,  4.986327658267e+00,  5.675961109548e+00],
        [-3.208759040568e-01, -6.047625636686e-02,  1.965904222075e-01,  4.703219462833e-01,  7.757615353933e-01,  1.100545131188e+00,  1.452983846592e+00,  1.846050689285e+00,  2.274076880496e+00,  2.737004218752e+00,  3.256221577839e+00,  3.856347981169e+00,  4.549747487129e+00,  5.288446739789e+00,  6.018086043089e+00],
        [-2.745743292735e-01, -6.160825044426e-03,  2.586924736636e-01,  5.413467998977e-01,  8.578709953977e-01,  1.195058040453e+00,  1.561785686130e+00,  1.971911418646e+00,  2.419379971124e+00,  2.904129174009e+00,  3.449006159666e+00,  4.080308436428e+00,  4.811243024044e+00,  5.590565821310e+00,  6.360210976630e+00]],
       [[-3.902767675317e-01, -1.418889912775e-01,  1.035064177263e-01,  3.638636629078e-01,  6.526886712316e-01,  9.588808888110e-01,  1.289902101597e+00,  1.657399583222e+00,  2.056283857206e+00,  2.486502669779e+00,  2.967259128806e+00,  3.520656397201e+00,  4.157795028887e+00,  4.835604147975e+00,  5.505279169559e+00],
        [-3.439751927484e-01, -8.757355995504e-02,  1.656084691824e-01,  4.348885165221e-01,  7.347981312360e-01,  1.053393798076e+00,  1.398703941136e+00,  1.783260312584e+00,  2.201586947833e+00,  2.653627625036e+00,  3.160043710633e+00,  3.744616852459e+00,  4.419290565802e+00,  5.137723229497e+00,  5.847404103100e+00],
        [-2.976736179652e-01, -3.325812863260e-02,  2.277105206385e-01,  5.059133701365e-01,  8.169075912404e-01,  1.147906707341e+00,  1.507505780674e+00,  1.909121041945e+00,  2.346890038461e+00,  2.820752580293e+00,  3.352828292460e+00,  3.968577307718e+00,  4.680786102717e+00,  5.439842311018e+00,  6.189529036641e+00]],
       [[-4.133760562234e-01, -1.689862948656e-01,  7.252446470125e-02,  3.284302331466e-01,  6.117252670743e-01,  9.117295556989e-01,  1.235622196141e+00,  1.594609206521e+00,  1.983793924543e+00,  2.403126076063e+00,  2.871081261599e+00,  3.408925268491e+00,  4.027338107560e+00,  4.684880637683e+00,  5.334597229570e+00],
        [-3.670744814401e-01, -1.146708635432e-01,  1.346265161573e-01,  3.994550867609e-01,  6.938347270787e-01,  1.006242464964e+00,  1.344424035680e+00,  1.720469935883e+00,  2.129097015171e+00,  2.570251031320e+00,  3.063865843426e+00,  3.632885723750e+00,  4.288833644475e+00,  4.986999719205e+00,  5.676722163111e+00],
        [-3.207729066568e-01, -6.035543222077e-02,  1.967285676134e-01,  4.704799403753e-01,  7.759441870830e-01,  1.100755374229e+00,  1.453225875219e+00,  1.846330665244e+00,  2.274400105798e+00,  2.737375986577e+00,  3.256650425254e+00,  3.856846179008e+00,  4.550329181389e+00,  5.289118800727e+00,  6.018847096652e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 5.859551159571e+00,  6.134936234605e+00,  6.410321309639e+00],
        [ 6.201676093112e+00,  6.477061168146e+00,  6.752446243180e+00],
        [ 6.543801026652e+00,  6.819186101687e+00,  7.094571176721e+00]],
       [[ 5.688869219582e+00,  5.964254294616e+00,  6.239639369650e+00],
        [ 6.030994153123e+00,  6.306379228157e+00,  6.581764303191e+00],
        [ 6.373119086664e+00,  6.648504161698e+00,  6.923889236732e+00]],
       [[ 5.518187279593e+00,  5.793572354627e+00,  6.068957429661e+00],
        [ 5.860312213134e+00,  6.135697288168e+00,  6.411082363202e+00],
        [ 6.202437146675e+00,  6.477822221709e+00,  6.753207296743e+00]]
                ], dtype=np.float64)
            ]
        ]
                               ]

# Quadratically extrapolated data sampled on self.xsamples_ex,
# self.ysamples_ex and self.zsamples_ex.
# Calculated at (x, y, z) from the formula:
# Pijk(xn, yn, zn) + (x-xn)*dPijk/dx(xn, yn, zn)
#                  + (y-yn)*dPijk/dy(xn, yn, zn)
#                  + (z-zn)*dPijk/dz(xn, yn, zn)
#                  + (x-xn)*(y-yn)*d2Pijk/dxdy(xn, yn, zn)
#                  + (y-yn)*(z-zn)*d2Pijk/dydz(xn, yn, zn)
#                  + (z-zn)*(x-xn)*d2Pijk/dzdx(xn, yn, zn)
#                  + 0.5*(x-xn)**2*d2Pijk/dx2(xn, yn, zn)
#                  + 0.5*(y-yn)**2*d2Pijk/dy2(xn, yn, zn)
#                  + 0.5*(z-zn)**2*d2Pijk/dz2(xn, yn, zn)
# where (xn, yn, zn) is the nearest coordinates in the
# interpolated range form (x, y, z), and Pijk the nearest interpolation
# polynomial.
# NB: this extrapolation is not entirely triquadratic as some higher
# level derivatives are not taken into account.
cubic_quadratic_extrapolated_data = [
        [  # x inf
            [  # y inf
                np.array([  # z inf
       [[-1.113383605640e+00, -1.051092553942e+00, -9.888015022437e-01],
        [-1.133072030172e+00, -1.071640122861e+00, -1.010208215549e+00],
        [-1.150111722728e+00, -1.089538959803e+00, -1.028966196879e+00]],
       [[-1.118587779352e+00, -1.056296727654e+00, -9.940056759564e-01],
        [-1.136324638742e+00, -1.074892731431e+00, -1.013460824120e+00],
        [-1.151412766156e+00, -1.090840003231e+00, -1.030267240307e+00]],
       [[-1.123791953065e+00, -1.061500901367e+00, -9.992098496692e-01],
        [-1.139577247313e+00, -1.078145340001e+00, -1.016713432690e+00],
        [-1.152713809584e+00, -1.092141046659e+00, -1.031568283735e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.472741344451e-01, -7.952912215808e-01, -6.435670739138e-01, -4.905491002602e-01, -3.350693744992e-01, -1.780878179219e-01, -1.895917198814e-02,  1.433237622277e-01,  3.083208718352e-01,  4.760276381885e-01,  6.481046515800e-01,  8.264632848041e-01,  1.012063459152e+00,  1.201180617168e+00,  1.389594378450e+00],
        [-9.692536106752e-01, -8.210748960510e-01, -6.730470769203e-01, -5.242647803224e-01, -3.740469456271e-01, -2.229533382065e-01, -7.060768409913e-02,  8.357735139234e-02,  2.393451222720e-01,  3.966929935514e-01,  5.565893164394e-01,  7.201486826350e-01,  8.879308575100e-01,  1.057763914774e+00,  1.227186795561e+00],
        [-9.885843549289e-01, -8.437513971599e-01, -6.989744644864e-01, -5.539174063357e-01, -4.083273557340e-01, -2.624121446561e-01, -1.160320685680e-01,  3.103094055694e-02,  1.786815941445e-01,  3.269189138654e-01,  4.761024331136e-01,  6.266459820498e-01,  7.787573926486e-01,  9.316302632417e-01,  1.084350841836e+00]],
       [[-9.524783081578e-01, -8.013961314290e-01, -6.505471791306e-01, -4.985321046798e-01, -3.442982591608e-01, -1.887108172521e-01, -3.118820903226e-02,  1.291773513923e-01,  2.919891913651e-01,  4.572432382417e-01,  6.264361779339e-01,  8.012907260000e-01,  9.826720571187e-01,  1.167223236894e+00,  1.351140446938e+00],
        [-9.725062192456e-01, -8.248904647062e-01, -6.774096426808e-01, -5.292541580846e-01, -3.798149985406e-01, -2.295927127879e-01, -7.825083225170e-02,  7.473584462021e-02,  2.291378219782e-01,  3.849527435847e-01,  5.430465204105e-01,  7.044158333824e-01,  8.695612312394e-01,  1.036540552103e+00,  1.203153088366e+00],
        [-9.898853983571e-01, -8.452776246220e-01, -7.007194907906e-01, -5.559131574406e-01, -4.106345768994e-01, -2.650678944887e-01, -1.190893278290e-01,  2.749433784808e-02,  1.745986740270e-01,  3.222228138787e-01,  4.706853147021e-01,  6.203528423488e-01,  7.714095421404e-01,  9.231409181733e-01,  1.074737358958e+00]],
       [[-9.576824818705e-01, -8.075010412771e-01, -6.575272843475e-01, -5.065151090994e-01, -3.535271438223e-01, -1.993338165824e-01, -4.341724607638e-02,  1.150309405569e-01,  2.756575108950e-01,  4.384588382949e-01,  6.047677042877e-01,  7.761181671959e-01,  9.532806550857e-01,  1.133265856621e+00,  1.312686515426e+00],
        [-9.757588278161e-01, -8.287060333613e-01, -6.817722084414e-01, -5.342435358469e-01, -3.855830514541e-01, -2.362320873693e-01, -8.589398040428e-02,  6.589433784808e-02,  2.189305216843e-01,  3.732124936179e-01,  5.295037243817e-01,  6.886829841299e-01,  8.511916049688e-01,  1.015317189432e+00,  1.179119381171e+00],
        [-9.911864417852e-01, -8.468038520840e-01, -7.024645170948e-01, -5.579089085455e-01, -4.129417980648e-01, -2.677236443212e-01, -1.221465870900e-01,  2.395773513923e-02,  1.705157539094e-01,  3.175267138920e-01,  4.652681962906e-01,  6.140597026478e-01,  7.640616916322e-01,  9.146515731049e-01,  1.065123876080e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.436439566020e+00,  1.506707347374e+00,  1.576975128729e+00],
        [ 1.271465037792e+00,  1.337882401138e+00,  1.404299764485e+00],
        [ 1.126062138728e+00,  1.188629084067e+00,  1.251196029406e+00]],
       [[ 1.397985634508e+00,  1.468253415862e+00,  1.538521197217e+00],
        [ 1.247431330597e+00,  1.313848693943e+00,  1.380266057290e+00],
        [ 1.116448655850e+00,  1.179015601189e+00,  1.241582546528e+00]],
       [[ 1.359531702996e+00,  1.429799484351e+00,  1.500067265705e+00],
        [ 1.223397623402e+00,  1.289814986748e+00,  1.356232350095e+00],
        [ 1.106835172972e+00,  1.169402118311e+00,  1.231969063650e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.194793806142e+00, -1.138780079719e+00, -1.082579807016e+00],
        [-1.244317624587e+00, -1.193769670696e+00, -1.142775228988e+00],
        [-1.350920240706e+00, -1.311571117800e+00, -1.271231158916e+00],
        [-1.502940394759e+00, -1.479351891285e+00, -1.454001901626e+00],
        [-1.699150585722e+00, -1.695761198546e+00, -1.689619489205e+00],
        [-1.939550813594e+00, -1.960799039582e+00, -1.978083921653e+00],
        [-2.225368579400e+00, -2.275816206999e+00, -2.320863166884e+00],
        [-2.568265142880e+00, -2.653645230543e+00, -2.731902920071e+00],
        [-2.925891718664e+00, -3.047683765345e+00, -3.160558288214e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.190880257591e+00, -1.134421872388e+00, -1.077776940904e+00],
        [-1.234104604840e+00, -1.182525712289e+00, -1.130500331920e+00],
        [-1.325162299517e+00, -1.283647176305e+00, -1.241141217113e+00],
        [-1.454280937307e+00, -1.426954706820e+00, -1.397866990148e+00],
        [-1.620431844073e+00, -1.611308139876e+00, -1.599432113515e+00],
        [-1.823615019814e+00, -1.836707475472e+00, -1.845836587214e+00],
        [-2.064859138670e+00, -2.104292877569e+00, -2.138325948754e+00],
        [-2.353936604952e+00, -2.424895903779e+00, -2.488732804473e+00],
        [-2.655358160893e+00, -2.759180897504e+00, -2.854086110302e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.186683931184e+00, -1.129780887201e+00, -1.072691296937e+00],
        [-1.223761880847e+00, -1.171152049635e+00, -1.118095730605e+00],
        [-1.301116652118e+00, -1.257435528599e+00, -1.212763569102e+00],
        [-1.410519647033e+00, -1.379455689534e+00, -1.346630245850e+00],
        [-1.551104697386e+00, -1.536246676169e+00, -1.518636332788e+00],
        [-1.722871803177e+00, -1.727808488505e+00, -1.728781829917e+00],
        [-1.926687132612e+00, -1.955106982811e+00, -1.978126165297e+00],
        [-2.170779283655e+00, -2.227317793648e+00, -2.276733905506e+00],
        [-2.425265453177e+00, -2.511118879718e+00, -2.588054782445e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.722255150993e-20,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.045009321725e+00, -9.099423728058e-01, -7.746545295328e-01, -6.404711580304e-01, -5.083892559197e-01, -3.775893884550e-01, -2.486223792014e-01, -1.223480213554e-01,  1.609386505479e-03,  1.232537017134e-01,  2.411673649369e-01,  3.537187369013e-01,  4.600883828613e-01,  5.634557632771e-01,  6.674235968018e-01],
        [-1.108530885728e+00, -9.844582216344e-01, -8.598529154354e-01, -7.379108197654e-01, -6.210359929557e-01, -5.072525336750e-01, -3.978886416624e-01, -2.950175345001e-01, -1.977332841144e-01, -1.060265893276e-01, -2.331560806633e-02,  4.646529121247e-02,  1.013402071774e-01,  1.489757663558e-01,  1.980591968915e-01],
        [-1.243787388560e+00, -1.143124861480e+00, -1.041265887628e+00, -9.453891476408e-01, -8.608947550320e-01, -7.833443435018e-01, -7.157213803255e-01, -6.626828283290e-01, -6.221937475237e-01, -5.942332451492e-01, -5.864793548734e-01, -6.077696477278e-01, -6.625424900118e-01, -7.335767299062e-01, -8.013586902785e-01],
        [-1.436123305083e+00, -1.368750195254e+00, -1.299236702674e+00, -1.240425123843e+00, -1.201975988646e+00, -1.175949284306e+00, -1.167682282849e+00, -1.185506055175e+00, -1.225780196593e+00, -1.288467331011e+00, -1.387303072234e+00, -1.538097387750e+00, -1.748790290334e+00, -1.988574010590e+00, -2.222539567311e+00],
        [-1.683995948442e+00, -1.659524528524e+00, -1.631696229687e+00, -1.620652325445e+00, -1.641543951323e+00, -1.681918352548e+00, -1.750146263722e+00, -1.859293757390e+00, -2.003651388468e+00, -2.183160537994e+00, -2.419363517701e+00, -2.737055961257e+00, -3.148690623435e+00, -3.605950000440e+00, -4.054084434480e+00],
        [-1.987405318636e+00, -2.015447861292e+00, -2.038644468666e+00, -2.086070752445e+00, -2.179598643063e+00, -2.301251548228e+00, -2.463113322945e+00, -2.684045934973e+00, -2.955807323147e+00, -3.278312866097e+00, -3.682660691274e+00, -4.204645368249e+00, -4.862243489314e+00, -5.585704699458e+00, -6.295993291786e+00],
        [-2.347894102522e+00, -2.438329887987e+00, -2.522150550500e+00, -2.639046827773e+00, -2.818875806341e+00, -3.037097874885e+00, -3.310208546028e+00, -3.663956045573e+00, -4.087089243486e+00, -4.579492624240e+00, -5.183617835400e+00, -5.948327576323e+00, -6.898161458326e+00, -7.937904182897e+00, -8.959665138954e+00],
        [-2.780117825237e+00, -2.945362705699e+00, -3.101871218623e+00, -3.302061569241e+00, -3.585364994659e+00, -3.919372866149e+00, -4.325870245313e+00, -4.838861936857e+00, -5.443488956615e+00, -6.139598747164e+00, -6.983255753330e+00, -8.038991277648e+00, -9.339213948843e+00, -1.075817616568e+01, -1.215339047338e+01],
        [-3.230853790230e+00, -3.474111856578e+00, -3.706421457402e+00, -3.993473385842e+00, -4.384683092664e+00, -4.839435899892e+00, -5.385032970715e+00, -6.064089319931e+00, -6.857983584012e+00, -7.766524577128e+00, -8.859972580629e+00, -1.021919859013e+01, -1.188481728362e+01, -1.369924105151e+01, -1.548390380452e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -6.727559183567e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.039910016427e+00, -9.039604819523e-01, -7.678150792229e-01, -6.326490177682e-01, -4.993463409352e-01, -3.671804513683e-01, -2.366397673922e-01, -1.084866724263e-01,  1.761197007441e-02,  1.416595804281e-01,  2.623992008749e-01,  3.783840477763e-01,  4.888875237764e-01,  5.967288741859e-01,  7.051026497135e-01],
        [-1.095568696219e+00, -9.692525419716e-01, -8.424673607623e-01, -7.180273143623e-01, -5.980493367563e-01, -4.807935148047e-01, -3.674294171198e-01, -2.597826503018e-01, -1.570554841534e-01, -5.923972836617e-02,  3.065470062606e-02,  1.091633285278e-01,  1.745462421997e-01,  2.335544185339e-01,  2.938375423356e-01],
        [-1.212253446553e+00, -1.106133038429e+00, -9.989709441346e-01, -8.970172806928e-01, -8.049736559742e-01, -7.189758071485e-01, -6.416212894690e-01, -5.769646867930e-01, -5.232342789808e-01, -4.804118757544e-01, -4.551823557630e-01, -4.552401486557e-01, -4.844495172628e-01, -5.278168688115e-01, -5.683526237719e-01],
        [-1.377496575598e+00, -1.299976376784e+00, -1.220603520363e+00, -1.150493951975e+00, -1.098009565852e+00, -1.056277700988e+00, -1.029918156162e+00, -1.026142081752e+00, -1.041798441597e+00, -1.076854883959e+00, -1.143200585855e+00, -1.254520228927e+00, -1.417686474183e+00, -1.606032946967e+00, -1.789343374245e+00],
        [-1.589985694739e+00, -1.549243020768e+00, -1.505604846399e+00, -1.476444174020e+00, -1.474829726101e+00, -1.490020288176e+00, -1.529236098433e+00, -1.603747393059e+00, -1.708629448549e+00, -1.843831702688e+00, -2.027935633604e+00, -2.282328895988e+00, -2.617752704305e+00, -2.992530443207e+00, -3.359437395992e+00],
        [-1.849720803977e+00, -1.853932970381e+00, -1.853974922240e+00, -1.874867946830e+00, -1.935434136723e+00, -2.020203568711e+00, -2.139575116282e+00, -2.309780620714e+00, -2.523727299835e+00, -2.781342331942e+00, -3.109387499010e+00, -3.538666149836e+00, -4.084648207629e+00, -4.687309357533e+00, -5.278634689014e+00],
        [-2.158014291925e+00, -2.215585761892e+00, -2.267473990938e+00, -2.347778424590e+00, -2.482150138004e+00, -2.649506450742e+00, -2.864019128475e+00, -3.147809206837e+00, -3.491210518911e+00, -3.894123822012e+00, -4.393020538119e+00, -5.029880006773e+00, -5.825784908411e+00, -6.698933062668e+00, -7.556632566401e+00],
        [-2.527333850416e+00, -2.648826989841e+00, -2.762824361468e+00, -2.914300572087e+00, -3.137087462682e+00, -3.403378561680e+00, -3.731865363289e+00, -4.151723851575e+00, -4.650205078586e+00, -5.227178150676e+00, -5.930746133368e+00, -6.816276621645e+00, -7.911576087079e+00, -9.108753599497e+00, -1.028555550252e+01],
        [-2.912402072271e+00, -3.100542653000e+00, -3.279297648601e+00, -3.504980569839e+00, -3.819952870817e+00, -4.189397570401e+00, -4.636718623296e+00, -5.198447801763e+00, -5.858621919707e+00, -6.617077082848e+00, -7.534044001169e+00, -8.678849432113e+00, -1.008631035681e+01, -1.162133460902e+01, -1.313084619573e+01]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01, -1.076409469371e-21,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.034527933273e+00, -8.976468701738e-01, -7.605963527212e-01, -6.243931070365e-01, -4.898019584054e-01, -3.561942950839e-01, -2.239926695248e-01, -9.385665358988e-02,  3.450196398799e-02,  1.610861422783e-01,  2.848084311234e-01,  4.044171535407e-01,  5.192836977865e-01,  6.318471185815e-01,  7.448711640667e-01],
        [-1.082476802464e+00, -9.538947089071e-01, -8.249078400881e-01, -6.979448475810e-01, -5.748326679556e-01, -4.540697376458e-01, -3.366654068177e-01, -2.241951934066e-01, -1.159706477577e-01, -1.198470154787e-02,  8.516505529067e-02,  1.724887445508e-01,  2.484848026664e-01,  3.189793945806e-01,  3.905742797351e-01],
        [-1.182431798337e+00, -1.071149872237e+00, -9.589726170649e-01, -8.512720072542e-01, -7.520890739064e-01, -6.581024838284e-01, -5.715448352833e-01, -4.959010423521e-01, -4.296483119001e-01, -3.727710093864e-01, -3.310147867827e-01, -3.109930049596e-01, -3.160269971098e-01, -3.332297729986e-01, -3.479987921397e-01],
        [-1.323768013290e+00, -1.236948498149e+00, -1.148540011581e+00, -1.068076382148e+00, -1.002729367316e+00, -9.466044823542e-01, -9.036639965101e-01, -8.800927071637e-01, -8.731880607451e-01, -8.829223100949e-01, -9.194924622090e-01, -9.946354770346e-01, -1.114245839301e+00, -1.255452562350e+00, -1.392340013242e+00],
        [-1.505367035998e+00, -1.449978601168e+00, -1.392109952891e+00, -1.346642371852e+00, -1.324770199874e+00, -1.317292780457e+00, -1.330394789612e+00, -1.373730030656e+00, -1.443080108220e+00, -1.538401711974e+00, -1.675611272789e+00, -1.873028922416e+00, -2.139855317354e+00, -2.440391308020e+00, -2.734185379540e+00],
        [-1.727228866460e+00, -1.710240181295e+00, -1.689682440996e+00, -1.686969976365e+00, -1.718211571581e+00, -1.770167378138e+00, -1.851737214590e+00, -1.976813012828e+00, -2.139324454324e+00, -2.339209215024e+00, -2.599371218524e+00, -2.946173341103e+00, -3.392855431271e+00, -3.888046010008e+00, -4.373534891032e+00],
        [-1.990471916002e+00, -2.019045224003e+00, -2.042757546640e+00, -2.090774796098e+00, -2.185036830747e+00, -2.307511228161e+00, -2.470319372330e+00, -2.692381810866e+00, -2.965430885131e+00, -3.289381710945e+00, -3.695428997611e+00, -4.219478482355e+00, -4.879562587602e+00, -5.605714333769e+00, -6.318652551752e+00],
        [-2.305721092226e+00, -2.388857591308e+00, -2.465585941894e+00, -2.574355034961e+00, -2.744087786313e+00, -2.951012381805e+00, -3.211108221241e+00, -3.549317918034e+00, -3.954742368335e+00, -4.427269670877e+00, -5.008023242939e+00, -5.744336964127e+00, -6.659982648589e+00, -7.662724101108e+00, -8.648046400015e+00],
        [-2.634391204368e+00, -2.774413784315e+00, -2.906415186079e+00, -3.078522478759e+00, -3.326938921596e+00, -3.621908968642e+00, -3.983434280779e+00, -4.442735911428e+00, -4.986171284415e+00, -5.613600331200e+00, -6.376497866651e+00, -7.334112437002e+00, -8.516199588197e+00, -9.807305853886e+00, -1.107660829668e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.968337401258e-01,  7.413715262478e-01,  7.864163977329e-01],
        [ 2.129785106079e-01,  2.363688809505e-01,  2.609729310148e-01],
        [-8.160464762798e-01, -8.358336790840e-01, -8.529275104510e-01],
        [-2.278862452902e+00, -2.359356601382e+00, -2.435062533974e+00],
        [-4.163745338456e+00, -4.322002038316e+00, -4.472777150850e+00],
        [-6.470695132942e+00, -6.723769989885e+00, -6.966071361079e+00],
        [-9.211435917162e+00, -9.576858303718e+00, -9.927600153366e+00],
        [-1.249734645875e+01, -1.299714653229e+01, -1.347758592040e+01],
        [-1.592394596999e+01, -1.656380893240e+01, -1.717943155188e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.358413413008e-01,  7.823719498176e-01,  8.294096436976e-01],
        [ 3.118370870710e-01,  3.398478039422e-01,  3.690722005351e-01],
        [-5.765688498396e-01, -5.866487127437e-01, -5.940352042106e-01],
        [-1.834498706303e+00, -1.898241524483e+00, -1.957196126775e+00],
        [-3.451965349358e+00, -3.584522623302e+00, -3.709598309920e+00],
        [-5.428968779004e+00, -5.645492009199e+00, -5.851241753646e+00],
        [-7.775496128203e+00, -8.091557690150e+00, -8.392938715190e+00],
        [-1.058642516008e+01, -1.102159574191e+01, -1.143740563832e+01],
        [-1.351719978749e+01, -1.407652988937e+01, -1.461161964831e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.769384039172e-01,  8.254618348289e-01,  8.744923511038e-01],
        [ 4.116540554896e-01,  4.442851188894e-01,  4.781298620109e-01],
        [-3.497434582740e-01, -3.501159812779e-01, -3.477951328446e-01],
        [-1.426327791767e+00, -1.473319279648e+00, -1.515522551640e+00],
        [-2.809580382295e+00, -2.916438230323e+00, -3.015814491026e+00],
        [-4.499501229857e+00, -4.679472833304e+00, -4.848670951002e+00],
        [-6.504608897148e+00, -6.771309634487e+00, -7.023329834919e+00],
        [-8.905829729776e+00, -9.276370819898e+00, -9.627551224597e+00],
        [-1.140927331475e+01, -1.188807055608e+01, -1.234262745447e+01]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.987267063048e+00, -3.113068450200e+00, -3.229952313541e+00],
        [-3.077122802977e+00, -3.208938200837e+00, -3.331836074884e+00],
        [-3.164329810929e+00, -3.302159219497e+00, -3.431071104251e+00]],
       [[-2.708801353658e+00, -2.816633430740e+00, -2.915547984010e+00],
        [-2.786758866159e+00, -2.900604953949e+00, -3.005533517926e+00],
        [-2.862067646683e+00, -2.981927745180e+00, -3.092870319865e+00]],
       [[-2.470776494324e+00, -2.560639261336e+00, -2.641584504535e+00],
        [-2.536835779396e+00, -2.632712557116e+00, -2.719671811022e+00],
        [-2.600246332493e+00, -2.702137120919e+00, -2.795110385533e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.302920709205e+00, -3.558652086721e+00, -3.803081312523e+00, -4.104021296892e+00, -4.512483838728e+00, -4.986542217679e+00, -5.554379551065e+00, -6.259987516213e+00, -7.084143193229e+00, -8.026649220094e+00, -9.160035610952e+00, -1.056778586947e+01, -1.229182671601e+01, -1.416947973067e+01, -1.601641031170e+01],
        [-3.408813811020e+00, -3.682873120801e+00, -3.945110582338e+00, -4.266457285093e+00, -4.700270656973e+00, -5.202696099498e+00, -5.803212648556e+00, -6.547834810636e+00, -7.416455755857e+00, -8.408869047084e+00, -9.600939779924e+00, -1.107999020383e+01, -1.288987491727e+01, -1.486043520702e+01, -1.679886038150e+01],
        [-3.512058180858e+00, -3.803986981519e+00, -4.083587236712e+00, -4.424830219246e+00, -4.883360314197e+00, -5.413443267481e+00, -6.045821618404e+00, -6.828482105059e+00, -7.740456097050e+00, -8.781528309123e+00, -1.003081549708e+01, -1.157938263660e+01, -1.347296398176e+01, -1.553410763251e+01, -1.756173882214e+01]],
       [[-2.976536839627e+00, -3.175777838153e+00, -3.365318494352e+00, -3.603360862180e+00, -3.933687039466e+00, -4.320312414578e+00, -4.787425822769e+00, -5.372784174439e+00, -6.059888938317e+00, -6.848570723725e+00, -7.801080151953e+00, -8.989068938951e+00, -1.044852169635e+01, -1.203981577512e+01, -1.360474158961e+01],
        [-3.070531714014e+00, -3.286041304747e+00, -3.491389250111e+00, -3.747545422319e+00, -4.100373991590e+00, -4.512179085981e+00, -5.008299848943e+00, -5.628288733453e+00, -6.354862615035e+00, -7.187844047580e+00, -8.192444001617e+00, -9.443721614554e+00, -1.097937275833e+01, -1.265313498188e+01, -1.429927498947e+01],
        [-3.161877856425e+00, -3.393197597980e+00, -3.613907390430e+00, -3.887666928408e+00, -4.262363782693e+00, -4.698639043548e+00, -5.222949747475e+00, -5.876593292468e+00, -6.641524070317e+00, -7.517556806484e+00, -8.572779399467e+00, -9.885562388573e+00, -1.149526468354e+01, -1.324917113778e+01, -1.497423676016e+01]],
       [[-2.690593820106e+00, -2.840343924478e+00, -2.981797022460e+00, -3.164735152392e+00, -3.426606512831e+00, -3.736632339208e+00, -4.115502099374e+00, -4.595510460498e+00, -5.162545712418e+00, -5.816462969986e+00, -6.610507137897e+00, -7.605964171339e+00, -8.833612834878e+00, -1.017402950692e+01, -1.149189257727e+01],
        [-2.772690467064e+00, -2.936649823587e+00, -3.091909264163e+00, -3.290668284468e+00, -3.572193598833e+00, -3.904211800195e+00, -4.308417054231e+00, -4.818672284104e+00, -5.420180503226e+00, -6.112789790707e+00, -6.952330668253e+00, -8.003065188190e+00, -9.297266757581e+00, -1.070971244409e+01, -1.209850930718e+01],
        [-2.852138382047e+00, -3.029848549334e+00, -3.198468890427e+00, -3.412538362495e+00, -3.713083523815e+00, -4.066384547348e+00, -4.495107881446e+00, -5.034634107709e+00, -5.669503072598e+00, -6.399556046476e+00, -7.283125746795e+00, -8.387354303458e+00, -9.745961543504e+00, -1.122811233040e+01, -1.268555440793e+01]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.646843155541e+01, -1.712626313520e+01, -1.775985437205e+01],
        [-1.726885024258e+01, -1.795363474843e+01, -1.861417891134e+01],
        [-1.804969730059e+01, -1.876143473249e+01, -1.944893182145e+01]],
       [[-1.400307425963e+01, -1.458037297887e+01, -1.513343135518e+01],
        [-1.471557627685e+01, -1.531982792215e+01, -1.589983922452e+01],
        [-1.540850666491e+01, -1.603971123627e+01, -1.664667546469e+01]],
       [[-1.183653667358e+01, -1.233330253228e+01, -1.280582804805e+01],
        [-1.246112202087e+01, -1.298484080562e+01, -1.348431924744e+01],
        [-1.306613573899e+01, -1.361680744980e+01, -1.414323881767e+01]]
                ], dtype=np.float64)
            ]
        ],
        [  # x mid
            [  # y inf
                np.array([  # z inf
       [[-1.127261402207e+00, -1.064970350509e+00, -1.002679298811e+00],
        [-1.141745653026e+00, -1.080313745715e+00, -1.018881838404e+00],
        [-1.153581171869e+00, -1.093008408945e+00, -1.032435646020e+00]],
       [[-1.140058695107e+00, -1.078727667810e+00, -1.017396640513e+00],
        [-1.149034955184e+00, -1.088203063123e+00, -1.027371171062e+00],
        [-1.156213290370e+00, -1.095880533546e+00, -1.035547776721e+00]],
       [[-1.155413918840e+00, -1.095111395591e+00, -1.034808872341e+00],
        [-1.157486823064e+00, -1.097297746033e+00, -1.037108669002e+00],
        [-1.159135978741e+00, -1.099060347929e+00, -1.038984717116e+00]],
       [[-1.172403215197e+00, -1.113111993545e+00, -1.053820771894e+00],
        [-1.166535960152e+00, -1.106978946620e+00, -1.047421933087e+00],
        [-1.162127964322e+00, -1.102305158909e+00, -1.042482353496e+00]],
       [[-1.177827241735e+00, -1.118715718582e+00, -1.059604195429e+00],
        [-1.169083432731e+00, -1.109638730760e+00, -1.050194028790e+00],
        [-1.162809935751e+00, -1.103032054963e+00, -1.043254174175e+00]],
       [[-1.174968418078e+00, -1.115601051372e+00, -1.056233684667e+00],
        [-1.167356330941e+00, -1.107751726750e+00, -1.048147122559e+00],
        [-1.162142960233e+00, -1.102301118557e+00, -1.042459276880e+00]],
       [[-1.165000395491e+00, -1.105128791355e+00, -1.045257187219e+00],
        [-1.162259597435e+00, -1.102339844850e+00, -1.042420092265e+00],
        [-1.160557579075e+00, -1.100589678041e+00, -1.040621777007e+00]],
       [[-1.157961451016e+00, -1.098015169820e+00, -1.038068888624e+00],
        [-1.159331850399e+00, -1.099365424652e+00, -1.039398998905e+00],
        [-1.159975117566e+00, -1.099988547267e+00, -1.040001976968e+00]],
       [[-1.154806409917e+00, -1.095059649117e+00, -1.035312888317e+00],
        [-1.158575414390e+00, -1.098733688890e+00, -1.038891963390e+00],
        [-1.160158729033e+00, -1.100222038833e+00, -1.040285348633e+00]],
       [[-1.157613578490e+00, -1.098278341022e+00, -1.038943103554e+00],
        [-1.160653748432e+00, -1.101069225015e+00, -1.041484701598e+00],
        [-1.161119604123e+00, -1.101285794757e+00, -1.041451985390e+00]],
       [[-1.159870460224e+00, -1.100449118410e+00, -1.041027776597e+00],
        [-1.161329921085e+00, -1.101691582452e+00, -1.042053243819e+00],
        [-1.161096321812e+00, -1.101240986359e+00, -1.041385650906e+00]],
       [[-1.160000462704e+00, -1.100009407854e+00, -1.040018353003e+00],
        [-1.160021521461e+00, -1.100027112179e+00, -1.040032702898e+00],
        [-1.160017101493e+00, -1.100019337780e+00, -1.040021574068e+00]],
       [[-1.154737451557e+00, -1.093610138076e+00, -1.032482824594e+00],
        [-1.155254850713e+00, -1.094550279787e+00, -1.033845708861e+00],
        [-1.157519517681e+00, -1.097237689310e+00, -1.036955860940e+00]],
       [[-1.150747689498e+00, -1.088984773088e+00, -1.027221856677e+00],
        [-1.152179972532e+00, -1.091078149775e+00, -1.029976327019e+00],
        [-1.156057055651e+00, -1.095616326548e+00, -1.035175597446e+00]],
       [[-1.148334245549e+00, -1.086411889298e+00, -1.024489533046e+00],
        [-1.150856840477e+00, -1.089655367820e+00, -1.028453895163e+00],
        [-1.155601910994e+00, -1.095121321931e+00, -1.034640732869e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.611519310123e-01, -8.115709811759e-01, -6.621806878253e-01, -5.118371120458e-01, -3.596797335967e-01, -2.064158161359e-01, -5.156993743912e-02,  1.056000000000e-01,  2.647697239149e-01,  4.259359049971e-01,  5.903220551903e-01,  7.593364613265e-01,  9.336863870637e-01,  1.110627603105e+00,  1.287050561085e+00],
        [-9.779272335297e-01, -8.312497457980e-01, -6.846805856150e-01, -5.375697876884e-01, -3.894284200631e-01, -2.406583370902e-01, -9.098941250600e-02,  6.000000000000e-02,  2.121256548218e-01,  3.653856603068e-01,  5.204751936958e-01,  6.781944179615e-01,  8.389451874550e-01,  1.001168280985e+00,  1.163096909708e+00],
        [-9.920538040707e-01, -8.478213370587e-01, -7.036278679643e-01, -5.592394092821e-01, -4.144799455084e-01, -2.694941442096e-01, -1.241847599307e-01,  2.160000000000e-02,  1.677938071644e-01,  3.143959805676e-01,  4.616567840162e-01,  6.098642761804e-01,  7.591631246267e-01,  9.089920097260e-01,  1.058714887495e+00]],
       [[-9.765092889810e-01, -8.295863840200e-01, -6.827787655206e-01, -5.353947147134e-01, -3.869138908757e-01, -2.377639633004e-01, -8.765745293462e-02,  6.385437290063e-02,  2.165754327448e-01,  3.705037134265e-01,  5.263790500585e-01,  6.850530077213e-01,  8.469532557082e-01,  1.010420409163e+00,  1.173574181523e+00],
        [-9.868165763547e-01, -8.416776522346e-01, -6.966034290196e-01, -5.512057012793e-01, -4.051924441286e-01, -2.588036735237e-01, -1.118780508769e-01,  3.583626093202e-02,  1.842292173428e-01,  3.332996885261e-01,  4.834628836986e-01,  6.351967170116e-01,  7.887412044214e-01,  9.431650683037e-01,  1.097413056891e+00],
        [-9.953259388385e-01, -8.516598114970e-01, -7.080166232641e-01, -5.642587394880e-01, -4.202826254411e-01, -2.761733765653e-01, -1.318737917536e-01,  1.270541552046e-02,  1.575252299737e-01,  3.025852510357e-01,  4.480326873014e-01,  5.940369788218e-01,  7.406832210387e-01,  8.876412380666e-01,  1.034536900132e+00]],
       [[-9.946071901749e-01, -8.508166621255e-01, -7.070526006212e-01, -5.631562063915e-01, -4.190080237688e-01, -2.747062336540e-01, -1.301848389019e-01,  1.465917695196e-02,  1.597807990919e-01,  3.051795653502e-01,  4.510253211632e-01,  5.975135620411e-01,  7.447424688845e-01,  8.923310933709e-01,  1.039847774329e+00],
        [-9.969826176483e-01, -8.536032275587e-01, -7.102386460176e-01, -5.668000217338e-01, -4.232205169299e-01, -2.795550657360e-01, -1.357667414615e-01,  8.202095616231e-03,  1.523262588293e-01,  2.966054895857e-01,  4.411348197221e-01,  5.860236327921e-01,  7.313268629258e-01,  8.768313621015e-01,  1.022295607469e+00],
        [-9.989342965749e-01, -8.558927022298e-01, -7.128563380873e-01, -5.697938229320e-01, -4.266815504588e-01, -2.835389227468e-01, -1.403528977295e-01,  2.896882254995e-03,  1.462015215761e-01,  2.895609289024e-01,  4.330086683440e-01,  5.765833728663e-01,  7.203044445481e-01,  8.640966020528e-01,  1.007874542393e+00]],
       [[-1.014293290792e+00, -8.739100245241e-01, -7.334566104037e-01, -5.933539355432e-01, -4.539186093997e-01, -3.148904098980e-01, -1.764442581674e-01, -3.885319263008e-02,  9.800209554780e-02,  2.341228313119e-01,  3.690588504080e-01,  5.022920047343e-01,  6.335620722155e-01,  7.638787315401e-01,  8.943860724960e-01],
        [-1.007717257399e+00, -8.661958141150e-01, -7.246364964857e-01, -5.832665505824e-01, -4.422569207112e-01, -3.014671073354e-01, -1.609915541628e-01, -2.097768055344e-02,  1.186389309171e-01,  2.578589416234e-01,  3.964392981308e-01,  5.341002410522e-01,  6.707012708506e-01,  8.067875349273e-01,  9.429767521484e-01],
        [-1.002600483221e+00, -8.601934308752e-01, -7.177736160162e-01, -5.754176137230e-01, -4.331830270762e-01, -2.910225119653e-01, -1.489678930741e-01, -7.068846285228e-03,  1.346963351324e-01,  2.763278740422e-01,  4.177438687598e-01,  5.588500488010e-01,  6.995990700552e-01,  8.401746307711e-01,  9.807848835947e-01]],
       [[-1.020196513327e+00, -8.808349742620e-01, -7.413743158235e-01, -6.024092542520e-01, -4.643871607801e-01, -3.269403399146e-01, -1.903159563546e-01, -5.489981517549e-02,  7.947666778484e-02,  2.128152233825e-01,  3.444797665838e-01,  4.737381507334e-01,  6.002226803379e-01,  7.253600379845e-01,  8.507668300227e-01],
        [-1.010564227476e+00, -8.695355365418e-01, -7.284549990539e-01, -5.876336943333e-01, -4.473056296758e-01, -3.072784739216e-01, -1.676815119656e-01, -2.871654758025e-02,  1.097046008631e-01,  2.475828387265e-01,  3.845854478381e-01,  5.203294628968e-01,  6.546225527424e-01,  7.882109748674e-01,  9.219403305365e-01],
        [-1.003402253649e+00, -8.611339713822e-01, -7.188489917158e-01, -5.766474990465e-01, -4.346048564028e-01, -2.926591227300e-01, -1.508519347695e-01, -9.248284270331e-03,  1.321802280300e-01,  2.734338937070e-01,  4.144055594817e-01,  5.549718897769e-01,  6.950709435381e-01,  8.349430561121e-01,  9.748605569235e-01]],
       [[-1.016655440197e+00, -8.766810137261e-01, -7.366248465720e-01, -5.969773828335e-01, -4.581075557364e-01, -3.197121381740e-01, -1.819949592332e-01, -4.527418043296e-02,  9.058922437367e-02,  2.255966825702e-01,  3.592236344930e-01,  4.908663014284e-01,  6.202214562700e-01,  7.484656400435e-01,  8.769320180307e-01],
        [-1.008410719765e+00, -8.670093006477e-01, -7.255666038471e-01, -5.843302954611e-01, -4.434866806210e-01, -3.028826346908e-01, -1.626210879627e-01, -2.286270670234e-02,  1.164627149779e-01,  2.553558978829e-01,  3.935519481234e-01,  5.307459675101e-01,  6.667848314067e-01,  8.022626734265e-01,  9.378527198216e-01],
        [-1.002564715763e+00, -8.601514728009e-01, -7.177256428632e-01, -5.753627478033e-01, -4.331195984198e-01, -2.909495017805e-01, -1.488838448476e-01, -6.971620253634e-03,  1.348085801746e-01,  2.764569762352e-01,  4.178927927327e-01,  5.590230557938e-01,  6.998010724865e-01,  8.404080144446e-01,  9.810491713496e-01]],
       [[-1.005342784462e+00, -8.634103684292e-01, -7.214517313628e-01, -5.796241994629e-01, -4.380461202892e-01, -2.966202236974e-01, -1.554118946227e-01, -1.452319391715e-02,  1.260904756636e-01,  2.664295720001e-01,  4.063258251945e-01,  5.455855532131e-01,  6.841114859116e-01,  8.222810378186e-01,  9.605218658838e-01],
        [-1.002473590542e+00, -8.600445756655e-01, -7.176034210335e-01, -5.752229651816e-01, -4.329580004016e-01, -2.907634927770e-01, -1.486697140806e-01, -6.723916220070e-03,  1.350945483382e-01,  2.767858915827e-01,  4.182722082880e-01,  5.594638279744e-01,  7.003157167252e-01,  8.410026090850e-01,  9.817225007229e-01],
        [-1.000643176318e+00, -8.578973541394e-01, -7.151483754147e-01, -5.724151794224e-01, -4.297120131061e-01, -2.870271668687e-01, -1.443685118945e-01, -1.748334496769e-03,  1.408387340403e-01,  2.833927488375e-01,  4.258934531889e-01,  5.683175312191e-01,  7.106532733309e-01,  8.529461135276e-01,  9.952475341074e-01]],
       [[-9.981047011601e-01, -8.549195207994e-01, -7.117436420855e-01, -5.685212551377e-01, -4.252103773540e-01, -2.818455143361e-01, -1.384034714383e-01,  5.151956396028e-03,  1.488049487448e-01,  2.925553431795e-01,  4.364628317473e-01,  5.805961211939e-01,  7.249897171210e-01,  8.695097355354e-01,  1.014004469452e+00],
        [-9.994213817397e-01, -8.564640918844e-01, -7.135096417409e-01, -5.705409930379e-01, -4.275453288519e-01, -2.845331834432e-01, -1.414974756881e-01,  1.572847502463e-03,  1.446729562912e-01,  2.878028010900e-01,  4.309806053621e-01,  5.742273446797e-01,  7.175535533029e-01,  8.609183576125e-01,  1.004275442785e+00],
        [-1.000010930102e+00, -8.571556790219e-01, -7.143003742999e-01, -5.714453377887e-01, -4.285908116002e-01, -2.857365967420e-01, -1.428828269766e-01, -2.971109703619e-05,  1.428228421325e-01,  2.856748336486e-01,  4.285259192100e-01,  5.713757025881e-01,  7.142239847906e-01,  8.570715379205e-01,  9.999192368648e-01]],
       [[-9.954817144500e-01, -8.518425486840e-01, -7.082255575193e-01, -5.644976933477e-01, -4.205588720138e-01, -2.764913529259e-01, -1.322398413570e-01,  1.228197350634e-02,  1.570363766700e-01,  3.020229809136e-01,  4.473840887113e-01,  5.932834930702e-01,  7.398034533987e-01,  8.866247978073e-01,  1.033385865400e+00],
        [-9.989974797231e-01, -8.559668210900e-01, -7.129410825726e-01, -5.698907434769e-01, -4.267935970622e-01, -2.836678951021e-01, -1.405013687650e-01,  2.725132651268e-03,  1.460032409181e-01,  2.893328701188e-01,  4.327455944233e-01,  5.762777563357e-01,  7.199476076294e-01,  8.636843302283e-01,  1.007407678566e+00],
        [-1.000327555166e+00, -8.575271054153e-01, -7.147250481068e-01, -5.719310285874e-01, -4.291523025034e-01, -2.863829064217e-01, -1.436268489585e-01, -8.903872555707e-04,  1.418292128527e-01,  2.845319794381e-01,  4.272075962180e-01,  5.698441889439e-01,  7.124357941824e-01,  8.550055504451e-01,  9.975796765029e-01]],
       [[-9.993862785757e-01, -8.564229130799e-01, -7.134625595734e-01, -5.704871461202e-01, -4.274830782296e-01, -2.844615292463e-01, -1.414149884544e-01,  1.668267795384e-03,  1.447831166529e-01,  2.879295055217e-01,  4.311267634320e-01,  5.743971384855e-01,  7.177518040270e-01,  8.611474067481e-01,  1.004534822033e+00],
        [-1.001761685986e+00, -8.592094549775e-01, -7.166485780602e-01, -5.741309306866e-01, -4.316955358117e-01, -2.893103203749e-01, -1.469968438690e-01, -4.788759003482e-03,  1.373286393517e-01,  2.793555021743e-01,  4.212363455265e-01,  5.629073062811e-01,  7.043363113772e-01,  8.456478063903e-01,  9.869828034200e-01],
        [-1.001562779145e+00, -8.589761214263e-01, -7.163817939834e-01, -5.738258151621e-01, -4.313428019491e-01, -2.889043025597e-01, -1.465294422673e-01, -4.248074151632e-03,  1.379528466038e-01,  2.800734539304e-01,  4.220645284204e-01,  5.638694175463e-01,  7.054596695236e-01,  8.469456791395e-01,  9.884525372277e-01]],
       [[-1.001413548722e+00, -8.588010622657e-01, -7.161816384708e-01, -5.735969013718e-01, -4.310781623652e-01, -2.885996865389e-01, -1.461787728859e-01, -3.842423803313e-03,  1.384211598706e-01,  2.806120992780e-01,  4.226858749926e-01,  5.645912442603e-01,  7.063024721688e-01,  8.479194118620e-01,  9.895552091982e-01],
        [-1.002294351396e+00, -8.598343138866e-01, -7.173630162811e-01, -5.749480191542e-01, -4.326401444865e-01, -2.903976215697e-01, -1.482485286499e-01, -6.236693708671e-03,  1.356570346442e-01,  2.774328530362e-01,  4.190185013422e-01,  5.603308067057e-01,  7.013279984184e-01,  8.421721495634e-01,  9.830469088220e-01],
        [-1.001482093937e+00, -8.588814712571e-01, -7.162735748358e-01, -5.737020471232e-01, -4.311997178550e-01, -2.887396041924e-01, -1.463398439841e-01, -4.028749016106e-03,  1.382060520334e-01,  2.803646861809e-01,  4.224004751827e-01,  5.642596914423e-01,  7.059153521211e-01,  8.474721523995e-01,  9.890487247581e-01]],
       [[-1.000024316436e+00, -8.571713822574e-01, -7.143183287396e-01, -5.714658719163e-01, -4.286145504190e-01, -2.857639215451e-01, -1.429142828790e-01, -6.609892674838e-05,  1.427808332855e-01,  2.856265158417e-01,  4.284701829008e-01,  5.713109529641e-01,  7.141483833293e-01,  8.569841917105e-01,  9.998203244886e-01],
        [-1.000036430044e+00, -8.571855924826e-01, -7.143345761322e-01, -5.714844537290e-01, -4.286360322317e-01, -2.857886483989e-01, -1.429427480612e-01, -9.902712548831e-05,  1.427428184967e-01,  2.855827919275e-01,  4.284197458101e-01,  5.712523595139e-01,  7.140799697975e-01,  8.569051500809e-01,  9.997308163643e-01],
        [-1.000023064926e+00, -8.571699141360e-01, -7.143166501495e-01, -5.714639521470e-01, -4.286123310378e-01, -2.857613669043e-01, -1.429113420149e-01, -6.269696870673e-05,  1.427847607617e-01,  2.856310331530e-01,  4.284753937800e-01,  5.713170065129e-01,  7.141554514343e-01,  8.569923578514e-01,  9.998295719693e-01]],
       [[-9.917312822734e-01, -8.474429933282e-01, -7.031952851559e-01, -5.587446731193e-01, -4.139079975619e-01, -2.688357978465e-01, -1.234268815000e-01,  2.247670514091e-02,  1.688059415068e-01,  3.155601189624e-01,  4.629996590721e-01,  6.114243122893e-01,  7.609846179766e-01,  9.110964735511e-01,  1.061098019148e+00],
        [-9.933759949104e-01, -8.493723721171e-01, -7.054012582635e-01, -5.612675997114e-01, -4.168246686928e-01, -2.721930611135e-01, -1.272917124750e-01,  1.800591266679e-02,  1.636445224737e-01,  3.096235492636e-01,  4.561516147144e-01,  6.034688465697e-01,  7.516958407353e-01,  9.003646772012e-01,  1.048945145207e+00],
        [-9.967679753599e-01, -8.533514350759e-01, -7.099507567504e-01, -5.664707686322e-01, -4.228398784209e-01, -2.791169280006e-01, -1.352623638907e-01,  8.785553848206e-03,  1.529998468880e-01,  2.973802382417e-01,  4.420285198606e-01,  5.870618563263e-01,  7.325390895227e-01,  8.782319090875e-01,  1.023881611379e+00]],
       [[-9.860465790703e-01, -8.407743841532e-01, -6.955706690930e-01, -5.500245547490e-01, -4.038269600922e-01, -2.572319195648e-01, -1.100686713607e-01,  3.792933055810e-02,  1.866456143167e-01,  3.360789840966e-01,  4.866689000203e-01,  6.389211895196e-01,  7.930898870363e-01,  9.481893223041e-01,  1.103102610022e+00],
        [-9.892417785142e-01, -8.445226073350e-01, -6.998562347828e-01, -5.549258690959e-01, -4.094932058338e-01, -2.637541079901e-01, -1.175769165730e-01,  2.924387797151e-02,  1.766184747098e-01,  3.245459516544e-01,  4.733651367784e-01,  6.234660278874e-01,  7.750444879749e-01,  9.273405558033e-01,  1.079493102084e+00],
        [-9.948817780438e-01, -8.511387755440e-01, -7.074208919816e-01, -5.635774137323e-01, -4.194949675011e-01, -2.752667350723e-01, -1.308300797039e-01,  1.391276973768e-02,  1.589190904744e-01,  3.041884438708e-01,  4.498820272748e-01,  5.961853820729e-01,  7.431916900494e-01,  8.905393997809e-01,  1.037818829161e+00]],
       [[-9.832079622121e-01, -8.374444607169e-01, -6.917633702912e-01, -5.456702245179e-01, -3.987930644098e-01, -2.514376039542e-01, -1.033983423844e-01,  4.564549118178e-02,  1.955537303914e-01,  3.463249361543e-01,  4.984879702474e-01,  6.526515632025e-01,  8.091214290070e-01,  9.667113773751e-01,  1.124077309230e+00],
        [-9.876529133912e-01, -8.426587421237e-01, -6.977251672309e-01, -5.524886104649e-01, -4.066755725702e-01, -2.605108432436e-01, -1.138433189802e-01,  3.356286116307e-02,  1.816046336911e-01,  3.302809404496e-01,  4.799806503920e-01,  6.311513594976e-01,  7.840178574631e-01,  9.377079455489e-01,  1.091233315611e+00],
        [-9.943203401600e-01, -8.504801642341e-01, -7.066678626405e-01, -5.627161893853e-01, -4.184993348109e-01, -2.741207021778e-01, -1.295107838737e-01,  1.543891613501e-02,  1.606809886408e-01,  3.062149468925e-01,  4.522196706089e-01,  5.989010539403e-01,  7.463625001473e-01,  8.942027978096e-01,  1.041967325181e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.333895748655e+00,  1.404163530009e+00,  1.474431311364e+00],
        [ 1.207375151939e+00,  1.273792515285e+00,  1.340209878632e+00],
        [ 1.100426184387e+00,  1.162993129726e+00,  1.225560075064e+00]],
       [[ 1.217551015184e+00,  1.283516265675e+00,  1.349481516166e+00],
        [ 1.139898577929e+00,  1.203626859486e+00,  1.267355141043e+00],
        [ 1.075531108547e+00,  1.137022421170e+00,  1.198513733793e+00]],
       [[ 1.080751651089e+00,  1.142107466231e+00,  1.203463281372e+00],
        [ 1.062860530444e+00,  1.123707914908e+00,  1.184555299371e+00],
        [ 1.048100511583e+00,  1.108439465368e+00,  1.168778419154e+00]],
       [[ 9.322683897113e-01,  9.890918655341e-01,  1.045915341357e+00],
        [ 9.816532004079e-01,  1.039667872797e+00,  1.097682545186e+00],
        [ 1.020255462899e+00,  1.079461331854e+00,  1.138667200810e+00]],
       [[ 8.881122453726e-01,  9.441303683974e-01,  1.000148491422e+00],
        [ 9.602812151302e-01,  1.017792542021e+00,  1.075303868911e+00],
        [ 1.014196910761e+00,  1.073201441517e+00,  1.132205972273e+00]],
       [[ 9.150418408820e-01,  9.722065751590e-01,  1.029371309436e+00],
        [ 9.766713591037e-01,  1.034899318027e+00,  1.093127276950e+00],
        [ 1.020576627062e+00,  1.079867810632e+00,  1.139158994201e+00]],
       [[ 1.000138245656e+00,  1.059562815315e+00,  1.118987384974e+00],
        [ 1.021482738081e+00,  1.081123094118e+00,  1.140763450155e+00],
        [ 1.035151629051e+00,  1.095007771465e+00,  1.154863913880e+00]],
       [[ 1.053843968801e+00,  1.113603217823e+00,  1.173362466846e+00],
        [ 1.044175129878e+00,  1.104024660517e+00,  1.163874191156e+00],
        [ 1.039879111702e+00,  1.099818923958e+00,  1.159758736213e+00]],
       [[ 1.072629239163e+00,  1.131494299809e+00,  1.190359360454e+00],
        [ 1.046934787168e+00,  1.106225450072e+00,  1.165516112975e+00],
        [ 1.037390519944e+00,  1.097106785105e+00,  1.156823050266e+00]],
       [[ 1.042548649383e+00,  1.099569390408e+00,  1.156590131433e+00],
        [ 1.025741445514e+00,  1.083879408654e+00,  1.142017371795e+00],
        [ 1.027955994065e+00,  1.087211179321e+00,  1.146466364578e+00]],
       [[ 1.027826298484e+00,  1.085232932414e+00,  1.142639566343e+00],
        [ 1.021966339626e+00,  1.080345485832e+00,  1.138724632037e+00],
        [ 1.028616497080e+00,  1.087968155562e+00,  1.147319814044e+00]],
       [[ 1.039793598236e+00,  1.099753508857e+00,  1.159713419478e+00],
        [ 1.039714112456e+00,  1.099689056595e+00,  1.159664000733e+00],
        [ 1.039822890406e+00,  1.099812868061e+00,  1.159802845717e+00]],
       [[ 1.104466198153e+00,  1.169518466661e+00,  1.234570735169e+00],
        [ 1.091050257085e+00,  1.154207924903e+00,  1.217365592720e+00],
        [ 1.064723656130e+00,  1.125986723257e+00,  1.187249790384e+00]],
       [[ 1.148369838828e+00,  1.216270682037e+00,  1.284171525245e+00],
        [ 1.122785120087e+00,  1.187723147093e+00,  1.252661174098e+00],
        [ 1.079135636363e+00,  1.141110847165e+00,  1.203086057967e+00]],
       [[ 1.169820911231e+00,  1.238436314233e+00,  1.307051717234e+00],
        [ 1.134823066861e+00,  1.200207693737e+00,  1.265592320613e+00],
        [ 1.083403225681e+00,  1.145557076431e+00,  1.207710927182e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.183729281437e+00, -1.126529798267e+00, -1.069143768817e+00],
        [-1.216794673604e+00, -1.163497549951e+00, -1.109753938480e+00],
        [-1.286037494847e+00, -1.240912371124e+00, -1.194796411422e+00],
        [-1.384066657505e+00, -1.350510881998e+00, -1.315193620305e+00],
        [-1.510104152352e+00, -1.491423253121e+00, -1.469990031727e+00],
        [-1.664149979386e+00, -1.663649484495e+00, -1.659185645686e+00],
        [-1.846982147837e+00, -1.868059405569e+00, -1.883735995588e+00],
        [-2.065991745363e+00, -2.112916396133e+00, -2.152718648768e+00],
        [-2.294337453619e+00, -2.368211340113e+00, -2.433167702794e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.173024906310e+00, -1.114562098636e+00, -1.055996896466e+00],
        [-1.192387043418e+00, -1.136209344586e+00, -1.079777037013e+00],
        [-1.236305949864e+00, -1.185311536375e+00, -1.133717248375e+00],
        [-1.299764651270e+00, -1.256259599048e+00, -1.211655795654e+00],
        [-1.382235045067e+00, -1.348463103660e+00, -1.312944075177e+00],
        [-1.483717131256e+00, -1.461922050214e+00, -1.437582086943e+00],
        [-1.604739012404e+00, -1.597226867650e+00, -1.586218434626e+00],
        [-1.750317662891e+00, -1.759986630926e+00, -1.765014853123e+00],
        [-1.902233544175e+00, -1.929831541515e+00, -1.951594515702e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.162916001416e+00, -1.103260146310e+00, -1.043581367239e+00],
        [-1.167325609354e+00, -1.108190173768e+00, -1.048997148356e+00],
        [-1.177522942564e+00, -1.119590990671e+00, -1.061521283247e+00],
        [-1.192325562548e+00, -1.136140607777e+00, -1.079701527594e+00],
        [-1.211609002097e+00, -1.157699868326e+00, -1.103385013573e+00],
        [-1.235373261210e+00, -1.184268772316e+00, -1.132571741184e+00],
        [-1.263742807099e+00, -1.215986476509e+00, -1.167414578251e+00],
        [-1.297900078259e+00, -1.254174970148e+00, -1.209365769092e+00],
        [-1.333550955940e+00, -1.294033344935e+00, -1.253151373811e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.154538270986e+00, -1.093893680712e+00, -1.033292027483e+00],
        [-1.143933022076e+00, -1.082036806120e+00, -1.020266899719e+00],
        [-1.113396633571e+00, -1.047896529729e+00, -9.827627953722e-01],
        [-1.067001058722e+00, -9.960253744859e-01, -9.257807956807e-01],
        [-1.005174924187e+00, -9.269025533333e-01, -8.498473302481e-01],
        [-9.279182299652e-01, -8.405280662712e-01, -7.549623990744e-01],
        [-8.348023493991e-01, -7.364227003575e-01, -6.405995725556e-01],
        [-7.217553292381e-01, -6.100339326441e-01, -5.017577694547e-01],
        [-6.035647891816e-01, -4.778946096274e-01, -3.565988111067e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.155036589865e+00, -1.094450810913e+00, -1.033904051503e+00],
        [-1.141365954236e+00, -1.079166774336e+00, -1.017114084836e+00],
        [-1.093954819818e+00, -1.026160203739e+00, -9.588847977640e-01],
        [-1.019696406795e+00, -9.431378533840e-01, -8.676822880034e-01],
        [-9.193163172892e-01, -8.309109605610e-01, -7.443977237352e-01],
        [-7.928145513021e-01, -6.894795252706e-01, -5.890311049594e-01],
        [-6.394655067089e-01, -5.180323102218e-01, -4.006912634952e-01],
        [-4.523759633269e-01, -3.088625611524e-01, -1.709121016253e-01],
        [-2.565791944511e-01, -8.995796459383e-02,  6.956107841374e-02]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.158344969531e+00, -1.098149643740e+00, -1.037967328868e+00],
        [-1.148235069943e+00, -1.086846579326e+00, -1.025550577980e+00],
        [-1.105362552516e+00, -1.038914270817e+00, -9.728955180353e-01],
        [-1.036420855302e+00, -9.618361121666e-01, -8.882228788422e-01],
        [-9.421145507296e-01, -8.563998290555e-01, -7.723980003800e-01],
        [-8.224436387976e-01, -7.226054214835e-01, -6.254208826488e-01],
        [-6.767035470808e-01, -5.596651637719e-01, -4.464261856697e-01],
        [-4.982008375233e-01, -3.600956619633e-01, -2.271931796333e-01],
        [-3.112432588464e-01, -1.510734520013e-01,  2.423906159152e-03]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.161285337994e+00, -1.101437032881e+00, -1.041578623164e+00],
        [-1.158909240116e+00, -1.098780509230e+00, -1.038660353286e+00],
        [-1.142345078234e+00, -1.080261454013e+00, -1.018316622870e+00],
        [-1.114491489081e+00, -1.049120599487e+00, -9.841074722407e-01],
        [-1.075653592312e+00, -1.005699075362e+00, -9.364076424857e-01],
        [-1.025831387928e+00, -9.499968816389e-01, -8.752171336045e-01],
        [-9.647197562719e-01, -8.816728886050e-01, -8.001612045098e-01],
        [-8.894200606122e-01, -7.974863640061e-01, -7.076798148772e-01],
        [-8.104589290822e-01, -7.092062828758e-01, -6.107015322039e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.157125394899e+00, -1.096786135576e+00, -1.036469474783e+00],
        [-1.156813747078e+00, -1.096437707249e+00, -1.036086715950e+00],
        [-1.166433558711e+00, -1.107192843795e+00, -1.047901551855e+00],
        [-1.183955821955e+00, -1.126783074973e+00, -1.069422000776e+00],
        [-1.209166957035e+00, -1.154969614440e+00, -1.100385748850e+00],
        [-1.242066963951e+00, -1.191752462196e+00, -1.140792796075e+00],
        [-1.282869422476e+00, -1.237370404583e+00, -1.190905456316e+00],
        [-1.333603340457e+00, -1.294091911844e+00, -1.253215711296e+00],
        [-1.386900215718e+00, -1.353678855203e+00, -1.318673732659e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.150097138125e+00, -1.088928407777e+00, -1.027837528166e+00],
        [-1.147898280452e+00, -1.086470042123e+00, -1.025136940714e+00],
        [-1.175552439060e+00, -1.117387929420e+00, -1.059101155241e+00],
        [-1.226960610622e+00, -1.174863265302e+00, -1.122239513278e+00],
        [-1.301480794790e+00, -1.258178280888e+00, -1.213763524459e+00],
        [-1.399112991562e+00, -1.367332976179e+00, -1.333673188785e+00],
        [-1.520499201290e+00, -1.503045120055e+00, -1.482756996621e+00],
        [-1.671738427298e+00, -1.672133516882e+00, -1.668505606436e+00],
        [-1.830681657508e+00, -1.849835140278e+00, -1.863716100632e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.143295858412e+00, -1.081324444748e+00, -1.019484349662e+00],
        [-1.135665523883e+00, -1.072793582307e+00, -1.010112944712e+00],
        [-1.163196191706e+00, -1.103573404505e+00, -1.043925490640e+00],
        [-1.218704431294e+00, -1.165632696200e+00, -1.112099459847e+00],
        [-1.301434092059e+00, -1.258126066326e+00, -1.213706165217e+00],
        [-1.411385174000e+00, -1.381053514882e+00, -1.348745606751e+00],
        [-1.549313827705e+00, -1.535260432937e+00, -1.518146471563e+00],
        [-1.722403483763e+00, -1.728778035630e+00, -1.730731287253e+00],
        [-1.904566946881e+00, -1.932440331133e+00, -1.954460348332e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.147068570109e+00, -1.085542409819e+00, -1.024117909166e+00],
        [-1.140104749258e+00, -1.077756722636e+00, -1.015565101298e+00],
        [-1.156265413436e+00, -1.095824659570e+00, -1.035413264926e+00],
        [-1.190826205487e+00, -1.134464297416e+00, -1.077860051034e+00],
        [-1.243289824657e+00, -1.193119644255e+00, -1.142294686042e+00],
        [-1.313656270947e+00, -1.271790700089e+00, -1.228717169950e+00],
        [-1.402422845112e+00, -1.371033456836e+00, -1.337738276340e+00],
        [-1.514313904292e+00, -1.496129837688e+00, -1.475160354214e+00],
        [-1.632172572534e+00, -1.627898121558e+00, -1.619911715073e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.159802136863e+00, -1.099778785163e+00, -1.039756988953e+00],
        [-1.159694079792e+00, -1.099657975256e+00, -1.039624275693e+00],
        [-1.159934021227e+00, -1.099926234448e+00, -1.039918966358e+00],
        [-1.160450864699e+00, -1.100504075505e+00, -1.040553741865e+00],
        [-1.161237126371e+00, -1.101383131349e+00, -1.041519410735e+00],
        [-1.162292806239e+00, -1.102563401979e+00, -1.042815972964e+00],
        [-1.163625388151e+00, -1.104053254479e+00, -1.044452620042e+00],
        [-1.165305968570e+00, -1.105932176078e+00, -1.046516671042e+00],
        [-1.167076355052e+00, -1.107911502606e+00, -1.048691019832e+00]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.180636439042e+00, -1.123071940303e+00, -1.065345209473e+00],
        [-1.195114200681e+00, -1.139258359459e+00, -1.083126470119e+00],
        [-1.185727087379e+00, -1.128763384175e+00, -1.071597429062e+00],
        [-1.157350718748e+00, -1.097038052022e+00, -1.036746212457e+00],
        [-1.110498317905e+00, -1.044656156431e+00, -9.792031493728e-01],
        [-1.045169884851e+00, -9.716176974026e-01, -8.989682398099e-01],
        [-9.608521964743e-01, -8.773488815131e-01, -7.954111547058e-01],
        [-8.526696331658e-01, -7.563986711879e-01, -6.625437679023e-01],
        [-7.383283924286e-01, -6.285629396952e-01, -5.221124322542e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.191426889989e+00, -1.135135874374e+00, -1.078597798205e+00],
        [-1.214236477617e+00, -1.160637437072e+00, -1.106612019808e+00],
        [-1.203654018601e+00, -1.148806042024e+00, -1.093614882077e+00],
        [-1.166501543975e+00, -1.107268852642e+00, -1.047985049823e+00],
        [-1.103497162269e+00, -1.036828728232e+00, -9.706044877631e-01],
        [-1.014640873482e+00, -9.374856687920e-01, -8.614731958950e-01],
        [-8.992145690876e-01, -8.084368150207e-01, -7.197092095076e-01],
        [-7.503962180404e-01, -6.420550034947e-01, -5.369338637755e-01],
        [-5.929605646504e-01, -4.660388803098e-01, -3.435749414588e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.192966672302e+00, -1.136857380954e+00, -1.080488924149e+00],
        [-1.218099679898e+00, -1.164956572375e+00, -1.111356717807e+00],
        [-1.212877236761e+00, -1.159117779352e+00, -1.104942630814e+00],
        [-1.183500994116e+00, -1.126274568601e+00, -1.068863391472e+00],
        [-1.130623757355e+00, -1.067156789249e+00, -1.003920760659e+00],
        [-1.054245526478e+00, -9.817644412952e-01, -9.101147383727e-01],
        [-9.537134961101e-01, -8.693676756287e-01, -7.866435637538e-01],
        [-8.228260149769e-01, -7.230329254888e-01, -6.258905084535e-01],
        [-6.841048691595e-01, -5.679399858372e-01, -4.555163226855e-01]]
                ], dtype=np.float64),

                None,  # z mid (interpolation area)

                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.054972575733e-01,  8.553492367484e-01,  9.057083012865e-01],
        [ 4.787311410772e-01,  5.144424354961e-01,  5.513674096366e-01],
        [-2.055555499383e-01, -1.994565130087e-01, -1.906641046420e-01],
        [-1.174320977668e+00, -1.210144912016e+00, -1.241180630475e+00],
        [-2.419876527606e+00, -2.509601425024e+00, -2.591844735117e+00],
        [-3.942222199753e+00, -4.097826052035e+00, -4.242656418568e+00],
        [-5.749046608614e+00, -5.982840129548e+00, -6.201953113573e+00],
        [-7.913391591995e+00, -8.240846354313e+00, -8.548940431207e+00],
        [-1.016999994944e+01, -1.059510861708e+01, -1.099597694178e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 9.112823960701e-01,  9.657121886103e-01,  1.020420318249e+00],
        [ 7.199376112333e-01,  7.660870278546e-01,  8.129285427899e-01],
        [ 2.859125003818e-01,  3.132796383061e-01,  3.422774042122e-01],
        [-3.412130849328e-01, -3.409845784540e-01, -3.377693566321e-01],
        [-1.156220212968e+00, -1.191260843312e+00, -1.221552398600e+00],
        [-2.159108883725e+00, -2.237549156267e+00, -2.309071721693e+00],
        [-3.355098028945e+00, -3.485294296434e+00, -3.605986667052e+00],
        [-4.793767500179e+00, -4.986221665394e+00, -5.166060975530e+00],
        [-6.295064152321e+00, -6.552486383720e+00, -6.794047377715e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.011182847198e+00,  1.069935795399e+00,  1.128751057398e+00],
        [ 9.676052463661e-01,  1.024472389753e+00,  1.081496078515e+00],
        [ 8.668309094220e-01,  9.193370800567e-01,  9.722177090465e-01],
        [ 7.205451910549e-01,  7.667209004719e-01,  8.135873943810e-01],
        [ 5.299781286007e-01,  5.679071177520e-01,  6.069389708749e-01],
        [ 2.951297220594e-01,  3.228957318969e-01,  3.522724385284e-01],
        [ 1.476993409501e-02,  3.040347615279e-02,  4.825396098456e-02],
        [-3.227865899819e-01, -3.217606836409e-01, -3.177879071449e-01],
        [-6.751035620878e-01, -6.893240444795e-01, -6.998358115545e-01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.093975103950e+00,  1.156310856928e+00,  1.218529894916e+00],
        [ 1.198780635463e+00,  1.265651809670e+00,  1.332179638911e+00],
        [ 1.500554073782e+00,  1.580484383694e+00,  1.659418798090e+00],
        [ 1.959054663754e+00,  2.058826419814e+00,  2.156610825265e+00],
        [ 2.570046536415e+00,  2.696258743377e+00,  2.819162399678e+00],
        [ 3.333529691765e+00,  3.492781354385e+00,  3.647073521330e+00],
        [ 4.253739998767e+00,  4.452813427487e+00,  4.644937510978e+00],
        [ 5.370918212575e+00,  5.618337121871e+00,  5.856390915809e+00],
        [ 6.538926853947e+00,  6.836890912070e+00,  7.122964169720e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.089050507135e+00,  1.151173149978e+00,  1.213189726709e+00],
        [ 1.224149479862e+00,  1.292118481577e+00,  1.359689281100e+00],
        [ 1.692686256752e+00,  1.780931016951e+00,  1.867764417759e+00],
        [ 2.426539135882e+00,  2.546541112319e+00,  2.663544856437e+00],
        [ 3.418537411783e+00,  3.581467752546e+00,  3.739254778161e+00],
        [ 4.668681084457e+00,  4.885710937632e+00,  5.094894182931e+00],
        [ 6.184140859370e+00,  6.466751682712e+00,  6.738238889721e+00],
        [ 8.033038438447e+00,  8.395659631568e+00,  8.743159178778e+00],
        [ 9.967984483115e+00,  1.041433976204e+01,  1.084138929552e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.056355707386e+00,  1.117063494671e+00,  1.177735914608e+00],
        [ 1.156265988505e+00,  1.221297356839e+00,  1.286077313269e+00],
        [ 1.579950242834e+00,  1.663316393063e+00,  1.745514962640e+00],
        [ 2.261261099502e+00,  2.374110729073e+00,  2.484319521177e+00],
        [ 3.193235677366e+00,  3.346416167577e+00,  3.494940531875e+00],
        [ 4.375873976425e+00,  4.580232708575e+00,  4.777377994735e+00],
        [ 5.816138877825e+00,  6.082824549360e+00,  6.339182366763e+00],
        [ 7.580177752434e+00,  7.923201564198e+00,  8.252082989497e+00],
        [ 9.427771200775e+00,  9.850748946536e+00,  1.025558909629e+01]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.027297749185e+00,  1.086748063905e+00,  1.146225845789e+00],
        [ 1.050779348077e+00,  1.111245820442e+00,  1.171688983699e+00],
        [ 1.214473364582e+00,  1.282023635930e+00,  1.349196628580e+00],
        [ 1.489734251016e+00,  1.569196337036e+00,  1.647685924169e+00],
        [ 1.873546686569e+00,  1.969618116039e+00,  2.063887096122e+00],
        [ 2.365910671242e+00,  2.483288972939e+00,  2.597800144439e+00],
        [ 2.969841525843e+00,  3.113354715456e+00,  3.252694843463e+00],
        [ 3.713984798059e+00,  3.889700516927e+00,  4.059634049462e+00],
        [ 4.494311919979e+00,  4.703796011028e+00,  4.905810547578e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.068408056994e+00,  1.129637405321e+00,  1.190805324473e+00],
        [ 1.071487891884e+00,  1.132850518944e+00,  1.194145057040e+00],
        [ 9.764208661212e-01,  1.033669502244e+00,  1.091055620973e+00],
        [ 8.032584888712e-01,  8.530135861455e-01,  9.032806098642e-01],
        [ 5.541114453092e-01,  5.930847949570e-01,  6.331088230389e-01],
        [ 2.289797354352e-01,  2.538831286786e-01,  2.805402604973e-01],
        [-1.742473259252e-01, -1.667934369970e-01, -1.567138770856e-01],
        [-6.756212479372e-01, -6.898641329952e-01, -7.003971832999e-01],
        [-1.202323392057e+00, -1.239359120695e+00, -1.271546081426e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.137864247331e+00,  1.202099287014e+00,  1.266122706453e+00],
        [ 1.159594283951e+00,  1.224769683060e+00,  1.289686473206e+00],
        [ 8.863042540696e-01,  9.396531266062e-01,  9.933343486169e-01],
        [ 3.782670744978e-01,  4.096308230020e-01,  4.424254932831e-01],
        [-3.581727372047e-01, -3.586781535050e-01, -3.561601811537e-01],
        [-1.323015181038e+00, -1.365273802915e+00, -1.402422674693e+00],
        [-2.522604774560e+00, -2.616775199474e+00, -2.703241898977e+00],
        [-4.017214434586e+00, -4.176063548535e+00, -4.323977014603e+00],
        [-5.587958305322e+00, -5.814780788563e+00, -6.027271069930e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.205077354857e+00,  1.272221017304e+00,  1.339007718849e+00],
        [ 1.280483530872e+00,  1.350890368140e+00,  1.420777187274e+00],
        [ 1.008413888875e+00,  1.067047011413e+00,  1.125748435304e+00],
        [ 4.598581121165e-01,  4.947526830764e-01,  5.309017445249e-01],
        [-3.577112011674e-01, -3.581966446636e-01, -3.556596975272e-01],
        [-1.444294050977e+00, -1.491800971808e+00, -1.533935890853e+00],
        [-2.807363035548e+00, -2.913856270561e+00, -3.012030022988e+00],
        [-4.517907838131e+00, -4.698424276878e+00, -4.866922375517e+00],
        [-6.318123819556e+00, -6.576543949663e+00, -6.819052978471e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.167793830628e+00,  1.233324062134e+00,  1.298577954096e+00],
        [ 1.236613238062e+00,  1.305121604377e+00,  1.373204817048e+00],
        [ 1.076906755620e+00,  1.138503882036e+00,  1.200021201814e+00],
        [ 7.353624683295e-01,  7.821793900274e-01,  8.296550555498e-01],
        [ 2.168949114569e-01,  2.412753383413e-01,  2.674356358507e-01],
        [-4.784959149973e-01, -4.842082730217e-01, -4.866370572825e-01],
        [-1.355724546291e+00, -1.399398654044e+00, -1.437892281436e+00],
        [-2.461479067476e+00, -2.553004299664e+00, -2.636957983790e+00],
        [-3.626208011848e+00, -3.768136465169e+00, -3.899974777284e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 1.041955366765e+00,  1.102039984550e+00,  1.162120374078e+00],
        [ 1.043023232202e+00,  1.103154061476e+00,  1.163278353355e+00],
        [ 1.040652029993e+00,  1.100680246354e+00,  1.160707052774e+00],
        [ 1.035544365355e+00,  1.095351549388e+00,  1.155168368221e+00],
        [ 1.027774196733e+00,  1.087245129546e+00,  1.146742499261e+00],
        [ 1.017341524124e+00,  1.076360986828e+00,  1.135429445894e+00],
        [ 1.004172389101e+00,  1.062621962276e+00,  1.121149008562e+00],
        [ 9.875641864120e-01,  1.045295045662e+00,  1.103139291363e+00],
        [ 9.700684824172e-01,  1.027042221446e+00,  1.084167179384e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 8.360620273238e-01,  8.872366857849e-01,  9.388523367899e-01],
        [ 6.929866958012e-01,  7.379698213667e-01,  7.837033235186e-01],
        [ 7.857540987509e-01,  8.347516999140e-01,  8.842990787634e-01],
        [ 1.066181311924e+00,  1.127314298668e+00,  1.188390671319e+00],
        [ 1.529196448558e+00,  1.610366246813e+00,  1.690478213692e+00],
        [ 2.174799508654e+00,  2.283907544351e+00,  2.390561705883e+00],
        [ 3.008062378969e+00,  3.153229562089e+00,  3.294141035377e+00],
        [ 4.077167983781e+00,  4.268600322820e+00,  4.453465133418e+00],
        [ 5.207136229719e+00,  5.447467533316e+00,  5.678787881362e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.294262513687e-01,  7.759862854383e-01,  8.232178997226e-01],
        [ 5.040123100871e-01,  5.408176378931e-01,  5.787819777839e-01],
        [ 6.085926222856e-01,  6.499236250372e-01,  6.921874969082e-01],
        [ 9.757490071452e-01,  1.032968568815e+00,  1.090327065910e+00],
        [ 1.598384814053e+00,  1.682548713642e+00,  1.765505169927e+00],
        [ 2.476500043011e+00,  2.598664059519e+00,  2.717721808961e+00],
        [ 3.617191344652e+00,  3.788718362055e+00,  3.954672497897e+00],
        [ 5.087876899757e+00,  5.323047299259e+00,  5.549464627872e+00],
        [ 6.643722262204e+00,  6.946221303480e+00,  7.236602936196e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.142094747423e-01,  7.601110083419e-01,  8.067170266956e-01],
        [ 4.658345198430e-01,  5.009877176720e-01,  5.373824826913e-01],
        [ 5.174449000816e-01,  5.548315183306e-01,  5.933481022246e-01],
        [ 8.077532889252e-01,  8.577028970360e-01,  9.081547121001e-01],
        [ 1.330308388844e+00,  1.402871378706e+00,  1.474806609876e+00],
        [ 2.085110199836e+00,  2.190336963338e+00,  2.293303795550e+00],
        [ 3.078610019438e+00,  3.226830126025e+00,  3.370641971577e+00],
        [ 4.372095174178e+00,  4.576290380036e+00,  4.773280311133e+00],
        [ 5.742995899246e+00,  6.006516335007e+00,  6.259867079962e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-2.334560393687e+00, -2.412443620652e+00, -2.481409323805e+00],
        [-2.392687527141e+00, -2.476584764814e+00, -2.551564478673e+00],
        [-2.448165928619e+00, -2.538077176999e+00, -2.619070901566e+00]],
       [[-1.928966046272e+00, -1.959229504674e+00, -1.983657939924e+00],
        [-1.967566528675e+00, -2.001828178672e+00, -2.030254805516e+00],
        [-2.004369086188e+00, -2.042628927779e+00, -2.075053746217e+00]],
       [[-1.339823015247e+00, -1.300930824445e+00, -1.260674273526e+00],
        [-1.348877980418e+00, -1.310923919922e+00, -1.271605499308e+00],
        [-1.357509197042e+00, -1.320493266852e+00, -1.282112976544e+00]],
       [[-5.828132108797e-01, -4.550725317533e-01, -3.317062336604e-01],
        [-5.529018927730e-01, -4.220554642884e-01, -2.955834168372e-01],
        [-5.244498338818e-01, -3.904976560389e-01, -2.609198592294e-01]],
       [[-2.222422091838e-01, -5.219377220433e-02,  1.107524779254e-01],
        [-1.727953246362e-01,  2.393923026629e-03,  1.704809838397e-01],
        [-1.258187521124e-01,  5.451130623365e-02,  2.277391777300e-01]],
       [[-2.784869789538e-01, -1.150468170446e-01,  4.172089617999e-02],
        [-2.313514894727e-01, -6.300579496736e-02,  9.866745085334e-02],
        [-1.866147164211e-01, -1.336348931964e-02,  1.532152890972e-01]],
       [[-7.966440535110e-01, -6.940115513688e-01, -5.941269447609e-01],
        [-7.767873899017e-01, -6.720851038556e-01, -5.701307133439e-01],
        [-7.579695059892e-01, -6.511974360392e-01, -5.471732616237e-01]],
       [[-1.396205032512e+00, -1.363913654568e+00, -1.329838514596e+00],
        [-1.409556314188e+00, -1.378659910101e+00, -1.345979743986e+00],
        [-1.422180463646e+00, -1.392679033416e+00, -1.361393841158e+00]],
       [[-1.858417522695e+00, -1.880343502634e+00, -1.896996960156e+00],
        [-1.898199912285e+00, -1.924284637975e+00, -1.945096841250e+00],
        [-1.935796612044e+00, -1.966040083487e+00, -1.991011032514e+00]],
       [[-1.936301707749e+00, -1.967348926194e+00, -1.992542777584e+00],
        [-1.981758587176e+00, -2.017566556908e+00, -2.047521159586e+00],
        [-2.024641152351e+00, -2.065209873371e+00, -2.099925227336e+00]],
       [[-1.652683719809e+00, -1.650461252529e+00, -1.644526829742e+00],
        [-1.682039557276e+00, -1.682895065541e+00, -1.680038618299e+00],
        [-1.709702334608e+00, -1.713635818419e+00, -1.713857346722e+00]],
       [[-1.167384422615e+00, -1.108250391064e+00, -1.049060729184e+00],
        [-1.167825291689e+00, -1.108737491479e+00, -1.049594060941e+00],
        [-1.168240682037e+00, -1.109199113169e+00, -1.050101913973e+00]],
       [[-7.185095869206e-01, -6.067589829662e-01, -4.983233243041e-01],
        [-6.902374351689e-01, -5.755091043831e-01, -4.640957188895e-01],
        [-6.637125512300e-01, -5.460064936126e-01, -4.316153812876e-01]],
       [[-5.657020524176e-01, -4.360491095431e-01, -3.108539121583e-01],
        [-5.268516174728e-01, -3.931017867976e-01, -2.638097016121e-01],
        [-4.904459826135e-01, -3.525992641376e-01, -2.192102911514e-01]],
       [[-6.601388902732e-01, -5.415710616367e-01, -4.267444531705e-01],
        [-6.260419849352e-01, -5.038697383271e-01, -3.854387118894e-01],
        [-5.941675551867e-01, -4.683908906070e-01, -3.463554461978e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-2.522432279344e+00, -2.643077056968e+00, -2.756250122464e+00, -2.906781748603e+00, -3.128395202089e+00, -3.393373248813e+00, -3.720347397610e+00, -4.138400000000e+00, -4.634823022382e+00, -5.209485991178e+00, -5.910337597939e+00, -6.792567750103e+00, -7.883893681780e+00, -9.076770709991e+00, -1.024933751889e+01],
        [-2.596596774684e+00, -2.730077911087e+00, -2.855723354797e+00, -3.020547261970e+00, -3.259915710677e+00, -3.544761236190e+00, -3.894622971590e+00, -4.340000000000e+00, -4.867565222583e+00, -5.477181809809e+00, -6.219134248757e+00, -7.151300994454e+00, -8.302749511629e+00, -9.560696134100e+00, -1.079734313551e+01],
        [-2.668112538048e+00, -2.813971591844e+00, -2.951643971690e+00, -3.130249721288e+00, -3.386739058244e+00, -3.690742509732e+00, -4.062674417928e+00, -4.534400000000e+00, -5.091995201349e+00, -5.735317063489e+00, -6.516902447760e+00, -7.497222337220e+00, -8.706646204697e+00, -1.002733850735e+01, -1.132577712296e+01]],
       [[-1.996701883895e+00, -2.026353472045e+00, -2.051113499726e+00, -2.100331329752e+00, -2.196084819978e+00, -2.320228125869e+00, -2.484958873691e+00, -2.709316619383e+00, -2.984981701570e+00, -3.311868702161e+00, -3.721368542016e+00, -4.249612801807e+00, -4.914747326067e+00, -5.646365050007e+00, -6.364686134011e+00],
        [-2.045964210549e+00, -2.084142100891e+00, -2.117186663739e+00, -2.175897864059e+00, -2.283444765273e+00, -2.420784658364e+00, -2.600718041388e+00, -2.843225506754e+00, -3.139576191021e+00, -3.489680454278e+00, -3.926480724234e+00, -4.487894397115e+00, -5.192964181940e+00, -5.967803121005e+00, -6.728688229221e+00],
        [-2.093428612313e+00, -2.139821620785e+00, -2.180848358497e+00, -2.248706450008e+00, -2.367616338628e+00, -2.517671183678e+00, -2.712252352019e+00, -2.972247127568e+00, -3.288528452439e+00, -3.661002618985e+00, -4.124106936488e+00, -4.717479439904e+00, -5.461026969910e+00, -6.277509681381e+00, -7.079405356559e+00]],
       [[-1.233078595069e+00, -1.130562594644e+00, -1.026902703492e+00, -9.289622659721e-01, -8.419041860304e-01, -7.614850604808e-01, -6.905573025061e-01, -6.335733095792e-01, -5.885875300604e-01, -5.555799889405e-01, -5.418914486390e-01, -5.559712742032e-01, -6.020628688192e-01, -6.637015503102e-01, -7.222308144260e-01],
        [-1.244635241056e+00, -1.144119459920e+00, -1.042403070965e+00, -9.466897211031e-01, -8.623983045536e-01, -7.850750191086e-01, -7.177137080522e-01, -6.649875303623e-01, -6.248544688632e-01, -5.972935581328e-01, -5.900095347792e-01, -6.118707054545e-01, -6.673308723665e-01, -7.391089913593e-01, -8.076235199358e-01],
        [-1.255768138495e+00, -1.157179234433e+00, -1.057335085111e+00, -9.637671620900e-01, -8.821409634448e-01, -8.078000026650e-01, -7.438743673067e-01, -6.952498831708e-01, -6.597916046565e-01, -6.374776122438e-01, -6.363632708563e-01, -6.657204673825e-01, -7.302056883328e-01, -8.117514611878e-01, -8.898851236617e-01]],
       [[-2.518922466170e-01,  2.044706265125e-02,  2.891148484957e-01,  5.761402514584e-01,  8.980945421519e-01,  1.241357753356e+00,  1.615085219208e+00,  2.033567711751e+00,  2.490560632395e+00,  2.985999867749e+00,  3.543446917658e+00,  4.190021541880e+00,  4.939343707636e+00,  5.738567050417e+00,  6.527810157793e+00],
        [-2.136989302216e-01,  6.525086173036e-02,  3.403416871326e-01,  6.347273452825e-01,  9.658251236647e-01,  1.319319711755e+00,  1.704833853058e+00,  2.137387909677e+00,  2.610418476098e+00,  3.123858165736e+00,  3.702471369081e+00,  4.374762397194e+00,  5.155046560599e+00,  5.987779517245e+00,  6.810022715243e+00],
        [-1.769648730417e-01,  1.083428336401e-01,  3.896112923210e-01,  6.910759910052e-01,  1.030967910124e+00,  1.394302962961e+00,  1.791153443993e+00,  2.237241429795e+00,  2.725696888648e+00,  3.256449285831e+00,  3.855419943410e+00,  4.552444823938e+00,  5.362508014132e+00,  6.227470276530e+00,  7.081452724487e+00]],
       [[ 2.154376519843e-01,  5.686622179897e-01,  9.159217237626e-01,  1.293006530698e+00,  1.726839693866e+00,  2.195293089474e+00,  2.713241229615e+00,  3.303902083014e+00,  3.957130158976e+00,  4.672821293593e+00,  5.489255445758e+00,  6.450493617344e+00,  7.578663932145e+00,  8.787907821122e+00,  9.980936995265e+00],
        [ 2.785933650207e-01,  6.427488945247e-01,  1.000629411548e+00,  1.389884990973e+00,  1.838837644647e+00,  2.324209442832e+00,  2.861647796519e+00,  3.475577110124e+00,  4.155324720133e+00,  4.900781050144e+00,  5.752215135245e+00,  6.755977443977e+00,  7.935345906077e+00,  9.200000630167e+00,  1.044759810186e+01],
        [ 3.392787660332e-01,  7.139376984989e-01,  1.082023789902e+00,  1.482974086616e+00,  1.946454837596e+00,  2.448083281389e+00,  3.004249496229e+00,  3.640537132949e+00,  4.345766975379e+00,  5.119824246332e+00,  6.004889255122e+00,  7.049512385327e+00,  8.278076398399e+00,  9.595974583573e+00,  1.089600593433e+01]],
       [[ 1.425257890605e-01,  4.831308013645e-01,  8.181285863970e-01,  1.181162507786e+00,  1.597540556188e+00,  2.046462033140e+00,  2.541909156193e+00,  3.105707090950e+00,  3.728318955991e+00,  4.409646836008e+00,  5.185674345767e+00,  6.097819348904e+00,  7.166882543886e+00,  8.312155858864e+00,  9.442187149844e+00],
        [ 2.027426987979e-01,  5.537700277965e-01,  8.988946001782e-01,  1.273532955643e+00,  1.704326944445e+00,  2.169379565706e+00,  2.683409970830e+00,  3.269393622455e+00,  3.917290997091e+00,  4.626999018796e+00,  5.436397821525e+00,  6.389088200608e+00,  7.506967156926e+00,  8.705072893485e+00,  9.887133273999e+00],
        [ 2.605608921058e-01,  6.215953689968e-01,  9.764433322182e-01,  1.362223863786e+00,  1.806859539788e+00,  2.287400727699e+00,  2.819274157312e+00,  3.426559766678e+00,  4.098735412784e+00,  4.835693064624e+00,  5.677133828262e+00,  6.668754474513e+00,  7.833504635909e+00,  9.082338235742e+00,  1.031435514789e+01]],
       [[-5.290638156526e-01, -3.046972416804e-01, -8.264190325438e-02,  1.509696129010e-01,  4.065689737710e-01,  6.755823671425e-01,  9.637731046568e-01,  1.280137272275e+00,  1.620743875539e+00,  1.985552554869e+00,  2.389395348540e+00,  2.849344230643e+00,  3.373973013389e+00,  3.930014744070e+00,  4.479773885160e+00],
        [-5.036877282997e-01, -2.749290721031e-01, -4.860619086398e-02,  1.898955651604e-01,  4.515699664877e-01,  7.273812066579e-01,  1.023403149579e+00,  1.349116629404e+00,  1.700378832616e+00,  2.077147224885e+00,  2.495053059140e+00,  2.972088221596e+00,  3.517288518710e+00,  4.095594429850e+00,  4.667279218182e+00],
        [-4.793504206436e-01, -2.463794737634e-01, -1.596374318409e-02,  2.272280688978e-01,  4.947288266122e-01,  7.770596411612e-01,  1.080592216146e+00,  1.415272290559e+00,  1.776753902720e+00,  2.164992432573e+00,  2.596385631547e+00,  3.089807641032e+00,  3.654737349823e+00,  4.254396048807e+00,  4.847108949750e+00]],
       [[-1.306130775710e+00, -1.216258615117e+00, -1.124884042192e+00, -1.041021530925e+00, -9.714521578387e-01, -9.106025398116e-01, -8.622191017750e-01, -8.321497247485e-01, -8.178390765615e-01, -8.192609215755e-01, -8.460567856201e-01, -9.093242586525e-01, -1.014636723799e+00, -1.140369089634e+00, -1.262017475339e+00],
        [-1.323201987671e+00, -1.236284505061e+00, -1.147780828935e+00, -1.067208120394e+00, -1.001725598912e+00, -9.454490847669e-01, -9.023339201864e-01, -8.785540900135e-01, -8.714117654044e-01, -8.808792477046e-01, -9.171357170542e-01, -9.918976143249e-01, -1.111049119244e+00, -1.251759229224e+00, -1.388157618200e+00],
        [-1.339546067415e+00, -1.255457411059e+00, -1.169702348581e+00, -1.092279316713e+00, -1.030709571235e+00, -9.788113739137e-01, -9.407400856364e-01, -9.229819049844e-01, -9.227025759523e-01, -9.398729991857e-01, -9.851871082554e-01, -1.070953835575e+00, -1.203354919383e+00, -1.358404810584e+00, -1.508924940314e+00]],
       [[-1.905170086051e+00, -1.918979390216e+00, -1.928346348799e+00, -1.959925035293e+00, -2.033765794556e+00, -2.133389199870e+00, -2.269872712401e+00, -2.460507396576e+00, -2.697737624456e+00, -2.981485822290e+00, -3.340260135790e+00, -3.806874013505e+00, -4.397806882155e+00, -5.049117487165e+00, -5.688352544903e+00],
        [-1.956042464313e+00, -1.978656737706e+00, -1.996578996766e+00, -2.037961327492e+00, -2.123980944426e+00, -2.237232243941e+00, -2.389415262791e+00, -2.598792857977e+00, -2.857384760081e+00, -3.165109035555e+00, -3.552076045201e+00, -4.052943419332e+00, -4.685116761574e+00, -5.381061190321e+00, -6.064251401767e+00],
        [-2.004729152745e+00, -2.035770097116e+00, -2.061880085214e+00, -2.112644854673e+00, -2.210320074688e+00, -2.336613757156e+00, -2.503821765966e+00, -2.731136998429e+00, -3.010172788020e+00, -3.340843028706e+00, -3.754791458529e+00, -4.288440655816e+00, -4.960082608670e+00, -5.698743205681e+00, -6.424000073861e+00]],
       [[-2.006086807925e+00, -2.037362734668e+00, -2.063701042110e+00, -2.114727446052e+00, -2.212727688993e+00, -2.339385065509e+00, -2.507012054457e+00, -2.734827487836e+00, -3.014433366514e+00, -3.345743468105e+00, -3.760444289723e+00, -4.295007626244e+00, -4.967750183091e+00, -5.707601944032e+00, -6.434031864154e+00],
        [-2.064239024119e+00, -2.105579911291e+00, -2.141697782809e+00, -2.203930732589e+00, -2.315852627877e+00, -2.458088050417e+00, -2.643661145223e+00, -2.892901600400e+00, -3.196926009139e+00, -3.555643165363e+00, -4.002571058279e+00, -4.576289566958e+00, -5.296174109657e+00, -6.087046795041e+00, -6.863721851888e+00],
        [-2.119816926061e+00, -2.170777212465e+00, -2.216241720945e+00, -2.289185119035e+00, -2.414412375317e+00, -2.571536226382e+00, -2.774260978973e+00, -3.043978001314e+00, -3.371339967210e+00, -3.756250907518e+00, -4.233979226035e+00, -4.845119564203e+00, -5.610059185428e+00, -6.449694172943e+00, -7.274390087201e+00]],
       [[-1.638508350379e+00, -1.606163956658e+00, -1.570685925637e+00, -1.550876081139e+00, -1.560877966817e+00, -1.589066970086e+00, -1.643257148850e+00, -1.735645646149e+00, -1.860902710583e+00, -2.018973621519e+00, -2.229968068138e+00, -2.517032706771e+00, -2.891792150003e+00, -3.309142139960e+00, -3.717974020564e+00],
        [-1.676072122633e+00, -1.650229250369e+00, -1.621068387321e+00, -1.608497478210e+00, -1.627492138580e+00, -1.665743873957e+00, -1.731526447258e+00, -1.837754565676e+00, -1.978784925816e+00, -2.154559587800e+00, -2.386371304094e+00, -2.698728460636e+00, -3.103939551905e+00, -3.554246813509e+00, -3.995534841038e+00],
        [-1.711942834753e+00, -1.692308449829e+00, -1.669180029750e+00, -1.663521785467e+00, -1.691103901591e+00, -1.738964825421e+00, -1.815817305236e+00, -1.935261270605e+00, -2.091353998433e+00, -2.284034474695e+00, -2.535725192558e+00, -2.872234892210e+00, -3.306525126354e+00, -3.788304221924e+00, -4.260585545200e+00]],
       [[-1.009570048860e+00, -8.683692859085e-01, -7.271215555970e-01, -5.861086621565e-01, -4.455425909273e-01, -3.052491106655e-01, -1.653453395088e-01, -2.601408987730e-02,  1.128245212569e-01,  2.511713140548e-01,  3.887248818001e-01,  5.251382993198e-01,  6.602373353025e-01,  7.946980184814e-01,  9.292863722154e-01],
        [-1.010134201512e+00, -8.690310818568e-01, -7.278782261245e-01, -5.869740508544e-01, -4.465430378843e-01, -3.064006850694e-01, -1.666710146414e-01, -2.754761577893e-02,  1.110541036361e-01,  2.491350121123e-01,  3.863759350620e-01,  5.224094961365e-01,  6.570511931206e-01,  7.910169065169e-01,  9.251178166247e-01],
        [-1.010672875438e+00, -8.696629892332e-01, -7.286007232765e-01, -5.878003561575e-01, -4.474983018346e-01, -3.075002511248e-01, -1.679368185456e-01, -2.901188332507e-02,  1.093636430692e-01,  2.471906753096e-01,  3.841330733846e-01,  5.198039334024e-01,  6.540089461073e-01,  7.875020439525e-01,  9.211375247631e-01]],
       [[-4.278745214696e-01, -1.859941482142e-01,  5.307837805631e-02,  3.061901392176e-01,  5.860142376429e-01,  8.821346199635e-01,  1.201552951270e+00,  1.555198291918e+00,  1.938295001044e+00,  2.350794047059e+00,  2.810714404283e+00,  3.338796274154e+00,  3.945455710036e+00,  4.590277743007e+00,  5.227467256585e+00],
        [-3.916617648340e-01, -1.435137033212e-01,  1.016487881664e-01,  3.617391297452e-01,  6.502325694514e-01,  9.560537684642e-01,  1.286647563176e+00,  1.653634770241e+00,  2.051937473986e+00,  2.481503539360e+00,  2.961492454007e+00,  3.513957173119e+00,  4.149973035510e+00,  4.826567001540e+00,  5.495045346866e+00],
        [-3.571962760111e-01, -1.030829425982e-01,  1.478756728972e-01,  4.146078779441e-01,  7.113523626627e-01,  1.026406313345e+00,  1.367636354641e+00,  1.747321682219e+00,  2.160096690374e+00,  2.605906290337e+00,  3.104995453236e+00,  3.680666547561e+00,  4.344622387013e+00,  5.051455288310e+00,  5.749712777261e+00]],
       [[-2.298669725071e-01,  4.628446166972e-02,  3.186562779827e-01,  6.099261837367e-01,  9.371533295161e-01,  1.286316758397e+00,  1.666841349564e+00,  2.093438614148e+00,  2.559680104376e+00,  3.065499819272e+00,  3.635152940192e+00,  4.296557668167e+00,  5.063734960179e+00,  5.882282585330e+00,  6.690556143847e+00],
        [-1.800915034271e-01,  1.046750474111e-01,  3.854176949871e-01,  6.862798589962e-01,  1.025423262165e+00,  1.387920740873e+00,  1.783806325922e+00,  2.228742367251e+00,  2.715884931720e+00,  3.245163752560e+00,  3.842401679286e+00,  4.537321330487e+00,  5.344849869841e+00,  6.207068925134e+00,  7.058349877232e+00],
        [-1.327608344325e-01,  1.601976881255e-01,  4.489000204829e-01,  7.588833039664e-01,  1.109357678889e+00,  1.484534284691e+00,  1.895026384361e+00,  2.357400464708e+00,  2.864417514437e+00,  3.416003210507e+00,  4.039471072118e+00,  4.766259508624e+00,  5.612157380639e+00,  6.515902875416e+00,  7.408078845632e+00]],
       [[-3.522718365100e-01, -9.730618323128e-02,  1.544805842192e-01,  4.221617807378e-01,  7.200851772537e-01,  1.036458306299e+00,  1.379208057735e+00,  1.760707696611e+00,  2.175550512011e+00,  2.623680993116e+00,  3.125499205277e+00,  3.704486033528e+00,  4.372433945372e+00,  5.083587394925e+00,  5.786099736916e+00],
        [-3.085631499145e-01, -4.603241606283e-02,  2.131049207937e-01,  4.892092425495e-01,  7.975965074978e-01,  1.125678492645e+00,  1.481916994260e+00,  1.879520225128e+00,  2.312716629563e+00,  2.781446950879e+00,  3.307487850522e+00,  3.915904703292e+00,  4.619285732219e+00,  5.368787807882e+00,  6.109065674179e+00],
        [-2.670769389086e-01,  2.634210402198e-03,  2.687483588981e-01,  5.528475113874e-01,  8.711665836617e-01,  1.210362059346e+00,  1.579403442486e+00,  1.992291438635e+00,  2.442908198766e+00,  2.931190910789e+00,  3.480222835839e+00,  4.116573271203e+00,  4.853585733295e+00,  5.639486504925e+00,  6.415609614632e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[-1.055818923275e+01, -1.100126651775e+01, -1.142010345982e+01],
        [-1.112416346674e+01, -1.159419367780e+01, -1.203998354592e+01],
        [-1.167056607156e+01, -1.216754920868e+01, -1.264029200286e+01]],
       [[-6.553076598643e+00, -6.822444597755e+00, -7.075951359462e+00],
        [-6.929024461566e+00, -7.216311112245e+00, -7.487736525521e+00],
        [-7.291687356615e+00, -7.596892658863e+00, -7.886236723707e+00]],
       [[-7.356401593466e-01, -7.526635806301e-01, -7.659782865969e-01],
        [-8.238358037482e-01, -8.450636333694e-01, -8.625827476739e-01],
        [-9.089003463659e-01, -9.343325843249e-01, -9.560561069671e-01]],
       [[ 6.739245087007e+00,  7.046488480434e+00,  7.341841073386e+00],
        [ 7.030736979760e+00,  7.351899376140e+00,  7.661170972047e+00],
        [ 7.311446324306e+00,  7.646527723641e+00,  7.969718322502e+00]],
       [[ 1.029947237983e+01,  1.076118733546e+01,  1.120359654563e+01],
        [ 1.078149316312e+01,  1.126624763381e+01,  1.173169635903e+01],
        [ 1.124526067229e+01,  1.175305465803e+01,  1.224154289830e+01]],
       [[ 9.744019898944e+00,  1.018165435925e+01,  1.060115122355e+01],
        [ 1.020362273765e+01,  1.066324226977e+01,  1.110472420589e+01],
        [ 1.064550132608e+01,  1.112710593003e+01,  1.159057293797e+01]],
       [[ 4.627702421869e+00,  4.843370598184e+00,  5.051569220001e+00],
        [ 4.821391840157e+00,  5.046336144372e+00,  5.263810894089e+00],
        [ 5.007405656992e+00,  5.241626089106e+00,  5.468376966723e+00]],
       [[-1.292180316196e+00, -1.333383937560e+00, -1.369738791016e+00],
        [-1.422488351783e+00, -1.469943812235e+00, -1.512550504780e+00],
        [-1.547423566622e+00, -1.601130866162e+00, -1.649989397795e+00]],
       [[-5.855813514942e+00, -6.095061468438e+00, -6.319977220061e+00],
        [-6.244137842061e+00, -6.502024000941e+00, -6.745577957948e+00],
        [-6.616311984411e+00, -6.892836348674e+00, -7.155028511064e+00]],
       [[-6.624634210285e+00, -6.897278478400e+00, -7.154011645217e+00],
        [-7.068548336027e+00, -7.362528811155e+00, -7.640598184985e+00],
        [-7.493440709349e+00, -7.808757391489e+00, -8.108162972332e+00]],
       [[-3.824329525386e+00, -3.975454331614e+00, -4.116488996636e+00],
        [-4.111086698767e+00, -4.276006034356e+00, -4.430835228738e+00],
        [-4.385333755836e+00, -4.564047620785e+00, -4.732671344527e+00]],
       [[ 9.670927679521e-01,  1.023928377315e+00,  1.080915205587e+00],
        [ 9.627860826955e-01,  1.019414497559e+00,  1.076194131333e+00],
        [ 9.586676611679e-01,  1.015088881533e+00,  1.071661320807e+00]],
       [[ 5.398625432420e+00,  5.647853566546e+00,  5.888070745122e+00],
        [ 5.675100353231e+00,  5.937673733153e+00,  6.191236157524e+00],
        [ 5.938664614156e+00,  6.214583239872e+00,  6.481490910038e+00]],
       [[ 6.907114499354e+00,  7.221854192149e+00,  7.524476476384e+00],
        [ 7.287148884258e+00,  7.620249554332e+00,  7.941232815846e+00],
        [ 7.649118504178e+00,  8.000580151531e+00,  8.339924390324e+00]],
       [[ 5.974609358150e+00,  6.248899047663e+00,  6.513019046370e+00],
        [ 6.308344549164e+00,  6.598788119305e+00,  6.879061998640e+00],
        [ 6.625657743369e+00,  6.932255194138e+00,  7.228682954100e+00]]
                ], dtype=np.float64)
            ]
        ],
        [  # x sup
            [  # y inf
                np.array([  # z inf
       [[-1.147431946918e+00, -1.085509590666e+00, -1.023587234415e+00],
        [-1.150292903832e+00, -1.089091431175e+00, -1.027889958518e+00],
        [-1.155376336336e+00, -1.094895747274e+00, -1.034415158211e+00]],
       [[-1.146078498970e+00, -1.084156142719e+00, -1.022233786468e+00],
        [-1.149446998865e+00, -1.088245526208e+00, -1.027044053551e+00],
        [-1.155037974350e+00, -1.094557385287e+00, -1.034076796224e+00]],
       [[-1.144725051023e+00, -1.082802694772e+00, -1.020880338520e+00],
        [-1.148601093898e+00, -1.087399621241e+00, -1.026198148584e+00],
        [-1.154699612363e+00, -1.094219023300e+00, -1.033738434237e+00]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-9.823056635806e-01, -8.363859926285e-01, -6.905531609991e-01, -5.442861327560e-01, -3.971929621726e-01, -2.495957903854e-01, -1.012780743076e-01,  4.809819315564e-02,  1.983853139917e-01,  3.495817717830e-01,  5.022448460161e-01,  6.570159765780e-01,  8.142173046053e-01,  9.725989013975e-01,  1.130744444437e+00],
        [-9.870889767465e-01, -8.419971995685e-01, -6.969687864233e-01, -5.516235531137e-01, -4.056755086720e-01, -2.593597097632e-01, -1.125181514321e-01,  3.509579989673e-02,  1.833743734414e-01,  3.323164627175e-01,  4.823286977474e-01,  6.338791178573e-01,  7.872027797121e-01,  9.413876480629e-01,  1.095400275114e+00],
        [-9.940947655021e-01, -8.502155472120e-01, -7.063653103175e-01, -5.623701664448e-01, -4.180993092516e-01, -2.736602487856e-01, -1.289807168545e-01,  1.605209162848e-02,  1.613888845409e-01,  3.070291557997e-01,  4.531588895511e-01,  5.999921572842e-01,  7.476364690469e-01,  8.956746788152e-01,  1.043634108982e+00]],
       [[-9.809522156333e-01, -8.347982904958e-01, -6.887378470609e-01, -5.422099951132e-01, -3.947928088169e-01, -2.468330700323e-01, -9.809767219227e-02,  5.177724611643e-02,  2.026326893923e-01,  3.544670252261e-01,  5.078801596693e-01,  6.635625966413e-01,  8.218611180029e-01,  9.814301874310e-01,  1.140745147246e+00],
        [-9.862430717795e-01, -8.410048857356e-01, -6.958342152120e-01, -5.503259670869e-01, -4.041754128246e-01, -2.576330095425e-01, -1.105304001101e-01,  3.739520799723e-02,  1.860289830667e-01,  3.353697461195e-01,  4.858507687806e-01,  6.379707553969e-01,  7.919801630856e-01,  9.469072018339e-01,  1.101650714370e+00],
        [-9.937564035153e-01, -8.498186216788e-01, -7.059114818329e-01, -5.618511320341e-01, -4.174992709126e-01, -2.729695686973e-01, -1.281856163257e-01,  1.697185486868e-02,  1.624507283910e-01,  3.082504691605e-01,  4.545677179643e-01,  6.016288123000e-01,  7.495474223963e-01,  8.978825003236e-01,  1.046134284685e+00]],
       [[-9.795987676861e-01, -8.332105883632e-01, -6.869225331227e-01, -5.401338574704e-01, -3.923926554611e-01, -2.440703496792e-01, -9.491727007697e-02,  5.545629907723e-02,  2.068800647928e-01,  3.593522786692e-01,  5.135154733224e-01,  6.701092167046e-01,  8.295049314004e-01,  9.902614734646e-01,  1.150745850055e+00],
        [-9.853971668125e-01, -8.400125719027e-01, -6.946996440006e-01, -5.490283810602e-01, -4.026753169773e-01, -2.559063093218e-01, -1.085426487880e-01,  3.969461609773e-02,  1.886835926921e-01,  3.384230295214e-01,  4.893728398139e-01,  6.420623929364e-01,  7.967575464590e-01,  9.524267556048e-01,  1.107901153626e+00],
        [-9.934180415285e-01, -8.494216961456e-01, -7.054576533484e-01, -5.613320976234e-01, -4.168992325737e-01, -2.722788886090e-01, -1.273905157969e-01,  1.789161810888e-02,  1.635125722412e-01,  3.094717825212e-01,  4.559765463776e-01,  6.032654673159e-01,  7.514583757457e-01,  9.000903218320e-01,  1.048634460387e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.176488046438e+00,  1.245103449439e+00,  1.313718852440e+00],
        [ 1.138990026365e+00,  1.204374653241e+00,  1.269759280117e+00],
        [ 1.085070009483e+00,  1.147223860233e+00,  1.209377710983e+00]],
       [[ 1.186488749247e+00,  1.255104152248e+00,  1.323719555249e+00],
        [ 1.145240465621e+00,  1.210625092497e+00,  1.276009719372e+00],
        [ 1.087570185185e+00,  1.149724035935e+00,  1.211877886686e+00]],
       [[ 1.196489452056e+00,  1.265104855057e+00,  1.333720258059e+00],
        [ 1.151490904877e+00,  1.216875531752e+00,  1.282260158628e+00],
        [ 1.090070360887e+00,  1.152224211638e+00,  1.214378062388e+00]]
                ], dtype=np.float64)
            ],
            [  # y mid
                np.array([  # z inf
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.194444323524e+00, -1.138429655293e+00, -1.082155821604e+00],
        [-1.220903111564e+00, -1.167952770597e+00, -1.114545682585e+00],
        [-1.216417949600e+00, -1.162963043443e+00, -1.109092446155e+00],
        [-1.187310719892e+00, -1.130511484656e+00, -1.073527497805e+00],
        [-1.134246883731e+00, -1.071340305902e+00, -1.008664667590e+00],
        [-1.057226441115e+00, -9.854495071805e-01, -9.145039555065e-01],
        [-9.555839307722e-01, -8.720968768425e-01, -7.902315315193e-01],
        [-8.229974703936e-01, -7.242314040158e-01, -6.281160100909e-01],
        [-6.824254745519e-01, -5.674593912226e-01, -4.562345280637e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.198590068192e+00, -1.142717334634e+00, -1.086585435619e+00],
        [-1.228262902593e+00, -1.175601711458e+00, -1.122483773280e+00],
        [-1.223381456051e+00, -1.170383376770e+00, -1.116969606358e+00],
        [-1.191005205320e+00, -1.134846755500e+00, -1.078503554067e+00],
        [-1.131877253215e+00, -1.069811260802e+00, -1.007976207906e+00],
        [-1.045997599735e+00, -9.752768926737e-01, -9.053875678723e-01],
        [-9.326231420840e-01, -8.504242379819e-01, -7.698470424863e-01],
        [-7.846944034579e-01, -6.874688717456e-01, -5.928940124862e-01],
        [-6.278484310623e-01, -5.146805477224e-01, -4.052538845531e-01]],
       [[-1.160000000000e+00, -1.100000000000e+00, -1.040000000000e+00],
        [-1.205050934260e+00, -1.149320135376e+00, -1.093330171034e+00],
        [-1.239408265856e+00, -1.187036224556e+00, -1.134207436211e+00],
        [-1.232327887132e+00, -1.179786634726e+00, -1.126829691191e+00],
        [-1.192275566862e+00, -1.136757902460e+00, -1.081055486444e+00],
        [-1.120142438603e+00, -1.058917031606e+00, -9.979225641260e-01],
        [-1.015928502354e+00, -9.462640221649e-01, -8.774309242361e-01],
        [-8.787426245785e-01, -7.978318703039e-01, -7.185428246359e-01],
        [-7.001190364493e-01, -6.044340394025e-01, -5.113997148086e-01],
        [-5.108018456790e-01, -3.994321623286e-01, -2.918036991486e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  3.958711892950e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571429e-01,  1.000000000000e+00],
        [-1.044495951668e+00, -9.093401488814e-01, -7.739659712312e-01, -6.396836679004e-01, -5.074788648939e-01, -3.765414738249e-01, -2.474160356413e-01, -1.209525368582e-01,  3.220438748586e-03,  1.251067045153e-01,  2.433048695946e-01,  3.562019049623e-01,  4.629877222317e-01,  5.668055173798e-01,  6.712169169522e-01],
        [-1.078687208886e+00, -9.494492141118e-01, -8.198250424410e-01, -6.921317552535e-01, -5.681123461573e-01, -4.463342445087e-01, -3.277604234710e-01, -2.138940100467e-01, -1.040781870442e-01,  1.693789088965e-03,  1.009436808908e-01,  1.908189872458e-01,  2.698871375107e-01,  3.437065995719e-01,  4.185757992737e-01],
        [-1.072947775113e+00, -9.427164016232e-01, -8.121270189249e-01, -6.833276822714e-01, -5.579342515662e-01, -4.346186476636e-01, -3.142736046020e-01, -1.982926115152e-01, -8.606675936348e-02,  2.241020353165e-02,  1.248408019949e-01,  2.185805959344e-01,  3.023015062051e-01,  3.811565668389e-01,  4.609847974005e-01],
        [-1.035435533453e+00, -8.987115574011e-01, -7.618136727235e-01, -6.257853311731e-01, -4.914114622092e-01, -3.580469304192e-01, -2.261253954566e-01, -9.632376666859e-02,  3.165374312449e-02,  1.578101707741e-01,  2.810294814412e-01,  4.000270966020e-01,  5.141578808426e-01,  6.259250018013e-01,  7.381648554157e-01],
        [-9.670092084462e-01, -8.184420336547e-01, -6.700367693147e-01, -5.208219527183e-01, -3.700668076748e-01, -2.183719608947e-01, -6.533367144810e-02,  8.967826918682e-02,  2.463884805594e-01,  4.047941353340e-01,  5.659342717065e-01,  7.310048435173e-01,  9.006064774787e-01,  1.072408702627e+00,  1.243770809539e+00],
        [-8.676688000906e-01, -7.019078303846e-01, -5.367963086997e-01, -3.684375469076e-01, -1.939002879626e-01, -1.559373908962e-02,  1.681015674244e-01,  3.597134960515e-01,  5.581374529419e-01,  7.633620972125e-01,  9.795551727912e-01,  1.211513836683e+00,  1.461647296115e+00,  1.720607669319e+00,  1.977802659768e+00],
        [-7.365555838630e-01, -5.481015953865e-01, -3.609405254133e-01, -1.673148629970e-01,  3.861092651408e-02,  2.520406031127e-01,  4.761981965717e-01,  7.161161692267e-01,  9.695955001322e-01,  1.236613611883e+00,  1.525467632213e+00,  1.845707721818e+00,  2.202130120700e+00,  2.576125103695e+00,  2.946605569889e+00],
        [-5.655116766149e-01, -3.474534826470e-01, -1.315276473815e-01,  9.505998128201e-02,  3.419337168518e-01,  6.011833128420e-01,  8.781260324176e-01,  1.181061714123e+00,  1.506363600797e+00,  1.853994456452e+00,  2.237638401462e+00,  2.673046133385e+00,  3.168127898710e+00,  3.692191423176e+00,  4.210458595819e+00],
        [-3.841630749415e-01, -1.347171434181e-01,  1.117064164002e-01,  3.732418346718e-01,  6.635304622423e-01,  9.713604400104e-01,  1.304268373227e+00,  1.674018322697e+00,  2.075469779775e+00,  2.508569966745e+00,  2.992714540961e+00,  3.550228293673e+00,  4.192323084014e+00,  4.875496164584e+00,  5.550453587085e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  7.593495650214e-15,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00],
        [-1.049020188799e+00, -9.146474390183e-01, -7.800341105639e-01, -6.466236754800e-01, -5.155019757599e-01, -3.857765552547e-01, -2.580473224747e-01, -1.332506884389e-01, -1.097747224992e-02,  1.087765271589e-01,  2.244674290223e-01,  3.343181955573e-01,  4.374363706149e-01,  5.372847424818e-01,  6.377870749868e-01],
        [-1.086818066137e+00, -9.589873566194e-01, -8.307305660165e-01, -7.046041808398e-01, -5.825313006180e-01, -4.629313252174e-01, -3.468667331394e-01, -2.359959715619e-01, -1.295943534719e-01, -2.765443849620e-02,  6.708945622603e-02,  1.514900767256e-01,  2.239668228691e-01,  2.906525266557e-01,  3.584964389136e-01],
        [-1.081129486567e+00, -9.523142001571e-01, -8.231007507708e-01, -6.958781162697e-01, -5.724433889453e-01, -4.513195343161e-01, -3.334994141114e-01, -2.205328090861e-01, -1.117425158891e-01, -7.121581663097e-03,  9.077483709688e-02,  1.790057039224e-01,  2.560939843323e-01,  3.277706688142e-01,  4.005296724821e-01],
        [-1.040838779993e+00, -9.050499955153e-01, -7.690607846462e-01, -6.340737057336e-01, -5.009933750868e-01, -3.690762863831e-01, -2.388222241452e-01, -1.110113135529e-01,  1.469733450641e-02,  1.383072199464e-01,  2.585321337895e-01,  3.738916236589e-01,  4.836421832302e-01,  5.906686657145e-01,  6.982399636156e-01],
        [-9.668811390396e-01, -8.182917980506e-01, -6.698649960453e-01, -5.206254991225e-01, -3.698396942371e-01, -2.181105397170e-01, -6.503272732053e-02,  9.002639792759e-02,  2.467903865569e-01,  4.052564002560e-01,  5.664675107403e-01,  7.316243145125e-01,  9.013297699025e-01,  1.073244359118e+00,  1.244717121569e+00],
        [-8.592565637047e-01, -6.920396077632e-01, -5.255133849690e-01, -3.555334964370e-01, -1.789823463956e-01,  1.577705682596e-03,  1.878690763635e-01,  3.825803253559e-01,  5.845366402629e-01,  7.937259592667e-01,  1.014580967950e+00,  1.252203776486e+00,  1.509156744350e+00,  1.775497749027e+00,  2.039961146340e+00],
        [-7.170298613818e-01, -5.251963693018e-01, -3.347516230273e-01, -1.373631478004e-01,  7.323710362960e-02,  2.918974081115e-01,  5.220807509844e-01,  7.691925858374e-01,  1.030870906782e+00,  1.307091463045e+00,  1.606766340975e+00,  1.940153530988e+00,  2.312404756238e+00,  2.703530993665e+00,  3.090882228678e+00],
        [-5.313167021205e-01, -3.073400567553e-01, -8.566359036985e-02,  1.475137707959e-01,  4.025737901934e-01,  6.709836714029e-01,  9.584791552977e-01,  1.274013291918e+00,  1.613673892107e+00,  1.977420789343e+00,  2.380015067689e+00,  2.838447031549e+00,  3.361249477348e+00,  3.915314596323e+00,  4.463127180667e+00],
        [-3.343812314237e-01, -7.631907995395e-02,  1.784763831277e-01,  4.496052880761e-01,  7.518116990810e-01,  1.072977434285e+00,  1.421248328574e+00,  1.809339403324e+00,  2.231694611315e+00,  2.688256908492e+00,  3.199989821131e+00,  3.791022789120e+00,  4.473473994341e+00,  5.200324097785e+00,  5.918294421558e+00]],
       [[-1.000000000000e+00, -8.571428571429e-01, -7.142857142857e-01, -5.714285714286e-01, -4.285714285714e-01, -2.857142857143e-01, -1.428571428571e-01,  1.432971526342e-14,  1.428571428571e-01,  2.857142857143e-01,  4.285714285714e-01,  5.714285714286e-01,  7.142857142857e-01,  8.571428571428e-01,  1.000000000000e+00],
        [-1.055859547330e+00, -9.226705507661e-01, -7.892074096885e-01, -6.571149911808e-01, -5.276306352797e-01, -3.997373692296e-01, -2.741188015322e-01, -1.518419924525e-01, -3.244067165825e-02,  8.408994805515e-02,  1.959905817320e-01,  3.012362570380e-01,  3.988100012173e-01,  4.926577351430e-01,  5.872506711194e-01],
        [-1.098734495623e+00, -9.729662765674e-01, -8.467134936078e-01, -7.228835301670e-01, -6.036634455802e-01, -4.872556905132e-01, -3.748685765953e-01, -2.683881852944e-01, -1.669903608800e-01, -7.066664173211e-02,  1.747334951400e-02,  9.385037472197e-02,  1.566668845579e-01,  2.128974881226e-01,  2.704452729412e-01],
        [-1.091294122650e+00, -9.642381270582e-01, -8.367340830291e-01, -7.114702811857e-01, -5.904689698006e-01, -4.720680581492e-01, -3.573848026611e-01, -2.481631546454e-01, -1.436410645885e-01, -4.381070851608e-02,  4.845262395369e-02,  1.298394166950e-01,  1.986875789837e-01,  2.614461316461e-01,  3.254226062341e-01],
        [-1.043817902648e+00, -9.085447434309e-01, -7.730565370429e-01, -6.386435665095e-01, -5.062764384303e-01, -3.751574089042e-01, -2.458227209228e-01, -1.191094085305e-01,  5.348284692265e-03,  1.275541139722e-01,  2.461280434765e-01,  3.594816242324e-01,  4.668171123372e-01,  5.712298063569e-01,  6.762270591930e-01],
        [-9.573878855373e-01, -8.071554563378e-01, -6.571321566066e-01, -5.060632095358e-01, -3.530047178371e-01, -1.987324729646e-01, -4.272498834855e-02,  1.158317364156e-01,  2.765820098538e-01,  4.395221800755e-01,  6.059943068630e-01,  7.775431279917e-01,  9.549444349173e-01,  1.135188106004e+00,  1.314863304259e+00],
        [-8.320040713170e-01, -6.600702657793e-01, -4.889609417209e-01, -3.137292102649e-01, -1.306538080203e-01,  5.720674967008e-02,  2.519083950627e-01,  4.566602801937e-01,  6.700601108967e-01,  8.920934897947e-01,  1.128051414114e+00,  1.384023927976e+00,  1.663069546725e+00,  1.953321030590e+00,  2.241331341429e+00],
        [-6.665844100831e-01, -4.660198411078e-01, -2.670915914393e-01, -5.998174531072e-02,  1.626951573842e-01,  3.948689891833e-01,  6.406200862775e-01,  9.063175394345e-01,  1.189178264928e+00,  1.489173688777e+00,  1.816804666441e+00,  2.184157893510e+00,  2.597303497463e+00,  3.032688986345e+00,  3.463626498262e+00],
        [-4.508494275533e-01, -2.129455411059e-01,  2.226325335234e-02,  2.709475076334e-01,  5.452714088785e-01,  8.352371823429e-01,  1.147565326488e+00,  1.492746022166e+00,  1.866195404476e+00,  2.267866410796e+00,  2.715054425449e+00,  3.227666783369e+00,  3.815701259306e+00,  4.440365832690e+00,  5.057704386586e+00],
        [-2.221298460122e-01,  5.536072669791e-02,  3.290337096432e-01,  6.217946413364e-01,  9.508740567732e-01,  1.302110137747e+00,  1.685022450322e+00,  2.114470304516e+00,  2.583960669314e+00,  3.093426880635e+00,  3.667367799053e+00,  4.333982105272e+00,  5.107431617513e+00,  5.932767553979e+00,  6.747726205571e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 7.011438446771e-01,  7.466213068927e-01,  7.928032538623e-01],
        [ 4.407455584326e-01,  4.750348364962e-01,  5.105656817501e-01],
        [ 4.843715148668e-01,  5.203932291039e-01,  5.575449089860e-01],
        [ 7.699092342930e-01,  8.179443084035e-01,  8.664815894674e-01],
        [ 1.290820560955e+00,  1.360872055836e+00,  1.430295792025e+00],
        [ 2.047105494850e+00,  2.149176471399e+00,  2.248987516657e+00],
        [ 3.045302191743e+00,  3.189673573661e+00,  3.329636694544e+00],
        [ 4.347523131315e+00,  4.547115538925e+00,  4.739502671773e+00],
        [ 5.728201939933e+00,  5.986349726868e+00,  6.234327822997e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.672899313276e-01,  7.121312864672e-01,  7.576771263608e-01],
        [ 3.798022783070e-01,  4.127956767224e-01,  4.470306423281e-01],
        [ 4.225514859366e-01,  4.565258441558e-01,  4.916301680202e-01],
        [ 7.280698084927e-01,  7.732330816027e-01,  8.188985616661e-01],
        [ 1.289255378004e+00,  1.355539630414e+00,  1.421196124131e+00],
        [ 2.106108194469e+00,  2.203445490586e+00,  2.298522855414e+00],
        [ 3.185730125863e+00,  3.324328420777e+00,  3.458518454657e+00],
        [ 4.595588917914e+00,  4.788277128150e+00,  4.973760063625e+00],
        [ 6.090670125581e+00,  6.340758939277e+00,  6.580678062167e+00]],
       [[ 1.040000000000e+00,  1.100000000000e+00,  1.160000000000e+00],
        [ 6.163294560762e-01,  6.605347041398e-01,  7.054444369574e-01],
        [ 2.908871925692e-01,  3.225847113365e-01,  3.555237972940e-01],
        [ 3.460795156767e-01,  3.780065178782e-01,  4.110634857248e-01],
        [ 7.041423700697e-01,  7.464338421793e-01,  7.892275212423e-01],
        [ 1.356890065713e+00,  1.419407075651e+00,  1.481296326897e+00],
        [ 2.304322602604e+00,  2.396926218291e+00,  2.487269902687e+00],
        [ 3.554625670777e+00,  3.687450878689e+00,  3.815867825565e+00],
        [ 5.185563325584e+00,  5.371347338448e+00,  5.549926076550e+00],
        [ 6.914729260768e+00,  7.156759101224e+00,  7.388619250875e+00]]
                ], dtype=np.float64)
            ],
            [  # y sup
                np.array([  # z inf
       [[-6.588499020395e-01, -5.414808733959e-01, -4.278530649227e-01],
        [-6.253386062623e-01, -5.043651596471e-01, -3.871329332024e-01],
        [-5.940497860747e-01, -4.694719214879e-01, -3.486352770717e-01]],
       [[-6.048584681108e-01, -4.892876394566e-01, -3.774580309728e-01],
        [-5.722255866749e-01, -4.530503400491e-01, -3.376163135938e-01],
        [-5.418151808285e-01, -4.190355162312e-01, -2.999970718044e-01]],
       [[-4.883974922884e-01, -3.746248636236e-01, -2.645934551293e-01],
        [-4.566430251937e-01, -3.392659785574e-01, -2.256301520915e-01],
        [-4.271110336885e-01, -3.061295690807e-01, -1.888893246433e-01]]
                ], dtype=np.float64),
                np.array([  # z mid
       [[-3.541796482575e-01, -9.954419821081e-02,  1.519217290644e-01,  4.192352701230e-01,  7.167019361203e-01,  1.032563992997e+00,  1.374724982838e+00,  1.755521726606e+00,  2.169563438255e+00,  2.616794770468e+00,  3.117555702456e+00,  3.695257958901e+00,  4.361659273895e+00,  5.071138869460e+00,  5.772002808890e+00],
        [-3.110565712229e-01, -4.895739765271e-02,  2.097606160024e-01,  4.853844291549e-01,  7.931747685371e-01,  1.120588806107e+00,  1.476057823674e+00,  1.872742403295e+00,  2.304891802352e+00,  2.772446977843e+00,  3.297106061426e+00,  3.903844038532e+00,  4.605203737238e+00,  5.352518163513e+00,  6.090641644255e+00],
        [-2.701559697778e-01, -9.777377980276e-04,  2.646186044704e-01,  5.481243952131e-01,  8.657063468736e-01,  1.204076999573e+00,  1.572168176211e+00,  1.983921764975e+00,  2.433245618098e+00,  2.920077187365e+00,  3.467402760468e+00,  4.101680016311e+00,  4.836196414810e+00,  5.619395741653e+00,  6.392858482811e+00]],
       [[-3.049834143006e-01, -4.183310135700e-02,  2.179062461555e-01,  4.947004207475e-01,  8.039446751316e-01,  1.132985614035e+00,  1.490328842495e+00,  1.889250955405e+00,  2.323950516339e+00,  2.794367961827e+00,  3.322392696352e+00,  3.933219864215e+00,  4.639502860717e+00,  5.392145683757e+00,  6.135516541466e+00],
        [-2.627387516072e-01,  7.723249285568e-03,  2.745669586388e-01,  5.595021256098e-01,  8.788597608073e-01,  1.219217367291e+00,  1.589597539796e+00,  2.004083854352e+00,  2.456522250251e+00,  2.946849543620e+00,  3.498285625909e+00,  4.137557058648e+00,  4.878086338806e+00,  5.667793299455e+00,  6.447664723985e+00],
        [-2.227165645034e-01,  5.467245922472e-02,  3.282467726522e-01,  6.208946374984e-01,  9.498335924028e-01,  1.300912500902e+00,  1.683643748799e+00,  2.112875438290e+00,  2.582119435812e+00,  3.091309127561e+00,  3.664924895539e+00,  4.331144151228e+00,  5.104118031122e+00,  5.928939199241e+00,  6.743390909695e+00]],
       [[-1.933176384500e-01,  8.915973868450e-02,  3.676781230345e-01,  6.659914712281e-01,  1.001968534997e+00,  1.360922944262e+00,  1.752726868554e+00,  2.192790004770e+00,  2.674378820882e+00,  3.197424183582e+00,  3.787332387998e+00,  4.473346590235e+00,  5.270153160386e+00,  6.120768021048e+00,  6.960621223581e+00],
        [-1.519513900978e-01,  1.376856394116e-01,  4.231606610631e-01,  7.294457219208e-01,  1.075325873931e+00,  1.445361637663e+00,  1.849931422321e+00,  2.305235125976e+00,  2.804193924609e+00,  3.346735139794e+00,  3.959567888143e+00,  4.673434899469e+00,  5.503775653219e+00,  6.390683958391e+00,  7.266278753255e+00],
        [-1.128076173353e-01,  1.836043994352e-01,  4.756623006218e-01,  7.894907796398e-01,  1.144741958786e+00,  1.525263711420e+00,  1.941913487790e+00,  2.411638932172e+00,  2.927034479986e+00,  3.488024098152e+00,  4.122549728361e+00,  4.862773106850e+00,  5.724846360279e+00,  6.646098179821e+00,  7.555514286119e+00]]
                ], dtype=np.float64),
                np.array([  # z sup
       [[ 5.956930664239e+00,  6.225847704926e+00,  6.484595054807e+00],
        [ 6.286338753357e+00,  6.571409674671e+00,  6.846310905180e+00],
        [ 6.599324845664e+00,  6.900549647606e+00,  7.191604758743e+00]],
       [[ 6.315071747990e+00,  6.575929815437e+00,  6.826618192079e+00],
        [ 6.637989184261e+00,  6.915001132336e+00,  7.181843389606e+00],
        [ 6.944484623723e+00,  7.237650452426e+00,  7.520646590323e+00]],
       [[ 7.134803781279e+00,  7.387602875487e+00,  7.630232278890e+00],
        [ 7.451230564705e+00,  7.720183539541e+00,  7.978966823571e+00],
        [ 7.751235351320e+00,  8.036342206784e+00,  8.311279371442e+00]]
                ], dtype=np.float64)
            ]
        ]
                               ]