"""empty message

Revision ID: 0d44655e35fd
Revises: 8b3f167d0418
Create Date: 2017-08-31 14:14:54.187073

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "0d44655e35fd"
down_revision = "8b3f167d0418"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "individual_importances",
        sa.Column("model_id", sa.Integer(), nullable=False),
        sa.Column("entity_id", sa.BigInteger(), nullable=False),
        sa.Column("as_of_date", sa.DateTime(), nullable=False),
        sa.Column("feature", sa.String(), nullable=False),
        sa.Column("method", sa.String(), nullable=False),
        sa.Column("importance_score", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(["model_id"], ["results.models.model_id"]),
        sa.PrimaryKeyConstraint(
            "model_id", "entity_id", "as_of_date", "feature", "method"
        ),
        schema="results",
    )
    op.create_table(
        "list_predictions",
        sa.Column("model_id", sa.Integer(), nullable=False),
        sa.Column("entity_id", sa.BigInteger(), nullable=False),
        sa.Column("as_of_date", sa.DateTime(), nullable=False),
        sa.Column("score", sa.Numeric(), nullable=True),
        sa.Column("rank_abs", sa.Integer(), nullable=True),
        sa.Column("rank_pct", sa.Float(), nullable=True),
        sa.Column("matrix_uuid", sa.Text(), nullable=True),
        sa.Column("test_label_window", sa.Interval(), nullable=True),
        sa.ForeignKeyConstraint(["model_id"], ["results.models.model_id"]),
        sa.PrimaryKeyConstraint("model_id", "entity_id", "as_of_date"),
        schema="results",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("list_predictions", schema="results")
    op.drop_table("individual_importances", schema="results")
    # ### end Alembic commands ###
