from enum import IntEnum


class UserEventType(IntEnum):
    UNDEFINED_EVENT = -1

    REPLACE_MESSAGE_FLAGS = 1
    INSTALL_MESSAGE_FLAGS = 2
    RESET_MESSAGE_FLAGS = 3

    NEW_MESSAGE = 4
    EDIT_MESSAGE = 5
    IN_READ = 6
    OUT_READ = 7
    FRIEND_ONLINE = 8
    FRIEND_OFFLINE = 9
    RESET_DIALOG_FLAGS = 10
    REPLACE_DIALOG_FLAGS = 11
    INSTALL_DIALOG_FLAGS = 12
    DELETE_MESSAGES = 13
    CHAT_RESTORE = 14

    MESSAGE_CHANGE = 18
    CLEAR_MESSAGE_CACHE = 19

    CHANGE_MAJOR_ID = 20
    CHANGE_MINOR_ID = 21

    TOPIC_PARAMS_CHANGE = 51
    CHAT_INFO_EDIT = 52
    DIALOG_TYPING_STATE = 61

    USER_TYPING_STATE = 62
    USERS_TYPING_STATE = 63
    VOICE_MESSAGE_STATES = 64
    PHOTO_UPLOAD_STATE = 65
    VIDEO_UPLOAD_STATE = 66
    FILE_UPLOAD_STATE = 67

    CALL = 70
    COUNTER = 80
    USER_INVISIBLE_CHANGE = 81
    NOTIFICATIONS_SETTINGS_CHANGED = 114
    CHAT_CALL = 115
    CALLBACK_BUTTON_REPLY = 119
