# coding: utf-8

"""
    Apteco API

    An API to allow access to Apteco Marketing Suite resources  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@apteco.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Variable(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'type': 'str',
        'folder_name': 'str',
        'table_name': 'str',
        'is_selectable': 'bool',
        'is_browsable': 'bool',
        'is_exportable': 'bool',
        'is_virtual': 'bool',
        'selector_info': 'SelectorVariableInfo',
        'numeric_info': 'NumericVariableInfo',
        'text_info': 'TextVariableInfo',
        'reference_info': 'object'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'type': 'type',
        'folder_name': 'folderName',
        'table_name': 'tableName',
        'is_selectable': 'isSelectable',
        'is_browsable': 'isBrowsable',
        'is_exportable': 'isExportable',
        'is_virtual': 'isVirtual',
        'selector_info': 'selectorInfo',
        'numeric_info': 'numericInfo',
        'text_info': 'textInfo',
        'reference_info': 'referenceInfo'
    }

    def __init__(self, name=None, description=None, type=None, folder_name=None, table_name=None, is_selectable=None, is_browsable=None, is_exportable=None, is_virtual=None, selector_info=None, numeric_info=None, text_info=None, reference_info=None):  # noqa: E501
        """Variable - a model defined in OpenAPI"""  # noqa: E501

        self._name = None
        self._description = None
        self._type = None
        self._folder_name = None
        self._table_name = None
        self._is_selectable = None
        self._is_browsable = None
        self._is_exportable = None
        self._is_virtual = None
        self._selector_info = None
        self._numeric_info = None
        self._text_info = None
        self._reference_info = None
        self.discriminator = None

        self.name = name
        self.description = description
        self.type = type
        if folder_name is not None:
            self.folder_name = folder_name
        self.table_name = table_name
        self.is_selectable = is_selectable
        self.is_browsable = is_browsable
        self.is_exportable = is_exportable
        self.is_virtual = is_virtual
        if selector_info is not None:
            self.selector_info = selector_info
        if numeric_info is not None:
            self.numeric_info = numeric_info
        if text_info is not None:
            self.text_info = text_info
        if reference_info is not None:
            self.reference_info = reference_info

    @property
    def name(self):
        """Gets the name of this Variable.  # noqa: E501

        The name of the variable  # noqa: E501

        :return: The name of this Variable.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Variable.

        The name of the variable  # noqa: E501

        :param name: The name of this Variable.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Variable.  # noqa: E501

        The description of the variable  # noqa: E501

        :return: The description of this Variable.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Variable.

        The description of the variable  # noqa: E501

        :param description: The description of this Variable.  # noqa: E501
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def type(self):
        """Gets the type of this Variable.  # noqa: E501

        The type of the variable  # noqa: E501

        :return: The type of this Variable.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Variable.

        The type of the variable  # noqa: E501

        :param type: The type of this Variable.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["Selector", "Reference", "Text", "Numeric"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def folder_name(self):
        """Gets the folder_name of this Variable.  # noqa: E501

        The name of the folder that this variable belongs to within the FastStats system  # noqa: E501

        :return: The folder_name of this Variable.  # noqa: E501
        :rtype: str
        """
        return self._folder_name

    @folder_name.setter
    def folder_name(self, folder_name):
        """Sets the folder_name of this Variable.

        The name of the folder that this variable belongs to within the FastStats system  # noqa: E501

        :param folder_name: The folder_name of this Variable.  # noqa: E501
        :type: str
        """

        self._folder_name = folder_name

    @property
    def table_name(self):
        """Gets the table_name of this Variable.  # noqa: E501

        The name of the table that this variable is from  # noqa: E501

        :return: The table_name of this Variable.  # noqa: E501
        :rtype: str
        """
        return self._table_name

    @table_name.setter
    def table_name(self, table_name):
        """Sets the table_name of this Variable.

        The name of the table that this variable is from  # noqa: E501

        :param table_name: The table_name of this Variable.  # noqa: E501
        :type: str
        """
        if table_name is None:
            raise ValueError("Invalid value for `table_name`, must not be `None`")  # noqa: E501

        self._table_name = table_name

    @property
    def is_selectable(self):
        """Gets the is_selectable of this Variable.  # noqa: E501

        Whether the variable is allowed to used in selections  # noqa: E501

        :return: The is_selectable of this Variable.  # noqa: E501
        :rtype: bool
        """
        return self._is_selectable

    @is_selectable.setter
    def is_selectable(self, is_selectable):
        """Sets the is_selectable of this Variable.

        Whether the variable is allowed to used in selections  # noqa: E501

        :param is_selectable: The is_selectable of this Variable.  # noqa: E501
        :type: bool
        """
        if is_selectable is None:
            raise ValueError("Invalid value for `is_selectable`, must not be `None`")  # noqa: E501

        self._is_selectable = is_selectable

    @property
    def is_browsable(self):
        """Gets the is_browsable of this Variable.  # noqa: E501

        Whether the variable is allowed to viewed with a client application (but not exported)  # noqa: E501

        :return: The is_browsable of this Variable.  # noqa: E501
        :rtype: bool
        """
        return self._is_browsable

    @is_browsable.setter
    def is_browsable(self, is_browsable):
        """Sets the is_browsable of this Variable.

        Whether the variable is allowed to viewed with a client application (but not exported)  # noqa: E501

        :param is_browsable: The is_browsable of this Variable.  # noqa: E501
        :type: bool
        """
        if is_browsable is None:
            raise ValueError("Invalid value for `is_browsable`, must not be `None`")  # noqa: E501

        self._is_browsable = is_browsable

    @property
    def is_exportable(self):
        """Gets the is_exportable of this Variable.  # noqa: E501

        Whether the variable is allowed to exported by a client application  # noqa: E501

        :return: The is_exportable of this Variable.  # noqa: E501
        :rtype: bool
        """
        return self._is_exportable

    @is_exportable.setter
    def is_exportable(self, is_exportable):
        """Sets the is_exportable of this Variable.

        Whether the variable is allowed to exported by a client application  # noqa: E501

        :param is_exportable: The is_exportable of this Variable.  # noqa: E501
        :type: bool
        """
        if is_exportable is None:
            raise ValueError("Invalid value for `is_exportable`, must not be `None`")  # noqa: E501

        self._is_exportable = is_exportable

    @property
    def is_virtual(self):
        """Gets the is_virtual of this Variable.  # noqa: E501

        Whether the variable is a virtual variable (i.e. created after the system has been built) or not  # noqa: E501

        :return: The is_virtual of this Variable.  # noqa: E501
        :rtype: bool
        """
        return self._is_virtual

    @is_virtual.setter
    def is_virtual(self, is_virtual):
        """Sets the is_virtual of this Variable.

        Whether the variable is a virtual variable (i.e. created after the system has been built) or not  # noqa: E501

        :param is_virtual: The is_virtual of this Variable.  # noqa: E501
        :type: bool
        """
        if is_virtual is None:
            raise ValueError("Invalid value for `is_virtual`, must not be `None`")  # noqa: E501

        self._is_virtual = is_virtual

    @property
    def selector_info(self):
        """Gets the selector_info of this Variable.  # noqa: E501


        :return: The selector_info of this Variable.  # noqa: E501
        :rtype: SelectorVariableInfo
        """
        return self._selector_info

    @selector_info.setter
    def selector_info(self, selector_info):
        """Sets the selector_info of this Variable.


        :param selector_info: The selector_info of this Variable.  # noqa: E501
        :type: SelectorVariableInfo
        """

        self._selector_info = selector_info

    @property
    def numeric_info(self):
        """Gets the numeric_info of this Variable.  # noqa: E501


        :return: The numeric_info of this Variable.  # noqa: E501
        :rtype: NumericVariableInfo
        """
        return self._numeric_info

    @numeric_info.setter
    def numeric_info(self, numeric_info):
        """Sets the numeric_info of this Variable.


        :param numeric_info: The numeric_info of this Variable.  # noqa: E501
        :type: NumericVariableInfo
        """

        self._numeric_info = numeric_info

    @property
    def text_info(self):
        """Gets the text_info of this Variable.  # noqa: E501


        :return: The text_info of this Variable.  # noqa: E501
        :rtype: TextVariableInfo
        """
        return self._text_info

    @text_info.setter
    def text_info(self, text_info):
        """Sets the text_info of this Variable.


        :param text_info: The text_info of this Variable.  # noqa: E501
        :type: TextVariableInfo
        """

        self._text_info = text_info

    @property
    def reference_info(self):
        """Gets the reference_info of this Variable.  # noqa: E501

        Details specific for reference (URN) variables in the FastStats system  # noqa: E501

        :return: The reference_info of this Variable.  # noqa: E501
        :rtype: object
        """
        return self._reference_info

    @reference_info.setter
    def reference_info(self, reference_info):
        """Sets the reference_info of this Variable.

        Details specific for reference (URN) variables in the FastStats system  # noqa: E501

        :param reference_info: The reference_info of this Variable.  # noqa: E501
        :type: object
        """

        self._reference_info = reference_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Variable):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
